/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ia extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arabe";
        final String metaValue_bn = "bengalese";
        final String metaValue_gu = "gujarati";
        final String metaValue_ja = "japonese";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongol";
        final String metaValue_si = "cingalese";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telugu";
        final Object[][] data = new Object[][] {
            { "001", "mundo" },
            { "002", "Africa" },
            { "003", "America del Nord" },
            { "005", "America del Sud" },
            { "009", "Oceania" },
            { "011", "Africa occidental" },
            { "013", "America central" },
            { "014", "Africa oriental" },
            { "015", "Africa septentrional" },
            { "017", "Africa central" },
            { "018", "Africa meridional" },
            { "019", "Americas" },
            { "021", "America septentrional" },
            { "029", "Caribes" },
            { "030", "Asia oriental" },
            { "034", "Asia meridional" },
            { "035", "Asia del sud-est" },
            { "039", "Europa meridional" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "057", "Region micronesian" },
            { "061", "Polynesia" },
            { "142", "Asia" },
            { "143", "Asia central" },
            { "145", "Asia occidental" },
            { "150", "Europa" },
            { "151", "Europa oriental" },
            { "154", "Europa septentrional" },
            { "155", "Europa occidental" },
            { "202", "Africa subsaharian" },
            { "419", "America latin" },
            { "AC", "Insula del Ascension" },
            { "AD", "Andorra" },
            { "AE", "Emiratos Arabe Unite" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua e Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antarctica" },
            { "AR", "Argentina" },
            { "AS", "Samoa american" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Insulas \u00c5land" },
            { "AZ", "Azerbaidzhan" },
            { "BA", "Bosnia e Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgica" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Sancte Bartholomeo" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Paises Basse caribe" },
            { "BR", "Brasil" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Insula de Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Bielorussia" },
            { "BZ", "Belize" },
            { "CA", "Canada" },
            { "CC", "Insulas Cocos (Keeling)" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Republica African Central" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Suissa" },
            { "CI", "Costa de Ebore" },
            { "CK", "Insulas Cook" },
            { "CL", "Chile" },
            { "CM", "Camerun" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Insula Clipperton" },
            { "CQ", "Sark" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Capo Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Insula de Natal" },
            { "CY", "Cypro" },
            { "CZ", "Chechia" },
            { "DE", "Germania" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibuti" },
            { "DK", "Danmark" },
            { "DM", "Dominica" },
            { "DO", "Republica Dominican" },
            { "DZ", "Algeria" },
            { "EA", "Ceuta e Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonia" },
            { "EG", "Egypto" },
            { "EH", "Sahara occidental" },
            { "ER", "Eritrea" },
            { "ES", "Espania" },
            { "ET", "Ethiopia" },
            { "EU", "Union Europee" },
            { "EZ", "Zona euro" },
            { "FI", "Finlandia" },
            { "FJ", "Fiji" },
            { "FK", "Insulas Falkland" },
            { "FM", "Micronesia" },
            { "FO", "Insulas Feroe" },
            { "FR", "Francia" },
            { "GA", "Gabon" },
            { "GB", "Regno Unite" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Guyana francese" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Groenlandia" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Guinea equatorial" },
            { "GR", "Grecia" },
            { "GS", "Georgia del Sud e Insulas Sandwich Austral" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hongkong, R.A.S. de China" },
            { "HM", "Insulas Heard e McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croatia" },
            { "HT", "Haiti" },
            { "HU", "Hungaria" },
            { "IC", "Insulas Canari" },
            { "ID", "Indonesia" },
            { "IE", "Irlanda" },
            { "IL", "Israel" },
            { "IM", "Insula de Man" },
            { "IN", "India" },
            { "IO", "Territorio oceanic britanno-indian" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islanda" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jordania" },
            { "JP", "Japon" },
            { "KE", "Kenya" },
            { "KG", "Kirghizistan" },
            { "KH", "Cambodgia" },
            { "KI", "Kiribati" },
            { "KM", "Comoros" },
            { "KN", "Sancte Christophoro e Nevis" },
            { "KP", "Corea del Nord" },
            { "KR", "Corea del Sud" },
            { "KW", "Kuwait" },
            { "KY", "Insulas de Caiman" },
            { "KZ", "Kazakhstan" },
            { "LA", "Laos" },
            { "LB", "Libano" },
            { "LC", "Sancte Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lituania" },
            { "LU", "Luxemburg" },
            { "LV", "Lettonia" },
            { "LY", "Libya" },
            { "MA", "Marocco" },
            { "MC", "Monaco" },
            { "MD", "Moldavia" },
            { "ME", "Montenegro" },
            { "MF", "Sancte Martino francese" },
            { "MG", "Madagascar" },
            { "MH", "Insulas Marshall" },
            { "MK", "Macedonia del Nord" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birmania)" },
            { "MN", "Mongolia" },
            { "MO", "Macao, R.A.S. de China" },
            { "MP", "Insulas Marianna del Nord" },
            { "MQ", "Martinica" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritio" },
            { "MV", "Maldivas" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "NC", "Nove Caledonia" },
            { "NE", "Niger" },
            { "NF", "Insula Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Nederlandia" },
            { "NO", "Norvegia" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nove Zelanda" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Polynesia francese" },
            { "PG", "Papua Nove Guinea" },
            { "PH", "Philippinas" },
            { "PK", "Pakistan" },
            { "PL", "Polonia" },
            { "PM", "St. Pierre e Miquelon" },
            { "PN", "Insulas Pitcairn" },
            { "PR", "Porto Rico" },
            { "PS", "Territorios palestin" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Oceania remote" },
            { "RE", "Reunion" },
            { "RO", "Romania" },
            { "RS", "Serbia" },
            { "RU", "Russia" },
            { "RW", "Ruanda" },
            { "SA", "Arabia Saudita" },
            { "SB", "Insulas Solomon" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "SE", "Svedia" },
            { "SG", "Singapur" },
            { "SH", "Sancte Helena" },
            { "SI", "Slovenia" },
            { "SJ", "Svalbard e Jan Mayen" },
            { "SK", "Slovachia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "SS", "Sudan del Sud" },
            { "ST", "S\u00e3o Tom\u00e9 e Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sancte Martino nederlandese" },
            { "SY", "Syria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Insulas Turcos e Caicos" },
            { "TD", "Tchad" },
            { "TF", "Territorios meridional francese" },
            { "TG", "Togo" },
            { "TH", "Thailandia" },
            { "TJ", "Tadzhikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor del Est" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Turchia" },
            { "TT", "Trinidad e Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Ukraina" },
            { "UG", "Uganda" },
            { "UM", "Insulas peripheric del SUA" },
            { "UN", "Nationes Unite" },
            { "US", "Statos Unite" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "VA", "Citate del Vaticano" },
            { "VC", "Sancte Vincente e le Grenadinas" },
            { "VE", "Venezuela" },
            { "VG", "Insulas Virgine britannic" },
            { "VI", "Insulas Virgine statounitese" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis e Futuna" },
            { "WS", "Samoa" },
            { "XA", "Pseudo-accentos" },
            { "XB", "Pseudo-bidi" },
            { "XK", "Kosovo" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "Africa del Sud" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Region incognite" },
            { "aa", "afar" },
            { "ab", "abkhazo" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amharico" },
            { "an", "aragonese" },
            { "ar", metaValue_ar },
            { "as", "assamese" },
            { "av", "avaro" },
            { "ay", "aymara" },
            { "az", "azerbaidzhano" },
            { "ba", "bashkir" },
            { "be", "bielorusso" },
            { "bg", "bulgaro" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", "tibetano" },
            { "br", "breton" },
            { "bs", "bosniaco" },
            { "ca", "catalano" },
            { "ce", "checheno" },
            { "ch", "chamorro" },
            { "co", "corso" },
            { "cs", "checo" },
            { "cu", "slavo ecclesiastic" },
            { "cv", "chuvash" },
            { "cy", "gallese" },
            { "da", "danese" },
            { "de", "germano" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", "greco" },
            { "en", "anglese" },
            { "eo", "esperanto" },
            { "es", "espaniol" },
            { "et", "estoniano" },
            { "eu", "basco" },
            { "fa", "persa" },
            { "ff", "fula" },
            { "fi", "finnese" },
            { "fj", "fijiano" },
            { "fo", "feroese" },
            { "fr", "francese" },
            { "fy", "frison occidental" },
            { "ga", "irlandese" },
            { "gd", "gaelico scotese" },
            { "gl", "galleco" },
            { "gn", "guarani" },
            { "gu", metaValue_gu },
            { "gv", "mannese" },
            { "ha", "hausa" },
            { "he", "hebreo" },
            { "hi", "hindi" },
            { "hr", "croato" },
            { "ht", "creolo haitian" },
            { "hu", "hungaro" },
            { "hy", "armenio" },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonesiano" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "yi de Sichuan" },
            { "io", "ido" },
            { "is", "islandese" },
            { "it", "italiano" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", "javanese" },
            { "ka", "georgiano" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kazakh" },
            { "kl", "groenlandese" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", "coreano" },
            { "kr", "kanuri" },
            { "ks", "kashmiri" },
            { "ku", "kurdo" },
            { "kv", "komi" },
            { "kw", "cornico" },
            { "ky", "kirghizo" },
            { "la", "latino" },
            { "lb", "luxemburgese" },
            { "lg", "luganda" },
            { "li", "limburgese" },
            { "ln", "lingala" },
            { "lo", "laotiano" },
            { "lt", "lithuano" },
            { "lu", "luba-katanga" },
            { "lv", "letton" },
            { "mg", "malgache" },
            { "mh", "marshallese" },
            { "mi", "maori" },
            { "mk", "macedone" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malay" },
            { "mt", "maltese" },
            { "my", "birmano" },
            { "na", "nauru" },
            { "nb", "norvegiano bokm\u00e5l" },
            { "nd", "ndebele del nord" },
            { "ne", "nepalese" },
            { "ng", "ndonga" },
            { "nl", "nederlandese" },
            { "nn", "norvegiano nynorsk" },
            { "no", "norvegiano" },
            { "nr", "ndebele del sud" },
            { "nv", "navajo" },
            { "ny", "nyanja" },
            { "oc", "occitano" },
            { "om", "oromo" },
            { "or", "oriya" },
            { "os", "osseto" },
            { "pa", "punjabi" },
            { "pl", "polonese" },
            { "ps", "pashto" },
            { "pt", "portugese" },
            { "qu", "quechua" },
            { "rm", "romanche" },
            { "rn", "rundi" },
            { "ro", "romaniano" },
            { "ru", "russo" },
            { "rw", "kinyarwanda" },
            { "sa", "sanscrito" },
            { "sc", "sardo" },
            { "sd", "sindhi" },
            { "se", "sami del nord" },
            { "sg", "sango" },
            { "sh", "serbocroato" },
            { "si", metaValue_si },
            { "sk", "slovaco" },
            { "sl", "sloveno" },
            { "sm", "samoano" },
            { "sn", "shona" },
            { "so", "somali" },
            { "sq", "albanese" },
            { "sr", "serbo" },
            { "ss", "swati" },
            { "st", "sotho del sud" },
            { "su", "sundanese" },
            { "sv", "svedese" },
            { "sw", "swahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tajiko" },
            { "th", "thai" },
            { "ti", "tigrinya" },
            { "tk", "turkmeno" },
            { "tn", "tswana" },
            { "to", "tongano" },
            { "tr", "turco" },
            { "ts", "tsonga" },
            { "tt", "tataro" },
            { "tw", "twi" },
            { "ty", "tahitiano" },
            { "ug", "uighur" },
            { "uk", "ukrainiano" },
            { "ur", "urdu" },
            { "uz", "uzbeko" },
            { "ve", "venda" },
            { "vi", "vietnamese" },
            { "vo", "volap\u00fck" },
            { "wa", "wallon" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "yiddish" },
            { "yo", "yoruba" },
            { "za", "zhuang" },
            { "zh", "chinese" },
            { "zu", "zulu" },
            { "ace", "acehnese" },
            { "ada", "adangme" },
            { "ady", "adygeano" },
            { "agq", "aghem" },
            { "ain", "ainu" },
            { "ale", "aleuto" },
            { "alt", "altai del sud" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "apc", "arabe levantin" },
            { "arn", "mapuche" },
            { "arp", "arapaho" },
            { "ars", "arabe najdi" },
            { "asa", "asu" },
            { "ast", "asturiano" },
            { "atj", "atikamekw" },
            { "awa", "awadhi" },
            { "bal", "baluchi" },
            { "ban", "balinese" },
            { "bas", "basaa" },
            { "bem", "bemba" },
            { "bew", "betawi" },
            { "bez", "bena" },
            { "bgc", "haryanvi" },
            { "bgn", "baluchi occidental" },
            { "bho", "bhojpuri" },
            { "bin", "bini" },
            { "bla", "siksika" },
            { "blo", "anii" },
            { "blt", "tai dam" },
            { "brx", "bodo" },
            { "bss", "akoose" },
            { "bug", "buginese" },
            { "byn", "blin" },
            { "cad", "caddo" },
            { "cay", "cayuga" },
            { "cch", "atsam" },
            { "ccp", "chakma" },
            { "ceb", "cebuano" },
            { "cgg", "chiga" },
            { "chk", "chuukese" },
            { "chm", "mari" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", "cherokee" },
            { "chy", "cheyenne" },
            { "cic", "chickasaw" },
            { "ckb", "kurdo central" },
            { "clc", "chilcotin" },
            { "crg", "mitchif" },
            { "crj", "cree del sud-est" },
            { "crk", "cree del planas" },
            { "crl", "cree del nord-est" },
            { "crm", "cree moose" },
            { "crr", "algonquino de Carolina" },
            { "crs", "creolo seychellese" },
            { "csw", "cree del paludes" },
            { "dak", "dakota" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "dgr", "dogrib" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "basse sorabo" },
            { "dua", "duala" },
            { "dyo", "jola-fonyi" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "eka", "ekajuk" },
            { "ewo", "ewondo" },
            { "fil", "filipino" },
            { "fon", "fon" },
            { "frc", "francese cajun" },
            { "frr", "frison septentrional" },
            { "fur", "friulano" },
            { "gaa", "ga" },
            { "gez", "ge\u2019ez" },
            { "gil", "gilbertese" },
            { "gor", "gorontalo" },
            { "gsw", "germano suisse" },
            { "guz", "gusii" },
            { "gwi", "gwich\u2019in" },
            { "hai", "haida" },
            { "haw", "hawaiano" },
            { "hax", "haida del sud" },
            { "hil", "hiligaynon" },
            { "hmn", "hmong" },
            { "hsb", "alte sorabo" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "inuktitut del west canadian" },
            { "ilo", "ilocano" },
            { "inh", "ingush" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "kaa", "kara-kalpak" },
            { "kab", "kabylo" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kbd", "cabardiano" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "capoverdiano" },
            { "ken", "kenyang" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "khasi" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "kok", "konkani" },
            { "kpe", "kpelle" },
            { "krc", "karachay-balkaro" },
            { "krl", "careliano" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "coloniese" },
            { "kum", "kumyko" },
            { "kwk", "kwakwala" },
            { "kxv", "kuvi" },
            { "lad", "judeo-espaniol" },
            { "lag", "langi" },
            { "lez", "lezghiano" },
            { "lij", "ligure" },
            { "lil", "lillooet" },
            { "lkt", "lakota" },
            { "lld", "ladino" },
            { "lmo", "lombardo" },
            { "lou", "creolo louisianese" },
            { "loz", "lozi" },
            { "lrc", "luri del nord" },
            { "lsm", "samia" },
            { "ltg", "latgaliano" },
            { "lua", "luba-lulua" },
            { "lun", "lunda" },
            { "lus", "mizo" },
            { "luy", "luyia" },
            { "mad", "madurese" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "macassarese" },
            { "mas", "masai" },
            { "mdf", "moksha" },
            { "men", "mende" },
            { "mer", "meri" },
            { "mfe", "creolo mauritian" },
            { "mgh", "macua de Metto" },
            { "mgo", "meta\u02bc" },
            { "mhn", "mocheno" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mni", "manipuri" },
            { "moe", "innu-aimun" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mua", "mundang" },
            { "mul", "plure linguas" },
            { "mus", "creek" },
            { "mwl", "mirandese" },
            { "myv", "erzya" },
            { "mzn", "mazanderani" },
            { "nap", "napolitano" },
            { "naq", "nama" },
            { "nds", "basse germano" },
            { "new", "newari" },
            { "nia", "nias" },
            { "niu", "nieuano" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogai" },
            { "nqo", "n\u2019ko" },
            { "nso", "sotho del nord" },
            { "nus", "nuer" },
            { "nyn", "nyankole" },
            { "ojb", "ojibwa del nord-west" },
            { "ojc", "ojibwa central" },
            { "ojs", "oji-cree" },
            { "ojw", "ojibwa del west" },
            { "oka", "okanagan" },
            { "osa", "osage" },
            { "pag", "pangasinan" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palauano" },
            { "pcm", "pidgin nigerian" },
            { "pis", "pijin" },
            { "pqm", "malecite-passamaquoddy" },
            { "prg", "prussiano" },
            { "quc", "k\u02bciche\u02bc" },
            { "raj", "rajasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotongano" },
            { "rhg", "rohingya" },
            { "rif", "rifeno" },
            { "rof", "rombo" },
            { "rup", "aromaniano" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "yakuto" },
            { "saq", "samburu" },
            { "sat", "santali" },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "siciliano" },
            { "sco", "scotese" },
            { "sdh", "kurdo del sud" },
            { "seh", "sena" },
            { "ses", "koyraboro senni" },
            { "shi", "tachelhit" },
            { "shn", "shan" },
            { "sid", "sidamo" },
            { "skr", "saraiki" },
            { "slh", "lushootseed del sud" },
            { "sma", "sami del sud" },
            { "smj", "sami de Lule" },
            { "smn", "sami de Inari" },
            { "sms", "sami skolt" },
            { "snk", "soninke" },
            { "srn", "sranan tongo" },
            { "ssy", "saho" },
            { "str", "salish del strictos" },
            { "suk", "sukuma" },
            { "swb", "comoriano" },
            { "syr", "syriaco" },
            { "szl", "silesiano" },
            { "tce", "tutchone del sud" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "tet", "tetum" },
            { "tgx", "tagish" },
            { "tht", "tahltan" },
            { "tig", "tigre" },
            { "tlh", "klingon" },
            { "tli", "tlingit" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "trv", "taroko" },
            { "trw", "torwali" },
            { "ttm", "tutchone del nord" },
            { "tum", "tumbuka" },
            { "tvl", "tuvaluano" },
            { "twq", "tasawaq" },
            { "tyv", "tuvano" },
            { "tzm", "tamazight del Atlas Central" },
            { "udm", "udmurto" },
            { "umb", "umbundu" },
            { "und", "lingua incognite" },
            { "vec", "venetiano" },
            { "vmw", "macua" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "wolaytta" },
            { "war", "waray" },
            { "wbp", "warlpiri" },
            { "wuu", "wu" },
            { "xal", "calmuco" },
            { "xnr", "kangri" },
            { "xog", "soga" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nheengatu" },
            { "yue", "cantonese" },
            { "zgh", "tamazight marocchin standard" },
            { "zun", "zuni" },
            { "zxx", "sin contento linguistic" },
            { "zza", "zaza" },
            { "Arab", metaValue_ar },
            { "Armn", "armenie" },
            { "Beng", metaValue_bn },
            { "Bopo", "bopomofo" },
            { "Brai", "braille" },
            { "Cyrl", "cyrillic" },
            { "Deva", "devanagari" },
            { "Ethi", "ethiope" },
            { "Geor", "georgian" },
            { "Grek", "grec" },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhi" },
            { "Hanb", "han con bopomofo" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hans", "simplificate" },
            { "Hant", "traditional" },
            { "Hebr", "hebraic" },
            { "Hira", "hiragana" },
            { "Hrkt", "syllabarios japonese" },
            { "Jamo", "jamo" },
            { "Jpan", metaValue_ja },
            { "Kana", "katakana" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", "corean" },
            { "Laoo", "lao" },
            { "Latn", "latin" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mymr", "birman" },
            { "Orya", "orya" },
            { "Sinh", metaValue_si },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Thaa", "thaana" },
            { "Thai", "thailandese" },
            { "Tibt", "tibetan" },
            { "Zinh", "hereditate" },
            { "Zmth", "notation mathematic" },
            { "Zsye", "emoji" },
            { "Zsym", "symbolos" },
            { "Zxxx", "non scripte" },
            { "Zyyy", "commun" },
            { "Zzzz", "scriptura incognite" },
            { "de_AT", "germano austriac" },
            { "de_CH", "alte germano suisse" },
            { "en_AU", "anglese australian" },
            { "en_CA", "anglese canadian" },
            { "en_GB", "anglese britannic" },
            { "en_US", "anglese american" },
            { "es_ES", "espaniol europee" },
            { "es_MX", "espaniol mexican" },
            { "fa_AF", "dari" },
            { "fr_CA", "francese canadian" },
            { "fr_CH", "francese suisse" },
            { "nl_BE", "flamingo" },
            { "pt_BR", "portugese de Brasil" },
            { "pt_PT", "portugese de Portugal" },
            { "ro_MD", "moldavo" },
            { "sw_CD", "swahili del Congo" },
            { "ar_001", "arabe standard moderne" },
            { "es_419", "espaniol latinoamerican" },
            { "key.ca", "calendario" },
            { "key.cf", "formato de moneta" },
            { "key.co", "ordinamento" },
            { "key.cu", "moneta" },
            { "key.hc", "cyclo horari (12 o 24)" },
            { "key.lb", "stilo de salto de linea" },
            { "key.ms", "systema de mesura" },
            { "key.nu", "numeros" },
            { "nds_NL", "basse saxone" },
            { "zh_Hans", "chinese simplificate" },
            { "zh_Hant", "chinese traditional" },
            { "type.ca.roc", "calendario del Republica de China" },
            { "type.co.eor", "regulas europee de ordinamento" },
            { "type.hc.h11", "systema de 12 horas (0\u201311)" },
            { "type.hc.h12", "systema de 12 horas (1\u201312)" },
            { "type.hc.h23", "systema de 24 horas (0\u201323)" },
            { "type.hc.h24", "systema de 24 horas (1\u201324)" },
            { "type.nu.ahom", "cifras ahom" },
            { "type.nu.arab", "cifras indo-arabe" },
            { "type.nu.armn", "cifras armenie" },
            { "type.nu.bali", "cifras balinese" },
            { "type.nu.beng", "cifras bengalese" },
            { "type.nu.brah", "cifras brahmi" },
            { "type.nu.cakm", "cifras chakma" },
            { "type.nu.cham", "cifras cham" },
            { "type.nu.cyrl", "cifras cyrillic" },
            { "type.nu.deva", "cifras devanagari" },
            { "type.nu.diak", "cifras dives akuru" },
            { "type.nu.ethi", "cifras ethiope" },
            { "type.nu.gara", "cifras garay" },
            { "type.nu.geor", "cifras georgian" },
            { "type.nu.gong", "cifras gunjala gondi" },
            { "type.nu.gonm", "cifras masaram gondi" },
            { "type.nu.grek", "cifras grec" },
            { "type.nu.gujr", "cifras gujarati" },
            { "type.nu.gukh", "cifras gurung khema" },
            { "type.nu.guru", "cifras gurmukhi" },
            { "type.nu.hans", "cifras chinese simplificate" },
            { "type.nu.hant", "cifras chinese traditional" },
            { "type.nu.hebr", "cifras hebraic" },
            { "type.nu.hmng", "cifras pahawh hmong" },
            { "type.nu.hmnp", "cifras nyiakeng puachue hmong" },
            { "type.nu.java", "cifras javanese" },
            { "type.nu.jpan", "cifras japonese" },
            { "type.nu.khmr", "cifras khmer" },
            { "type.nu.knda", "cifras kannada" },
            { "type.nu.laoo", "cifras lao" },
            { "type.nu.latn", "cifras occidental" },
            { "type.nu.mlym", "cifras malayalam" },
            { "type.nu.mtei", "cifras meetei mayek" },
            { "type.nu.mymr", "cifras birman" },
            { "type.nu.olck", "cifras ol chiki" },
            { "type.nu.orya", "cifras oriya" },
            { "type.nu.taml", "cifras tamil traditional" },
            { "type.nu.telu", "cifras telugu" },
            { "type.nu.thai", "cifras thailandese" },
            { "type.nu.tibt", "cifras tibetan" },
            { "type.nu.vaii", "cifras vai" },
            { "type.ca.dangi", "calendario dangi" },
            { "type.co.ducet", "ordinamento Unicode predefinite" },
            { "type.co.emoji", "ordinamento de emoji" },
            { "type.lb.loose", "stilo de salto de linea flexibile" },
            { "type.nu.roman", "cifras roman" },
            { "type.ca.coptic", "calendario copte" },
            { "type.ca.hebrew", "calendario hebraic" },
            { "type.ca.indian", "calendario national indian" },
            { "type.co.compat", "ordinamento previe, pro compatibilitate" },
            { "type.co.pinyin", "ordinamento pinyin" },
            { "type.co.search", "recerca generic" },
            { "type.co.stroke", "ordinamento de tractos" },
            { "type.co.unihan", "ordinamento de tractos radical" },
            { "type.co.zhuyin", "ordinamento zhuyin" },
            { "type.lb.normal", "stilo de salto de linea normal" },
            { "type.lb.strict", "stilo de salto de linea stricte" },
            { "type.ms.metric", "systema metric" },
            { "type.ca.chinese", "calendario chinese" },
            { "type.ca.islamic", "calendario hegiric" },
            { "type.ca.iso8601", "calendario ISO-8601" },
            { "type.ca.persian", "calendario persa" },
            { "type.cf.account", "formato de moneta pro contabilitate" },
            { "type.co.big5han", "ordinamento traditional chinese - Big5" },
            { "type.nu.arabext", "cifras indo-arabe extendite" },
            { "type.nu.armnlow", "cifras armenie minuscule" },
            { "type.nu.greklow", "cifras grec minuscule" },
            { "type.nu.hanidec", "cifras decimal chinese" },
            { "type.nu.hansfin", "cifras financiari chinese simplificate" },
            { "type.nu.hantfin", "cifras financiari chinese traditional" },
            { "type.nu.jpanfin", "cifras financiari japonese" },
            { "type.nu.tamldec", "cifras tamil" },
            { "type.ca.buddhist", "calendario buddhista" },
            { "type.ca.ethiopic", "calendario ethiope" },
            { "type.ca.japanese", "calendario japonese" },
            { "type.cf.standard", "formato de moneta standard" },
            { "type.co.searchjl", "recerca per consonante initial hangul" },
            { "type.co.standard", "ordinamento standard" },
            { "type.ms.uksystem", "systema de mesura imperial" },
            { "type.ms.ussystem", "systema de mesura statounitese" },
            { "type.nu.fullwide", "cifras in plen largor" },
            { "type.nu.romanlow", "cifras roman minuscule" },
            { "type.ca.gregorian", "calendario gregorian" },
            { "type.co.gb2312han", "ordinamento chinese simplificate - GB2312" },
            { "type.co.phonebook", "ordinamento de annuario telephonic" },
            { "type.co.dictionary", "ordinamento de dictionario" },
            { "type.co.traditional", "ordinamento traditional" },
            { "type.ca.islamic-rgsa", "calendario hegiric (Arabia Saudita, observation)" },
            { "type.ca.islamic-tbla", "calendario hegiric (tabular, epocha astronomic)" },
            { "type.ca.islamic-civil", "calendario hegiric (tabular, epocha civil)" },
            { "type.ca.islamic-umalqura", "calendario hegiric (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "calendario ethiope Amete Alem" },
        };
        return data;
    }
}
