﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

namespace Cake.Common.Tools.GitVersion
{
    /// <summary>
    /// GitVersion information.
    /// </summary>
    public sealed class GitVersion
    {
        /// <summary>
        /// Gets or sets the major version.
        /// </summary>
        public int Major { get; set; }

        /// <summary>
        /// Gets or sets the minor version.
        /// </summary>
        public int Minor { get; set; }

        /// <summary>
        /// Gets or sets the patch version.
        /// </summary>
        public int Patch { get; set; }

        /// <summary>
        /// Gets or sets the pre-release tag.
        /// </summary>
        public string PreReleaseTag { get; set; }

        /// <summary>
        /// Gets or sets the pre-release tag with dash.
        /// </summary>
        public string PreReleaseTagWithDash { get; set; }

        /// <summary>
        /// Gets or sets the pre-release label.
        /// </summary>
        public string PreReleaseLabel { get; set; }

        /// <summary>
        /// Gets or sets the pre-release label with dash.
        /// </summary>
        public string PreReleaseLabelWithDash { get; set; }

        /// <summary>
        /// Gets or sets the pre-release number.
        /// </summary>
        public int? PreReleaseNumber { get; set; }

        /// <summary>
        /// Gets or sets the weighted pre-release number.
        /// </summary>
        public int? WeightedPreReleaseNumber { get; set; }

        /// <summary>
        /// Gets or sets the build metadata.
        /// </summary>
        public string BuildMetaData { get; set; }

        /// <summary>
        /// Gets or sets the build metadata padded.
        /// </summary>
        public string BuildMetaDataPadded { get; set; }

        /// <summary>
        /// Gets or sets the major version.
        /// </summary>
        public string FullBuildMetaData { get; set; }

        /// <summary>
        /// Gets or sets the major, minor, and path.
        /// </summary>
        public string MajorMinorPatch { get; set; }

        /// <summary>
        /// Gets or sets the Semantic Version.
        /// </summary>
        public string SemVer { get; set; }

        /// <summary>
        /// Gets or sets the legacy Semantic Version.
        /// </summary>
        public string LegacySemVer { get; set; }

        /// <summary>
        /// Gets or sets the padded legacy Semantic Version.
        /// </summary>
        public string LegacySemVerPadded { get; set; }

        /// <summary>
        /// Gets or sets the assembly Semantic Version.
        /// </summary>
        public string AssemblySemVer { get; set; }

        /// <summary>
        /// Gets or sets the assembly semantic file version.
        /// </summary>
        public string AssemblySemFileVer { get; set; }

        /// <summary>
        /// Gets or sets the full Semantic Version.
        /// </summary>
        public string FullSemVer { get; set; }

        /// <summary>
        /// Gets or sets the informational version.
        /// </summary>
        public string InformationalVersion { get; set; }

        /// <summary>
        /// Gets or sets the branch name.
        /// </summary>
        public string BranchName { get; set; }

        /// <summary>
        /// Gets or sets the escaped branch name.
        /// </summary>
        public string EscapedBranchName { get; set; }

        /// <summary>
        /// Gets or sets the Git SHA.
        /// </summary>
        public string Sha { get; set; }

        /// <summary>
        /// Gets or sets the shortened Git SHA.
        /// </summary>
        public string ShortSha { get; set; }

        /// <summary>
        /// Gets or sets the NuGet version for v2.
        /// </summary>
        public string NuGetVersionV2 { get; set; }

        /// <summary>
        /// Gets or sets the NuGet version.
        /// </summary>
        public string NuGetVersion { get; set; }

        /// <summary>
        /// Gets or sets the NuGet pre-release tag for v2.
        /// </summary>
        public string NuGetPreReleaseTagV2 { get; set; }

        /// <summary>
        /// Gets or sets the NuGet pre-release tag.
        /// </summary>
        public string NuGetPreReleaseTag { get; set; }

        /// <summary>
        /// Gets or sets the version source sha.
        /// </summary>
        public string VersionSourceSha { get; set; }

        /// <summary>
        /// Gets or sets the commits since version source.
        /// </summary>
        public int? CommitsSinceVersionSource { get; set; }

        /// <summary>
        /// Gets or sets the commits since version source padded.
        /// </summary>
        public string CommitsSinceVersionSourcePadded { get; set; }

        /// <summary>
        /// Gets or sets the number of uncommited changes.
        /// </summary>
        public int? UncommittedChanges { get; set; }

        /// <summary>
        /// Gets or sets the commit date.
        /// </summary>
        public string CommitDate { get; set; }
    }
}