/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.midletsuite;

import com.sun.midp.Configuration;
import com.sun.midp.io.Base64;
import com.sun.midp.io.HttpUrl;
import com.sun.midp.io.Properties;
import com.sun.midp.io.j2me.storage.File;
import com.sun.midp.io.j2me.storage.RandomAccessStream;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.midletsuite.InstallListener;
import com.sun.midp.midletsuite.InstallState;
import com.sun.midp.midletsuite.InvalidJadException;
import com.sun.midp.midletsuite.JadProperties;
import com.sun.midp.midletsuite.JarReader;
import com.sun.midp.midletsuite.MIDletSuiteImpl;
import com.sun.midp.midletsuite.ManifestProperties;
import com.sun.midp.security.SecurityDomain;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class Installer {
    public static final int STORING_SUITE = 1;
    public static final String JAR_MANIFEST = "META-INF/MANIFEST.MF";
    public static final String DATA_SIZE_PROP = "MIDlet-Data-Size";
    public static final String JAR_SIZE_PROP = "MIDlet-Jar-Size";
    public static final String JAR_URL_PROP = "MIDlet-Jar-URL";
    public static final String SUITE_NAME_PROP = "MIDlet-Name";
    public static final String VENDOR_PROP = "MIDlet-Vendor";
    public static final String VERSION_PROP = "MIDlet-Version";
    public static final String NOTIFY_PROP = "MIDlet-Install-Notify";
    public static final String CONFIGURATION_PROP = "MicroEdition-Configuration";
    public static final String PROFILE_PROP = "MicroEdition-Profile";
    private static final int MAX_DL_SIZE = 1024;
    private static final String BASIC_TAG = "basic";
    private static final String VERSION_TAG = "version";
    private static final String DOMAIN_TAG = "domain";
    private static final String PATH_TAG = "path";
    static final String JAD_MT = "text/vnd.sun.j2me.app-descriptor";
    static final String JAR_MT_1 = "application/java";
    static final String JAR_MT_2 = "application/java-archive";
    static final String DOMAIN_OWNER_FILENAME = "domainOwner.utf";
    static final String JAD_URL_FILENAME = "jadUrl.utf";
    static final String JAD_ENCODING_FILENAME = "jadEncoding.utf";
    static final String JAR_FILENAME = "suite.jar";
    static final String JAD_FILENAME = "suite.jad";
    static final String TMP_FILENAME = "installer.tmp";
    static final String MANIFEST_FILENAME = "suite.mf";
    static final String SUITE_LIST_FILENAME = "suites.utf";
    static final String SUCCESS_MSG = "900 Success";
    static final String INSUFFICIENT_MEM_MSG = "901 Insufficient Memory";
    static final String USER_CANCELLED_MSG = "902 User Cancelled";
    static final String JAR_SIZE_MISMATCH_MSG = "904 JAR Size Mismatch";
    static final String ATTRIBUTE_MISMATCH_MSG = "905 Attribute Mismatch";
    static final String INVALID_JAD_MSG = "906 Invalid Descriptor";
    static final String INVALID_JAR_MSG = "907 Invalid JAR";
    static final String INCOMPATIBLE_MSG = "908 Incompatible Configration or Profile";
    private static Installer myInstaller;
    private static SecurityDomain classSecurityDomain;
    private String nextMidletSuiteToRun;
    private String nextMidletToRun;
    private Vector midletSuiteList;
    private HttpConnection httpConnection;
    private InputStream httpInputStream;
    private InstallListener listener;
    private InstallStateImpl state;

    public static void initSecurityDomain(SecurityDomain theDomain) {
        if (classSecurityDomain != null) {
            return;
        }
        classSecurityDomain = theDomain;
        MIDletSuiteImpl.initSecurityDomain(classSecurityDomain);
    }

    public static Installer getInstaller() throws SecurityException {
        MIDletSuite midletSuite = Scheduler.getScheduler().getMIDletSuite();
        if (midletSuite != null) {
            midletSuite.checkIfPermitted(3);
        }
        return Installer.getInstallerCommon();
    }

    public static Installer getInstaller(SecurityDomain securityDomain) throws SecurityException {
        securityDomain.checkIfPermitted(3);
        return Installer.getInstallerCommon();
    }

    private static Installer getInstallerCommon() {
        if (myInstaller != null) {
            return myInstaller;
        }
        String nameOfInstaller = Configuration.getProperty("com.sun.midp.midletsuite.installer");
        if (nameOfInstaller == null) {
            myInstaller = new Installer();
            return myInstaller;
        }
        try {
            myInstaller = (Installer)Class.forName(nameOfInstaller).newInstance();
            return myInstaller;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static String makeStorageName(String vendorName, String appName) {
        return File.unicodeToAsciiFilename(vendorName) + '_' + File.unicodeToAsciiFilename(appName) + '_';
    }

    protected Installer() {
        if (myInstaller != null) {
            throw new SecurityException("Illegal instantiation of the Installer");
        }
    }

    public String install(String location, boolean force, InstallListener installListener) throws IOException, InvalidJadException, SecurityException {
        this.state = new InstallStateImpl();
        this.state.jadUrl = location;
        this.state.force = force;
        this.state.nextStep = 1;
        this.listener = installListener;
        return this.performInstall();
    }

    public String install(String location, byte[] jad, String jadEncoding, String jadCookie, String username, String password, boolean force, InstallListener installListener) throws IOException, InvalidJadException, SecurityException {
        this.state = new InstallStateImpl();
        this.state.jadUrl = location;
        this.state.force = force;
        this.state.nextStep = 2;
        InstallStateImpl.access$402(this.state, jad);
        this.state.jadEncoding = jadEncoding;
        this.state.cookie = jadCookie;
        this.state.username = username;
        this.state.password = password;
        this.listener = installListener;
        return this.performInstall();
    }

    public String install(String location, boolean force) throws IOException, InvalidJadException, SecurityException {
        return this.install(location, force, null);
    }

    private synchronized String performInstall() throws IOException, InvalidJadException {
        this.state.startTime = System.currentTimeMillis();
        while (this.state.nextStep < 6) {
            this.state.exception = null;
            if (this.state.stopInstallation) {
                this.postStatusBackToProvider(USER_CANCELLED_MSG);
                throw new IOException("stopped");
            }
            switch (this.state.nextStep) {
                case 1: {
                    this.installStep1();
                    break;
                }
                case 2: {
                    this.installStep2();
                    break;
                }
                case 3: {
                    this.installStep3();
                    break;
                }
                case 4: {
                    this.installStep4();
                    break;
                }
                case 5: {
                    this.installStep5();
                }
            }
            if (this.state.exception == null) continue;
            if (this.listener == null) {
                throw this.state.exception;
            }
            if (this.listener.warnUser(this.state)) continue;
            this.state.stopInstallation = true;
            this.postStatusBackToProvider(USER_CANCELLED_MSG);
            throw this.state.exception;
        }
        return this.state.storageName;
    }

    private void installStep1() throws IOException, InvalidJadException {
        if (this.state.jadUrl == null || this.state.jadUrl.length() == 0) {
            throw new IOException("Must specify URL of .jad file");
        }
        try {
            byte[] jad = this.downloadJAD();
            InstallStateImpl.access$402(this.state, jad);
            this.state.nextStep++;
            return;
        }
        catch (InvalidJadException ije) {
            if (ije.getReason() == 33) {
                this.state.exception = ije;
                return;
            }
            throw ije;
        }
    }

    private void installStep2() throws IOException, InvalidJadException {
        this.state.jadProps = new JadProperties();
        try {
            this.parseJad(new ByteArrayInputStream(this.state.jad), this.state.jadEncoding, this.state.jadProps);
        }
        catch (InvalidJadException ije) {
            this.postStatusBackToProvider(INVALID_JAD_MSG);
            throw ije;
        }
        this.state.suiteName = this.state.jadProps.getProperty(SUITE_NAME_PROP);
        if (this.state.suiteName == null || this.state.suiteName.length() == 0) {
            this.postStatusBackToProvider(INVALID_JAD_MSG);
            throw new InvalidJadException(13);
        }
        this.state.vendor = this.state.jadProps.getProperty(VENDOR_PROP);
        if (this.state.vendor == null || this.state.vendor.length() == 0) {
            this.postStatusBackToProvider(INVALID_JAD_MSG);
            throw new InvalidJadException(14);
        }
        this.state.version = this.state.jadProps.getProperty(VERSION_PROP);
        if (this.state.version == null || this.state.version.length() == 0) {
            this.postStatusBackToProvider(INVALID_JAD_MSG);
            throw new InvalidJadException(15);
        }
        this.state.storageName = Installer.makeStorageName(this.state.vendor, this.state.suiteName);
        MIDletSuite midletSuite = this.getMIDletSuite(this.state.storageName);
        try {
            this.checkVersionFormat(this.state.version);
            this.state.nextStep++;
            if (midletSuite == null) {
                return;
            }
            this.state.isPreviousVersion = true;
            this.state.previousJadUrl = midletSuite.getJadUrl();
            int cmpResult = this.vercmp(this.state.version, midletSuite.getProperty(VERSION_PROP));
            if (cmpResult < 0) {
                throw new InvalidJadException(17);
            }
            if (this.state.force) {
                return;
            }
            if (cmpResult > 0) {
                this.state.exception = new InvalidJadException(32);
                return;
            }
            this.state.exception = new InvalidJadException(39);
            return;
        }
        catch (NumberFormatException nfe) {
            this.postStatusBackToProvider(INVALID_JAD_MSG);
            throw new InvalidJadException(16);
        }
    }

    private void installStep3() throws IOException, InvalidJadException {
        try {
            this.state.domainOwner = this.verifyJad(this.state.jad, this.state.jadProps);
        }
        catch (InvalidJadException ije) {
            this.postStatusBackToProvider(INVALID_JAD_MSG);
            throw ije;
        }
        this.state.nextStep++;
        if (this.state.domainOwner == null && this.state.previousJadUrl != null) {
            HttpUrl old = new HttpUrl(this.state.previousJadUrl);
            HttpUrl current = new HttpUrl(this.state.jadUrl);
            if (current.domain != null && old.domain == null || current.domain == null && old.domain != null || current.domain != null && old.domain != null && !current.domain.regionMatches(true, 0, old.domain, 0, old.domain.length())) {
                this.state.exception = new InvalidJadException(34, this.state.previousJadUrl == null ? "none" : this.state.previousJadUrl);
                return;
            }
        }
    }

    private void installStep4() throws IOException, InvalidJadException {
        int dataSize;
        String sizeString = this.state.jadProps.getProperty(JAR_SIZE_PROP);
        if (sizeString == null) {
            this.postStatusBackToProvider(INVALID_JAD_MSG);
            throw new InvalidJadException(21);
        }
        try {
            this.state.expectedJarSize = Integer.parseInt(sizeString);
        }
        catch (NumberFormatException e) {
            this.postStatusBackToProvider(INVALID_JAD_MSG);
            throw new InvalidJadException(29);
        }
        sizeString = this.state.jadProps.getProperty(DATA_SIZE_PROP);
        if (sizeString == null) {
            dataSize = 0;
        } else {
            try {
                dataSize = Integer.parseInt(sizeString);
            }
            catch (NumberFormatException e) {
                this.postStatusBackToProvider(INVALID_JAD_MSG);
                throw new InvalidJadException(29);
            }
        }
        int suiteSize = this.state.expectedJarSize + this.state.jad.length * 2 + this.state.jadUrl.length() * 3 + dataSize;
        this.state.file = new File(Installer.classSecurityDomain);
        if (suiteSize > this.state.file.getBytesAvailableForFiles()) {
            this.postStatusBackToProvider(INSUFFICIENT_MEM_MSG);
            throw new InvalidJadException(30, Integer.toString((suiteSize + 1023) / 1024));
        }
        this.state.nextStep++;
    }

    private void installStep5() throws IOException, InvalidJadException {
        String storageRoot;
        byte[] manifest;
        int bytesDownloaded;
        RandomAccessStream myStorage = null;
        String jarUrl = this.state.jadProps.getProperty(JAR_URL_PROP);
        if (jarUrl == null || jarUrl.length() == 0) {
            this.postStatusBackToProvider(INVALID_JAD_MSG);
            throw new InvalidJadException(18);
        }
        String tempFilename = File.getStorageRoot() + TMP_FILENAME;
        try {
            bytesDownloaded = this.downloadJAR(jarUrl, tempFilename);
        }
        catch (InvalidJadException ije) {
            if (ije.getReason() == 33) {
                this.state.exception = ije;
                return;
            }
            throw ije;
        }
        try {
            if (bytesDownloaded != this.state.expectedJarSize) {
                this.postStatusBackToProvider(JAR_SIZE_MISMATCH_MSG);
                throw new InvalidJadException(31);
            }
            myStorage = new RandomAccessStream(classSecurityDomain);
            if (this.state.domainOwner != null) {
                this.verifyJar(this.state.jadProps, myStorage, tempFilename);
            }
            try {
                manifest = JarReader.readJarEntry(classSecurityDomain, tempFilename, JAR_MANIFEST);
            }
            catch (IOException ioe) {
                this.postStatusBackToProvider(INVALID_JAR_MSG);
                throw new InvalidJadException(36);
            }
            ManifestProperties jarProps = new ManifestProperties();
            jarProps.load(new ByteArrayInputStream(manifest));
            String configuration = jarProps.getProperty(CONFIGURATION_PROP);
            if (configuration == null || configuration.length() == 0) {
                this.postStatusBackToProvider(INVALID_JAR_MSG);
                throw new InvalidJadException(41);
            }
            String temp = this.state.jadProps.getProperty(CONFIGURATION_PROP);
            if (temp != null) {
                configuration = temp;
            }
            if (!configuration.equals("CLDC-1.0")) {
                this.postStatusBackToProvider(INCOMPATIBLE_MSG);
                throw new InvalidJadException(40);
            }
            String profile = jarProps.getProperty(PROFILE_PROP);
            if (profile == null || profile.length() == 0) {
                this.postStatusBackToProvider(INVALID_JAR_MSG);
                throw new InvalidJadException(42);
            }
            temp = this.state.jadProps.getProperty(PROFILE_PROP);
            if (temp != null) {
                profile = temp;
            }
            if (!profile.equals("MIDP-1.0")) {
                this.postStatusBackToProvider(INCOMPATIBLE_MSG);
                throw new InvalidJadException(40);
            }
            if (!this.state.suiteName.equals(jarProps.getProperty(SUITE_NAME_PROP))) {
                this.postStatusBackToProvider(ATTRIBUTE_MISMATCH_MSG);
                throw new InvalidJadException(25);
            }
            if (!this.state.version.equals(jarProps.getProperty(VERSION_PROP))) {
                this.postStatusBackToProvider(ATTRIBUTE_MISMATCH_MSG);
                throw new InvalidJadException(26);
            }
            if (!this.state.vendor.equals(jarProps.getProperty(VENDOR_PROP))) {
                this.postStatusBackToProvider(ATTRIBUTE_MISMATCH_MSG);
                throw new InvalidJadException(27);
            }
            storageRoot = File.getStorageRoot() + this.state.storageName;
            while (System.currentTimeMillis() - this.state.startTime < 1000L) {
            }
            InstallStateImpl ioe = this.state;
            synchronized (ioe) {
                if (this.state.stopInstallation) {
                    this.postStatusBackToProvider(USER_CANCELLED_MSG);
                    throw new IOException("stopped");
                }
                if (this.listener != null) {
                    this.listener.updateStatus(1);
                }
                this.state.writingSuite = true;
            }
        }
        catch (Exception e) {
            this.state.file.delete(tempFilename);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (RuntimeException)e;
        }
        try {
            this.state.file.rename(tempFilename, storageRoot + JAR_FILENAME);
            myStorage.connect(storageRoot + MANIFEST_FILENAME, -3);
            myStorage.writeBytes(manifest, 0, manifest.length);
            myStorage.disconnect();
            myStorage.connect(storageRoot + JAD_FILENAME, -3);
            myStorage.writeBytes(this.state.jad, 0, this.state.jad.length);
            myStorage.disconnect();
            myStorage.connect(storageRoot + JAD_URL_FILENAME, -3);
            DataOutputStream storageStream = myStorage.openDataOutputStream();
            storageStream.writeUTF(this.state.jadUrl);
            storageStream.close();
            myStorage.disconnect();
            if (this.state.jadEncoding != null) {
                myStorage.connect(storageRoot + JAD_ENCODING_FILENAME, -3);
                storageStream = myStorage.openDataOutputStream();
                storageStream.writeUTF(this.state.jadEncoding);
                storageStream.close();
                myStorage.disconnect();
            } else if (this.state.file.exists(storageRoot + JAD_ENCODING_FILENAME)) {
                this.state.file.delete(storageRoot + JAD_ENCODING_FILENAME);
            }
            if (this.state.domainOwner != null) {
                myStorage.connect(storageRoot + DOMAIN_OWNER_FILENAME, -3);
                storageStream = myStorage.openDataOutputStream();
                storageStream.writeUTF(this.state.domainOwner);
                storageStream.close();
                myStorage.disconnect();
            }
            this.addToSuiteList(this.state.storageName);
            this.state.nextStep++;
            try {
                this.postStatusBackToProvider(SUCCESS_MSG);
            }
            catch (RuntimeException re) {
                // empty catch block
            }
            return;
        }
        catch (Exception e) {
            try {
                myStorage.disconnect();
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.remove(this.state.storageName);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (RuntimeException)e;
        }
    }

    private byte[] downloadJAD() throws IOException {
        String[] encoding = new String[1];
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        String[] acceptableTypes = new String[]{JAD_MT};
        String[] extraFieldKeys = new String[3];
        String[] extraFieldValues = new String[3];
        extraFieldKeys[0] = "User-Agent";
        extraFieldValues[0] = "Profile/" + System.getProperty("microedition.profiles") + " Configuration/" + System.getProperty("microedition.configuration");
        extraFieldKeys[1] = "Accept-Charset";
        extraFieldValues[1] = "UTF-8, " + System.getProperty("microedition.encoding");
        String locale = System.getProperty("microedition.locale");
        if (locale != null) {
            extraFieldKeys[2] = "Accept-Language";
            extraFieldValues[2] = locale;
        }
        this.downloadResource(this.state.jadUrl, extraFieldKeys, extraFieldValues, acceptableTypes, bos, encoding, 1, 2, 37);
        this.state.jadEncoding = encoding[0];
        return bos.toByteArray();
    }

    private int downloadJAR(String jarUrl, String filename) throws IOException {
        int jarSize;
        String url;
        String[] acceptableTypes = new String[]{JAR_MT_1, JAR_MT_2};
        RandomAccessStream jarOutputStream = null;
        OutputStream outputStream = null;
        HttpUrl parsedUrl = new HttpUrl(jarUrl);
        if (parsedUrl.authority == null && this.state.jadUrl != null) {
            try {
                parsedUrl.addBaseUrl(this.state.jadUrl);
            }
            catch (IOException e) {
                this.postStatusBackToProvider(INVALID_JAD_MSG);
                throw new InvalidJadException(19);
            }
            url = parsedUrl.toString();
        } else {
            url = jarUrl;
        }
        jarOutputStream = new RandomAccessStream(classSecurityDomain);
        jarOutputStream.connect(filename, -3);
        outputStream = jarOutputStream.openOutputStream();
        int ije = jarSize = this.downloadResource(url, null, null, acceptableTypes, outputStream, null, 19, 20, 38);
        try {
            try {
                return ije;
            }
            catch (InvalidJadException ije2) {
                switch (ije2.getReason()) {
                    case 19: 
                    case 20: {
                        this.postStatusBackToProvider(INVALID_JAD_MSG);
                        break;
                    }
                    case 38: {
                        this.postStatusBackToProvider(INVALID_JAR_MSG);
                    }
                }
                throw ije2;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            try {
                jarOutputStream.disconnect();
            }
            catch (Exception e) {}
        }
    }

    private int downloadResource(String url, String[] extraFieldKeys, String[] extraFieldValues, String[] acceptableTypes, OutputStream output, String[] encoding, int serverNotFoundCode, int resourceNotFoundCode, int invalidMediaTypeCode) throws IOException {
        String temp;
        int responseCode;
        Connection conn;
        block37: {
            conn = null;
            do {
                block38: {
                    String retryAfterField;
                    int i;
                    try {
                        conn = Connector.open(url, 1);
                    }
                    catch (Exception e) {
                        throw new InvalidJadException(serverNotFoundCode);
                    }
                    if (!(conn instanceof HttpConnection)) {
                        throw new InvalidJadException(serverNotFoundCode);
                    }
                    this.httpConnection = (HttpConnection)conn;
                    if (extraFieldKeys != null) {
                        i = 0;
                        while (i < extraFieldKeys.length && extraFieldKeys[i] != null) {
                            this.httpConnection.setRequestProperty(extraFieldKeys[i], extraFieldValues[i]);
                            ++i;
                        }
                    }
                    StringBuffer acceptField = new StringBuffer(256);
                    acceptField.append(acceptableTypes[0]);
                    i = 1;
                    while (i < acceptableTypes.length) {
                        acceptField.append(", ");
                        acceptField.append(acceptableTypes[i]);
                        ++i;
                    }
                    this.httpConnection.setRequestProperty("Accept", acceptField.toString());
                    this.httpConnection.setRequestMethod("GET");
                    if (this.state.username != null && this.state.password != null) {
                        this.httpConnection.setRequestProperty("Authorization", Installer.formatAuthCredentials(this.state.username, this.state.password));
                    }
                    if (this.state.cookie != null) {
                        this.httpConnection.setRequestProperty("Cookie", this.formatReturnCookie(this.state.cookie));
                    }
                    try {
                        responseCode = this.httpConnection.getResponseCode();
                    }
                    catch (IOException ioe) {
                        throw new InvalidJadException(serverNotFoundCode);
                    }
                    responseCode = this.httpConnection.getResponseCode();
                    if (responseCode != 503 || (retryAfterField = this.httpConnection.getHeaderField("Retry-After")) == null) break block37;
                    try {
                        int retryInterval = Integer.parseInt(retryAfterField);
                        if (retryInterval <= 0) break block38;
                        if (retryInterval > 60) {
                            retryInterval = 60;
                        }
                        Thread.sleep(retryInterval * 1000);
                    }
                    catch (InterruptedException ie) {
                        break block37;
                    }
                    catch (NumberFormatException ne) {
                        break block37;
                    }
                }
                this.httpConnection.close();
            } while (!this.state.stopInstallation);
            this.postStatusBackToProvider(USER_CANCELLED_MSG);
            throw new IOException("stopped");
        }
        if (responseCode == 404) {
            throw new InvalidJadException(resourceNotFoundCode);
        }
        if (responseCode == 406) {
            throw new InvalidJadException(invalidMediaTypeCode);
        }
        if (responseCode == 401) {
            this.checkIfBasicAuthSupported(this.httpConnection.getHeaderField("WWW-Authenticate"));
            throw new InvalidJadException(33);
        }
        if (responseCode != 200) {
            throw new IOException("Failed to download " + url + " HTTP response code: " + responseCode);
        }
        String mediaType = Installer.getMediaType(this.httpConnection.getType());
        if (mediaType != null) {
            boolean goodType = false;
            int i = 0;
            while (i < acceptableTypes.length) {
                if (mediaType.equals(acceptableTypes[i])) {
                    goodType = true;
                    break;
                }
                ++i;
            }
            if (!goodType) {
                throw new InvalidJadException(invalidMediaTypeCode, mediaType);
            }
        }
        if (encoding != null) {
            encoding[0] = Installer.getCharset(this.httpConnection.getType());
        }
        if ((temp = this.httpConnection.getHeaderField("Set-Cookie")) != null) {
            this.state.cookie = temp;
        }
        this.httpInputStream = this.httpConnection.openInputStream();
        int n = this.transferData(this.httpInputStream, output);
        try {
            return n;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            try {
                this.httpInputStream.close();
            }
            catch (Exception e) {}
            try {
                conn.close();
            }
            catch (Exception e) {}
        }
    }

    private void checkIfBasicAuthSupported(String wwwAuthField) throws InvalidJadException {
        if (!(wwwAuthField = wwwAuthField.trim()).regionMatches(true, 0, BASIC_TAG, 0, BASIC_TAG.length())) {
            throw new InvalidJadException(35);
        }
    }

    private static String getMediaType(String contentType) {
        if (contentType == null) {
            return null;
        }
        int semiColon = contentType.indexOf(59);
        if (semiColon < 0) {
            return contentType.toLowerCase();
        }
        return contentType.substring(0, semiColon).toLowerCase();
    }

    private static String getCharset(String contentType) {
        int end;
        if (contentType == null) {
            return null;
        }
        int start = contentType.indexOf("charset");
        if (start < 0) {
            return null;
        }
        if ((start = contentType.indexOf(61, start)) < 0) {
            return null;
        }
        if ((end = contentType.indexOf(59, ++start)) < 0) {
            end = contentType.length();
        }
        return contentType.substring(start, end).trim();
    }

    private static String formatAuthCredentials(String username, String password) {
        byte[] data = new byte[username.length() + password.length() + 1];
        int j = 0;
        int i = 0;
        while (i < username.length()) {
            data[j] = (byte)username.charAt(i);
            ++i;
            ++j;
        }
        data[j] = 58;
        ++j;
        int i2 = 0;
        while (i2 < password.length()) {
            data[j] = (byte)password.charAt(i2);
            ++i2;
            ++j;
        }
        return "Basic " + Base64.encode(data, 0, data.length);
    }

    String formatReturnCookie(String cookieField) {
        Vector params = new Vector();
        int start = 0;
        String version = null;
        String domain = null;
        String path = null;
        int i = 0;
        while (i < cookieField.length()) {
            char currentChar = cookieField.charAt(i);
            if (currentChar == ',') break;
            if (currentChar == ';') {
                params.addElement(cookieField.substring(start, i).trim());
                start = i + 1;
            }
            ++i;
        }
        params.addElement(cookieField.substring(start, i).trim());
        StringBuffer cookie = new StringBuffer((String)params.elementAt(0));
        i = 1;
        while (i < params.size()) {
            String param = (String)params.elementAt(i);
            if (param.regionMatches(true, 0, VERSION_TAG, 0, VERSION_TAG.length())) {
                version = param;
            } else {
                if (param.regionMatches(true, 0, DOMAIN_TAG, 0, DOMAIN_TAG.length())) {
                    domain = param;
                }
                if (param.regionMatches(true, 0, PATH_TAG, 0, PATH_TAG.length())) {
                    path = param;
                }
            }
            ++i;
        }
        cookie.append(";$");
        cookie.append(version);
        if (domain != null) {
            cookie.append(";$");
            cookie.append(domain);
        }
        if (path != null) {
            cookie.append(";$");
            cookie.append(path);
        }
        return cookie.toString();
    }

    private void postStatusBackToProvider(String message) {
        if (this.state.jadProps == null) {
            return;
        }
        String url = this.state.jadProps.getProperty(NOTIFY_PROP);
        if (url == null) {
            return;
        }
        try {
            HttpConnection transaction = (HttpConnection)Connector.open(url, 2);
            try {
                transaction.setRequestMethod("POST");
                if (this.state.cookie != null) {
                    transaction.setRequestProperty("Cookie", this.formatReturnCookie(this.state.cookie));
                }
                OutputStream out = transaction.openOutputStream();
                try {
                    out.write(message.getBytes());
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    out.close();
                }
                transaction.getResponseCode();
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                transaction.close();
            }
        }
        catch (IOException ioe) {
        }
        catch (IllegalArgumentException iae) {
        }
        catch (ClassCastException cce) {
            // empty catch block
        }
    }

    private int transferData(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int totalBytesWritten = 0;
        try {
            while (true) {
                int bytesRead;
                if ((bytesRead = in.read(buffer)) == -1) {
                    return totalBytesWritten;
                }
                out.write(buffer, 0, bytesRead);
                totalBytesWritten += bytesRead;
            }
        }
        catch (IOException ioe) {
            if (this.state.stopInstallation) {
                this.postStatusBackToProvider(USER_CANCELLED_MSG);
                throw new IOException("stopped");
            }
            throw ioe;
        }
    }

    public boolean stopInstalling() {
        if (this.state == null) {
            return false;
        }
        InstallStateImpl installStateImpl = this.state;
        synchronized (installStateImpl) {
            if (this.state.writingSuite) {
                boolean bl = false;
                return bl;
            }
            this.state.stopInstallation = true;
            try {
                this.httpInputStream.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.httpConnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = true;
            return bl;
        }
    }

    public boolean wasStopped() {
        if (this.state == null) {
            return false;
        }
        return this.state.stopInstallation;
    }

    protected String getSecurityDomainName(String storageName) {
        return "untrusted";
    }

    public void parseJad(InputStream jad, String enc, JadProperties jadProps) throws IOException, InvalidJadException {
        jadProps.load(jad, enc);
    }

    protected String verifyJad(byte[] jad, Properties jadProps) throws IOException, InvalidJadException {
        return null;
    }

    protected void verifyJar(Properties jadProps, RandomAccessStream jarStorage, String jarFilename) throws IOException, InvalidJadException {
    }

    private int vercmp(String ver1, String ver2) throws NumberFormatException {
        int idx1 = 0;
        int idx2 = 0;
        if (ver1 == null && ver2 == null) {
            return 0;
        }
        if (ver1 == null) {
            return -1;
        }
        if (ver2 == null) {
            return 1;
        }
        int i = 0;
        while (i < 3) {
            int intVal2;
            int intVal1;
            int newidx;
            String strVal1 = "0";
            String strVal2 = "0";
            if (idx1 >= 0) {
                newidx = ver1.indexOf(46, idx1);
                strVal1 = newidx < 0 ? ver1.substring(idx1) : ver1.substring(idx1, newidx);
                idx1 = ++newidx;
            }
            if (idx2 >= 0) {
                newidx = ver2.indexOf(46, idx2);
                strVal2 = newidx < 0 ? ver2.substring(idx2) : ver2.substring(idx2, newidx);
                idx2 = ++newidx;
            }
            if ((intVal1 = Integer.parseInt(strVal1)) > (intVal2 = Integer.parseInt(strVal2))) {
                return 1;
            }
            if (intVal1 < intVal2) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    private void checkVersionFormat(String ver) throws NumberFormatException {
        int start = 0;
        int length = ver.length();
        int i = 0;
        while (true) {
            if (i == 3 || start == length) {
                throw new NumberFormatException();
            }
            int end = ver.indexOf(46, start);
            if (end == -1) {
                end = length;
            }
            Integer.parseInt(ver.substring(start, end));
            if (end == length) {
                return;
            }
            start = end + 1;
            ++i;
        }
    }

    public MIDletSuite getMIDletSuite(String storageName) {
        return this.getMIDletSuite(storageName, null);
    }

    public MIDletSuite getMIDletSuite(String storageName, String midletToRun) {
        File file = new File(classSecurityDomain);
        String storageRoot = File.getStorageRoot() + storageName;
        if (!this.suiteExists(storageName)) {
            return null;
        }
        return new MIDletSuiteImpl(classSecurityDomain, Scheduler.getScheduler(), storageRoot, this.getSecurityDomainName(storageName), midletToRun);
    }

    public void remove(String storageName) {
        File file = new File(classSecurityDomain);
        String storageRoot = File.getStorageRoot() + storageName;
        Installer installer = myInstaller;
        synchronized (installer) {
            Vector files = file.filenamesThatStartWith(storageRoot);
            int numberOfFiles = files.size();
            int i = 0;
            while (i < numberOfFiles) {
                try {
                    file.delete((String)files.elementAt(i));
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                ++i;
            }
            if (!this.removeFromSuiteList(storageName) && numberOfFiles == 0) {
                throw new IllegalArgumentException("Could not find " + storageName);
            }
        }
    }

    public boolean execute(String storageName, String midlet) throws SecurityException {
        this.nextMidletSuiteToRun = storageName;
        this.nextMidletToRun = midlet;
        return true;
    }

    public String getNextMIDletSuiteToRun() {
        return this.nextMidletSuiteToRun;
    }

    public String getNextMIDletToRun() {
        return this.nextMidletToRun;
    }

    public String[] list() {
        Vector suiteList = this.getSuiteList();
        String[] array = new String[suiteList.size()];
        int i = 0;
        while (i < suiteList.size()) {
            array[i] = (String)suiteList.elementAt(i);
            ++i;
        }
        return array;
    }

    public boolean suiteExists(String storageName) {
        Vector suiteList = this.getSuiteList();
        int i = 0;
        while (i < suiteList.size()) {
            if (suiteList.elementAt(i).equals(storageName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Vector getSuiteList() {
        if (this.midletSuiteList != null) {
            return this.midletSuiteList;
        }
        this.midletSuiteList = new Vector();
        try {
            RandomAccessStream storage = new RandomAccessStream(classSecurityDomain);
            storage.connect(File.getStorageRoot() + SUITE_LIST_FILENAME, 1);
            try {
                String line;
                DataInputStream in = storage.openDataInputStream();
                while ((line = in.readUTF()) != null) {
                    this.midletSuiteList.addElement(line);
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                storage.disconnect();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return this.midletSuiteList;
    }

    private void addToSuiteList(String storageName) {
        if (this.suiteExists(storageName)) {
            return;
        }
        Vector suiteList = this.getSuiteList();
        suiteList.addElement(storageName);
        this.saveSuiteList(suiteList);
    }

    private boolean removeFromSuiteList(String storageName) {
        if (!this.suiteExists(storageName)) {
            return false;
        }
        Vector suiteList = this.getSuiteList();
        suiteList.removeElement(storageName);
        this.saveSuiteList(suiteList);
        return true;
    }

    private void saveSuiteList(Vector list) {
        File file = new File(classSecurityDomain);
        RandomAccessStream storage = new RandomAccessStream(classSecurityDomain);
        String filename = File.getStorageRoot() + SUITE_LIST_FILENAME;
        try {
            file.delete(filename);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            storage.connect(filename, -3);
            try {
                DataOutputStream out = storage.openDataOutputStream();
                int i = 0;
                while (i < list.size()) {
                    String line = (String)list.elementAt(i);
                    out.writeUTF(line);
                    ++i;
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                storage.disconnect();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    String getDomainOwner(String storageRoot) {
        RandomAccessStream myStorage = new RandomAccessStream(classSecurityDomain);
        try {
            String domainOwner;
            myStorage.connect(storageRoot + DOMAIN_OWNER_FILENAME, 1);
            try {
                DataInputStream dataStream = myStorage.openDataInputStream();
                domainOwner = dataStream.readUTF();
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                myStorage.disconnect();
            }
            return domainOwner;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private class InstallStateImpl
    implements InstallState {
        private long startTime;
        private int nextStep;
        private boolean stopInstallation;
        private boolean writingSuite;
        private InvalidJadException exception;
        private String jadUrl;
        private String previousJadUrl;
        private boolean force;
        private byte[] jad;
        private String jadEncoding;
        private String cookie;
        private JadProperties jadProps;
        private File file;
        private String username;
        private String password;
        private String suiteName;
        private String vendor;
        private String version;
        private String storageName;
        private String domainOwner;
        private int expectedJarSize;
        private boolean isPreviousVersion;

        private InstallStateImpl() {
        }

        public InvalidJadException getLastException() {
            return this.exception;
        }

        public String getStorageName() {
            return this.storageName;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        static /* synthetic */ byte[] access$402(InstallStateImpl x0, byte[] x1) {
            x0.jad = x1;
            return x1;
        }
    }
}

