/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io;

import com.sun.cldc.io.ConnectionBaseInterface;
import com.sun.midp.Configuration;
import com.sun.midp.io.j2me.http.Protocol;
import java.io.IOException;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;

public class InternalConnector {
    private static String platform;
    private static boolean j2me;
    private static String midpRoot;
    private static String cldcRoot;
    private static boolean enableAllProtocols;

    private InternalConnector() {
    }

    public static Connection openInternal(String name, int mode, boolean timeouts) throws IOException {
        try {
            return InternalConnector.openPrim(name, mode, timeouts, midpRoot);
        }
        catch (ClassNotFoundException x) {
            try {
                return InternalConnector.openPrim(name, mode, timeouts, cldcRoot);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ConnectionNotFoundException("The requested protocol does not exist " + name);
            }
        }
    }

    public static Connection open(String name, int mode, boolean timeouts) throws IOException {
        try {
            return InternalConnector.openPrim(name, mode, timeouts, midpRoot);
        }
        catch (ClassNotFoundException x) {
            if (enableAllProtocols) {
                try {
                    return InternalConnector.openPrim(name, mode, timeouts, cldcRoot);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw new ConnectionNotFoundException("The requested protocol does not exist " + name);
        }
    }

    private static Connection openPrim(String name, int mode, boolean timeouts, String root) throws IOException, ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("Null URL");
        }
        int colon = name.indexOf(58);
        if (colon < 1) {
            throw new IllegalArgumentException("no ':' in URL");
        }
        try {
            String altHandler;
            String protocol = name.substring(0, colon);
            name = name.substring(colon + 1);
            if (protocol.equals("file")) {
                protocol = "storage";
            }
            if ((altHandler = Configuration.getProperty("com.sun.midp.io.Connector.impl." + protocol)) != null) {
                try {
                    return ((ConnectionBaseInterface)Class.forName(altHandler).newInstance()).openPrim(name, mode, timeouts);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (protocol.equals("http")) {
                Protocol hc = new Protocol();
                return hc.openPrim(name, mode, timeouts);
            }
            if (protocol.equals("https") && !enableAllProtocols) {
                throw new ClassNotFoundException("https is not enabled");
            }
            Class clazz = Class.forName(root + "." + protocol + ".Protocol");
            ConnectionBaseInterface uc = (ConnectionBaseInterface)clazz.newInstance();
            return uc.openPrim(name, mode, timeouts);
        }
        catch (InstantiationException x) {
            throw new IOException(x.toString());
        }
        catch (IllegalAccessException x) {
            throw new IOException(x.toString());
        }
        catch (ClassCastException x) {
            throw new IOException(x.toString());
        }
    }

    static {
        if (Configuration.getProperty("microedition.configuration") != null) {
            j2me = true;
        }
        if ((platform = Configuration.getProperty("microedition.platform")) == null) {
            platform = j2me ? "j2me" : "j2se";
        }
        midpRoot = "com.sun.midp.io." + platform;
        cldcRoot = "com.sun.cldc.io." + platform;
        String prop = Configuration.getProperty("com.sun.midp.io.enable_extra_protocols");
        if (prop != null) {
            enableAllProtocols = prop.equals("true");
        }
    }
}

