/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.ParameterTypes;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.cli.Options;

public abstract class JavaCallable
implements ParameterTypes {
    protected final Class<?>[] parameterTypes;
    private static final boolean REWRITE_JAVA_TRACE = Options.REWRITE_JAVA_TRACE.load();

    protected JavaCallable(Class<?>[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    @Override
    public final int getArity() {
        return this.parameterTypes.length;
    }

    @Override
    public final Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public abstract int getModifiers();

    @Override
    public abstract Class<?>[] getExceptionTypes();

    public abstract Type[] getGenericExceptionTypes();

    public abstract Type[] getGenericParameterTypes();

    public abstract Annotation[][] getParameterAnnotations();

    @Override
    public abstract boolean isVarArgs();

    public abstract String toGenericString();

    public abstract AccessibleObject accessibleObject();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public String toString() {
        return this.accessibleObject().toString();
    }

    protected final void checkArity(ThreadContext context, int length2) {
        if (length2 != this.getArity()) {
            throw context.runtime.newArgumentError(length2, this.getArity());
        }
    }

    protected final IRubyObject handleThrowable(ThreadContext context, Throwable ex) {
        if (ex instanceof JumpException) {
            throw (JumpException)ex;
        }
        if (REWRITE_JAVA_TRACE) {
            Helpers.rewriteStackTraceAndThrow(context, ex);
        }
        Helpers.throwException(ex);
        return null;
    }

    protected final IRubyObject handleInvocationTargetEx(ThreadContext context, InvocationTargetException ex) {
        return this.handleThrowable(context, ex.getTargetException());
    }

    final IRubyObject handleIllegalAccessEx(ThreadContext context, IllegalAccessException ex, Member target2) throws RaiseException {
        throw context.runtime.newTypeError("illegal access on '" + target2.getName() + "': " + ex.getMessage());
    }

    final IRubyObject handleIllegalAccessEx(ThreadContext context, IllegalAccessException ex, Constructor target2) throws RaiseException {
        throw context.runtime.newTypeError("illegal access on constructor for type '" + target2.getDeclaringClass().getSimpleName() + "': " + ex.getMessage());
    }

    final IRubyObject handlelIllegalArgumentEx(ThreadContext context, IllegalArgumentException ex, Method target2, Object ... arguments) throws RaiseException {
        StringBuilder msg = new StringBuilder(64);
        msg.append("for method ").append(target2.getDeclaringClass().getSimpleName()).append('.').append(target2.getName());
        msg.append(" expected ");
        this.dumpParameterTypes(msg);
        msg.append("; got: ");
        JavaCallable.dumpArgTypes(arguments, msg);
        msg.append("; error: ").append(ex.getMessage());
        throw context.runtime.newTypeError(msg.toString());
    }

    final IRubyObject handlelIllegalArgumentEx(ThreadContext context, IllegalArgumentException ex, Constructor target2, Object ... arguments) throws RaiseException {
        return this.handlelIllegalArgumentEx(context, ex, target2, true, arguments);
    }

    final IRubyObject handlelIllegalArgumentEx(ThreadContext context, IllegalArgumentException ex, Constructor target2, boolean targetInfo, Object ... arguments) throws RaiseException {
        StringBuilder msg = new StringBuilder(64);
        if (targetInfo) {
            msg.append("for constructor of type ").append(target2.getDeclaringClass().getSimpleName());
        }
        msg.append(" expected ");
        this.dumpParameterTypes(msg);
        msg.append("; got: ");
        JavaCallable.dumpArgTypes(arguments, msg);
        msg.append("; error: ").append(ex.getMessage());
        throw context.runtime.newTypeError(msg.toString());
    }

    private void dumpParameterTypes(StringBuilder str) {
        str.append('[');
        JavaCallable.inspectParameterTypes(str, this, false);
        str.append(']');
    }

    static CharSequence dumpArgTypes(Object[] args2, StringBuilder str) {
        str.append('[');
        for (int i2 = 0; i2 < args2.length; ++i2) {
            if (i2 > 0) {
                str.append(',');
            }
            if (args2[i2] == null) {
                str.append("null");
                continue;
            }
            str.append(args2[i2].getClass().getName());
        }
        str.append(']');
        return str;
    }

    public static StringBuilder inspectParameterTypes(StringBuilder str, ParameterTypes target2) {
        return JavaCallable.inspectParameterTypes(str, target2, true);
    }

    private static StringBuilder inspectParameterTypes(StringBuilder str, ParameterTypes target2, boolean brackets) {
        if (brackets) {
            str.append('(');
        }
        Class<?>[] types = target2.getParameterTypes();
        for (int i2 = 0; i2 < types.length; ++i2) {
            str.append(types[i2].getName());
            if (i2 >= types.length - 1) continue;
            str.append(',');
        }
        if (brackets) {
            str.append(')');
        }
        return str;
    }
}

