
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: menu_base.c 2579 2007-07-22 13:30:26Z mschwerin $
 *
 */
#include "config.h"

#include <assert.h>

#include "mutex.h"
#include "oxine.h"
#include "utils_gui.h"

#include "menu_base.h"
#include "menu_main.h"
#include "menu_playback.h"

extern oxine_t *oxine;

static otk_cb_t current_menu = NULL;
static void *current_menu_data = NULL;

static otk_cb_t backto_menu = NULL;
static void *backto_menu_data = NULL;

static otk_cb_t playback_ended_menu = NULL;
static void *playback_ended_menu_data = NULL;


bool
is_current_menu (otk_cb_t menu)
{
    assert (menu);
    return (current_menu == menu);
}


void
set_current_menu (otk_cb_t menu, void *menu_data)
{
    assert (menu);
    current_menu = menu;
    current_menu_data = menu_data;
}


otk_cb_t
get_current_menu (void)
{
    return current_menu;
}


void *
get_current_menu_data (void)
{
    return current_menu_data;
}


void
set_backto_menu (otk_cb_t menu, void *menu_data)
{
    assert (menu);
    backto_menu = menu;
    backto_menu_data = menu_data;
}


void
show_menu_backto (void)
{
    if (!backto_menu) {
        show_menu_main (oxine);
    }
    else {
        backto_menu (backto_menu_data);
    }
}


void
backto_menu_cb (void *p)
{
    show_menu_backto ();
}


void
show_menu_current (void)
{
    if (!current_menu) {
        show_menu_main (oxine);
    }
    else {
        current_menu (current_menu_data);
    }
}


void
set_playback_ended_menu (otk_cb_t menu, void *menu_data)
{
    assert (menu);
    playback_ended_menu = menu;
    playback_ended_menu_data = menu_data;
}


void
playback_ended_menu_cb (void *data_p)
{
    if (!playback_ended_menu) {
        show_menu_main (oxine);
    }
    else if (is_current_menu (hide_user_interface)
        || is_current_menu (repaint_message_dialog)
        || is_current_menu (show_menu_playback)
        || is_current_menu (show_playback_info)
        || is_current_menu (show_playback_controls)
        || is_current_menu (show_playback_settings)
        || is_current_menu (show_playback_settings_two)) {
        playback_ended_menu (oxine);
    }
    else {
        show_menu_current ();
    }
}
