package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVsPullStreamInfoConfig invokes the vs.DescribeVsPullStreamInfoConfig API synchronously
func (client *Client) DescribeVsPullStreamInfoConfig(request *DescribeVsPullStreamInfoConfigRequest) (response *DescribeVsPullStreamInfoConfigResponse, err error) {
	response = CreateDescribeVsPullStreamInfoConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVsPullStreamInfoConfigWithChan invokes the vs.DescribeVsPullStreamInfoConfig API asynchronously
func (client *Client) DescribeVsPullStreamInfoConfigWithChan(request *DescribeVsPullStreamInfoConfigRequest) (<-chan *DescribeVsPullStreamInfoConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeVsPullStreamInfoConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVsPullStreamInfoConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVsPullStreamInfoConfigWithCallback invokes the vs.DescribeVsPullStreamInfoConfig API asynchronously
func (client *Client) DescribeVsPullStreamInfoConfigWithCallback(request *DescribeVsPullStreamInfoConfigRequest, callback func(response *DescribeVsPullStreamInfoConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVsPullStreamInfoConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeVsPullStreamInfoConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVsPullStreamInfoConfigRequest is the request struct for api DescribeVsPullStreamInfoConfig
type DescribeVsPullStreamInfoConfigRequest struct {
	*requests.RpcRequest
	ShowLog    string           `position:"Query" name:"ShowLog"`
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeVsPullStreamInfoConfigResponse is the response struct for api DescribeVsPullStreamInfoConfig
type DescribeVsPullStreamInfoConfigResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	LiveAppRecordList LiveAppRecordList `json:"LiveAppRecordList" xml:"LiveAppRecordList"`
}

// CreateDescribeVsPullStreamInfoConfigRequest creates a request to invoke DescribeVsPullStreamInfoConfig API
func CreateDescribeVsPullStreamInfoConfigRequest() (request *DescribeVsPullStreamInfoConfigRequest) {
	request = &DescribeVsPullStreamInfoConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeVsPullStreamInfoConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeVsPullStreamInfoConfigResponse creates a response to parse from DescribeVsPullStreamInfoConfig response
func CreateDescribeVsPullStreamInfoConfigResponse() (response *DescribeVsPullStreamInfoConfigResponse) {
	response = &DescribeVsPullStreamInfoConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
