package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyGatewayFileShareWatermark invokes the sgw.ModifyGatewayFileShareWatermark API synchronously
func (client *Client) ModifyGatewayFileShareWatermark(request *ModifyGatewayFileShareWatermarkRequest) (response *ModifyGatewayFileShareWatermarkResponse, err error) {
	response = CreateModifyGatewayFileShareWatermarkResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyGatewayFileShareWatermarkWithChan invokes the sgw.ModifyGatewayFileShareWatermark API asynchronously
func (client *Client) ModifyGatewayFileShareWatermarkWithChan(request *ModifyGatewayFileShareWatermarkRequest) (<-chan *ModifyGatewayFileShareWatermarkResponse, <-chan error) {
	responseChan := make(chan *ModifyGatewayFileShareWatermarkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyGatewayFileShareWatermark(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyGatewayFileShareWatermarkWithCallback invokes the sgw.ModifyGatewayFileShareWatermark API asynchronously
func (client *Client) ModifyGatewayFileShareWatermarkWithCallback(request *ModifyGatewayFileShareWatermarkRequest, callback func(response *ModifyGatewayFileShareWatermarkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyGatewayFileShareWatermarkResponse
		var err error
		defer close(result)
		response, err = client.ModifyGatewayFileShareWatermark(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyGatewayFileShareWatermarkRequest is the request struct for api ModifyGatewayFileShareWatermark
type ModifyGatewayFileShareWatermarkRequest struct {
	*requests.RpcRequest
	Watermark     requests.Integer `position:"Query" name:"Watermark"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	IndexId       string           `position:"Query" name:"IndexId"`
	GatewayId     string           `position:"Query" name:"GatewayId"`
}

// ModifyGatewayFileShareWatermarkResponse is the response struct for api ModifyGatewayFileShareWatermark
type ModifyGatewayFileShareWatermarkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateModifyGatewayFileShareWatermarkRequest creates a request to invoke ModifyGatewayFileShareWatermark API
func CreateModifyGatewayFileShareWatermarkRequest() (request *ModifyGatewayFileShareWatermarkRequest) {
	request = &ModifyGatewayFileShareWatermarkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "ModifyGatewayFileShareWatermark", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyGatewayFileShareWatermarkResponse creates a response to parse from ModifyGatewayFileShareWatermark response
func CreateModifyGatewayFileShareWatermarkResponse() (response *ModifyGatewayFileShareWatermarkResponse) {
	response = &ModifyGatewayFileShareWatermarkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
