package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMountTarget invokes the nas.DeleteMountTarget API synchronously
func (client *Client) DeleteMountTarget(request *DeleteMountTargetRequest) (response *DeleteMountTargetResponse, err error) {
	response = CreateDeleteMountTargetResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMountTargetWithChan invokes the nas.DeleteMountTarget API asynchronously
func (client *Client) DeleteMountTargetWithChan(request *DeleteMountTargetRequest) (<-chan *DeleteMountTargetResponse, <-chan error) {
	responseChan := make(chan *DeleteMountTargetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMountTarget(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMountTargetWithCallback invokes the nas.DeleteMountTarget API asynchronously
func (client *Client) DeleteMountTargetWithCallback(request *DeleteMountTargetRequest, callback func(response *DeleteMountTargetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMountTargetResponse
		var err error
		defer close(result)
		response, err = client.DeleteMountTarget(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMountTargetRequest is the request struct for api DeleteMountTarget
type DeleteMountTargetRequest struct {
	*requests.RpcRequest
	FileSystemId      string `position:"Query" name:"FileSystemId"`
	MountTargetDomain string `position:"Query" name:"MountTargetDomain"`
}

// DeleteMountTargetResponse is the response struct for api DeleteMountTarget
type DeleteMountTargetResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteMountTargetRequest creates a request to invoke DeleteMountTarget API
func CreateDeleteMountTargetRequest() (request *DeleteMountTargetRequest) {
	request = &DeleteMountTargetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "DeleteMountTarget", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteMountTargetResponse creates a response to parse from DeleteMountTarget response
func CreateDeleteMountTargetResponse() (response *DeleteMountTargetResponse) {
	response = &DeleteMountTargetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
