package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLiveStreamMonitor invokes the live.DeleteLiveStreamMonitor API synchronously
func (client *Client) DeleteLiveStreamMonitor(request *DeleteLiveStreamMonitorRequest) (response *DeleteLiveStreamMonitorResponse, err error) {
	response = CreateDeleteLiveStreamMonitorResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLiveStreamMonitorWithChan invokes the live.DeleteLiveStreamMonitor API asynchronously
func (client *Client) DeleteLiveStreamMonitorWithChan(request *DeleteLiveStreamMonitorRequest) (<-chan *DeleteLiveStreamMonitorResponse, <-chan error) {
	responseChan := make(chan *DeleteLiveStreamMonitorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLiveStreamMonitor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLiveStreamMonitorWithCallback invokes the live.DeleteLiveStreamMonitor API asynchronously
func (client *Client) DeleteLiveStreamMonitorWithCallback(request *DeleteLiveStreamMonitorRequest, callback func(response *DeleteLiveStreamMonitorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLiveStreamMonitorResponse
		var err error
		defer close(result)
		response, err = client.DeleteLiveStreamMonitor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLiveStreamMonitorRequest is the request struct for api DeleteLiveStreamMonitor
type DeleteLiveStreamMonitorRequest struct {
	*requests.RpcRequest
	MonitorId string           `position:"Query" name:"MonitorId"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteLiveStreamMonitorResponse is the response struct for api DeleteLiveStreamMonitor
type DeleteLiveStreamMonitorResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLiveStreamMonitorRequest creates a request to invoke DeleteLiveStreamMonitor API
func CreateDeleteLiveStreamMonitorRequest() (request *DeleteLiveStreamMonitorRequest) {
	request = &DeleteLiveStreamMonitorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteLiveStreamMonitor", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteLiveStreamMonitorResponse creates a response to parse from DeleteLiveStreamMonitor response
func CreateDeleteLiveStreamMonitorResponse() (response *DeleteLiveStreamMonitorResponse) {
	response = &DeleteLiveStreamMonitorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
