package dbfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateConstants invokes the dbfs.UpdateConstants API synchronously
func (client *Client) UpdateConstants(request *UpdateConstantsRequest) (response *UpdateConstantsResponse, err error) {
	response = CreateUpdateConstantsResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateConstantsWithChan invokes the dbfs.UpdateConstants API asynchronously
func (client *Client) UpdateConstantsWithChan(request *UpdateConstantsRequest) (<-chan *UpdateConstantsResponse, <-chan error) {
	responseChan := make(chan *UpdateConstantsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateConstants(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateConstantsWithCallback invokes the dbfs.UpdateConstants API asynchronously
func (client *Client) UpdateConstantsWithCallback(request *UpdateConstantsRequest, callback func(response *UpdateConstantsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateConstantsResponse
		var err error
		defer close(result)
		response, err = client.UpdateConstants(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateConstantsRequest is the request struct for api UpdateConstants
type UpdateConstantsRequest struct {
	*requests.RpcRequest
	PageNumber    requests.Integer `position:"Query" name:"PageNumber"`
	ConstantsData string           `position:"Query" name:"ConstantsData"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
}

// UpdateConstantsResponse is the response struct for api UpdateConstants
type UpdateConstantsResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Data       string `json:"Data" xml:"Data"`
	PageSize   int64  `json:"PageSize" xml:"PageSize"`
	TotalCount int64  `json:"TotalCount" xml:"TotalCount"`
	PageNumber int64  `json:"PageNumber" xml:"PageNumber"`
}

// CreateUpdateConstantsRequest creates a request to invoke UpdateConstants API
func CreateUpdateConstantsRequest() (request *UpdateConstantsRequest) {
	request = &UpdateConstantsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DBFS", "2020-04-18", "UpdateConstants", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateConstantsResponse creates a response to parse from UpdateConstants response
func CreateUpdateConstantsResponse() (response *UpdateConstantsResponse) {
	response = &UpdateConstantsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
