/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.testing.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class TestServer
implements Runnable {
    private static final boolean debug = Boolean.getBoolean("org.aspectj.testing.server.debug");
    private boolean exitOnError = true;
    private File workingDirectory;
    private ClassLoader rootLoader;
    private Map loaders = new HashMap();
    private String mainClass = "UnknownClass";
    private String mainLoader = "UnknownLoader";

    public void initialize() throws IOException {
        this.createRootLoader();
        this.loadConfiguration();
    }

    private void loadConfiguration() throws IOException {
        File file = new File(this.workingDirectory, "server.properties");
        Properties props = new Properties();
        FileInputStream in = new FileInputStream(file);
        props.load(in);
        in.close();
        Enumeration<?> enu = props.propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            if (key.startsWith("loader.")) {
                this.createLoader(props.getProperty(key));
                continue;
            }
            if (!key.equals("main")) continue;
            StringTokenizer st = new StringTokenizer(props.getProperty(key), ",");
            this.mainClass = st.nextToken();
            this.mainLoader = st.nextToken();
        }
    }

    private void createLoader(String property) throws IOException {
        String parentName;
        ClassLoader parent = this.rootLoader;
        StringTokenizer st = new StringTokenizer(property, ",");
        String name = st.nextToken();
        String classpath = st.nextToken();
        if (st.hasMoreTokens() && (parent = (ClassLoader)this.loaders.get(parentName = st.nextToken())) == null) {
            this.error("No such loader: " + parentName);
        }
        ArrayList<URL> urlList = new ArrayList<URL>();
        st = new StringTokenizer(classpath, ";");
        while (st.hasMoreTokens()) {
            String fileName = st.nextToken();
            File file = new File(this.workingDirectory, fileName).getCanonicalFile();
            if (!file.exists()) {
                this.error("Missing or invalid file: " + file.getPath());
            }
            URL url = file.toURL();
            urlList.add(url);
        }
        URL[] urls = new URL[urlList.size()];
        urlList.toArray(urls);
        URLClassLoader loader = new URLClassLoader(urls, parent);
        if (debug) {
            System.err.println("? TestServer.createLoader() loader=" + loader + ", name='" + name + "', urls=" + urlList + ", parent=" + parent);
        }
        this.loaders.put(name, loader);
    }

    private void createRootLoader() throws IOException {
        ArrayList<URL> urlList = new ArrayList<URL>();
        URL url = this.workingDirectory.getCanonicalFile().toURL();
        urlList.add(url);
        URL[] urls = ((URLClassLoader)this.getClass().getClassLoader()).getURLs();
        for (int i = 0; i < urls.length; ++i) {
            url = urls[i];
            String file = url.getFile();
            if (debug) {
                System.err.println("? TestServer.createRootLoader() " + file);
            }
            if (file.indexOf("runtime") == -1 && file.indexOf("aspectjrt") == -1 && file.indexOf("aspectj5rt") == -1) continue;
            urlList.add(url);
        }
        urls = new URL[urlList.size()];
        urlList.toArray(urls);
        ClassLoader parent = this.getClass().getClassLoader().getParent();
        this.rootLoader = new URLClassLoader(urls, parent);
        if (debug) {
            System.err.println("? TestServer.createRootLoader() loader=" + this.rootLoader + ", urlList=" + urlList + ", parent=" + parent);
        }
    }

    public void setExitOntError(boolean b) {
        this.exitOnError = b;
    }

    public void setWorkingDirectory(String name) {
        this.workingDirectory = new File(name);
        if (!this.workingDirectory.exists()) {
            this.error("Missing or invalid working directory: " + this.workingDirectory.getPath());
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Starting ...");
        TestServer server = new TestServer();
        server.setWorkingDirectory(args[0]);
        server.initialize();
        Thread thread = new Thread((Runnable)server, "application");
        thread.start();
        thread.join();
        System.out.println("Stopping ...");
    }

    public void run() {
        System.out.println("Running " + this.mainClass);
        this.runClass(this.mainClass, (ClassLoader)this.loaders.get(this.mainLoader));
    }

    private void runClass(String className, ClassLoader classLoader) {
        try {
            Class<?> clazz = Class.forName(className, false, classLoader);
            this.invokeMain(clazz, new String[0]);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            this.error(ex.toString());
        }
    }

    public void invokeMain(Class clazz, String[] args) {
        Class[] paramTypes = new Class[]{args.getClass()};
        try {
            Method method = clazz.getDeclaredMethod("main", paramTypes);
            Object[] params = new Object[]{args};
            method.invoke(null, params);
        }
        catch (InvocationTargetException ex) {
            Throwable th = ex.getTargetException();
            th.printStackTrace();
            this.error(th.toString());
        }
        catch (Throwable th) {
            th.printStackTrace();
            this.error(th.toString());
        }
    }

    private void error(String message) {
        System.out.println(message);
        if (this.exitOnError) {
            System.exit(0);
        }
    }
}

