/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import org.aspectj.weaver.AnnotatedElement;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.World;

public class TypeX
implements AnnotatedElement {
    protected String signature;
    protected TypeX[] typeParameters;
    public static final TypeX[] NONE = new TypeX[0];
    public static final TypeX OBJECT = TypeX.forSignature("Ljava/lang/Object;");
    public static final TypeX OBJECTARRAY = TypeX.forSignature("[Ljava/lang/Object;");
    public static final TypeX CLONEABLE = TypeX.forSignature("Ljava/lang/Cloneable;");
    public static final TypeX SERIALIZABLE = TypeX.forSignature("Ljava/io/Serializable;");
    public static final TypeX THROWABLE = TypeX.forSignature("Ljava/lang/Throwable;");
    public static final TypeX RUNTIME_EXCEPTION = TypeX.forSignature("Ljava/lang/RuntimeException;");
    public static final TypeX ERROR = TypeX.forSignature("Ljava/lang/Error;");
    public static final TypeX AT_INHERITED = TypeX.forSignature("Ljava/lang/annotation/Inherited;");
    public static final TypeX AT_RETENTION = TypeX.forSignature("Ljava/lang/annotation/Retention;");
    public static final TypeX ENUM = TypeX.forSignature("Ljava/lang/Enum;");
    public static final TypeX ANNOTATION = TypeX.forSignature("Ljava/lang/annotation/Annotation;");
    public static final TypeX JAVA_LANG_CLASS = TypeX.forSignature("Ljava/lang/Class;");
    public static final TypeX JAVA_LANG_EXCEPTION = TypeX.forSignature("Ljava/lang/Exception;");
    public static final TypeX JAVA_LANG_REFLECT_METHOD = TypeX.forSignature("Ljava/lang/reflect/Method;");
    public static final TypeX SUPPRESS_AJ_WARNINGS = TypeX.forSignature("Lorg/aspectj/lang/annotation/SuppressAjWarnings;");
    public static final TypeX AT_TARGET = TypeX.forSignature("Ljava/lang/annotation/Target;");
    public static final String MISSING_NAME = "<missing>";

    protected TypeX(String signature) {
        this.signature = signature;
    }

    public int getSize() {
        return 1;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TypeX)) {
            return false;
        }
        return this.signature.equals(((TypeX)other).signature);
    }

    public final int hashCode() {
        return this.signature.hashCode();
    }

    public static TypeX makeArray(TypeX base, int dims) {
        StringBuffer sig = new StringBuffer();
        for (int i = 0; i < dims; ++i) {
            sig.append("[");
        }
        sig.append(base.getSignature());
        return TypeX.forSignature(sig.toString());
    }

    public static TypeX forName(String name) {
        return TypeX.forSignature(TypeX.nameToSignature(name));
    }

    public static TypeX[] forNames(String[] names) {
        TypeX[] ret = new TypeX[names.length];
        int len = names.length;
        for (int i = 0; i < len; ++i) {
            ret[i] = TypeX.forName(names[i]);
        }
        return ret;
    }

    public static TypeX forParameterizedTypeNames(String name, String[] paramTypeNames) {
        TypeX ret = TypeX.forName(name);
        ret.typeParameters = new TypeX[paramTypeNames.length];
        for (int i = 0; i < paramTypeNames.length; ++i) {
            ret.typeParameters[i] = TypeX.forName(paramTypeNames[i]);
        }
        StringBuffer sigAddition = new StringBuffer();
        sigAddition.append("<");
        for (int i = 0; i < ret.typeParameters.length; ++i) {
            sigAddition.append(ret.typeParameters[i].signature);
            sigAddition.append(">");
            sigAddition.append(";");
        }
        ret.signature = ret.signature + sigAddition.toString();
        return ret;
    }

    public static TypeX[] add(TypeX[] types, TypeX end) {
        int len = types.length;
        TypeX[] ret = new TypeX[len + 1];
        System.arraycopy(types, 0, ret, 0, len);
        ret[len] = end;
        return ret;
    }

    public static TypeX[] insert(TypeX start, TypeX[] types) {
        int len = types.length;
        TypeX[] ret = new TypeX[len + 1];
        ret[0] = start;
        System.arraycopy(types, 0, ret, 1, len);
        return ret;
    }

    public static TypeX forSignature(String signature) {
        switch (signature.charAt(0)) {
            case 'B': {
                return ResolvedTypeX.BYTE;
            }
            case 'C': {
                return ResolvedTypeX.CHAR;
            }
            case 'D': {
                return ResolvedTypeX.DOUBLE;
            }
            case 'F': {
                return ResolvedTypeX.FLOAT;
            }
            case 'I': {
                return ResolvedTypeX.INT;
            }
            case 'J': {
                return ResolvedTypeX.LONG;
            }
            case 'L': {
                return new TypeX(signature);
            }
            case 'S': {
                return ResolvedTypeX.SHORT;
            }
            case 'V': {
                return ResolvedTypeX.VOID;
            }
            case 'Z': {
                return ResolvedTypeX.BOOLEAN;
            }
            case '[': {
                return new TypeX(signature);
            }
        }
        throw new BCException("Bad type signature " + signature);
    }

    public static TypeX[] forSignatures(String[] sigs) {
        TypeX[] ret = new TypeX[sigs.length];
        int len = sigs.length;
        for (int i = 0; i < len; ++i) {
            ret[i] = TypeX.forSignature(sigs[i]);
        }
        return ret;
    }

    public String getName() {
        return TypeX.signatureToName(this.signature);
    }

    public String getBaseName() {
        String name = this.getName();
        if (this.isParameterized()) {
            return name.substring(0, name.indexOf("<"));
        }
        return name;
    }

    public static String[] getNames(TypeX[] types) {
        String[] ret = new String[types.length];
        int len = types.length;
        for (int i = 0; i < len; ++i) {
            ret[i] = types[i].getName();
        }
        return ret;
    }

    public String getSignature() {
        return this.signature;
    }

    public final boolean isArray() {
        return this.signature.startsWith("[");
    }

    public final boolean isParameterized() {
        return this.signature.indexOf("<") != -1;
    }

    public TypeX getOutermostType() {
        if (this.isArray() || this.isPrimitive()) {
            return this;
        }
        String sig = this.getSignature();
        int dollar = sig.indexOf(36);
        if (dollar != -1) {
            return TypeX.forSignature(sig.substring(0, dollar) + ';');
        }
        return this;
    }

    public TypeX getComponentType() {
        if (this.isArray()) {
            return TypeX.forSignature(this.signature.substring(1));
        }
        return null;
    }

    public boolean isPrimitive() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public ResolvedPointcutDefinition findPointcut(String name, World world) {
        return world.findPointcut(this, name);
    }

    public final boolean isConvertableFrom(TypeX other, World world) {
        if (this.equals(OBJECT)) {
            return true;
        }
        if (this.isPrimitive() || other.isPrimitive()) {
            return this.isAssignableFrom(other, world);
        }
        return this.isCoerceableFrom(other, world);
    }

    public boolean needsNoConversionFrom(TypeX other, World world) {
        if (other.isPrimitive()) {
            return false;
        }
        return world.needsNoConversionFrom(this, other);
    }

    public boolean isAssignableFrom(TypeX other, World world) {
        if (other.isPrimitive() && !world.behaveInJava5Way) {
            return false;
        }
        return world.isAssignableFrom(this, other);
    }

    public boolean isCoerceableFrom(TypeX other, World world) {
        if (other.isPrimitive()) {
            return false;
        }
        return world.isCoerceableFrom(this, other);
    }

    public final boolean isInterface(World world) {
        return world.resolve(this).isInterface();
    }

    public final boolean isClass(World world) {
        return world.resolve(this).isClass();
    }

    public final boolean isEnum(World world) {
        return world.resolve(this).isEnum();
    }

    public final boolean isAnnotation(World world) {
        return world.resolve(this).isAnnotation();
    }

    public final boolean isAnnotationWithRuntimeRetention(World world) {
        return world.resolve(this).isAnnotationWithRuntimeRetention();
    }

    public final boolean isAspect(World world) {
        return world.resolve(this).isAspect();
    }

    public TypeX getSuperclass(World world) {
        return world.getSuperclass(this);
    }

    public TypeX[] getDeclaredInterfaces(World world) {
        return world.getDeclaredInterfaces(this);
    }

    public Iterator getDirectSupertypes(World world) {
        return world.resolve(this).getDirectSupertypes();
    }

    public int getModifiers(World world) {
        return world.getModifiers(this);
    }

    public ResolvedMember[] getDeclaredFields(World world) {
        return world.getDeclaredFields(this);
    }

    public ResolvedMember[] getDeclaredMethods(World world) {
        return world.getDeclaredMethods(this);
    }

    public ResolvedMember[] getDeclaredPointcuts(World world) {
        return world.getDeclaredPointcuts(this);
    }

    public ResolvedTypeX resolve(World world) {
        return world.resolve(this);
    }

    public boolean hasAnnotation(TypeX ofType) {
        throw new UnsupportedOperationException("You should resolve this member and call hasAnnotation() on the result...");
    }

    public ResolvedTypeX[] getAnnotationTypes() {
        throw new UnsupportedOperationException("You should resolve this member and call hasAnnotation() on the result...");
    }

    private static String signatureToName(String signature) {
        switch (signature.charAt(0)) {
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'L': {
                String name = signature.substring(1, signature.length() - 1).replace('/', '.');
                if (name.indexOf("<") == -1) {
                    return name;
                }
                StringBuffer nameBuff = new StringBuffer();
                boolean justSeenLeftArrowChar = false;
                boolean justSeenSemiColon = false;
                int paramNestLevel = 0;
                block19: for (int i = 0; i < name.length(); ++i) {
                    char c = name.charAt(i);
                    switch (c) {
                        case '<': {
                            justSeenLeftArrowChar = true;
                            ++paramNestLevel;
                            nameBuff.append(c);
                            continue block19;
                        }
                        case ';': {
                            justSeenSemiColon = true;
                            continue block19;
                        }
                        case '>': {
                            --paramNestLevel;
                            nameBuff.append(c);
                            continue block19;
                        }
                        case 'L': {
                            if (justSeenLeftArrowChar) {
                                justSeenLeftArrowChar = false;
                                continue block19;
                            }
                            if (justSeenSemiColon) {
                                nameBuff.append(",");
                                continue block19;
                            }
                            nameBuff.append("L");
                            continue block19;
                        }
                        default: {
                            justSeenSemiColon = false;
                            justSeenLeftArrowChar = false;
                            nameBuff.append(c);
                        }
                    }
                }
                return nameBuff.toString();
            }
            case 'S': {
                return "short";
            }
            case 'V': {
                return "void";
            }
            case 'Z': {
                return "boolean";
            }
            case '[': {
                return TypeX.signatureToName(signature.substring(1, signature.length())) + "[]";
            }
        }
        throw new BCException("Bad type signature: " + signature);
    }

    private static String nameToSignature(String name) {
        if (name.equals("byte")) {
            return "B";
        }
        if (name.equals("char")) {
            return "C";
        }
        if (name.equals("double")) {
            return "D";
        }
        if (name.equals("float")) {
            return "F";
        }
        if (name.equals("int")) {
            return "I";
        }
        if (name.equals("long")) {
            return "J";
        }
        if (name.equals("short")) {
            return "S";
        }
        if (name.equals("boolean")) {
            return "Z";
        }
        if (name.equals("void")) {
            return "V";
        }
        if (name.endsWith("[]")) {
            return "[" + TypeX.nameToSignature(name.substring(0, name.length() - 2));
        }
        if (name.length() != 0) {
            if (name.charAt(0) == '[' && name.charAt(name.length() - 1) == ';') {
                return name;
            }
            if (name.indexOf("<") == -1) {
                return "L" + name.replace('.', '/') + ";";
            }
            StringBuffer nameBuff = new StringBuffer();
            nameBuff.append("L");
            block6: for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                switch (c) {
                    case '.': {
                        nameBuff.append('/');
                        continue block6;
                    }
                    case '<': {
                        nameBuff.append("<L");
                        continue block6;
                    }
                    case '>': {
                        nameBuff.append(";>");
                        continue block6;
                    }
                    case ',': {
                        nameBuff.append(";L");
                        continue block6;
                    }
                    default: {
                        nameBuff.append(c);
                    }
                }
            }
            nameBuff.append(";");
            return nameBuff.toString();
        }
        throw new BCException("Bad type name: " + name);
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeUTF(this.signature);
    }

    public static TypeX read(DataInputStream s) throws IOException {
        String sig = s.readUTF();
        if (sig.equals(MISSING_NAME)) {
            return ResolvedTypeX.MISSING;
        }
        return TypeX.forSignature(sig);
    }

    public static void writeArray(TypeX[] types, DataOutputStream s) throws IOException {
        int len = types.length;
        s.writeShort(len);
        for (int i = 0; i < len; ++i) {
            types[i].write(s);
        }
    }

    public static TypeX[] readArray(DataInputStream s) throws IOException {
        int len = s.readShort();
        TypeX[] types = new TypeX[len];
        for (int i = 0; i < len; ++i) {
            types[i] = TypeX.read(s);
        }
        return types;
    }

    public void dump(World world) {
        if (this.isAspect(world)) {
            System.out.print("aspect ");
        } else if (this.isInterface(world)) {
            System.out.print("interface ");
        } else if (this.isClass(world)) {
            System.out.print("class ");
        }
        System.out.println(this.toString());
        this.dumpResolvedMembers("fields", this.getDeclaredFields(world));
        this.dumpResolvedMembers("methods", this.getDeclaredMethods(world));
        this.dumpResolvedMembers("pointcuts", this.getDeclaredPointcuts(world));
    }

    private void dumpResolvedMembers(String label, ResolvedMember[] l) {
        String indent = "    ";
        System.out.println(label);
        if (l == null) {
            System.out.println("    null");
            return;
        }
        int len = l.length;
        for (int i = 0; i < len; ++i) {
            System.out.println("    " + l[i]);
        }
    }

    public String getNameAsIdentifier() {
        return this.getName().replace('.', '_');
    }

    public String getPackageNameAsIdentifier() {
        String name = this.getName();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return name.substring(0, index).replace('.', '_');
    }

    public String getPackageName() {
        String name = this.getName();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return name.substring(0, index);
    }

    public TypeX[] getTypeParameters() {
        return this.typeParameters == null ? new TypeX[]{} : this.typeParameters;
    }

    public String getClassName() {
        String name = this.getName();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return name;
        }
        return name.substring(index + 1);
    }
}

