/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.lookup;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class RawTypeBinding
extends ParameterizedTypeBinding {
    public RawTypeBinding(ReferenceBinding type, ReferenceBinding enclosingType, LookupEnvironment environment) {
        super(type, null, enclosingType, environment);
        if (enclosingType == null || (enclosingType.modifiers & 0x40000000) == 0) {
            this.modifiers &= 0xBFFFFFFF;
        }
    }

    public ParameterizedMethodBinding createParameterizedMethod(MethodBinding originalMethod) {
        if (originalMethod.typeVariables == TypeConstants.NoTypeVariables || originalMethod.isStatic()) {
            return super.createParameterizedMethod(originalMethod);
        }
        return new ParameterizedGenericMethodBinding(originalMethod, this, this.environment);
    }

    public int kind() {
        return 516;
    }

    public String debugName() {
        StringBuffer nameBuffer = new StringBuffer(10);
        nameBuffer.append(this.type.sourceName()).append("#RAW");
        return nameBuffer.toString();
    }

    public char[] genericTypeSignature() {
        if (this.genericTypeSignature == null) {
            StringBuffer sig = new StringBuffer(10);
            if (this.isMemberType() && this.enclosingType().isParameterizedType()) {
                char[] typeSig = this.enclosingType().genericTypeSignature();
                int i = 0;
                while (i < typeSig.length - 1) {
                    sig.append(typeSig[i]);
                    ++i;
                }
                sig.append('.').append(this.sourceName()).append(';');
                int sigLength = sig.length();
                this.genericTypeSignature = new char[sigLength];
                sig.getChars(0, sigLength, this.genericTypeSignature, 0);
            } else {
                this.genericTypeSignature = this.type.signature();
            }
        }
        return this.genericTypeSignature;
    }

    public boolean isEquivalentTo(TypeBinding otherType) {
        if (this == otherType) {
            return true;
        }
        if (otherType == null) {
            return false;
        }
        if (otherType.isWildcard()) {
            return ((WildcardBinding)otherType).boundCheck(this);
        }
        return otherType.erasure() == this.erasure();
    }

    public boolean isParameterizedType() {
        return false;
    }

    public boolean isRawType() {
        return true;
    }

    protected void initializeArguments() {
        TypeVariableBinding[] typeVariables = this.type.typeVariables();
        int length = typeVariables.length;
        TypeBinding[] typeArguments = new TypeBinding[length];
        int i = 0;
        while (i < length) {
            typeArguments[i] = typeVariables[i].erasure();
            ++i;
        }
        this.arguments = typeArguments;
    }

    public char[] readableName() {
        char[] readableName = this.isMemberType() ? CharOperation.concat(this.enclosingType().readableName(), this.sourceName, '.') : CharOperation.concatWith(this.type.compoundName, '.');
        return readableName;
    }

    public TypeBinding substitute(TypeBinding originalType) {
        block0 : switch (originalType.kind()) {
            case 2052: {
                TypeVariableBinding originalVariable = (TypeVariableBinding)originalType;
                ParameterizedTypeBinding currentType = this;
                while (true) {
                    ReferenceBinding enclosing;
                    TypeVariableBinding[] typeVariables;
                    int length;
                    if (originalVariable.rank < (length = (typeVariables = currentType.type.typeVariables()).length) && typeVariables[originalVariable.rank] == originalVariable) {
                        if (currentType.arguments == null) {
                            currentType.initializeArguments();
                        }
                        if (currentType.arguments != null) {
                            return currentType.arguments[originalVariable.rank];
                        }
                    }
                    if (!((enclosing = currentType.enclosingType()) instanceof ParameterizedTypeBinding)) break block0;
                    currentType = (ParameterizedTypeBinding)enclosing;
                }
            }
            case 132: {
                ReferenceBinding substitutedEnclosing = originalType.enclosingType();
                if (substitutedEnclosing != null) {
                    substitutedEnclosing = (ReferenceBinding)this.substitute(substitutedEnclosing);
                }
                ParameterizedTypeBinding originalParameterizedType = (ParameterizedTypeBinding)originalType;
                return this.environment.createRawType(originalParameterizedType.type, substitutedEnclosing);
            }
            case 1028: {
                ReferenceBinding substitutedEnclosing = originalType.enclosingType();
                if (substitutedEnclosing != null) {
                    substitutedEnclosing = (ReferenceBinding)this.substitute(substitutedEnclosing);
                }
                return this.environment.createRawType((ReferenceBinding)originalType, substitutedEnclosing);
            }
            case 260: {
                TypeBinding originalBound;
                TypeBinding substitutedBound;
                WildcardBinding wildcard = (WildcardBinding)originalType;
                if (wildcard.kind == 0 || (substitutedBound = this.substitute(originalBound = wildcard.bound)) == originalBound) break;
                return this.environment.createWildcard(wildcard.genericType, wildcard.rank, substitutedBound, wildcard.kind);
            }
            case 68: {
                TypeBinding originalLeafComponentType = originalType.leafComponentType();
                TypeBinding substitute = this.substitute(originalLeafComponentType);
                if (substitute == originalLeafComponentType) break;
                return this.environment.createArrayType(substitute.leafComponentType(), substitute.dimensions() + originalType.dimensions());
            }
        }
        return originalType;
    }

    public char[] shortReadableName() {
        char[] shortReadableName = this.isMemberType() ? CharOperation.concat(this.enclosingType().shortReadableName(), this.sourceName, '.') : this.type.sourceName;
        return shortReadableName;
    }
}

