/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic.annotation;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.annotation.ClassElementValue;
import org.aspectj.apache.bcel.generic.ConstantPoolGen;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.annotation.ElementValueGen;

public class ClassElementValueGen
extends ElementValueGen {
    private int idx;

    protected ClassElementValueGen(int typeIdx, ConstantPoolGen cpool) {
        super(99, cpool);
        this.idx = typeIdx;
    }

    public ClassElementValueGen(ObjectType t, ConstantPoolGen cpool) {
        super(99, cpool);
        this.idx = cpool.addUtf8(t.getSignature());
    }

    public ClassElementValueGen(ClassElementValue value, ConstantPoolGen cpool, boolean copyPoolEntries) {
        super(99, cpool);
        this.idx = copyPoolEntries ? cpool.addUtf8(value.getClassString()) : value.getIndex();
    }

    public int getIndex() {
        return this.idx;
    }

    public String getClassString() {
        ConstantUtf8 cu8 = (ConstantUtf8)this.getConstantPool().getConstant(this.idx);
        return cu8.getBytes();
    }

    public String stringifyValue() {
        return this.getClassString();
    }

    public void dump(DataOutputStream dos) throws IOException {
        dos.writeByte(this.type);
        dos.writeShort(this.idx);
    }
}

