Object.assign(window.search, {"doc_urls":["index.html#clippy","installation.html#installation","installation.html#using-rustup","installation.html#from-source","usage.html#usage","usage.html#cargo-subcommand","usage.html#using-clippy-without-cargo-clippy-driver","configuration.html#configuring-clippy","lint_configuration.html#lint-configuration-options","lint_configuration.html#absolute-paths-allowed-crates","lint_configuration.html#absolute-paths-max-segments","lint_configuration.html#accept-comment-above-attributes","lint_configuration.html#accept-comment-above-statement","lint_configuration.html#allow-comparison-to-zero","lint_configuration.html#allow-dbg-in-tests","lint_configuration.html#allow-expect-in-tests","lint_configuration.html#allow-mixed-uninlined-format-args","lint_configuration.html#allow-one-hash-in-raw-strings","lint_configuration.html#allow-panic-in-tests","lint_configuration.html#allow-print-in-tests","lint_configuration.html#allow-private-module-inception","lint_configuration.html#allow-renamed-params-for","lint_configuration.html#allow-unwrap-in-tests","lint_configuration.html#allow-useless-vec-in-tests","lint_configuration.html#allowed-dotfiles","lint_configuration.html#allowed-duplicate-crates","lint_configuration.html#allowed-idents-below-min-chars","lint_configuration.html#allowed-prefixes","lint_configuration.html#allowed-scripts","lint_configuration.html#allowed-wildcard-imports","lint_configuration.html#arithmetic-side-effects-allowed","lint_configuration.html#arithmetic-side-effects-allowed-binary","lint_configuration.html#arithmetic-side-effects-allowed-unary","lint_configuration.html#array-size-threshold","lint_configuration.html#avoid-breaking-exported-api","lint_configuration.html#await-holding-invalid-types","lint_configuration.html#cargo-ignore-publish","lint_configuration.html#check-private-items","lint_configuration.html#cognitive-complexity-threshold","lint_configuration.html#disallowed-macros","lint_configuration.html#disallowed-methods","lint_configuration.html#disallowed-names","lint_configuration.html#disallowed-types","lint_configuration.html#doc-valid-idents","lint_configuration.html#enable-raw-pointer-heuristic-for-send","lint_configuration.html#enforce-iter-loop-reborrow","lint_configuration.html#enforced-import-renames","lint_configuration.html#enum-variant-name-threshold","lint_configuration.html#enum-variant-size-threshold","lint_configuration.html#excessive-nesting-threshold","lint_configuration.html#future-size-threshold","lint_configuration.html#ignore-interior-mutability","lint_configuration.html#large-error-threshold","lint_configuration.html#literal-representation-threshold","lint_configuration.html#matches-for-let-else","lint_configuration.html#max-fn-params-bools","lint_configuration.html#max-include-file-size","lint_configuration.html#max-struct-bools","lint_configuration.html#max-suggested-slice-pattern-length","lint_configuration.html#max-trait-bounds","lint_configuration.html#min-ident-chars-threshold","lint_configuration.html#missing-docs-in-crate-items","lint_configuration.html#msrv","lint_configuration.html#pass-by-value-size-limit","lint_configuration.html#pub-underscore-fields-behavior","lint_configuration.html#semicolon-inside-block-ignore-singleline","lint_configuration.html#semicolon-outside-block-ignore-multiline","lint_configuration.html#single-char-binding-names-threshold","lint_configuration.html#stack-size-threshold","lint_configuration.html#standard-macro-braces","lint_configuration.html#struct-field-name-threshold","lint_configuration.html#suppress-restriction-lint-in-const","lint_configuration.html#too-large-for-stack","lint_configuration.html#too-many-arguments-threshold","lint_configuration.html#too-many-lines-threshold","lint_configuration.html#trivial-copy-size-limit","lint_configuration.html#type-complexity-threshold","lint_configuration.html#unnecessary-box-size","lint_configuration.html#unreadable-literal-lint-fractions","lint_configuration.html#upper-case-acronyms-aggressive","lint_configuration.html#vec-box-size-threshold","lint_configuration.html#verbose-bit-mask-threshold","lint_configuration.html#warn-on-all-wildcard-imports","lint_configuration.html#warn-unsafe-macro-metavars-in-private-macros","lints.html#clippys-lints","lints.html#correctness","lints.html#suspicious","lints.html#complexity","lints.html#perf","lints.html#style","lints.html#pedantic","lints.html#restriction","lints.html#cargo","continuous_integration/index.html#continuous-integration","continuous_integration/github_actions.html#github-actions","continuous_integration/gitlab.html#gitlab-ci","continuous_integration/travis.html#travis-ci","development/index.html#clippy-development","development/index.html#getting-started","development/index.html#additional-readings-for-beginners","development/index.html#writing-code","development/basics.html#basics-for-hacking-on-clippy","development/basics.html#get-the-code","development/basics.html#building-and-testing","development/basics.html#cargo-dev","development/basics.html#lintcheck","development/basics.html#pr","development/basics.html#common-abbreviations","development/basics.html#install-from-source","development/adding_lints.html#adding-a-new-lint","development/adding_lints.html#setup","development/adding_lints.html#getting-started","development/adding_lints.html#defining-our-lint","development/adding_lints.html#testing","development/adding_lints.html#rustfix-tests","development/adding_lints.html#testing-manually","development/adding_lints.html#lint-declaration","development/adding_lints.html#lint-registration","development/adding_lints.html#lint-passes","development/adding_lints.html#emitting-a-lint","development/adding_lints.html#adding-the-lint-logic","development/adding_lints.html#specifying-the-lints-minimum-supported-rust-version-msrv","development/adding_lints.html#author-lint","development/adding_lints.html#print-hir-lint","development/adding_lints.html#documentation","development/adding_lints.html#running-rustfmt","development/adding_lints.html#debugging","development/adding_lints.html#conflicting-lints","development/adding_lints.html#pr-checklist","development/adding_lints.html#adding-configuration-to-a-lint","development/adding_lints.html#cheat-sheet","development/defining_lints.html#define-new-lints","development/defining_lints.html#lint-name","development/defining_lints.html#add-and-register-the-lint","development/defining_lints.html#the-define_clippy_lints-macro","development/defining_lints.html#lint-registration","development/writing_tests.html#testing","development/writing_tests.html#develop-lints-with-tests","development/writing_tests.html#clippy-ui-tests","development/writing_tests.html#toml-tests","development/writing_tests.html#cargo-lints","development/writing_tests.html#rustfix-tests","development/writing_tests.html#testing-manually","development/lint_passes.html#lint-passes","development/lint_passes.html#earlylintpass","development/lint_passes.html#latelintpass","development/emitting_lints.html#emitting-a-lint","development/emitting_lints.html#suggestions-automatic-fixes","development/emitting_lints.html#how-to-choose-between-notes-help-messages-and-suggestions","development/emitting_lints.html#final-run-ui-tests-to-emit-the-lint","development/type_checking.html#type-checking","development/type_checking.html#latecontext-and-typeckresults","development/type_checking.html#ty","development/type_checking.html#tykind","development/type_checking.html#hirty-and-tyty","development/type_checking.html#creating-types-programmatically","development/type_checking.html#useful-links","development/trait_checking.html#trait-checking","development/trait_checking.html#using-diagnostic-items","development/trait_checking.html#using-lang-items","development/trait_checking.html#using-type-path","development/trait_checking.html#creating-types-programmatically","development/method_checking.html#method-checking","development/method_checking.html#checking-if-an-expr-is-calling-a-specific-method","development/method_checking.html#checking-if-a-impl-block-implements-a-method","development/macro_expansions.html#dealing-with-macros-and-expansions","development/macro_expansions.html#false-positives","development/macro_expansions.html#how-to-work-with-macros","development/common_tools_writing_lints.html#common-tools-for-writing-lints","development/common_tools_writing_lints.html#retrieving-the-type-of-expression","development/common_tools_writing_lints.html#checking-if-an-expr-is-calling-a-specific-method","development/common_tools_writing_lints.html#checking-for-a-specific-type","development/common_tools_writing_lints.html#checking-if-a-type-implements-a-specific-trait","development/common_tools_writing_lints.html#checking-if-a-type-defines-a-specific-method","development/common_tools_writing_lints.html#dealing-with-macros-and-expansions","development/infrastructure/index.html#infrastructure","development/infrastructure/sync.html#syncing-changes-between-clippy-and--rust-langrust","development/infrastructure/sync.html#patching-git-subtree-to-work-with-big-repos","development/infrastructure/sync.html#defining-remotes","development/infrastructure/sync.html#performing-the-sync-from--rust-langrust--to-clippy","development/infrastructure/sync.html#performing-the-sync-from-clippy-to--rust-langrust","development/infrastructure/backport.html#backport-changes","development/infrastructure/backport.html#backport-the-changes","development/infrastructure/backport.html#update-clippy-in-the-rust-repository","development/infrastructure/changelog_update.html#changelog-update","development/infrastructure/changelog_update.html#when-to-update","development/infrastructure/changelog_update.html#changelog-update-walkthrough","development/infrastructure/release.html#release-a-new-clippy-version","development/infrastructure/release.html#remerge-the-beta-branch","development/infrastructure/release.html#update-the-beta-branch","development/infrastructure/release.html#find-the-clippy-commit","development/infrastructure/release.html#tag-the-stable-commit","development/infrastructure/release.html#update-the-stable-branch","development/infrastructure/release.html#update-changelogmd","development/infrastructure/book.html#the-clippy-book","development/infrastructure/book.html#get-mdbook","development/infrastructure/book.html#make-changes","development/proposals/index.html#proposals","development/proposals/roadmap-2021.html#roadmap-2021","development/proposals/roadmap-2021.html#summary","development/proposals/roadmap-2021.html#motivation","development/proposals/roadmap-2021.html#explanation","development/proposals/roadmap-2021.html#user-facing","development/proposals/roadmap-2021.html#internal","development/proposals/roadmap-2021.html#prioritization","development/proposals/roadmap-2021.html#prior-art","development/proposals/roadmap-2021.html#rust-roadmap","development/proposals/roadmap-2021.html#drawbacks","development/proposals/roadmap-2021.html#big-roadmap","development/proposals/syntax-tree-patterns.html#summary","development/proposals/syntax-tree-patterns.html#motivation","development/proposals/syntax-tree-patterns.html#approach","development/proposals/syntax-tree-patterns.html#guide-level-explanation","development/proposals/syntax-tree-patterns.html#pattern-syntax","development/proposals/syntax-tree-patterns.html#the-result-type","development/proposals/syntax-tree-patterns.html#implementing-clippy-lints-using-patterns","development/proposals/syntax-tree-patterns.html#reference-level-explanation","development/proposals/syntax-tree-patterns.html#overview","development/proposals/syntax-tree-patterns.html#patterntree","development/proposals/syntax-tree-patterns.html#parsing--lowering","development/proposals/syntax-tree-patterns.html#the-ismatch-trait","development/proposals/syntax-tree-patterns.html#drawbacks","development/proposals/syntax-tree-patterns.html#rationale-and-alternatives","development/proposals/syntax-tree-patterns.html#alternatives","development/proposals/syntax-tree-patterns.html#prior-art","development/proposals/syntax-tree-patterns.html#unresolved-questions","development/proposals/syntax-tree-patterns.html#future-possibilities","development/the_team.html#the-team","development/the_team.html#everyone","development/the_team.html#clippy-contributors","development/the_team.html#the-clippy-team"],"index":{"documentStore":{"docInfo":{"0":{"body":167,"breadcrumbs":2,"title":1},"1":{"body":27,"breadcrumbs":2,"title":1},"10":{"body":16,"breadcrumbs":7,"title":4},"100":{"body":84,"breadcrumbs":3,"title":2},"101":{"body":35,"breadcrumbs":5,"title":3},"102":{"body":72,"breadcrumbs":3,"title":1},"103":{"body":77,"breadcrumbs":4,"title":2},"104":{"body":86,"breadcrumbs":4,"title":2},"105":{"body":43,"breadcrumbs":3,"title":1},"106":{"body":11,"breadcrumbs":3,"title":1},"107":{"body":55,"breadcrumbs":4,"title":2},"108":{"body":126,"breadcrumbs":4,"title":2},"109":{"body":87,"breadcrumbs":6,"title":3},"11":{"body":15,"breadcrumbs":7,"title":4},"110":{"body":3,"breadcrumbs":4,"title":1},"111":{"body":44,"breadcrumbs":5,"title":2},"112":{"body":104,"breadcrumbs":5,"title":2},"113":{"body":228,"breadcrumbs":4,"title":1},"114":{"body":33,"breadcrumbs":5,"title":2},"115":{"body":53,"breadcrumbs":5,"title":2},"116":{"body":166,"breadcrumbs":5,"title":2},"117":{"body":82,"breadcrumbs":5,"title":2},"118":{"body":65,"breadcrumbs":5,"title":2},"119":{"body":145,"breadcrumbs":5,"title":2},"12":{"body":16,"breadcrumbs":7,"title":4},"120":{"body":140,"breadcrumbs":6,"title":3},"121":{"body":187,"breadcrumbs":10,"title":7},"122":{"body":57,"breadcrumbs":5,"title":2},"123":{"body":37,"breadcrumbs":6,"title":3},"124":{"body":80,"breadcrumbs":4,"title":1},"125":{"body":40,"breadcrumbs":5,"title":2},"126":{"body":17,"breadcrumbs":4,"title":1},"127":{"body":74,"breadcrumbs":5,"title":2},"128":{"body":35,"breadcrumbs":5,"title":2},"129":{"body":223,"breadcrumbs":6,"title":3},"13":{"body":13,"breadcrumbs":6,"title":3},"130":{"body":80,"breadcrumbs":5,"title":2},"131":{"body":93,"breadcrumbs":6,"title":3},"132":{"body":39,"breadcrumbs":5,"title":2},"133":{"body":263,"breadcrumbs":6,"title":3},"134":{"body":71,"breadcrumbs":5,"title":2},"135":{"body":66,"breadcrumbs":5,"title":2},"136":{"body":18,"breadcrumbs":4,"title":1},"137":{"body":61,"breadcrumbs":6,"title":3},"138":{"body":335,"breadcrumbs":6,"title":3},"139":{"body":49,"breadcrumbs":5,"title":2},"14":{"body":12,"breadcrumbs":6,"title":3},"140":{"body":83,"breadcrumbs":5,"title":2},"141":{"body":61,"breadcrumbs":5,"title":2},"142":{"body":25,"breadcrumbs":5,"title":2},"143":{"body":33,"breadcrumbs":5,"title":2},"144":{"body":151,"breadcrumbs":4,"title":1},"145":{"body":131,"breadcrumbs":4,"title":1},"146":{"body":231,"breadcrumbs":5,"title":2},"147":{"body":136,"breadcrumbs":6,"title":3},"148":{"body":142,"breadcrumbs":9,"title":6},"149":{"body":22,"breadcrumbs":9,"title":6},"15":{"body":12,"breadcrumbs":6,"title":3},"150":{"body":19,"breadcrumbs":5,"title":2},"151":{"body":68,"breadcrumbs":5,"title":2},"152":{"body":105,"breadcrumbs":4,"title":1},"153":{"body":76,"breadcrumbs":4,"title":1},"154":{"body":74,"breadcrumbs":5,"title":2},"155":{"body":47,"breadcrumbs":6,"title":3},"156":{"body":16,"breadcrumbs":5,"title":2},"157":{"body":25,"breadcrumbs":5,"title":2},"158":{"body":63,"breadcrumbs":6,"title":3},"159":{"body":92,"breadcrumbs":6,"title":3},"16":{"body":15,"breadcrumbs":8,"title":5},"160":{"body":58,"breadcrumbs":6,"title":3},"161":{"body":176,"breadcrumbs":6,"title":3},"162":{"body":19,"breadcrumbs":5,"title":2},"163":{"body":130,"breadcrumbs":8,"title":5},"164":{"body":102,"breadcrumbs":8,"title":5},"165":{"body":35,"breadcrumbs":6,"title":3},"166":{"body":87,"breadcrumbs":5,"title":2},"167":{"body":265,"breadcrumbs":5,"title":2},"168":{"body":47,"breadcrumbs":7,"title":4},"169":{"body":113,"breadcrumbs":6,"title":3},"17":{"body":11,"breadcrumbs":8,"title":5},"170":{"body":42,"breadcrumbs":8,"title":5},"171":{"body":86,"breadcrumbs":6,"title":3},"172":{"body":103,"breadcrumbs":8,"title":5},"173":{"body":49,"breadcrumbs":8,"title":5},"174":{"body":204,"breadcrumbs":6,"title":3},"175":{"body":77,"breadcrumbs":3,"title":1},"176":{"body":104,"breadcrumbs":14,"title":6},"177":{"body":139,"breadcrumbs":14,"title":6},"178":{"body":63,"breadcrumbs":10,"title":2},"179":{"body":139,"breadcrumbs":13,"title":5},"18":{"body":12,"breadcrumbs":6,"title":3},"180":{"body":39,"breadcrumbs":13,"title":5},"181":{"body":46,"breadcrumbs":6,"title":2},"182":{"body":120,"breadcrumbs":6,"title":2},"183":{"body":80,"breadcrumbs":8,"title":4},"184":{"body":7,"breadcrumbs":6,"title":2},"185":{"body":45,"breadcrumbs":5,"title":1},"186":{"body":300,"breadcrumbs":7,"title":3},"187":{"body":53,"breadcrumbs":9,"title":4},"188":{"body":95,"breadcrumbs":8,"title":3},"189":{"body":70,"breadcrumbs":8,"title":3},"19":{"body":16,"breadcrumbs":6,"title":3},"190":{"body":52,"breadcrumbs":8,"title":3},"191":{"body":38,"breadcrumbs":8,"title":3},"192":{"body":58,"breadcrumbs":8,"title":3},"193":{"body":60,"breadcrumbs":7,"title":2},"194":{"body":22,"breadcrumbs":6,"title":2},"195":{"body":35,"breadcrumbs":5,"title":1},"196":{"body":51,"breadcrumbs":6,"title":2},"197":{"body":47,"breadcrumbs":3,"title":1},"198":{"body":0,"breadcrumbs":6,"title":2},"199":{"body":36,"breadcrumbs":5,"title":1},"2":{"body":9,"breadcrumbs":3,"title":2},"20":{"body":12,"breadcrumbs":7,"title":4},"200":{"body":55,"breadcrumbs":5,"title":1},"201":{"body":34,"breadcrumbs":5,"title":1},"202":{"body":207,"breadcrumbs":6,"title":2},"203":{"body":401,"breadcrumbs":5,"title":1},"204":{"body":61,"breadcrumbs":5,"title":1},"205":{"body":0,"breadcrumbs":6,"title":2},"206":{"body":19,"breadcrumbs":6,"title":2},"207":{"body":0,"breadcrumbs":5,"title":1},"208":{"body":21,"breadcrumbs":6,"title":2},"209":{"body":27,"breadcrumbs":6,"title":1},"21":{"body":43,"breadcrumbs":6,"title":3},"210":{"body":175,"breadcrumbs":6,"title":1},"211":{"body":118,"breadcrumbs":6,"title":1},"212":{"body":105,"breadcrumbs":8,"title":3},"213":{"body":362,"breadcrumbs":7,"title":2},"214":{"body":275,"breadcrumbs":7,"title":2},"215":{"body":20,"breadcrumbs":10,"title":5},"216":{"body":0,"breadcrumbs":8,"title":3},"217":{"body":64,"breadcrumbs":6,"title":1},"218":{"body":113,"breadcrumbs":6,"title":1},"219":{"body":63,"breadcrumbs":7,"title":2},"22":{"body":12,"breadcrumbs":6,"title":3},"220":{"body":125,"breadcrumbs":7,"title":2},"221":{"body":175,"breadcrumbs":6,"title":1},"222":{"body":105,"breadcrumbs":7,"title":2},"223":{"body":293,"breadcrumbs":6,"title":1},"224":{"body":33,"breadcrumbs":7,"title":2},"225":{"body":79,"breadcrumbs":7,"title":2},"226":{"body":395,"breadcrumbs":7,"title":2},"227":{"body":43,"breadcrumbs":3,"title":1},"228":{"body":30,"breadcrumbs":3,"title":1},"229":{"body":165,"breadcrumbs":4,"title":2},"23":{"body":12,"breadcrumbs":7,"title":4},"230":{"body":196,"breadcrumbs":4,"title":2},"24":{"body":12,"breadcrumbs":5,"title":2},"25":{"body":10,"breadcrumbs":6,"title":3},"26":{"body":33,"breadcrumbs":8,"title":5},"27":{"body":68,"breadcrumbs":5,"title":2},"28":{"body":12,"breadcrumbs":5,"title":2},"29":{"body":31,"breadcrumbs":6,"title":3},"3":{"body":15,"breadcrumbs":2,"title":1},"30":{"body":37,"breadcrumbs":7,"title":4},"31":{"body":46,"breadcrumbs":8,"title":5},"32":{"body":21,"breadcrumbs":8,"title":5},"33":{"body":12,"breadcrumbs":6,"title":3},"34":{"body":31,"breadcrumbs":7,"title":4},"35":{"body":10,"breadcrumbs":7,"title":4},"36":{"body":14,"breadcrumbs":6,"title":3},"37":{"body":15,"breadcrumbs":6,"title":3},"38":{"body":10,"breadcrumbs":6,"title":3},"39":{"body":12,"breadcrumbs":5,"title":2},"4":{"body":26,"breadcrumbs":2,"title":1},"40":{"body":12,"breadcrumbs":5,"title":2},"41":{"body":33,"breadcrumbs":5,"title":2},"42":{"body":12,"breadcrumbs":5,"title":2},"43":{"body":111,"breadcrumbs":6,"title":3},"44":{"body":14,"breadcrumbs":8,"title":5},"45":{"body":41,"breadcrumbs":7,"title":4},"46":{"body":14,"breadcrumbs":6,"title":3},"47":{"body":14,"breadcrumbs":7,"title":4},"48":{"body":13,"breadcrumbs":7,"title":4},"49":{"body":11,"breadcrumbs":6,"title":3},"5":{"body":353,"breadcrumbs":3,"title":2},"50":{"body":14,"breadcrumbs":6,"title":3},"51":{"body":16,"breadcrumbs":6,"title":3},"52":{"body":13,"breadcrumbs":6,"title":3},"53":{"body":11,"breadcrumbs":6,"title":3},"54":{"body":14,"breadcrumbs":4,"title":1},"55":{"body":11,"breadcrumbs":7,"title":4},"56":{"body":14,"breadcrumbs":7,"title":4},"57":{"body":11,"breadcrumbs":6,"title":3},"58":{"body":32,"breadcrumbs":8,"title":5},"59":{"body":11,"breadcrumbs":6,"title":3},"6":{"body":36,"breadcrumbs":7,"title":6},"60":{"body":13,"breadcrumbs":7,"title":4},"61":{"body":18,"breadcrumbs":7,"title":4},"62":{"body":73,"breadcrumbs":4,"title":1},"63":{"body":15,"breadcrumbs":7,"title":4},"64":{"body":18,"breadcrumbs":7,"title":4},"65":{"body":10,"breadcrumbs":8,"title":5},"66":{"body":10,"breadcrumbs":8,"title":5},"67":{"body":12,"breadcrumbs":8,"title":5},"68":{"body":12,"breadcrumbs":6,"title":3},"69":{"body":31,"breadcrumbs":6,"title":3},"7":{"body":357,"breadcrumbs":3,"title":2},"70":{"body":14,"breadcrumbs":7,"title":4},"71":{"body":30,"breadcrumbs":7,"title":4},"72":{"body":16,"breadcrumbs":5,"title":2},"73":{"body":11,"breadcrumbs":6,"title":3},"74":{"body":11,"breadcrumbs":6,"title":3},"75":{"body":19,"breadcrumbs":7,"title":4},"76":{"body":9,"breadcrumbs":6,"title":3},"77":{"body":14,"breadcrumbs":6,"title":3},"78":{"body":11,"breadcrumbs":7,"title":4},"79":{"body":16,"breadcrumbs":7,"title":4},"8":{"body":13,"breadcrumbs":6,"title":3},"80":{"body":13,"breadcrumbs":7,"title":4},"81":{"body":15,"breadcrumbs":7,"title":4},"82":{"body":14,"breadcrumbs":6,"title":3},"83":{"body":15,"breadcrumbs":9,"title":6},"84":{"body":54,"breadcrumbs":4,"title":2},"85":{"body":34,"breadcrumbs":3,"title":1},"86":{"body":47,"breadcrumbs":3,"title":1},"87":{"body":40,"breadcrumbs":3,"title":1},"88":{"body":29,"breadcrumbs":3,"title":1},"89":{"body":44,"breadcrumbs":3,"title":1},"9":{"body":9,"breadcrumbs":7,"title":4},"90":{"body":57,"breadcrumbs":3,"title":1},"91":{"body":54,"breadcrumbs":3,"title":1},"92":{"body":16,"breadcrumbs":3,"title":1},"93":{"body":81,"breadcrumbs":4,"title":2},"94":{"body":50,"breadcrumbs":6,"title":2},"95":{"body":40,"breadcrumbs":6,"title":2},"96":{"body":49,"breadcrumbs":6,"title":2},"97":{"body":29,"breadcrumbs":3,"title":2},"98":{"body":15,"breadcrumbs":3,"title":2},"99":{"body":69,"breadcrumbs":4,"title":3}},"docs":{"0":{"body":"Clippy Test License: MIT OR Apache-2.0 A collection of lints to catch common mistakes and improve your Rust code. There are over 700 lints included in this crate! Lints are divided into categories, each with a default lint level . You can choose how much Clippy is supposed to annoy help you by changing the lint level by category. Category Description Default level clippy::all all lints that are on by default (correctness, suspicious, style, complexity, perf) warn/deny clippy::correctness code that is outright wrong or useless deny clippy::suspicious code that is most likely wrong or useless warn clippy::style code that should be written in a more idiomatic way warn clippy::complexity code that does something simple but in a complex way warn clippy::perf code that can be written to run faster warn clippy::pedantic lints which are rather strict or have occasional false positives allow clippy::restriction lints which prevent the use of language and library features [1] allow clippy::nursery new lints that are still under development allow clippy::cargo lints for the cargo manifest allow More to come, please file an issue if you have ideas! The restriction category should, emphatically , not be enabled as a whole. The contained lints may lint against perfectly reasonable code, may not have an alternative suggestion, and may contradict any other lints (including other categories). Lints should be considered on a case-by-case basis before enabling. Some use cases for restriction lints include: Strict coding styles (e.g. clippy::else_if_without_else ). Additional restrictions on CI (e.g. clippy::todo ). Preventing panicking in certain functions (e.g. clippy::unwrap_used ). Running a lint only on a subset of code (e.g. #[forbid(clippy::float_arithmetic)] on a module).","breadcrumbs":"Introduction » Clippy","id":"0","title":"Clippy"},"1":{"body":"If you're using rustup to install and manage your Rust toolchains, Clippy is usually already installed . In that case you can skip this chapter and go to the Usage chapter. Note: If you used the minimal profile when installing a Rust toolchain, Clippy is not automatically installed.","breadcrumbs":"Installation » Installation","id":"1","title":"Installation"},"10":{"body":"The maximum number of segments a path can have before being linted, anything above this will be linted. Default Value: 2 Affected lints: absolute_paths","breadcrumbs":"Configuration » Lint Configuration » absolute-paths-max-segments","id":"10","title":"absolute-paths-max-segments"},"100":{"body":"If you have done the basic setup, it's time to start hacking. The Adding lints chapter is a walk through on how to add a new lint to Clippy. This is also interesting if you just want to fix a lint, because it also covers how to test lints and gives an overview of the bigger picture. If you want to add a new lint or change existing ones apart from bugfixing, it's also a good idea to give the stability guarantees and lint categories sections of the Clippy 1.0 RFC a quick read. The lint categories are also described earlier in this book . Note: Some higher level things about contributing to Clippy are still covered in the CONTRIBUTING.md document. Some of those will be moved to the book over time, like: Finding something to fix IDE setup High level overview on how Clippy works Triage procedure Bors and Homu","breadcrumbs":"Development » Writing code","id":"100","title":"Writing code"},"101":{"body":"This document explains the basics for hacking on Clippy. Besides others, this includes how to build and test Clippy. For a more in depth description on the codebase take a look at Adding Lints or Common Tools . Basics for hacking on Clippy Get the Code Building and Testing cargo dev lintcheck PR Common Abbreviations Install from source","breadcrumbs":"Development » Basics » Basics for hacking on Clippy","id":"101","title":"Basics for hacking on Clippy"},"102":{"body":"First, make sure you have checked out the latest version of Clippy. If this is your first time working on Clippy, create a fork of the repository and clone it afterwards with the following command: git clone git@github.com:<your-username>/rust-clippy If you've already cloned Clippy in the past, update it to the latest version: # If the upstream remote has not been added yet\ngit remote add upstream https://github.com/rust-lang/rust-clippy\n# upstream has to be the remote of the rust-lang/rust-clippy repo\ngit fetch upstream\n# make sure that you are on the master branch\ngit checkout master\n# rebase your master branch on the upstream master\ngit rebase upstream/master\n# push to the master branch of your fork\ngit push","breadcrumbs":"Development » Basics » Get the Code","id":"102","title":"Get the Code"},"103":{"body":"You can build and test Clippy like every other Rust project: cargo build # builds Clippy\ncargo test # tests Clippy Since Clippy's test suite is pretty big, there are some commands that only run a subset of Clippy's tests: # only run UI tests\ncargo uitest\n# only run UI tests starting with `test_`\nTESTNAME=\"test_\" cargo uitest\n# only run dogfood tests\ncargo dev dogfood If the output of a UI test differs from the expected output, you can update the reference file with: cargo bless For example, this is necessary if you fix a typo in an error message of a lint, or if you modify a test file to add a test case. Note: This command may update more files than you intended. In that case only commit the files you wanted to update.","breadcrumbs":"Development » Basics » Building and Testing","id":"103","title":"Building and Testing"},"104":{"body":"Clippy has some dev tools to make working on Clippy more convenient. These tools can be accessed through the cargo dev command. Available tools are listed below. To get more information about these commands, just call them with --help. # formats the whole Clippy codebase and all tests\ncargo dev fmt\n# register or update lint names/groups/...\ncargo dev update_lints\n# create a new lint and register it\ncargo dev new_lint\n# deprecate a lint and attempt to remove code relating to it\ncargo dev deprecate\n# automatically formatting all code before each commit\ncargo dev setup git-hook\n# (experimental) Setup Clippy to work with IntelliJ-Rust\ncargo dev setup intellij\n# runs the `dogfood` tests\ncargo dev dogfood More about intellij command usage and reasons.","breadcrumbs":"Development » Basics » cargo dev","id":"104","title":"cargo dev"},"105":{"body":"cargo lintcheck will build and run Clippy on a fixed set of crates and generate a log of the results. You can git diff the updated log against its previous version and see what impact your lint made on a small set of crates. If you add a new lint, please audit the resulting warnings and make sure there are no false positives and that the suggestions are valid. Refer to the tools README for more details.","breadcrumbs":"Development » Basics » lintcheck","id":"105","title":"lintcheck"},"106":{"body":"We follow a rustc no merge-commit policy. See https://rustc-dev-guide.rust-lang.org/contributing.html#opening-a-pr .","breadcrumbs":"Development » Basics » PR","id":"106","title":"PR"},"107":{"body":"Abbreviation Meaning UB Undefined Behavior FP False Positive FN False Negative ICE Internal Compiler Error AST Abstract Syntax Tree MIR Mid-Level Intermediate Representation HIR High-Level Intermediate Representation TCX Type context This is a concise list of abbreviations that can come up during Clippy development. An extensive general list can be found in the rustc-dev-guide glossary . Always feel free to ask if an abbreviation or meaning is unclear to you.","breadcrumbs":"Development » Basics » Common Abbreviations","id":"107","title":"Common Abbreviations"},"108":{"body":"If you are hacking on Clippy and want to install it from source, do the following: First, take note of the toolchain override in /rust-toolchain. We will use this override to install Clippy into the right toolchain. Tip: You can view the active toolchain for the current directory with rustup show active-toolchain. From the Clippy project root, run the following command to build the Clippy binaries and copy them into the toolchain directory. This will override the currently installed Clippy component. cargo build --release --bin cargo-clippy --bin clippy-driver -Zunstable-options --out-dir \"$(rustc --print=sysroot)/bin\" Now you may run cargo clippy in any project, using the toolchain where you just installed Clippy. cd my-project\ncargo +nightly-2021-07-01 clippy ...or clippy-driver clippy-driver +nightly-2021-07-01 <filename> If you need to restore the default Clippy installation, run the following (from the Clippy project root). rustup component remove clippy\nrustup component add clippy DO NOT install using cargo install --path . --force since this will overwrite rustup proxies . That is, ~/.cargo/bin/cargo-clippy and ~/.cargo/bin/clippy-driver should be hard or soft links to ~/.cargo/bin/rustup. You can repair these by running rustup update.","breadcrumbs":"Development » Basics » Install from source","id":"108","title":"Install from source"},"109":{"body":"You are probably here because you want to add a new lint to Clippy. If this is the first time you're contributing to Clippy, this document guides you through creating an example lint from scratch. To get started, we will create a lint that detects functions called foo, because that's clearly a non-descriptive name. Adding a new lint Setup Getting Started Defining Our Lint Standalone Specific Type Tests Location Testing Cargo lints Rustfix tests Testing manually Lint declaration Lint registration Lint passes Emitting a lint Adding the lint logic Specifying the lint's minimum supported Rust version (MSRV) Author lint Print HIR lint Documentation Running rustfmt Debugging Conflicting lints PR Checklist Adding configuration to a lint Cheat Sheet","breadcrumbs":"Development » Adding Lints » Adding a new lint","id":"109","title":"Adding a new lint"},"11":{"body":"Whether to accept a safety comment to be placed above the attributes for the unsafe block Default Value: true Affected lints: undocumented_unsafe_blocks","breadcrumbs":"Configuration » Lint Configuration » accept-comment-above-attributes","id":"11","title":"accept-comment-above-attributes"},"110":{"body":"See the Basics documentation.","breadcrumbs":"Development » Adding Lints » Setup","id":"110","title":"Setup"},"111":{"body":"There is a bit of boilerplate code that needs to be set up when creating a new lint. Fortunately, you can use the Clippy dev tools to handle this for you. We are naming our new lint foo_functions (lints are generally written in snake case), and we don't need type information, so it will have an early pass type (more on this later). If you're unsure if the name you chose fits the lint, take a look at our lint naming guidelines .","breadcrumbs":"Development » Adding Lints » Getting Started","id":"111","title":"Getting Started"},"112":{"body":"To get started, there are two ways to define our lint. Standalone Command: cargo dev new_lint --name=foo_functions --pass=early --category=pedantic (category will default to nursery if not provided) This command will create a new file: clippy_lints/src/foo_functions.rs, as well as register the lint . Specific Type Command: cargo dev new_lint --name=foo_functions --type=functions --category=pedantic This command will create a new file: clippy_lints/src/{type}/foo_functions.rs. Notice how this command has a --type flag instead of --pass. Unlike a standalone definition, this lint won't be registered in the traditional sense. Instead, you will call your lint from within the type's lint pass, found in clippy_lints/src/{type}/mod.rs. A \"type\" is just the name of a directory in clippy_lints/src, like functions in the example command. These are groupings of lints with common behaviors, so if your lint falls into one, it would be best to add it to that type. Tests Location Both commands will create a file: tests/ui/foo_functions.rs. For cargo lints, two project hierarchies (fail/pass) will be created by default under tests/ui-cargo. Next, we'll open up these files and add our lint!","breadcrumbs":"Development » Adding Lints » Defining Our Lint","id":"112","title":"Defining Our Lint"},"113":{"body":"Let's write some tests first that we can execute while we iterate on our lint. Clippy uses UI tests for testing. UI tests check that the output of Clippy is exactly as expected. Each test is just a plain Rust file that contains the code we want to check. The output of Clippy is compared against a .stderr file. Note that you don't have to create this file yourself, we'll get to generating the .stderr files further down. We start by opening the test file created at tests/ui/foo_functions.rs. Update the file with some examples to get started: #![allow(unused)]\n#![warn(clippy::foo_functions)] // Impl methods\nstruct A;\nimpl A { pub fn fo(&self) {} pub fn foo(&self) {} pub fn food(&self) {}\n} // Default trait methods\ntrait B { fn fo(&self) {} fn foo(&self) {} fn food(&self) {}\n} // Plain functions\nfn fo() {}\nfn foo() {}\nfn food() {} fn main() { // We also don't want to lint method calls foo(); let a = A; a.foo();\n} Now we can run the test with TESTNAME=foo_functions cargo uibless, currently this test is meaningless though. While we are working on implementing our lint, we can keep running the UI test. That allows us to check if the output is turning into what we want by checking the .stderr file that gets updated on every test run. Running TESTNAME=foo_functions cargo uitest should pass on its own. When we commit our lint, we need to commit the generated .stderr files, too. In general, you should only commit files changed by cargo bless for the specific lint you are creating/editing. Note: you can run multiple test files by specifying a comma separated list: TESTNAME=foo_functions,test2,test3. Cargo lints For cargo lints, the process of testing differs in that we are interested in the Cargo.toml manifest file. We also need a minimal crate associated with that manifest. If our new lint is named e.g. foo_categories, after running cargo dev new_lint --name=foo_categories --type=cargo --category=cargo we will find by default two new crates, each with its manifest file: tests/ui-cargo/foo_categories/fail/Cargo.toml: this file should cause the new lint to raise an error. tests/ui-cargo/foo_categories/pass/Cargo.toml: this file should not trigger the lint. If you need more cases, you can copy one of those crates (under foo_categories) and rename it. The process of generating the .stderr file is the same, and prepending the TESTNAME variable to cargo uitest works too.","breadcrumbs":"Development » Adding Lints » Testing","id":"113","title":"Testing"},"114":{"body":"If the lint you are working on is making use of structured suggestions, the test will create a .fixed file by running rustfix for that test. Rustfix will apply the suggestions from the lint to the code of the test file and compare that to the contents of a .fixed file. Use cargo bless to automatically generate the .fixed file while running the tests.","breadcrumbs":"Development » Adding Lints » Rustfix tests","id":"114","title":"Rustfix tests"},"115":{"body":"Manually testing against an example file can be useful if you have added some println!s and the test suite output becomes unreadable. To try Clippy with your local modifications, run the following from the Clippy directory: cargo dev lint input.rs To run Clippy on an existing project rather than a single file you can use cargo dev lint /path/to/project Or set up a rustup toolchain that points to the local Clippy binaries cargo dev setup toolchain # Then in `/path/to/project` you can run\ncargo +clippy clippy","breadcrumbs":"Development » Adding Lints » Testing manually","id":"115","title":"Testing manually"},"116":{"body":"Let's start by opening the new file created in the clippy_lints crate at clippy_lints/src/foo_functions.rs. That's the crate where all the lint code is. This file has already imported some initial things we will need: use rustc_lint::{EarlyLintPass, EarlyContext};\nuse rustc_session::declare_lint_pass;\nuse rustc_ast::ast::*; The next step is to update the lint declaration. Lints are declared using the declare_clippy_lint! macro, and we just need to update the auto-generated lint declaration to have a real description, something like this: declare_clippy_lint! { /// ### What it does /// /// ### Why is this bad? /// /// ### Example /// ```rust /// // example code /// ``` #[clippy::version = \"1.29.0\"] pub FOO_FUNCTIONS, pedantic, \"function named `foo`, which is not a descriptive name\"\n} The section of lines prefixed with /// constitutes the lint documentation section. This is the default documentation style and will be displayed like this . To render and open this documentation locally in a browser, run cargo dev serve. The #[clippy::version] attribute will be rendered as part of the lint documentation. The value should be set to the current Rust version that the lint is developed in, it can be retrieved by running rustc -vV in the rust-clippy directory. The version is listed under release . (Use the version without the -nightly) suffix. FOO_FUNCTIONS is the name of our lint. Be sure to follow the lint naming guidelines here when naming your lint. In short, the name should state the thing that is being checked for and read well when used with allow/warn/deny. pedantic sets the lint level to Allow. The exact mapping can be found here The last part should be a text that explains what exactly is wrong with the code The rest of this file contains an empty implementation for our lint pass, which in this case is EarlyLintPass and should look like this: // clippy_lints/src/foo_functions.rs // .. imports and lint declaration .. declare_lint_pass!(FooFunctions => [FOO_FUNCTIONS]); impl EarlyLintPass for FooFunctions {}","breadcrumbs":"Development » Adding Lints » Lint declaration","id":"116","title":"Lint declaration"},"117":{"body":"When using cargo dev new_lint, the lint is automatically registered and nothing more has to be done. When declaring a new lint by hand and cargo dev update_lints is used, the lint pass may have to be registered manually in the register_lints function in clippy_lints/src/lib.rs: store.register_early_pass(|| Box::new(foo_functions::FooFunctions)); As one may expect, there is a corresponding register_late_pass method available as well. Without a call to one of register_early_pass or register_late_pass, the lint pass in question will not be run. One reason that cargo dev update_lints does not automate this step is that multiple lints can use the same lint pass, so registering the lint pass may already be done when adding a new lint. Another reason that this step is not automated is that the order that the passes are registered determines the order the passes actually run, which in turn affects the order that any emitted lints are output in.","breadcrumbs":"Development » Adding Lints » Lint registration","id":"117","title":"Lint registration"},"118":{"body":"Writing a lint that only checks for the name of a function means that we only have to deal with the AST and don't have to deal with the type system at all. This is good, because it makes writing this particular lint less complicated. We have to make this decision with every new Clippy lint. It boils down to using either EarlyLintPass or LateLintPass . In short, the EarlyLintPass runs before type checking and HIR lowering and the LateLintPass has access to type information. Consider using the LateLintPass unless you need something specific from the EarlyLintPass. Since we don't need type information for checking the function name, we used --pass=early when running the new lint automation and all the imports were added accordingly.","breadcrumbs":"Development » Adding Lints » Lint passes","id":"118","title":"Lint passes"},"119":{"body":"With UI tests and the lint declaration in place, we can start working on the implementation of the lint logic. Let's start by implementing the EarlyLintPass for our FooFunctions: impl EarlyLintPass for FooFunctions { fn check_fn(&mut self, cx: &EarlyContext<'_>, fn_kind: FnKind<'_>, span: Span, _: NodeId) { // TODO: Emit lint here }\n} We implement the check_fn method from the EarlyLintPass trait. This gives us access to various information about the function that is currently being checked. More on that in the next section. Let's worry about the details later and emit our lint for every function definition first. Depending on how complex we want our lint message to be, we can choose from a variety of lint emission functions. They can all be found in clippy_utils/src/diagnostics.rs . span_lint_and_help seems most appropriate in this case. It allows us to provide an extra help message, and we can't really suggest a better name automatically. This is how it looks: impl EarlyLintPass for FooFunctions { fn check_fn(&mut self, cx: &EarlyContext<'_>, fn_kind: FnKind<'_>, span: Span, _: NodeId) { span_lint_and_help( cx, FOO_FUNCTIONS, span, \"function named `foo`\", None, \"consider using a more meaningful name\" ); }\n} Running our UI test should now produce output that contains the lint message. According to the rustc-dev-guide , the text should be matter of fact and avoid capitalization and periods, unless multiple sentences are needed. When code or an identifier must appear in a message or label, it should be surrounded with single grave accents `.","breadcrumbs":"Development » Adding Lints » Emitting a lint","id":"119","title":"Emitting a lint"},"12":{"body":"Whether to accept a safety comment to be placed above the statement containing the unsafe block Default Value: true Affected lints: undocumented_unsafe_blocks","breadcrumbs":"Configuration » Lint Configuration » accept-comment-above-statement","id":"12","title":"accept-comment-above-statement"},"120":{"body":"Writing the logic for your lint will most likely be different from our example, so this section is kept rather short. Using the check_fn method gives us access to FnKind that has the FnKind::Fn variant. It provides access to the name of the function/method via an Ident . With that we can expand our check_fn method to: impl EarlyLintPass for FooFunctions { fn check_fn(&mut self, cx: &EarlyContext<'_>, fn_kind: FnKind<'_>, span: Span, _: NodeId) { if is_foo_fn(fn_kind) { span_lint_and_help( cx, FOO_FUNCTIONS, span, \"function named `foo`\", None, \"consider using a more meaningful name\" ); } }\n} We separate the lint conditional from the lint emissions because it makes the code a bit easier to read. In some cases this separation would also allow to write some unit tests (as opposed to only UI tests) for the separate function. In our example, is_foo_fn looks like: // use statements, impl EarlyLintPass, check_fn, .. fn is_foo_fn(fn_kind: FnKind<'_>) -> bool { match fn_kind { FnKind::Fn(_, ident, ..) => { // check if `fn` name is `foo` ident.name.as_str() == \"foo\" } // ignore closures FnKind::Closure(..) => false }\n} Now we should also run the full test suite with cargo test. At this point running cargo test should produce the expected output. Remember to run cargo bless to update the .stderr file. cargo test (as opposed to cargo uitest) will also ensure that our lint implementation is not violating any Clippy lints itself. That should be it for the lint implementation. Running cargo test should now pass.","breadcrumbs":"Development » Adding Lints » Adding the lint logic","id":"120","title":"Adding the lint logic"},"121":{"body":"Sometimes a lint makes suggestions that require a certain version of Rust. For example, the manual_strip lint suggests using str::strip_prefix and str::strip_suffix which is only available after Rust 1.45. In such cases, you need to ensure that the MSRV configured for the project is >= the MSRV of the required Rust feature. If multiple features are required, just use the one with a lower MSRV. First, add an MSRV alias for the required feature in clippy_config::msrvs . This can be accessed later as msrvs::STR_STRIP_PREFIX, for example. msrv_aliases! { .. 1,45,0 { STR_STRIP_PREFIX }\n} In order to access the project-configured MSRV, you need to have an msrv field in the LintPass struct, and a constructor to initialize the field. The msrv value is passed to the constructor in clippy_lints/lib.rs. pub struct ManualStrip { msrv: Msrv,\n} impl ManualStrip { pub fn new(conf: &'static Conf) -> Self { Self { msrv: conf.msrv.clone() } }\n} The project's MSRV can then be matched against the feature MSRV in the LintPass using the Msrv::meets method. if !self.msrv.meets(msrvs::STR_STRIP_PREFIX) { return;\n} The project's MSRV can also be specified as an attribute, which overrides the value from clippy.toml. This can be accounted for using the extract_msrv_attr!(LintContext) macro and passing LateContext/EarlyContext. impl<'tcx> LateLintPass<'tcx> for ManualStrip { fn check_expr(&mut self, cx: &LateContext<'tcx>, expr: &'tcx Expr<'_>) { ... } extract_msrv_attr!(LateContext);\n} Once the msrv is added to the lint, a relevant test case should be added to the lint's test file, tests/ui/manual_strip.rs in this example. It should have a case for the version below the MSRV and one with the same contents but for the MSRV version itself. ... #[clippy::msrv = \"1.44\"]\nfn msrv_1_44() { /* something that would trigger the lint */\n} #[clippy::msrv = \"1.45\"]\nfn msrv_1_45() { /* something that would trigger the lint */\n} As a last step, the lint should be added to the lint documentation. This is done in clippy_config/src/conf.rs: define_Conf! { /// Lint: LIST, OF, LINTS, <THE_NEWLY_ADDED_LINT>. The minimum rust version that the project supports (msrv: Option<String> = None), ...\n} Afterwards update the documentation for the book as described in Adding configuration to a lint .","breadcrumbs":"Development » Adding Lints » Specifying the lint's minimum supported Rust version (MSRV)","id":"121","title":"Specifying the lint's minimum supported Rust version (MSRV)"},"122":{"body":"If you have trouble implementing your lint, there is also the internal author lint to generate Clippy code that detects the offending pattern. It does not work for all the Rust syntax, but can give a good starting point. The quickest way to use it, is the Rust playground: play.rust-lang.org . Put the code you want to lint into the editor and add the #[clippy::author] attribute above the item. Then run Clippy via Tools -> Clippy and you should see the generated code in the output below. Here is an example on the playground. If the command was executed successfully, you can copy the code over to where you are implementing your lint.","breadcrumbs":"Development » Adding Lints » Author lint","id":"122","title":"Author lint"},"123":{"body":"To implement a lint, it's helpful to first understand the internal representation that rustc uses. Clippy has the #[clippy::dump] attribute that prints the High-Level Intermediate Representation (HIR) of the item, statement, or expression that the attribute is attached to. To attach the attribute to expressions you often need to enable #![feature(stmt_expr_attributes)]. Here you can find an example, just select Tools and run Clippy .","breadcrumbs":"Development » Adding Lints » Print HIR lint","id":"123","title":"Print HIR lint"},"124":{"body":"The final thing before submitting our PR is to add some documentation to our lint declaration. Please document your lint with a doc comment akin to the following: declare_clippy_lint! { /// ### What it does /// Checks for ... (describe what the lint matches). /// /// ### Why is this bad? /// Supply the reason for linting the code. /// /// ### Example /// /// ```rust,ignore /// // A short example of code that triggers the lint /// ``` /// /// Use instead: /// ```rust,ignore /// // A short example of improved code that doesn't trigger the lint /// ``` #[clippy::version = \"1.29.0\"] pub FOO_FUNCTIONS, pedantic, \"function named `foo`, which is not a descriptive name\"\n} If the lint is in the restriction group because it lints things that are not necessarily “bad” but are more of a style choice, then replace the “Why is this bad?” section heading with “Why restrict this?”, to avoid writing “Why is this bad? It isn't, but ...”. Once your lint is merged, this documentation will show up in the lint list .","breadcrumbs":"Development » Adding Lints » Documentation","id":"124","title":"Documentation"},"125":{"body":"Rustfmt is a tool for formatting Rust code according to style guidelines. Your code has to be formatted by rustfmt before a PR can be merged. Clippy uses nightly rustfmt in the CI. It can be installed via rustup: rustup component add rustfmt --toolchain=nightly Use cargo dev fmt to format the whole codebase. Make sure that rustfmt is installed for the nightly toolchain.","breadcrumbs":"Development » Adding Lints » Running rustfmt","id":"125","title":"Running rustfmt"},"126":{"body":"If you want to debug parts of your lint implementation, you can use the dbg! macro anywhere in your code. Running the tests should then include the debug output in the stdout part.","breadcrumbs":"Development » Adding Lints » Debugging","id":"126","title":"Debugging"},"127":{"body":"There are several lints that deal with the same pattern but suggest different approaches. In other words, some lints may suggest modifications that go in the opposite direction to what some other lints already propose for the same code, creating conflicting diagnostics. When you are creating a lint that ends up in this scenario, the following tips should be encouraged to guide classification: The only case where they should be in the same category is if that category is restriction. For example, semicolon_inside_block and semicolon_outside_block. For all the other cases, they should be in different categories with different levels of allowance. For example, implicit_return (restriction, allow) and needless_return (style, warn). For lints that are in different categories, it is also recommended that at least one of them should be in the restriction category. The reason for this is that the restriction group is the only group where we don't recommend to enable the entire set, but cherry pick lints out of.","breadcrumbs":"Development » Adding Lints » Conflicting lints","id":"127","title":"Conflicting lints"},"128":{"body":"Before submitting your PR make sure you followed all the basic requirements: [ ] Followed lint naming conventions [ ] Added passing UI tests (including committed .stderr file) [ ] cargo test passes locally [ ] Executed cargo dev update_lints [ ] Added lint documentation [ ] Run cargo dev fmt","breadcrumbs":"Development » Adding Lints » PR Checklist","id":"128","title":"PR Checklist"},"129":{"body":"Clippy supports the configuration of lints values using a clippy.toml file which is searched for in: The directory specified by the CLIPPY_CONF_DIR environment variable, or The directory specified by the CARGO_MANIFEST_DIR environment variable, or The current directory. Adding a configuration to a lint can be useful for thresholds or to constrain some behavior that can be seen as a false positive for some users. Adding a configuration is done in the following steps: Adding a new configuration entry to clippy_config::conf like this: /// Lint: LINT_NAME.\n///\n/// <The configuration field doc comment>\n(configuration_ident: Type = DefaultValue), The doc comment is automatically added to the documentation of the listed lints. The default value will be formatted using the Debug implementation of the type. Adding the configuration value to the lint impl struct: This first requires the definition of a lint impl struct. Lint impl structs are usually generated with the declare_lint_pass! macro. This struct needs to be defined manually to add some kind of metadata to it: // Generated struct definition\ndeclare_lint_pass!(StructName => [ LINT_NAME\n]); // New manual definition struct\npub struct StructName {} impl_lint_pass!(StructName => [ LINT_NAME\n]); Next add the configuration value and a corresponding creation method like this: pub struct StructName { configuration_ident: Type,\n} // ... impl StructName { pub fn new(conf: &'static Conf) -> Self { Self { configuration_ident: conf.configuration_ident, } }\n} Passing the configuration value to the lint impl struct: First find the struct construction in the clippy_lints lib file . The configuration value is now cloned or copied into a local value that is then passed to the impl struct like this: // Default generated registration:\nstore.register_*_pass(|| box module::StructName); // New registration with configuration value\nstore.register_*_pass(move || box module::StructName::new(conf)); Congratulations the work is almost done. The configuration value can now be accessed in the linting code via self.configuration_ident. Adding tests: The default configured value can be tested like any normal lint in tests/ui . The configuration itself will be tested separately in tests/ui-toml . Simply add a new subfolder with a fitting name. This folder contains a clippy.toml file with the configuration value and a rust file that should be linted by Clippy. The test can otherwise be written as usual. Update Lint Configuration Run cargo bless --test config-metadata to generate documentation changes for the book.","breadcrumbs":"Development » Adding Lints » Adding configuration to a lint","id":"129","title":"Adding configuration to a lint"},"13":{"body":"Don't lint when comparing the result of a modulo operation to zero. Default Value: true Affected lints: modulo_arithmetic","breadcrumbs":"Configuration » Lint Configuration » allow-comparison-to-zero","id":"13","title":"allow-comparison-to-zero"},"130":{"body":"Here are some pointers to things you are likely going to need for every lint: Clippy utils - Various helper functions. Maybe the function you need is already in here ( is_type_diagnostic_item , implements_trait , snippet , etc) Clippy diagnostics Let chains from_expansion and in_external_macro Span Applicability Common tools for writing lints helps with common operations The rustc-dev-guide explains a lot of internal compiler concepts The nightly rustc docs which has been linked to throughout this guide For EarlyLintPass lints: EarlyLintPass rustc_ast::ast For LateLintPass lints: LateLintPass Ty::TyKind While most of Clippy's lint utils are documented, most of rustc's internals lack documentation currently. This is unfortunate, but in most cases you can probably get away with copying things from existing similar lints. If you are stuck, don't hesitate to ask on Zulip or in the issue/PR.","breadcrumbs":"Development » Adding Lints » Cheat Sheet","id":"130","title":"Cheat Sheet"},"131":{"body":"The first step in the journey of a new lint is the definition and registration of the lint in Clippy's codebase. We can use the Clippy dev tools to handle this step since setting up the lint involves some boilerplate code. Lint types A lint type is the category of items and expressions in which your lint focuses on. As of the writing of this documentation update, there are 12 types of lints besides the numerous standalone lints living under clippy_lints/src/: cargo casts functions loops matches methods misc_early operators transmute types unit_types utils / internal (Clippy internal lints) These types group together lints that share some common behaviors. For instance, functions groups together lints that deal with some aspects of functions in Rust, like definitions, signatures and attributes. For more information, feel free to compare the lint files under any category with All Clippy lints or ask one of the maintainers.","breadcrumbs":"Development » Defining Lints » Define New Lints","id":"131","title":"Define New Lints"},"132":{"body":"A good lint name is important, make sure to check the lint naming guidelines . Don't worry, if the lint name doesn't fit, a Clippy team member will alert you in the PR process. We'll name our example lint that detects functions named \"foo\" foo_functions. Check the lint naming guidelines to see why this name makes sense.","breadcrumbs":"Development » Defining Lints » Lint name","id":"132","title":"Lint name"},"133":{"body":"Now that a name is chosen, we shall register foo_functions as a lint to the codebase. There are two ways to register a lint. Standalone If you believe that this new lint is a standalone lint (that doesn't belong to any specific type like functions or loops), you can run the following command in your Clippy project: $ cargo dev new_lint --name=lint_name --pass=late --category=pedantic There are two things to note here: --pass: We set --pass=late in this command to do a late lint pass. The alternative is an early lint pass. We will discuss this difference in the Lint Passes chapter. --category: If not provided, the category of this new lint will default to nursery. The cargo dev new_lint command will create a new file: clippy_lints/src/foo_functions.rs as well as register the lint . Overall, you should notice that the following files are modified or created: $ git status\nOn branch foo_functions\nChanges not staged for commit: (use \"git add <file>...\" to update what will be committed) (use \"git restore <file>...\" to discard changes in working directory) modified: CHANGELOG.md modified: clippy_lints/src/lib.register_lints.rs modified: clippy_lints/src/lib.register_pedantic.rs modified: clippy_lints/src/lib.rs Untracked files: (use \"git add <file>...\" to include in what will be committed) clippy_lints/src/foo_functions.rs tests/ui/foo_functions.rs Specific Type Note : Lint types are listed in the \"Lint types\" section If you believe that this new lint belongs to a specific type of lints, you can run cargo dev new_lint with a --type option. Since our foo_functions lint is related to function calls, one could argue that we should put it into a group of lints that detect some behaviors of functions, we can put it in the functions group. Let's run the following command in your Clippy project: $ cargo dev new_lint --name=foo_functions --type=functions --category=pedantic This command will create, among other things, a new file: clippy_lints/src/{type}/foo_functions.rs. In our case, the path will be clippy_lints/src/functions/foo_functions.rs. Notice how this command has a --type flag instead of --pass. Unlike a standalone definition, this lint won't be registered in the traditional sense. Instead, you will call your lint from within the type's lint pass, found in clippy_lints/src/{type}/mod.rs. A type is just the name of a directory in clippy_lints/src, like functions in the example command. Clippy groups together some lints that share common behaviors, so if your lint falls into one, it would be best to add it to that type. Overall, you should notice that the following files are modified or created: $ git status\nOn branch foo_functions\nChanges not staged for commit: (use \"git add <file>...\" to update what will be committed) (use \"git restore <file>...\" to discard changes in working directory) modified: CHANGELOG.md modified: clippy_lints/src/declared_lints.rs modified: clippy_lints/src/functions/mod.rs Untracked files: (use \"git add <file>...\" to include in what will be committed) clippy_lints/src/functions/foo_functions.rs tests/ui/foo_functions.rs","breadcrumbs":"Development » Defining Lints » Add and Register the Lint","id":"133","title":"Add and Register the Lint"},"134":{"body":"After cargo dev new_lint, you should see a macro with the name define_clippy_lints. It will be in the same file if you defined a standalone lint, and it will be in mod.rs if you defined a type-specific lint. The macro looks something like this: declare_clippy_lint! { /// ### What it does /// /// // Describe here what does the lint do. /// /// Triggers when detects... /// /// ### Why is this bad? /// /// // Describe why this pattern would be bad /// /// It can lead to... /// /// ### Example /// ```rust /// // example code where Clippy issues a warning /// ``` /// Use instead: /// ```rust /// // example code which does not raise Clippy warning /// ``` #[clippy::version = \"1.70.0\"] // <- In which version was this implemented, keep it up to date! pub LINT_NAME, // <- The lint name IN_ALL_CAPS pedantic, // <- The lint group \"default lint description\" // <- A lint description, e.g. \"A function has an unit return type.\"\n}","breadcrumbs":"Development » Defining Lints » The define_clippy_lints macro","id":"134","title":"The define_clippy_lints macro"},"135":{"body":"If we run the cargo dev new_lint command for a new lint, the lint will be automatically registered and there is nothing more to do. However, sometimes we might want to declare a new lint by hand. In this case, we'd use cargo dev update_lints command afterwards. When a lint is manually declared, we might need to register the lint pass manually in the register_lints function in clippy_lints/src/lib.rs: store.register_late_pass(|_| Box::new(foo_functions::FooFunctions)); As you might have guessed, where there's something late, there is something early: in Clippy there is a register_early_pass method as well. More on early vs. late passes in the Lint Passes chapter. Without a call to one of register_early_pass or register_late_pass, the lint pass in question will not be run.","breadcrumbs":"Development » Defining Lints » Lint registration","id":"135","title":"Lint registration"},"136":{"body":"Developing lints for Clippy is a Test-Driven Development (TDD) process because our first task before implementing any logic for a new lint is to write some test cases.","breadcrumbs":"Development » Writing tests » Testing","id":"136","title":"Testing"},"137":{"body":"When we develop Clippy, we enter a complex and chaotic realm full of programmatic issues, stylistic errors, illogical code and non-adherence to convention. Tests are the first layer of order we can leverage to define when and where we want a new lint to trigger or not. Moreover, writing tests first help Clippy developers to find a balance for the first iteration of and further enhancements for a lint. With test cases on our side, we will not have to worry about over-engineering a lint on its first version nor missing out some obvious edge cases of the lint. This approach empowers us to iteratively enhance each lint.","breadcrumbs":"Development » Writing tests » Develop Lints with Tests","id":"137","title":"Develop Lints with Tests"},"138":{"body":"We use UI tests for testing in Clippy. These UI tests check that the output of Clippy is exactly as we expect it to be. Each test is just a plain Rust file that contains the code we want to check. The output of Clippy is compared against a .stderr file. Note that you don't have to create this file yourself. We'll get to generating the .stderr files with the command cargo bless (seen later on). Write Test Cases Let us now think about some tests for our imaginary foo_functions lint. We start by opening the test file tests/ui/foo_functions.rs that was created by cargo dev new_lint. Update the file with some examples to get started: #![warn(clippy::foo_functions)] // < Add this, so the lint is guaranteed to be enabled in this file // Impl methods\nstruct A;\nimpl A { pub fn fo(&self) {} pub fn foo(&self) {} //~ ERROR: function called \"foo\" pub fn food(&self) {}\n} // Default trait methods\ntrait B { fn fo(&self) {} fn foo(&self) {} //~ ERROR: function called \"foo\" fn food(&self) {}\n} // Plain functions\nfn fo() {}\nfn foo() {} //~ ERROR: function called \"foo\"\nfn food() {} fn main() { // We also don't want to lint method calls foo(); let a = A; a.foo();\n} Without actual lint logic to emit the lint when we see a foo function name, this test will just pass, because no lint will be emitted. However, we can now run the test with the following command: $ TESTNAME=foo_functions cargo uitest Clippy will compile and it will conclude with an ok for the tests: ...Clippy warnings and test outputs...\ntest compile_test ... ok\ntest result: ok. 3 passed; 0 failed; 0 ignored; 0 measured; 0 filtered out; finished in 0.48s This is normal. After all, we wrote a bunch of Rust code but we haven't really implemented any logic for Clippy to detect foo functions and emit a lint. As we gradually implement our lint logic, we will keep running this UI test command. Clippy will begin outputting information that allows us to check if the output is turning into what we want it to be. Example output As our foo_functions lint is tested, the output would look something like this: failures:\n---- compile_test stdout ----\nnormalized stderr:\nerror: function called \"foo\" --> tests/ui/foo_functions.rs:6:12 |\nLL | pub fn foo(&self) {} | ^^^ | = note: `-D clippy::foo-functions` implied by `-D warnings`\nerror: function called \"foo\" --> tests/ui/foo_functions.rs:13:8 |\nLL | fn foo(&self) {} | ^^^\nerror: function called \"foo\" --> tests/ui/foo_functions.rs:19:4 |\nLL | fn foo() {} | ^^^\nerror: aborting due to 3 previous errors Note the failures label at the top of the fragment, we'll get rid of it (saving this output) in the next section. Note: You can run multiple test files by specifying a comma separated list: TESTNAME=foo_functions,bar_methods,baz_structs. cargo bless Once we are satisfied with the output, we need to run this command to generate or update the .stderr file for our lint: $ TESTNAME=foo_functions cargo uibless This writes the emitted lint suggestions and fixes to the .stderr file, with the reason for the lint, suggested fixes, and line numbers, etc. Running TESTNAME=foo_functions cargo uitest should pass then. When we commit our lint, we need to commit the generated .stderr files, too. In general, you should only commit files changed by cargo bless for the specific lint you are creating/editing. Note: If the generated .stderr, and .fixed files are empty, they should be removed.","breadcrumbs":"Development » Writing tests » Clippy UI Tests","id":"138","title":"Clippy UI Tests"},"139":{"body":"Some lints can be configured through a clippy.toml file. Those configuration values are tested in tests/ui-toml. To add a new test there, create a new directory and add the files: clippy.toml: Put here the configuration value you want to test. lint_name.rs: A test file where you put the testing code, that should see a different lint behavior according to the configuration set in the clippy.toml file. The potential .stderr and .fixed files can again be generated with cargo bless.","breadcrumbs":"Development » Writing tests » toml Tests","id":"139","title":"toml Tests"},"14":{"body":"Whether dbg! should be allowed in test functions or #[cfg(test)] Default Value: false Affected lints: dbg_macro","breadcrumbs":"Configuration » Lint Configuration » allow-dbg-in-tests","id":"14","title":"allow-dbg-in-tests"},"140":{"body":"The process of testing is different for Cargo lints in that now we are interested in the Cargo.toml manifest file. In this case, we also need a minimal crate associated with that manifest. Those tests are generated in tests/ui-cargo. Imagine we have a new example lint that is named foo_categories, we can run: $ cargo dev new_lint --name=foo_categories --pass=late --category=cargo After running cargo dev new_lint we will find by default two new crates, each with its manifest file: tests/ui-cargo/foo_categories/fail/Cargo.toml: this file should cause the new lint to raise an error. tests/ui-cargo/foo_categories/pass/Cargo.toml: this file should not trigger the lint. If you need more cases, you can copy one of those crates (under foo_categories) and rename it. The process of generating the .stderr file is the same as for other lints and prepending the TESTNAME variable to cargo uitest works for Cargo lints too.","breadcrumbs":"Development » Writing tests » Cargo Lints","id":"140","title":"Cargo Lints"},"141":{"body":"If the lint you are working on is making use of structured suggestions, rustfix will apply the suggestions from the lint to the test file code and compare that to the contents of a .fixed file. Structured suggestions tell a user how to fix or re-write certain code that has been linted with span_lint_and_sugg . Should span_lint_and_sugg be used to generate a suggestion, but not all suggestions lead to valid code, you can use the //@no-rustfix comment on top of the test file, to not run rustfix on that file. We'll talk about suggestions more in depth in a later chapter . Use cargo bless to automatically generate the .fixed file after running the tests.","breadcrumbs":"Development » Writing tests » Rustfix Tests","id":"141","title":"Rustfix Tests"},"142":{"body":"Manually testing against an example file can be useful if you have added some println!s and the test suite output becomes unreadable. To try Clippy with your local modifications, run from the working copy root. $ cargo dev lint input.rs","breadcrumbs":"Development » Writing tests » Testing Manually","id":"142","title":"Testing Manually"},"143":{"body":"Before working on the logic of a new lint, there is an important decision that every Clippy developer must make: to use EarlyLintPass or LateLintPass . In short, the LateLintPass has access to type and symbol information while the EarlyLintPass doesn't. If you don't need access to type information, use the EarlyLintPass. Let us expand on these two traits more below.","breadcrumbs":"Development » Lint Passes » Lint passes","id":"143","title":"Lint passes"},"144":{"body":"If you examine the documentation on EarlyLintPass closely, you'll see that every method defined for this trait utilizes a EarlyContext . In EarlyContext's documentation, it states: Context for lint checking of the AST, after expansion, before lowering to HIR. Voilà. EarlyLintPass works only on the Abstract Syntax Tree (AST) level. And AST is generated during the lexing and parsing phase of code compilation. Therefore, it doesn't know what a symbol means or information about types, and it should be our trait choice for a new lint if the lint only deals with syntax-related issues. While linting speed has not been a concern for Clippy, the EarlyLintPass is faster, and it should be your choice if you know for sure a lint does not need type information. As a reminder, run the following command to generate boilerplate for lints that use EarlyLintPass: $ cargo dev new_lint --name=<your_new_lint> --pass=early --category=<your_category_choice> Example for EarlyLintPass Take a look at the following code: let x = OurUndefinedType;\nx.non_existing_method(); From the AST perspective, both lines are \"grammatically\" correct. The assignment uses a let and ends with a semicolon. The invocation of a method looks fine, too. As programmers, we might raise a few questions already, but the parser is okay with it. This is what we mean when we say EarlyLintPass deals with only syntax on the AST level. Alternatively, think of the foo_functions lint we mentioned in the Define New Lints chapter. We want the foo_functions lint to detect functions with foo as their name. Writing a lint that only checks for the name of a function means that we only work with the AST and don't have to access the type system at all (the type system is where LateLintPass comes into the picture).","breadcrumbs":"Development » Lint Passes » EarlyLintPass","id":"144","title":"EarlyLintPass"},"145":{"body":"In contrast to EarlyLintPass, LateLintPass contains type information. If you examine the documentation on LateLintPass closely, you see that every method defined in this trait utilizes a LateContext . In LateContext's documentation we will find methods that deal with type-checking, which do not exist in EarlyContext, such as: maybe_typeck_results typeck_results Example for LateLintPass Let us take a look with the following example: let x = OurUndefinedType;\nx.non_existing_method(); These two lines of code are syntactically correct code from the perspective of the AST. We have an assignment and invoke a method on the variable that is of a type. Grammatically, everything is in order for the parser. However, going down a level and looking at the type information, the compiler will notice that both OurUndefinedType and non_existing_method() are undefined . As Clippy developers, to access such type information, we must implement LateLintPass on our lint. When you browse through Clippy's lints, you will notice that almost every lint is implemented in a LateLintPass, specifically because we often need to check not only for syntactic issues but also type information. Another limitation of the EarlyLintPass is that the nodes are only identified by their position in the AST. This means that you can't just get an id and request a certain node. For most lints that is fine, but we have some lints that require the inspection of other nodes, which is easier at the HIR level. In these cases, LateLintPass is the better choice. As a reminder, run the following command to generate boilerplate for lints that use LateLintPass: $ cargo dev new_lint --name=<your_new_lint> --pass=late --category=<your_category_choice>","breadcrumbs":"Development » Lint Passes » LateLintPass","id":"145","title":"LateLintPass"},"146":{"body":"Once we have defined a lint , written UI tests and chosen the lint pass for the lint, we can begin the implementation of the lint logic so that we can emit it and gradually work towards a lint that behaves as expected. Note that we will not go into concrete implementation of a lint logic in this chapter. We will go into details in later chapters as well as in two examples of real Clippy lints. To emit a lint, we must implement a pass (see Lint Passes ) for the lint that we have declared. In this example we'll implement a \"late\" lint, so take a look at the LateLintPass documentation, which provides an abundance of methods that we can implement for our lint. pub trait LateLintPass<'tcx>: LintPass { // Trait methods\n} By far the most common method used for Clippy lints is check_expr method , this is because Rust is an expression language and, more often than not, the lint we want to work on must examine expressions. Note: If you don't fully understand what expressions are in Rust, take a look at the official documentation on expressions Other common ones include the check_fn method and the check_item method . Emitting a lint Inside the trait method that we implement, we can write down the lint logic and emit the lint with suggestions. Clippy's diagnostics provides quite a few diagnostic functions that we can use to emit lints. Take a look at the documentation to pick one that suits your lint's needs the best. Some common ones you will encounter in the Clippy repository includes: span_lint : Emits a lint without providing any other information span_lint_and_note : Emits a lint and adds a note span_lint_and_help : Emits a lint and provides a helpful message span_lint_and_sugg : Emits a lint and provides a suggestion to fix the code span_lint_and_then : Like span_lint, but allows for a lot of output customization. impl<'tcx> LateLintPass<'tcx> for LintName { fn check_expr(&mut self, cx: &LateContext<'tcx>, expr: &'tcx Expr<'_>) { // Imagine that `some_lint_expr_logic` checks for requirements for emitting the lint if some_lint_expr_logic(expr) { span_lint_and_help( cx, // < The context LINT_NAME, // < The name of the lint in ALL CAPS expr.span, // < The span to lint \"message on why the lint is emitted\", None, // < An optional help span (to highlight something in the lint) \"message that provides a helpful suggestion\", ); } }\n} Note: The message should be matter of fact and avoid capitalization and punctuation. If multiple sentences are needed, the messages should probably be split up into an error + a help / note / suggestion message.","breadcrumbs":"Development » Emitting lints » Emitting a lint","id":"146","title":"Emitting a lint"},"147":{"body":"Some lints know what to change in order to fix the code. For example, the lint range_plus_one warns for ranges where the user wrote x..y + 1 instead of using an inclusive range (x..=y). The fix to this code would be changing the x..y + 1 expression to x..=y. This is where suggestions come in . A suggestion is a change that the lint provides to fix the issue it is linting. The output looks something like this (from the example earlier): error: an inclusive range would be more readable --> tests/ui/range_plus_minus_one.rs:37:14 |\nLL | for _ in 1..1 + 1 {} | ^^^^^^^^ help: use: `1..=1` Not all suggestions are always right , some of them require human supervision, that's why we have Applicability . Applicability indicates confidence in the correctness of the suggestion, some are always right (Applicability::MachineApplicable), but we use Applicability::MaybeIncorrect and others when talking about a suggestion that may be incorrect. Example The same lint LINT_NAME but that emits a suggestion would look something like this: impl<'tcx> LateLintPass<'tcx> for LintName { fn check_expr(&mut self, cx: &LateContext<'tcx>, expr: &'tcx Expr<'_>) { // Imagine that `some_lint_expr_logic` checks for requirements for emitting the lint if some_lint_expr_logic(expr) { span_lint_and_sugg( // < Note this change cx, LINT_NAME, span, \"message on why the lint is emitted\", \"use\", format!(\"foo + {} * bar\", snippet(cx, expr.span, \"<default>\")), // < Suggestion Applicability::MachineApplicable, ); } }\n} Suggestions generally use the format! macro to interpolate the old values with the new ones. To get code snippets, use one of the snippet* functions from clippy_utils::source.","breadcrumbs":"Development » Emitting lints » Suggestions: Automatic fixes","id":"147","title":"Suggestions: Automatic fixes"},"148":{"body":"Notes are presented separately from the main lint message, they provide useful information that the user needs to understand why the lint was activated. They are the most helpful when attached to a span. Examples: Notes error: calls to `std::mem::forget` with a reference instead of an owned value. Forgetting a reference does nothing. --> tests/ui/drop_forget_ref.rs:10:5 |\n10 | forget(&SomeStruct); | ^^^^^^^^^^^^^^^^^^^ | = note: `-D clippy::forget-ref` implied by `-D warnings`\nnote: argument has type &SomeStruct --> tests/ui/drop_forget_ref.rs:10:12 |\n10 | forget(&SomeStruct); | ^^^^^^^^^^^ Help Messages Help messages are specifically to help the user. These are used in situation where you can't provide a specific machine applicable suggestion. They can also be attached to a span. Example: error: constant division of 0.0 with 0.0 will always result in NaN --> tests/ui/zero_div_zero.rs:6:25 |\n6 | let other_f64_nan = 0.0f64 / 0.0; | ^^^^^^^^^^^^ | = help: consider using `f64::NAN` if you would like a constant representing NaN Suggestions Suggestions are the most helpful, they are changes to the source code to fix the error. The magic in suggestions is that tools like rustfix can detect them and automatically fix your code. Example: error: This `.fold` can be more succinctly expressed as `.any`\n--> tests/ui/methods.rs:390:13 |\n390 | let _ = (0..3).fold(false, |acc, x| acc || x > 2); | ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ help: try: `.any(|x| x > 2)` | Snippets Snippets are pieces of the source code (as a string), they are extracted generally using the snippet function. For example, if you want to know how an item looks (and you know the item's span), you could use snippet(cx, span, \"..\").","breadcrumbs":"Development » Emitting lints » How to choose between notes, help messages and suggestions","id":"148","title":"How to choose between notes, help messages and suggestions"},"149":{"body":"Now, if we run our UI test , we should see that Clippy now produces output that contains the lint message we designed. The next step is to implement the logic properly, which is a detail that we will cover in the next chapters.","breadcrumbs":"Development » Emitting lints » Final: Run UI Tests to Emit the Lint","id":"149","title":"Final: Run UI Tests to Emit the Lint"},"15":{"body":"Whether expect should be allowed in test functions or #[cfg(test)] Default Value: false Affected lints: expect_used","breadcrumbs":"Configuration » Lint Configuration » allow-expect-in-tests","id":"15","title":"allow-expect-in-tests"},"150":{"body":"When we work on a new lint or improve an existing lint, we might want to retrieve the type Ty of an expression Expr for a variety of reasons. This can be achieved by utilizing the LateContext that is available for LateLintPass .","breadcrumbs":"Development » Type Checking » Type Checking","id":"150","title":"Type Checking"},"151":{"body":"The lint context LateContext and TypeckResults (returned by LateContext::typeck_results) are the two most useful data structures in LateLintPass. They allow us to jump to type definitions and other compilation stages such as HIR. Note: LateContext.typeck_results's return value is TypeckResults and is created in the type checking step, it includes useful information such as types of expressions, ways to resolve methods and so on. TypeckResults contains useful methods such as expr_ty , which gives us access to the underlying structure Ty of a given expression. pub fn expr_ty(&self, expr: &Expr<'_>) -> Ty<'tcx> As a side note, besides expr_ty, TypeckResults contains a pat_ty() method that is useful for retrieving a type from a pattern.","breadcrumbs":"Development » Type Checking » LateContext and TypeckResults","id":"151","title":"LateContext and TypeckResults"},"152":{"body":"Ty struct contains the type information of an expression. Let's take a look at rustc_middle's Ty struct to examine this struct: pub struct Ty<'tcx>(Interned<'tcx, WithStableHash<TyS<'tcx>>>); At a first glance, this struct looks quite esoteric. But at a closer look, we will see that this struct contains many useful methods for type checking. For instance, is_char checks if the given Ty struct corresponds to the primitive character type. is_* Usage In some scenarios, all we need to do is check if the Ty of an expression is a specific type, such as char type, so we could write the following: impl LateLintPass<'_> for MyStructLint { fn check_expr(&mut self, cx: &LateContext<'_>, expr: &Expr<'_>) { // Get type of `expr` let ty = cx.typeck_results().expr_ty(expr); // Check if the `Ty` of this expression is of character type if ty.is_char() { println!(\"Our expression is a char!\"); } }\n} Furthermore, if we examine the source code for is_char, we find something very interesting: #[inline]\npub fn is_char(self) -> bool { matches!(self.kind(), Char)\n} Indeed, we just discovered Ty's kind() method , which provides us with TyKind of a Ty.","breadcrumbs":"Development » Type Checking » Ty","id":"152","title":"Ty"},"153":{"body":"TyKind defines the kinds of types in Rust's type system. Peeking into TyKind documentation , we will see that it is an enum of over 25 variants, including items such as Bool, Int, Ref, etc. kind Usage The TyKind of Ty can be returned by calling Ty.kind() method . We often use this method to perform pattern matching in Clippy. For instance, if we want to check for a struct, we could examine if the ty.kind corresponds to an Adt (algebraic data type) and if its AdtDef is a struct: impl LateLintPass<'_> for MyStructLint { fn check_expr(&mut self, cx: &LateContext<'_>, expr: &Expr<'_>) { // Get type of `expr` let ty = cx.typeck_results().expr_ty(expr); // Match its kind to enter the type match ty.kind { ty::Adt(adt_def, _) if adt_def.is_struct() => println!(\"Our `expr` is a struct!\"), _ => () } }\n}","breadcrumbs":"Development » Type Checking » TyKind","id":"153","title":"TyKind"},"154":{"body":"We've been talking about ty::Ty this whole time without addressing hir::Ty , but the latter is also important to understand. hir::Ty would represent what the user wrote, while ty::Ty is how the compiler sees the type and has more information. Example: fn foo(x: u32) -> u32 { x } Here the HIR sees the types without \"thinking\" about them, it knows that the function takes an u32 and returns an u32. As far as hir::Ty is concerned those might be different types. But at the ty::Ty level the compiler understands that they're the same type, in-depth lifetimes, etc... To get from a hir::Ty to a ty::Ty, you can use the lower_ty function outside of bodies or the TypeckResults::node_type() method inside of bodies. Warning : Don't use lower_ty inside of bodies, because this can cause ICEs.","breadcrumbs":"Development » Type Checking » hir::Ty and ty::Ty","id":"154","title":"hir::Ty and ty::Ty"},"155":{"body":"A common usecase for creating types programmatically is when we want to check if a type implements a trait (see Trait Checking ). Here's an example of how to create a Ty for a slice of u8, i.e. [u8] use rustc_middle::ty::Ty;\n// assume we have access to a LateContext\nlet ty = Ty::new_slice(cx.tcx, Ty::new_u8()); In general, we rely on Ty::new_* methods. These methods define the basic building-blocks that the type-system and trait-system use to define and understand the written code.","breadcrumbs":"Development » Type Checking » Creating Types programmatically","id":"155","title":"Creating Types programmatically"},"156":{"body":"Below are some useful links to further explore the concepts covered in this chapter: Stages of compilation Diagnostic items Type checking Ty module","breadcrumbs":"Development » Type Checking » Useful Links","id":"156","title":"Useful Links"},"157":{"body":"Besides type checking , we might want to examine if a specific type Ty implements certain trait when implementing a lint. There are three approaches to achieve this, depending on if the target trait that we want to examine has a diagnostic item , lang item , or neither.","breadcrumbs":"Development » Trait Checking » Trait Checking","id":"157","title":"Trait Checking"},"158":{"body":"As explained in the Rust Compiler Development Guide , diagnostic items are introduced for identifying types via Symbols . For instance, if we want to examine whether an expression implements the Iterator trait, we could simply write the following code, providing the LateContext (cx), our expression at hand, and the symbol of the trait in question: use clippy_utils::is_trait_method;\nuse rustc_hir::Expr;\nuse rustc_lint::{LateContext, LateLintPass};\nuse rustc_span::symbol::sym; impl LateLintPass<'_> for CheckIteratorTraitLint { fn check_expr(&mut self, cx: &LateContext<'_>, expr: &Expr<'_>) { let implements_iterator = cx.tcx.get_diagnostic_item(sym::Iterator).map_or(false, |id| { implements_trait(cx, cx.typeck_results().expr_ty(arg), id, &[]) }); if implements_iterator { // [...] } }\n} Note : Refer to this index for all the defined Symbols.","breadcrumbs":"Development » Trait Checking » Using Diagnostic Items","id":"158","title":"Using Diagnostic Items"},"159":{"body":"Besides diagnostic items, we can also use lang_items . Take a look at the documentation to find that LanguageItems contains all language items defined in the compiler. Using one of its *_trait method, we could obtain the DefId of any specific item, such as Clone, Copy, Drop, Eq, which are familiar to many Rustaceans. For instance, if we want to examine whether an expression expr implements Drop trait, we could access LanguageItems via our LateContext's TyCtxt , which provides a lang_items method that will return the id of Drop trait to us. Then, by calling Clippy utils function implements_trait we can check that the Ty of the expr implements the trait: use clippy_utils::implements_trait;\nuse rustc_hir::Expr;\nuse rustc_lint::{LateContext, LateLintPass}; impl LateLintPass<'_> for CheckDropTraitLint { fn check_expr(&mut self, cx: &LateContext<'_>, expr: &Expr<'_>) { let ty = cx.typeck_results().expr_ty(expr); if cx.tcx.lang_items() .drop_trait() .map_or(false, |id| implements_trait(cx, ty, id, &[])) { println!(\"`expr` implements `Drop` trait!\"); } }\n}","breadcrumbs":"Development » Trait Checking » Using Lang Items","id":"159","title":"Using Lang Items"},"16":{"body":"Whether to allow mixed uninlined format args, e.g. format!(\"{} {}\", a, foo.bar) Default Value: true Affected lints: uninlined_format_args","breadcrumbs":"Configuration » Lint Configuration » allow-mixed-uninlined-format-args","id":"16","title":"allow-mixed-uninlined-format-args"},"160":{"body":"If neither diagnostic item nor a language item is available, we can use clippy_utils::paths with the match_trait_method to determine trait implementation. Note : This approach should be avoided if possible, the best thing to do would be to make a PR to rust-lang/rust adding a diagnostic item. Below, we check if the given expr implements the Iterator's trait method cloned : use clippy_utils::{match_trait_method, paths};\nuse rustc_hir::Expr;\nuse rustc_lint::{LateContext, LateLintPass}; impl LateLintPass<'_> for CheckTokioAsyncReadExtTrait { fn check_expr(&mut self, cx: &LateContext<'_>, expr: &Expr<'_>) { if match_trait_method(cx, expr, &paths::CORE_ITER_CLONED) { println!(\"`expr` implements `CORE_ITER_CLONED` trait!\"); } }\n}","breadcrumbs":"Development » Trait Checking » Using Type Path","id":"160","title":"Using Type Path"},"161":{"body":"Traits are often generic over a type parameter, e.g. Borrow<T> is generic over T. Rust allows us to implement a trait for a specific type. For example, we can implement Borrow<[u8]> for a hypothetical type Foo. Let's suppose that we would like to find whether our type actually implements Borrow<[u8]>. To do so, we can use the same implements_trait function as above, and supply a type parameter that represents [u8]. Since [u8] is a specialization of [T], we can use the Ty::new_slice method to create a type that represents [T] and supply u8 as a type parameter. To create a ty::Ty programmatically, we rely on Ty::new_* methods. These methods create a TyKind and then wrap it in a Ty struct. This means we have access to all the primitive types, such as Ty::new_char, Ty::new_bool, Ty::new_int, etc. We can also create more complex types, such as slices, tuples, and references out of these basic building blocks. For trait checking, it is not enough to create the types, we need to convert them into GenericArg . In rustc, a generic is an entity that the compiler understands and has three kinds, type, const and lifetime. By calling .into() on a constructed Ty , we wrap the type into a generic which can then be used by the query system to decide whether the specialized trait is implemented. The following code demonstrates how to do this: use rustc_middle::ty::Ty;\nuse clippy_utils::ty::implements_trait;\nuse rustc_span::symbol::sym; let ty = todo!(\"Get the `Foo` type to check for a trait implementation\");\nlet borrow_id = cx.tcx.get_diagnostic_item(sym::Borrow).unwrap(); // avoid unwrap in real code\nlet slice_of_bytes_t = Ty::new_slice(cx.tcx, cx.tcx.types.u8);\nlet generic_param = slice_of_bytes_t.into();\nif implements_trait(cx, ty, borrow_id, &[generic_param]) { todo!(\"Rest of lint implementation\")\n} In essence, the Ty struct allows us to create types programmatically in a representation that can be used by the compiler and the query engine. We then use the rustc_middle::Ty of the type we are interested in, and query the compiler to see if it indeed implements the trait we are interested in.","breadcrumbs":"Development » Trait Checking » Creating Types Programmatically","id":"161","title":"Creating Types Programmatically"},"162":{"body":"In some scenarios we might want to check for methods when developing a lint. There are two kinds of questions that we might be curious about: Invocation: Does an expression call a specific method? Definition: Does an impl define a method?","breadcrumbs":"Development » Method Checking » Method Checking","id":"162","title":"Method Checking"},"163":{"body":"Suppose we have an expr, we can check whether it calls a specific method, e.g. our_fancy_method, by performing a pattern match on the ExprKind that we can access from expr.kind: use rustc_hir as hir;\nuse rustc_lint::{LateContext, LateLintPass};\nuse rustc_span::sym;\nuse clippy_utils::is_trait_method; impl<'tcx> LateLintPass<'tcx> for OurFancyMethodLint { fn check_expr(&mut self, cx: &LateContext<'tcx>, expr: &'tcx hir::Expr<'_>) { // Check our expr is calling a method with pattern matching if let hir::ExprKind::MethodCall(path, _, [self_arg, ..]) = &expr.kind // Check if the name of this method is `our_fancy_method` && path.ident.name == sym!(our_fancy_method) // We can check the type of the self argument whenever necessary. // (It's necessary if we want to check that method is specifically belonging to a specific trait, // for example, a `map` method could belong to user-defined trait instead of to `Iterator`) // See the next section for more information. && is_trait_method(cx, self_arg, sym::OurFancyTrait) { println!(\"`expr` is a method call for `our_fancy_method`\"); } }\n} Take a closer look at the ExprKind enum variant MethodCall for more information on the pattern matching. As mentioned in Define Lints , the methods lint type is full of pattern matching with MethodCall in case the reader wishes to explore more. Additionally, we use the clippy_utils::sym! macro to conveniently convert an input our_fancy_method into a Symbol and compare that symbol to the Ident 's name in the PathSegment in the MethodCall .","breadcrumbs":"Development » Method Checking » Checking if an expr is calling a specific method","id":"163","title":"Checking if an expr is calling a specific method"},"164":{"body":"While sometimes we want to check whether a method is being called or not, other times we want to know if our Ty defines a method. To check if our impl block defines a method our_fancy_method, we will utilize the check_impl_item method that is available in our beloved LateLintPass (for more information, refer to the \"Lint Passes\" chapter in the Clippy book). This method provides us with an ImplItem struct, which represents anything within an impl block. Let us take a look at how we might check for the implementation of our_fancy_method on a type: use clippy_utils::ty::is_type_diagnostic_item;\nuse clippy_utils::return_ty;\nuse rustc_hir::{ImplItem, ImplItemKind};\nuse rustc_lint::{LateContext, LateLintPass};\nuse rustc_span::symbol::sym; impl<'tcx> LateLintPass<'tcx> for MyTypeImpl { fn check_impl_item(&mut self, cx: &LateContext<'tcx>, impl_item: &'tcx ImplItem<'_>) { // Check if item is a method/function if let ImplItemKind::Fn(ref signature, _) = impl_item.kind // Check the method is named `our_fancy_method` && impl_item.ident.name == sym!(our_fancy_method) // We can also check it has a parameter `self` && signature.decl.implicit_self.has_implicit_self() // We can go even further and even check if its return type is `String` && is_type_diagnostic_item(cx, return_ty(cx, impl_item.hir_id), sym::String) { println!(\"`our_fancy_method` is implemented!\"); } }\n}","breadcrumbs":"Development » Method Checking » Checking if a impl block implements a method","id":"164","title":"Checking if a impl block implements a method"},"165":{"body":"Sometimes we might encounter Rust macro expansions while working with Clippy. While macro expansions are not as dramatic and profound as the expansion of our universe, they can certainly bring chaos to the orderly world of code and logic. The general rule of thumb is that we should ignore code with macro expansions when working with Clippy because the code can be dynamic in ways that are difficult or impossible for us to foresee.","breadcrumbs":"Development » Macro Expansions » Dealing with macros and expansions","id":"165","title":"Dealing with macros and expansions"},"166":{"body":"What exactly do we mean by dynamic in ways that are difficult to foresee ? Macros are expanded in the EarlyLintPass level, so the Abstract Syntax Tree (AST) is generated in place of macros. This means the code which we work with in Clippy is already expanded. If we wrote a new lint, there is a possibility that the lint is triggered in macro-generated code. Since this expanded macro code is not written by the macro's user but really by the macro's author, the user cannot and should not be responsible for fixing the issue that triggers the lint. Besides, a Span in a macro can be changed by the macro author. Therefore, any lint check related to lines or columns should be avoided since they might be changed at any time and become unreliable or incorrect information. Because of these unforeseeable or unstable behaviors, macro expansion should often not be regarded as a part of the stable API. This is also why most lints check if they are inside a macro or not before emitting suggestions to the end user to avoid false positives.","breadcrumbs":"Development » Macro Expansions » False Positives","id":"166","title":"False Positives"},"167":{"body":"Several functions are available for working with macros. The Span.from_expansion method We could utilize a span's from_expansion method, which detects if the span is from a macro expansion / desugaring. This is a very common first step in a lint: if expr.span.from_expansion() { // We most likely want to ignore it. return;\n} Span.ctxt method The span's context, given by the method ctxt and returning SyntaxContext , represents if the span is from a macro expansion and, if it is, which macro call expanded this span. Sometimes, it is useful to check if the context of two spans are equal. For instance, suppose we have the following line of code that would expand into 1 + 0: // The following code expands to `1 + 0` for both `EarlyLintPass` and `LateLintPass`\n1 + mac!() Assuming that we'd collect the 1 expression as a variable left and the 0/mac!() expression as a variable right, we can simply compare their contexts. If the context is different, then we most likely are dealing with a macro expansion and should just ignore it: if left.span.ctxt() != right.span.ctxt() { // The code author most likely cannot modify this expression return;\n} Note : Code that is not from expansion is in the \"root\" context. So any spans whose from_expansion returns false can be assumed to have the same context. Because of this, using span.from_expansion() is often sufficient. Going a bit deeper, in a simple expression such as a == b, a and b have the same context. However, in a macro_rules! with a == $b, $b is expanded to an expression that contains a different context from a. Take a look at the following macro m: macro_rules! m { ($a:expr, $b:expr) => { if $a.is_some() { $b; } }\n} let x: Option<u32> = Some(42);\nm!(x, x.unwrap()); If the m!(x, x.unwrap()); line is expanded, we would get two expanded expressions: x.is_some() (from the $a.is_some() line in the m macro) x.unwrap() (corresponding to $b in the m macro) Suppose x.is_some() expression's span is associated with the x_is_some_span variable and x.unwrap() expression's span is associated with x_unwrap_span variable, we could assume that these two spans do not share the same context: // x.is_some() is from inside the macro\n// x.unwrap() is from outside the macro\nassert_ne!(x_is_some_span.ctxt(), x_unwrap_span.ctxt()); The in_external_macro function rustc_middle::lint provides a function ( in_external_macro ) that can detect if the given span is from a macro defined in a foreign crate. Therefore, if we really want a new lint to work with macro-generated code, this is the next line of defense to avoid macros not defined inside the current crate since it is unfair to the user if Clippy lints code which the user cannot change. For example, assume we have the following code that is being examined by Clippy: #[macro_use]\nextern crate a_foreign_crate_with_macros; // `foo` macro is defined in `a_foreign_crate_with_macros`\nfoo!(\"bar\"); Also assume that we get the corresponding variable foo_span for the foo macro call, we could decide not to lint if in_external_macro results in true (note that cx can be EarlyContext or LateContext): if in_external_macro(cx.sess(), foo_span) { // We should ignore macro from a foreign crate. return;\n}","breadcrumbs":"Development » Macro Expansions » How to Work with Macros","id":"167","title":"How to Work with Macros"},"168":{"body":"You may need following tooltips to catch up with common operations. Common tools for writing lints Retrieving the type of expression Checking if an expr is calling a specific method Checking for a specific type Checking if a type implements a specific trait Checking if a type defines a specific method Dealing with macros Useful Rustc dev guide links: Stages of compilation Diagnostic items Type checking Ty module","breadcrumbs":"Development » Common Tools » Common tools for writing lints","id":"168","title":"Common tools for writing lints"},"169":{"body":"Sometimes you may want to retrieve the type Ty of an expression Expr, for example to answer following questions: which type does this expression correspond to (using its TyKind )? is it a sized type? is it a primitive type? does it implement a trait? This operation is performed using the expr_ty() method from the TypeckResults struct, that gives you access to the underlying structure Ty . Example of use: impl LateLintPass<'_> for MyStructLint { fn check_expr(&mut self, cx: &LateContext<'_>, expr: &Expr<'_>) { // Get type of `expr` let ty = cx.typeck_results().expr_ty(expr); // Match its kind to enter its type match ty.kind { ty::Adt(adt_def, _) if adt_def.is_struct() => println!(\"Our `expr` is a struct!\"), _ => () } }\n} Similarly, in TypeckResults methods, you have the pat_ty() method to retrieve a type from a pattern. Two noticeable items here: cx is the lint context LateContext . The two most useful data structures in this context are tcx and the TypeckResults returned by LateContext::typeck_results, allowing us to jump to type definitions and other compilation stages such as HIR. typeck_results's return value is TypeckResults and is created by type checking step, it includes useful information such as types of expressions, ways to resolve methods and so on.","breadcrumbs":"Development » Common Tools » Retrieving the type of expression","id":"169","title":"Retrieving the type of expression"},"17":{"body":"Whether to allow r#\"\"# when r\"\" can be used Default Value: false Affected lints: unnecessary_raw_string_hashes","breadcrumbs":"Configuration » Lint Configuration » allow-one-hash-in-raw-strings","id":"17","title":"allow-one-hash-in-raw-strings"},"170":{"body":"Starting with an expr, you can check whether it is calling a specific method some_method: impl<'tcx> LateLintPass<'tcx> for MyStructLint { fn check_expr(&mut self, cx: &LateContext<'tcx>, expr: &'tcx hir::Expr<'_>) { // Check our expr is calling a method if let hir::ExprKind::MethodCall(path, _, _self_arg, ..) = &expr.kind // Check the name of this method is `some_method` && path.ident.name == sym!(some_method) // Optionally, check the type of the self argument. // - See \"Checking for a specific type\" { // ... } }\n}","breadcrumbs":"Development » Common Tools » Checking if an expr is calling a specific method","id":"170","title":"Checking if an expr is calling a specific method"},"171":{"body":"There are three ways to check if an expression type is a specific type we want to check for. All of these methods only check for the base type, generic arguments have to be checked separately. use clippy_utils::ty::{is_type_diagnostic_item, is_type_lang_item};\nuse clippy_utils::{paths, match_def_path};\nuse rustc_span::symbol::sym;\nuse rustc_hir::LangItem; impl LateLintPass<'_> for MyStructLint { fn check_expr(&mut self, cx: &LateContext<'_>, expr: &Expr<'_>) { // Getting the expression type let ty = cx.typeck_results().expr_ty(expr); // 1. Using diagnostic items // The last argument is the diagnostic item to check for if is_type_diagnostic_item(cx, ty, sym::Option) { // The type is an `Option` } // 2. Using lang items if is_type_lang_item(cx, ty, LangItem::RangeFull) { // The type is a full range like `.drain(..)` } // 3. Using the type path // This method should be avoided if possible if match_def_path(cx, def_id, &paths::RESULT) { // The type is a `core::result::Result` } }\n} Prefer using diagnostic items and lang items where possible.","breadcrumbs":"Development » Common Tools » Checking for a specific type","id":"171","title":"Checking for a specific type"},"172":{"body":"There are three ways to do this, depending on if the target trait has a diagnostic item, lang item or neither. use clippy_utils::ty::implements_trait;\nuse clippy_utils::is_trait_method;\nuse rustc_span::symbol::sym; impl LateLintPass<'_> for MyStructLint { fn check_expr(&mut self, cx: &LateContext<'_>, expr: &Expr<'_>) { // 1. Using diagnostic items with the expression // we use `is_trait_method` function from Clippy's utils if is_trait_method(cx, expr, sym::Iterator) { // method call in `expr` belongs to `Iterator` trait } // 2. Using lang items with the expression type let ty = cx.typeck_results().expr_ty(expr); if cx.tcx.lang_items() // we are looking for the `DefId` of `Drop` trait in lang items .drop_trait() // then we use it with our type `ty` by calling `implements_trait` from Clippy's utils .map_or(false, |id| implements_trait(cx, ty, id, &[])) { // `expr` implements `Drop` trait } }\n} Prefer using diagnostic and lang items, if the target trait has one. We access lang items through the type context tcx. tcx is of type TyCtxt and is defined in the rustc_middle crate. A list of defined paths for Clippy can be found in paths.rs","breadcrumbs":"Development » Common Tools » Checking if a type implements a specific trait","id":"172","title":"Checking if a type implements a specific trait"},"173":{"body":"To check if our type defines a method called some_method: use clippy_utils::ty::is_type_diagnostic_item;\nuse clippy_utils::return_ty; impl<'tcx> LateLintPass<'tcx> for MyTypeImpl { fn check_impl_item(&mut self, cx: &LateContext<'tcx>, impl_item: &'tcx ImplItem<'_>) { // Check if item is a method/function if let ImplItemKind::Fn(ref signature, _) = impl_item.kind // Check the method is named `some_method` && impl_item.ident.name == sym!(some_method) // We can also check it has a parameter `self` && signature.decl.implicit_self.has_implicit_self() // We can go further and even check if its return type is `String` && is_type_diagnostic_item(cx, return_ty(cx, impl_item.hir_id), sym!(string_type)) { // ... } }\n}","breadcrumbs":"Development » Common Tools » Checking if a type defines a specific method","id":"173","title":"Checking if a type defines a specific method"},"174":{"body":"Keep in mind that macros are already expanded and desugaring is already applied to the code representation that you are working with in Clippy. This unfortunately causes a lot of false positives because macro expansions are \"invisible\" unless you actively check for them. Generally speaking, code with macro expansions should just be ignored by Clippy because that code can be dynamic in ways that are difficult or impossible to see. Use the following functions to deal with macros: span.from_expansion(): detects if a span is from macro expansion or desugaring. Checking this is a common first step in a lint. if expr.span.from_expansion() { // just forget it return;\n} span.ctxt(): the span's context represents whether it is from expansion, and if so, which macro call expanded it. It is sometimes useful to check if the context of two spans are equal. // expands to `1 + 0`, but don't lint\n1 + mac!() if left.span.ctxt() != right.span.ctxt() { // the coder most likely cannot modify this expression return;\n} Note: Code that is not from expansion is in the \"root\" context. So any spans where from_expansion returns true can be assumed to have the same context. And so just using span.from_expansion() is often good enough. in_external_macro(span): detect if the given span is from a macro defined in a foreign crate. If you want the lint to work with macro-generated code, this is the next line of defense to avoid macros not defined in the current crate. It doesn't make sense to lint code that the coder can't change. You may want to use it for example to not start linting in macros from other crates use rustc_middle::lint::in_external_macro; use a_crate_with_macros::foo; // `foo` is defined in `a_crate_with_macros`\nfoo!(\"bar\"); // if we lint the `match` of `foo` call and test its span\nassert_eq!(in_external_macro(cx.sess(), match_span), true); span.ctxt(): the span's context represents whether it is from expansion, and if so, what expanded it One thing SpanContext is useful for is to check if two spans are in the same context. For example, in a == b, a and b have the same context. In a macro_rules! with a == $b, $b is expanded to some expression with a different context from a. macro_rules! m { ($a:expr, $b:expr) => { if $a.is_some() { $b; } }\n} let x: Option<u32> = Some(42);\nm!(x, x.unwrap()); // These spans are not from the same context\n// x.is_some() is from inside the macro\n// x.unwrap() is from outside the macro\nassert_eq!(x_is_some_span.ctxt(), x_unwrap_span.ctxt());","breadcrumbs":"Development » Common Tools » Dealing with macros and expansions","id":"174","title":"Dealing with macros and expansions"},"175":{"body":"In order to deploy Clippy over rustup, some infrastructure is necessary. This chapter describes the different parts of the Clippy infrastructure that need to be maintained to make this possible. The most important part is the sync between the rust-lang/rust repository and the Clippy repository that takes place every two weeks. This process is described in the Syncing changes between Clippy and rust-lang/rust section. A new Clippy release is done together with every Rust release, so every six weeks. The release process is described in the Release a new Clippy Version section. During a release cycle a changelog entry for the next release has to be written. The format of that and how to do that is documented in the Changelog Update section. Note: The Clippy CI should also be described in this chapter, but for now is left as a TODO.","breadcrumbs":"Development » Infrastructure » Infrastructure","id":"175","title":"Infrastructure"},"176":{"body":"Clippy currently gets built with a pinned nightly version. In the rust-lang/rust repository, where rustc resides, there's a copy of Clippy that compiler hackers modify from time to time to adapt to changes in the unstable API of the compiler. We need to sync these changes back to this repository periodically, and the changes made to this repository in the meantime also need to be synced to the rust-lang/rust repository. To avoid flooding the rust-lang/rust PR queue, this two-way sync process is done in a bi-weekly basis if there's no urgent changes. This is done starting on the day of the Rust stable release and then every other week. That way we guarantee that we keep this repo up to date with the latest compiler API, and every feature in Clippy is available for 2 weeks in nightly, before it can get to beta. For reference, the first sync following this cadence was performed the 2020-08-27. This process is described in detail in the following sections. For general information about subtrees in the Rust repository see the rustc-dev-guide .","breadcrumbs":"Development » Infrastructure » Syncing changes between Clippy and rust-lang/rust » Syncing changes between Clippy and rust-lang/rust","id":"176","title":"Syncing changes between Clippy and rust-lang/rust"},"177":{"body":"Currently, there's a bug in git-subtree that prevents it from working properly with the rust-lang/rust repo. There's an open PR to fix that, but it's stale. Before continuing with the following steps, we need to manually apply that fix to our local copy of git-subtree. You can get the patched version of git-subtree from here . Put this file under /usr/lib/git-core (making a backup of the previous file) and make sure it has the proper permissions: sudo cp --backup /path/to/patched/git-subtree.sh /usr/lib/git-core/git-subtree\nsudo chmod --reference=/usr/lib/git-core/git-subtree~ /usr/lib/git-core/git-subtree\nsudo chown --reference=/usr/lib/git-core/git-subtree~ /usr/lib/git-core/git-subtree Note: The first time running git subtree push a cache has to be built. This involves going through the complete Clippy history once. For this you have to increase the stack limit though, which you can do with ulimit -s 60000. Make sure to run the ulimit command from the same session you call git subtree. Note: If you are a Debian user, dash is the shell used by default for scripts instead of sh. This shell has a hardcoded recursion limit set to 1,000. In order to make this process work, you need to force the script to run bash instead. You can do this by editing the first line of the git-subtree script and changing sh to bash.","breadcrumbs":"Development » Infrastructure » Syncing changes between Clippy and rust-lang/rust » Patching git-subtree to work with big repos","id":"177","title":"Patching git-subtree to work with big repos"},"178":{"body":"You may want to define remotes, so you don't have to type out the remote addresses on every sync. You can do this with the following commands (these commands still have to be run inside the rust directory): # Set clippy-upstream remote for pulls\n$ git remote add clippy-upstream https://github.com/rust-lang/rust-clippy\n# Make sure to not push to the upstream repo\n$ git remote set-url --push clippy-upstream DISABLED\n# Set a local remote\n$ git remote add clippy-local /path/to/rust-clippy Note: The following sections assume that you have set those remotes with the above remote names.","breadcrumbs":"Development » Infrastructure » Syncing changes between Clippy and rust-lang/rust » Defining remotes","id":"178","title":"Defining remotes"},"179":{"body":"Here is a TL;DR version of the sync process (all the following commands have to be run inside the rust directory): Clone the rust-lang/rust repository or make sure it is up-to-date. Checkout the commit from the latest available nightly. You can get it using rustup check. Sync the changes to the rust-copy of Clippy to your Clippy fork: # Be sure to either use a net-new branch, e.g. `sync-from-rust`, or delete the branch beforehand\n# because changes cannot be fast forwarded and you have to run this command again.\ngit subtree push -P src/tools/clippy clippy-local sync-from-rust Note: Most of the time you have to create a merge commit in the rust-clippy repo (this has to be done in the Clippy repo, not in the rust-copy of Clippy): git fetch upstream # assuming upstream is the rust-lang/rust remote\ngit checkout sync-from-rust\ngit merge upstream/master --no-ff Note: This is one of the few instances where a merge commit is allowed in a PR. Bump the nightly version in the Clippy repository by changing the date in the rust-toolchain file to the current date and committing it with the message: git commit -m \"Bump nightly version -> YYYY-MM-DD\" Open a PR to rust-lang/rust-clippy and wait for it to get merged (to accelerate the process ping the @rust-lang/clippy team in your PR and/or ask them in the Zulip stream.)","breadcrumbs":"Development » Infrastructure » Syncing changes between Clippy and rust-lang/rust » Performing the sync from rust-lang/rust to Clippy","id":"179","title":"Performing the sync from rust-lang/rust to Clippy"},"18":{"body":"Whether panic should be allowed in test functions or #[cfg(test)] Default Value: false Affected lints: panic","breadcrumbs":"Configuration » Lint Configuration » allow-panic-in-tests","id":"18","title":"allow-panic-in-tests"},"180":{"body":"All the following commands have to be run inside the rust directory. Make sure you have checked out the latest master of rust-lang/rust. Sync the rust-lang/rust-clippy master to the rust-copy of Clippy: git checkout -b sync-from-clippy\ngit subtree pull -P src/tools/clippy clippy-upstream master Open a PR to rust-lang/rust","breadcrumbs":"Development » Infrastructure » Syncing changes between Clippy and rust-lang/rust » Performing the sync from Clippy to rust-lang/rust","id":"180","title":"Performing the sync from Clippy to rust-lang/rust"},"181":{"body":"Sometimes it is necessary to backport changes to the beta release of Clippy. Backports in Clippy are rare and should be approved by the Clippy team. For example, a backport is done, if a crucial ICE was fixed or a lint is broken to a point, that it has to be disabled, before landing on stable. Backports are done to the beta branch of Clippy. Backports to stable Clippy releases basically don't exist, since this would require a Rust point release, which is almost never justifiable for a Clippy fix.","breadcrumbs":"Development » Infrastructure » Backporting Changes » Backport Changes","id":"181","title":"Backport Changes"},"182":{"body":"Backports are done on the beta branch of the Clippy repository. # Assuming the current directory corresponds to the Clippy repository\n$ git checkout beta\n$ git checkout -b backport\n$ git cherry-pick <SHA> # `<SHA>` is the commit hash of the commit(s), that should be backported\n$ git push origin backport Now you should test that the backport passes all the tests in the Rust repository. You can do this with: # Assuming the current directory corresponds to the Rust repository\n$ git checkout beta\n# Make sure to change `your-github-name` to your github name in the following command\n$ git subtree pull -p src/tools/clippy https://github.com/<your-github-name>/rust-clippy backport\n$ ./x.py test src/tools/clippy Should the test fail, you can fix Clippy directly in the Rust repository. This has to be first applied to the Clippy beta branch and then again synced to the Rust repository, though. The easiest way to do this is: # In the Rust repository\n$ git diff --patch --relative=src/tools/clippy > clippy.patch\n# In the Clippy repository\n$ git apply /path/to/clippy.patch\n$ git add -u\n$ git commit -m \"Fix rustup fallout\"\n$ git push origin backport After this, you can open a PR to the beta branch of the Clippy repository.","breadcrumbs":"Development » Infrastructure » Backporting Changes » Backport the changes","id":"182","title":"Backport the changes"},"183":{"body":"This step must be done, after the PR of the previous step was merged. After the backport landed in the Clippy repository, the branch has to be synced back to the beta branch of the Rust repository. # Assuming the current directory corresponds to the Rust repository\n$ git checkout beta\n$ git checkout -b clippy_backport\n$ git subtree pull -p src/tools/clippy https://github.com/rust-lang/rust-clippy beta\n$ git push origin clippy_backport Make sure to test the backport in the Rust repository before opening a PR. This is done with ./x.py test src/tools/clippy. If that passes all tests, open a PR to the beta branch of the Rust repository. In this PR you should tag the Clippy team member, that agreed to the backport or the @rust-lang/clippy team. Make sure to add [beta] to the title of the PR.","breadcrumbs":"Development » Infrastructure » Backporting Changes » Update Clippy in the Rust Repository","id":"183","title":"Update Clippy in the Rust Repository"},"184":{"body":"If you want to help with updating the changelog , you're in the right place.","breadcrumbs":"Development » Infrastructure » Updating the Changelog » Changelog Update","id":"184","title":"Changelog Update"},"185":{"body":"Typos and other small fixes/additions are always welcome. Special care needs to be taken when it comes to updating the changelog for a new Rust release. For that purpose, the changelog is ideally updated during the week before an upcoming stable release. You can find the release dates on the Rust Forge . Most of the time we only need to update the changelog for minor Rust releases. It's been very rare that Clippy changes were included in a patch release.","breadcrumbs":"Development » Infrastructure » Updating the Changelog » When to update","id":"185","title":"When to update"},"186":{"body":"1. Finding the relevant Clippy commits Each Rust release ships with its own version of Clippy. The Clippy subtree can be found in the tools directory of the Rust repository. Depending on the current time and what exactly you want to update, the following bullet points might be helpful: When writing the release notes for the upcoming stable release you need to check out the Clippy commit of the current Rust beta branch. Link When writing the release notes for the upcoming beta release , you need to check out the Clippy commit of the current Rust master. Link When writing the (forgotten) release notes for a past stable release , you need to check out the Rust release tag of the stable release. Link Usually you want to write the changelog of the upcoming stable release . Make sure though, that beta was already branched in the Rust repository. To find the commit hash, issue the following command when in a rust-lang/rust checkout: git log --oneline -- src/tools/clippy/ | grep -o \"Merge commit '[a-f0-9]*' into .*\" | head -1 | sed -e \"s/Merge commit '\\([a-f0-9]*\\)' into .*/\\1/g\" 2. Fetching the PRs between those commits Once you've got the correct commit range, run util/fetch_prs_between.sh commit1 commit2 > changes.txt and open that file in your editor of choice. When updating the changelog it's also a good idea to make sure that commit1 is already correct in the current changelog. 3. Authoring the final changelog The above script should have dumped all the relevant PRs to the file you specified. It should have filtered out most of the irrelevant PRs already, but it's a good idea to do a manual cleanup pass where you look for more irrelevant PRs. If you're not sure about some PRs, just leave them in for the review and ask for feedback. With the PRs filtered, you can start to take each PR and move the changelog: content to CHANGELOG.md. Adapt the wording as you see fit but try to keep it somewhat coherent. The order should roughly be: New lints Moves or deprecations of lints Changes that expand what code existing lints cover False positive fixes Suggestion fixes/improvements ICE fixes Documentation improvements Others As section headers, we use: ### New Lints\n### Moves and Deprecations\n### Enhancements\n### False Positive Fixes\n### Suggestion Fixes/Improvements\n### ICE Fixes\n### Documentation Improvements\n### Others Please also be sure to update the Beta/Unreleased sections at the top with the relevant commit ranges. 3.1 Include beta-accepted PRs Look for the beta-accepted label and make sure to also include the PRs with that label in the changelog. If you can, remove the beta-accepted labels after the changelog PR was merged. Note: Some of those PRs might even get backported to the previous beta. Those have to be included in the changelog of the previous release. 4. Update clippy::version attributes Next, make sure to check that the #[clippy::version] attributes for the added lints contain the correct version.","breadcrumbs":"Development » Infrastructure » Updating the Changelog » Changelog update walkthrough","id":"186","title":"Changelog update walkthrough"},"187":{"body":"NOTE: This document is probably only relevant to you, if you're a member of the Clippy team. Clippy is released together with stable Rust releases. The dates for these releases can be found at the Rust Forge . This document explains the necessary steps to create a Clippy release. Remerge the beta branch Update the beta branch Find the Clippy commit Tag the stable commit Update CHANGELOG.md NOTE: This document is for stable Rust releases, not for point releases. For point releases, step 1. and 2. should be enough.","breadcrumbs":"Development » Infrastructure » Release a New Version » Release a new Clippy Version","id":"187","title":"Release a new Clippy Version"},"188":{"body":"This step is only necessary, if since the last release something was backported to the beta Rust release. The remerge is then necessary, to make sure that the Clippy commit, that was used by the now stable Rust release, persists in the tree of the Clippy repository. To find out if this step is necessary run # Assumes that the local master branch of rust-lang/rust-clippy is up-to-date\n$ git fetch upstream\n$ git branch master --contains upstream/beta If this command outputs master, this step is not necessary. # Assuming `HEAD` is the current `master` branch of rust-lang/rust-clippy\n$ git checkout -b backport_remerge\n$ git merge upstream/beta\n$ git diff # This diff has to be empty, otherwise something with the remerge failed\n$ git push origin backport_remerge # This can be pushed to your fork After this, open a PR to the master branch. In this PR, the commit hash of the HEAD of the beta branch must exist. In addition to that, no files should be changed by this PR.","breadcrumbs":"Development » Infrastructure » Release a New Version » Remerge the beta branch","id":"188","title":"Remerge the beta branch"},"189":{"body":"This step must be done after the PR of the previous step was merged. First, the Clippy commit of the beta branch of the Rust repository has to be determined. # Assuming the current directory corresponds to the Rust repository\n$ git fetch upstream\n$ git checkout upstream/beta\n$ BETA_SHA=$(git log --oneline -- src/tools/clippy/ | grep -o \"Merge commit '[a-f0-9]*' into .*\" | head -1 | sed -e \"s/Merge commit '\\([a-f0-9]*\\)' into .*/\\1/g\") After finding the Clippy commit, the beta branch in the Clippy repository can be updated. # Assuming the current directory corresponds to the Clippy repository\n$ git checkout beta\n$ git reset --hard $BETA_SHA\n$ git push upstream beta","breadcrumbs":"Development » Infrastructure » Release a New Version » Update the beta branch","id":"189","title":"Update the beta branch"},"19":{"body":"Whether print macros (ex. println!) should be allowed in test functions or #[cfg(test)] Default Value: false Affected lints: print_stderr print_stdout","breadcrumbs":"Configuration » Lint Configuration » allow-print-in-tests","id":"19","title":"allow-print-in-tests"},"190":{"body":"The first step is to tag the Clippy commit, that is included in the stable Rust release. This commit can be found in the Rust repository. # Assuming the current directory corresponds to the Rust repository\n$ git fetch upstream # `upstream` is the `rust-lang/rust` remote\n$ git checkout 1.XX.0 # XX should be exchanged with the corresponding version\n$ SHA=$(git log --oneline -- src/tools/clippy/ | grep -o \"Merge commit '[a-f0-9]*' into .*\" | head -1 | sed -e \"s/Merge commit '\\([a-f0-9]*\\)' into .*/\\1/g\")","breadcrumbs":"Development » Infrastructure » Release a New Version » Find the Clippy commit","id":"190","title":"Find the Clippy commit"},"191":{"body":"After finding the Clippy commit, it can be tagged with the release number. # Assuming the current directory corresponds to the Clippy repository\n$ git checkout $SHA\n$ git tag rust-1.XX.0 # XX should be exchanged with the corresponding version\n$ git push upstream rust-1.XX.0 # `upstream` is the `rust-lang/rust-clippy` remote After this, the release should be available on the Clippy release page .","breadcrumbs":"Development » Infrastructure » Release a New Version » Tag the stable commit","id":"191","title":"Tag the stable commit"},"192":{"body":"At this step you should have already checked out the commit of the rust-1.XX.0 tag. Updating the stable branch from here is as easy as: # Assuming the current directory corresponds to the Clippy repository and the\n# commit of the just created rust-1.XX.0 tag is checked out.\n$ git push upstream rust-1.XX.0:stable # `upstream` is the `rust-lang/rust-clippy` remote NOTE: Usually there are no stable backports for Clippy, so this update should be possible without force pushing or anything like this. If there should have happened a stable backport, make sure to re-merge those changes just as with the beta branch.","breadcrumbs":"Development » Infrastructure » Release a New Version » Update the stable branch","id":"192","title":"Update the stable branch"},"193":{"body":"For this see the document on how to update the changelog . If you don't have time to do a complete changelog update right away, just update the following parts: Remove the (beta) from the new stable version: ## Rust 1.XX (beta) -> ## Rust 1.XX Update the release date line of the new stable version: Current beta, release 20YY-MM-DD -> Current stable, released 20YY-MM-DD Update the release date line of the previous stable version: Current stable, released 20YY-MM-DD -> Released 20YY-MM-DD","breadcrumbs":"Development » Infrastructure » Release a New Version » Update CHANGELOG.md","id":"193","title":"Update CHANGELOG.md"},"194":{"body":"This document explains how to make additions and changes to the Clippy book, the guide to Clippy that you're reading right now. The Clippy book is formatted with Markdown and generated by mdBook . Get mdBook Make changes","breadcrumbs":"Development » Infrastructure » The Clippy Book » The Clippy Book","id":"194","title":"The Clippy Book"},"195":{"body":"While not strictly necessary since the book source is simply Markdown text files, having mdBook locally will allow you to build, test and serve the book locally to view changes before you commit them to the repository. You likely already have cargo installed, so the easiest option is to: cargo install mdbook See the mdBook installation instructions for other options.","breadcrumbs":"Development » Infrastructure » The Clippy Book » Get mdBook","id":"195","title":"Get mdBook"},"196":{"body":"The book's src directory contains all the markdown files used to generate the book. If you want to see your changes in real time, you can use the mdBook serve command to run a web server locally that will automatically update changes as they are made. From the top level of your rust-clippy directory: mdbook serve book --open Then navigate to http://localhost:3000 to see the generated book. While the server is running, changes you make will automatically be updated. For more information, see the mdBook guide .","breadcrumbs":"Development » Infrastructure » The Clippy Book » Make changes","id":"196","title":"Make changes"},"197":{"body":"This chapter is about accepted proposals for changes that should be worked on in or around Clippy in the long run. Besides adding more and more lints and improve the lints that Clippy already has, Clippy is also interested in making the experience of its users, developers and maintainers better over time. Projects that address bigger picture things like this usually take more time, and it is useful to have a proposal for those first. This is the place where such proposals are collected, so that we can refer to them when working on them.","breadcrumbs":"Development » Proposals » Proposals","id":"197","title":"Proposals"},"198":{"body":"","breadcrumbs":"Development » Proposals » Roadmap 2021 » Roadmap 2021","id":"198","title":"Roadmap 2021"},"199":{"body":"This Roadmap lays out the plans for Clippy in 2021: Improving usability and reliability Improving experience of contributors and maintainers Develop and specify processes Members of the Clippy team will be assigned tasks from one or more of these topics. The team member is then responsible to complete the assigned tasks. This can either be done by implementing them or by providing mentorship to interested contributors.","breadcrumbs":"Development » Proposals » Roadmap 2021 » Summary","id":"199","title":"Summary"},"2":{"body":"If Clippy was not installed for a toolchain, it can be installed with $ rustup component add clippy [--toolchain=<name>]","breadcrumbs":"Installation » Using Rustup","id":"2","title":"Using Rustup"},"20":{"body":"Whether to allow module inception if it's not public. Default Value: false Affected lints: module_inception","breadcrumbs":"Configuration » Lint Configuration » allow-private-module-inception","id":"20","title":"allow-private-module-inception"},"200":{"body":"With the ongoing growth of the Rust language and with that of the whole ecosystem, also Clippy gets more and more users and contributors. This is good for the project, but also brings challenges along. Some of these challenges are: More issues about reliability or usability are popping up Traffic is hard to handle for a small team Bigger projects don't get completed due to the lack of processes and/or time of the team members Additionally, according to the Rust Roadmap 2021 , clear processes should be defined by every team and unified across teams. This Roadmap is the first step towards this.","breadcrumbs":"Development » Proposals » Roadmap 2021 » Motivation","id":"200","title":"Motivation"},"201":{"body":"This section will explain the things that should be done in 2021. It is important to note, that this document focuses on the \"What?\", not the \"How?\". The later will be addressed in follow-up tracking issue, with an assigned team member. The following is split up in two major sections. The first section covers the user facing plans, the second section the internal plans.","breadcrumbs":"Development » Proposals » Roadmap 2021 » Explanation","id":"201","title":"Explanation"},"202":{"body":"Clippy should be as pleasant to use and configure as possible. This section covers plans that should be implemented to improve the situation of Clippy in this regard. Usability In the following, plans to improve the usability are covered. No Output After cargo check Currently, when cargo clippy is run after cargo check, it does not produce any output. This is especially problematic since rust-analyzer is on the rise, and it uses cargo check for checking code. A fix is already implemented, but it still has to be pushed over the finish line. This also includes the stabilization of the cargo clippy --fix command or the support of multi-span suggestions in rustfix. #4612 lints.toml Configuration This is something that comes up every now and then: a reusable configuration file, where lint levels can be defined. Discussions about this often lead to nothing specific or to \"we need an RFC for this\". And this is exactly what needs to be done. Get together with the cargo team and write an RFC and implement such a configuration file somehow and somewhere. #3164 cargo#5034 IRLO Lint Groups There are more and more issues about managing lints in Clippy popping up. Lints are hard to implement with a guarantee of no/few false positives (FPs). One way to address this might be to introduce more lint groups to give users the ability to better manage lints, or improve the process of classifying lints, so that disabling lints due to FPs becomes rare. It is important to note, that Clippy lints are less conservative than rustc lints, which won't change in the future. #5537 #6366 Reliability In the following, plans to improve the reliability are covered. False Positive Rate In the worst case, new lints are only available in nightly for 2 weeks, before hitting beta and ultimately stable. This and the fact that fewer people use nightly Rust nowadays makes it more probable that a lint with many FPs hits stable. This leads to annoyed users, that will disable these new lints in the best case and to more annoyed users, that will stop using Clippy in the worst. A process should be developed and implemented to prevent this from happening. #6429","breadcrumbs":"Development » Proposals » Roadmap 2021 » User Facing","id":"202","title":"User Facing"},"203":{"body":"(The end of) 2020 has shown, that Clippy has to think about the available resources, especially regarding management and maintenance of the project. This section address issues affecting team members and contributors. Management In 2020 Clippy achieved over 1000 open issues with regularly between 25-35 open PRs. This is simultaneously a win and a loss. More issues and PRs means more people are interested in Clippy and in contributing to it. On the other hand, it means for team members more work and for contributors longer wait times for reviews. The following will describe plans how to improve the situation for both team members and contributors. Clear Expectations for Team Members According to the Rust Roadmap 2021 , a document specifying what it means to be a member of the team should be produced. This should not put more pressure on the team members, but rather help them and interested folks to know what the expectations are. With this it should also be easier to recruit new team members and may encourage people to get in touch, if they're interested to join. Scaling up the Team More people means less work for each individual. Together with the document about expectations for team members, a document defining the process of how to join the team should be produced. This can also increase the stability of the team, in case of current members dropping out (temporarily). There can also be different roles in the team, like people triaging vs. people reviewing. Regular Meetings Other teams have regular meetings. Clippy is big enough that it might be worth to also do them. Especially if more people join the team, this can be important for sync-ups. Besides the asynchronous communication, that works well for working on separate lints, a meeting adds a synchronous alternative at a known time. This is especially helpful if there are bigger things that need to be discussed (like the projects in this roadmap). For starters bi-weekly meetings before Rust syncs might make sense. Triaging To get a handle on the influx of open issues, a process for triaging issues and PRs should be developed. Officially, Clippy follows the Rust triage process, but currently no one enforces it. This can be improved by sharing triage teams across projects or by implementing dashboards / tools which simplify triaging. Development Improving the developer and contributor experience is something the Clippy team works on regularly. Though, some things might need special attention and planing. These topics are listed in the following. Process for New and Existing Lints As already mentioned above, classifying new lints gets quite hard, because the probability of a buggy lint getting into stable is quite high. A process should be implemented on how to classify lints. In addition, a test system should be developed to find out which lints are currently problematic in real world code to fix or disable them. #6429 (comment) #6429 (comment) Processes Related to the point before, a process for suggesting and discussing major changes should be implemented. It's also not clearly defined when a lint should be enabled or disabled by default. This can also be improved by the test system mentioned above. Dev-Tools There's already cargo dev which makes Clippy development easier and more pleasant. This can still be expanded, so that it covers more areas of the development process. #5394 Contributor Guide Similar to a Clippy Book, which describes how to use Clippy, a book about how to contribute to Clippy might be helpful for new and existing contributors. There's already the doc directory in the Clippy repo, this can be turned into a mdbook. rustc integration Recently Clippy was integrated with git subtree into the rust-lang/rust repository. This made syncing between the two repositories easier. A #[non_exhaustive] list of things that still can be improved is: Use the same rustfmt version and configuration as rustc. Make cargo dev work in the Rust repo, just as it works in the Clippy repo. E.g. cargo dev bless or cargo dev update_lints. And even add more things to it that might be useful for the Rust repo, e.g. cargo dev deprecate. Easier sync process. The subtree situation is not ideal.","breadcrumbs":"Development » Proposals » Roadmap 2021 » Internal","id":"203","title":"Internal"},"204":{"body":"The most pressing issues for users of Clippy are of course the user facing issues. So there should be a priority on those issues, but without losing track of the internal issues listed in this document. Getting the FP rate of warn/deny-by-default lints under control should have the highest priority. Other user facing issues should also get a high priority, but shouldn't be in the way of addressing internal issues. To better manage the upcoming projects, the basic internal processes, like meetings, tracking issues and documentation, should be established as soon as possible. They might even be necessary to properly manage the projects, regarding the user facing issues.","breadcrumbs":"Development » Proposals » Roadmap 2021 » Prioritization","id":"204","title":"Prioritization"},"205":{"body":"","breadcrumbs":"Development » Proposals » Roadmap 2021 » Prior Art","id":"205","title":"Prior Art"},"206":{"body":"Rust's roadmap process was established by RFC 1728 in 2016. Since then every year a roadmap was published, that defined the bigger plans for the coming years. This year roadmap can be found here .","breadcrumbs":"Development » Proposals » Roadmap 2021 » Rust Roadmap","id":"206","title":"Rust Roadmap"},"207":{"body":"","breadcrumbs":"Development » Proposals » Roadmap 2021 » Drawbacks","id":"207","title":"Drawbacks"},"208":{"body":"This roadmap is pretty big and not all items listed in this document might be addressed during 2021. Because this is the first roadmap for Clippy, having open tasks at the end of 2021 is fine, but they should be revisited in the 2022 roadmap.","breadcrumbs":"Development » Proposals » Roadmap 2021 » Big Roadmap","id":"208","title":"Big Roadmap"},"209":{"body":"Feature Name: syntax-tree-patterns Start Date: 2019-03-12 RFC PR: #3875 Introduce a domain-specific language (similar to regular expressions) that allows to describe lints using syntax tree patterns .","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Summary","id":"209","title":"Summary"},"21":{"body":"List of trait paths to ignore when checking renamed function parameters. Example allow-renamed-params-for = [ \"std::convert::From\" ] Noteworthy By default, the following traits are ignored: From, TryFrom, FromStr \"..\" can be used as part of the list to indicate that the configured values should be appended to the default configuration of Clippy. By default, any configuration will replace the default value. Default Value: [\"core::convert::From\", \"core::convert::TryFrom\", \"core::str::FromStr\"] Affected lints: renamed_function_params","breadcrumbs":"Configuration » Lint Configuration » allow-renamed-params-for","id":"21","title":"allow-renamed-params-for"},"210":{"body":"Finding parts of a syntax tree (AST, HIR, ...) that have certain properties (e.g. \" an if that has a block as its condition \") is a major task when writing lints. For non-trivial lints, it often requires nested pattern matching of AST / HIR nodes. For example, testing that an expression is a boolean literal requires the following checks: if let ast::ExprKind::Lit(lit) = &expr.node { if let ast::LitKind::Bool(_) = &lit.node { ... }\n} Writing this kind of matching code quickly becomes a complex task and the resulting code is often hard to comprehend. The code below shows a simplified version of the pattern matching required by the collapsible_if lint: // simplified version of the collapsible_if lint\nif let ast::ExprKind::If(check, then, None) = &expr.node { if then.stmts.len() == 1 { if let ast::StmtKind::Expr(inner) | ast::StmtKind::Semi(inner) = &then.stmts[0].node { if let ast::ExprKind::If(check_inner, content, None) = &inner.node { ... } } }\n} The if_chain macro can improve readability by flattening the nested if statements, but the resulting code is still quite hard to read: // simplified version of the collapsible_if lint\nif_chain! { if let ast::ExprKind::If(check, then, None) = &expr.node; if then.stmts.len() == 1; if let ast::StmtKind::Expr(inner) | ast::StmtKind::Semi(inner) = &then.stmts[0].node; if let ast::ExprKind::If(check_inner, content, None) = &inner.node; then { ... }\n} The code above matches if expressions that contain only another if expression (where both ifs don't have an else branch). While it's easy to explain what the lint does, it's hard to see that from looking at the code samples above. Following the motivation above, the first goal this RFC is to simplify writing and reading lints . The second part of the motivation is clippy's dependence on unstable compiler-internal data structures. Clippy lints are currently written against the compiler's AST / HIR which means that even small changes in these data structures might break a lot of lints. The second goal of this RFC is to make lints independent of the compiler's AST / HIR data structures .","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Motivation","id":"210","title":"Motivation"},"211":{"body":"A lot of complexity in writing lints currently seems to come from having to manually implement the matching logic (see code samples above). It's an imperative style that describes how to match a syntax tree node instead of specifying what should be matched against declaratively. In other areas, it's common to use declarative patterns to describe desired information and let the implementation do the actual matching. A well-known example of this approach are regular expressions . Instead of writing code that detects certain character sequences, one can describe a search pattern using a domain-specific language and search for matches using that pattern. The advantage of using a declarative domain-specific language is that its limited domain (e.g. matching character sequences in the case of regular expressions) allows to express entities in that domain in a very natural and expressive way. While regular expressions are very useful when searching for patterns in flat character sequences, they cannot easily be applied to hierarchical data structures like syntax trees. This RFC therefore proposes a pattern matching system that is inspired by regular expressions and designed for hierarchical syntax trees.","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Approach","id":"211","title":"Approach"},"212":{"body":"This proposal adds a pattern! macro that can be used to specify a syntax tree pattern to search for. A simple pattern is shown below: pattern!{ my_pattern: Expr = Lit(Bool(false))\n} This macro call defines a pattern named my_pattern that can be matched against an Expr syntax tree node. The actual pattern (Lit(Bool(false)) in this case) defines which syntax trees should match the pattern. This pattern matches expressions that are boolean literals with value false. The pattern can then be used to implement lints in the following way: ... impl EarlyLintPass for MyAwesomeLint { fn check_expr(&mut self, cx: &EarlyContext, expr: &syntax::ast::Expr) { if my_pattern(expr).is_some() { cx.span_lint( MY_AWESOME_LINT, expr.span, \"This is a match for a simple pattern. Well done!\", ); } }\n} The pattern! macro call expands to a function my_pattern that expects a syntax tree expression as its argument and returns an Option that indicates whether the pattern matched. Note: The result type is explained in more detail in a later section . For now, it's enough to know that the result is Some if the pattern matched and None otherwise.","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Guide-level explanation","id":"212","title":"Guide-level explanation"},"213":{"body":"The following examples demonstrate the pattern syntax: Any (_) The simplest pattern is the any pattern. It matches anything and is therefore similar to regex's *. pattern!{ // matches any expression my_pattern: Expr = _\n} Node (<node-name>(<args>)) Nodes are used to match a specific variant of an AST node. A node has a name and a number of arguments that depends on the node type. For example, the Lit node has a single argument that describes the type of the literal. As another example, the If node has three arguments describing the if's condition, then block and else block. pattern!{ // matches any expression that is a literal my_pattern: Expr = Lit(_)\n} pattern!{ // matches any expression that is a boolean literal my_pattern: Expr = Lit(Bool(_))\n} pattern!{ // matches if expressions that have a boolean literal in their condition // Note: The `_?` syntax here means that the else branch is optional and can be anything. // This is discussed in more detail in the section `Repetition`. my_pattern: Expr = If( Lit(Bool(_)) , _, _?)\n} Literal (<lit>) A pattern can also contain Rust literals. These literals match themselves. pattern!{ // matches the boolean literal false my_pattern: Expr = Lit(Bool(false))\n} pattern!{ // matches the character literal 'x' my_pattern: Expr = Lit(Char('x'))\n} Alternations (a | b) pattern!{ // matches if the literal is a boolean or integer literal my_pattern: Lit = Bool(_) | Int(_)\n} pattern!{ // matches if the expression is a char literal with value 'x' or 'y' my_pattern: Expr = Lit( Char('x' | 'y') )\n} Empty (()) The empty pattern represents an empty sequence or the None variant of an optional. pattern!{ // matches if the expression is an empty array my_pattern: Expr = Array( () )\n} pattern!{ // matches if expressions that don't have an else clause my_pattern: Expr = If(_, _, ())\n} Sequence (<a> <b>) pattern!{ // matches the array [true, false] my_pattern: Expr = Array( Lit(Bool(true)) Lit(Bool(false)) )\n} Repetition (<a>*, <a>+, <a>?, <a>{n}, <a>{n,m}, <a>{n,}) Elements may be repeated. The syntax for specifying repetitions is identical to regex's syntax . pattern!{ // matches arrays that contain 2 'x's as their last or second-last elements // Examples: // ['x', 'x'] match // ['x', 'x', 'y'] match // ['a', 'b', 'c', 'x', 'x', 'y'] match // ['x', 'x', 'y', 'z'] no match my_pattern: Expr = Array( _* Lit(Char('x')){2} _? )\n} pattern!{ // matches if expressions that **may or may not** have an else block // Attn: `If(_, _, _)` matches only ifs that **have** an else block // // | if with else block | if without else block // If(_, _, _) | match | no match // If(_, _, _?) | match | match // If(_, _, ()) | no match | match my_pattern: Expr = If(_, _, _?)\n} Named submatch (<a>#<name>) pattern!{ // matches character literals and gives the literal the name foo my_pattern: Expr = Lit(Char(_)#foo)\n} pattern!{ // matches character literals and gives the char the name bar my_pattern: Expr = Lit(Char(_#bar))\n} pattern!{ // matches character literals and gives the expression the name baz my_pattern: Expr = Lit(Char(_))#baz\n} The reason for using named submatches is described in the section The result type . Summary The following table gives an summary of the pattern syntax: Syntax Concept Examples _ Any _ <node-name>(<args>) Node Lit(Bool(true)), If(_, _, _) <lit> Literal 'x', false, 101 <a> | <b> Alternation Char(_) | Bool(_) () Empty Array( () ) <a> <b> Sequence Tuple( Lit(Bool(_)) Lit(Int(_)) Lit(_) ) <a>* <a>+ <a>? <a>{n} <a>{n,m} <a>{n,} Repetition Array( _* ), Block( Semi(_)+ ), If(_, _, Block(_)?), Array( Lit(_){10} ), Lit(_){5,10}, Lit(Bool(_)){10,} <a>#<name> Named submatch Lit(Int(_))#foo Lit(Int(_#bar))","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Pattern syntax","id":"213","title":"Pattern syntax"},"214":{"body":"A lot of lints require checks that go beyond what the pattern syntax described above can express. For example, a lint might want to check whether a node was created as part of a macro expansion or whether there's no comment above a node. Another example would be a lint that wants to match two nodes that have the same value (as needed by lints like almost_swapped). Instead of allowing users to write these checks into the pattern directly (which might make patterns hard to read), the proposed solution allows users to assign names to parts of a pattern expression. When matching a pattern against a syntax tree node, the return value will contain references to all nodes that were matched by these named subpatterns. This is similar to capture groups in regular expressions. For example, given the following pattern pattern!{ // matches character literals my_pattern: Expr = Lit(Char(_#val_inner)#val)#val_outer\n} one could get references to the nodes that matched the subpatterns in the following way: ...\nfn check_expr(expr: &syntax::ast::Expr) { if let Some(result) = my_pattern(expr) { result.val_inner // type: &char result.val // type: &syntax::ast::Lit result.val_outer // type: &syntax::ast::Expr }\n} The types in the result struct depend on the pattern. For example, the following pattern pattern!{ // matches arrays of character literals my_pattern_seq: Expr = Array( Lit(_)*#foo )\n} matches arrays that consist of any number of literal expressions. Because those expressions are named foo, the result struct contains a foo attribute which is a vector of expressions: ...\nif let Some(result) = my_pattern_seq(expr) { result.foo // type: Vec<&syntax::ast::Expr>\n} Another result type occurs when a name is only defined in one branch of an alternation: pattern!{ // matches if expression is a boolean or integer literal my_pattern_alt: Expr = Lit( Bool(_#bar) | Int(_) )\n} In the pattern above, the bar name is only defined if the pattern matches a boolean literal. If it matches an integer literal, the name isn't set. To account for this, the result struct's bar attribute is an option type: ...\nif let Some(result) = my_pattern_alt(expr) { result.bar // type: Option<&bool>\n} It's also possible to use a name in multiple alternation branches if they have compatible types: pattern!{ // matches if expression is a boolean or integer literal my_pattern_mult: Expr = Lit(_#baz) | Array( Lit(_#baz) )\n}\n...\nif let Some(result) = my_pattern_mult(expr) { result.baz // type: &syntax::ast::Lit\n} Named submatches are a flat namespace and this is intended. In the example above, two different sub-structures are assigned to a flat name. I expect that for most lints, a flat namespace is sufficient and easier to work with than a hierarchical one. Two stages Using named subpatterns, users can write lints in two stages. First, a coarse selection of possible matches is produced by the pattern syntax. In the second stage, the named subpattern references can be used to do additional tests like asserting that a node hasn't been created as part of a macro expansion.","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » The result type","id":"214","title":"The result type"},"215":{"body":"As a \"real-world\" example, I re-implemented the collapsible_if lint using patterns. The code can be found here . The pattern-based version passes all test cases that were written for collapsible_if.","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Implementing Clippy lints using patterns","id":"215","title":"Implementing Clippy lints using patterns"},"216":{"body":"","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Reference-level explanation","id":"216","title":"Reference-level explanation"},"217":{"body":"The following diagram shows the dependencies between the main parts of the proposed solution: Pattern syntax | | parsing / lowering v PatternTree ^ | | IsMatch trait | | +---------------+-----------+---------+ | | | | v v v v syntax::ast rustc::hir syn ... The pattern syntax described in the previous section is parsed / lowered into the so-called PatternTree data structure that represents a valid syntax tree pattern. Matching a PatternTree against an actual syntax tree (e.g. rust ast / hir or the syn ast, ...) is done using the IsMatch trait. The PatternTree and the IsMatch trait are introduced in more detail in the following sections.","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Overview","id":"217","title":"Overview"},"218":{"body":"The core data structure of this RFC is the PatternTree . It's a data structure similar to rust's AST / HIR, but with the following differences: The PatternTree doesn't contain parsing information like Spans The PatternTree can represent alternatives, sequences and optionals The code below shows a simplified version of the current PatternTree: Note: The current implementation can be found here . pub enum Expr { Lit(Alt<Lit>), Array(Seq<Expr>), Block_(Alt<BlockType>), If(Alt<Expr>, Alt<BlockType>, Opt<Expr>), IfLet( Alt<BlockType>, Opt<Expr>, ),\n} pub enum Lit { Char(Alt<char>), Bool(Alt<bool>), Int(Alt<u128>),\n} pub enum Stmt { Expr(Alt<Expr>), Semi(Alt<Expr>),\n} pub enum BlockType { Block(Seq<Stmt>),\n} The Alt, Seq and Opt structs look like these: Note: The current implementation can be found here . pub enum Alt<T> { Any, Elmt(Box<T>), Alt(Box<Self>, Box<Self>), Named(Box<Self>, ...)\n} pub enum Opt<T> { Any, // anything, but not None Elmt(Box<T>), None, Alt(Box<Self>, Box<Self>), Named(Box<Self>, ...)\n} pub enum Seq<T> { Any, Empty, Elmt(Box<T>), Repeat(Box<Self>, RepeatRange), Seq(Box<Self>, Box<Self>), Alt(Box<Self>, Box<Self>), Named(Box<Self>, ...)\n} pub struct RepeatRange { pub start: usize, pub end: Option<usize> // exclusive\n}","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » PatternTree","id":"218","title":"PatternTree"},"219":{"body":"The input of a pattern! macro call is parsed into a ParseTree first and then lowered to a PatternTree. Valid patterns depend on the PatternTree definitions. For example, the pattern Lit(Bool(_)*) isn't valid because the parameter type of the Lit variant of the Expr enum is Any<Lit> and therefore doesn't support repetition (*). As another example, Array( Lit(_)* ) is a valid pattern because the parameter of Array is of type Seq<Expr> which allows sequences and repetitions. Note: names in the pattern syntax correspond to PatternTree enum variants . For example, the Lit in the pattern above refers to the Lit variant of the Expr enum (Expr::Lit), not the Lit enum.","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Parsing / Lowering","id":"219","title":"Parsing / Lowering"},"22":{"body":"Whether unwrap should be allowed in test functions or #[cfg(test)] Default Value: false Affected lints: unwrap_used","breadcrumbs":"Configuration » Lint Configuration » allow-unwrap-in-tests","id":"22","title":"allow-unwrap-in-tests"},"220":{"body":"The pattern syntax and the PatternTree are independent of specific syntax tree implementations (rust ast / hir, syn, ...). When looking at the different pattern examples in the previous sections, it can be seen that the patterns don't contain any information specific to a certain syntax tree implementation. In contrast, Clippy lints currently match against ast / hir syntax tree nodes and therefore directly depend on their implementation. The connection between the PatternTree and specific syntax tree implementations is the IsMatch trait. It defines how to match PatternTree nodes against specific syntax tree nodes. A simplified implementation of the IsMatch trait is shown below: pub trait IsMatch<O> { fn is_match(&self, other: &'o O) -> bool;\n} This trait needs to be implemented on each enum of the PatternTree (for the corresponding syntax tree types). For example, the IsMatch implementation for matching ast::LitKind against the PatternTree's Lit enum might look like this: impl IsMatch<ast::LitKind> for Lit { fn is_match(&self, other: &ast::LitKind) -> bool { match (self, other) { (Lit::Char(i), ast::LitKind::Char(j)) => i.is_match(j), (Lit::Bool(i), ast::LitKind::Bool(j)) => i.is_match(j), (Lit::Int(i), ast::LitKind::Int(j, _)) => i.is_match(j), _ => false, } }\n} All IsMatch implementations for matching the current PatternTree against syntax::ast can be found here .","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » The IsMatch Trait","id":"220","title":"The IsMatch Trait"},"221":{"body":"Performance The pattern matching code is currently not optimized for performance, so it might be slower than hand-written matching code. Additionally, the two-stage approach (matching against the coarse pattern first and checking for additional properties later) might be slower than the current practice of checking for structure and additional properties in one pass. For example, the following lint pattern!{ pat_if_without_else: Expr = If( _, Block( Expr( If(_, _, ())#inner ) | Semi( If(_, _, ())#inner ) )#then, () )\n}\n...\nfn check_expr(&mut self, cx: &EarlyContext<'_>, expr: &ast::Expr) { if let Some(result) = pat_if_without_else(expr) { if !block_starts_with_comment(cx, result.then) { ... }\n} first matches against the pattern and then checks that the then block doesn't start with a comment. Using clippy's current approach, it's possible to check for these conditions earlier: fn check_expr(&mut self, cx: &EarlyContext<'_>, expr: &ast::Expr) { if_chain! { if let ast::ExprKind::If(ref check, ref then, None) = expr.node; if !block_starts_with_comment(cx, then); if let Some(inner) = expr_block(then); if let ast::ExprKind::If(ref check_inner, ref content, None) = inner.node; then { ... } }\n} Whether or not this causes performance regressions depends on actual patterns. If it turns out to be a problem, the pattern matching algorithms could be extended to allow \"early filtering\" (see the Early Filtering section in Future Possibilities). That being said, I don't see any conceptual limitations regarding pattern matching performance. Applicability Even though I'd expect that a lot of lints can be written using the proposed pattern syntax, it's unlikely that all lints can be expressed using patterns. I suspect that there will still be lints that need to be implemented by writing custom pattern matching code. This would lead to mix within clippy's codebase where some lints are implemented using patterns and others aren't. This inconsistency might be considered a drawback.","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Drawbacks","id":"221","title":"Drawbacks"},"222":{"body":"Specifying lints using syntax tree patterns has a couple of advantages compared to the current approach of manually writing matching code. First, syntax tree patterns allow users to describe patterns in a simple and expressive way. This makes it easier to write new lints for both novices and experts and also makes reading / modifying existing lints simpler. Another advantage is that lints are independent of specific syntax tree implementations (e.g. AST / HIR, ...). When these syntax tree implementations change, only the IsMatch trait implementations need to be adapted and existing lints can remain unchanged. This also means that if the IsMatch trait implementations were integrated into the compiler, updating the IsMatch implementations would be required for the compiler to compile successfully. This could reduce the number of times Clippy breaks because of changes in the compiler. Another advantage of the pattern's independence is that converting an EarlyLintPass lint into a LatePassLint wouldn't require rewriting the whole pattern matching code. In fact, the pattern might work just fine without any adaptions.","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Rationale and alternatives","id":"222","title":"Rationale and alternatives"},"223":{"body":"Rust-like pattern syntax The proposed pattern syntax requires users to know the structure of the PatternTree (which is very similar to the AST's / HIR's structure) and also the pattern syntax. An alternative would be to introduce a pattern syntax that is similar to actual Rust syntax (probably like the quote! macro). For example, a pattern that matches if expressions that have false in their condition could look like this: if false { #[*]\n} Problems Extending Rust syntax (which is quite complex by itself) with additional syntax needed for specifying patterns (alternations, sequences, repetitions, named submatches, ...) might become difficult to read and really hard to parse properly. For example, a pattern that matches a binary operation that has 0 on both sides might look like this: 0 #[*:BinOpKind] 0 Now consider this slightly more complex example: 1 + 0 #[*:BinOpKind] 0 The parser would need to know the precedence of #[*:BinOpKind] because it affects the structure of the resulting AST. 1 + 0 + 0 is parsed as (1 + 0) + 0 while 1 + 0 * 0 is parsed as 1 + (0 * 0). Since the pattern could be any BinOpKind, the precedence cannot be known in advance. Another example of a problem would be named submatches. Take a look at this pattern: fn test() { 1 #foo\n} Which node is #foo referring to? int, ast::Lit, ast::Expr, ast::Stmt? Naming subpatterns in a rust-like syntax is difficult because a lot of AST nodes don't have a syntactic element that can be used to put the name tag on. In these situations, the only sensible option would be to assign the name tag to the outermost node (ast::Stmt in the example above), because the information of all child nodes can be retrieved through the outermost node. The problem with this then would be that accessing inner nodes (like ast::Lit) would again require manual pattern matching. In general, Rust syntax contains a lot of code structure implicitly. This structure is reconstructed during parsing (e.g. binary operations are reconstructed using operator precedence and left-to-right) and is one of the reasons why parsing is a complex task. The advantage of this approach is that writing code is simpler for users. When writing syntax tree patterns , each element of the hierarchy might have alternatives, repetitions, etc.. Respecting that while still allowing human-friendly syntax that contains structure implicitly seems to be really complex, if not impossible. Developing such a syntax would also require to maintain a custom parser that is at least as complex as the Rust parser itself. Additionally, future changes in the Rust syntax might be incompatible with such a syntax. In summary, I think that developing such a syntax would introduce a lot of complexity to solve a relatively minor problem. The issue of users not knowing about the PatternTree structure could be solved by a tool that, given a rust program, generates a pattern that matches only this program (similar to the Clippy author lint). For some simple cases (like the first example above), it might be possible to successfully mix Rust and pattern syntax. This space could be further explored in a future extension.","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Alternatives","id":"223","title":"Alternatives"},"224":{"body":"The pattern syntax is heavily inspired by regular expressions (repetitions, alternatives, sequences, ...). From what I've seen until now, other linters also implement lints that directly work on syntax tree data structures, just like Clippy does currently. I would therefore consider the pattern syntax to be new , but please correct me if I'm wrong.","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Prior art","id":"224","title":"Prior art"},"225":{"body":"How to handle multiple matches? When matching a syntax tree node against a pattern, there are possibly multiple ways in which the pattern can be matched. A simple example of this would be the following pattern: pattern!{ my_pattern: Expr = Array( _* Lit(_)+#literals)\n} This pattern matches arrays that end with at least one literal. Now given the array [x, 1, 2], should 1 be matched as part of the _* or the Lit(_)+ part of the pattern? The difference is important because the named submatch #literals would contain 1 or 2 elements depending how the pattern is matched. In regular expressions, this problem is solved by matching \"greedy\" by default and \"non-greedy\" optionally. I haven't looked much into this yet because I don't know how relevant it is for most lints. The current implementation simply returns the first match it finds.","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Unresolved questions","id":"225","title":"Unresolved questions"},"226":{"body":"Implement rest of Rust Syntax The current project only implements a small part of the Rust syntax. In the future, this should incrementally be extended to more syntax to allow implementing more lints. Implementing more of the Rust syntax requires extending the PatternTree and IsMatch implementations, but should be relatively straight-forward. Early filtering As described in the Drawbacks/Performance section, allowing additional checks during the pattern matching might be beneficial. The pattern below shows how this could look like: pattern!{ pat_if_without_else: Expr = If( _, Block( Expr( If(_, _, ())#inner ) | Semi( If(_, _, ())#inner ) )#then, () ) where !in_macro(#then.span);\n} The difference compared to the currently proposed two-stage filtering is that using early filtering, the condition (!in_macro(#then.span) in this case) would be evaluated as soon as the Block(_)#then was matched. Another idea in this area would be to introduce a syntax for backreferences. They could be used to require that multiple parts of a pattern should match the same value. For example, the assign_op_pattern lint that searches for a = a op b and recommends changing it to a op= b requires that both occurrences of a are the same. Using =#... as syntax for backreferences, the lint could be implemented like this: pattern!{ assign_op_pattern: Expr = Assign(_#target, Binary(_, =#target, _)\n} Match descendant A lot of lints currently implement custom visitors that check whether any subtree (which might not be a direct descendant) of the current node matches some properties. This cannot be expressed with the proposed pattern syntax. Extending the pattern syntax to allow patterns like \"a function that contains at least two return statements\" could be a practical addition. Negation operator for alternatives For patterns like \"a literal that is not a boolean literal\" one currently needs to list all alternatives except the boolean case. Introducing a negation operator that allows to write Lit(!Bool(_)) might be a good idea. This pattern would be equivalent to Lit( Char(_) | Int(_) ) (given that currently only three literal types are implemented). Functional composition Patterns currently don't have any concept of composition. This leads to repetitions within patterns. For example, one of the collapsible-if patterns currently has to be written like this: pattern!{ pat_if_else: Expr = If( _, _, Block_( Block( Expr((If(_, _, _?) | IfLet(_, _?))#else_) | Semi((If(_, _, _?) | IfLet(_, _?))#else_) )#block_inner )#block ) | IfLet( _, Block_( Block( Expr((If(_, _, _?) | IfLet(_, _?))#else_) | Semi((If(_, _, _?) | IfLet(_, _?))#else_) )#block_inner )#block )\n} If patterns supported defining functions of subpatterns, the code could be simplified as follows: pattern!{ fn expr_or_semi(expr: Expr) -> Stmt { Expr(expr) | Semi(expr) } fn if_or_if_let(then: Block, else: Opt<Expr>) -> Expr { If(_, then, else) | IfLet(then, else) } pat_if_else: Expr = if_or_if_let( _, Block_( Block( expr_or_semi( if_or_if_let(_, _?)#else_ ) )#block_inner )#block )\n} Additionally, common patterns like expr_or_semi could be shared between different lints. Clippy Pattern Author Another improvement could be to create a tool that, given some valid Rust syntax, generates a pattern that matches this syntax exactly. This would make starting to write a pattern easier. A user could take a look at the patterns generated for a couple of Rust code examples and use that information to write a pattern that matches all of them. This is similar to clippy's author lint. Supporting other syntaxes Most of the proposed system is language-agnostic. For example, the pattern syntax could also be used to describe patterns for other programming languages. In order to support other languages' syntaxes, one would need to implement another PatternTree that sufficiently describes the languages' AST and implement IsMatch for this PatternTree and the languages' AST. One aspect of this is that it would even be possible to write lints that work on the pattern syntax itself. For example, when writing the following pattern pattern!{ my_pattern: Expr = Array( Lit(Bool(false)) Lit(Bool(false)) )\n} a lint that works on the pattern syntax's AST could suggest using this pattern instead: pattern!{ my_pattern: Expr = Array( Lit(Bool(false)){2} )\n} In the future, Clippy could use this system to also provide lints for custom syntaxes like those found in macros.","breadcrumbs":"Development » Proposals » Syntax Tree Patterns » Future possibilities","id":"226","title":"Future possibilities"},"227":{"body":"Everyone who contributes to Clippy makes the project what it is. Collaboration and discussions are the lifeblood of every open-source project. Clippy has a very flat hierarchy. The teams mainly have additional access rights to the repo. This document outlines the onboarding process, as well as duties, and access rights for members of a group. All regular events mentioned in this chapter are tracked in the calendar repository . The calendar file is also available for download: clippy.ics","breadcrumbs":"Development » The Team » The team","id":"227","title":"The team"},"228":{"body":"Everyone, including you, is welcome to join discussions and contribute in other ways, like PRs. You also have some triage rights, using @rustbot to add labels and claim issues. See labeling with @rustbot . A rule for everyone should be to keep a healthy work-life balance. Take a break when you need one.","breadcrumbs":"Development » The Team » Everyone","id":"228","title":"Everyone"},"229":{"body":"This is a group of regular contributors to Clippy to help with triaging. Duties This team exists to make contributing easier for regular members. It doesn't carry any duties that need to be done. However, we want to encourage members of this group to help with triaging, which can include: Labeling issues For the good-first-issue label, it can still be good to use @rustbot to subscribe to the issue and help interested parties, if they post questions in the comments. Closing duplicate or resolved issues When you manually close an issue, it's often a good idea, to add a short comment explaining the reason. Ping people after two weeks of inactivity We try to keep issue assignments and PRs fairly up-to-date. After two weeks, it can be good to send a friendly ping to the delaying party. You might close a PR with the I-inactive-closed label if the author is busy or wants to abandon it. If the reviewer is busy, the PR can be reassigned to someone else. Checkout: https://triage.rust-lang.org/triage/rust-lang/rust-clippy to monitor PRs. While not part of their duties, contributors are encouraged to review PRs and help on Zulip. The team always appreciates help! Membership If you have been contributing to Clippy for some time, we'll probably ask you if you want to join this team. Members of this team are also welcome to suggest people who they think would make a great addition to this group. For this group, there is no direct onboarding process. You're welcome to just continue what you've been doing. If you like, you can ask for someone to mentor you, either in the Clippy stream on Zulip or privately via a PM. If you have been inactive in Clippy for over three months, we'll probably move you to the alumni group. You're always welcome to come back.","breadcrumbs":"Development » The Team » Clippy-Contributors","id":"229","title":"Clippy-Contributors"},"23":{"body":"Whether useless_vec should ignore test functions or #[cfg(test)] Default Value: false Affected lints: useless_vec","breadcrumbs":"Configuration » Lint Configuration » allow-useless-vec-in-tests","id":"23","title":"allow-useless-vec-in-tests"},"230":{"body":"The Clippy team is responsible for maintaining Clippy. Duties Respond to PRs in a timely manner It's totally fine, if you don't have the time for reviews right now. You can reassign the PR to a random member by commenting r? clippy. Take a break when you need one You are valuable! Clippy wouldn't be what it is without you. So take a break early and recharge some energy when you need to. Be responsive on Zulip This means in a reasonable time frame, so responding within one or two days is totally fine. It's also good, if you answer threads on Zulip and take part in our Clippy meetings, every two weeks. The meeting dates are tracked in the calendar repository . Sync Clippy with the rust-lang/rust repo This is done every two weeks, usually by @flip1995. Update the changelog This needs to be done for every release, every six weeks. This is usually done by @xFrednet. Membership If you have been active for some time, we'll probably reach out and ask if you want to help with reviews and eventually join the Clippy team. During the onboarding process, you'll be assigned pull requests to review. You'll also have an active team member as a mentor who'll stay in contact via Zulip DMs to provide advice and feedback. If you have questions, you're always welcome to ask, that is the best way to learn. Once you're done with the review, you can ping your mentor for a full review and to r+ the PR in both of your names. When your mentor is confident that you can handle reviews on your own, they'll start an informal vote among the active team members to officially add you to the team. This vote is usually accepted unanimously. Then you'll be added to the team once you've confirmed that you're still interested in joining. The onboarding phase typically takes a couple of weeks to a few months. If you have been inactive in Clippy for over three months, we'll probably move you to the alumni group. You're always welcome to come back.","breadcrumbs":"Development » The Team » The Clippy Team","id":"230","title":"The Clippy Team"},"24":{"body":"Additional dotfiles (files or directories starting with a dot) to allow Default Value: [] Affected lints: path_ends_with_ext","breadcrumbs":"Configuration » Lint Configuration » allowed-dotfiles","id":"24","title":"allowed-dotfiles"},"25":{"body":"A list of crate names to allow duplicates of Default Value: [] Affected lints: multiple_crate_versions","breadcrumbs":"Configuration » Lint Configuration » allowed-duplicate-crates","id":"25","title":"allowed-duplicate-crates"},"26":{"body":"Allowed names below the minimum allowed characters. The value \"..\" can be used as part of the list to indicate, that the configured values should be appended to the default configuration of Clippy. By default, any configuration will replace the default value. Default Value: [\"i\", \"j\", \"x\", \"y\", \"z\", \"w\", \"n\"] Affected lints: min_ident_chars","breadcrumbs":"Configuration » Lint Configuration » allowed-idents-below-min-chars","id":"26","title":"allowed-idents-below-min-chars"},"27":{"body":"List of prefixes to allow when determining whether an item's name ends with the module's name. If the rest of an item's name is an allowed prefix (e.g. item ToFoo or to_foo in module foo), then don't emit a warning. Example allowed-prefixes = [ \"to\", \"from\" ] Noteworthy By default, the following prefixes are allowed: to, as, into, from, try_into and try_from PascalCase variant is included automatically for each snake_case variant (e.g. if try_into is included, TryInto will also be included) Use \"..\" as part of the list to indicate that the configured values should be appended to the default configuration of Clippy. By default, any configuration will replace the default value Default Value: [\"to\", \"as\", \"into\", \"from\", \"try_into\", \"try_from\"] Affected lints: module_name_repetitions","breadcrumbs":"Configuration » Lint Configuration » allowed-prefixes","id":"27","title":"allowed-prefixes"},"28":{"body":"The list of unicode scripts allowed to be used in the scope. Default Value: [\"Latin\"] Affected lints: disallowed_script_idents","breadcrumbs":"Configuration » Lint Configuration » allowed-scripts","id":"28","title":"allowed-scripts"},"29":{"body":"List of path segments allowed to have wildcard imports. Example allowed-wildcard-imports = [ \"utils\", \"common\" ] Noteworthy This configuration has no effects if used with warn_on_all_wildcard_imports = true. Paths with any segment that containing the word 'prelude' are already allowed by default. Default Value: [] Affected lints: wildcard_imports","breadcrumbs":"Configuration » Lint Configuration » allowed-wildcard-imports","id":"29","title":"allowed-wildcard-imports"},"3":{"body":"Take a look at the Basics chapter in the Clippy developer guide to find step-by-step instructions on how to build and install Clippy from source.","breadcrumbs":"Installation » From Source","id":"3","title":"From Source"},"30":{"body":"Suppress checking of the passed type names in all types of operations. If a specific operation is desired, consider using arithmetic_side_effects_allowed_binary or arithmetic_side_effects_allowed_unary instead. Example arithmetic-side-effects-allowed = [\"SomeType\", \"AnotherType\"] Noteworthy A type, say SomeType, listed in this configuration has the same behavior of [\"SomeType\" , \"*\"], [\"*\", \"SomeType\"] in arithmetic_side_effects_allowed_binary. Default Value: [] Affected lints: arithmetic_side_effects","breadcrumbs":"Configuration » Lint Configuration » arithmetic-side-effects-allowed","id":"30","title":"arithmetic-side-effects-allowed"},"31":{"body":"Suppress checking of the passed type pair names in binary operations like addition or multiplication. Supports the \"*\" wildcard to indicate that a certain type won't trigger the lint regardless of the involved counterpart. For example, [\"SomeType\", \"*\"] or [\"*\", \"AnotherType\"]. Pairs are asymmetric, which means that [\"SomeType\", \"AnotherType\"] is not the same as [\"AnotherType\", \"SomeType\"]. Example arithmetic-side-effects-allowed-binary = [[\"SomeType\" , \"f32\"], [\"AnotherType\", \"*\"]] Default Value: [] Affected lints: arithmetic_side_effects","breadcrumbs":"Configuration » Lint Configuration » arithmetic-side-effects-allowed-binary","id":"31","title":"arithmetic-side-effects-allowed-binary"},"32":{"body":"Suppress checking of the passed type names in unary operations like \"negation\" (-). Example arithmetic-side-effects-allowed-unary = [\"SomeType\", \"AnotherType\"] Default Value: [] Affected lints: arithmetic_side_effects","breadcrumbs":"Configuration » Lint Configuration » arithmetic-side-effects-allowed-unary","id":"32","title":"arithmetic-side-effects-allowed-unary"},"33":{"body":"The maximum allowed size for arrays on the stack Default Value: 512000 Affected lints: large_const_arrays large_stack_arrays","breadcrumbs":"Configuration » Lint Configuration » array-size-threshold","id":"33","title":"array-size-threshold"},"34":{"body":"Suppress lints whenever the suggested change would cause breakage for other crates. Default Value: true Affected lints: box_collection enum_variant_names large_types_passed_by_value linkedlist needless_pass_by_ref_mut option_option rc_buffer rc_mutex redundant_allocation ref_option single_call_fn trivially_copy_pass_by_ref unnecessary_box_returns unnecessary_wraps unused_self upper_case_acronyms vec_box wrong_self_convention","breadcrumbs":"Configuration » Lint Configuration » avoid-breaking-exported-api","id":"34","title":"avoid-breaking-exported-api"},"35":{"body":"The list of types which may not be held across an await point. Default Value: [] Affected lints: await_holding_invalid_type","breadcrumbs":"Configuration » Lint Configuration » await-holding-invalid-types","id":"35","title":"await-holding-invalid-types"},"36":{"body":"For internal testing only, ignores the current publish settings in the Cargo manifest. Default Value: false Affected lints: cargo_common_metadata","breadcrumbs":"Configuration » Lint Configuration » cargo-ignore-publish","id":"36","title":"cargo-ignore-publish"},"37":{"body":"Whether to also run the listed lints on private items. Default Value: false Affected lints: missing_errors_doc missing_panics_doc missing_safety_doc unnecessary_safety_doc","breadcrumbs":"Configuration » Lint Configuration » check-private-items","id":"37","title":"check-private-items"},"38":{"body":"The maximum cognitive complexity a function can have Default Value: 25 Affected lints: cognitive_complexity","breadcrumbs":"Configuration » Lint Configuration » cognitive-complexity-threshold","id":"38","title":"cognitive-complexity-threshold"},"39":{"body":"The list of disallowed macros, written as fully qualified paths. Default Value: [] Affected lints: disallowed_macros","breadcrumbs":"Configuration » Lint Configuration » disallowed-macros","id":"39","title":"disallowed-macros"},"4":{"body":"This chapter describes how to use Clippy to get the most out of it. Clippy can be used as a cargo subcommand or, like rustc, directly with the clippy-driver binary. Note: This chapter assumes that you have Clippy installed already. If you're not sure, take a look at the Installation chapter.","breadcrumbs":"Usage » Usage","id":"4","title":"Usage"},"40":{"body":"The list of disallowed methods, written as fully qualified paths. Default Value: [] Affected lints: disallowed_methods","breadcrumbs":"Configuration » Lint Configuration » disallowed-methods","id":"40","title":"disallowed-methods"},"41":{"body":"The list of disallowed names to lint about. NB: bar is not here since it has legitimate uses. The value \"..\" can be used as part of the list to indicate that the configured values should be appended to the default configuration of Clippy. By default, any configuration will replace the default value. Default Value: [\"foo\", \"baz\", \"quux\"] Affected lints: disallowed_names","breadcrumbs":"Configuration » Lint Configuration » disallowed-names","id":"41","title":"disallowed-names"},"42":{"body":"The list of disallowed types, written as fully qualified paths. Default Value: [] Affected lints: disallowed_types","breadcrumbs":"Configuration » Lint Configuration » disallowed-types","id":"42","title":"disallowed-types"},"43":{"body":"The list of words this lint should not consider as identifiers needing ticks. The value \"..\" can be used as part of the list to indicate, that the configured values should be appended to the default configuration of Clippy. By default, any configuration will replace the default value. For example: doc-valid-idents = [\"ClipPy\"] would replace the default list with [\"ClipPy\"]. doc-valid-idents = [\"ClipPy\", \"..\"] would append ClipPy to the default list. Default Value: [\"KiB\", \"MiB\", \"GiB\", \"TiB\", \"PiB\", \"EiB\", \"AccessKit\", \"CoreFoundation\", \"CoreGraphics\", \"CoreText\", \"DevOps\", \"Direct2D\", \"Direct3D\", \"DirectWrite\", \"DirectX\", \"ECMAScript\", \"GPLv2\", \"GPLv3\", \"GitHub\", \"GitLab\", \"IPv4\", \"IPv6\", \"ClojureScript\", \"CoffeeScript\", \"JavaScript\", \"PostScript\", \"PureScript\", \"TypeScript\", \"WebAssembly\", \"NaN\", \"NaNs\", \"OAuth\", \"GraphQL\", \"OCaml\", \"OpenAL\", \"OpenDNS\", \"OpenGL\", \"OpenMP\", \"OpenSSH\", \"OpenSSL\", \"OpenStreetMap\", \"OpenTelemetry\", \"OpenType\", \"WebGL\", \"WebGL2\", \"WebGPU\", \"WebRTC\", \"WebSocket\", \"WebTransport\", \"WebP\", \"OpenExr\", \"YCbCr\", \"sRGB\", \"TensorFlow\", \"TrueType\", \"iOS\", \"macOS\", \"FreeBSD\", \"NetBSD\", \"OpenBSD\", \"TeX\", \"LaTeX\", \"BibTeX\", \"BibLaTeX\", \"MinGW\", \"CamelCase\"] Affected lints: doc_markdown","breadcrumbs":"Configuration » Lint Configuration » doc-valid-idents","id":"43","title":"doc-valid-idents"},"44":{"body":"Whether to apply the raw pointer heuristic to determine if a type is Send. Default Value: true Affected lints: non_send_fields_in_send_ty","breadcrumbs":"Configuration » Lint Configuration » enable-raw-pointer-heuristic-for-send","id":"44","title":"enable-raw-pointer-heuristic-for-send"},"45":{"body":"Whether to recommend using implicit into iter for reborrowed values. Example let mut vec = vec![1, 2, 3];\nlet rmvec = &mut vec;\nfor _ in rmvec.iter() {}\nfor _ in rmvec.iter_mut() {} Use instead: let mut vec = vec![1, 2, 3];\nlet rmvec = &mut vec;\nfor _ in &*rmvec {}\nfor _ in &mut *rmvec {} Default Value: false Affected lints: explicit_iter_loop","breadcrumbs":"Configuration » Lint Configuration » enforce-iter-loop-reborrow","id":"45","title":"enforce-iter-loop-reborrow"},"46":{"body":"The list of imports to always rename, a fully qualified path followed by the rename. Default Value: [] Affected lints: missing_enforced_import_renames","breadcrumbs":"Configuration » Lint Configuration » enforced-import-renames","id":"46","title":"enforced-import-renames"},"47":{"body":"The minimum number of enum variants for the lints about variant names to trigger Default Value: 3 Affected lints: enum_variant_names","breadcrumbs":"Configuration » Lint Configuration » enum-variant-name-threshold","id":"47","title":"enum-variant-name-threshold"},"48":{"body":"The maximum size of an enum's variant to avoid box suggestion Default Value: 200 Affected lints: large_enum_variant","breadcrumbs":"Configuration » Lint Configuration » enum-variant-size-threshold","id":"48","title":"enum-variant-size-threshold"},"49":{"body":"The maximum amount of nesting a block can reside in Default Value: 0 Affected lints: excessive_nesting","breadcrumbs":"Configuration » Lint Configuration » excessive-nesting-threshold","id":"49","title":"excessive-nesting-threshold"},"5":{"body":"The easiest and most common way to run Clippy is through cargo. To do that, just run cargo clippy Lint configuration The above command will run the default set of lints, which are included in the lint group clippy::all. You might want to use even more lints, or you may not agree with every Clippy lint, and for that there are ways to configure lint levels. Note: Clippy is meant to be used with a generous sprinkling of #[allow(..)]s through your code. So if you disagree with a lint, don't feel bad disabling them for parts of your code or the whole project. Command line You can configure lint levels on the command line by adding -A/W/D clippy::lint_name like this: cargo clippy -- -Aclippy::style -Wclippy::double_neg -Dclippy::perf For CI all warnings can be elevated to errors which will in turn fail the build and cause Clippy to exit with a code other than 0. cargo clippy -- -Dwarnings Note: Adding -D warnings will cause your build to fail if any warnings are found in your code. That includes warnings found by rustc (e.g. dead_code, etc.). For more information on configuring lint levels, see the rustc documentation . Even more lints Clippy has lint groups which are allow-by-default. This means, that you will have to enable the lints in those groups manually. For a full list of all lints with their description and examples, please refer to Clippy's lint list . The two most important allow-by-default groups are described below: clippy::pedantic The first group is the pedantic group. This group contains really opinionated lints, that may have some intentional false positives in order to prevent false negatives. So while this group is ready to be used in production, you can expect to sprinkle multiple #[allow(..)]s in your code. If you find any false positives, you're still welcome to report them to us for future improvements. FYI: Clippy uses the whole group to lint itself. clippy::restriction The second group is the restriction group. This group contains lints that \"restrict\" the language in some way. For example the clippy::unwrap lint from this group won't allow you to use .unwrap() in your code. You may want to look through the lints in this group and enable the ones that fit your need. Note: You shouldn't enable the whole lint group, but cherry-pick lints from this group. Some lints in this group will even contradict other Clippy lints! Too many lints The most opinionated warn-by-default group of Clippy is the clippy::style group. Some people prefer to disable this group completely and then cherry-pick some lints they like from this group. The same is of course possible with every other of Clippy's lint groups. Note: We try to keep the warn-by-default groups free from false positives (FP). If you find that a lint wrongly triggers, please report it in an issue (if there isn't an issue for that FP already) Source Code You can configure lint levels in source code the same way you can configure rustc lints: #![allow(clippy::style)] #[warn(clippy::double_neg)]\nfn main() { let x = 1; let y = --x; // ^^ warning: double negation\n} Automatically applying Clippy suggestions Clippy can automatically apply some lint suggestions, just like the compiler. Note that --fix implies --all-targets, so it can fix as much code as it can. cargo clippy --fix Workspaces All the usual workspace options should work with Clippy. For example the following command will run Clippy on the example crate in your workspace: cargo clippy -p example As with cargo check, this includes dependencies that are members of the workspace, like path dependencies. If you want to run Clippy only on the given crate, use the --no-deps option like this: cargo clippy -p example -- --no-deps","breadcrumbs":"Usage » Cargo subcommand","id":"5","title":"Cargo subcommand"},"50":{"body":"The maximum byte size a Future can have, before it triggers the clippy::large_futures lint Default Value: 16384 Affected lints: large_futures","breadcrumbs":"Configuration » Lint Configuration » future-size-threshold","id":"50","title":"future-size-threshold"},"51":{"body":"A list of paths to types that should be treated as if they do not contain interior mutability Default Value: [\"bytes::Bytes\"] Affected lints: borrow_interior_mutable_const declare_interior_mutable_const ifs_same_cond mutable_key_type","breadcrumbs":"Configuration » Lint Configuration » ignore-interior-mutability","id":"51","title":"ignore-interior-mutability"},"52":{"body":"The maximum size of the Err-variant in a Result returned from a function Default Value: 128 Affected lints: result_large_err","breadcrumbs":"Configuration » Lint Configuration » large-error-threshold","id":"52","title":"large-error-threshold"},"53":{"body":"The lower bound for linting decimal literals Default Value: 16384 Affected lints: decimal_literal_representation","breadcrumbs":"Configuration » Lint Configuration » literal-representation-threshold","id":"53","title":"literal-representation-threshold"},"54":{"body":"Whether the matches should be considered by the lint, and whether there should be filtering for common types. Default Value: \"WellKnownTypes\" Affected lints: manual_let_else","breadcrumbs":"Configuration » Lint Configuration » matches-for-let-else","id":"54","title":"matches-for-let-else"},"55":{"body":"The maximum number of bool parameters a function can have Default Value: 3 Affected lints: fn_params_excessive_bools","breadcrumbs":"Configuration » Lint Configuration » max-fn-params-bools","id":"55","title":"max-fn-params-bools"},"56":{"body":"The maximum size of a file included via include_bytes!() or include_str!(), in bytes Default Value: 1000000 Affected lints: large_include_file","breadcrumbs":"Configuration » Lint Configuration » max-include-file-size","id":"56","title":"max-include-file-size"},"57":{"body":"The maximum number of bool fields a struct can have Default Value: 3 Affected lints: struct_excessive_bools","breadcrumbs":"Configuration » Lint Configuration » max-struct-bools","id":"57","title":"max-struct-bools"},"58":{"body":"When Clippy suggests using a slice pattern, this is the maximum number of elements allowed in the slice pattern that is suggested. If more elements are necessary, the lint is suppressed. For example, [_, _, _, e, ..] is a slice pattern with 4 elements. Default Value: 3 Affected lints: index_refutable_slice","breadcrumbs":"Configuration » Lint Configuration » max-suggested-slice-pattern-length","id":"58","title":"max-suggested-slice-pattern-length"},"59":{"body":"The maximum number of bounds a trait can have to be linted Default Value: 3 Affected lints: type_repetition_in_bounds","breadcrumbs":"Configuration » Lint Configuration » max-trait-bounds","id":"59","title":"max-trait-bounds"},"6":{"body":"Clippy can also be used in projects that do not use cargo. To do so, run clippy-driver with the same arguments you use for rustc. For example: clippy-driver --edition 2018 -Cpanic=abort foo.rs Note: clippy-driver is designed for running Clippy and should not be used as a general replacement for rustc. clippy-driver may produce artifacts that are not optimized as expected, for example.","breadcrumbs":"Usage » Using Clippy without cargo: clippy-driver","id":"6","title":"Using Clippy without cargo: clippy-driver"},"60":{"body":"Minimum chars an ident can have, anything below or equal to this will be linted. Default Value: 1 Affected lints: min_ident_chars","breadcrumbs":"Configuration » Lint Configuration » min-ident-chars-threshold","id":"60","title":"min-ident-chars-threshold"},"61":{"body":"Whether to only check for missing documentation in items visible within the current crate. For example, pub(crate) items. Default Value: false Affected lints: missing_docs_in_private_items","breadcrumbs":"Configuration » Lint Configuration » missing-docs-in-crate-items","id":"61","title":"missing-docs-in-crate-items"},"62":{"body":"The minimum rust version that the project supports. Defaults to the rust-version field in Cargo.toml Default Value: current version Affected lints: allow_attributes allow_attributes_without_reason almost_complete_range approx_constant assigning_clones borrow_as_ptr cast_abs_to_unsigned checked_conversions cloned_instead_of_copied collapsible_match collapsible_str_replace deprecated_cfg_attr derivable_impls err_expect filter_map_next from_over_into if_then_some_else_none index_refutable_slice iter_kv_map legacy_numeric_constants manual_bits manual_c_str_literals manual_clamp manual_hash_one manual_is_ascii_check manual_let_else manual_non_exhaustive manual_pattern_char_comparison manual_range_contains manual_rem_euclid manual_retain manual_split_once manual_str_repeat manual_strip manual_try_fold map_clone map_unwrap_or match_like_matches_macro mem_replace_with_default missing_const_for_fn needless_borrow option_as_ref_deref option_map_unwrap_or ptr_as_ptr redundant_field_names redundant_static_lifetimes seek_from_current seek_rewind transmute_ptr_to_ref tuple_array_conversions type_repetition_in_bounds unchecked_duration_subtraction uninlined_format_args unnecessary_lazy_evaluations unnested_or_patterns unused_trait_names use_self","breadcrumbs":"Configuration » Lint Configuration » msrv","id":"62","title":"msrv"},"63":{"body":"The minimum size (in bytes) to consider a type for passing by reference instead of by value. Default Value: 256 Affected lints: large_types_passed_by_value","breadcrumbs":"Configuration » Lint Configuration » pass-by-value-size-limit","id":"63","title":"pass-by-value-size-limit"},"64":{"body":"Lint \"public\" fields in a struct that are prefixed with an underscore based on their exported visibility, or whether they are marked as \"pub\". Default Value: \"PubliclyExported\" Affected lints: pub_underscore_fields","breadcrumbs":"Configuration » Lint Configuration » pub-underscore-fields-behavior","id":"64","title":"pub-underscore-fields-behavior"},"65":{"body":"Whether to lint only if it's multiline. Default Value: false Affected lints: semicolon_inside_block","breadcrumbs":"Configuration » Lint Configuration » semicolon-inside-block-ignore-singleline","id":"65","title":"semicolon-inside-block-ignore-singleline"},"66":{"body":"Whether to lint only if it's singleline. Default Value: false Affected lints: semicolon_outside_block","breadcrumbs":"Configuration » Lint Configuration » semicolon-outside-block-ignore-multiline","id":"66","title":"semicolon-outside-block-ignore-multiline"},"67":{"body":"The maximum number of single char bindings a scope may have Default Value: 4 Affected lints: many_single_char_names","breadcrumbs":"Configuration » Lint Configuration » single-char-binding-names-threshold","id":"67","title":"single-char-binding-names-threshold"},"68":{"body":"The maximum allowed stack size for functions in bytes Default Value: 512000 Affected lints: large_stack_frames","breadcrumbs":"Configuration » Lint Configuration » stack-size-threshold","id":"68","title":"stack-size-threshold"},"69":{"body":"Enforce the named macros always use the braces specified. A MacroMatcher can be added like so { name = \"macro_name\", brace = \"(\" }. If the macro could be used with a full path two MacroMatchers have to be added one with the full path crate_name::macro_name and one with just the macro name. Default Value: [] Affected lints: nonstandard_macro_braces","breadcrumbs":"Configuration » Lint Configuration » standard-macro-braces","id":"69","title":"standard-macro-braces"},"7":{"body":"Note: The configuration file is unstable and may be deprecated in the future. Some lints can be configured in a TOML file named clippy.toml or .clippy.toml, which is searched for in: The directory specified by the CLIPPY_CONF_DIR environment variable, or The directory specified by the CARGO_MANIFEST_DIR environment variable, or The current directory. It contains a basic variable = value mapping e.g. avoid-breaking-exported-api = false\ndisallowed-names = [\"toto\", \"tata\", \"titi\"] The table of configurations contains all config values, their default, and a list of lints they affect. Each configurable lint , also contains information about these values. For configurations that are a list type with default values such as disallowed-names , you can use the unique value \"..\" to extend the default values instead of replacing them. # default of disallowed-names is [\"foo\", \"baz\", \"quux\"]\ndisallowed-names = [\"bar\", \"..\"] # -> [\"bar\", \"foo\", \"baz\", \"quux\"] To deactivate the \"for further information visit lint-link \" message you can define the CLIPPY_DISABLE_DOCS_LINKS environment variable. Allowing/Denying Lints Attributes in Code You can add attributes to your code to allow/warn/deny Clippy lints: the whole set of warn-by-default lints using the clippy lint group (#![allow(clippy::all)]) all lints using both the clippy and clippy::pedantic lint groups (#![warn(clippy::all, clippy::pedantic)]. Note that clippy::pedantic contains some very aggressive lints prone to false positives. only some lints (#![deny(clippy::single_match, clippy::box_vec)], etc.) allow/warn/deny can be limited to a single function or module using #[allow(...)], etc. Note: allow means to suppress the lint for your code. With warn the lint will only emit a warning, while with deny the lint will emit an error, when triggering for your code. An error causes Clippy to exit with an error code, so is most useful in scripts used in CI/CD. Command Line Flags If you do not want to include your lint levels in the code, you can globally enable/disable lints by passing extra flags to Clippy during the run: To allow lint_name, run cargo clippy -- -A clippy::lint_name And to warn on lint_name, run cargo clippy -- -W clippy::lint_name This also works with lint groups. For example, you can run Clippy with warnings for all pedantic lints enabled: cargo clippy -- -W clippy::pedantic If you care only about a certain lints, you can allow all others and then explicitly warn on the lints you are interested in: cargo clippy -- -A clippy::all -W clippy::useless_format -W clippy::... Lints Section in Cargo.toml Finally, lints can be allowed/denied using the lints section ) in the Cargo.toml file: To deny clippy::enum_glob_use, put the following in the Cargo.toml: [lints.clippy]\nenum_glob_use = \"deny\" For more details and options, refer to the Cargo documentation. Specifying the minimum supported Rust version Projects that intend to support old versions of Rust can disable lints pertaining to newer features by specifying the minimum supported Rust version (MSRV) in the Clippy configuration file. msrv = \"1.30.0\" The MSRV can also be specified as an attribute, like below. #![feature(custom_inner_attributes)]\n#![clippy::msrv = \"1.30.0\"] fn main() { ...\n} You can also omit the patch version when specifying the MSRV, so msrv = 1.30 is equivalent to msrv = 1.30.0. Note: custom_inner_attributes is an unstable feature, so it has to be enabled explicitly. Lints that recognize this configuration option can be found here Disabling evaluation of certain code Note: This should only be used in cases where other solutions, like #[allow(clippy::all)], are not sufficient. Very rarely, you may wish to prevent Clippy from evaluating certain sections of code entirely. You can do this with conditional compilation by checking that the clippy cfg is not set. You may need to provide a stub so that the code compiles: #[cfg(not(clippy))]\ninclude!(concat!(env!(\"OUT_DIR\"), \"/my_big_function-generated.rs\")); #[cfg(clippy)]\nfn my_big_function(_input: &str) -> Option<MyStruct> { None\n}","breadcrumbs":"Configuration » Configuring Clippy","id":"7","title":"Configuring Clippy"},"70":{"body":"The minimum number of struct fields for the lints about field names to trigger Default Value: 3 Affected lints: struct_field_names","breadcrumbs":"Configuration » Lint Configuration » struct-field-name-threshold","id":"70","title":"struct-field-name-threshold"},"71":{"body":"Whether to suppress a restriction lint in constant code. In same cases the restructured operation might not be unavoidable, as the suggested counterparts are unavailable in constant code. This configuration will cause restriction lints to trigger even if no suggestion can be made. Default Value: false Affected lints: indexing_slicing","breadcrumbs":"Configuration » Lint Configuration » suppress-restriction-lint-in-const","id":"71","title":"suppress-restriction-lint-in-const"},"72":{"body":"The maximum size of objects (in bytes) that will be linted. Larger objects are ok on the heap Default Value: 200 Affected lints: boxed_local useless_vec","breadcrumbs":"Configuration » Lint Configuration » too-large-for-stack","id":"72","title":"too-large-for-stack"},"73":{"body":"The maximum number of argument a function or method can have Default Value: 7 Affected lints: too_many_arguments","breadcrumbs":"Configuration » Lint Configuration » too-many-arguments-threshold","id":"73","title":"too-many-arguments-threshold"},"74":{"body":"The maximum number of lines a function or method can have Default Value: 100 Affected lints: too_many_lines","breadcrumbs":"Configuration » Lint Configuration » too-many-lines-threshold","id":"74","title":"too-many-lines-threshold"},"75":{"body":"The maximum size (in bytes) to consider a Copy type for passing by value instead of by reference. By default there is no limit Default Value: target_pointer_width * 2 Affected lints: trivially_copy_pass_by_ref","breadcrumbs":"Configuration » Lint Configuration » trivial-copy-size-limit","id":"75","title":"trivial-copy-size-limit"},"76":{"body":"The maximum complexity a type can have Default Value: 250 Affected lints: type_complexity","breadcrumbs":"Configuration » Lint Configuration » type-complexity-threshold","id":"76","title":"type-complexity-threshold"},"77":{"body":"The byte size a T in Box<T> can have, below which it triggers the clippy::unnecessary_box lint Default Value: 128 Affected lints: unnecessary_box_returns","breadcrumbs":"Configuration » Lint Configuration » unnecessary-box-size","id":"77","title":"unnecessary-box-size"},"78":{"body":"Should the fraction of a decimal be linted to include separators. Default Value: true Affected lints: unreadable_literal","breadcrumbs":"Configuration » Lint Configuration » unreadable-literal-lint-fractions","id":"78","title":"unreadable-literal-lint-fractions"},"79":{"body":"Enables verbose mode. Triggers if there is more than one uppercase char next to each other Default Value: false Affected lints: upper_case_acronyms","breadcrumbs":"Configuration » Lint Configuration » upper-case-acronyms-aggressive","id":"79","title":"upper-case-acronyms-aggressive"},"8":{"body":"The following list shows each configuration option, along with a description, its default value, an example and lints affected.","breadcrumbs":"Configuration » Lint Configuration » Lint Configuration Options","id":"8","title":"Lint Configuration Options"},"80":{"body":"The size of the boxed type in bytes, where boxing in a Vec is allowed Default Value: 4096 Affected lints: vec_box","breadcrumbs":"Configuration » Lint Configuration » vec-box-size-threshold","id":"80","title":"vec-box-size-threshold"},"81":{"body":"The maximum allowed size of a bit mask before suggesting to use 'trailing_zeros' Default Value: 1 Affected lints: verbose_bit_mask","breadcrumbs":"Configuration » Lint Configuration » verbose-bit-mask-threshold","id":"81","title":"verbose-bit-mask-threshold"},"82":{"body":"Whether to allow certain wildcard imports (prelude, super in tests). Default Value: false Affected lints: wildcard_imports","breadcrumbs":"Configuration » Lint Configuration » warn-on-all-wildcard-imports","id":"82","title":"warn-on-all-wildcard-imports"},"83":{"body":"Whether to also emit warnings for unsafe blocks with metavariable expansions in private macros. Default Value: false Affected lints: macro_metavars_in_unsafe","breadcrumbs":"Configuration » Lint Configuration » warn-unsafe-macro-metavars-in-private-macros","id":"83","title":"warn-unsafe-macro-metavars-in-private-macros"},"84":{"body":"Clippy offers a bunch of additional lints, to help its users write more correct and idiomatic Rust code. A full list of all lints, that can be filtered by category, lint level or keywords, can be found in the Clippy lint documentation . This chapter will give an overview of the different lint categories, which kind of lints they offer and recommended actions when you should see a lint out of that category. For examples, see the Clippy lint documentation and filter by category. The different lint groups were defined in the Clippy 1.0 RFC .","breadcrumbs":"Clippy's Lints » Clippy's Lints","id":"84","title":"Clippy's Lints"},"85":{"body":"The clippy::correctness group is the only lint group in Clippy which lints are deny-by-default and abort the compilation when triggered. This is for good reason: If you see a correctness lint, it means that your code is outright wrong or useless, and you should try to fix it. Lints in this category are carefully picked and should be free of false positives. So just #[allow]ing those lints is not recommended.","breadcrumbs":"Clippy's Lints » Correctness","id":"85","title":"Correctness"},"86":{"body":"The clippy::suspicious group is similar to the correctness lints in that it contains lints that trigger on code that is really sus and should be fixed. As opposed to correctness lints, it might be possible that the linted code is intentionally written like it is. It is still recommended to fix code that is linted by lints out of this group instead of #[allow]ing the lint. In case you intentionally have written code that offends the lint you should specifically and locally #[allow] the lint and add give a reason why the code is correct as written.","breadcrumbs":"Clippy's Lints » Suspicious","id":"86","title":"Suspicious"},"87":{"body":"The clippy::complexity group offers lints that give you suggestions on how to simplify your code. It mostly focuses on code that can be written in a shorter and more readable way, while preserving the semantics. If you should see a complexity lint, it usually means that you can remove or replace some code, and it is recommended to do so. However, if you need the more complex code for some expressiveness reason, it is recommended to allow complexity lints on a case-by-case basis.","breadcrumbs":"Clippy's Lints » Complexity","id":"87","title":"Complexity"},"88":{"body":"The clippy::perf group gives you suggestions on how you can increase the performance of your code. Those lints are mostly about code that the compiler can't trivially optimize, but has to be written in a slightly different way to make the optimizer job easier. Perf lints are usually easy to apply, and it is recommended to do so.","breadcrumbs":"Clippy's Lints » Perf","id":"88","title":"Perf"},"89":{"body":"The clippy::style group is mostly about writing idiomatic code. Because style is subjective, this lint group is the most opinionated warn-by-default group in Clippy. If you see a style lint, applying the suggestion usually makes your code more readable and idiomatic. But because we know that this is opinionated, feel free to sprinkle #[allow]s for style lints in your code or #![allow] a style lint on your whole crate if you disagree with the suggested style completely.","breadcrumbs":"Clippy's Lints » Style","id":"89","title":"Style"},"9":{"body":"Which crates to allow absolute paths from Default Value: [] Affected lints: absolute_paths","breadcrumbs":"Configuration » Lint Configuration » absolute-paths-allowed-crates","id":"9","title":"absolute-paths-allowed-crates"},"90":{"body":"The clippy::pedantic group makes Clippy even more pedantic . You can enable the whole group with #![warn(clippy::pedantic)] in the lib.rs/main.rs of your crate. This lint group is for Clippy power users that want an in depth check of their code. Note: Instead of enabling the whole group (like Clippy itself does), you may want to cherry-pick lints out of the pedantic group. If you enable this group, expect to also use #[allow] attributes generously throughout your code. Lints in this group are designed to be pedantic and false positives sometimes are intentional in order to prevent false negatives.","breadcrumbs":"Clippy's Lints » Pedantic","id":"90","title":"Pedantic"},"91":{"body":"The clippy::restriction group contains lints that will restrict you from using certain parts of the Rust language. It is not recommended to enable the whole group, but rather cherry-pick lints that are useful for your code base and your use case. Note: Clippy will produce a warning if it finds a #![warn(clippy::restriction)] attribute in your code! Lints from this group will restrict you in some way. If you enable a restriction lint for your crate it is recommended to also fix code that this lint triggers on. However, those lints are really strict by design, and you might want to #[allow] them in some special cases, with a comment justifying that.","breadcrumbs":"Clippy's Lints » Restriction","id":"91","title":"Restriction"},"92":{"body":"The clippy::cargo group gives you suggestions on how to improve your Cargo.toml file. This might be especially interesting if you want to publish your crate and are not sure if you have all useful information in your Cargo.toml.","breadcrumbs":"Clippy's Lints » Cargo","id":"92","title":"Cargo"},"93":{"body":"It is recommended to run Clippy on CI with -Dwarnings, so that Clippy lints prevent CI from passing. To enforce errors on warnings on all cargo commands not just cargo clippy, you can set the env var RUSTFLAGS=\"-Dwarnings\". We recommend to use Clippy from the same toolchain, that you use for compiling your crate for maximum compatibility. E.g. if your crate is compiled with the stable toolchain, you should also use stable Clippy. Note: New Clippy lints are first added to the nightly toolchain. If you want to help with improving Clippy and have CI resources left, please consider adding a nightly Clippy check to your CI and report problems like false positives back to us. With that we can fix bugs early, before they can get to stable. This chapter will give an overview on how to use Clippy on different popular CI providers.","breadcrumbs":"Continuous Integration » Continuous Integration","id":"93","title":"Continuous Integration"},"94":{"body":"GitHub hosted runners using the latest stable version of Rust have Clippy pre-installed. It is as simple as running cargo clippy to run lints against the codebase. on: push\nname: Clippy check # Make sure CI fails on all warnings, including Clippy lints\nenv: RUSTFLAGS: \"-Dwarnings\" jobs: clippy_check: runs-on: ubuntu-latest steps: - uses: actions/checkout@v4 - name: Run Clippy run: cargo clippy --all-targets --all-features","breadcrumbs":"Continuous Integration » GitHub Actions » GitHub Actions","id":"94","title":"GitHub Actions"},"95":{"body":"You can add Clippy to GitLab CI by using the latest stable rust docker image , as it is shown in the .gitlab-ci.yml CI configuration file below, # Make sure CI fails on all warnings, including Clippy lints\nvariables: RUSTFLAGS: \"-Dwarnings\" clippy_check: image: rust:latest script: - rustup component add clippy - cargo clippy --all-targets --all-features","breadcrumbs":"Continuous Integration » GitLab CI » GitLab CI","id":"95","title":"GitLab CI"},"96":{"body":"You can add Clippy to Travis CI in the same way you use it locally: language: rust\nrust: - stable - beta\nbefore_script: - rustup component add clippy\nscript: - cargo clippy # if you want the build job to fail when encountering warnings, use - cargo clippy -- -D warnings # in order to also check tests and non-default crate features, use - cargo clippy --all-targets --all-features -- -D warnings - cargo test # etc.","breadcrumbs":"Continuous Integration » Travis CI » Travis CI","id":"96","title":"Travis CI"},"97":{"body":"Hello fellow Rustacean! If you made it here, you're probably interested in making Clippy better by contributing to it. In that case, welcome to the project! Note: If you're just interested in using Clippy, there's nothing to see from this point onward, and you should return to one of the earlier chapters.","breadcrumbs":"Development » Clippy Development","id":"97","title":"Clippy Development"},"98":{"body":"If this is your first time contributing to Clippy, you should first read the Basics docs . This will explain the basics on how to get the source code and how to compile and test the code.","breadcrumbs":"Development » Getting started","id":"98","title":"Getting started"},"99":{"body":"If a dear reader of this documentation has never taken a class on compilers and interpreters, it might be confusing as to why AST level deals with only the language's syntax. And some readers might not even understand what lexing, parsing, and AST mean. This documentation serves by no means as a crash course on compilers or language design. And for details specifically related to Rust, the Rustc Development Guide is a far better choice to peruse. The Syntax and AST chapter and the High-Level IR chapter are great introduction to the concepts mentioned in this chapter. Some readers might also find the introductory chapter of Robert Nystrom's Crafting Interpreters a helpful overview of compiled and interpreted languages before jumping back to the Rustc guide.","breadcrumbs":"Development » Additional Readings for Beginners","id":"99","title":"Additional Readings for Beginners"}},"length":231,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{".":{"3":{")":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"(":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"148":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":1,"docs":{"148":{"tf":1.7320508075688772}},"f":{"6":{"4":{"df":1,"docs":{"148":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"4":{"8":{"df":1,"docs":{"138":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"/":{"df":0,"docs":{},"m":{"a":{"c":{"df":1,"docs":{"167":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"1":{"df":1,"docs":{"108":{"tf":1.4142135623730951}}},"3":{"df":1,"docs":{"209":{"tf":1.0}}},"7":{"df":1,"docs":{"108":{"tf":1.4142135623730951}}},"8":{"df":1,"docs":{"176":{"tf":1.0}}},"df":6,"docs":{"138":{"tf":2.0},"167":{"tf":1.4142135623730951},"174":{"tf":1.0},"223":{"tf":3.605551275463989},"49":{"tf":1.0},"5":{"tf":1.0}}},"1":{",":{"0":{"0":{"0":{"df":1,"docs":{"177":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"5":{",":{"0":{"df":1,"docs":{"121":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{".":{"1":{"df":1,"docs":{"147":{"tf":1.0}}},"=":{"1":{"df":1,"docs":{"147":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":2,"docs":{"100":{"tf":1.0},"84":{"tf":1.0}}},"2":{"9":{".":{"0":{"df":2,"docs":{"116":{"tf":1.0},"124":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"0":{".":{"0":{"df":1,"docs":{"7":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"4":{"4":{"df":1,"docs":{"121":{"tf":1.0}}},"5":{"df":1,"docs":{"121":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"7":{"0":{".":{"0":{"df":1,"docs":{"134":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"x":{"df":0,"docs":{},"x":{".":{"0":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"192":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":3,"docs":{"190":{"tf":1.0},"191":{"tf":1.4142135623730951},"192":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"193":{"tf":1.4142135623730951}}}}},"/":{"df":0,"docs":{},"g":{"df":3,"docs":{"186":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0}}}},"0":{"0":{"0":{"0":{"0":{"0":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"203":{"tf":1.0}}},"df":1,"docs":{"74":{"tf":1.0}}},"1":{"df":1,"docs":{"213":{"tf":1.0}}},"df":1,"docs":{"148":{"tf":1.4142135623730951}}},"2":{"8":{"df":2,"docs":{"52":{"tf":1.0},"77":{"tf":1.0}}},"df":2,"docs":{"131":{"tf":1.0},"209":{"tf":1.0}}},"6":{"3":{"8":{"4":{"df":2,"docs":{"50":{"tf":1.0},"53":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"2":{"8":{"df":1,"docs":{"206":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":16,"docs":{"0":{"tf":1.0},"147":{"tf":1.7320508075688772},"167":{"tf":2.0},"171":{"tf":1.0},"172":{"tf":1.0},"174":{"tf":1.4142135623730951},"186":{"tf":1.4142135623730951},"187":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"210":{"tf":1.4142135623730951},"223":{"tf":2.449489742783178},"225":{"tf":1.7320508075688772},"5":{"tf":1.0},"60":{"tf":1.0},"81":{"tf":1.0}}},"2":{".":{"0":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"0":{"0":{"df":2,"docs":{"48":{"tf":1.0},"72":{"tf":1.0}}},"1":{"6":{"df":1,"docs":{"206":{"tf":1.0}}},"8":{"df":1,"docs":{"6":{"tf":1.0}}},"9":{"df":1,"docs":{"209":{"tf":1.0}}},"df":0,"docs":{}},"2":{"0":{"df":2,"docs":{"176":{"tf":1.0},"203":{"tf":1.4142135623730951}}},"1":{"df":7,"docs":{"108":{"tf":1.4142135623730951},"198":{"tf":1.0},"199":{"tf":1.0},"200":{"tf":1.0},"201":{"tf":1.0},"203":{"tf":1.0},"208":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"208":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":1,"docs":{"193":{"tf":2.0}}}}},"5":{"0":{"df":1,"docs":{"76":{"tf":1.0}}},"6":{"df":1,"docs":{"63":{"tf":1.0}}},"df":3,"docs":{"153":{"tf":1.0},"203":{"tf":1.0},"38":{"tf":1.0}}},"7":{"df":1,"docs":{"176":{"tf":1.0}}},"df":12,"docs":{"10":{"tf":1.0},"148":{"tf":1.4142135623730951},"171":{"tf":1.0},"172":{"tf":1.0},"176":{"tf":1.0},"186":{"tf":1.0},"187":{"tf":1.0},"202":{"tf":1.0},"213":{"tf":1.0},"225":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"75":{"tf":1.0}}},"3":{".":{"1":{"df":1,"docs":{"186":{"tf":1.0}}},"df":0,"docs":{}},"1":{"6":{"4":{"df":1,"docs":{"202":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"df":1,"docs":{"203":{"tf":1.0}}},"8":{"7":{"5":{"df":1,"docs":{"209":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"0":{"df":1,"docs":{"148":{"tf":1.0}}},"df":0,"docs":{}},"df":10,"docs":{"138":{"tf":1.4142135623730951},"171":{"tf":1.0},"186":{"tf":1.0},"45":{"tf":1.4142135623730951},"47":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"70":{"tf":1.0}}},"4":{"0":{"9":{"6":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"1":{"2":{"df":1,"docs":{"202":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"186":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":1.0}}},"5":{"1":{"2":{"0":{"0":{"0":{"df":2,"docs":{"33":{"tf":1.0},"68":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"9":{"4":{"df":1,"docs":{"203":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"3":{"7":{"df":1,"docs":{"202":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"0":{"0":{"0":{"0":{"df":1,"docs":{"177":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"6":{"6":{"df":1,"docs":{"202":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"2":{"9":{"df":2,"docs":{"202":{"tf":1.0},"203":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"148":{"tf":1.0}}},"7":{"0":{"0":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"73":{"tf":1.0}}},"9":{"df":3,"docs":{"186":{"tf":1.4142135623730951},"189":{"tf":1.4142135623730951},"190":{"tf":1.4142135623730951}}},"_":{"?":{")":{"#":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":1,"docs":{"226":{"tf":1.0}}},"df":0,"docs":{}}}}}},")":{"#":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":1,"docs":{"226":{"tf":2.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":17,"docs":{"119":{"tf":1.4142135623730951},"120":{"tf":1.0},"147":{"tf":1.0},"148":{"tf":1.0},"153":{"tf":1.4142135623730951},"163":{"tf":1.0},"164":{"tf":1.0},"169":{"tf":1.4142135623730951},"170":{"tf":1.0},"173":{"tf":1.0},"213":{"tf":4.795831523312719},"220":{"tf":1.4142135623730951},"221":{"tf":1.7320508075688772},"225":{"tf":1.4142135623730951},"226":{"tf":4.0},"45":{"tf":2.0},"58":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"170":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"159":{"tf":1.0}}}}},"df":0,"docs":{}}}},"a":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":2,"docs":{"113":{"tf":1.0},"138":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"167":{"tf":1.4142135623730951},"174":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"/":{"df":0,"docs":{},"w":{"/":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"167":{"tf":1.0},"174":{"tf":1.0}}}}}}},">":{"#":{"<":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"213":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"{":{"df":0,"docs":{},"n":{",":{"df":0,"docs":{},"m":{"df":1,"docs":{"213":{"tf":1.4142135623730951}}}},"df":1,"docs":{"213":{"tf":2.0}}}}},"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"174":{"tf":1.0}},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"174":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"167":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"b":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"229":{"tf":1.0}}}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":2,"docs":{"101":{"tf":1.0},"107":{"tf":2.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"202":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"138":{"tf":1.0},"85":{"tf":1.0}}}},"v":{"df":14,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"122":{"tf":1.0},"161":{"tf":1.0},"178":{"tf":1.0},"186":{"tf":1.0},"203":{"tf":1.4142135623730951},"210":{"tf":1.7320508075688772},"211":{"tf":1.0},"214":{"tf":2.0},"219":{"tf":1.0},"223":{"tf":1.4142135623730951},"5":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"107":{"tf":1.0},"144":{"tf":1.0},"166":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"146":{"tf":1.0}}},"df":0,"docs":{}}}},"c":{"c":{"df":1,"docs":{"148":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"179":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"119":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"186":{"tf":1.7320508075688772},"197":{"tf":1.0},"230":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":18,"docs":{"104":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.4142135623730951},"121":{"tf":1.4142135623730951},"129":{"tf":1.0},"143":{"tf":1.4142135623730951},"144":{"tf":1.0},"145":{"tf":1.0},"151":{"tf":1.0},"155":{"tf":1.0},"159":{"tf":1.0},"161":{"tf":1.0},"163":{"tf":1.0},"169":{"tf":1.0},"172":{"tf":1.0},"223":{"tf":1.0},"227":{"tf":1.4142135623730951}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":5,"docs":{"119":{"tf":1.0},"125":{"tf":1.0},"139":{"tf":1.0},"200":{"tf":1.0},"203":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"118":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"121":{"tf":1.0},"214":{"tf":1.0}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":3,"docs":{"150":{"tf":1.0},"157":{"tf":1.0},"203":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"84":{"tf":1.0},"94":{"tf":1.0}},"s":{"/":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"@":{"df":0,"docs":{},"v":{"4":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"df":4,"docs":{"108":{"tf":1.4142135623730951},"148":{"tf":1.0},"174":{"tf":1.0},"230":{"tf":1.7320508075688772}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":8,"docs":{"117":{"tf":1.0},"138":{"tf":1.0},"161":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.0},"217":{"tf":1.0},"221":{"tf":1.0},"223":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"176":{"tf":1.0},"186":{"tf":1.0},"222":{"tf":1.4142135623730951}}}}},"d":{"df":29,"docs":{"100":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"112":{"tf":1.4142135623730951},"121":{"tf":1.0},"122":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"129":{"tf":1.7320508075688772},"133":{"tf":2.449489742783178},"138":{"tf":1.0},"139":{"tf":1.4142135623730951},"146":{"tf":1.0},"178":{"tf":1.4142135623730951},"182":{"tf":1.0},"183":{"tf":1.0},"2":{"tf":1.0},"203":{"tf":1.4142135623730951},"212":{"tf":1.0},"228":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.0},"7":{"tf":1.0},"86":{"tf":1.0},"95":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":14,"docs":{"0":{"tf":1.0},"188":{"tf":1.0},"194":{"tf":1.0},"203":{"tf":1.0},"214":{"tf":1.0},"221":{"tf":1.4142135623730951},"223":{"tf":1.0},"226":{"tf":1.4142135623730951},"227":{"tf":1.0},"229":{"tf":1.0},"24":{"tf":1.0},"31":{"tf":1.0},"84":{"tf":1.0},"99":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"163":{"tf":1.0},"200":{"tf":1.0},"221":{"tf":1.0},"223":{"tf":1.0},"226":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":8,"docs":{"154":{"tf":1.0},"178":{"tf":1.0},"197":{"tf":1.0},"201":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.0},"208":{"tf":1.0}}}}}}},"df":19,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"109":{"tf":2.0},"115":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":2.0},"128":{"tf":1.4142135623730951},"129":{"tf":2.6457513110645907},"142":{"tf":1.0},"160":{"tf":1.0},"186":{"tf":1.0},"197":{"tf":1.0},"230":{"tf":1.0},"5":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"137":{"tf":1.0}}}}},"t":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"153":{"tf":1.0},"169":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"153":{"tf":1.0}}}}},"df":1,"docs":{"153":{"tf":1.0}}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"223":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"211":{"tf":1.0},"222":{"tf":1.7320508075688772},"223":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"230":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":80,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"117":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"203":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"223":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"102":{"tf":1.0},"121":{"tf":1.0},"135":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"139":{"tf":1.0},"179":{"tf":1.0},"182":{"tf":1.0},"223":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":16,"docs":{"0":{"tf":1.0},"105":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"121":{"tf":1.0},"138":{"tf":1.0},"142":{"tf":1.0},"210":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.0},"214":{"tf":1.0},"217":{"tf":1.0},"220":{"tf":2.0},"221":{"tf":1.4142135623730951},"225":{"tf":1.0},"94":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"7":{"tf":1.0},"79":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"226":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"183":{"tf":1.0},"5":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"124":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"132":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"153":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":1,"docs":{"221":{"tf":1.0}}}}}}}}},"i":{"a":{"df":1,"docs":{"121":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{".":{".":{")":{"]":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"113":{"tf":1.0}}}}}}},"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"116":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"]":{"df":3,"docs":{"85":{"tf":1.0},"86":{"tf":1.0},"89":{"tf":1.0}}},"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":55,"docs":{"0":{"tf":2.0},"113":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"127":{"tf":1.4142135623730951},"13":{"tf":1.0},"138":{"tf":1.0},"14":{"tf":1.4142135623730951},"146":{"tf":1.0},"15":{"tf":1.4142135623730951},"151":{"tf":1.0},"16":{"tf":1.4142135623730951},"161":{"tf":1.4142135623730951},"169":{"tf":1.0},"17":{"tf":1.4142135623730951},"179":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"195":{"tf":1.0},"20":{"tf":1.4142135623730951},"209":{"tf":1.0},"21":{"tf":1.4142135623730951},"211":{"tf":1.0},"214":{"tf":1.4142135623730951},"219":{"tf":1.0},"22":{"tf":1.4142135623730951},"221":{"tf":1.0},"222":{"tf":1.0},"223":{"tf":1.0},"226":{"tf":2.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"26":{"tf":1.7320508075688772},"27":{"tf":2.23606797749979},"28":{"tf":1.4142135623730951},"29":{"tf":2.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"5":{"tf":1.7320508075688772},"58":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":2.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.0}},"e":{"d":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"214":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"200":{"tf":1.0},"8":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":18,"docs":{"1":{"tf":1.0},"102":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"127":{"tf":1.0},"130":{"tf":1.0},"144":{"tf":1.0},"166":{"tf":1.0},"174":{"tf":1.4142135623730951},"186":{"tf":1.7320508075688772},"192":{"tf":1.0},"195":{"tf":1.0},"197":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.7320508075688772},"29":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"218":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"<":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"218":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"218":{"tf":1.0}}}},"df":1,"docs":{"218":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":11,"docs":{"0":{"tf":1.0},"133":{"tf":1.0},"144":{"tf":1.0},"203":{"tf":1.0},"213":{"tf":1.4142135623730951},"214":{"tf":1.4142135623730951},"218":{"tf":1.0},"222":{"tf":1.0},"223":{"tf":2.0},"224":{"tf":1.0},"226":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"229":{"tf":1.0},"230":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":8,"docs":{"107":{"tf":1.0},"147":{"tf":1.4142135623730951},"148":{"tf":1.0},"185":{"tf":1.0},"229":{"tf":1.4142135623730951},"230":{"tf":1.4142135623730951},"46":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":1,"docs":{"202":{"tf":1.0}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"179":{"tf":1.0},"200":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":2,"docs":{"0":{"tf":1.0},"202":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":9,"docs":{"117":{"tf":1.0},"145":{"tf":1.0},"210":{"tf":1.0},"213":{"tf":1.0},"214":{"tf":1.4142135623730951},"219":{"tf":1.0},"222":{"tf":1.4142135623730951},"223":{"tf":1.0},"226":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":3,"docs":{"30":{"tf":1.0},"31":{"tf":2.0},"32":{"tf":1.0}}}}}}}}}},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"169":{"tf":1.0},"230":{"tf":1.0}}}}}},"y":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"df":1,"docs":{"148":{"tf":1.0}}}}},"<":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"219":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":6,"docs":{"10":{"tf":1.0},"164":{"tf":1.0},"192":{"tf":1.0},"213":{"tf":1.4142135623730951},"218":{"tf":1.0},"60":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"126":{"tf":1.0}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"100":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":4,"docs":{"166":{"tf":1.0},"176":{"tf":1.4142135623730951},"34":{"tf":1.0},"7":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"119":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"21":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"c":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"147":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"y":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"147":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":4,"docs":{"130":{"tf":1.0},"147":{"tf":1.4142135623730951},"148":{"tf":1.0},"221":{"tf":1.0}}},"df":10,"docs":{"114":{"tf":1.0},"141":{"tf":1.0},"174":{"tf":1.0},"177":{"tf":1.0},"182":{"tf":1.4142135623730951},"211":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"229":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"a":{"c":{"df":0,"docs":{},"h":{"df":8,"docs":{"127":{"tf":1.0},"137":{"tf":1.0},"157":{"tf":1.0},"160":{"tf":1.0},"211":{"tf":1.4142135623730951},"221":{"tf":1.4142135623730951},"222":{"tf":1.0},"223":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"119":{"tf":1.0}}}}},"v":{"df":1,"docs":{"181":{"tf":1.0}}},"x":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":3,"docs":{"203":{"tf":1.0},"211":{"tf":1.0},"226":{"tf":1.0}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"221":{"tf":1.0}}}},"df":0,"docs":{}}},"g":{"df":1,"docs":{"16":{"tf":1.4142135623730951}},"u":{"df":1,"docs":{"133":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":8,"docs":{"148":{"tf":1.0},"163":{"tf":1.0},"170":{"tf":1.0},"171":{"tf":1.4142135623730951},"212":{"tf":1.0},"213":{"tf":1.7320508075688772},"6":{"tf":1.0},"73":{"tf":1.4142135623730951}}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951}},"i":{"c":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0}},"s":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"d":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"197":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"218":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":6,"docs":{"213":{"tf":3.0},"214":{"tf":2.0},"219":{"tf":1.4142135623730951},"225":{"tf":1.7320508075688772},"226":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"t":{"df":2,"docs":{"205":{"tf":1.0},"224":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"k":{"df":7,"docs":{"107":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"179":{"tf":1.0},"186":{"tf":1.0},"229":{"tf":1.4142135623730951},"230":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"131":{"tf":1.0},"226":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"(":{"c":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"174":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"x":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{".":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"174":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"!":{"(":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{".":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"167":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"214":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"(":{"_":{"#":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"226":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"226":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":8,"docs":{"144":{"tf":1.0},"145":{"tf":1.0},"199":{"tf":1.4142135623730951},"201":{"tf":1.0},"214":{"tf":1.4142135623730951},"223":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":3,"docs":{"113":{"tf":1.0},"140":{"tf":1.0},"167":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":13,"docs":{"155":{"tf":1.0},"167":{"tf":2.23606797749979},"174":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.0},"182":{"tf":1.4142135623730951},"183":{"tf":1.0},"188":{"tf":1.4142135623730951},"189":{"tf":1.4142135623730951},"190":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.0},"4":{"tf":1.0}}}}},"t":{"'":{"df":1,"docs":{"223":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"221":{"tf":1.4142135623730951},"223":{"tf":1.0}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"(":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"210":{"tf":1.4142135623730951}}}}}},"df":1,"docs":{"210":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"221":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"210":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"223":{"tf":1.4142135623730951}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"_":{"df":1,"docs":{"210":{"tf":1.0}}},"df":0,"docs":{},"j":{"df":1,"docs":{"220":{"tf":1.0}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"j":{"df":1,"docs":{"220":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"j":{"df":1,"docs":{"220":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"220":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"223":{"tf":1.4142135623730951}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"210":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"210":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":14,"docs":{"107":{"tf":1.0},"118":{"tf":1.0},"144":{"tf":2.449489742783178},"145":{"tf":1.4142135623730951},"166":{"tf":1.0},"210":{"tf":2.0},"213":{"tf":1.0},"217":{"tf":1.4142135623730951},"218":{"tf":1.0},"220":{"tf":1.4142135623730951},"222":{"tf":1.0},"223":{"tf":1.4142135623730951},"226":{"tf":1.7320508075688772},"99":{"tf":1.7320508075688772}}},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"203":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"123":{"tf":1.4142135623730951},"148":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"104":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"203":{"tf":1.0}}}}},"n":{"df":1,"docs":{"213":{"tf":1.0}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":11,"docs":{"11":{"tf":1.4142135623730951},"116":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.7320508075688772},"131":{"tf":1.0},"186":{"tf":1.4142135623730951},"214":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"90":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"105":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":8,"docs":{"109":{"tf":1.0},"122":{"tf":1.4142135623730951},"166":{"tf":1.4142135623730951},"167":{"tf":1.0},"186":{"tf":1.0},"223":{"tf":1.0},"226":{"tf":1.4142135623730951},"229":{"tf":1.0}}}}},"o":{"df":1,"docs":{"116":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"t":{"df":13,"docs":{"1":{"tf":1.0},"104":{"tf":1.0},"114":{"tf":1.0},"117":{"tf":1.0},"119":{"tf":1.0},"129":{"tf":1.0},"135":{"tf":1.0},"141":{"tf":1.0},"147":{"tf":1.0},"148":{"tf":1.0},"196":{"tf":1.4142135623730951},"27":{"tf":1.0},"5":{"tf":1.4142135623730951}}}},"df":2,"docs":{"117":{"tf":1.4142135623730951},"118":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":13,"docs":{"104":{"tf":1.0},"117":{"tf":1.0},"121":{"tf":1.0},"150":{"tf":1.0},"160":{"tf":1.0},"164":{"tf":1.0},"167":{"tf":1.0},"176":{"tf":1.0},"179":{"tf":1.0},"191":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.0},"227":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":13,"docs":{"119":{"tf":1.0},"124":{"tf":1.0},"146":{"tf":1.0},"160":{"tf":1.0},"161":{"tf":1.0},"166":{"tf":1.4142135623730951},"167":{"tf":1.0},"171":{"tf":1.0},"174":{"tf":1.0},"176":{"tf":1.0},"34":{"tf":1.0},"48":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"35":{"tf":1.4142135623730951}}}},"y":{"df":2,"docs":{"130":{"tf":1.0},"193":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"167":{"tf":1.0},"174":{"tf":1.0}}}}}}},"a":{"c":{"df":0,"docs":{},"k":{"df":6,"docs":{"176":{"tf":1.0},"183":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.0}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"188":{"tf":1.4142135623730951}}}}}}}}},"df":6,"docs":{"181":{"tf":2.449489742783178},"182":{"tf":2.8284271247461903},"183":{"tf":1.7320508075688772},"186":{"tf":1.0},"188":{"tf":1.0},"192":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"226":{"tf":1.4142135623730951}}}}}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"177":{"tf":1.4142135623730951}}}}}},"d":{"df":4,"docs":{"116":{"tf":1.0},"124":{"tf":2.0},"134":{"tf":1.4142135623730951},"5":{"tf":1.0}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"137":{"tf":1.0},"228":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"r":{"df":5,"docs":{"147":{"tf":1.0},"213":{"tf":1.0},"214":{"tf":1.4142135623730951},"41":{"tf":1.0},"7":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"e":{"df":4,"docs":{"171":{"tf":1.0},"215":{"tf":1.0},"64":{"tf":1.0},"91":{"tf":1.0}}},"h":{"df":1,"docs":{"177":{"tf":1.4142135623730951}}},"i":{"c":{"df":11,"docs":{"100":{"tf":1.0},"101":{"tf":1.7320508075688772},"110":{"tf":1.0},"128":{"tf":1.0},"155":{"tf":1.0},"161":{"tf":1.0},"181":{"tf":1.0},"204":{"tf":1.0},"3":{"tf":1.0},"7":{"tf":1.0},"98":{"tf":1.4142135623730951}}},"df":3,"docs":{"0":{"tf":1.0},"176":{"tf":1.0},"87":{"tf":1.0}}}},"z":{"df":3,"docs":{"213":{"tf":1.0},"41":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"df":10,"docs":{"113":{"tf":1.0},"138":{"tf":1.0},"167":{"tf":2.449489742783178},"174":{"tf":2.23606797749979},"180":{"tf":1.0},"182":{"tf":1.0},"183":{"tf":1.0},"188":{"tf":1.0},"213":{"tf":2.23606797749979},"226":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":6,"docs":{"115":{"tf":1.0},"142":{"tf":1.0},"166":{"tf":1.0},"202":{"tf":1.0},"210":{"tf":1.0},"223":{"tf":1.0}}}}},"df":6,"docs":{"10":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"164":{"tf":1.0},"167":{"tf":1.0},"221":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":23,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"104":{"tf":1.0},"118":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"128":{"tf":1.0},"136":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":1.0},"166":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.0},"181":{"tf":1.0},"183":{"tf":1.0},"185":{"tf":1.0},"195":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.4142135623730951},"50":{"tf":1.0},"81":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"179":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"138":{"tf":1.0},"146":{"tf":1.0}},"n":{"df":1,"docs":{"99":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"146":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":9,"docs":{"107":{"tf":1.0},"112":{"tf":1.0},"129":{"tf":1.0},"131":{"tf":1.0},"133":{"tf":1.4142135623730951},"139":{"tf":1.0},"166":{"tf":1.0},"30":{"tf":1.0},"64":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"133":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"133":{"tf":1.4142135623730951},"163":{"tf":1.4142135623730951},"172":{"tf":1.0}}}},"v":{"df":1,"docs":{"164":{"tf":1.0}}},"w":{"df":17,"docs":{"104":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"143":{"tf":1.0},"156":{"tf":1.0},"160":{"tf":1.0},"210":{"tf":1.0},"212":{"tf":1.0},"218":{"tf":1.0},"220":{"tf":1.0},"226":{"tf":1.0},"26":{"tf":1.4142135623730951},"5":{"tf":1.0},"60":{"tf":1.0},"7":{"tf":1.0},"77":{"tf":1.0},"95":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"226":{"tf":1.0}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":8,"docs":{"101":{"tf":1.0},"131":{"tf":1.0},"151":{"tf":1.0},"157":{"tf":1.0},"159":{"tf":1.0},"166":{"tf":1.0},"197":{"tf":1.0},"203":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":6,"docs":{"112":{"tf":1.0},"133":{"tf":1.0},"146":{"tf":1.0},"160":{"tf":1.0},"202":{"tf":1.0},"230":{"tf":1.0}}}},"t":{"a":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"186":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"=":{"$":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"189":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"189":{"tf":1.0}}},"df":0,"docs":{}}}},"df":12,"docs":{"176":{"tf":1.0},"181":{"tf":1.4142135623730951},"182":{"tf":2.23606797749979},"183":{"tf":2.23606797749979},"186":{"tf":2.6457513110645907},"187":{"tf":1.4142135623730951},"188":{"tf":1.7320508075688772},"189":{"tf":2.23606797749979},"192":{"tf":1.0},"193":{"tf":1.7320508075688772},"202":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"119":{"tf":1.0},"145":{"tf":1.0},"197":{"tf":1.0},"202":{"tf":1.0},"204":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":8,"docs":{"148":{"tf":1.0},"175":{"tf":1.4142135623730951},"176":{"tf":1.0},"186":{"tf":1.0},"203":{"tf":1.4142135623730951},"217":{"tf":1.0},"220":{"tf":1.0},"226":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"214":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"b":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":2,"docs":{"176":{"tf":1.0},"203":{"tf":1.0}},"g":{"df":4,"docs":{"103":{"tf":1.0},"177":{"tf":1.0},"203":{"tf":1.0},"208":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"100":{"tf":1.0},"197":{"tf":1.0},"200":{"tf":1.0},"203":{"tf":1.0},"206":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"108":{"tf":1.0},"115":{"tf":1.0},"223":{"tf":1.4142135623730951},"31":{"tf":1.7320508075688772},"4":{"tf":1.0}}},"y":{"(":{"_":{"df":1,"docs":{"226":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"d":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"df":1,"docs":{"108":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"223":{"tf":2.0}}},"df":0,"docs":{}}}}}}},"t":{"df":4,"docs":{"111":{"tf":1.0},"120":{"tf":1.0},"167":{"tf":1.0},"81":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":9,"docs":{"103":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"120":{"tf":1.0},"129":{"tf":1.0},"138":{"tf":1.7320508075688772},"139":{"tf":1.0},"141":{"tf":1.0},"203":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"k":{"(":{"_":{")":{"#":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"226":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"213":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"218":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"_":{"(":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"218":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"226":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"226":{"tf":1.7320508075688772}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"221":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":13,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"155":{"tf":1.0},"161":{"tf":1.0},"164":{"tf":1.7320508075688772},"210":{"tf":1.0},"213":{"tf":2.6457513110645907},"221":{"tf":1.4142135623730951},"226":{"tf":2.8284271247461903},"49":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"83":{"tf":1.0}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"218":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"154":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"118":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"111":{"tf":1.0},"131":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"196":{"tf":1.0}}},"df":8,"docs":{"100":{"tf":1.4142135623730951},"121":{"tf":1.0},"129":{"tf":1.0},"164":{"tf":1.0},"194":{"tf":1.7320508075688772},"195":{"tf":1.4142135623730951},"196":{"tf":1.7320508075688772},"203":{"tf":1.4142135623730951}}},"l":{"(":{"_":{"#":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"214":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"213":{"tf":1.4142135623730951}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"218":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":6,"docs":{"120":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"220":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"n":{"df":5,"docs":{"210":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":2.0},"214":{"tf":1.7320508075688772},"226":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"r":{"df":1,"docs":{"100":{"tf":1.0}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"<":{"[":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"161":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":1,"docs":{"161":{"tf":1.0}}}},"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"161":{"tf":1.4142135623730951}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"h":{"df":11,"docs":{"112":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"167":{"tf":1.0},"203":{"tf":1.0},"210":{"tf":1.0},"222":{"tf":1.0},"223":{"tf":1.0},"226":{"tf":1.0},"230":{"tf":1.0},"7":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"53":{"tf":1.0},"59":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"x":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"117":{"tf":1.0},"135":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"218":{"tf":2.0}}}}}},"t":{"df":1,"docs":{"77":{"tf":1.0}}}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":4,"docs":{"129":{"tf":1.4142135623730951},"48":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.7320508075688772}},"e":{"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"72":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"69":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":14,"docs":{"102":{"tf":1.7320508075688772},"133":{"tf":1.4142135623730951},"179":{"tf":1.4142135623730951},"181":{"tf":1.0},"182":{"tf":1.7320508075688772},"183":{"tf":1.7320508075688772},"186":{"tf":1.4142135623730951},"187":{"tf":1.4142135623730951},"188":{"tf":2.449489742783178},"189":{"tf":1.7320508075688772},"192":{"tf":1.7320508075688772},"210":{"tf":1.0},"213":{"tf":1.0},"214":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":6,"docs":{"210":{"tf":1.0},"222":{"tf":1.0},"228":{"tf":1.0},"230":{"tf":1.4142135623730951},"34":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"165":{"tf":1.0},"200":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"181":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"s":{"df":1,"docs":{"145":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"116":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"177":{"tf":1.0},"93":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"100":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"203":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"l":{"d":{"df":10,"docs":{"101":{"tf":1.4142135623730951},"103":{"tf":2.0},"105":{"tf":1.0},"108":{"tf":1.4142135623730951},"155":{"tf":1.0},"161":{"tf":1.0},"195":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.4142135623730951},"96":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":2,"docs":{"176":{"tf":1.0},"177":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"186":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"179":{"tf":1.4142135623730951}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"138":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"229":{"tf":1.4142135623730951}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":8,"docs":{"50":{"tf":1.0},"56":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0}},"s":{":":{":":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"177":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"176":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"227":{"tf":1.4142135623730951},"230":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"df":25,"docs":{"104":{"tf":1.0},"109":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"133":{"tf":1.4142135623730951},"135":{"tf":1.0},"138":{"tf":2.6457513110645907},"148":{"tf":1.0},"153":{"tf":1.0},"159":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":2.0},"164":{"tf":1.0},"167":{"tf":1.4142135623730951},"168":{"tf":1.0},"170":{"tf":1.7320508075688772},"172":{"tf":1.4142135623730951},"173":{"tf":1.0},"174":{"tf":1.4142135623730951},"177":{"tf":1.0},"212":{"tf":1.4142135623730951},"217":{"tf":1.0},"219":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"119":{"tf":1.0},"145":{"tf":1.0},"148":{"tf":1.0},"174":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":1,"docs":{"146":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"119":{"tf":1.0},"146":{"tf":1.0}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"214":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"185":{"tf":1.0},"7":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"85":{"tf":1.0}}}}}}}},"g":{"df":0,"docs":{},"o":{"#":{"5":{"0":{"3":{"4":{"df":1,"docs":{"202":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":5,"docs":{"113":{"tf":1.0},"140":{"tf":1.0},"62":{"tf":1.0},"7":{"tf":1.7320508075688772},"92":{"tf":1.4142135623730951}}}}}}},"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"108":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"108":{"tf":1.0}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"108":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"113":{"tf":1.0},"140":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"113":{"tf":1.0},"140":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"129":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":41,"docs":{"0":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":2.449489742783178},"104":{"tf":3.0},"105":{"tf":1.0},"108":{"tf":2.23606797749979},"109":{"tf":1.0},"112":{"tf":2.0},"113":{"tf":2.6457513110645907},"114":{"tf":1.0},"115":{"tf":2.0},"116":{"tf":1.0},"117":{"tf":1.7320508075688772},"120":{"tf":2.449489742783178},"125":{"tf":1.0},"128":{"tf":1.7320508075688772},"129":{"tf":1.0},"131":{"tf":1.0},"133":{"tf":2.0},"134":{"tf":1.0},"135":{"tf":1.4142135623730951},"138":{"tf":2.6457513110645907},"139":{"tf":1.0},"140":{"tf":2.6457513110645907},"141":{"tf":1.0},"142":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"195":{"tf":1.4142135623730951},"202":{"tf":2.449489742783178},"203":{"tf":2.23606797749979},"36":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":3.0},"6":{"tf":1.4142135623730951},"7":{"tf":2.23606797749979},"92":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"95":{"tf":1.0},"96":{"tf":2.0}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"229":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":33,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.0},"103":{"tf":1.4142135623730951},"111":{"tf":1.0},"113":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.7320508075688772},"127":{"tf":1.4142135623730951},"130":{"tf":1.0},"133":{"tf":1.0},"135":{"tf":1.0},"136":{"tf":1.0},"137":{"tf":1.4142135623730951},"138":{"tf":1.0},"140":{"tf":1.4142135623730951},"145":{"tf":1.0},"163":{"tf":1.0},"202":{"tf":1.4142135623730951},"203":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.0},"215":{"tf":1.0},"223":{"tf":1.0},"226":{"tf":1.4142135623730951},"7":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"97":{"tf":1.0}}},"t":{"_":{"a":{"b":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"131":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"0":{"tf":1.0},"168":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":8,"docs":{"0":{"tf":2.23606797749979},"100":{"tf":1.4142135623730951},"112":{"tf":1.0},"127":{"tf":2.23606797749979},"131":{"tf":1.4142135623730951},"133":{"tf":1.4142135623730951},"84":{"tf":2.0},"85":{"tf":1.0}}},"y":{"=":{"<":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"_":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"144":{"tf":1.0},"145":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":2,"docs":{"113":{"tf":1.0},"140":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"112":{"tf":1.4142135623730951},"133":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"u":{"df":0,"docs":{},"s":{"df":9,"docs":{"113":{"tf":1.0},"140":{"tf":1.0},"154":{"tf":1.0},"174":{"tf":1.0},"221":{"tf":1.0},"34":{"tf":1.0},"5":{"tf":1.4142135623730951},"7":{"tf":1.0},"71":{"tf":1.0}}}}},"d":{"df":1,"docs":{"108":{"tf":1.0}}},"df":1,"docs":{"213":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":12,"docs":{"0":{"tf":1.0},"121":{"tf":1.0},"141":{"tf":1.0},"145":{"tf":1.0},"157":{"tf":1.0},"210":{"tf":1.0},"211":{"tf":1.0},"220":{"tf":1.0},"31":{"tf":1.0},"7":{"tf":1.7320508075688772},"82":{"tf":1.0},"91":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"165":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":6,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0}}}}}}},"df":1,"docs":{"7":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"130":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"200":{"tf":1.4142135623730951}}}}}}},"n":{"df":0,"docs":{},"g":{"df":32,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"113":{"tf":1.0},"129":{"tf":1.0},"133":{"tf":2.0},"138":{"tf":1.0},"147":{"tf":2.0},"148":{"tf":1.0},"166":{"tf":1.4142135623730951},"167":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":2.23606797749979},"177":{"tf":1.0},"179":{"tf":1.7320508075688772},"181":{"tf":1.4142135623730951},"182":{"tf":1.4142135623730951},"185":{"tf":1.0},"186":{"tf":1.0},"188":{"tf":1.0},"192":{"tf":1.0},"194":{"tf":1.4142135623730951},"195":{"tf":1.0},"196":{"tf":2.0},"197":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.0},"210":{"tf":1.0},"222":{"tf":1.4142135623730951},"223":{"tf":1.0},"226":{"tf":1.0},"34":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"m":{"d":{"df":4,"docs":{"133":{"tf":1.4142135623730951},"186":{"tf":1.0},"187":{"tf":1.0},"193":{"tf":1.0}}},"df":0,"docs":{}}},"df":6,"docs":{"175":{"tf":1.4142135623730951},"184":{"tf":1.4142135623730951},"185":{"tf":1.7320508075688772},"186":{"tf":3.0},"193":{"tf":1.4142135623730951},"230":{"tf":1.0}}}}},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"186":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"o":{"df":1,"docs":{"165":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"137":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":19,"docs":{"1":{"tf":1.4142135623730951},"100":{"tf":1.0},"133":{"tf":1.0},"135":{"tf":1.0},"141":{"tf":1.0},"144":{"tf":1.0},"146":{"tf":1.4142135623730951},"149":{"tf":1.0},"156":{"tf":1.0},"164":{"tf":1.0},"175":{"tf":1.4142135623730951},"197":{"tf":1.0},"227":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.7320508075688772},"84":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":2.0}}}}}},"r":{"(":{"'":{"df":0,"docs":{},"x":{"df":1,"docs":{"213":{"tf":1.0}}}},"_":{"df":2,"docs":{"213":{"tf":1.0},"226":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"218":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"152":{"tf":1.4142135623730951},"211":{"tf":1.7320508075688772},"213":{"tf":2.0},"214":{"tf":1.4142135623730951},"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":7,"docs":{"152":{"tf":1.7320508075688772},"213":{"tf":1.4142135623730951},"214":{"tf":1.0},"26":{"tf":1.0},"60":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"79":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"130":{"tf":1.0}}}},"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":15,"docs":{"121":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"163":{"tf":1.0},"169":{"tf":1.0},"170":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"212":{"tf":1.0},"221":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"214":{"tf":1.0}}}}}}},"df":1,"docs":{"146":{"tf":1.0}}}}}},"f":{"df":0,"docs":{},"n":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"119":{"tf":1.4142135623730951},"120":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":3,"docs":{"119":{"tf":1.0},"120":{"tf":1.7320508075688772},"146":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"164":{"tf":1.0},"173":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"164":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"221":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"146":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"159":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":56,"docs":{"102":{"tf":1.0},"113":{"tf":2.0},"116":{"tf":1.0},"118":{"tf":1.7320508075688772},"119":{"tf":1.0},"120":{"tf":1.0},"124":{"tf":1.0},"132":{"tf":1.4142135623730951},"138":{"tf":1.7320508075688772},"144":{"tf":1.4142135623730951},"145":{"tf":1.4142135623730951},"146":{"tf":1.0},"147":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":2.0},"153":{"tf":1.0},"155":{"tf":1.4142135623730951},"156":{"tf":1.0},"157":{"tf":1.4142135623730951},"159":{"tf":1.0},"160":{"tf":1.0},"161":{"tf":1.4142135623730951},"162":{"tf":1.4142135623730951},"163":{"tf":2.449489742783178},"164":{"tf":2.8284271247461903},"166":{"tf":1.4142135623730951},"167":{"tf":1.0},"168":{"tf":2.23606797749979},"169":{"tf":1.0},"170":{"tf":2.449489742783178},"171":{"tf":2.449489742783178},"172":{"tf":1.0},"173":{"tf":2.449489742783178},"174":{"tf":2.0},"179":{"tf":1.0},"180":{"tf":1.0},"186":{"tf":2.0},"192":{"tf":1.4142135623730951},"202":{"tf":2.0},"21":{"tf":1.0},"210":{"tf":1.0},"214":{"tf":1.7320508075688772},"221":{"tf":2.23606797749979},"226":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"37":{"tf":1.0},"5":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0}},"e":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"158":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"128":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":11,"docs":{"102":{"tf":1.0},"179":{"tf":1.4142135623730951},"180":{"tf":1.0},"182":{"tf":1.7320508075688772},"183":{"tf":1.4142135623730951},"186":{"tf":1.0},"188":{"tf":1.0},"189":{"tf":1.4142135623730951},"190":{"tf":1.0},"191":{"tf":1.0},"229":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"160":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"127":{"tf":1.0},"182":{"tf":1.0},"5":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"223":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"177":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"c":{"df":5,"docs":{"124":{"tf":1.0},"144":{"tf":1.4142135623730951},"145":{"tf":1.0},"186":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":3,"docs":{"0":{"tf":1.0},"119":{"tf":1.0},"148":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"111":{"tf":1.0}},"n":{"df":2,"docs":{"133":{"tf":1.0},"146":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"177":{"tf":1.0}}}}}},"i":{".":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"/":{"c":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"0":{"tf":1.0},"125":{"tf":1.0},"175":{"tf":1.0},"5":{"tf":1.0},"93":{"tf":2.23606797749979},"94":{"tf":1.0},"95":{"tf":2.0},"96":{"tf":1.4142135623730951}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"228":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"99":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"127":{"tf":1.0}},"i":{"df":2,"docs":{"202":{"tf":1.0},"203":{"tf":1.4142135623730951}}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"213":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"186":{"tf":1.0}}}}},"r":{"df":2,"docs":{"200":{"tf":1.0},"203":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"109":{"tf":1.0},"203":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":103,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.4142135623730951},"100":{"tf":2.0},"101":{"tf":2.0},"102":{"tf":2.449489742783178},"103":{"tf":1.7320508075688772},"104":{"tf":2.0},"105":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":4.123105625617661},"109":{"tf":1.4142135623730951},"111":{"tf":1.0},"113":{"tf":1.7320508075688772},"115":{"tf":2.449489742783178},"116":{"tf":1.0},"118":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.7320508075688772},"123":{"tf":1.4142135623730951},"125":{"tf":1.0},"129":{"tf":1.4142135623730951},"130":{"tf":1.4142135623730951},"131":{"tf":1.7320508075688772},"132":{"tf":1.0},"133":{"tf":1.7320508075688772},"134":{"tf":1.4142135623730951},"135":{"tf":1.0},"136":{"tf":1.0},"137":{"tf":1.4142135623730951},"138":{"tf":2.8284271247461903},"142":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.7320508075688772},"149":{"tf":1.0},"153":{"tf":1.0},"159":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.4142135623730951},"166":{"tf":1.0},"167":{"tf":1.4142135623730951},"172":{"tf":1.0},"174":{"tf":1.4142135623730951},"175":{"tf":2.6457513110645907},"176":{"tf":2.0},"177":{"tf":1.0},"178":{"tf":2.449489742783178},"179":{"tf":3.0},"180":{"tf":2.23606797749979},"181":{"tf":2.449489742783178},"182":{"tf":2.6457513110645907},"183":{"tf":2.0},"185":{"tf":1.0},"186":{"tf":2.23606797749979},"187":{"tf":2.23606797749979},"188":{"tf":2.0},"189":{"tf":2.0},"190":{"tf":1.4142135623730951},"191":{"tf":2.0},"192":{"tf":1.7320508075688772},"194":{"tf":2.0},"196":{"tf":1.0},"197":{"tf":1.7320508075688772},"199":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"200":{"tf":1.0},"202":{"tf":2.6457513110645907},"203":{"tf":3.605551275463989},"204":{"tf":1.0},"208":{"tf":1.0},"21":{"tf":1.0},"210":{"tf":1.0},"215":{"tf":1.0},"220":{"tf":1.0},"222":{"tf":1.0},"223":{"tf":1.0},"224":{"tf":1.0},"226":{"tf":1.4142135623730951},"227":{"tf":1.4142135623730951},"229":{"tf":2.449489742783178},"230":{"tf":3.0},"26":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.4142135623730951},"4":{"tf":2.0},"41":{"tf":1.0},"43":{"tf":2.23606797749979},"5":{"tf":4.358898943540674},"58":{"tf":1.0},"6":{"tf":2.8284271247461903},"7":{"tf":3.872983346207417},"84":{"tf":2.0},"85":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.7320508075688772},"91":{"tf":1.0},"93":{"tf":3.0},"94":{"tf":2.449489742783178},"95":{"tf":2.0},"96":{"tf":2.23606797749979},"97":{"tf":1.7320508075688772},"98":{"tf":1.0}}},"y":{"'":{"df":11,"docs":{"103":{"tf":1.4142135623730951},"130":{"tf":1.0},"131":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.0},"172":{"tf":1.4142135623730951},"210":{"tf":1.0},"221":{"tf":1.4142135623730951},"226":{"tf":1.0},"5":{"tf":1.4142135623730951},"84":{"tf":1.0}}},".":{"df":1,"docs":{"227":{"tf":1.0}},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"182":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":4,"docs":{"121":{"tf":1.0},"129":{"tf":1.4142135623730951},"139":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951}}}}}}},":":{":":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"0":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"122":{"tf":1.0}}}}}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":2,"docs":{"0":{"tf":1.0},"92":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":2,"docs":{"0":{"tf":1.0},"87":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"85":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"123":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"138":{"tf":1.0}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"148":{"tf":1.0}}}}}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"50":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":2,"docs":{"121":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}}},"p":{"df":0,"docs":{},"e":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"0":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":2.0},"90":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":2,"docs":{"0":{"tf":1.0},"88":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"5":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":3,"docs":{"0":{"tf":1.0},"5":{"tf":1.0},"89":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":4,"docs":{"116":{"tf":1.4142135623730951},"124":{"tf":1.0},"134":{"tf":1.0},"186":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"183":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"94":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"129":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"121":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"129":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"121":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"116":{"tf":1.0},"129":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"121":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"r":{"c":{"/":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"133":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":3,"docs":{"112":{"tf":1.0},"116":{"tf":1.4142135623730951},"133":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"133":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"133":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":3,"docs":{"117":{"tf":1.0},"133":{"tf":1.0},"135":{"tf":1.0}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"133":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"e":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"133":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"{":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"}":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"112":{"tf":1.0},"133":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"112":{"tf":1.0},"133":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":3,"docs":{"112":{"tf":1.0},"131":{"tf":1.0},"133":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"119":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"159":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":3,"docs":{"158":{"tf":1.0},"163":{"tf":1.0},"172":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"160":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"164":{"tf":1.0},"173":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"147":{"tf":1.0}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"163":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"161":{"tf":1.0},"172":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"164":{"tf":1.0},"173":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"{":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"171":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"{":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"160":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"171":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"n":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":5,"docs":{"102":{"tf":1.7320508075688772},"129":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"179":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"144":{"tf":1.0},"145":{"tf":1.0},"229":{"tf":2.0}},"r":{"df":2,"docs":{"152":{"tf":1.0},"163":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"120":{"tf":1.0}}}}}}},"o":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"214":{"tf":1.0},"221":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"s":{"df":7,"docs":{"101":{"tf":1.0},"104":{"tf":1.0},"125":{"tf":1.0},"131":{"tf":1.0},"133":{"tf":1.0},"221":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{}},"df":59,"docs":{"0":{"tf":3.0},"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"104":{"tf":1.4142135623730951},"111":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.7320508075688772},"119":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":2.0},"124":{"tf":1.7320508075688772},"125":{"tf":1.4142135623730951},"126":{"tf":1.0},"127":{"tf":1.0},"129":{"tf":1.0},"131":{"tf":1.0},"134":{"tf":1.4142135623730951},"137":{"tf":1.0},"138":{"tf":1.4142135623730951},"139":{"tf":1.0},"141":{"tf":1.7320508075688772},"144":{"tf":1.4142135623730951},"145":{"tf":1.4142135623730951},"146":{"tf":1.0},"147":{"tf":1.7320508075688772},"148":{"tf":1.7320508075688772},"152":{"tf":1.0},"155":{"tf":1.0},"158":{"tf":1.0},"161":{"tf":1.4142135623730951},"165":{"tf":1.7320508075688772},"166":{"tf":1.7320508075688772},"167":{"tf":2.6457513110645907},"174":{"tf":2.449489742783178},"186":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.0},"210":{"tf":2.449489742783178},"211":{"tf":1.4142135623730951},"215":{"tf":1.0},"218":{"tf":1.0},"221":{"tf":1.7320508075688772},"222":{"tf":1.4142135623730951},"223":{"tf":1.4142135623730951},"226":{"tf":1.4142135623730951},"5":{"tf":3.0},"7":{"tf":3.0},"71":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":2.23606797749979},"87":{"tf":2.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.7320508075688772},"90":{"tf":1.4142135623730951},"91":{"tf":1.7320508075688772},"98":{"tf":1.4142135623730951}},"r":{"df":1,"docs":{"174":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"186":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"227":{"tf":1.0}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":1,"docs":{"226":{"tf":1.0}},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":2,"docs":{"210":{"tf":1.7320508075688772},"215":{"tf":1.4142135623730951}}}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"167":{"tf":1.0},"197":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":1,"docs":{"166":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":10,"docs":{"0":{"tf":1.0},"107":{"tf":1.0},"144":{"tf":1.0},"147":{"tf":1.0},"185":{"tf":1.0},"202":{"tf":1.0},"206":{"tf":1.0},"211":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.0}}},"m":{"a":{"df":2,"docs":{"113":{"tf":1.0},"138":{"tf":1.0}},"n":{"d":{"df":23,"docs":{"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.7320508075688772},"108":{"tf":1.0},"112":{"tf":2.6457513110645907},"122":{"tf":1.0},"133":{"tf":2.6457513110645907},"135":{"tf":1.4142135623730951},"138":{"tf":2.0},"144":{"tf":1.0},"145":{"tf":1.0},"177":{"tf":1.0},"178":{"tf":1.4142135623730951},"179":{"tf":1.4142135623730951},"180":{"tf":1.0},"182":{"tf":1.0},"186":{"tf":1.0},"188":{"tf":1.0},"196":{"tf":1.0},"202":{"tf":1.0},"5":{"tf":2.0},"7":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":11,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"124":{"tf":1.0},"129":{"tf":1.4142135623730951},"141":{"tf":1.0},"203":{"tf":1.4142135623730951},"214":{"tf":1.0},"221":{"tf":1.0},"229":{"tf":1.4142135623730951},"230":{"tf":1.0},"91":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"(":{"df":1,"docs":{"182":{"tf":1.0}}},"1":{"df":1,"docs":{"186":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"186":{"tf":1.0}}},"df":17,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"106":{"tf":1.0},"113":{"tf":1.7320508075688772},"128":{"tf":1.0},"133":{"tf":2.449489742783178},"138":{"tf":1.7320508075688772},"179":{"tf":2.23606797749979},"182":{"tf":1.4142135623730951},"186":{"tf":3.0},"187":{"tf":1.4142135623730951},"188":{"tf":1.4142135623730951},"189":{"tf":2.0},"190":{"tf":2.23606797749979},"191":{"tf":1.4142135623730951},"192":{"tf":1.4142135623730951},"195":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":17,"docs":{"0":{"tf":1.0},"101":{"tf":1.4142135623730951},"107":{"tf":1.0},"112":{"tf":1.0},"130":{"tf":1.4142135623730951},"131":{"tf":1.0},"133":{"tf":1.0},"146":{"tf":1.7320508075688772},"155":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.7320508075688772},"174":{"tf":1.0},"211":{"tf":1.0},"226":{"tf":1.0},"29":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"203":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":10,"docs":{"113":{"tf":1.0},"114":{"tf":1.0},"13":{"tf":1.0},"131":{"tf":1.0},"138":{"tf":1.0},"141":{"tf":1.0},"163":{"tf":1.0},"167":{"tf":1.0},"222":{"tf":1.0},"226":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"t":{"df":2,"docs":{"214":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":23,"docs":{"107":{"tf":1.0},"130":{"tf":1.0},"138":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"151":{"tf":1.0},"154":{"tf":1.4142135623730951},"156":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"161":{"tf":1.7320508075688772},"168":{"tf":1.0},"169":{"tf":1.0},"176":{"tf":1.7320508075688772},"210":{"tf":1.0},"222":{"tf":2.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951},"85":{"tf":1.0},"88":{"tf":1.0},"93":{"tf":1.4142135623730951},"98":{"tf":1.0},"99":{"tf":1.7320508075688772}},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"138":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"210":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"177":{"tf":1.0},"193":{"tf":1.0},"199":{"tf":1.0},"200":{"tf":1.0},"5":{"tf":1.0},"89":{"tf":1.0}}},"x":{"df":10,"docs":{"0":{"tf":1.4142135623730951},"119":{"tf":1.0},"137":{"tf":1.0},"161":{"tf":1.0},"210":{"tf":1.0},"211":{"tf":1.0},"223":{"tf":2.449489742783178},"38":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"87":{"tf":2.0}}}},"i":{"c":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"108":{"tf":1.7320508075688772},"125":{"tf":1.0},"2":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"226":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"210":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"130":{"tf":1.0},"156":{"tf":1.0},"213":{"tf":1.0},"226":{"tf":1.0},"99":{"tf":1.0}},"u":{"df":1,"docs":{"221":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"144":{"tf":1.0},"154":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"107":{"tf":1.0}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"138":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"146":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":7,"docs":{"120":{"tf":1.0},"210":{"tf":1.0},"213":{"tf":1.4142135623730951},"221":{"tf":1.0},"223":{"tf":1.0},"226":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{},"f":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"129":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"121":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":2,"docs":{"121":{"tf":1.0},"129":{"tf":1.0}},"i":{"d":{"df":2,"docs":{"147":{"tf":1.0},"230":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":2,"docs":{"129":{"tf":1.0},"7":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"129":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":18,"docs":{"109":{"tf":1.0},"121":{"tf":1.7320508075688772},"129":{"tf":4.0},"139":{"tf":2.0},"202":{"tf":2.0},"203":{"tf":1.0},"21":{"tf":1.7320508075688772},"26":{"tf":1.7320508075688772},"27":{"tf":1.7320508075688772},"29":{"tf":1.0},"30":{"tf":1.0},"41":{"tf":1.7320508075688772},"43":{"tf":1.7320508075688772},"5":{"tf":2.449489742783178},"7":{"tf":2.8284271247461903},"71":{"tf":1.0},"8":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"230":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"127":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"99":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"129":{"tf":1.0}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"220":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"202":{"tf":1.0}}}}},"i":{"d":{"df":14,"docs":{"0":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"148":{"tf":1.0},"221":{"tf":1.0},"223":{"tf":1.0},"224":{"tf":1.0},"30":{"tf":1.0},"43":{"tf":1.0},"54":{"tf":1.0},"63":{"tf":1.0},"75":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"214":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"148":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951}}}}},"df":2,"docs":{"161":{"tf":1.0},"71":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"129":{"tf":1.0}}}}},"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"129":{"tf":1.0},"161":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"121":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"230":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":30,"docs":{"0":{"tf":1.0},"113":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":1.0},"129":{"tf":1.0},"138":{"tf":1.0},"145":{"tf":1.0},"149":{"tf":1.0},"151":{"tf":1.4142135623730951},"152":{"tf":1.4142135623730951},"159":{"tf":1.0},"167":{"tf":1.0},"186":{"tf":1.0},"188":{"tf":1.0},"196":{"tf":1.0},"210":{"tf":1.0},"213":{"tf":1.4142135623730951},"214":{"tf":1.4142135623730951},"218":{"tf":1.0},"220":{"tf":1.0},"223":{"tf":1.4142135623730951},"225":{"tf":1.0},"226":{"tf":1.0},"29":{"tf":1.0},"5":{"tf":1.4142135623730951},"51":{"tf":1.0},"7":{"tf":2.0},"86":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"114":{"tf":1.0},"121":{"tf":1.0},"141":{"tf":1.0},"186":{"tf":1.0},"210":{"tf":1.4142135623730951},"221":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":8,"docs":{"107":{"tf":1.0},"144":{"tf":1.0},"146":{"tf":1.0},"151":{"tf":1.0},"167":{"tf":3.0},"169":{"tf":1.4142135623730951},"172":{"tf":1.0},"174":{"tf":3.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":3,"docs":{"177":{"tf":1.0},"229":{"tf":1.0},"93":{"tf":1.0}}}}},"r":{"a":{"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"145":{"tf":1.0},"220":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":8,"docs":{"100":{"tf":1.0},"109":{"tf":1.0},"203":{"tf":1.4142135623730951},"227":{"tf":1.0},"228":{"tf":1.0},"229":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"100":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"199":{"tf":1.4142135623730951},"200":{"tf":1.0},"203":{"tf":2.449489742783178},"229":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"204":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"104":{"tf":1.0},"163":{"tf":1.0}}},"t":{"df":2,"docs":{"128":{"tf":1.0},"137":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"161":{"tf":1.0},"163":{"tf":1.0},"222":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":13,"docs":{"108":{"tf":1.0},"113":{"tf":1.0},"122":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.0},"140":{"tf":1.0},"142":{"tf":1.0},"159":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.0},"179":{"tf":1.4142135623730951},"180":{"tf":1.0},"75":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"177":{"tf":2.23606797749979}}}}}},":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"171":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"160":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":2,"docs":{"177":{"tf":1.0},"218":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":9,"docs":{"0":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"147":{"tf":1.0},"186":{"tf":1.7320508075688772},"224":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":14,"docs":{"117":{"tf":1.0},"129":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"167":{"tf":1.4142135623730951},"169":{"tf":1.0},"182":{"tf":1.4142135623730951},"183":{"tf":1.0},"189":{"tf":1.4142135623730951},"190":{"tf":1.4142135623730951},"191":{"tf":1.4142135623730951},"192":{"tf":1.0},"219":{"tf":1.0},"220":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"31":{"tf":1.0},"71":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"222":{"tf":1.0},"226":{"tf":1.0},"230":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":3,"docs":{"204":{"tf":1.0},"5":{"tf":1.0},"99":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"100":{"tf":1.4142135623730951},"149":{"tf":1.0},"156":{"tf":1.0},"186":{"tf":1.0},"201":{"tf":1.0},"202":{"tf":1.7320508075688772},"203":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"=":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"177":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"99":{"tf":1.0}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"99":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":19,"docs":{"0":{"tf":1.0},"105":{"tf":1.4142135623730951},"113":{"tf":1.7320508075688772},"116":{"tf":1.4142135623730951},"140":{"tf":1.7320508075688772},"167":{"tf":2.0},"172":{"tf":1.0},"174":{"tf":1.7320508075688772},"25":{"tf":1.4142135623730951},"34":{"tf":1.0},"5":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"89":{"tf":1.0},"9":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.4142135623730951},"96":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":21,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"109":{"tf":1.4142135623730951},"111":{"tf":1.0},"112":{"tf":2.0},"113":{"tf":1.4142135623730951},"114":{"tf":1.0},"116":{"tf":1.0},"127":{"tf":1.4142135623730951},"133":{"tf":2.0},"138":{"tf":1.4142135623730951},"139":{"tf":1.0},"151":{"tf":1.0},"155":{"tf":1.7320508075688772},"161":{"tf":2.6457513110645907},"169":{"tf":1.0},"179":{"tf":1.0},"187":{"tf":1.0},"192":{"tf":1.0},"214":{"tf":1.4142135623730951},"226":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"113":{"tf":1.0},"138":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"129":{"tf":1.0}}}}}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"181":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"167":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"162":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":35,"docs":{"108":{"tf":1.4142135623730951},"113":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.0},"167":{"tf":1.0},"174":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.0},"179":{"tf":1.0},"182":{"tf":1.4142135623730951},"183":{"tf":1.0},"186":{"tf":2.0},"188":{"tf":1.0},"189":{"tf":1.4142135623730951},"190":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.0},"193":{"tf":1.7320508075688772},"202":{"tf":1.0},"203":{"tf":1.7320508075688772},"210":{"tf":1.0},"211":{"tf":1.0},"218":{"tf":1.7320508075688772},"220":{"tf":1.4142135623730951},"221":{"tf":1.7320508075688772},"222":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":2.8284271247461903},"36":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"7":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":4,"docs":{"146":{"tf":1.0},"221":{"tf":1.0},"223":{"tf":1.0},"226":{"tf":1.4142135623730951}}}}}}},"x":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"212":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"c":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"161":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"158":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"159":{"tf":1.0},"172":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"161":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"(":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"158":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":6,"docs":{"152":{"tf":1.0},"153":{"tf":1.0},"159":{"tf":1.0},"169":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":20,"docs":{"119":{"tf":1.7320508075688772},"120":{"tf":1.4142135623730951},"121":{"tf":1.0},"146":{"tf":1.4142135623730951},"147":{"tf":1.4142135623730951},"152":{"tf":1.0},"153":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.0},"160":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"167":{"tf":1.0},"169":{"tf":1.4142135623730951},"170":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"173":{"tf":1.0},"212":{"tf":1.0},"221":{"tf":1.4142135623730951}}},"y":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"175":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"203":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"177":{"tf":1.0}}}},"t":{"a":{"df":8,"docs":{"151":{"tf":1.0},"153":{"tf":1.0},"169":{"tf":1.0},"210":{"tf":1.7320508075688772},"211":{"tf":1.0},"217":{"tf":1.0},"218":{"tf":1.4142135623730951},"224":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":10,"docs":{"134":{"tf":1.0},"176":{"tf":1.0},"179":{"tf":1.7320508075688772},"185":{"tf":1.0},"187":{"tf":1.0},"188":{"tf":1.0},"193":{"tf":1.4142135623730951},"209":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.0}}}},"y":{"df":2,"docs":{"176":{"tf":1.0},"230":{"tf":1.0}}}},"b":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":2,"docs":{"126":{"tf":1.0},"14":{"tf":1.4142135623730951}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"d":{"df":2,"docs":{"179":{"tf":1.0},"193":{"tf":2.0}}},"df":4,"docs":{"138":{"tf":1.4142135623730951},"148":{"tf":1.4142135623730951},"5":{"tf":1.0},"96":{"tf":1.4142135623730951}},"e":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":10,"docs":{"118":{"tf":1.4142135623730951},"127":{"tf":1.0},"131":{"tf":1.0},"144":{"tf":1.4142135623730951},"145":{"tf":1.0},"165":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.0},"174":{"tf":1.4142135623730951},"99":{"tf":1.0}}}},"b":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"177":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"g":{"df":3,"docs":{"109":{"tf":1.0},"126":{"tf":1.7320508075688772},"129":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"161":{"tf":1.0},"167":{"tf":1.0}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":2,"docs":{"53":{"tf":1.0},"78":{"tf":1.0}}},"s":{"df":2,"docs":{"118":{"tf":1.0},"143":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":8,"docs":{"109":{"tf":1.0},"116":{"tf":2.23606797749979},"117":{"tf":1.0},"119":{"tf":1.0},"124":{"tf":1.0},"135":{"tf":1.4142135623730951},"146":{"tf":1.0},"211":{"tf":1.7320508075688772}},"e":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"116":{"tf":1.4142135623730951},"124":{"tf":1.0},"134":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"!":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"129":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"129":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"167":{"tf":1.0}}}}}},"f":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"171":{"tf":1.0}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":96,"docs":{"0":{"tf":1.7320508075688772},"10":{"tf":1.0},"108":{"tf":1.0},"11":{"tf":1.0},"112":{"tf":1.4142135623730951},"113":{"tf":1.4142135623730951},"116":{"tf":1.0},"12":{"tf":1.0},"129":{"tf":1.7320508075688772},"13":{"tf":1.0},"133":{"tf":1.0},"134":{"tf":1.0},"138":{"tf":1.0},"14":{"tf":1.0},"140":{"tf":1.0},"147":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"177":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.0},"21":{"tf":2.23606797749979},"22":{"tf":1.0},"225":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":2.0},"27":{"tf":2.23606797749979},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.0},"42":{"tf":1.0},"43":{"tf":2.449489742783178},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":2.23606797749979},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":2.23606797749979},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0},"96":{"tf":1.0}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"129":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"167":{"tf":1.0},"174":{"tf":1.0}}}}},"i":{"d":{"df":2,"docs":{"159":{"tf":1.0},"172":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":32,"docs":{"109":{"tf":1.0},"112":{"tf":1.4142135623730951},"129":{"tf":1.0},"131":{"tf":1.0},"134":{"tf":1.4142135623730951},"137":{"tf":1.0},"144":{"tf":1.4142135623730951},"145":{"tf":1.0},"146":{"tf":1.0},"153":{"tf":1.0},"155":{"tf":1.4142135623730951},"158":{"tf":1.0},"159":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"167":{"tf":1.7320508075688772},"168":{"tf":1.0},"172":{"tf":1.4142135623730951},"173":{"tf":1.4142135623730951},"174":{"tf":1.7320508075688772},"178":{"tf":1.4142135623730951},"200":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.4142135623730951},"206":{"tf":1.0},"212":{"tf":1.4142135623730951},"214":{"tf":1.4142135623730951},"220":{"tf":1.0},"226":{"tf":1.0},"7":{"tf":1.0},"84":{"tf":1.0}},"e":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"134":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"121":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":9,"docs":{"112":{"tf":1.0},"119":{"tf":1.0},"129":{"tf":1.7320508075688772},"131":{"tf":1.4142135623730951},"133":{"tf":1.0},"151":{"tf":1.0},"162":{"tf":1.0},"169":{"tf":1.0},"219":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"229":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"179":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"161":{"tf":1.0},"213":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"i":{"df":3,"docs":{"0":{"tf":1.0},"7":{"tf":1.7320508075688772},"85":{"tf":1.0}}},"y":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"p":{"df":1,"docs":{"5":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"d":{"df":13,"docs":{"119":{"tf":1.0},"157":{"tf":1.0},"172":{"tf":1.0},"186":{"tf":1.0},"210":{"tf":1.0},"213":{"tf":1.0},"214":{"tf":1.0},"217":{"tf":1.0},"219":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.0},"225":{"tf":1.0},"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"175":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":4,"docs":{"104":{"tf":1.4142135623730951},"186":{"tf":1.4142135623730951},"203":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"101":{"tf":1.0},"141":{"tf":1.0},"154":{"tf":1.0},"90":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"226":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"b":{"df":16,"docs":{"100":{"tf":1.0},"121":{"tf":1.0},"124":{"tf":1.0},"134":{"tf":1.4142135623730951},"175":{"tf":2.0},"176":{"tf":1.0},"203":{"tf":1.4142135623730951},"209":{"tf":1.0},"211":{"tf":1.7320508075688772},"213":{"tf":1.7320508075688772},"214":{"tf":1.0},"217":{"tf":1.0},"222":{"tf":1.0},"226":{"tf":1.7320508075688772},"4":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":8,"docs":{"0":{"tf":1.0},"101":{"tf":1.0},"109":{"tf":1.0},"116":{"tf":1.4142135623730951},"124":{"tf":1.0},"134":{"tf":1.4142135623730951},"5":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":6,"docs":{"149":{"tf":1.0},"211":{"tf":1.0},"6":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"99":{"tf":1.0}}}},"r":{"df":2,"docs":{"211":{"tf":1.0},"30":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"167":{"tf":1.0},"174":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":10,"docs":{"105":{"tf":1.0},"119":{"tf":1.0},"146":{"tf":1.0},"149":{"tf":1.0},"176":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":1.0},"217":{"tf":1.0},"7":{"tf":1.0},"99":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":11,"docs":{"109":{"tf":1.0},"122":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"134":{"tf":1.0},"138":{"tf":1.0},"144":{"tf":1.0},"148":{"tf":1.0},"167":{"tf":1.4142135623730951},"174":{"tf":1.4142135623730951},"211":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"117":{"tf":1.0},"160":{"tf":1.0},"189":{"tf":1.0},"27":{"tf":1.0},"44":{"tf":1.0}}}}}}}},"v":{"df":27,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":3.1622776601683795},"106":{"tf":1.0},"107":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"115":{"tf":1.7320508075688772},"116":{"tf":1.0},"117":{"tf":1.7320508075688772},"119":{"tf":1.0},"125":{"tf":1.0},"128":{"tf":1.4142135623730951},"130":{"tf":1.0},"131":{"tf":1.0},"133":{"tf":2.0},"134":{"tf":1.0},"135":{"tf":1.4142135623730951},"138":{"tf":1.0},"140":{"tf":1.4142135623730951},"142":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"168":{"tf":1.0},"176":{"tf":1.0},"203":{"tf":2.449489742783178}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":17,"docs":{"0":{"tf":1.0},"107":{"tf":1.0},"116":{"tf":1.0},"136":{"tf":1.4142135623730951},"137":{"tf":1.7320508075688772},"143":{"tf":1.0},"145":{"tf":1.0},"158":{"tf":1.0},"162":{"tf":1.0},"197":{"tf":1.0},"199":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":2.449489742783178},"223":{"tf":1.4142135623730951},"3":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":11,"docs":{"127":{"tf":1.0},"130":{"tf":1.0},"146":{"tf":1.4142135623730951},"156":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.0},"160":{"tf":1.4142135623730951},"168":{"tf":1.0},"171":{"tf":1.7320508075688772},"172":{"tf":1.7320508075688772}}}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"217":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":3,"docs":{"105":{"tf":1.0},"182":{"tf":1.0},"188":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":20,"docs":{"103":{"tf":1.0},"113":{"tf":1.0},"120":{"tf":1.0},"127":{"tf":2.0},"133":{"tf":1.0},"139":{"tf":1.0},"140":{"tf":1.0},"154":{"tf":1.0},"167":{"tf":1.4142135623730951},"174":{"tf":1.0},"175":{"tf":1.0},"203":{"tf":1.0},"214":{"tf":1.0},"218":{"tf":1.0},"220":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"88":{"tf":1.0},"93":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":4,"docs":{"165":{"tf":1.0},"166":{"tf":1.0},"174":{"tf":1.0},"223":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"r":{"df":1,"docs":{"108":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"2":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"3":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":3,"docs":{"127":{"tf":1.0},"226":{"tf":1.0},"229":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"182":{"tf":1.0},"214":{"tf":1.0},"220":{"tf":1.0},"224":{"tf":1.0},"4":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":21,"docs":{"108":{"tf":1.4142135623730951},"112":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"129":{"tf":1.7320508075688772},"133":{"tf":1.7320508075688772},"139":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.0},"182":{"tf":1.4142135623730951},"183":{"tf":1.0},"186":{"tf":1.0},"189":{"tf":1.4142135623730951},"190":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.0},"196":{"tf":1.4142135623730951},"203":{"tf":1.0},"24":{"tf":1.0},"7":{"tf":1.7320508075688772}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"x":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"178":{"tf":1.0},"181":{"tf":1.0},"202":{"tf":1.4142135623730951},"203":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"5":{"tf":1.0},"89":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":5,"docs":{"39":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"7":{"tf":2.0}},"e":{"d":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"133":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"152":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":6,"docs":{"133":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.4142135623730951},"213":{"tf":1.0},"227":{"tf":1.0},"228":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"148":{"tf":1.0}}}}}},"m":{"df":1,"docs":{"230":{"tf":1.0}}},"o":{"c":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":7,"docs":{"124":{"tf":1.0},"129":{"tf":1.4142135623730951},"130":{"tf":1.0},"203":{"tf":1.0},"43":{"tf":1.7320508075688772},"61":{"tf":1.0},"98":{"tf":1.0}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"95":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":31,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"109":{"tf":1.4142135623730951},"110":{"tf":1.0},"116":{"tf":2.0},"121":{"tf":1.4142135623730951},"124":{"tf":2.0},"128":{"tf":1.0},"129":{"tf":1.4142135623730951},"130":{"tf":1.4142135623730951},"131":{"tf":1.0},"144":{"tf":1.4142135623730951},"145":{"tf":1.4142135623730951},"146":{"tf":1.7320508075688772},"153":{"tf":1.0},"159":{"tf":1.0},"175":{"tf":1.0},"186":{"tf":1.4142135623730951},"187":{"tf":1.7320508075688772},"193":{"tf":1.0},"194":{"tf":1.0},"201":{"tf":1.0},"203":{"tf":1.7320508075688772},"204":{"tf":1.4142135623730951},"208":{"tf":1.0},"227":{"tf":1.0},"5":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.0},"84":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}}}}}}},"df":1,"docs":{"229":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":10,"docs":{"124":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":1.0},"174":{"tf":1.0},"218":{"tf":1.0},"219":{"tf":1.0},"221":{"tf":1.0},"229":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"209":{"tf":1.0},"211":{"tf":2.0}}}}},"df":0,"docs":{}},"n":{"'":{"df":0,"docs":{},"t":{"df":27,"docs":{"111":{"tf":1.0},"113":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"127":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.0},"132":{"tf":1.0},"138":{"tf":1.4142135623730951},"143":{"tf":1.0},"144":{"tf":1.0},"146":{"tf":1.0},"154":{"tf":1.0},"174":{"tf":1.0},"178":{"tf":1.0},"181":{"tf":1.0},"193":{"tf":1.0},"200":{"tf":1.0},"210":{"tf":1.0},"213":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.0},"223":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":1.0},"230":{"tf":1.0},"27":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":18,"docs":{"100":{"tf":1.0},"117":{"tf":1.4142135623730951},"121":{"tf":1.0},"129":{"tf":1.4142135623730951},"175":{"tf":1.0},"176":{"tf":1.4142135623730951},"179":{"tf":1.0},"181":{"tf":1.4142135623730951},"182":{"tf":1.0},"183":{"tf":1.4142135623730951},"189":{"tf":1.0},"199":{"tf":1.0},"201":{"tf":1.0},"202":{"tf":1.0},"212":{"tf":1.0},"217":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":2.0}}}},"t":{"df":1,"docs":{"24":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":4,"docs":{"113":{"tf":1.0},"118":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"227":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"171":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"165":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"207":{"tf":1.0},"221":{"tf":1.4142135623730951}},"s":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"226":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"136":{"tf":1.0}}},"r":{"df":3,"docs":{"108":{"tf":2.0},"4":{"tf":1.0},"6":{"tf":2.23606797749979}}}}}},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"159":{"tf":1.0},"172":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"159":{"tf":2.0},"172":{"tf":1.4142135623730951},"203":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"e":{"df":3,"docs":{"138":{"tf":1.0},"200":{"tf":1.0},"202":{"tf":1.0}}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"186":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"229":{"tf":1.0},"25":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":9,"docs":{"107":{"tf":1.0},"144":{"tf":1.0},"175":{"tf":1.0},"185":{"tf":1.0},"208":{"tf":1.0},"223":{"tf":1.0},"226":{"tf":1.0},"230":{"tf":1.0},"7":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"227":{"tf":1.0},"229":{"tf":1.7320508075688772},"230":{"tf":1.0}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"5":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.0},"95":{"tf":1.0}}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"165":{"tf":1.0},"166":{"tf":1.0},"174":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":17,"docs":{"0":{"tf":2.0},"113":{"tf":1.0},"134":{"tf":1.0},"16":{"tf":1.0},"161":{"tf":1.0},"163":{"tf":1.0},"179":{"tf":1.0},"203":{"tf":1.4142135623730951},"210":{"tf":1.0},"211":{"tf":1.0},"217":{"tf":1.0},"222":{"tf":1.0},"223":{"tf":1.0},"27":{"tf":1.4142135623730951},"5":{"tf":1.0},"7":{"tf":1.0},"93":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":14,"docs":{"0":{"tf":1.0},"104":{"tf":1.0},"113":{"tf":1.4142135623730951},"137":{"tf":1.0},"138":{"tf":1.0},"140":{"tf":1.0},"186":{"tf":1.4142135623730951},"203":{"tf":1.0},"220":{"tf":1.0},"223":{"tf":1.0},"27":{"tf":1.0},"7":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":7,"docs":{"111":{"tf":1.0},"133":{"tf":1.0},"135":{"tf":1.4142135623730951},"221":{"tf":1.4142135623730951},"226":{"tf":1.4142135623730951},"230":{"tf":1.0},"93":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"100":{"tf":1.0},"147":{"tf":1.0},"221":{"tf":1.0},"97":{"tf":1.0}}}}},"y":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"144":{"tf":1.0}}},"<":{"'":{"_":{"df":3,"docs":{"119":{"tf":1.4142135623730951},"120":{"tf":1.0},"221":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"116":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"167":{"tf":1.0},"212":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":12,"docs":{"116":{"tf":1.4142135623730951},"118":{"tf":1.7320508075688772},"119":{"tf":2.0},"120":{"tf":1.4142135623730951},"130":{"tf":1.4142135623730951},"143":{"tf":1.7320508075688772},"144":{"tf":2.6457513110645907},"145":{"tf":1.4142135623730951},"166":{"tf":1.0},"167":{"tf":1.0},"212":{"tf":1.0},"222":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}}},"s":{"df":0,"docs":{},"i":{"df":3,"docs":{"192":{"tf":1.0},"210":{"tf":1.0},"88":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":8,"docs":{"120":{"tf":1.0},"145":{"tf":1.0},"203":{"tf":2.0},"214":{"tf":1.0},"222":{"tf":1.0},"226":{"tf":1.0},"229":{"tf":1.0},"88":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"182":{"tf":1.0},"195":{"tf":1.0},"5":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"211":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"200":{"tf":1.0}}}}}}}}}},"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"137":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"177":{"tf":1.0},"6":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"122":{"tf":1.0},"186":{"tf":1.0}}}}}}},"df":4,"docs":{"186":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"58":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"i":{"b":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"213":{"tf":1.4142135623730951},"223":{"tf":1.4142135623730951},"225":{"tf":1.0},"58":{"tf":1.7320508075688772}}}}}},"v":{"df":1,"docs":{"5":{"tf":1.0}}}},"m":{"df":0,"docs":{},"t":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"218":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"119":{"tf":1.0},"120":{"tf":1.0}}}},"t":{"df":11,"docs":{"109":{"tf":1.0},"117":{"tf":1.0},"119":{"tf":1.7320508075688772},"138":{"tf":2.0},"146":{"tf":3.4641016151377544},"147":{"tf":1.7320508075688772},"149":{"tf":1.0},"166":{"tf":1.0},"27":{"tf":1.0},"7":{"tf":1.4142135623730951},"83":{"tf":1.0}}}},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"137":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":5,"docs":{"116":{"tf":1.0},"138":{"tf":1.0},"188":{"tf":1.0},"213":{"tf":2.23606797749979},"218":{"tf":1.0}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":11,"docs":{"0":{"tf":1.4142135623730951},"123":{"tf":1.0},"127":{"tf":1.0},"138":{"tf":1.0},"203":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"79":{"tf":1.0},"90":{"tf":1.7320508075688772},"91":{"tf":1.4142135623730951}},"e":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"146":{"tf":1.0},"165":{"tf":1.0},"96":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"127":{"tf":1.0},"203":{"tf":1.0},"229":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"d":{"df":8,"docs":{"127":{"tf":1.0},"144":{"tf":1.0},"166":{"tf":1.0},"203":{"tf":1.0},"208":{"tf":1.0},"218":{"tf":1.0},"225":{"tf":1.0},"27":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"230":{"tf":1.0}}}}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":5,"docs":{"203":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"69":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"137":{"tf":1.0},"161":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"137":{"tf":1.4142135623730951},"186":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":5,"docs":{"161":{"tf":1.0},"174":{"tf":1.0},"187":{"tf":1.0},"203":{"tf":1.0},"212":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"120":{"tf":1.0},"121":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"137":{"tf":1.0},"153":{"tf":1.0},"169":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"127":{"tf":1.0},"7":{"tf":1.0}}},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"161":{"tf":1.0},"211":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"129":{"tf":1.0},"175":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"48":{"tf":1.0}}},"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"34":{"tf":1.0},"47":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":7,"docs":{"153":{"tf":1.0},"163":{"tf":1.0},"218":{"tf":2.6457513110645907},"219":{"tf":2.0},"220":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":1.0}}}},"v":{"df":2,"docs":{"93":{"tf":1.0},"94":{"tf":1.0}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"129":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772}}}}}}}},"q":{"df":1,"docs":{"159":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"167":{"tf":1.0},"174":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"226":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"52":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":13,"docs":{"103":{"tf":1.0},"107":{"tf":1.0},"113":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":2.8284271247461903},"140":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"148":{"tf":2.0},"5":{"tf":1.0},"52":{"tf":1.0},"7":{"tf":1.7320508075688772},"93":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"152":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":3,"docs":{"202":{"tf":1.0},"203":{"tf":1.7320508075688772},"92":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"161":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"204":{"tf":1.0},"206":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"c":{"df":9,"docs":{"130":{"tf":1.0},"138":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.0},"161":{"tf":1.0},"223":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951},"96":{"tf":1.0}}},"df":0,"docs":{}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":2,"docs":{"226":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":12,"docs":{"164":{"tf":1.4142135623730951},"173":{"tf":1.0},"186":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.0},"210":{"tf":1.0},"221":{"tf":1.0},"226":{"tf":1.0},"5":{"tf":1.7320508075688772},"71":{"tf":1.0},"90":{"tf":1.0},"99":{"tf":1.0}},"t":{"df":1,"docs":{"227":{"tf":1.0}},"u":{"df":1,"docs":{"230":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"227":{"tf":1.0},"228":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"145":{"tf":1.0}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":7,"docs":{"113":{"tf":1.0},"116":{"tf":1.0},"138":{"tf":1.0},"166":{"tf":1.0},"186":{"tf":1.0},"202":{"tf":1.0},"226":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":9,"docs":{"144":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.0},"152":{"tf":1.4142135623730951},"153":{"tf":1.0},"157":{"tf":1.4142135623730951},"158":{"tf":1.0},"159":{"tf":1.0},"167":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":57,"docs":{"103":{"tf":1.0},"109":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951},"121":{"tf":1.7320508075688772},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.7320508075688772},"127":{"tf":1.4142135623730951},"132":{"tf":1.0},"133":{"tf":1.0},"134":{"tf":1.7320508075688772},"138":{"tf":1.4142135623730951},"140":{"tf":1.0},"142":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.4142135623730951},"146":{"tf":1.4142135623730951},"147":{"tf":1.7320508075688772},"148":{"tf":2.0},"154":{"tf":1.0},"155":{"tf":1.0},"161":{"tf":1.0},"163":{"tf":1.0},"167":{"tf":1.0},"169":{"tf":1.4142135623730951},"174":{"tf":1.4142135623730951},"181":{"tf":1.0},"21":{"tf":1.0},"210":{"tf":1.0},"211":{"tf":1.0},"213":{"tf":2.23606797749979},"214":{"tf":2.23606797749979},"215":{"tf":1.0},"219":{"tf":1.7320508075688772},"220":{"tf":1.4142135623730951},"221":{"tf":1.0},"223":{"tf":2.449489742783178},"225":{"tf":1.0},"226":{"tf":2.23606797749979},"27":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":2.449489742783178},"58":{"tf":1.0},"6":{"tf":1.4142135623730951},"61":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"226":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"49":{"tf":1.0}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"190":{"tf":1.0},"191":{"tf":1.0}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"218":{"tf":1.0}}}}}},"df":1,"docs":{"19":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"113":{"tf":1.0},"122":{"tf":1.0},"128":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":11,"docs":{"100":{"tf":1.0},"115":{"tf":1.0},"130":{"tf":1.0},"145":{"tf":1.0},"150":{"tf":1.0},"181":{"tf":1.0},"186":{"tf":1.0},"188":{"tf":1.0},"203":{"tf":1.4142135623730951},"222":{"tf":1.4142135623730951},"229":{"tf":1.0}}}},"t":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":8,"docs":{"120":{"tf":1.0},"143":{"tf":1.0},"166":{"tf":1.7320508075688772},"167":{"tf":2.449489742783178},"174":{"tf":2.23606797749979},"186":{"tf":1.0},"203":{"tf":1.0},"212":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":7,"docs":{"144":{"tf":1.0},"165":{"tf":2.23606797749979},"166":{"tf":1.0},"167":{"tf":2.0},"174":{"tf":2.6457513110645907},"214":{"tf":1.4142135623730951},"83":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":14,"docs":{"103":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"120":{"tf":1.0},"138":{"tf":1.0},"146":{"tf":1.0},"15":{"tf":1.4142135623730951},"203":{"tf":1.7320508075688772},"212":{"tf":1.0},"214":{"tf":1.0},"221":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"197":{"tf":1.0},"199":{"tf":1.0},"203":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"104":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"222":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":11,"docs":{"101":{"tf":1.0},"116":{"tf":1.0},"130":{"tf":1.0},"158":{"tf":1.0},"187":{"tf":1.0},"194":{"tf":1.0},"201":{"tf":1.0},"210":{"tf":1.0},"212":{"tf":1.0},"229":{"tf":1.0},"98":{"tf":1.0}}}},"n":{"df":3,"docs":{"201":{"tf":1.0},"212":{"tf":1.0},"216":{"tf":1.0}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"45":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"156":{"tf":1.0},"163":{"tf":1.0},"223":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"34":{"tf":1.0},"64":{"tf":1.0},"7":{"tf":1.0}}}}},"r":{"(":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"(":{"_":{"df":1,"docs":{"226":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"218":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"226":{"tf":1.0}}}}}}},".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"163":{"tf":1.4142135623730951},"170":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"210":{"tf":1.7320508075688772},"221":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"167":{"tf":1.0},"174":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":3,"docs":{"146":{"tf":1.0},"147":{"tf":1.0},"212":{"tf":1.0}}}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"219":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"'":{"_":{"df":12,"docs":{"121":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"169":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"221":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"226":{"tf":1.0}}}}}}},"df":1,"docs":{"226":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"151":{"tf":1.4142135623730951},"169":{"tf":1.0}}},"y":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"151":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":24,"docs":{"121":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":1.4142135623730951},"153":{"tf":1.7320508075688772},"158":{"tf":1.0},"159":{"tf":1.7320508075688772},"160":{"tf":1.7320508075688772},"163":{"tf":2.0},"168":{"tf":1.0},"169":{"tf":2.0},"170":{"tf":2.0},"171":{"tf":1.0},"172":{"tf":2.0},"212":{"tf":1.7320508075688772},"213":{"tf":3.872983346207417},"214":{"tf":2.0},"218":{"tf":1.0},"219":{"tf":1.4142135623730951},"221":{"tf":2.0},"225":{"tf":1.0},"226":{"tf":3.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":30,"docs":{"123":{"tf":1.4142135623730951},"131":{"tf":1.0},"146":{"tf":2.0},"147":{"tf":1.0},"148":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.4142135623730951},"152":{"tf":2.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.0},"162":{"tf":1.0},"167":{"tf":2.449489742783178},"168":{"tf":1.0},"169":{"tf":2.0},"171":{"tf":1.4142135623730951},"172":{"tf":1.4142135623730951},"174":{"tf":1.4142135623730951},"209":{"tf":1.0},"210":{"tf":1.7320508075688772},"211":{"tf":2.449489742783178},"212":{"tf":1.4142135623730951},"213":{"tf":3.0},"214":{"tf":2.8284271247461903},"221":{"tf":1.0},"222":{"tf":1.0},"223":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":1.0},"87":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"167":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"163":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"221":{"tf":1.0},"223":{"tf":1.0},"226":{"tf":1.7320508075688772},"7":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"107":{"tf":1.0},"223":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"167":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"!":{"(":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"121":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"121":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":1,"docs":{"148":{"tf":1.0}}}},"df":2,"docs":{"119":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"0":{"df":3,"docs":{"186":{"tf":1.4142135623730951},"189":{"tf":1.4142135623730951},"190":{"tf":1.4142135623730951}}},"3":{"2":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}},"6":{"4":{":":{":":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"148":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"e":{"df":3,"docs":{"201":{"tf":1.0},"202":{"tf":1.0},"204":{"tf":1.7320508075688772}}},"t":{"df":4,"docs":{"119":{"tf":1.0},"146":{"tf":1.0},"202":{"tf":1.0},"222":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"112":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":7,"docs":{"138":{"tf":1.0},"182":{"tf":1.0},"188":{"tf":1.0},"5":{"tf":1.4142135623730951},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"138":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"229":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"112":{"tf":1.0},"133":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"182":{"tf":1.0}}}}}},"s":{"df":37,"docs":{"0":{"tf":1.0},"105":{"tf":1.0},"107":{"tf":1.4142135623730951},"120":{"tf":1.0},"129":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"166":{"tf":1.4142135623730951},"167":{"tf":1.0},"17":{"tf":1.0},"174":{"tf":1.0},"18":{"tf":1.0},"186":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.0},"202":{"tf":1.4142135623730951},"212":{"tf":1.0},"213":{"tf":1.7320508075688772},"22":{"tf":1.0},"220":{"tf":1.0},"223":{"tf":1.4142135623730951},"23":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":2.0},"61":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.4142135623730951},"71":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"90":{"tf":1.4142135623730951},"93":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"159":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":3,"docs":{"146":{"tf":1.0},"154":{"tf":1.0},"99":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"179":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"144":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":8,"docs":{"0":{"tf":1.0},"121":{"tf":2.0},"176":{"tf":1.0},"209":{"tf":1.0},"7":{"tf":1.4142135623730951},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.4142135623730951}},"e":{"(":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"123":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"d":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"186":{"tf":1.0},"230":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":4,"docs":{"107":{"tf":1.0},"131":{"tf":1.0},"5":{"tf":1.0},"89":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"102":{"tf":1.0},"179":{"tf":1.0},"186":{"tf":1.0},"188":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":4,"docs":{"144":{"tf":1.0},"146":{"tf":1.0},"179":{"tf":1.0},"230":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"202":{"tf":1.0}}}}}},"f":{"df":1,"docs":{"179":{"tf":1.0}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":6,"docs":{"121":{"tf":1.4142135623730951},"129":{"tf":1.0},"57":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.4142135623730951},"70":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":32,"docs":{"0":{"tf":1.0},"103":{"tf":2.0},"112":{"tf":2.0},"113":{"tf":3.872983346207417},"114":{"tf":2.0},"115":{"tf":1.4142135623730951},"116":{"tf":1.7320508075688772},"120":{"tf":1.0},"121":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":2.0},"131":{"tf":1.0},"133":{"tf":3.4641016151377544},"134":{"tf":1.0},"138":{"tf":3.605551275463989},"139":{"tf":2.23606797749979},"140":{"tf":2.23606797749979},"141":{"tf":2.23606797749979},"142":{"tf":1.0},"177":{"tf":1.4142135623730951},"179":{"tf":1.0},"186":{"tf":1.4142135623730951},"188":{"tf":1.0},"195":{"tf":1.0},"196":{"tf":1.0},"202":{"tf":1.4142135623730951},"227":{"tf":1.0},"24":{"tf":1.0},"56":{"tf":1.4142135623730951},"7":{"tf":2.0},"92":{"tf":1.0},"95":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"108":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":6,"docs":{"138":{"tf":1.0},"186":{"tf":1.4142135623730951},"221":{"tf":1.4142135623730951},"226":{"tf":1.7320508075688772},"54":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"124":{"tf":1.0},"149":{"tf":1.0},"186":{"tf":1.0},"7":{"tf":1.0}}}},"d":{"df":24,"docs":{"100":{"tf":1.0},"113":{"tf":1.0},"123":{"tf":1.0},"129":{"tf":1.0},"137":{"tf":1.0},"140":{"tf":1.0},"145":{"tf":1.0},"152":{"tf":1.0},"159":{"tf":1.0},"161":{"tf":1.0},"185":{"tf":1.0},"186":{"tf":1.4142135623730951},"187":{"tf":1.0},"188":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.0},"203":{"tf":1.0},"210":{"tf":1.0},"225":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.4142135623730951},"91":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":5,"docs":{"144":{"tf":1.0},"145":{"tf":1.0},"208":{"tf":1.0},"222":{"tf":1.0},"230":{"tf":1.4142135623730951}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"138":{"tf":1.0},"202":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":34,"docs":{"102":{"tf":1.4142135623730951},"108":{"tf":1.0},"109":{"tf":1.0},"113":{"tf":1.0},"119":{"tf":1.0},"121":{"tf":1.0},"123":{"tf":1.0},"129":{"tf":1.4142135623730951},"131":{"tf":1.0},"136":{"tf":1.0},"137":{"tf":2.0},"152":{"tf":1.0},"167":{"tf":1.0},"174":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.4142135623730951},"182":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"197":{"tf":1.0},"200":{"tf":1.0},"201":{"tf":1.0},"208":{"tf":1.0},"210":{"tf":1.0},"214":{"tf":1.0},"219":{"tf":1.0},"221":{"tf":1.4142135623730951},"222":{"tf":1.0},"223":{"tf":1.0},"225":{"tf":1.0},"229":{"tf":1.0},"5":{"tf":1.0},"93":{"tf":1.0},"98":{"tf":1.4142135623730951}}}}},"t":{"df":5,"docs":{"111":{"tf":1.0},"129":{"tf":1.0},"132":{"tf":1.0},"186":{"tf":1.0},"5":{"tf":1.0}}},"x":{"df":22,"docs":{"100":{"tf":1.4142135623730951},"103":{"tf":1.0},"105":{"tf":1.0},"114":{"tf":1.7320508075688772},"138":{"tf":1.7320508075688772},"139":{"tf":1.0},"141":{"tf":1.7320508075688772},"146":{"tf":1.0},"147":{"tf":2.0},"148":{"tf":1.4142135623730951},"166":{"tf":1.0},"177":{"tf":1.4142135623730951},"181":{"tf":1.4142135623730951},"182":{"tf":1.4142135623730951},"186":{"tf":2.0},"202":{"tf":1.4142135623730951},"203":{"tf":1.0},"5":{"tf":1.7320508075688772},"85":{"tf":1.0},"86":{"tf":1.4142135623730951},"91":{"tf":1.0},"93":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"/":{"a":{"d":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"185":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"186":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"112":{"tf":1.0},"133":{"tf":1.0},"7":{"tf":1.4142135623730951}}},"t":{"df":3,"docs":{"211":{"tf":1.0},"214":{"tf":1.7320508075688772},"227":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"210":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"1":{"9":{"9":{"5":{"df":1,"docs":{"230":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"176":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"t":{"df":3,"docs":{"104":{"tf":1.0},"125":{"tf":1.0},"128":{"tf":1.0}}}},"n":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"119":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":32,"docs":{"107":{"tf":1.0},"113":{"tf":3.1622776601683795},"119":{"tf":1.4142135623730951},"120":{"tf":1.7320508075688772},"121":{"tf":2.0},"129":{"tf":1.0},"138":{"tf":3.605551275463989},"146":{"tf":1.0},"147":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":1.4142135623730951},"153":{"tf":1.0},"154":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"169":{"tf":1.0},"170":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"173":{"tf":1.0},"212":{"tf":1.0},"214":{"tf":1.0},"220":{"tf":1.4142135623730951},"221":{"tf":1.4142135623730951},"223":{"tf":1.0},"226":{"tf":1.4142135623730951},"5":{"tf":1.0},"55":{"tf":1.0},"7":{"tf":1.4142135623730951}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{":":{":":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"120":{"tf":1.0}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"(":{"_":{"df":1,"docs":{"120":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"120":{"tf":1.0}}}}},"df":0,"docs":{}},"<":{"'":{"_":{"df":2,"docs":{"119":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"120":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"113":{"tf":1.4142135623730951},"138":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":3,"docs":{"131":{"tf":1.0},"201":{"tf":1.0},"87":{"tf":1.0}}}}},"df":2,"docs":{"113":{"tf":1.0},"138":{"tf":1.0}},"l":{"d":{"df":1,"docs":{"148":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"129":{"tf":1.0}}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"203":{"tf":1.0}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":46,"docs":{"102":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":1.7320508075688772},"115":{"tf":1.0},"116":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.4142135623730951},"129":{"tf":1.0},"133":{"tf":2.0},"138":{"tf":1.0},"144":{"tf":1.4142135623730951},"145":{"tf":1.4142135623730951},"152":{"tf":1.0},"158":{"tf":1.0},"161":{"tf":1.0},"167":{"tf":2.0},"168":{"tf":1.0},"169":{"tf":1.0},"174":{"tf":1.0},"176":{"tf":1.4142135623730951},"177":{"tf":1.0},"178":{"tf":1.4142135623730951},"179":{"tf":1.0},"180":{"tf":1.0},"182":{"tf":1.0},"186":{"tf":1.4142135623730951},"193":{"tf":1.0},"201":{"tf":1.4142135623730951},"202":{"tf":1.4142135623730951},"203":{"tf":1.7320508075688772},"21":{"tf":1.0},"210":{"tf":1.4142135623730951},"212":{"tf":1.0},"213":{"tf":1.4142135623730951},"214":{"tf":1.7320508075688772},"217":{"tf":1.4142135623730951},"218":{"tf":1.0},"221":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":1.4142135623730951},"27":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}}},"o":{"!":{"(":{"\"":{"b":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"167":{"tf":1.0},"174":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"113":{"tf":1.4142135623730951},"138":{"tf":2.0}}}}}}},"df":0,"docs":{},"x":{"df":1,"docs":{"154":{"tf":1.0}}}},".":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}}},"_":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"113":{"tf":1.4142135623730951},"140":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":9,"docs":{"111":{"tf":1.0},"116":{"tf":1.7320508075688772},"119":{"tf":1.0},"120":{"tf":1.0},"124":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":2.0},"138":{"tf":1.4142135623730951},"144":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"167":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"d":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"113":{"tf":1.4142135623730951},"138":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"113":{"tf":1.0},"138":{"tf":1.0}}},"df":18,"docs":{"109":{"tf":1.0},"113":{"tf":1.4142135623730951},"116":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.7320508075688772},"124":{"tf":1.0},"132":{"tf":1.0},"138":{"tf":3.3166247903554},"144":{"tf":1.0},"161":{"tf":1.4142135623730951},"167":{"tf":1.4142135623730951},"174":{"tf":1.4142135623730951},"213":{"tf":1.0},"214":{"tf":1.4142135623730951},"223":{"tf":1.4142135623730951},"27":{"tf":1.0},"41":{"tf":1.0},"7":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"116":{"tf":1.0},"119":{"tf":1.7320508075688772},"120":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"b":{"df":0,"docs":{},"i":{"d":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"c":{"df":3,"docs":{"108":{"tf":1.0},"177":{"tf":1.0},"192":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"167":{"tf":1.4142135623730951},"174":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"165":{"tf":1.0},"166":{"tf":1.0}}}}},"g":{"df":2,"docs":{"185":{"tf":1.0},"187":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"148":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"148":{"tf":1.0},"174":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"186":{"tf":1.0}}}}}}}},"k":{"df":3,"docs":{"102":{"tf":1.4142135623730951},"179":{"tf":1.0},"188":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"t":{"!":{"(":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"147":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"104":{"tf":1.4142135623730951},"125":{"tf":1.7320508075688772},"129":{"tf":1.0},"147":{"tf":1.0},"16":{"tf":1.7320508075688772},"175":{"tf":1.0},"194":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"111":{"tf":1.0}}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"179":{"tf":1.0},"226":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"df":17,"docs":{"107":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"133":{"tf":1.0},"172":{"tf":1.0},"186":{"tf":1.0},"187":{"tf":1.0},"190":{"tf":1.0},"206":{"tf":1.0},"215":{"tf":1.0},"218":{"tf":1.4142135623730951},"220":{"tf":1.0},"226":{"tf":1.0},"5":{"tf":1.4142135623730951},"7":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":4,"docs":{"107":{"tf":1.0},"202":{"tf":1.7320508075688772},"204":{"tf":1.0},"5":{"tf":1.4142135623730951}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"138":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"230":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"s":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}},"df":5,"docs":{"107":{"tf":1.0},"131":{"tf":1.0},"5":{"tf":1.0},"85":{"tf":1.0},"89":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"223":{"tf":1.0},"229":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":3,"docs":{"130":{"tf":1.0},"167":{"tf":1.4142135623730951},"174":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":8,"docs":{"120":{"tf":1.0},"137":{"tf":1.0},"163":{"tf":1.0},"171":{"tf":1.0},"230":{"tf":1.0},"5":{"tf":1.0},"69":{"tf":1.4142135623730951},"84":{"tf":1.0}},"i":{"df":5,"docs":{"146":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"120":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":43,"docs":{"0":{"tf":1.0},"109":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"119":{"tf":2.0},"120":{"tf":1.4142135623730951},"124":{"tf":1.0},"130":{"tf":1.4142135623730951},"131":{"tf":1.7320508075688772},"132":{"tf":1.0},"133":{"tf":2.23606797749979},"134":{"tf":1.0},"135":{"tf":1.0},"138":{"tf":3.1622776601683795},"14":{"tf":1.0},"144":{"tf":1.4142135623730951},"146":{"tf":1.0},"147":{"tf":1.0},"148":{"tf":1.0},"15":{"tf":1.0},"154":{"tf":1.4142135623730951},"159":{"tf":1.0},"161":{"tf":1.0},"167":{"tf":1.7320508075688772},"172":{"tf":1.0},"174":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"212":{"tf":1.0},"22":{"tf":1.0},"226":{"tf":1.7320508075688772},"23":{"tf":1.0},"38":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"113":{"tf":1.0},"137":{"tf":1.0},"156":{"tf":1.0},"164":{"tf":1.0},"173":{"tf":1.0},"223":{"tf":1.0},"7":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"152":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":7,"docs":{"202":{"tf":1.0},"221":{"tf":1.0},"223":{"tf":1.4142135623730951},"226":{"tf":1.7320508075688772},"5":{"tf":1.0},"50":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":31,"docs":{"105":{"tf":1.0},"107":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":2.0},"114":{"tf":1.0},"116":{"tf":1.0},"122":{"tf":1.4142135623730951},"129":{"tf":2.0},"138":{"tf":2.23606797749979},"139":{"tf":1.0},"140":{"tf":1.4142135623730951},"141":{"tf":1.4142135623730951},"144":{"tf":1.4142135623730951},"145":{"tf":1.0},"147":{"tf":1.0},"148":{"tf":1.0},"155":{"tf":1.0},"161":{"tf":2.0},"165":{"tf":1.0},"166":{"tf":1.4142135623730951},"167":{"tf":1.0},"171":{"tf":1.0},"174":{"tf":1.4142135623730951},"176":{"tf":1.0},"194":{"tf":1.0},"196":{"tf":1.4142135623730951},"223":{"tf":1.4142135623730951},"226":{"tf":1.4142135623730951},"5":{"tf":1.0},"6":{"tf":1.0},"90":{"tf":1.0}},"i":{"c":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"161":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"161":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":9,"docs":{"109":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"171":{"tf":1.0},"176":{"tf":1.0},"200":{"tf":1.0},"203":{"tf":1.4142135623730951},"204":{"tf":1.0},"98":{"tf":1.0}}}},"i":{"b":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{},"t":{"@":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{":":{"<":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"102":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":17,"docs":{"102":{"tf":2.449489742783178},"104":{"tf":1.0},"105":{"tf":1.0},"133":{"tf":2.8284271247461903},"177":{"tf":2.6457513110645907},"178":{"tf":1.7320508075688772},"179":{"tf":2.23606797749979},"180":{"tf":1.4142135623730951},"182":{"tf":3.3166247903554},"183":{"tf":2.0},"186":{"tf":1.0},"188":{"tf":2.449489742783178},"189":{"tf":2.23606797749979},"190":{"tf":1.4142135623730951},"191":{"tf":1.7320508075688772},"192":{"tf":1.0},"203":{"tf":1.0}},"h":{"df":0,"docs":{},"u":{"b":{"df":3,"docs":{"182":{"tf":1.7320508075688772},"43":{"tf":1.0},"94":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"l":{"a":{"b":{"df":2,"docs":{"43":{"tf":1.0},"95":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":14,"docs":{"100":{"tf":1.4142135623730951},"119":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.0},"151":{"tf":1.0},"169":{"tf":1.0},"202":{"tf":1.0},"213":{"tf":2.0},"84":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}},"n":{"df":10,"docs":{"151":{"tf":1.0},"152":{"tf":1.0},"160":{"tf":1.0},"167":{"tf":1.4142135623730951},"174":{"tf":1.0},"214":{"tf":1.0},"223":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":1.4142135623730951},"5":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"152":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"107":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"o":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"210":{"tf":1.4142135623730951}}}},"df":10,"docs":{"1":{"tf":1.0},"127":{"tf":1.0},"130":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.4142135623730951},"164":{"tf":1.0},"167":{"tf":1.0},"173":{"tf":1.0},"177":{"tf":1.0},"214":{"tf":1.0}},"o":{"d":{"df":11,"docs":{"100":{"tf":1.0},"118":{"tf":1.0},"122":{"tf":1.0},"132":{"tf":1.0},"174":{"tf":1.0},"186":{"tf":1.4142135623730951},"200":{"tf":1.0},"226":{"tf":1.0},"229":{"tf":2.0},"230":{"tf":1.0},"85":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"2":{"df":1,"docs":{"43":{"tf":1.0}}},"3":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"d":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"138":{"tf":1.0},"146":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"144":{"tf":1.0},"145":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"119":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"229":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"225":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"p":{"df":3,"docs":{"186":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":22,"docs":{"112":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.4142135623730951},"131":{"tf":1.4142135623730951},"133":{"tf":1.7320508075688772},"134":{"tf":1.0},"202":{"tf":1.4142135623730951},"214":{"tf":1.0},"227":{"tf":1.0},"229":{"tf":2.23606797749979},"230":{"tf":1.0},"5":{"tf":4.795831523312719},"7":{"tf":1.7320508075688772},"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.7320508075688772},"90":{"tf":2.6457513110645907},"91":{"tf":1.7320508075688772},"92":{"tf":1.0}}}},"w":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"200":{"tf":1.0}}}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":4,"docs":{"100":{"tf":1.0},"138":{"tf":1.0},"176":{"tf":1.0},"202":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"135":{"tf":1.0}}}}},"i":{"d":{"df":14,"docs":{"107":{"tf":1.0},"109":{"tf":1.0},"119":{"tf":1.0},"127":{"tf":1.0},"130":{"tf":1.4142135623730951},"158":{"tf":1.0},"168":{"tf":1.0},"176":{"tf":1.0},"194":{"tf":1.0},"196":{"tf":1.0},"203":{"tf":1.0},"212":{"tf":1.0},"3":{"tf":1.0},"99":{"tf":1.4142135623730951}},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"106":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"111":{"tf":1.0},"116":{"tf":1.0},"125":{"tf":1.0},"132":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"h":{"a":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"100":{"tf":1.0},"101":{"tf":1.7320508075688772},"108":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"176":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"117":{"tf":1.0},"135":{"tf":1.0},"158":{"tf":1.0},"203":{"tf":1.0},"221":{"tf":1.0}},"l":{"df":6,"docs":{"111":{"tf":1.0},"131":{"tf":1.0},"200":{"tf":1.0},"203":{"tf":1.0},"225":{"tf":1.0},"230":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"192":{"tf":1.0},"202":{"tf":1.0}}}}}},"r":{"d":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"177":{"tf":1.0}}},"df":0,"docs":{}}},"df":8,"docs":{"108":{"tf":1.0},"189":{"tf":1.0},"200":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.0},"210":{"tf":1.7320508075688772},"214":{"tf":1.0},"223":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":4,"docs":{"17":{"tf":1.0},"182":{"tf":1.0},"186":{"tf":1.0},"188":{"tf":1.0}}},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"214":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":3,"docs":{"195":{"tf":1.0},"208":{"tf":1.0},"211":{"tf":1.0}},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"138":{"tf":1.0},"225":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":5,"docs":{"124":{"tf":1.0},"186":{"tf":1.0},"188":{"tf":1.4142135623730951},"189":{"tf":1.0},"190":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"186":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"228":{"tf":1.0}}}}}},"p":{"df":1,"docs":{"72":{"tf":1.0}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"224":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"97":{"tf":1.0}}}},"p":{"df":17,"docs":{"0":{"tf":1.0},"104":{"tf":1.0},"119":{"tf":1.0},"123":{"tf":1.0},"130":{"tf":1.0},"137":{"tf":1.0},"146":{"tf":2.0},"147":{"tf":1.0},"148":{"tf":2.8284271247461903},"184":{"tf":1.0},"186":{"tf":1.0},"203":{"tf":1.7320508075688772},"229":{"tf":2.23606797749979},"230":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"130":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"155":{"tf":1.0}}},"df":22,"docs":{"109":{"tf":1.0},"116":{"tf":1.4142135623730951},"119":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"130":{"tf":1.4142135623730951},"133":{"tf":1.0},"134":{"tf":1.0},"139":{"tf":1.0},"154":{"tf":1.0},"169":{"tf":1.0},"177":{"tf":1.0},"179":{"tf":1.0},"192":{"tf":1.0},"206":{"tf":1.0},"213":{"tf":1.0},"215":{"tf":1.0},"218":{"tf":1.4142135623730951},"220":{"tf":1.0},"41":{"tf":1.0},"7":{"tf":1.0},"97":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"130":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"211":{"tf":1.4142135623730951},"214":{"tf":1.0}},"i":{"df":3,"docs":{"112":{"tf":1.0},"223":{"tf":1.0},"227":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"h":{"df":6,"docs":{"100":{"tf":1.0},"107":{"tf":1.0},"123":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"100":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"204":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"146":{"tf":1.0}}}}}}}}},"r":{"'":{"df":1,"docs":{"223":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"<":{"'":{"_":{"df":2,"docs":{"163":{"tf":1.0},"170":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"163":{"tf":1.0},"170":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"154":{"tf":2.23606797749979}}}}},"df":0,"docs":{}},"df":15,"docs":{"107":{"tf":1.0},"109":{"tf":1.0},"118":{"tf":1.0},"123":{"tf":1.4142135623730951},"144":{"tf":1.0},"145":{"tf":1.0},"151":{"tf":1.0},"154":{"tf":1.0},"163":{"tf":1.0},"169":{"tf":1.0},"210":{"tf":2.0},"217":{"tf":1.0},"218":{"tf":1.0},"220":{"tf":1.4142135623730951},"222":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"177":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"202":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"u":{"df":1,"docs":{"100":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"104":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"94":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"3":{"0":{"0":{"0":{"df":1,"docs":{"196":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"<":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"182":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"102":{"tf":1.0},"178":{"tf":1.0},"183":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"106":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"229":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"147":{"tf":1.0},"223":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"161":{"tf":1.0}}}}}}}}}},"i":{"'":{"d":{"df":1,"docs":{"221":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":1,"docs":{"224":{"tf":1.0}}},"v":{"df":1,"docs":{"224":{"tf":1.0}}}},".":{"df":1,"docs":{"155":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"j":{"df":1,"docs":{"220":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"c":{"df":4,"docs":{"107":{"tf":1.0},"154":{"tf":1.0},"181":{"tf":1.0},"186":{"tf":1.4142135623730951}}},"d":{"df":5,"docs":{"100":{"tf":1.0},"145":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.7320508075688772},"172":{"tf":1.4142135623730951}},"e":{"a":{"df":5,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"186":{"tf":1.4142135623730951},"226":{"tf":1.4142135623730951},"229":{"tf":1.0}},"l":{"df":2,"docs":{"185":{"tf":1.0},"203":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"120":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":6,"docs":{"120":{"tf":1.4142135623730951},"163":{"tf":1.0},"213":{"tf":1.0},"26":{"tf":1.0},"43":{"tf":1.7320508075688772},"60":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":4,"docs":{"119":{"tf":1.0},"145":{"tf":1.0},"158":{"tf":1.0},"43":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"'":{"df":1,"docs":{"213":{"tf":1.0}}},"(":{"_":{"df":3,"docs":{"213":{"tf":2.8284271247461903},"221":{"tf":1.4142135623730951},"226":{"tf":1.7320508075688772}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"218":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"210":{"tf":1.4142135623730951},"221":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"_":{"df":1,"docs":{"226":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"226":{"tf":1.0}}}}}}},"df":1,"docs":{"226":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"210":{"tf":1.0},"213":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"_":{"df":1,"docs":{"226":{"tf":2.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"226":{"tf":1.0}}}}}}},"df":2,"docs":{"218":{"tf":1.0},"226":{"tf":1.0}}}}},"s":{"_":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":11,"docs":{"120":{"tf":1.0},"138":{"tf":1.0},"165":{"tf":1.0},"167":{"tf":1.7320508075688772},"174":{"tf":1.0},"21":{"tf":1.4142135623730951},"23":{"tf":1.0},"36":{"tf":1.4142135623730951},"51":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"137":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"95":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"138":{"tf":1.0}}}}},"df":3,"docs":{"140":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"105":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"211":{"tf":1.0}}}},"l":{"<":{"'":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"x":{"df":7,"docs":{"121":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"170":{"tf":1.0},"173":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"164":{"tf":1.0},"173":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"164":{"tf":1.0},"173":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"164":{"tf":1.0},"173":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":2,"docs":{"164":{"tf":1.0},"173":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"!":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"129":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":19,"docs":{"113":{"tf":1.4142135623730951},"116":{"tf":1.0},"119":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951},"121":{"tf":1.0},"129":{"tf":2.449489742783178},"138":{"tf":1.4142135623730951},"152":{"tf":1.0},"153":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"162":{"tf":1.0},"164":{"tf":1.7320508075688772},"169":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"212":{"tf":1.0},"220":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":37,"docs":{"113":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.7320508075688772},"120":{"tf":1.4142135623730951},"122":{"tf":1.4142135623730951},"123":{"tf":1.0},"126":{"tf":1.0},"129":{"tf":1.0},"134":{"tf":1.0},"136":{"tf":1.0},"138":{"tf":1.4142135623730951},"145":{"tf":1.4142135623730951},"146":{"tf":2.449489742783178},"149":{"tf":1.0},"155":{"tf":1.0},"157":{"tf":1.4142135623730951},"158":{"tf":1.0},"159":{"tf":1.7320508075688772},"160":{"tf":1.7320508075688772},"161":{"tf":2.6457513110645907},"164":{"tf":1.7320508075688772},"168":{"tf":1.0},"169":{"tf":1.0},"172":{"tf":1.4142135623730951},"199":{"tf":1.0},"202":{"tf":2.23606797749979},"203":{"tf":1.7320508075688772},"211":{"tf":1.4142135623730951},"212":{"tf":1.0},"215":{"tf":1.4142135623730951},"218":{"tf":1.4142135623730951},"220":{"tf":2.8284271247461903},"221":{"tf":1.4142135623730951},"222":{"tf":2.23606797749979},"224":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":3.1622776601683795}},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"158":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"c":{"df":0,"docs":{},"x":{"df":4,"docs":{"158":{"tf":1.0},"159":{"tf":1.0},"161":{"tf":1.0},"172":{"tf":1.0}}}},"df":0,"docs":{}},"df":4,"docs":{"130":{"tf":1.0},"159":{"tf":1.0},"161":{"tf":1.0},"172":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"127":{"tf":1.0}}}}}}}}},"df":1,"docs":{"45":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"223":{"tf":1.4142135623730951}}}}}}},"df":3,"docs":{"138":{"tf":1.0},"148":{"tf":1.0},"5":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"<":{"'":{"_":{"df":2,"docs":{"164":{"tf":1.0},"173":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"164":{"tf":1.0}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":2,"docs":{"164":{"tf":1.0},"173":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":14,"docs":{"116":{"tf":1.4142135623730951},"118":{"tf":1.0},"132":{"tf":1.0},"143":{"tf":1.0},"154":{"tf":1.0},"175":{"tf":1.0},"201":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.0},"225":{"tf":1.0},"29":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"5":{"tf":1.0},"82":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"165":{"tf":1.0},"174":{"tf":1.0},"223":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":13,"docs":{"0":{"tf":1.0},"124":{"tf":1.0},"150":{"tf":1.0},"186":{"tf":1.4142135623730951},"197":{"tf":1.0},"199":{"tf":1.4142135623730951},"202":{"tf":2.0},"203":{"tf":2.23606797749979},"210":{"tf":1.0},"226":{"tf":1.0},"5":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}}}}}},"n":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"134":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"(":{"c":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"167":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"174":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":2,"docs":{"130":{"tf":1.0},"167":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"(":{"#":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"226":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"229":{"tf":1.7320508075688772},"230":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":22,"docs":{"0":{"tf":1.7320508075688772},"101":{"tf":1.0},"126":{"tf":1.0},"128":{"tf":1.0},"133":{"tf":1.4142135623730951},"146":{"tf":1.4142135623730951},"151":{"tf":1.0},"153":{"tf":1.0},"169":{"tf":1.0},"185":{"tf":1.0},"186":{"tf":1.7320508075688772},"190":{"tf":1.0},"202":{"tf":1.0},"228":{"tf":1.0},"229":{"tf":1.0},"27":{"tf":1.7320508075688772},"5":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"7":{"tf":1.0},"78":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}},"e":{"!":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"a":{"df":0,"docs":{},"t":{"!":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"!":{"(":{"\"":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":1,"docs":{"147":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"223":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"221":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"147":{"tf":1.0},"166":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"177":{"tf":1.0},"203":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"226":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"152":{"tf":1.0},"161":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"210":{"tf":1.0},"220":{"tf":1.0},"222":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"x":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"58":{"tf":1.0},"62":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"158":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"i":{"c":{"df":8,"docs":{"147":{"tf":1.0},"21":{"tf":1.0},"212":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"31":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"203":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"203":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":29,"docs":{"104":{"tf":1.0},"111":{"tf":1.0},"118":{"tf":1.4142135623730951},"119":{"tf":1.0},"131":{"tf":1.0},"138":{"tf":1.0},"143":{"tf":1.4142135623730951},"144":{"tf":1.4142135623730951},"145":{"tf":2.0},"146":{"tf":1.0},"148":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":1.0},"154":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.0},"166":{"tf":1.0},"169":{"tf":1.0},"176":{"tf":1.0},"196":{"tf":1.0},"211":{"tf":1.0},"218":{"tf":1.0},"220":{"tf":1.0},"223":{"tf":1.0},"226":{"tf":1.0},"230":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951},"92":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"175":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"116":{"tf":1.0},"121":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"152":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"210":{"tf":1.4142135623730951},"221":{"tf":1.0}}},"df":0,"docs":{}}}},"df":3,"docs":{"221":{"tf":1.4142135623730951},"223":{"tf":1.0},"226":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"115":{"tf":1.0},"142":{"tf":1.0}}}},"df":2,"docs":{"163":{"tf":1.0},"219":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":9,"docs":{"146":{"tf":1.0},"154":{"tf":1.4142135623730951},"166":{"tf":1.0},"167":{"tf":1.4142135623730951},"174":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.0},"65":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"145":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"211":{"tf":1.0},"224":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":9,"docs":{"1":{"tf":2.23606797749979},"101":{"tf":1.0},"108":{"tf":2.8284271247461903},"125":{"tf":1.4142135623730951},"195":{"tf":1.7320508075688772},"2":{"tf":1.4142135623730951},"3":{"tf":1.0},"4":{"tf":1.4142135623730951},"94":{"tf":1.0}}},"n":{"c":{"df":7,"docs":{"131":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"167":{"tf":1.0},"179":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":18,"docs":{"112":{"tf":1.4142135623730951},"124":{"tf":1.0},"133":{"tf":1.4142135623730951},"134":{"tf":1.0},"147":{"tf":1.0},"148":{"tf":1.0},"163":{"tf":1.0},"177":{"tf":1.4142135623730951},"211":{"tf":1.4142135623730951},"214":{"tf":1.0},"226":{"tf":1.0},"30":{"tf":1.0},"45":{"tf":1.0},"63":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.0},"86":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"195":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"(":{"_":{"df":3,"docs":{"213":{"tf":1.0},"214":{"tf":1.0},"226":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"u":{"1":{"2":{"8":{"df":1,"docs":{"218":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"153":{"tf":1.0},"223":{"tf":1.0}},"e":{"df":0,"docs":{},"g":{"df":2,"docs":{"213":{"tf":1.0},"214":{"tf":1.7320508075688772}},"r":{"df":3,"docs":{"203":{"tf":1.4142135623730951},"222":{"tf":1.0},"93":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"j":{"df":1,"docs":{"104":{"tf":1.7320508075688772}}}}}},"n":{"d":{"df":3,"docs":{"103":{"tf":1.0},"214":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":2,"docs":{"5":{"tf":1.0},"90":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"86":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":13,"docs":{"100":{"tf":1.0},"113":{"tf":1.0},"140":{"tf":1.0},"152":{"tf":1.0},"161":{"tf":1.4142135623730951},"197":{"tf":1.0},"199":{"tf":1.0},"203":{"tf":1.7320508075688772},"229":{"tf":1.0},"230":{"tf":1.0},"7":{"tf":1.0},"92":{"tf":1.0},"97":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.4142135623730951}}}}},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"107":{"tf":1.4142135623730951},"123":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":10,"docs":{"107":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"130":{"tf":1.4142135623730951},"131":{"tf":1.4142135623730951},"201":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.7320508075688772},"210":{"tf":1.0},"36":{"tf":1.0}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"147":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"99":{"tf":1.7320508075688772}}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":6,"docs":{"158":{"tf":1.0},"202":{"tf":1.0},"209":{"tf":1.0},"217":{"tf":1.0},"223":{"tf":1.4142135623730951},"226":{"tf":1.4142135623730951}},"t":{"df":1,"docs":{"99":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"99":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"174":{"tf":1.0}}}},"o":{"c":{"df":2,"docs":{"144":{"tf":1.0},"162":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":1,"docs":{"145":{"tf":1.0}}},"l":{"df":0,"docs":{},"v":{"df":3,"docs":{"131":{"tf":1.0},"177":{"tf":1.0},"31":{"tf":1.0}}}}}}},"o":{"df":1,"docs":{"43":{"tf":1.0}}},"p":{"df":0,"docs":{},"v":{"4":{"df":1,"docs":{"43":{"tf":1.0}}},"6":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":1,"docs":{"99":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"202":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"186":{"tf":1.4142135623730951}}}}}}}},"s":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"152":{"tf":1.0}}}}}}},"df":1,"docs":{"152":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":1,"docs":{"152":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"120":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"120":{"tf":1.0}}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"220":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"(":{"c":{"df":0,"docs":{},"x":{"df":2,"docs":{"163":{"tf":1.0},"172":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"172":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"(":{"c":{"df":0,"docs":{},"x":{"df":3,"docs":{"164":{"tf":1.0},"171":{"tf":1.0},"173":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"130":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"(":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"171":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"171":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"<":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"220":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":1,"docs":{"220":{"tf":1.0}}}},"df":4,"docs":{"217":{"tf":1.7320508075688772},"220":{"tf":2.23606797749979},"222":{"tf":1.7320508075688772},"226":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"'":{"df":0,"docs":{},"t":{"df":4,"docs":{"124":{"tf":1.0},"214":{"tf":1.0},"219":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":17,"docs":{"0":{"tf":1.0},"134":{"tf":1.0},"137":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"147":{"tf":1.0},"166":{"tf":1.0},"186":{"tf":1.0},"200":{"tf":1.0},"201":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":2.23606797749979},"204":{"tf":2.8284271247461903},"223":{"tf":1.0},"228":{"tf":1.0},"229":{"tf":2.449489742783178},"5":{"tf":1.4142135623730951}},"e":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"130":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"t":{"'":{"df":18,"docs":{"100":{"tf":1.4142135623730951},"123":{"tf":1.0},"163":{"tf":1.0},"177":{"tf":1.0},"185":{"tf":1.0},"186":{"tf":1.4142135623730951},"20":{"tf":1.0},"203":{"tf":1.0},"210":{"tf":1.4142135623730951},"211":{"tf":1.4142135623730951},"212":{"tf":1.0},"214":{"tf":1.0},"218":{"tf":1.0},"221":{"tf":1.4142135623730951},"229":{"tf":1.0},"230":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"'":{"df":2,"docs":{"148":{"tf":1.0},"27":{"tf":1.4142135623730951}}},"df":20,"docs":{"122":{"tf":1.0},"123":{"tf":1.0},"131":{"tf":1.0},"148":{"tf":1.0},"153":{"tf":1.0},"156":{"tf":1.0},"157":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951},"159":{"tf":2.0},"160":{"tf":1.7320508075688772},"164":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"171":{"tf":2.23606797749979},"172":{"tf":2.6457513110645907},"173":{"tf":1.0},"208":{"tf":1.0},"27":{"tf":1.0},"37":{"tf":1.4142135623730951},"61":{"tf":1.7320508075688772}}},"r":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"v":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"160":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":6,"docs":{"113":{"tf":1.0},"137":{"tf":1.4142135623730951},"158":{"tf":1.0},"163":{"tf":1.0},"172":{"tf":1.0},"45":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":7,"docs":{"120":{"tf":1.0},"121":{"tf":1.0},"129":{"tf":1.0},"223":{"tf":1.4142135623730951},"226":{"tf":1.0},"5":{"tf":1.0},"90":{"tf":1.0}}}}}}}},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"26":{"tf":1.0}},"o":{"b":{"df":3,"docs":{"88":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"203":{"tf":1.7320508075688772},"228":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"131":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":3,"docs":{"151":{"tf":1.0},"169":{"tf":1.0},"99":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"181":{"tf":1.0},"91":{"tf":1.0}}}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":9,"docs":{"113":{"tf":1.0},"134":{"tf":1.0},"138":{"tf":1.0},"174":{"tf":1.0},"176":{"tf":1.0},"186":{"tf":1.0},"228":{"tf":1.0},"229":{"tf":1.0},"5":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"120":{"tf":1.0}}}},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}}}}}},"i":{"b":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{},"n":{"d":{"df":8,"docs":{"129":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.7320508075688772},"161":{"tf":1.0},"162":{"tf":1.0},"169":{"tf":1.0},"210":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":10,"docs":{"144":{"tf":1.4142135623730951},"147":{"tf":1.0},"148":{"tf":1.4142135623730951},"154":{"tf":1.0},"164":{"tf":1.0},"203":{"tf":1.0},"212":{"tf":1.0},"223":{"tf":1.7320508075688772},"225":{"tf":1.0},"89":{"tf":1.0}},"n":{"df":3,"docs":{"203":{"tf":1.0},"211":{"tf":1.0},"223":{"tf":1.0}}}}}}},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":5,"docs":{"119":{"tf":1.0},"138":{"tf":1.0},"186":{"tf":1.7320508075688772},"228":{"tf":1.4142135623730951},"229":{"tf":1.7320508075688772}}}}},"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"130":{"tf":1.0},"200":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"181":{"tf":1.0},"183":{"tf":1.0}}},"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"#":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"106":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"229":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"122":{"tf":1.0}}}}}},"/":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"179":{"tf":1.0},"183":{"tf":1.0}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":17,"docs":{"102":{"tf":1.4142135623730951},"160":{"tf":1.0},"175":{"tf":1.4142135623730951},"176":{"tf":2.0},"177":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":2.0},"180":{"tf":2.0},"183":{"tf":1.0},"186":{"tf":1.0},"188":{"tf":1.4142135623730951},"190":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.0},"203":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.0}}}}}}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}}}}}},"df":4,"docs":{"157":{"tf":1.0},"159":{"tf":1.0},"171":{"tf":1.4142135623730951},"172":{"tf":2.23606797749979}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{":":{":":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"171":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"a":{"df":0,"docs":{},"g":{"df":12,"docs":{"0":{"tf":1.0},"146":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"200":{"tf":1.0},"209":{"tf":1.0},"211":{"tf":1.4142135623730951},"226":{"tf":2.23606797749979},"5":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.4142135623730951}},"e":{"'":{"df":1,"docs":{"99":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"52":{"tf":1.0},"72":{"tf":1.0}},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"50":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"k":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"b":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":2,"docs":{"34":{"tf":1.0},"63":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"r":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"116":{"tf":1.0},"121":{"tf":1.0},"171":{"tf":1.0},"188":{"tf":1.0},"213":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"145":{"tf":1.0},"159":{"tf":1.0}}},".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"151":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"/":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"121":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"151":{"tf":1.0},"169":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"<":{"'":{"_":{"df":8,"docs":{"152":{"tf":1.0},"153":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"169":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0}}},"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"x":{"df":7,"docs":{"121":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"170":{"tf":1.0},"173":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":7,"docs":{"145":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.4142135623730951},"155":{"tf":1.0},"158":{"tf":1.0},"167":{"tf":1.0},"169":{"tf":1.0}}}}}}}}},"df":3,"docs":{"133":{"tf":1.0},"135":{"tf":1.4142135623730951},"146":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"<":{"'":{"_":{"df":8,"docs":{"152":{"tf":1.0},"153":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"169":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0}}},"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"x":{"df":7,"docs":{"121":{"tf":1.0},"146":{"tf":1.4142135623730951},"147":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"170":{"tf":1.0},"173":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":14,"docs":{"118":{"tf":1.7320508075688772},"130":{"tf":1.4142135623730951},"143":{"tf":1.4142135623730951},"144":{"tf":1.0},"145":{"tf":2.8284271247461903},"146":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.4142135623730951},"167":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"222":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"r":{"df":9,"docs":{"111":{"tf":1.0},"119":{"tf":1.0},"121":{"tf":1.0},"138":{"tf":1.0},"141":{"tf":1.0},"146":{"tf":1.0},"201":{"tf":1.0},"212":{"tf":1.0},"221":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":6,"docs":{"102":{"tf":1.4142135623730951},"176":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.0},"94":{"tf":1.4142135623730951},"95":{"tf":1.0}}}},"x":{"df":1,"docs":{"43":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"154":{"tf":1.0}}}}}},"y":{"df":1,"docs":{"199":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"137":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":5,"docs":{"134":{"tf":1.0},"141":{"tf":1.0},"202":{"tf":1.4142135623730951},"221":{"tf":1.0},"226":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"230":{"tf":1.0}}}},"v":{"df":1,"docs":{"186":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{".":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"167":{"tf":1.0},"174":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":4,"docs":{"167":{"tf":1.0},"175":{"tf":1.0},"223":{"tf":1.0},"93":{"tf":1.0}}}},"g":{"a":{"c":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"41":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"58":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"118":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.0}}}},"t":{"'":{"df":6,"docs":{"113":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.4142135623730951},"133":{"tf":1.0},"152":{"tf":1.0},"161":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":18,"docs":{"0":{"tf":1.7320508075688772},"100":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"116":{"tf":1.0},"123":{"tf":1.0},"127":{"tf":1.0},"144":{"tf":1.4142135623730951},"145":{"tf":1.4142135623730951},"154":{"tf":1.0},"166":{"tf":1.0},"196":{"tf":1.0},"202":{"tf":1.0},"212":{"tf":1.0},"216":{"tf":1.0},"5":{"tf":2.0},"7":{"tf":1.0},"84":{"tf":1.0},"99":{"tf":1.4142135623730951}}},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"137":{"tf":1.0}}}},"df":0,"docs":{}}}},"x":{"df":2,"docs":{"144":{"tf":1.0},"99":{"tf":1.0}}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":1,"docs":{"129":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"227":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"228":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"154":{"tf":1.0},"161":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":7,"docs":{"145":{"tf":1.0},"177":{"tf":1.4142135623730951},"211":{"tf":1.0},"221":{"tf":1.0},"63":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"e":{"df":13,"docs":{"116":{"tf":1.0},"138":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":2.0},"174":{"tf":1.0},"177":{"tf":1.0},"193":{"tf":1.4142135623730951},"202":{"tf":1.0},"5":{"tf":1.4142135623730951},"7":{"tf":1.0},"74":{"tf":1.4142135623730951}}},"k":{"df":6,"docs":{"108":{"tf":1.0},"130":{"tf":1.0},"156":{"tf":1.4142135623730951},"168":{"tf":1.0},"186":{"tf":1.7320508075688772},"7":{"tf":1.0}},"e":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"t":{"'":{"df":3,"docs":{"109":{"tf":1.0},"121":{"tf":1.4142135623730951},"146":{"tf":1.0}}},"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":5,"docs":{"129":{"tf":1.7320508075688772},"134":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}},"e":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"139":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"101":{"tf":1.0},"105":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":165,"docs":{"0":{"tf":4.0},"10":{"tf":1.7320508075688772},"100":{"tf":2.6457513110645907},"101":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.7320508075688772},"105":{"tf":1.4142135623730951},"109":{"tf":4.0},"11":{"tf":1.0},"111":{"tf":2.23606797749979},"112":{"tf":3.1622776601683795},"113":{"tf":3.1622776601683795},"114":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"116":{"tf":3.7416573867739413},"117":{"tf":3.1622776601683795},"118":{"tf":2.23606797749979},"119":{"tf":2.8284271247461903},"12":{"tf":1.0},"120":{"tf":2.6457513110645907},"121":{"tf":3.1622776601683795},"122":{"tf":2.23606797749979},"123":{"tf":1.4142135623730951},"124":{"tf":3.1622776601683795},"126":{"tf":1.0},"127":{"tf":2.6457513110645907},"128":{"tf":1.4142135623730951},"129":{"tf":3.605551275463989},"13":{"tf":1.4142135623730951},"130":{"tf":2.449489742783178},"131":{"tf":3.7416573867739413},"132":{"tf":2.449489742783178},"133":{"tf":4.58257569495584},"134":{"tf":2.6457513110645907},"135":{"tf":2.8284271247461903},"136":{"tf":1.4142135623730951},"137":{"tf":2.449489742783178},"138":{"tf":3.7416573867739413},"139":{"tf":1.4142135623730951},"14":{"tf":1.0},"140":{"tf":2.6457513110645907},"141":{"tf":1.7320508075688772},"142":{"tf":1.0},"143":{"tf":1.4142135623730951},"144":{"tf":3.1622776601683795},"145":{"tf":2.449489742783178},"146":{"tf":5.291502622129181},"147":{"tf":2.6457513110645907},"148":{"tf":1.4142135623730951},"149":{"tf":1.4142135623730951},"15":{"tf":1.0},"150":{"tf":1.4142135623730951},"151":{"tf":1.0},"157":{"tf":1.0},"16":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.0},"166":{"tf":2.23606797749979},"167":{"tf":2.0},"168":{"tf":1.4142135623730951},"169":{"tf":1.0},"17":{"tf":1.0},"174":{"tf":2.449489742783178},"18":{"tf":1.0},"181":{"tf":1.0},"186":{"tf":2.23606797749979},"19":{"tf":1.0},"197":{"tf":1.4142135623730951},"20":{"tf":1.0},"202":{"tf":3.605551275463989},"203":{"tf":2.6457513110645907},"204":{"tf":1.0},"209":{"tf":1.0},"21":{"tf":1.0},"210":{"tf":3.1622776601683795},"211":{"tf":1.0},"212":{"tf":1.0},"214":{"tf":2.449489742783178},"215":{"tf":1.4142135623730951},"22":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":2.23606797749979},"222":{"tf":2.449489742783178},"223":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":3.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":5.477225575051661},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":5.0990195135927845},"70":{"tf":1.4142135623730951},"71":{"tf":2.0},"72":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.7320508075688772},"79":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":3.1622776601683795},"85":{"tf":2.23606797749979},"86":{"tf":3.0},"87":{"tf":1.7320508075688772},"88":{"tf":1.4142135623730951},"89":{"tf":2.0},"9":{"tf":1.0},"90":{"tf":1.7320508075688772},"91":{"tf":2.449489742783178},"93":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"95":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"224":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"146":{"tf":1.0},"147":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"121":{"tf":1.4142135623730951},"146":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"202":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":34,"docs":{"104":{"tf":1.0},"107":{"tf":1.4142135623730951},"113":{"tf":1.0},"116":{"tf":1.0},"121":{"tf":1.0},"124":{"tf":1.0},"129":{"tf":1.0},"133":{"tf":1.0},"138":{"tf":1.0},"172":{"tf":1.0},"203":{"tf":1.4142135623730951},"204":{"tf":1.0},"208":{"tf":1.0},"21":{"tf":1.4142135623730951},"226":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":2.0},"46":{"tf":1.0},"5":{"tf":1.4142135623730951},"51":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.0},"84":{"tf":1.0}}}},"t":{"(":{"!":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"_":{"df":1,"docs":{"226":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"_":{"#":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"214":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},")":{"*":{"#":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"214":{"tf":1.0}}}}}},"df":0,"docs":{}},"+":{"#":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"225":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"{":{"1":{"0":{"df":1,"docs":{"213":{"tf":1.0}}},"df":0,"docs":{}},"5":{",":{"1":{"0":{"df":1,"docs":{"213":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":3,"docs":{"213":{"tf":1.4142135623730951},"219":{"tf":1.0},"225":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"218":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"_":{")":{")":{"df":0,"docs":{},"{":{"1":{"0":{"df":1,"docs":{"213":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"213":{"tf":1.7320508075688772},"219":{"tf":1.0}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":3,"docs":{"212":{"tf":1.4142135623730951},"213":{"tf":1.4142135623730951},"226":{"tf":1.4142135623730951}},"e":{")":{")":{"df":0,"docs":{},"{":{"2":{"df":1,"docs":{"226":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"213":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"(":{"'":{"df":0,"docs":{},"x":{"'":{")":{")":{"df":0,"docs":{},"{":{"2":{"df":1,"docs":{"213":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"213":{"tf":1.0}}}},"_":{"#":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"213":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{")":{"#":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{")":{"#":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"214":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},")":{"#":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"213":{"tf":1.0}}}}}},")":{"#":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"213":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"_":{"#":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"213":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},")":{")":{"#":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"213":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"213":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"210":{"tf":1.0}}},"df":0,"docs":{}}}},":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"220":{"tf":1.0}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"220":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"220":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":6,"docs":{"213":{"tf":2.23606797749979},"214":{"tf":1.0},"218":{"tf":1.0},"219":{"tf":2.0},"220":{"tf":1.4142135623730951},"226":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":8,"docs":{"210":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":4.123105625617661},"214":{"tf":2.6457513110645907},"225":{"tf":1.4142135623730951},"226":{"tf":1.7320508075688772},"53":{"tf":1.4142135623730951},"78":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"131":{"tf":1.0}}}}},"l":{"df":2,"docs":{"138":{"tf":1.7320508075688772},"147":{"tf":1.0}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":13,"docs":{"115":{"tf":1.4142135623730951},"116":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"142":{"tf":1.0},"177":{"tf":1.0},"178":{"tf":1.4142135623730951},"179":{"tf":1.0},"188":{"tf":1.0},"195":{"tf":1.4142135623730951},"196":{"tf":1.0},"86":{"tf":1.0},"96":{"tf":1.0}}},"t":{"df":2,"docs":{"109":{"tf":1.0},"112":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":4,"docs":{"105":{"tf":1.4142135623730951},"186":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0}},"i":{"c":{"df":10,"docs":{"109":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.4142135623730951},"136":{"tf":1.0},"138":{"tf":1.7320508075688772},"143":{"tf":1.0},"146":{"tf":1.7320508075688772},"149":{"tf":1.0},"165":{"tf":1.0},"211":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"197":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"203":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":28,"docs":{"101":{"tf":1.0},"111":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"134":{"tf":1.0},"138":{"tf":1.0},"144":{"tf":1.4142135623730951},"145":{"tf":1.4142135623730951},"146":{"tf":1.7320508075688772},"147":{"tf":1.4142135623730951},"148":{"tf":1.0},"152":{"tf":1.7320508075688772},"159":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"167":{"tf":1.0},"172":{"tf":1.0},"186":{"tf":1.4142135623730951},"210":{"tf":1.0},"218":{"tf":1.0},"220":{"tf":1.4142135623730951},"223":{"tf":1.7320508075688772},"225":{"tf":1.0},"226":{"tf":1.4142135623730951},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0}}},"p":{"df":3,"docs":{"131":{"tf":1.0},"133":{"tf":1.0},"45":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"204":{"tf":1.0}}},"s":{"df":1,"docs":{"203":{"tf":1.0}}}},"t":{"df":9,"docs":{"130":{"tf":1.0},"146":{"tf":1.0},"174":{"tf":1.0},"210":{"tf":1.0},"211":{"tf":1.0},"214":{"tf":1.0},"221":{"tf":1.0},"223":{"tf":1.7320508075688772},"226":{"tf":1.0}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"154":{"tf":1.4142135623730951}}}}},"df":6,"docs":{"118":{"tf":1.0},"121":{"tf":1.0},"144":{"tf":1.0},"217":{"tf":1.4142135623730951},"219":{"tf":1.4142135623730951},"53":{"tf":1.0}}}}}}},"m":{"!":{"(":{"df":0,"docs":{},"x":{"df":2,"docs":{"167":{"tf":1.4142135623730951},"174":{"tf":1.0}}}},"df":0,"docs":{}},"a":{"c":{"df":2,"docs":{"167":{"tf":1.0},"174":{"tf":1.0}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"148":{"tf":1.0}}}}},"o":{"df":1,"docs":{"43":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"166":{"tf":1.4142135623730951}}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"167":{"tf":1.4142135623730951},"174":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"167":{"tf":1.0}}}}},"df":22,"docs":{"116":{"tf":1.0},"121":{"tf":1.0},"126":{"tf":1.0},"129":{"tf":1.0},"134":{"tf":1.7320508075688772},"147":{"tf":1.0},"163":{"tf":1.0},"165":{"tf":2.0},"166":{"tf":2.8284271247461903},"167":{"tf":4.123105625617661},"168":{"tf":1.0},"174":{"tf":3.605551275463989},"19":{"tf":1.0},"210":{"tf":1.0},"212":{"tf":1.7320508075688772},"214":{"tf":1.4142135623730951},"219":{"tf":1.0},"223":{"tf":1.0},"226":{"tf":1.0},"39":{"tf":1.4142135623730951},"69":{"tf":2.0},"83":{"tf":1.7320508075688772}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"e":{"df":6,"docs":{"105":{"tf":1.0},"176":{"tf":1.0},"196":{"tf":1.0},"203":{"tf":1.0},"71":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"148":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"113":{"tf":1.0},"138":{"tf":1.0},"148":{"tf":1.0},"217":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"227":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"131":{"tf":1.0},"175":{"tf":1.0},"197":{"tf":1.0},"199":{"tf":1.0},"223":{"tf":1.0},"230":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"203":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"201":{"tf":1.0},"203":{"tf":1.0},"210":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":41,"docs":{"102":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.0},"114":{"tf":1.0},"118":{"tf":1.4142135623730951},"120":{"tf":1.0},"121":{"tf":1.0},"125":{"tf":1.0},"128":{"tf":1.0},"132":{"tf":1.4142135623730951},"141":{"tf":1.0},"143":{"tf":1.0},"160":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"177":{"tf":2.0},"178":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.0},"182":{"tf":1.0},"183":{"tf":1.4142135623730951},"186":{"tf":2.0},"188":{"tf":1.0},"192":{"tf":1.0},"194":{"tf":1.4142135623730951},"196":{"tf":1.4142135623730951},"197":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.7320508075688772},"210":{"tf":1.0},"214":{"tf":1.0},"222":{"tf":1.4142135623730951},"226":{"tf":1.0},"227":{"tf":1.0},"229":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"1":{"tf":1.0},"202":{"tf":1.4142135623730951},"203":{"tf":1.4142135623730951},"204":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":6,"docs":{"152":{"tf":1.0},"159":{"tf":1.0},"202":{"tf":1.0},"5":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"0":{"tf":1.0},"113":{"tf":1.7320508075688772},"140":{"tf":1.7320508075688772},"36":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"230":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"l":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}},"c":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"_":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"i":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":2,"docs":{"54":{"tf":1.0},"62":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"121":{"tf":1.0},"62":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":13,"docs":{"109":{"tf":1.0},"115":{"tf":1.4142135623730951},"117":{"tf":1.0},"129":{"tf":1.4142135623730951},"135":{"tf":1.4142135623730951},"142":{"tf":1.4142135623730951},"177":{"tf":1.0},"186":{"tf":1.0},"211":{"tf":1.0},"222":{"tf":1.0},"223":{"tf":1.0},"229":{"tf":1.0},"5":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"121":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"y":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"p":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":2,"docs":{"159":{"tf":1.0},"172":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":3,"docs":{"116":{"tf":1.0},"163":{"tf":1.0},"7":{"tf":1.0}}},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":3,"docs":{"194":{"tf":1.0},"195":{"tf":1.0},"196":{"tf":1.0}}}}}},"df":1,"docs":{"64":{"tf":1.0}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"81":{"tf":1.4142135623730951}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"102":{"tf":2.23606797749979},"180":{"tf":1.7320508075688772},"186":{"tf":1.0},"188":{"tf":2.23606797749979}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"(":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"171":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"171":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"174":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"(":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"160":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"160":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":21,"docs":{"120":{"tf":1.0},"121":{"tf":1.0},"124":{"tf":1.0},"131":{"tf":1.0},"153":{"tf":1.7320508075688772},"163":{"tf":2.0},"169":{"tf":1.4142135623730951},"174":{"tf":1.0},"210":{"tf":2.0},"211":{"tf":2.6457513110645907},"212":{"tf":2.449489742783178},"213":{"tf":5.477225575051661},"214":{"tf":3.4641016151377544},"217":{"tf":1.0},"220":{"tf":2.23606797749979},"221":{"tf":2.6457513110645907},"222":{"tf":1.4142135623730951},"223":{"tf":2.0},"225":{"tf":2.8284271247461903},"226":{"tf":2.6457513110645907},"54":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"!":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"152":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"119":{"tf":1.0},"146":{"tf":1.0}}}}}},"x":{"df":6,"docs":{"10":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":21,"docs":{"10":{"tf":1.0},"33":{"tf":1.0},"38":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"81":{"tf":1.0},"93":{"tf":1.0}}}}}}},"y":{"b":{"df":1,"docs":{"130":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"145":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":4,"docs":{"194":{"tf":1.4142135623730951},"195":{"tf":2.0},"196":{"tf":1.7320508075688772},"203":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":4,"docs":{"167":{"tf":2.0},"174":{"tf":1.0},"179":{"tf":1.0},"182":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":17,"docs":{"107":{"tf":1.4142135623730951},"118":{"tf":1.0},"144":{"tf":1.7320508075688772},"145":{"tf":1.0},"161":{"tf":1.0},"166":{"tf":1.4142135623730951},"203":{"tf":2.0},"210":{"tf":1.0},"213":{"tf":1.0},"222":{"tf":1.0},"230":{"tf":1.0},"31":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.0},"99":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"119":{"tf":1.0},"120":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"113":{"tf":1.0}}}}}}}}},"t":{"df":1,"docs":{"5":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"176":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"138":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"203":{"tf":2.0},"204":{"tf":1.0},"230":{"tf":1.4142135623730951}}}},"m":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":11,"docs":{"132":{"tf":1.0},"183":{"tf":1.0},"187":{"tf":1.0},"199":{"tf":1.4142135623730951},"200":{"tf":1.0},"201":{"tf":1.0},"203":{"tf":3.0},"227":{"tf":1.0},"229":{"tf":1.7320508075688772},"230":{"tf":1.7320508075688772},"5":{"tf":1.0}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"229":{"tf":1.0},"230":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"144":{"tf":1.0},"163":{"tf":1.0},"203":{"tf":1.4142135623730951},"227":{"tf":1.0},"99":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"229":{"tf":1.0},"230":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"199":{"tf":1.0}}}}}}}}}},"r":{"df":0,"docs":{},"g":{"df":10,"docs":{"106":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"179":{"tf":2.0},"183":{"tf":1.0},"186":{"tf":1.4142135623730951},"188":{"tf":1.0},"189":{"tf":1.4142135623730951},"190":{"tf":1.0},"192":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":8,"docs":{"103":{"tf":1.0},"119":{"tf":2.0},"146":{"tf":2.449489742783178},"147":{"tf":1.0},"148":{"tf":2.0},"149":{"tf":1.0},"179":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"129":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"83":{"tf":1.0}},"i":{"df":1,"docs":{"83":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"164":{"tf":1.0},"173":{"tf":1.0}}}},"df":0,"docs":{}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"163":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":33,"docs":{"113":{"tf":1.7320508075688772},"117":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.4142135623730951},"121":{"tf":1.0},"129":{"tf":1.0},"131":{"tf":1.0},"135":{"tf":1.0},"138":{"tf":1.7320508075688772},"144":{"tf":1.4142135623730951},"145":{"tf":1.7320508075688772},"146":{"tf":2.6457513110645907},"151":{"tf":1.7320508075688772},"152":{"tf":1.4142135623730951},"153":{"tf":1.4142135623730951},"154":{"tf":1.0},"155":{"tf":1.4142135623730951},"159":{"tf":1.4142135623730951},"160":{"tf":1.0},"161":{"tf":1.7320508075688772},"162":{"tf":2.0},"163":{"tf":2.8284271247461903},"164":{"tf":2.6457513110645907},"167":{"tf":2.0},"168":{"tf":1.4142135623730951},"169":{"tf":2.0},"170":{"tf":2.0},"171":{"tf":1.4142135623730951},"172":{"tf":1.0},"173":{"tf":1.7320508075688772},"40":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"b":{"df":1,"docs":{"43":{"tf":1.0}}},"d":{"df":1,"docs":{"107":{"tf":1.0}}},"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"d":{"df":1,"docs":{"174":{"tf":1.0}}},"df":2,"docs":{"26":{"tf":1.0},"60":{"tf":1.0}},"g":{"df":0,"docs":{},"w":{"df":1,"docs":{"43":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"1":{"tf":1.0},"113":{"tf":1.0},"140":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":9,"docs":{"109":{"tf":1.0},"121":{"tf":1.4142135623730951},"26":{"tf":1.0},"47":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"185":{"tf":1.0},"223":{"tf":1.0}}}}},"r":{"df":1,"docs":{"107":{"tf":1.0}}},"s":{"c":{"_":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"131":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":2,"docs":{"137":{"tf":1.0},"61":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"s":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"0":{"tf":1.0}}},"x":{"df":3,"docs":{"16":{"tf":1.4142135623730951},"221":{"tf":1.0},"223":{"tf":1.0}}}},"m":{"df":2,"docs":{"179":{"tf":1.0},"193":{"tf":2.0}}},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"134":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"79":{"tf":1.0}}},"i":{"df":0,"docs":{},"f":{"df":3,"docs":{"115":{"tf":1.0},"127":{"tf":1.0},"142":{"tf":1.0}},"i":{"df":6,"docs":{"103":{"tf":1.0},"133":{"tf":3.0},"167":{"tf":1.0},"174":{"tf":1.0},"176":{"tf":1.0},"222":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":6,"docs":{"0":{"tf":1.0},"156":{"tf":1.0},"168":{"tf":1.0},"20":{"tf":1.4142135623730951},"27":{"tf":1.0},"7":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"129":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"129":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"229":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"229":{"tf":1.0},"230":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"e":{"df":43,"docs":{"0":{"tf":1.4142135623730951},"101":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.7320508075688772},"105":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"119":{"tf":1.4142135623730951},"120":{"tf":1.0},"124":{"tf":1.0},"131":{"tf":1.0},"135":{"tf":1.4142135623730951},"140":{"tf":1.0},"141":{"tf":1.0},"143":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"148":{"tf":1.0},"154":{"tf":1.0},"161":{"tf":1.0},"163":{"tf":1.7320508075688772},"164":{"tf":1.0},"186":{"tf":1.0},"196":{"tf":1.0},"197":{"tf":1.7320508075688772},"199":{"tf":1.0},"200":{"tf":1.7320508075688772},"202":{"tf":2.23606797749979},"203":{"tf":3.0},"212":{"tf":1.0},"213":{"tf":1.0},"217":{"tf":1.0},"223":{"tf":1.0},"226":{"tf":1.7320508075688772},"5":{"tf":1.7320508075688772},"58":{"tf":1.0},"7":{"tf":1.0},"79":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.4142135623730951},"89":{"tf":1.0},"90":{"tf":1.0}},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"137":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"200":{"tf":1.0},"210":{"tf":1.7320508075688772}}}}},"v":{"df":0,"docs":{},"e":{"df":4,"docs":{"100":{"tf":1.0},"186":{"tf":1.7320508075688772},"229":{"tf":1.0},"230":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"121":{"tf":1.0}}}}}}},"df":0,"docs":{}},"_":{"1":{"_":{"4":{"4":{"df":1,"docs":{"121":{"tf":1.0}}},"5":{"df":1,"docs":{"121":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"121":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":4,"docs":{"109":{"tf":1.0},"121":{"tf":4.242640687119285},"62":{"tf":1.0},"7":{"tf":2.449489742783178}},"s":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"121":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"0":{"tf":1.0},"225":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"202":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"65":{"tf":1.0},"66":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"df":11,"docs":{"113":{"tf":1.0},"117":{"tf":1.0},"119":{"tf":1.0},"121":{"tf":1.0},"138":{"tf":1.0},"146":{"tf":1.0},"214":{"tf":1.0},"225":{"tf":1.4142135623730951},"226":{"tf":1.0},"31":{"tf":1.0},"5":{"tf":1.0}},"e":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"25":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"51":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"45":{"tf":2.23606797749979}}}},"y":{"_":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"212":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"212":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"214":{"tf":1.0}}}}}}},"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"214":{"tf":1.0}}}}}}},"df":1,"docs":{"214":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"214":{"tf":1.0}}}}}}},"df":1,"docs":{"214":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"214":{"tf":1.0}}}}}}},"df":1,"docs":{"214":{"tf":1.0}}}}}},"df":5,"docs":{"212":{"tf":1.7320508075688772},"213":{"tf":4.0},"214":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"212":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"152":{"tf":1.0},"153":{"tf":1.0},"169":{"tf":1.0},"170":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"164":{"tf":1.0},"173":{"tf":1.0}}}}}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"=":{"<":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"144":{"tf":1.0},"145":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"113":{"tf":1.0},"140":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"112":{"tf":1.4142135623730951},"133":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"133":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},">":{"(":{"<":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"213":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"182":{"tf":1.0}}}}}}},"df":0,"docs":{}},"d":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"218":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":45,"docs":{"109":{"tf":1.0},"111":{"tf":1.7320508075688772},"112":{"tf":1.0},"113":{"tf":1.0},"116":{"tf":2.449489742783178},"118":{"tf":1.4142135623730951},"119":{"tf":1.7320508075688772},"120":{"tf":2.0},"124":{"tf":1.4142135623730951},"128":{"tf":1.0},"129":{"tf":1.0},"132":{"tf":2.8284271247461903},"133":{"tf":1.4142135623730951},"134":{"tf":1.4142135623730951},"138":{"tf":1.0},"140":{"tf":1.0},"144":{"tf":1.4142135623730951},"146":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.0},"170":{"tf":1.0},"173":{"tf":1.0},"178":{"tf":1.0},"182":{"tf":1.4142135623730951},"209":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":2.6457513110645907},"214":{"tf":3.3166247903554},"219":{"tf":1.0},"223":{"tf":2.23606797749979},"225":{"tf":1.0},"230":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.7320508075688772},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"41":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"67":{"tf":1.0},"69":{"tf":1.7320508075688772},"7":{"tf":2.23606797749979},"70":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951}},"s":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"104":{"tf":1.0}}}}}}}},"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"214":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"n":{"df":2,"docs":{"148":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"211":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"196":{"tf":1.0}}}}}},"b":{"df":1,"docs":{"41":{"tf":1.0}}},"df":1,"docs":{"26":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":9,"docs":{"103":{"tf":1.0},"163":{"tf":1.4142135623730951},"175":{"tf":1.0},"181":{"tf":1.0},"187":{"tf":1.0},"188":{"tf":2.0},"195":{"tf":1.0},"204":{"tf":1.0},"58":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"124":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":41,"docs":{"108":{"tf":1.0},"111":{"tf":1.4142135623730951},"113":{"tf":1.7320508075688772},"116":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"119":{"tf":1.0},"121":{"tf":1.4142135623730951},"123":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.4142135623730951},"135":{"tf":1.0},"138":{"tf":1.4142135623730951},"140":{"tf":1.4142135623730951},"143":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.4142135623730951},"148":{"tf":1.0},"152":{"tf":1.0},"161":{"tf":1.0},"168":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.4142135623730951},"177":{"tf":1.4142135623730951},"185":{"tf":1.4142135623730951},"186":{"tf":1.7320508075688772},"202":{"tf":1.4142135623730951},"203":{"tf":1.4142135623730951},"214":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.0},"222":{"tf":1.0},"223":{"tf":1.4142135623730951},"226":{"tf":1.4142135623730951},"228":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.7320508075688772},"43":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"87":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"127":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"g":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"226":{"tf":1.4142135623730951},"32":{"tf":1.0},"5":{"tf":1.0}}}},"df":3,"docs":{"107":{"tf":1.0},"5":{"tf":1.0},"90":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"210":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951}}}},"t":{"b":{"df":0,"docs":{},"s":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"179":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"181":{"tf":1.0},"99":{"tf":1.0}}}}},"w":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":2,"docs":{"121":{"tf":1.0},"129":{"tf":1.0}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":11,"docs":{"104":{"tf":1.0},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"117":{"tf":1.0},"133":{"tf":2.0},"134":{"tf":1.0},"135":{"tf":1.0},"138":{"tf":1.0},"140":{"tf":1.4142135623730951},"144":{"tf":1.0},"145":{"tf":1.0}}}}}}},"df":36,"docs":{"0":{"tf":1.0},"100":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":1.7320508075688772},"111":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"113":{"tf":1.7320508075688772},"116":{"tf":1.0},"117":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"129":{"tf":2.0},"131":{"tf":1.4142135623730951},"133":{"tf":2.23606797749979},"135":{"tf":1.4142135623730951},"136":{"tf":1.0},"137":{"tf":1.0},"139":{"tf":1.4142135623730951},"140":{"tf":1.7320508075688772},"143":{"tf":1.0},"144":{"tf":1.4142135623730951},"147":{"tf":1.0},"150":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"175":{"tf":1.4142135623730951},"179":{"tf":1.0},"185":{"tf":1.0},"186":{"tf":1.4142135623730951},"187":{"tf":1.0},"193":{"tf":1.4142135623730951},"202":{"tf":1.4142135623730951},"203":{"tf":2.0},"222":{"tf":1.0},"224":{"tf":1.0},"93":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"t":{"df":12,"docs":{"112":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"129":{"tf":1.0},"138":{"tf":1.0},"149":{"tf":1.4142135623730951},"163":{"tf":1.0},"167":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"186":{"tf":1.0},"79":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":8,"docs":{"108":{"tf":1.4142135623730951},"116":{"tf":1.0},"125":{"tf":1.4142135623730951},"130":{"tf":1.0},"176":{"tf":1.4142135623730951},"179":{"tf":1.7320508075688772},"202":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}}}}}},"o":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"202":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"e":{"df":10,"docs":{"145":{"tf":1.7320508075688772},"210":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":3.1622776601683795},"214":{"tf":2.6457513110645907},"220":{"tf":1.7320508075688772},"223":{"tf":2.449489742783178},"225":{"tf":1.0},"226":{"tf":1.0}},"i":{"d":{"df":2,"docs":{"119":{"tf":1.4142135623730951},"120":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"203":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"145":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":5,"docs":{"109":{"tf":1.0},"137":{"tf":1.0},"210":{"tf":1.0},"225":{"tf":1.0},"96":{"tf":1.0}},"e":{"df":10,"docs":{"119":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.0},"146":{"tf":1.0},"210":{"tf":2.0},"212":{"tf":1.0},"213":{"tf":1.0},"218":{"tf":1.4142135623730951},"221":{"tf":1.4142135623730951},"7":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"b":{"df":0,"docs":{},"r":{"a":{"c":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"129":{"tf":1.0},"138":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":36,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"103":{"tf":1.0},"108":{"tf":1.0},"113":{"tf":1.4142135623730951},"133":{"tf":1.4142135623730951},"138":{"tf":2.23606797749979},"146":{"tf":2.23606797749979},"147":{"tf":1.0},"148":{"tf":2.23606797749979},"151":{"tf":1.4142135623730951},"158":{"tf":1.0},"160":{"tf":1.0},"167":{"tf":1.4142135623730951},"174":{"tf":1.0},"175":{"tf":1.0},"177":{"tf":1.4142135623730951},"178":{"tf":1.0},"179":{"tf":1.4142135623730951},"186":{"tf":2.0},"187":{"tf":1.4142135623730951},"192":{"tf":1.0},"201":{"tf":1.0},"202":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":1.0},"218":{"tf":1.4142135623730951},"219":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":2.23606797749979},"6":{"tf":1.0},"7":{"tf":2.23606797749979},"90":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":4,"docs":{"21":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0}}}}}}}}},"h":{"df":5,"docs":{"117":{"tf":1.0},"135":{"tf":1.0},"148":{"tf":1.0},"202":{"tf":1.0},"97":{"tf":1.0}}},"i":{"c":{"df":4,"docs":{"112":{"tf":1.0},"133":{"tf":1.7320508075688772},"145":{"tf":1.4142135623730951},"169":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"222":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"a":{"d":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"202":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":19,"docs":{"108":{"tf":1.0},"113":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.4142135623730951},"129":{"tf":1.4142135623730951},"133":{"tf":1.0},"138":{"tf":1.4142135623730951},"140":{"tf":1.0},"149":{"tf":1.4142135623730951},"175":{"tf":1.0},"182":{"tf":1.0},"188":{"tf":1.0},"194":{"tf":1.0},"202":{"tf":1.0},"212":{"tf":1.0},"223":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0},"230":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":15,"docs":{"10":{"tf":1.0},"138":{"tf":1.0},"191":{"tf":1.0},"213":{"tf":1.0},"214":{"tf":1.0},"222":{"tf":1.0},"47":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"131":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"112":{"tf":1.0},"133":{"tf":1.0}}}}}}}},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"99":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"o":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"159":{"tf":1.0}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"137":{"tf":1.0}}}}}}},"c":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.0}}}}},"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"214":{"tf":1.0}},"r":{"df":1,"docs":{"226":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":4,"docs":{"186":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"220":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"122":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":2,"docs":{"84":{"tf":1.4142135623730951},"87":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":3,"docs":{"146":{"tf":1.0},"203":{"tf":1.0},"230":{"tf":1.0}}}},"df":0,"docs":{}}}},"k":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"144":{"tf":1.0}}}},"df":2,"docs":{"138":{"tf":1.7320508075688772},"72":{"tf":1.0}}},"l":{"d":{"df":2,"docs":{"147":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"n":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"227":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"c":{"df":7,"docs":{"121":{"tf":1.0},"124":{"tf":1.0},"138":{"tf":1.0},"146":{"tf":1.0},"177":{"tf":1.0},"186":{"tf":1.0},"230":{"tf":1.4142135623730951}}},"df":32,"docs":{"100":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.7320508075688772},"121":{"tf":1.4142135623730951},"127":{"tf":1.0},"131":{"tf":1.0},"133":{"tf":1.4142135623730951},"135":{"tf":1.0},"140":{"tf":1.0},"146":{"tf":1.7320508075688772},"147":{"tf":1.4142135623730951},"159":{"tf":1.0},"17":{"tf":1.0},"172":{"tf":1.0},"174":{"tf":1.0},"179":{"tf":1.0},"199":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.0},"211":{"tf":1.0},"214":{"tf":1.7320508075688772},"221":{"tf":1.0},"223":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":2.0},"228":{"tf":1.0},"230":{"tf":1.4142135623730951},"5":{"tf":1.0},"69":{"tf":1.4142135623730951},"79":{"tf":1.0},"97":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"186":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"200":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"97":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"p":{"df":1,"docs":{"226":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"s":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":16,"docs":{"112":{"tf":1.0},"113":{"tf":1.0},"116":{"tf":1.4142135623730951},"138":{"tf":1.0},"177":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.0},"182":{"tf":1.0},"183":{"tf":1.4142135623730951},"186":{"tf":1.0},"188":{"tf":1.0},"196":{"tf":1.0},"203":{"tf":1.7320508075688772},"208":{"tf":1.0},"227":{"tf":1.0},"43":{"tf":1.0}},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"43":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"43":{"tf":1.0}}},"l":{"df":1,"docs":{"43":{"tf":1.0}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}}}},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"r":{"df":11,"docs":{"13":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"223":{"tf":1.7320508075688772},"226":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"71":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"5":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"120":{"tf":1.4142135623730951},"86":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"127":{"tf":1.0}}}}}}},"t":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"218":{"tf":1.4142135623730951},"226":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"218":{"tf":1.0}}}},"df":1,"docs":{"218":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"221":{"tf":1.0},"6":{"tf":1.0},"88":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"n":{"<":{"&":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"214":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"121":{"tf":1.0}}}}},"u":{"3":{"2":{"df":2,"docs":{"167":{"tf":1.0},"174":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":1,"docs":{"218":{"tf":1.0}}}}},"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"df":15,"docs":{"108":{"tf":1.0},"133":{"tf":1.0},"146":{"tf":1.0},"170":{"tf":1.0},"171":{"tf":1.0},"195":{"tf":1.4142135623730951},"212":{"tf":1.0},"213":{"tf":1.4142135623730951},"214":{"tf":1.0},"218":{"tf":1.0},"223":{"tf":1.0},"225":{"tf":1.0},"5":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":12,"docs":{"117":{"tf":1.7320508075688772},"121":{"tf":1.0},"137":{"tf":1.0},"145":{"tf":1.0},"147":{"tf":1.0},"175":{"tf":1.0},"177":{"tf":1.0},"186":{"tf":1.0},"226":{"tf":1.0},"5":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"165":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"182":{"tf":1.4142135623730951},"183":{"tf":1.0},"188":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"6":{"4":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"148":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":5,"docs":{"101":{"tf":1.0},"147":{"tf":1.0},"186":{"tf":1.4142135623730951},"221":{"tf":1.0},"7":{"tf":1.0}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":3,"docs":{"129":{"tf":1.0},"188":{"tf":1.0},"212":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"163":{"tf":2.0},"164":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"163":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":2,"docs":{"144":{"tf":1.0},"145":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"t":{"df":19,"docs":{"102":{"tf":1.0},"108":{"tf":1.0},"127":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":1.0},"161":{"tf":1.0},"178":{"tf":1.0},"180":{"tf":1.0},"186":{"tf":2.0},"188":{"tf":1.0},"192":{"tf":1.4142135623730951},"199":{"tf":1.0},"203":{"tf":1.4142135623730951},"221":{"tf":1.0},"230":{"tf":1.0},"4":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0},"90":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"223":{"tf":1.4142135623730951}}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"227":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":15,"docs":{"103":{"tf":1.4142135623730951},"113":{"tf":1.7320508075688772},"115":{"tf":1.0},"117":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.0},"126":{"tf":1.0},"138":{"tf":3.0},"142":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"149":{"tf":1.0},"188":{"tf":1.0},"202":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"85":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"154":{"tf":1.0},"167":{"tf":1.0},"174":{"tf":1.0},"66":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"133":{"tf":1.4142135623730951}}}},"df":12,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"122":{"tf":1.0},"137":{"tf":1.0},"153":{"tf":1.0},"161":{"tf":1.4142135623730951},"175":{"tf":1.0},"197":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"108":{"tf":1.7320508075688772},"121":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":5,"docs":{"100":{"tf":1.4142135623730951},"217":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"108":{"tf":1.0}}}}}}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"148":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"191":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"18":{"tf":1.7320508075688772}},"k":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"55":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"161":{"tf":1.7320508075688772},"164":{"tf":1.0},"173":{"tf":1.0},"21":{"tf":1.0},"219":{"tf":1.4142135623730951},"55":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":6,"docs":{"144":{"tf":1.0},"217":{"tf":1.4142135623730951},"218":{"tf":1.0},"219":{"tf":1.4142135623730951},"223":{"tf":2.23606797749979},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"144":{"tf":1.0},"145":{"tf":1.0},"223":{"tf":1.7320508075688772}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"219":{"tf":1.0}}}}}}},"t":{"df":19,"docs":{"116":{"tf":1.4142135623730951},"126":{"tf":1.4142135623730951},"166":{"tf":1.0},"175":{"tf":1.4142135623730951},"193":{"tf":1.0},"21":{"tf":1.0},"210":{"tf":1.4142135623730951},"214":{"tf":1.7320508075688772},"217":{"tf":1.0},"225":{"tf":1.4142135623730951},"226":{"tf":1.4142135623730951},"229":{"tf":1.0},"230":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0},"91":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"118":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":1,"docs":{"229":{"tf":1.4142135623730951}}}}},"s":{"c":{"a":{"df":0,"docs":{},"l":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"112":{"tf":1.0},"118":{"tf":1.0},"144":{"tf":1.0}}}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"133":{"tf":1.4142135623730951},"140":{"tf":1.0},"145":{"tf":1.0}}}},"df":0,"docs":{}}},"df":29,"docs":{"109":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":2.449489742783178},"118":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.4142135623730951},"128":{"tf":1.4142135623730951},"129":{"tf":1.4142135623730951},"133":{"tf":2.449489742783178},"135":{"tf":2.0},"138":{"tf":1.7320508075688772},"143":{"tf":1.0},"146":{"tf":1.7320508075688772},"164":{"tf":1.0},"182":{"tf":1.0},"183":{"tf":1.0},"186":{"tf":1.0},"215":{"tf":1.0},"221":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"63":{"tf":1.4142135623730951},"7":{"tf":1.0},"75":{"tf":1.0},"93":{"tf":1.0}}},"t":{"df":2,"docs":{"102":{"tf":1.0},"186":{"tf":1.0}}}},"t":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"226":{"tf":1.4142135623730951}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":2,"docs":{"221":{"tf":1.0},"226":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"221":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"151":{"tf":1.0},"169":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"177":{"tf":1.4142135623730951},"182":{"tf":1.0},"185":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"163":{"tf":1.0},"170":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"182":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"d":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"177":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"178":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":16,"docs":{"10":{"tf":1.4142135623730951},"108":{"tf":1.0},"133":{"tf":1.0},"160":{"tf":1.4142135623730951},"171":{"tf":1.0},"172":{"tf":1.0},"21":{"tf":1.0},"29":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"51":{"tf":1.0},"69":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"172":{"tf":1.0}}}},":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"160":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"171":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"163":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"222":{"tf":1.0}}},"df":24,"docs":{"122":{"tf":1.0},"127":{"tf":1.0},"134":{"tf":1.0},"151":{"tf":1.0},"153":{"tf":1.0},"163":{"tf":2.0},"169":{"tf":1.0},"209":{"tf":1.4142135623730951},"210":{"tf":1.4142135623730951},"211":{"tf":2.23606797749979},"212":{"tf":3.605551275463989},"213":{"tf":4.795831523312719},"214":{"tf":3.872983346207417},"215":{"tf":1.7320508075688772},"217":{"tf":1.7320508075688772},"219":{"tf":2.449489742783178},"220":{"tf":1.7320508075688772},"221":{"tf":3.3166247903554},"222":{"tf":2.23606797749979},"223":{"tf":3.605551275463989},"224":{"tf":1.4142135623730951},"225":{"tf":2.6457513110645907},"226":{"tf":5.477225575051661},"58":{"tf":2.0}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":6,"docs":{"217":{"tf":2.0},"218":{"tf":2.23606797749979},"219":{"tf":1.7320508075688772},"220":{"tf":2.23606797749979},"223":{"tf":1.4142135623730951},"226":{"tf":1.7320508075688772}},"e":{"'":{"df":1,"docs":{"220":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"df":5,"docs":{"179":{"tf":1.0},"180":{"tf":1.0},"182":{"tf":1.0},"183":{"tf":1.0},"5":{"tf":1.4142135623730951}},"e":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"116":{"tf":1.4142135623730951},"124":{"tf":1.0},"134":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"90":{"tf":2.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"df":1,"docs":{"153":{"tf":1.0}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"202":{"tf":1.0},"203":{"tf":2.449489742783178},"229":{"tf":1.4142135623730951},"5":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"f":{"df":2,"docs":{"0":{"tf":1.0},"88":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":8,"docs":{"153":{"tf":1.0},"163":{"tf":1.0},"169":{"tf":1.0},"176":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.0},"221":{"tf":2.0},"88":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"119":{"tf":1.0},"176":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"177":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"188":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"144":{"tf":1.0},"145":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"99":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"144":{"tf":1.0},"230":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"b":{"df":1,"docs":{"43":{"tf":1.0}}},"c":{"df":0,"docs":{},"k":{"df":7,"docs":{"127":{"tf":1.0},"146":{"tf":1.0},"182":{"tf":1.0},"5":{"tf":1.4142135623730951},"85":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"100":{"tf":1.0},"144":{"tf":1.0},"197":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"148":{"tf":1.0}}},"df":0,"docs":{}},"n":{"df":1,"docs":{"176":{"tf":1.0}},"g":{"df":3,"docs":{"179":{"tf":1.0},"229":{"tf":1.4142135623730951},"230":{"tf":1.0}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":7,"docs":{"11":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":1.0},"166":{"tf":1.0},"175":{"tf":1.0},"184":{"tf":1.0},"197":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"113":{"tf":1.4142135623730951},"138":{"tf":1.4142135623730951}}}},"n":{"df":5,"docs":{"199":{"tf":1.0},"201":{"tf":1.4142135623730951},"202":{"tf":1.7320508075688772},"203":{"tf":1.0},"206":{"tf":1.0}},"e":{"df":1,"docs":{"203":{"tf":1.0}}}},"y":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"122":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"122":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"202":{"tf":1.0},"203":{"tf":1.0}}}}},"df":7,"docs":{"0":{"tf":1.0},"105":{"tf":1.0},"124":{"tf":1.0},"186":{"tf":1.0},"224":{"tf":1.0},"5":{"tf":1.4142135623730951},"93":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":1,"docs":{"229":{"tf":1.0}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":9,"docs":{"115":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.0},"181":{"tf":1.4142135623730951},"186":{"tf":1.0},"187":{"tf":1.4142135623730951},"203":{"tf":1.0},"35":{"tf":1.0},"97":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"130":{"tf":1.0},"44":{"tf":1.4142135623730951}}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"106":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":2,"docs":{"200":{"tf":1.0},"202":{"tf":1.0}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":14,"docs":{"0":{"tf":1.0},"105":{"tf":1.0},"107":{"tf":1.0},"129":{"tf":1.0},"145":{"tf":1.0},"166":{"tf":1.4142135623730951},"174":{"tf":1.0},"186":{"tf":1.4142135623730951},"202":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772},"7":{"tf":1.0},"85":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":14,"docs":{"160":{"tf":1.0},"166":{"tf":1.0},"171":{"tf":1.4142135623730951},"175":{"tf":1.0},"192":{"tf":1.0},"202":{"tf":1.0},"204":{"tf":1.0},"214":{"tf":1.4142135623730951},"221":{"tf":1.4142135623730951},"223":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":1.4142135623730951},"5":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"229":{"tf":1.0}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"139":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"90":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"221":{"tf":1.0},"226":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":22,"docs":{"101":{"tf":1.0},"106":{"tf":1.4142135623730951},"109":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"128":{"tf":1.4142135623730951},"132":{"tf":1.0},"160":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.0},"179":{"tf":1.7320508075688772},"180":{"tf":1.0},"182":{"tf":1.0},"183":{"tf":2.23606797749979},"186":{"tf":3.3166247903554},"188":{"tf":1.7320508075688772},"189":{"tf":1.0},"203":{"tf":1.7320508075688772},"209":{"tf":1.0},"228":{"tf":1.0},"229":{"tf":2.23606797749979},"230":{"tf":1.7320508075688772}},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"223":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":1,"docs":{"94":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"171":{"tf":1.0},"172":{"tf":1.0},"5":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":3,"docs":{"116":{"tf":1.0},"27":{"tf":2.23606797749979},"64":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":2,"docs":{"29":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"113":{"tf":1.0},"140":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"148":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"87":{"tf":1.0}}}}},"s":{"df":1,"docs":{"204":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"203":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"103":{"tf":1.0},"208":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"0":{"tf":1.4142135623730951},"177":{"tf":1.0},"202":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":9,"docs":{"105":{"tf":1.0},"138":{"tf":1.0},"177":{"tf":1.0},"183":{"tf":1.0},"186":{"tf":1.4142135623730951},"189":{"tf":1.0},"193":{"tf":1.0},"217":{"tf":1.0},"220":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"152":{"tf":1.0},"161":{"tf":1.0},"169":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{")":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"108":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"109":{"tf":1.0},"123":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"`":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":3,"docs":{"159":{"tf":1.0},"160":{"tf":1.0},"163":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"152":{"tf":1.0},"153":{"tf":1.0},"169":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":2,"docs":{"115":{"tf":1.0},"142":{"tf":1.0}}},"df":1,"docs":{"19":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"205":{"tf":1.0},"224":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"204":{"tf":1.0}},"i":{"df":1,"docs":{"204":{"tf":1.7320508075688772}}}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"20":{"tf":1.0},"229":{"tf":1.0},"37":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"o":{"b":{"a":{"b":{"df":0,"docs":{},"l":{"df":10,"docs":{"109":{"tf":1.0},"130":{"tf":1.0},"146":{"tf":1.0},"187":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.0},"223":{"tf":1.0},"229":{"tf":1.4142135623730951},"230":{"tf":1.4142135623730951},"97":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"202":{"tf":1.0},"203":{"tf":1.0}}}},"df":4,"docs":{"221":{"tf":1.0},"223":{"tf":2.0},"225":{"tf":1.0},"93":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"100":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":17,"docs":{"113":{"tf":1.4142135623730951},"132":{"tf":1.0},"136":{"tf":1.0},"140":{"tf":1.4142135623730951},"175":{"tf":1.4142135623730951},"176":{"tf":1.4142135623730951},"177":{"tf":1.0},"179":{"tf":1.4142135623730951},"199":{"tf":1.0},"200":{"tf":1.4142135623730951},"202":{"tf":1.4142135623730951},"203":{"tf":3.0},"204":{"tf":1.0},"206":{"tf":1.0},"227":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":8,"docs":{"119":{"tf":1.0},"120":{"tf":1.0},"149":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.4142135623730951},"214":{"tf":1.0},"6":{"tf":1.0},"91":{"tf":1.0}},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"165":{"tf":1.0}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"223":{"tf":1.4142135623730951},"226":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"137":{"tf":1.0},"155":{"tf":1.4142135623730951},"161":{"tf":1.7320508075688772}}}},"df":1,"docs":{"144":{"tf":1.0}}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"121":{"tf":1.4142135623730951}}},"df":17,"docs":{"103":{"tf":1.0},"108":{"tf":2.0},"112":{"tf":1.0},"115":{"tf":1.0},"121":{"tf":1.7320508075688772},"133":{"tf":1.4142135623730951},"197":{"tf":1.0},"200":{"tf":1.4142135623730951},"203":{"tf":1.7320508075688772},"204":{"tf":1.4142135623730951},"226":{"tf":1.0},"227":{"tf":1.4142135623730951},"5":{"tf":1.0},"6":{"tf":1.0},"62":{"tf":1.0},"7":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"177":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"149":{"tf":1.0},"177":{"tf":1.0},"204":{"tf":1.0},"223":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"210":{"tf":1.0},"221":{"tf":1.4142135623730951},"226":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"s":{"df":9,"docs":{"127":{"tf":1.0},"197":{"tf":2.0},"211":{"tf":1.0},"212":{"tf":1.0},"214":{"tf":1.0},"217":{"tf":1.0},"221":{"tf":1.0},"223":{"tf":1.0},"226":{"tf":1.7320508075688772}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":17,"docs":{"112":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"133":{"tf":1.0},"146":{"tf":2.449489742783178},"147":{"tf":1.0},"148":{"tf":1.4142135623730951},"152":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"164":{"tf":1.0},"167":{"tf":1.0},"199":{"tf":1.0},"226":{"tf":1.0},"230":{"tf":1.0},"7":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}},"x":{"df":0,"docs":{},"i":{"df":1,"docs":{"108":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"b":{"(":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":13,"docs":{"113":{"tf":1.7320508075688772},"116":{"tf":1.0},"121":{"tf":1.4142135623730951},"124":{"tf":1.0},"129":{"tf":1.7320508075688772},"134":{"tf":1.0},"138":{"tf":2.0},"146":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":1.4142135623730951},"218":{"tf":3.1622776601683795},"220":{"tf":1.0},"64":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"20":{"tf":1.0},"64":{"tf":1.0}},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":3,"docs":{"206":{"tf":1.0},"36":{"tf":1.4142135623730951},"92":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"178":{"tf":1.0},"180":{"tf":1.0},"182":{"tf":1.0},"183":{"tf":1.0},"230":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"146":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"185":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":12,"docs":{"102":{"tf":1.4142135623730951},"177":{"tf":1.0},"178":{"tf":1.4142135623730951},"179":{"tf":1.0},"182":{"tf":1.4142135623730951},"183":{"tf":1.0},"188":{"tf":1.4142135623730951},"189":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.4142135623730951},"202":{"tf":1.0},"94":{"tf":1.0}}}},"t":{"df":7,"docs":{"122":{"tf":1.0},"133":{"tf":1.4142135623730951},"139":{"tf":1.4142135623730951},"177":{"tf":1.0},"203":{"tf":1.0},"223":{"tf":1.0},"7":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":4,"docs":{"39":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"161":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"117":{"tf":1.0},"135":{"tf":1.0},"144":{"tf":1.0},"158":{"tf":1.0},"162":{"tf":1.0},"169":{"tf":1.0},"225":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"176":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"100":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"122":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"210":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":5,"docs":{"146":{"tf":1.0},"152":{"tf":1.0},"203":{"tf":1.4142135623730951},"210":{"tf":1.0},"223":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"223":{"tf":1.0}}}},"u":{"df":0,"docs":{},"x":{"df":2,"docs":{"41":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":4,"docs":{"113":{"tf":1.0},"134":{"tf":1.0},"140":{"tf":1.0},"144":{"tf":1.0}}}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"230":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"df":3,"docs":{"147":{"tf":1.7320508075688772},"171":{"tf":1.0},"186":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"147":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":4,"docs":{"181":{"tf":1.0},"185":{"tf":1.0},"202":{"tf":1.0},"7":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"202":{"tf":1.0},"204":{"tf":1.0}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"222":{"tf":1.0}}}},"df":0,"docs":{}}}}},"w":{"df":2,"docs":{"17":{"tf":1.0},"44":{"tf":1.4142135623730951}}}},"c":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"17":{"tf":1.4142135623730951},"230":{"tf":1.4142135623730951}},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"230":{"tf":1.0}}}},"d":{"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"147":{"tf":1.0},"210":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{}},"df":10,"docs":{"100":{"tf":1.0},"116":{"tf":1.0},"120":{"tf":1.0},"194":{"tf":1.0},"210":{"tf":1.4142135623730951},"214":{"tf":1.0},"222":{"tf":1.0},"223":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"163":{"tf":1.0},"99":{"tf":1.7320508075688772}}}},"i":{"df":1,"docs":{"5":{"tf":1.0}}},"m":{"df":1,"docs":{"105":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":6,"docs":{"116":{"tf":1.0},"146":{"tf":1.0},"161":{"tf":1.0},"196":{"tf":1.0},"203":{"tf":1.0},"215":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":8,"docs":{"119":{"tf":1.0},"138":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"223":{"tf":1.4142135623730951},"5":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0}}}},"m":{"df":1,"docs":{"137":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":14,"docs":{"0":{"tf":1.0},"104":{"tf":1.0},"117":{"tf":1.4142135623730951},"124":{"tf":1.0},"127":{"tf":1.0},"138":{"tf":1.0},"150":{"tf":1.0},"213":{"tf":1.0},"223":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"229":{"tf":1.0},"230":{"tf":1.0}}}}}}}},"b":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"102":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"203":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"230":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":10,"docs":{"127":{"tf":1.4142135623730951},"226":{"tf":1.0},"45":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.0},"91":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"223":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"203":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"177":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"222":{"tf":1.0}}},"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":3,"docs":{"141":{"tf":1.0},"192":{"tf":1.0},"215":{"tf":1.0}},"f":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"df":3,"docs":{"148":{"tf":1.0},"153":{"tf":1.0},"221":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":16,"docs":{"103":{"tf":1.0},"105":{"tf":1.0},"148":{"tf":1.4142135623730951},"158":{"tf":1.0},"161":{"tf":1.0},"164":{"tf":1.0},"176":{"tf":1.0},"197":{"tf":1.0},"214":{"tf":1.7320508075688772},"216":{"tf":1.0},"219":{"tf":1.0},"223":{"tf":1.0},"5":{"tf":1.0},"63":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"=":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"177":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":5,"docs":{"166":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.0},"221":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"'":{"df":1,"docs":{"213":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"104":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"117":{"tf":2.0},"133":{"tf":2.23606797749979},"135":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"117":{"tf":1.0},"135":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"117":{"tf":1.4142135623730951},"135":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"117":{"tf":1.0},"135":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"r":{"df":5,"docs":{"109":{"tf":1.0},"117":{"tf":1.0},"129":{"tf":1.4142135623730951},"131":{"tf":1.0},"135":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"221":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":8,"docs":{"203":{"tf":1.4142135623730951},"209":{"tf":1.0},"211":{"tf":2.0},"214":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0},"227":{"tf":1.0},"229":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"203":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"104":{"tf":1.0},"133":{"tf":1.0},"144":{"tf":1.0},"166":{"tf":1.0},"203":{"tf":1.0},"99":{"tf":1.0}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"/":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"182":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"223":{"tf":1.0},"226":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":13,"docs":{"108":{"tf":1.0},"116":{"tf":1.0},"175":{"tf":2.449489742783178},"176":{"tf":1.0},"181":{"tf":1.7320508075688772},"185":{"tf":2.23606797749979},"186":{"tf":3.3166247903554},"187":{"tf":2.8284271247461903},"188":{"tf":1.7320508075688772},"190":{"tf":1.0},"191":{"tf":1.7320508075688772},"193":{"tf":2.449489742783178},"230":{"tf":1.0}}}},"df":0,"docs":{},"v":{"df":4,"docs":{"121":{"tf":1.0},"186":{"tf":1.7320508075688772},"187":{"tf":1.0},"225":{"tf":1.0}}}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"199":{"tf":1.0},"200":{"tf":1.0},"202":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":2,"docs":{"155":{"tf":1.0},"161":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"222":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"120":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"187":{"tf":1.0},"188":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"144":{"tf":1.0},"145":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"t":{"df":6,"docs":{"102":{"tf":1.7320508075688772},"178":{"tf":3.1622776601683795},"179":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.0}}},"v":{"df":6,"docs":{"104":{"tf":1.0},"108":{"tf":1.0},"138":{"tf":1.0},"186":{"tf":1.0},"193":{"tf":1.0},"87":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":4,"docs":{"113":{"tf":1.0},"140":{"tf":1.0},"21":{"tf":1.7320508075688772},"46":{"tf":1.7320508075688772}},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"116":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"108":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"218":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"213":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"218":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"213":{"tf":2.0},"219":{"tf":1.4142135623730951},"223":{"tf":1.4142135623730951},"224":{"tf":1.0},"226":{"tf":1.0}}}}}},"l":{"a":{"c":{"df":9,"docs":{"124":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":8,"docs":{"102":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.4142135623730951},"178":{"tf":1.0},"179":{"tf":1.4142135623730951},"203":{"tf":2.0},"227":{"tf":1.0},"230":{"tf":1.0}},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"5":{"tf":1.4142135623730951},"93":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":17,"docs":{"102":{"tf":1.0},"146":{"tf":1.0},"175":{"tf":1.4142135623730951},"176":{"tf":2.23606797749979},"179":{"tf":1.4142135623730951},"182":{"tf":3.0},"183":{"tf":2.449489742783178},"186":{"tf":1.4142135623730951},"188":{"tf":1.0},"189":{"tf":2.0},"190":{"tf":1.4142135623730951},"191":{"tf":1.0},"192":{"tf":1.0},"195":{"tf":1.0},"203":{"tf":1.4142135623730951},"227":{"tf":1.0},"230":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":9,"docs":{"148":{"tf":1.0},"154":{"tf":1.0},"161":{"tf":1.4142135623730951},"164":{"tf":1.0},"167":{"tf":1.0},"174":{"tf":1.4142135623730951},"213":{"tf":1.0},"217":{"tf":1.0},"218":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"107":{"tf":1.4142135623730951},"123":{"tf":1.4142135623730951},"161":{"tf":1.0},"174":{"tf":1.0},"53":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"145":{"tf":1.0},"230":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":12,"docs":{"121":{"tf":2.0},"128":{"tf":1.0},"129":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.4142135623730951},"181":{"tf":1.0},"210":{"tf":1.7320508075688772},"214":{"tf":1.0},"222":{"tf":1.4142135623730951},"223":{"tf":1.7320508075688772},"226":{"tf":1.7320508075688772}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"189":{"tf":1.0}}}},"i":{"d":{"df":2,"docs":{"176":{"tf":1.0},"49":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":3,"docs":{"151":{"tf":1.0},"169":{"tf":1.0},"229":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"203":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"223":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"230":{"tf":1.4142135623730951}}},"df":0,"docs":{},"s":{"df":3,"docs":{"166":{"tf":1.0},"199":{"tf":1.0},"230":{"tf":1.4142135623730951}}}}}},"t":{"df":3,"docs":{"116":{"tf":1.0},"226":{"tf":1.0},"27":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"108":{"tf":1.0},"133":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"0":{"tf":1.7320508075688772},"124":{"tf":1.4142135623730951},"127":{"tf":2.0},"5":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"91":{"tf":2.0}}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{".":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"214":{"tf":1.0}}},"z":{"df":1,"docs":{"214":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"214":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"221":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"214":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"214":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"214":{"tf":1.0}}}},"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":11,"docs":{"105":{"tf":1.4142135623730951},"13":{"tf":1.0},"138":{"tf":1.0},"148":{"tf":1.0},"167":{"tf":1.0},"210":{"tf":1.4142135623730951},"212":{"tf":1.4142135623730951},"213":{"tf":1.0},"214":{"tf":2.23606797749979},"223":{"tf":1.0},"52":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":6,"docs":{"116":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.7320508075688772},"223":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"(":{"c":{"df":0,"docs":{},"x":{"df":2,"docs":{"164":{"tf":1.0},"173":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":17,"docs":{"121":{"tf":1.0},"134":{"tf":1.0},"151":{"tf":1.4142135623730951},"153":{"tf":1.0},"154":{"tf":1.0},"159":{"tf":1.0},"164":{"tf":1.0},"167":{"tf":2.23606797749979},"169":{"tf":1.4142135623730951},"173":{"tf":1.0},"174":{"tf":1.7320508075688772},"212":{"tf":1.0},"214":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":1.0},"52":{"tf":1.0},"97":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"202":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":4,"docs":{"186":{"tf":1.0},"203":{"tf":1.4142135623730951},"229":{"tf":1.4142135623730951},"230":{"tf":2.449489742783178}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"208":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"222":{"tf":1.0}}}}}}},"f":{"c":{"df":8,"docs":{"100":{"tf":1.0},"202":{"tf":1.4142135623730951},"206":{"tf":1.0},"209":{"tf":1.0},"210":{"tf":1.4142135623730951},"211":{"tf":1.0},"218":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}},"i":{"d":{"df":1,"docs":{"138":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{".":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"167":{"tf":1.0},"174":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":10,"docs":{"108":{"tf":1.0},"147":{"tf":1.4142135623730951},"167":{"tf":1.0},"184":{"tf":1.0},"193":{"tf":1.0},"194":{"tf":1.0},"223":{"tf":1.0},"227":{"tf":1.4142135623730951},"228":{"tf":1.0},"230":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"202":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"45":{"tf":2.0}}},"df":0,"docs":{}}}},"o":{"a":{"d":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":6,"docs":{"198":{"tf":1.0},"199":{"tf":1.0},"200":{"tf":1.4142135623730951},"203":{"tf":1.4142135623730951},"206":{"tf":2.0},"208":{"tf":2.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"99":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"203":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":4,"docs":{"108":{"tf":1.4142135623730951},"142":{"tf":1.0},"167":{"tf":1.0},"174":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"186":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"165":{"tf":1.0},"228":{"tf":1.0}}}},"n":{"df":44,"docs":{"0":{"tf":1.4142135623730951},"103":{"tf":2.0},"104":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":2.0},"109":{"tf":1.0},"113":{"tf":2.449489742783178},"114":{"tf":1.4142135623730951},"115":{"tf":1.7320508075688772},"116":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"119":{"tf":1.0},"120":{"tf":2.0},"122":{"tf":1.0},"123":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"133":{"tf":1.7320508075688772},"135":{"tf":1.4142135623730951},"138":{"tf":2.23606797749979},"140":{"tf":1.4142135623730951},"141":{"tf":1.4142135623730951},"142":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"149":{"tf":1.4142135623730951},"177":{"tf":1.7320508075688772},"178":{"tf":1.0},"179":{"tf":1.4142135623730951},"180":{"tf":1.0},"186":{"tf":1.0},"188":{"tf":1.0},"196":{"tf":1.4142135623730951},"197":{"tf":1.0},"202":{"tf":1.0},"37":{"tf":1.0},"5":{"tf":2.23606797749979},"6":{"tf":1.4142135623730951},"7":{"tf":2.0},"93":{"tf":1.0},"94":{"tf":2.23606797749979}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"94":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"'":{"df":3,"docs":{"153":{"tf":1.0},"206":{"tf":1.0},"218":{"tf":1.0}}},",":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"124":{"tf":1.4142135623730951}}}}}}}},":":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"a":{"c":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"159":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"228":{"tf":1.4142135623730951},"229":{"tf":1.0}}}}},"c":{"'":{"df":1,"docs":{"130":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"217":{"tf":1.0}}}}}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{":":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"116":{"tf":1.0},"130":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":3,"docs":{"158":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"171":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"{":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"164":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"163":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"116":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":5,"docs":{"158":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"172":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"152":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"174":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"167":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"161":{"tf":1.0}}},"y":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"155":{"tf":1.0},"161":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"116":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"p":{"a":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":5,"docs":{"158":{"tf":1.0},"161":{"tf":1.0},"164":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"163":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":16,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"123":{"tf":1.0},"130":{"tf":1.4142135623730951},"161":{"tf":1.0},"168":{"tf":1.0},"176":{"tf":1.4142135623730951},"202":{"tf":1.0},"203":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.7320508075688772},"6":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}},"df":58,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"113":{"tf":1.0},"116":{"tf":1.7320508075688772},"121":{"tf":2.23606797749979},"122":{"tf":1.4142135623730951},"125":{"tf":1.0},"129":{"tf":1.0},"131":{"tf":1.0},"134":{"tf":1.4142135623730951},"138":{"tf":1.4142135623730951},"146":{"tf":1.4142135623730951},"158":{"tf":1.0},"160":{"tf":1.0},"161":{"tf":1.0},"165":{"tf":1.0},"175":{"tf":1.7320508075688772},"176":{"tf":2.449489742783178},"177":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":3.605551275463989},"180":{"tf":2.449489742783178},"181":{"tf":1.0},"182":{"tf":2.23606797749979},"183":{"tf":2.449489742783178},"185":{"tf":1.7320508075688772},"186":{"tf":2.6457513110645907},"187":{"tf":1.7320508075688772},"188":{"tf":2.0},"189":{"tf":1.4142135623730951},"190":{"tf":2.0},"191":{"tf":1.7320508075688772},"192":{"tf":2.0},"193":{"tf":1.4142135623730951},"196":{"tf":1.0},"200":{"tf":1.4142135623730951},"202":{"tf":1.4142135623730951},"203":{"tf":2.449489742783178},"206":{"tf":1.0},"213":{"tf":1.0},"217":{"tf":1.0},"220":{"tf":1.0},"223":{"tf":3.0},"226":{"tf":2.23606797749979},"230":{"tf":1.0},"62":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"84":{"tf":1.0},"91":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.4142135623730951},"99":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":5,"docs":{"109":{"tf":1.0},"114":{"tf":1.7320508075688772},"141":{"tf":2.0},"148":{"tf":1.0},"202":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"t":{"df":3,"docs":{"109":{"tf":1.0},"125":{"tf":2.449489742783178},"203":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"p":{"df":10,"docs":{"1":{"tf":1.0},"108":{"tf":2.23606797749979},"115":{"tf":1.0},"125":{"tf":1.4142135623730951},"175":{"tf":1.0},"179":{"tf":1.0},"182":{"tf":1.0},"2":{"tf":1.4142135623730951},"95":{"tf":1.0},"96":{"tf":1.0}}}}}}}},"s":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":3,"docs":{"186":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0}}}}}}},"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":22,"docs":{"113":{"tf":1.0},"117":{"tf":1.0},"121":{"tf":1.0},"127":{"tf":1.7320508075688772},"134":{"tf":1.0},"140":{"tf":1.0},"147":{"tf":1.0},"154":{"tf":1.0},"161":{"tf":1.0},"167":{"tf":1.7320508075688772},"174":{"tf":2.0},"177":{"tf":1.0},"203":{"tf":1.0},"214":{"tf":1.0},"226":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"71":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"210":{"tf":1.0},"211":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"138":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"138":{"tf":1.0}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"203":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":3,"docs":{"127":{"tf":1.0},"152":{"tf":1.0},"162":{"tf":1.0}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"28":{"tf":1.0},"67":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"109":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":6,"docs":{"177":{"tf":1.7320508075688772},"186":{"tf":1.0},"28":{"tf":1.4142135623730951},"7":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}}}}}},"df":2,"docs":{"163":{"tf":1.0},"177":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"129":{"tf":1.0},"211":{"tf":1.7320508075688772},"212":{"tf":1.0},"226":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"201":{"tf":1.0},"210":{"tf":1.4142135623730951},"213":{"tf":1.0},"214":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":22,"docs":{"100":{"tf":1.0},"116":{"tf":1.4142135623730951},"119":{"tf":1.0},"120":{"tf":1.0},"124":{"tf":1.0},"133":{"tf":1.0},"138":{"tf":1.0},"163":{"tf":1.0},"175":{"tf":1.7320508075688772},"176":{"tf":1.0},"178":{"tf":1.0},"186":{"tf":1.4142135623730951},"201":{"tf":2.0},"202":{"tf":1.0},"203":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":1.4142135623730951},"217":{"tf":1.4142135623730951},"220":{"tf":1.0},"221":{"tf":1.0},"226":{"tf":1.0},"7":{"tf":1.7320508075688772}}}}}}},"d":{"df":3,"docs":{"186":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":35,"docs":{"105":{"tf":1.0},"106":{"tf":1.0},"110":{"tf":1.0},"122":{"tf":1.0},"132":{"tf":1.0},"134":{"tf":1.0},"138":{"tf":1.0},"139":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.0},"149":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.4142135623730951},"155":{"tf":1.0},"161":{"tf":1.0},"163":{"tf":1.0},"170":{"tf":1.0},"174":{"tf":1.0},"176":{"tf":1.0},"186":{"tf":1.0},"193":{"tf":1.0},"195":{"tf":1.0},"196":{"tf":1.7320508075688772},"210":{"tf":1.0},"211":{"tf":1.0},"221":{"tf":1.4142135623730951},"228":{"tf":1.0},"5":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0},"97":{"tf":1.0}},"k":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"m":{"df":3,"docs":{"119":{"tf":1.0},"211":{"tf":1.0},"223":{"tf":1.0}}},"n":{"df":4,"docs":{"129":{"tf":1.0},"138":{"tf":1.0},"220":{"tf":1.0},"224":{"tf":1.0}}}},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951}}}}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"123":{"tf":1.0},"214":{"tf":1.0}}}},"df":0,"docs":{}},"f":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"129":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"121":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"163":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":21,"docs":{"119":{"tf":1.4142135623730951},"120":{"tf":1.0},"121":{"tf":1.7320508075688772},"129":{"tf":1.4142135623730951},"146":{"tf":1.0},"147":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"169":{"tf":1.0},"170":{"tf":1.4142135623730951},"171":{"tf":1.0},"172":{"tf":1.0},"173":{"tf":1.4142135623730951},"212":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.4142135623730951}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"87":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"(":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"(":{"_":{"df":1,"docs":{"226":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"_":{"df":1,"docs":{"213":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"218":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"226":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"127":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"127":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":3,"docs":{"144":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0}}}}}}},"df":2,"docs":{"221":{"tf":1.0},"226":{"tf":1.0}}}},"n":{"d":{"df":2,"docs":{"229":{"tf":1.0},"44":{"tf":1.4142135623730951}}},"df":0,"docs":{},"s":{"df":5,"docs":{"112":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"174":{"tf":1.0},"203":{"tf":1.0}},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"223":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"119":{"tf":1.0},"146":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":8,"docs":{"113":{"tf":1.0},"120":{"tf":1.7320508075688772},"129":{"tf":1.0},"138":{"tf":1.0},"148":{"tf":1.0},"171":{"tf":1.0},"203":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"218":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"219":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"218":{"tf":1.0}}}},"df":1,"docs":{"218":{"tf":1.0}},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":6,"docs":{"211":{"tf":1.7320508075688772},"213":{"tf":1.7320508075688772},"218":{"tf":1.0},"219":{"tf":1.0},"223":{"tf":1.0},"224":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"v":{"df":4,"docs":{"116":{"tf":1.0},"195":{"tf":1.0},"196":{"tf":1.4142135623730951},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"196":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"177":{"tf":1.0}}}}}}},"t":{"df":15,"docs":{"105":{"tf":1.4142135623730951},"111":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.4142135623730951},"127":{"tf":1.0},"131":{"tf":1.0},"133":{"tf":1.0},"139":{"tf":1.0},"177":{"tf":1.0},"178":{"tf":2.0},"214":{"tf":1.0},"36":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951},"93":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":5,"docs":{"100":{"tf":1.4142135623730951},"104":{"tf":1.7320508075688772},"109":{"tf":1.0},"110":{"tf":1.0},"115":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"127":{"tf":1.0},"167":{"tf":1.0}}}}}},"h":{"a":{"=":{"$":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"190":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"182":{"tf":1.4142135623730951},"191":{"tf":1.0}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"133":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":5,"docs":{"131":{"tf":1.0},"133":{"tf":1.0},"167":{"tf":1.0},"203":{"tf":1.0},"226":{"tf":1.0}}}}},"df":1,"docs":{"177":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"130":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"177":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"186":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":6,"docs":{"116":{"tf":1.0},"118":{"tf":1.0},"120":{"tf":1.0},"124":{"tf":1.4142135623730951},"143":{"tf":1.0},"229":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"87":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"204":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"w":{"df":7,"docs":{"108":{"tf":1.0},"124":{"tf":1.0},"210":{"tf":1.0},"217":{"tf":1.0},"218":{"tf":1.0},"226":{"tf":1.0},"8":{"tf":1.0}},"n":{"df":4,"docs":{"203":{"tf":1.0},"212":{"tf":1.0},"220":{"tf":1.0},"95":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":6,"docs":{"137":{"tf":1.0},"151":{"tf":1.0},"223":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"131":{"tf":1.0},"164":{"tf":1.0},"173":{"tf":1.0}},"e":{".":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"164":{"tf":1.0},"173":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":9,"docs":{"130":{"tf":1.0},"203":{"tf":1.0},"209":{"tf":1.0},"213":{"tf":1.0},"214":{"tf":1.0},"218":{"tf":1.0},"223":{"tf":1.7320508075688772},"226":{"tf":1.0},"86":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"169":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":7,"docs":{"0":{"tf":1.0},"167":{"tf":1.0},"212":{"tf":1.4142135623730951},"222":{"tf":1.0},"223":{"tf":1.0},"225":{"tf":1.0},"94":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"222":{"tf":1.0},"223":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"213":{"tf":1.0}}}}},"i":{"df":5,"docs":{"129":{"tf":1.0},"158":{"tf":1.0},"167":{"tf":1.0},"195":{"tf":1.0},"225":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":6,"docs":{"203":{"tf":1.0},"210":{"tf":2.0},"218":{"tf":1.0},"220":{"tf":1.0},"226":{"tf":1.0},"87":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"203":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":5,"docs":{"115":{"tf":1.0},"119":{"tf":1.0},"213":{"tf":1.0},"67":{"tf":1.4142135623730951},"7":{"tf":1.0}},"e":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"65":{"tf":1.0},"66":{"tf":1.0}}}}}}}}},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"148":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.4142135623730951},"223":{"tf":1.0}}}},"df":0,"docs":{}}},"x":{"df":2,"docs":{"175":{"tf":1.0},"230":{"tf":1.0}}},"z":{"df":0,"docs":{},"e":{"df":13,"docs":{"169":{"tf":1.0},"33":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"72":{"tf":1.0},"75":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"81":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"1":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"161":{"tf":1.0}}}}}}},"df":1,"docs":{"161":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":3,"docs":{"155":{"tf":1.0},"161":{"tf":1.0},"58":{"tf":2.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"223":{"tf":1.0},"88":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"221":{"tf":1.4142135623730951}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"105":{"tf":1.0},"185":{"tf":1.0},"200":{"tf":1.0},"210":{"tf":1.0},"226":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"111":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"c":{"df":0,"docs":{},"x":{"df":2,"docs":{"147":{"tf":1.0},"148":{"tf":1.0}}}},"df":0,"docs":{}},"df":3,"docs":{"130":{"tf":1.0},"147":{"tf":1.4142135623730951},"148":{"tf":1.7320508075688772}}}}}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"108":{"tf":1.0}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"214":{"tf":1.0},"217":{"tf":1.0},"7":{"tf":1.0}}}},"v":{"df":2,"docs":{"223":{"tf":1.4142135623730951},"225":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"(":{"4":{"2":{"df":2,"docs":{"167":{"tf":1.0},"174":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"221":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"214":{"tf":2.0},"221":{"tf":1.0}}}}}}}}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":2,"docs":{"146":{"tf":1.0},"147":{"tf":1.0}},"i":{"c":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"146":{"tf":1.0},"147":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"170":{"tf":1.4142135623730951},"173":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"202":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"229":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"148":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"h":{"df":14,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.0},"121":{"tf":1.4142135623730951},"134":{"tf":1.0},"135":{"tf":1.4142135623730951},"138":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.4142135623730951},"152":{"tf":1.0},"188":{"tf":1.4142135623730951},"202":{"tf":1.0},"203":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":9,"docs":{"121":{"tf":1.0},"135":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0},"167":{"tf":1.0},"169":{"tf":1.0},"174":{"tf":1.0},"181":{"tf":1.0},"90":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":3,"docs":{"30":{"tf":2.0},"31":{"tf":2.0},"32":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"186":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"202":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"204":{"tf":1.0},"226":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":9,"docs":{"101":{"tf":1.0},"108":{"tf":1.4142135623730951},"148":{"tf":1.4142135623730951},"152":{"tf":1.0},"195":{"tf":1.0},"227":{"tf":1.0},"3":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"98":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"223":{"tf":1.0}}}},"df":0,"docs":{},"n":{"'":{"df":2,"docs":{"167":{"tf":1.4142135623730951},"174":{"tf":1.4142135623730951}}},".":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"167":{"tf":1.0},"174":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"167":{"tf":1.4142135623730951},"174":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":3,"docs":{"119":{"tf":1.4142135623730951},"120":{"tf":1.0},"146":{"tf":1.4142135623730951}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"146":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":3,"docs":{"141":{"tf":1.4142135623730951},"146":{"tf":1.0},"147":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"146":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"146":{"tf":1.4142135623730951}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"174":{"tf":1.0}}}}}}}}},"df":11,"docs":{"119":{"tf":2.23606797749979},"120":{"tf":1.7320508075688772},"130":{"tf":1.0},"146":{"tf":1.4142135623730951},"147":{"tf":1.0},"148":{"tf":2.0},"166":{"tf":1.0},"167":{"tf":3.0},"174":{"tf":2.6457513110645907},"202":{"tf":1.0},"218":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"174":{"tf":1.0}}}},"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"161":{"tf":1.4142135623730951},"185":{"tf":1.0},"203":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":29,"docs":{"109":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"118":{"tf":1.0},"133":{"tf":1.7320508075688772},"134":{"tf":1.0},"138":{"tf":1.0},"145":{"tf":1.0},"148":{"tf":1.4142135623730951},"152":{"tf":1.0},"157":{"tf":1.0},"159":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":2.0},"168":{"tf":2.0},"170":{"tf":1.7320508075688772},"171":{"tf":1.4142135623730951},"172":{"tf":1.0},"173":{"tf":1.0},"202":{"tf":1.0},"209":{"tf":1.0},"211":{"tf":1.4142135623730951},"213":{"tf":1.0},"220":{"tf":2.0},"222":{"tf":1.0},"30":{"tf":1.0},"86":{"tf":1.0},"99":{"tf":1.0}},"i":{"df":15,"docs":{"109":{"tf":1.0},"113":{"tf":1.0},"121":{"tf":1.4142135623730951},"129":{"tf":1.4142135623730951},"138":{"tf":1.0},"186":{"tf":1.0},"199":{"tf":1.0},"203":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":1.0},"222":{"tf":1.0},"223":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":2.449489742783178}}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"144":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"146":{"tf":1.0},"201":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":2,"docs":{"5":{"tf":1.4142135623730951},"89":{"tf":1.0}}}}}}}},"r":{"c":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"/":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":7,"docs":{"179":{"tf":1.0},"180":{"tf":1.0},"182":{"tf":1.4142135623730951},"183":{"tf":1.4142135623730951},"186":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"196":{"tf":1.0}}},"df":0,"docs":{},"g":{"b":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"100":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.0}}}},"l":{"df":17,"docs":{"166":{"tf":1.0},"176":{"tf":1.0},"181":{"tf":1.4142135623730951},"185":{"tf":1.0},"186":{"tf":2.0},"187":{"tf":1.7320508075688772},"188":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":2.0},"193":{"tf":2.23606797749979},"202":{"tf":1.4142135623730951},"203":{"tf":1.0},"93":{"tf":1.7320508075688772},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}}},"c":{"df":0,"docs":{},"k":{"df":4,"docs":{"177":{"tf":1.0},"33":{"tf":1.0},"68":{"tf":1.4142135623730951},"72":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":8,"docs":{"133":{"tf":1.4142135623730951},"151":{"tf":1.0},"156":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"214":{"tf":1.7320508075688772},"221":{"tf":1.0},"226":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"177":{"tf":1.0}}}},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"109":{"tf":1.0},"112":{"tf":1.4142135623730951},"131":{"tf":1.0},"133":{"tf":1.7320508075688772},"134":{"tf":1.0}}}}},"r":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":21,"docs":{"100":{"tf":1.0},"103":{"tf":1.0},"109":{"tf":1.4142135623730951},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.4142135623730951},"116":{"tf":1.0},"119":{"tf":1.4142135623730951},"122":{"tf":1.0},"138":{"tf":1.4142135623730951},"170":{"tf":1.0},"174":{"tf":1.0},"176":{"tf":1.0},"186":{"tf":1.0},"209":{"tf":1.0},"218":{"tf":1.0},"221":{"tf":1.0},"226":{"tf":1.0},"230":{"tf":1.0},"24":{"tf":1.0},"98":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"203":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"116":{"tf":1.0},"144":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"12":{"tf":1.4142135623730951},"120":{"tf":1.0},"123":{"tf":1.0},"210":{"tf":1.0},"226":{"tf":1.0}}}}}}},"i":{"c":{"df":2,"docs":{"121":{"tf":1.0},"129":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":1,"docs":{"133":{"tf":1.4142135623730951}}}},"y":{"df":1,"docs":{"230":{"tf":1.0}}}},"d":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"148":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":6,"docs":{"113":{"tf":2.23606797749979},"120":{"tf":1.0},"128":{"tf":1.0},"138":{"tf":2.6457513110645907},"139":{"tf":1.0},"140":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"126":{"tf":1.0},"138":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":20,"docs":{"116":{"tf":1.0},"117":{"tf":1.4142135623730951},"121":{"tf":1.0},"129":{"tf":1.0},"131":{"tf":1.4142135623730951},"149":{"tf":1.0},"151":{"tf":1.0},"167":{"tf":1.0},"169":{"tf":1.0},"174":{"tf":1.0},"177":{"tf":1.0},"183":{"tf":1.4142135623730951},"187":{"tf":1.4142135623730951},"188":{"tf":1.7320508075688772},"189":{"tf":1.4142135623730951},"190":{"tf":1.0},"192":{"tf":1.0},"200":{"tf":1.0},"3":{"tf":1.4142135623730951},"94":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":12,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"178":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.4142135623730951},"210":{"tf":1.0},"221":{"tf":1.0},"223":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.0},"5":{"tf":1.0},"86":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"t":{"df":2,"docs":{"218":{"tf":1.0},"226":{"tf":1.0}}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"202":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"*":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"129":{"tf":1.0}}}}}},"df":1,"docs":{"129":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"117":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"|":{"_":{"df":1,"docs":{"135":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"r":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"121":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"121":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"121":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"226":{"tf":1.0}}}}}}},"df":1,"docs":{"7":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"179":{"tf":1.0},"229":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.4142135623730951},"91":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"195":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":4,"docs":{"148":{"tf":1.0},"164":{"tf":1.0},"17":{"tf":1.0},"173":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"214":{"tf":1.0}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":14,"docs":{"113":{"tf":1.0},"121":{"tf":1.4142135623730951},"129":{"tf":3.3166247903554},"138":{"tf":1.0},"152":{"tf":2.6457513110645907},"153":{"tf":1.7320508075688772},"161":{"tf":1.4142135623730951},"164":{"tf":1.0},"169":{"tf":1.4142135623730951},"214":{"tf":1.4142135623730951},"218":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"64":{"tf":1.0},"70":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"129":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":12,"docs":{"114":{"tf":1.0},"141":{"tf":1.4142135623730951},"151":{"tf":1.4142135623730951},"169":{"tf":1.4142135623730951},"210":{"tf":1.7320508075688772},"211":{"tf":1.0},"214":{"tf":1.0},"217":{"tf":1.0},"218":{"tf":1.4142135623730951},"221":{"tf":1.0},"223":{"tf":2.6457513110645907},"224":{"tf":1.0}}}}}},"df":0,"docs":{}}},"u":{"b":{"df":1,"docs":{"7":{"tf":1.0}}},"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"130":{"tf":1.0}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":7,"docs":{"0":{"tf":1.4142135623730951},"116":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"127":{"tf":1.0},"211":{"tf":1.0},"89":{"tf":2.449489742783178}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"137":{"tf":1.0}}}}}}}},"u":{"b":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"4":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"214":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"129":{"tf":1.0}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"213":{"tf":1.7320508075688772},"214":{"tf":1.0},"223":{"tf":1.4142135623730951},"225":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"124":{"tf":1.0},"128":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"214":{"tf":2.0},"223":{"tf":1.0},"226":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"229":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"103":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":9,"docs":{"176":{"tf":1.0},"177":{"tf":3.4641016151377544},"179":{"tf":1.0},"180":{"tf":1.0},"182":{"tf":1.0},"183":{"tf":1.0},"186":{"tf":1.0},"203":{"tf":1.4142135623730951},"226":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"177":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"122":{"tf":1.0},"222":{"tf":1.0},"223":{"tf":1.0}}}}}}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"148":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"h":{"df":13,"docs":{"121":{"tf":1.0},"145":{"tf":1.4142135623730951},"151":{"tf":1.7320508075688772},"152":{"tf":1.0},"153":{"tf":1.0},"159":{"tf":1.0},"161":{"tf":1.4142135623730951},"167":{"tf":1.0},"169":{"tf":1.4142135623730951},"197":{"tf":1.0},"202":{"tf":1.0},"223":{"tf":1.7320508075688772},"7":{"tf":1.0}}}},"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"177":{"tf":1.7320508075688772}}}},"df":1,"docs":{"86":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":4,"docs":{"167":{"tf":1.0},"214":{"tf":1.0},"226":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{},"x":{"df":1,"docs":{"116":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":27,"docs":{"0":{"tf":1.0},"105":{"tf":1.0},"114":{"tf":1.4142135623730951},"119":{"tf":1.0},"121":{"tf":1.4142135623730951},"127":{"tf":1.4142135623730951},"138":{"tf":1.4142135623730951},"141":{"tf":2.449489742783178},"146":{"tf":2.0},"147":{"tf":3.0},"148":{"tf":2.23606797749979},"166":{"tf":1.0},"186":{"tf":1.4142135623730951},"202":{"tf":1.0},"203":{"tf":1.0},"226":{"tf":1.0},"229":{"tf":1.0},"34":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.4142135623730951},"58":{"tf":1.7320508075688772},"71":{"tf":1.4142135623730951},"81":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"92":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"103":{"tf":1.0},"115":{"tf":1.0},"120":{"tf":1.0},"142":{"tf":1.0},"146":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"199":{"tf":1.0},"209":{"tf":1.0},"213":{"tf":1.4142135623730951},"223":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"82":{"tf":1.0}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"147":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"124":{"tf":1.0},"161":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":9,"docs":{"109":{"tf":1.0},"121":{"tf":1.4142135623730951},"129":{"tf":1.0},"202":{"tf":1.0},"219":{"tf":1.0},"226":{"tf":1.7320508075688772},"31":{"tf":1.0},"62":{"tf":1.0},"7":{"tf":1.7320508075688772}}}},"s":{"df":4,"docs":{"0":{"tf":1.0},"161":{"tf":1.0},"163":{"tf":1.0},"167":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":7,"docs":{"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"58":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.4142135623730951}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":20,"docs":{"102":{"tf":1.4142135623730951},"105":{"tf":1.0},"116":{"tf":1.0},"125":{"tf":1.0},"128":{"tf":1.0},"132":{"tf":1.0},"144":{"tf":1.0},"177":{"tf":1.4142135623730951},"178":{"tf":1.0},"179":{"tf":1.4142135623730951},"180":{"tf":1.0},"182":{"tf":1.0},"183":{"tf":1.4142135623730951},"186":{"tf":2.449489742783178},"188":{"tf":1.0},"192":{"tf":1.0},"4":{"tf":1.0},"92":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"119":{"tf":1.0}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"221":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{}}}}},"y":{"df":0,"docs":{},"m":{"!":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"163":{"tf":1.0},"164":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"170":{"tf":1.0},"173":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"173":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"172":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"171":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"163":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"164":{"tf":1.0}}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":4,"docs":{"143":{"tf":1.0},"144":{"tf":1.0},"158":{"tf":1.7320508075688772},"163":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"n":{"c":{"df":9,"docs":{"175":{"tf":1.4142135623730951},"176":{"tf":2.23606797749979},"178":{"tf":1.0},"179":{"tf":2.449489742783178},"180":{"tf":1.7320508075688772},"182":{"tf":1.0},"183":{"tf":1.0},"203":{"tf":2.0},"230":{"tf":1.0}},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"203":{"tf":1.0}}}}}}},"df":2,"docs":{"217":{"tf":1.4142135623730951},"220":{"tf":1.0}},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"145":{"tf":1.4142135623730951},"223":{"tf":1.0}}}},"df":0,"docs":{},"x":{"'":{"df":1,"docs":{"226":{"tf":1.0}}},":":{":":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"212":{"tf":1.0},"214":{"tf":1.4142135623730951}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"214":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":2,"docs":{"217":{"tf":1.0},"220":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"167":{"tf":1.0}}}}}}}}},"df":20,"docs":{"107":{"tf":1.0},"122":{"tf":1.0},"144":{"tf":1.7320508075688772},"166":{"tf":1.0},"209":{"tf":1.4142135623730951},"210":{"tf":1.0},"211":{"tf":1.7320508075688772},"212":{"tf":2.0},"213":{"tf":2.6457513110645907},"214":{"tf":1.7320508075688772},"217":{"tf":2.0},"219":{"tf":1.0},"220":{"tf":2.6457513110645907},"221":{"tf":1.0},"222":{"tf":2.0},"223":{"tf":4.0},"224":{"tf":1.7320508075688772},"225":{"tf":1.0},"226":{"tf":3.872983346207417},"99":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":8,"docs":{"118":{"tf":1.0},"144":{"tf":1.4142135623730951},"153":{"tf":1.0},"155":{"tf":1.4142135623730951},"161":{"tf":1.0},"203":{"tf":1.4142135623730951},"211":{"tf":1.0},"226":{"tf":1.4142135623730951}}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"213":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":7,"docs":{"183":{"tf":1.0},"186":{"tf":1.0},"187":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.7320508075688772},"192":{"tf":1.4142135623730951},"223":{"tf":1.4142135623730951}}},"k":{"df":0,"docs":{},"e":{"df":21,"docs":{"101":{"tf":1.0},"108":{"tf":1.0},"111":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.7320508075688772},"152":{"tf":1.0},"154":{"tf":1.0},"159":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"167":{"tf":1.0},"175":{"tf":1.0},"186":{"tf":1.0},"197":{"tf":1.0},"223":{"tf":1.0},"226":{"tf":1.0},"228":{"tf":1.0},"230":{"tf":2.0},"3":{"tf":1.0},"4":{"tf":1.0}},"n":{"df":2,"docs":{"185":{"tf":1.0},"99":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"k":{"df":3,"docs":{"141":{"tf":1.0},"147":{"tf":1.0},"154":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"75":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"df":7,"docs":{"157":{"tf":1.0},"172":{"tf":1.4142135623730951},"226":{"tf":1.0},"5":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"k":{"df":5,"docs":{"136":{"tf":1.0},"199":{"tf":1.4142135623730951},"208":{"tf":1.0},"210":{"tf":1.4142135623730951},"223":{"tf":1.0}}}},"t":{"a":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"x":{"df":10,"docs":{"107":{"tf":1.0},"121":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"169":{"tf":1.0},"170":{"tf":1.0},"172":{"tf":1.4142135623730951},"173":{"tf":1.0}}}},"d":{"d":{"df":1,"docs":{"136":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"161":{"tf":1.7320508075688772},"77":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"df":13,"docs":{"132":{"tf":1.0},"179":{"tf":1.0},"181":{"tf":1.0},"183":{"tf":1.4142135623730951},"187":{"tf":1.0},"199":{"tf":1.4142135623730951},"200":{"tf":2.0},"201":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":4.0},"227":{"tf":1.4142135623730951},"229":{"tf":2.0},"230":{"tf":2.6457513110645907}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"141":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"203":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}}}},"s":{"df":0,"docs":{},"t":{"_":{"df":1,"docs":{"103":{"tf":1.0}}},"df":44,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.4142135623730951},"103":{"tf":3.4641016151377544},"104":{"tf":1.4142135623730951},"109":{"tf":2.0},"112":{"tf":1.0},"113":{"tf":3.605551275463989},"114":{"tf":2.23606797749979},"115":{"tf":1.7320508075688772},"119":{"tf":1.4142135623730951},"120":{"tf":2.6457513110645907},"121":{"tf":1.4142135623730951},"126":{"tf":1.0},"128":{"tf":1.4142135623730951},"129":{"tf":2.23606797749979},"136":{"tf":1.7320508075688772},"137":{"tf":2.0},"138":{"tf":4.123105625617661},"139":{"tf":2.449489742783178},"14":{"tf":1.4142135623730951},"140":{"tf":1.4142135623730951},"141":{"tf":2.0},"142":{"tf":1.7320508075688772},"146":{"tf":1.0},"149":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"174":{"tf":1.0},"18":{"tf":1.4142135623730951},"182":{"tf":2.0},"183":{"tf":1.7320508075688772},"19":{"tf":1.4142135623730951},"195":{"tf":1.0},"203":{"tf":1.4142135623730951},"210":{"tf":1.0},"214":{"tf":1.0},"215":{"tf":1.0},"22":{"tf":1.4142135623730951},"223":{"tf":1.0},"23":{"tf":1.4142135623730951},"36":{"tf":1.0},"82":{"tf":1.0},"96":{"tf":1.4142135623730951},"98":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"113":{"tf":1.0},"140":{"tf":1.0}},"e":{"=":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":1,"docs":{"103":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"113":{"tf":1.4142135623730951},"138":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{",":{"b":{"a":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"s":{",":{"b":{"a":{"df":0,"docs":{},"z":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"138":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"2":{",":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"3":{"df":1,"docs":{"113":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"/":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"1":{"0":{":":{"1":{"2":{"df":1,"docs":{"148":{"tf":1.0}}},"df":0,"docs":{}},"5":{"df":1,"docs":{"148":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":4,"docs":{"112":{"tf":1.0},"113":{"tf":1.0},"133":{"tf":1.4142135623730951},"138":{"tf":1.0}},"s":{":":{"1":{"3":{":":{"8":{"df":1,"docs":{"138":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{":":{"4":{"df":1,"docs":{"138":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{":":{"1":{"2":{"df":1,"docs":{"138":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"121":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"3":{"9":{"0":{":":{"1":{"3":{"df":1,"docs":{"148":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"3":{"7":{":":{"1":{"4":{"df":1,"docs":{"147":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"_":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"6":{":":{"2":{"5":{"df":1,"docs":{"148":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":5,"docs":{"112":{"tf":1.0},"113":{"tf":1.4142135623730951},"129":{"tf":1.4142135623730951},"139":{"tf":1.0},"140":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}},"x":{"df":1,"docs":{"43":{"tf":1.0}},"t":{"df":3,"docs":{"116":{"tf":1.0},"119":{"tf":1.0},"195":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":3,"docs":{"109":{"tf":1.0},"116":{"tf":1.0},"147":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"a":{"d":{"d":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"121":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"213":{"tf":1.0}}}}}}},"n":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"210":{"tf":1.4142135623730951}}}}}},"[":{"0":{"]":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"210":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"'":{"df":6,"docs":{"135":{"tf":1.0},"176":{"tf":1.4142135623730951},"177":{"tf":1.4142135623730951},"203":{"tf":1.4142135623730951},"214":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":8,"docs":{"144":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"211":{"tf":1.0},"213":{"tf":1.0},"219":{"tf":1.0},"220":{"tf":1.0},"224":{"tf":1.0}}}}}}},"y":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"230":{"tf":1.0}}}},"r":{"df":2,"docs":{"154":{"tf":1.0},"203":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":10,"docs":{"100":{"tf":1.0},"116":{"tf":1.4142135623730951},"124":{"tf":1.4142135623730951},"130":{"tf":1.4142135623730951},"133":{"tf":1.4142135623730951},"160":{"tf":1.0},"174":{"tf":1.0},"197":{"tf":1.0},"201":{"tf":1.0},"203":{"tf":2.0}}},"k":{"df":6,"docs":{"138":{"tf":1.0},"144":{"tf":1.0},"154":{"tf":1.0},"203":{"tf":1.0},"223":{"tf":1.0},"229":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":16,"docs":{"100":{"tf":1.0},"113":{"tf":1.0},"139":{"tf":1.0},"140":{"tf":1.4142135623730951},"154":{"tf":1.0},"178":{"tf":1.0},"186":{"tf":1.7320508075688772},"192":{"tf":1.0},"197":{"tf":1.0},"204":{"tf":1.0},"214":{"tf":1.0},"226":{"tf":1.0},"5":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":6,"docs":{"113":{"tf":1.0},"177":{"tf":1.0},"182":{"tf":1.0},"186":{"tf":1.0},"203":{"tf":1.0},"221":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"230":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":8,"docs":{"157":{"tf":1.0},"161":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"213":{"tf":1.0},"226":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.0}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":18,"docs":{"129":{"tf":1.0},"33":{"tf":1.0},"38":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":9,"docs":{"100":{"tf":1.0},"104":{"tf":1.0},"109":{"tf":1.0},"139":{"tf":1.0},"145":{"tf":1.0},"172":{"tf":1.0},"177":{"tf":1.0},"223":{"tf":1.0},"5":{"tf":1.7320508075688772}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"130":{"tf":1.0},"90":{"tf":1.0}}}}}}}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"165":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"b":{"df":1,"docs":{"43":{"tf":1.0}}},"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":20,"docs":{"100":{"tf":1.4142135623730951},"102":{"tf":1.0},"109":{"tf":1.0},"154":{"tf":1.0},"164":{"tf":1.0},"166":{"tf":1.0},"176":{"tf":1.4142135623730951},"177":{"tf":1.0},"179":{"tf":1.0},"185":{"tf":1.0},"186":{"tf":1.0},"193":{"tf":1.0},"196":{"tf":1.0},"197":{"tf":1.4142135623730951},"200":{"tf":1.0},"203":{"tf":1.4142135623730951},"222":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":2.0},"98":{"tf":1.0}}}},"p":{"df":2,"docs":{"108":{"tf":1.0},"127":{"tf":1.0}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}},"l":{"df":1,"docs":{"183":{"tf":1.0}}}}},"l":{";":{"d":{"df":0,"docs":{},"r":{"df":1,"docs":{"179":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"o":{"!":{"(":{"\"":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"161":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"161":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"119":{"tf":1.0},"175":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"27":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":6,"docs":{"131":{"tf":1.4142135623730951},"133":{"tf":1.0},"175":{"tf":1.0},"187":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"l":{"df":3,"docs":{"129":{"tf":1.0},"139":{"tf":1.4142135623730951},"7":{"tf":1.0}}}},"o":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"73":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"74":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"=":{"<":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"125":{"tf":1.0}}}}}}}}}},"df":7,"docs":{"1":{"tf":1.4142135623730951},"108":{"tf":2.6457513110645907},"115":{"tf":1.4142135623730951},"125":{"tf":1.0},"179":{"tf":1.0},"2":{"tf":1.0},"93":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":15,"docs":{"101":{"tf":1.0},"104":{"tf":1.7320508075688772},"105":{"tf":1.0},"111":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"125":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"148":{"tf":1.0},"168":{"tf":1.4142135623730951},"186":{"tf":1.0},"203":{"tf":1.4142135623730951},"223":{"tf":1.0},"226":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"168":{"tf":1.0}}}}}}},"p":{"df":4,"docs":{"138":{"tf":1.0},"141":{"tf":1.0},"186":{"tf":1.0},"196":{"tf":1.0}},"i":{"c":{"df":2,"docs":{"199":{"tf":1.0},"203":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"230":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"o":{"df":1,"docs":{"7":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"203":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"146":{"tf":1.0},"200":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":4,"docs":{"201":{"tf":1.0},"204":{"tf":1.4142135623730951},"227":{"tf":1.0},"230":{"tf":1.0}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"112":{"tf":1.0},"133":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"200":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"81":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"t":{"df":22,"docs":{"113":{"tf":1.4142135623730951},"119":{"tf":1.0},"138":{"tf":1.4142135623730951},"143":{"tf":1.0},"144":{"tf":1.4142135623730951},"145":{"tf":1.0},"146":{"tf":1.7320508075688772},"155":{"tf":1.7320508075688772},"157":{"tf":1.7320508075688772},"158":{"tf":1.4142135623730951},"159":{"tf":2.0},"160":{"tf":1.7320508075688772},"161":{"tf":2.449489742783178},"163":{"tf":1.4142135623730951},"168":{"tf":1.0},"169":{"tf":1.0},"172":{"tf":2.449489742783178},"21":{"tf":1.4142135623730951},"217":{"tf":1.7320508075688772},"220":{"tf":2.23606797749979},"222":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"131":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"v":{"df":0,"docs":{},"i":{"df":1,"docs":{"96":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":15,"docs":{"107":{"tf":1.0},"144":{"tf":1.0},"166":{"tf":1.0},"188":{"tf":1.0},"209":{"tf":1.4142135623730951},"210":{"tf":1.0},"211":{"tf":1.7320508075688772},"212":{"tf":2.0},"214":{"tf":1.0},"217":{"tf":1.4142135623730951},"220":{"tf":2.449489742783178},"222":{"tf":2.0},"223":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0}}}},"i":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"100":{"tf":1.0},"203":{"tf":2.449489742783178},"228":{"tf":1.0},"229":{"tf":1.4142135623730951}}}},"df":7,"docs":{"115":{"tf":1.0},"142":{"tf":1.0},"148":{"tf":1.0},"186":{"tf":1.0},"229":{"tf":1.0},"5":{"tf":1.0},"85":{"tf":1.0}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":19,"docs":{"113":{"tf":1.0},"121":{"tf":1.4142135623730951},"124":{"tf":1.4142135623730951},"134":{"tf":1.0},"137":{"tf":1.0},"140":{"tf":1.0},"166":{"tf":1.4142135623730951},"31":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"77":{"tf":1.0},"79":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"210":{"tf":1.0},"75":{"tf":1.0},"88":{"tf":1.0}},"l":{"df":0,"docs":{},"y":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":2,"docs":{"34":{"tf":1.0},"75":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"e":{"df":11,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"167":{"tf":1.0},"174":{"tf":1.4142135623730951},"213":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0},"44":{"tf":1.0},"78":{"tf":1.0}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"y":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"161":{"tf":1.0},"213":{"tf":1.0}},"e":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"n":{"df":6,"docs":{"113":{"tf":1.0},"117":{"tf":1.0},"138":{"tf":1.0},"203":{"tf":1.0},"221":{"tf":1.0},"5":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":23,"docs":{"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"133":{"tf":1.4142135623730951},"140":{"tf":1.0},"143":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.0},"151":{"tf":1.0},"162":{"tf":1.0},"167":{"tf":1.7320508075688772},"169":{"tf":1.4142135623730951},"174":{"tf":1.4142135623730951},"175":{"tf":1.0},"176":{"tf":1.0},"201":{"tf":1.0},"203":{"tf":1.0},"214":{"tf":2.0},"221":{"tf":1.0},"226":{"tf":1.4142135623730951},"229":{"tf":1.4142135623730951},"230":{"tf":1.7320508075688772},"5":{"tf":1.0},"69":{"tf":1.0}}}},"y":{"'":{"df":1,"docs":{"152":{"tf":1.0}}},".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"152":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"153":{"tf":1.7320508075688772},"169":{"tf":1.0}}},"df":0,"docs":{}}}}},":":{":":{"a":{"d":{"df":0,"docs":{},"t":{"(":{"a":{"d":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":2,"docs":{"153":{"tf":1.0},"169":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"161":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"161":{"tf":1.0}}}},"df":0,"docs":{}}},"df":2,"docs":{"155":{"tf":1.0},"161":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"161":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"161":{"tf":1.0}},"e":{"(":{"c":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"x":{"df":2,"docs":{"155":{"tf":1.0},"161":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"u":{"8":{"df":1,"docs":{"155":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"154":{"tf":2.23606797749979},"161":{"tf":1.0}}},"y":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"130":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"<":{"'":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"x":{">":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"d":{"<":{"'":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"152":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"151":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"159":{"tf":1.0},"172":{"tf":1.0}}}}}},"df":14,"docs":{"150":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":2.8284271247461903},"153":{"tf":1.4142135623730951},"155":{"tf":1.4142135623730951},"156":{"tf":1.0},"157":{"tf":1.0},"159":{"tf":1.7320508075688772},"161":{"tf":2.23606797749979},"164":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.7320508075688772},"171":{"tf":1.7320508075688772},"172":{"tf":1.7320508075688772}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"152":{"tf":1.0},"153":{"tf":2.0},"161":{"tf":1.0},"169":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"'":{"df":2,"docs":{"112":{"tf":1.0},"133":{"tf":1.0}}},"=":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"113":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"112":{"tf":1.0},"133":{"tf":1.0}}}},"df":0,"docs":{}}}}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"59":{"tf":1.0},"62":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}}}},"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"145":{"tf":1.0}},"s":{"'":{"df":1,"docs":{"169":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"151":{"tf":2.23606797749979},"169":{"tf":2.0}},"s":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"154":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":52,"docs":{"107":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.4142135623730951},"112":{"tf":2.0},"118":{"tf":2.0},"129":{"tf":1.7320508075688772},"131":{"tf":2.23606797749979},"133":{"tf":3.0},"134":{"tf":1.4142135623730951},"143":{"tf":1.4142135623730951},"144":{"tf":2.0},"145":{"tf":2.449489742783178},"148":{"tf":1.0},"150":{"tf":1.4142135623730951},"151":{"tf":2.0},"152":{"tf":2.6457513110645907},"153":{"tf":2.23606797749979},"154":{"tf":2.0},"155":{"tf":2.0},"156":{"tf":1.0},"157":{"tf":1.4142135623730951},"158":{"tf":1.0},"160":{"tf":1.0},"161":{"tf":4.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"168":{"tf":2.23606797749979},"169":{"tf":3.3166247903554},"170":{"tf":1.4142135623730951},"171":{"tf":3.0},"172":{"tf":2.23606797749979},"173":{"tf":1.7320508075688772},"178":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":1.7320508075688772},"214":{"tf":3.3166247903554},"219":{"tf":1.4142135623730951},"220":{"tf":1.0},"226":{"tf":1.0},"30":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"35":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"44":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"63":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"80":{"tf":1.0}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"i":{"c":{"df":1,"docs":{"230":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":2,"docs":{"103":{"tf":1.0},"185":{"tf":1.0}}}}}},"u":{"3":{"2":{"df":1,"docs":{"154":{"tf":2.0}}},"df":0,"docs":{}},"8":{"df":2,"docs":{"155":{"tf":1.4142135623730951},"161":{"tf":1.7320508075688772}}},"b":{"df":1,"docs":{"107":{"tf":1.0}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"94":{"tf":1.0}}}}}}},"df":1,"docs":{"182":{"tf":1.0}},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"113":{"tf":1.0},"138":{"tf":1.0}}}}}}},"df":8,"docs":{"103":{"tf":1.7320508075688772},"113":{"tf":1.7320508075688772},"119":{"tf":1.4142135623730951},"120":{"tf":1.0},"128":{"tf":1.0},"138":{"tf":2.0},"146":{"tf":1.0},"149":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"103":{"tf":1.4142135623730951},"113":{"tf":1.4142135623730951},"120":{"tf":1.0},"138":{"tf":1.4142135623730951},"140":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"177":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"202":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"230":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"32":{"tf":1.7320508075688772}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"222":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"_":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"107":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"107":{"tf":1.0},"145":{"tf":1.0}}}}},"r":{"df":8,"docs":{"0":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"116":{"tf":1.0},"131":{"tf":1.4142135623730951},"140":{"tf":1.0},"177":{"tf":1.0},"204":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"151":{"tf":1.0},"169":{"tf":1.0}}}},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":7,"docs":{"123":{"tf":1.0},"146":{"tf":1.0},"148":{"tf":1.0},"154":{"tf":1.4142135623730951},"155":{"tf":1.0},"161":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"167":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"166":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"130":{"tf":1.0},"174":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"200":{"tf":1.0}}}},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.4142135623730951}},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"16":{"tf":1.0},"62":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"7":{"tf":1.0}}}},"t":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"131":{"tf":1.0}}}}}},"df":2,"docs":{"120":{"tf":1.0},"134":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"165":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"118":{"tf":1.0},"119":{"tf":1.0},"174":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":3,"docs":{"112":{"tf":1.0},"133":{"tf":1.0},"221":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":1.0}}},"y":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"34":{"tf":1.0},"77":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"z":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":3,"docs":{"115":{"tf":1.0},"142":{"tf":1.0},"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"166":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"225":{"tf":1.0}}}}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":3,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"83":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"166":{"tf":1.0},"176":{"tf":1.0},"210":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"111":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"224":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"133":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"22":{"tf":1.0}}}}},"df":3,"docs":{"161":{"tf":1.0},"22":{"tf":1.4142135623730951},"5":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"185":{"tf":1.0},"186":{"tf":1.7320508075688772},"204":{"tf":1.0}}}}},"d":{"a":{"df":0,"docs":{},"t":{"df":25,"docs":{"102":{"tf":1.0},"103":{"tf":1.7320508075688772},"104":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"113":{"tf":1.4142135623730951},"116":{"tf":1.4142135623730951},"120":{"tf":1.0},"121":{"tf":1.0},"129":{"tf":1.0},"131":{"tf":1.0},"133":{"tf":1.4142135623730951},"138":{"tf":1.4142135623730951},"175":{"tf":1.0},"183":{"tf":1.0},"184":{"tf":1.4142135623730951},"185":{"tf":2.0},"186":{"tf":2.23606797749979},"187":{"tf":1.4142135623730951},"189":{"tf":1.4142135623730951},"192":{"tf":1.7320508075688772},"193":{"tf":2.449489742783178},"196":{"tf":1.4142135623730951},"222":{"tf":1.0},"230":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"104":{"tf":1.0},"117":{"tf":1.4142135623730951},"128":{"tf":1.0},"135":{"tf":1.0},"203":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":18,"docs":{"107":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"115":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.0},"131":{"tf":1.0},"134":{"tf":1.0},"146":{"tf":1.0},"168":{"tf":1.0},"176":{"tf":1.0},"179":{"tf":1.0},"188":{"tf":1.0},"200":{"tf":1.0},"201":{"tf":1.4142135623730951},"202":{"tf":1.4142135623730951},"203":{"tf":1.4142135623730951},"229":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":2,"docs":{"34":{"tf":1.0},"79":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"79":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"/":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"188":{"tf":1.4142135623730951},"189":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"102":{"tf":1.0},"179":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":9,"docs":{"102":{"tf":2.23606797749979},"178":{"tf":2.0},"179":{"tf":1.4142135623730951},"180":{"tf":1.0},"188":{"tf":1.0},"189":{"tf":1.4142135623730951},"190":{"tf":1.4142135623730951},"191":{"tf":1.4142135623730951},"192":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"176":{"tf":1.0}}}}}},"l":{"df":1,"docs":{"178":{"tf":1.0}}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"199":{"tf":1.0},"200":{"tf":1.0},"202":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":5,"docs":{"1":{"tf":1.0},"104":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"4":{"tf":1.0}}}},"df":98,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.4142135623730951},"108":{"tf":1.7320508075688772},"111":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"116":{"tf":2.449489742783178},"117":{"tf":1.7320508075688772},"118":{"tf":1.7320508075688772},"119":{"tf":1.0},"120":{"tf":1.7320508075688772},"121":{"tf":2.0},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.4142135623730951},"126":{"tf":1.0},"129":{"tf":1.7320508075688772},"131":{"tf":1.0},"133":{"tf":2.449489742783178},"134":{"tf":1.0},"135":{"tf":1.0},"138":{"tf":1.0},"141":{"tf":2.0},"142":{"tf":1.0},"143":{"tf":1.4142135623730951},"144":{"tf":1.4142135623730951},"145":{"tf":1.0},"146":{"tf":1.4142135623730951},"147":{"tf":2.449489742783178},"148":{"tf":2.23606797749979},"151":{"tf":2.0},"152":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.4142135623730951},"155":{"tf":1.4142135623730951},"156":{"tf":1.4142135623730951},"158":{"tf":2.23606797749979},"159":{"tf":2.449489742783178},"160":{"tf":2.23606797749979},"161":{"tf":2.8284271247461903},"163":{"tf":2.23606797749979},"164":{"tf":2.23606797749979},"167":{"tf":1.4142135623730951},"168":{"tf":1.0},"169":{"tf":2.23606797749979},"17":{"tf":1.0},"171":{"tf":2.8284271247461903},"172":{"tf":2.8284271247461903},"173":{"tf":1.4142135623730951},"174":{"tf":2.6457513110645907},"177":{"tf":1.0},"179":{"tf":1.4142135623730951},"186":{"tf":1.0},"188":{"tf":1.0},"196":{"tf":1.4142135623730951},"197":{"tf":1.0},"2":{"tf":1.0},"202":{"tf":2.0},"203":{"tf":1.7320508075688772},"209":{"tf":1.0},"21":{"tf":1.0},"211":{"tf":2.23606797749979},"212":{"tf":1.4142135623730951},"213":{"tf":1.4142135623730951},"214":{"tf":1.7320508075688772},"215":{"tf":1.4142135623730951},"217":{"tf":1.0},"221":{"tf":2.0},"222":{"tf":1.0},"223":{"tf":1.4142135623730951},"226":{"tf":2.6457513110645907},"228":{"tf":1.0},"229":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"4":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":1.4142135623730951},"5":{"tf":2.449489742783178},"58":{"tf":1.0},"6":{"tf":2.23606797749979},"69":{"tf":1.4142135623730951},"7":{"tf":2.8284271247461903},"81":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.7320508075688772},"92":{"tf":1.0},"93":{"tf":2.0},"94":{"tf":1.4142135623730951},"95":{"tf":1.0},"96":{"tf":1.7320508075688772},"97":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"155":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":2,"docs":{"23":{"tf":1.4142135623730951},"72":{"tf":1.0}}},"df":0,"docs":{}}}},"df":3,"docs":{"0":{"tf":1.4142135623730951},"23":{"tf":1.0},"85":{"tf":1.0}}}}}},"r":{"df":20,"docs":{"129":{"tf":1.0},"141":{"tf":1.0},"147":{"tf":1.0},"148":{"tf":1.4142135623730951},"154":{"tf":1.0},"163":{"tf":1.0},"166":{"tf":1.7320508075688772},"167":{"tf":1.4142135623730951},"177":{"tf":1.0},"197":{"tf":1.0},"200":{"tf":1.0},"201":{"tf":1.0},"202":{"tf":2.0},"204":{"tf":2.0},"214":{"tf":1.7320508075688772},"222":{"tf":1.0},"223":{"tf":1.7320508075688772},"226":{"tf":1.0},"84":{"tf":1.0},"90":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{">":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"102":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"218":{"tf":1.0}}}},"r":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"177":{"tf":2.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"u":{"a":{"df":0,"docs":{},"l":{"df":10,"docs":{"1":{"tf":1.0},"129":{"tf":1.4142135623730951},"186":{"tf":1.0},"192":{"tf":1.0},"197":{"tf":1.0},"230":{"tf":1.7320508075688772},"5":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"186":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":10,"docs":{"130":{"tf":1.4142135623730951},"131":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"150":{"tf":1.0},"159":{"tf":1.0},"164":{"tf":1.0},"167":{"tf":1.0},"172":{"tf":1.4142135623730951},"29":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":6,"docs":{"105":{"tf":1.0},"141":{"tf":1.0},"217":{"tf":1.0},"219":{"tf":1.7320508075688772},"226":{"tf":1.0},"43":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"u":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"230":{"tf":1.0}}}},"df":0,"docs":{}},"df":89,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"116":{"tf":1.0},"12":{"tf":1.0},"121":{"tf":1.4142135623730951},"129":{"tf":3.3166247903554},"13":{"tf":1.0},"139":{"tf":1.4142135623730951},"14":{"tf":1.0},"147":{"tf":1.0},"148":{"tf":1.0},"15":{"tf":1.0},"151":{"tf":1.0},"16":{"tf":1.0},"169":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.7320508075688772},"212":{"tf":1.0},"213":{"tf":1.0},"214":{"tf":1.4142135623730951},"22":{"tf":1.0},"226":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":2.0},"27":{"tf":1.7320508075688772},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.0},"42":{"tf":1.0},"43":{"tf":2.0},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.7320508075688772},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":2.449489742783178},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"df":1,"docs":{"93":{"tf":1.0}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":7,"docs":{"113":{"tf":1.0},"129":{"tf":1.4142135623730951},"140":{"tf":1.0},"145":{"tf":1.0},"167":{"tf":2.23606797749979},"7":{"tf":2.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":9,"docs":{"120":{"tf":1.0},"153":{"tf":1.0},"163":{"tf":1.0},"213":{"tf":1.4142135623730951},"219":{"tf":1.7320508075688772},"27":{"tf":1.4142135623730951},"47":{"tf":1.7320508075688772},"48":{"tf":1.4142135623730951},"52":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"119":{"tf":1.0},"150":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":2,"docs":{"119":{"tf":1.0},"130":{"tf":1.0}}}}}}},"df":1,"docs":{"217":{"tf":2.23606797749979}},"e":{"c":{"!":{"[":{"1":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{":":{":":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"214":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":2,"docs":{"34":{"tf":1.0},"80":{"tf":1.0}}}}},"df":0,"docs":{}},"df":3,"docs":{"23":{"tf":1.0},"45":{"tf":2.0},"80":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"214":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"79":{"tf":1.0},"81":{"tf":1.0}},"e":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"81":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":7,"docs":{"152":{"tf":1.0},"167":{"tf":1.0},"185":{"tf":1.0},"211":{"tf":1.4142135623730951},"223":{"tf":1.0},"227":{"tf":1.0},"7":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":23,"docs":{"102":{"tf":1.4142135623730951},"105":{"tf":1.0},"109":{"tf":1.0},"116":{"tf":1.7320508075688772},"121":{"tf":2.23606797749979},"134":{"tf":1.0},"137":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.0},"179":{"tf":1.7320508075688772},"186":{"tf":1.4142135623730951},"187":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.0},"193":{"tf":1.7320508075688772},"203":{"tf":1.0},"210":{"tf":1.7320508075688772},"215":{"tf":1.0},"218":{"tf":1.0},"62":{"tf":1.7320508075688772},"7":{"tf":2.0},"94":{"tf":1.0}}}}}}}},"i":{"a":{"df":9,"docs":{"120":{"tf":1.0},"122":{"tf":1.0},"125":{"tf":1.0},"129":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.0},"56":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"108":{"tf":1.0},"195":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"120":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"61":{"tf":1.0},"64":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"226":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"144":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"230":{"tf":1.4142135623730951}}}}},"s":{"df":2,"docs":{"135":{"tf":1.0},"203":{"tf":1.0}}},"v":{"df":1,"docs":{"116":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"179":{"tf":1.0},"203":{"tf":1.0}}}},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"100":{"tf":1.0}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"186":{"tf":1.0}}}}}}}}}}},"n":{"df":0,"docs":{},"t":{"df":42,"docs":{"100":{"tf":1.4142135623730951},"103":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"113":{"tf":1.7320508075688772},"119":{"tf":1.0},"122":{"tf":1.0},"126":{"tf":1.0},"135":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":1.7320508075688772},"139":{"tf":1.0},"144":{"tf":1.0},"146":{"tf":1.0},"148":{"tf":1.0},"150":{"tf":1.0},"153":{"tf":1.0},"155":{"tf":1.0},"157":{"tf":1.4142135623730951},"158":{"tf":1.0},"159":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.4142135623730951},"167":{"tf":1.4142135623730951},"169":{"tf":1.0},"171":{"tf":1.0},"174":{"tf":1.4142135623730951},"178":{"tf":1.0},"184":{"tf":1.0},"186":{"tf":1.4142135623730951},"196":{"tf":1.0},"214":{"tf":1.0},"229":{"tf":1.4142135623730951},"230":{"tf":1.0},"5":{"tf":1.7320508075688772},"7":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"113":{"tf":1.0},"138":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"204":{"tf":1.0}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"c":{"a":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":19,"docs":{"0":{"tf":2.0},"105":{"tf":1.0},"127":{"tf":1.0},"134":{"tf":1.4142135623730951},"138":{"tf":1.4142135623730951},"147":{"tf":1.0},"148":{"tf":1.0},"154":{"tf":1.0},"27":{"tf":1.0},"5":{"tf":2.6457513110645907},"7":{"tf":2.449489742783178},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"89":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.7320508075688772}}}},"y":{"df":27,"docs":{"0":{"tf":1.4142135623730951},"112":{"tf":1.0},"122":{"tf":1.0},"133":{"tf":1.0},"151":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"169":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"174":{"tf":1.0},"176":{"tf":1.4142135623730951},"182":{"tf":1.0},"202":{"tf":1.0},"204":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.0},"214":{"tf":1.0},"222":{"tf":1.0},"225":{"tf":1.0},"228":{"tf":1.0},"230":{"tf":1.0},"5":{"tf":2.0},"87":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{":":{":":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":2,"docs":{"26":{"tf":1.0},"7":{"tf":2.0}},"e":{"'":{"d":{"df":2,"docs":{"135":{"tf":1.0},"167":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":8,"docs":{"112":{"tf":1.0},"113":{"tf":1.0},"132":{"tf":1.0},"138":{"tf":1.4142135623730951},"141":{"tf":1.0},"146":{"tf":1.0},"229":{"tf":1.4142135623730951},"230":{"tf":1.4142135623730951}}}},"v":{"df":1,"docs":{"154":{"tf":1.0}}}},"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"196":{"tf":1.0}},"g":{"df":0,"docs":{},"l":{"2":{"df":1,"docs":{"43":{"tf":1.0}}},"df":1,"docs":{"43":{"tf":1.0}}},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"43":{"tf":1.0}}}}},"p":{"df":1,"docs":{"43":{"tf":1.0}}},"r":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"df":6,"docs":{"175":{"tf":1.4142135623730951},"176":{"tf":1.4142135623730951},"185":{"tf":1.0},"202":{"tf":1.0},"229":{"tf":1.4142135623730951},"230":{"tf":2.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"176":{"tf":1.0},"203":{"tf":1.0}}}}}},"l":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":6,"docs":{"185":{"tf":1.0},"228":{"tf":1.0},"229":{"tf":1.7320508075688772},"230":{"tf":1.4142135623730951},"5":{"tf":1.0},"97":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":10,"docs":{"112":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"133":{"tf":1.0},"135":{"tf":1.0},"146":{"tf":1.0},"203":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.0},"227":{"tf":1.0}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"54":{"tf":1.0}}}}}}}}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"163":{"tf":1.0},"34":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":34,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"16":{"tf":1.0},"161":{"tf":1.4142135623730951},"163":{"tf":1.0},"164":{"tf":1.0},"17":{"tf":1.0},"170":{"tf":1.0},"174":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"212":{"tf":1.0},"214":{"tf":1.4142135623730951},"22":{"tf":1.0},"221":{"tf":1.0},"226":{"tf":1.0},"23":{"tf":1.0},"27":{"tf":1.0},"37":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"54":{"tf":1.4142135623730951},"61":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}}}}},"o":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"230":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":11,"docs":{"0":{"tf":1.0},"104":{"tf":1.0},"125":{"tf":1.0},"154":{"tf":1.0},"200":{"tf":1.0},"222":{"tf":1.0},"5":{"tf":1.7320508075688772},"7":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"167":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"l":{"d":{"c":{"a":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"29":{"tf":1.0},"82":{"tf":1.0}}}}}}}}},"df":3,"docs":{"29":{"tf":1.7320508075688772},"31":{"tf":1.0},"82":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":1,"docs":{"203":{"tf":1.0}}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"163":{"tf":1.0},"7":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":7,"docs":{"112":{"tf":1.0},"133":{"tf":1.0},"164":{"tf":1.0},"221":{"tf":1.0},"226":{"tf":1.0},"230":{"tf":1.0},"61":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":12,"docs":{"116":{"tf":1.0},"117":{"tf":1.0},"135":{"tf":1.0},"138":{"tf":1.0},"146":{"tf":1.0},"154":{"tf":1.4142135623730951},"192":{"tf":1.0},"204":{"tf":1.0},"213":{"tf":1.0},"222":{"tf":1.0},"230":{"tf":1.0},"6":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"<":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"<":{"'":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"152":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"112":{"tf":1.0},"133":{"tf":1.0},"202":{"tf":1.0},"31":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":4,"docs":{"127":{"tf":1.0},"186":{"tf":1.0},"29":{"tf":1.0},"43":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":30,"docs":{"100":{"tf":1.0},"102":{"tf":1.0},"104":{"tf":1.4142135623730951},"113":{"tf":1.4142135623730951},"114":{"tf":1.0},"119":{"tf":1.0},"122":{"tf":1.0},"129":{"tf":1.0},"133":{"tf":1.4142135623730951},"140":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":1.4142135623730951},"146":{"tf":1.4142135623730951},"150":{"tf":1.0},"165":{"tf":1.4142135623730951},"166":{"tf":1.0},"167":{"tf":1.7320508075688772},"174":{"tf":1.4142135623730951},"177":{"tf":1.7320508075688772},"197":{"tf":1.4142135623730951},"203":{"tf":2.6457513110645907},"214":{"tf":1.0},"222":{"tf":1.0},"224":{"tf":1.0},"226":{"tf":1.4142135623730951},"228":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"5":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"d":{"df":3,"docs":{"165":{"tf":1.0},"203":{"tf":1.0},"215":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"119":{"tf":1.0},"132":{"tf":1.0},"137":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"202":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"203":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"222":{"tf":1.0},"230":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"161":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":27,"docs":{"100":{"tf":1.0},"113":{"tf":1.0},"118":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951},"124":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"136":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":1.4142135623730951},"141":{"tf":1.0},"144":{"tf":1.0},"146":{"tf":1.0},"152":{"tf":1.0},"158":{"tf":1.0},"168":{"tf":1.4142135623730951},"186":{"tf":2.0},"202":{"tf":1.0},"210":{"tf":1.7320508075688772},"211":{"tf":1.4142135623730951},"214":{"tf":1.4142135623730951},"221":{"tf":1.0},"222":{"tf":1.4142135623730951},"223":{"tf":1.4142135623730951},"226":{"tf":2.23606797749979},"84":{"tf":1.0},"89":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":17,"docs":{"0":{"tf":1.4142135623730951},"111":{"tf":1.0},"129":{"tf":1.0},"146":{"tf":1.0},"155":{"tf":1.0},"166":{"tf":1.0},"175":{"tf":1.0},"210":{"tf":1.0},"215":{"tf":1.0},"221":{"tf":1.4142135623730951},"226":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"86":{"tf":1.7320508075688772},"87":{"tf":1.0},"88":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":4,"docs":{"0":{"tf":1.4142135623730951},"116":{"tf":1.0},"224":{"tf":1.0},"85":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":4,"docs":{"138":{"tf":1.0},"147":{"tf":1.0},"154":{"tf":1.0},"166":{"tf":1.0}}}}}}},"x":{"'":{"df":1,"docs":{"213":{"tf":1.0}}},".":{".":{"=":{"df":0,"docs":{},"i":{"df":1,"docs":{"147":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"147":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"167":{"tf":1.7320508075688772},"174":{"tf":1.0}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"144":{"tf":1.0},"145":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"182":{"tf":1.0},"183":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"167":{"tf":2.23606797749979},"174":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"167":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{".":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"167":{"tf":1.0},"174":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"167":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":10,"docs":{"144":{"tf":1.0},"145":{"tf":1.0},"148":{"tf":1.7320508075688772},"154":{"tf":1.0},"167":{"tf":1.0},"174":{"tf":1.0},"213":{"tf":3.3166247903554},"225":{"tf":1.0},"26":{"tf":1.0},"5":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"230":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"x":{"df":2,"docs":{"190":{"tf":1.0},"191":{"tf":1.0}}}},"y":{"c":{"b":{"c":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"213":{"tf":2.23606797749979},"26":{"tf":1.0},"5":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"206":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"144":{"tf":1.0},"230":{"tf":1.7320508075688772}}}},"r":{"df":12,"docs":{"1":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"184":{"tf":1.0},"186":{"tf":1.0},"187":{"tf":1.0},"194":{"tf":1.0},"229":{"tf":1.4142135623730951},"230":{"tf":2.0},"4":{"tf":1.0},"5":{"tf":1.0},"97":{"tf":1.4142135623730951}}},"v":{"df":4,"docs":{"102":{"tf":1.0},"186":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"113":{"tf":1.0},"138":{"tf":1.0}}}}}}}}},"y":{"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":1,"docs":{"179":{"tf":1.0}}}}}},"z":{"df":2,"docs":{"213":{"tf":1.0},"26":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":4,"docs":{"130":{"tf":1.0},"179":{"tf":1.0},"229":{"tf":1.4142135623730951},"230":{"tf":1.7320508075688772}}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"108":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"breadcrumbs":{"root":{"0":{".":{".":{"3":{")":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"(":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"148":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":1,"docs":{"148":{"tf":1.7320508075688772}},"f":{"6":{"4":{"df":1,"docs":{"148":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"4":{"8":{"df":1,"docs":{"138":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"/":{"df":0,"docs":{},"m":{"a":{"c":{"df":1,"docs":{"167":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"1":{"df":1,"docs":{"108":{"tf":1.4142135623730951}}},"3":{"df":1,"docs":{"209":{"tf":1.0}}},"7":{"df":1,"docs":{"108":{"tf":1.4142135623730951}}},"8":{"df":1,"docs":{"176":{"tf":1.0}}},"df":6,"docs":{"138":{"tf":2.0},"167":{"tf":1.4142135623730951},"174":{"tf":1.0},"223":{"tf":3.605551275463989},"49":{"tf":1.0},"5":{"tf":1.0}}},"1":{",":{"0":{"0":{"0":{"df":1,"docs":{"177":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"5":{",":{"0":{"df":1,"docs":{"121":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{".":{"1":{"df":1,"docs":{"147":{"tf":1.0}}},"=":{"1":{"df":1,"docs":{"147":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":2,"docs":{"100":{"tf":1.0},"84":{"tf":1.0}}},"2":{"9":{".":{"0":{"df":2,"docs":{"116":{"tf":1.0},"124":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"0":{".":{"0":{"df":1,"docs":{"7":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"4":{"4":{"df":1,"docs":{"121":{"tf":1.0}}},"5":{"df":1,"docs":{"121":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"7":{"0":{".":{"0":{"df":1,"docs":{"134":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"x":{"df":0,"docs":{},"x":{".":{"0":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"192":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":3,"docs":{"190":{"tf":1.0},"191":{"tf":1.4142135623730951},"192":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"193":{"tf":1.4142135623730951}}}}},"/":{"df":0,"docs":{},"g":{"df":3,"docs":{"186":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0}}}},"0":{"0":{"0":{"0":{"0":{"0":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"203":{"tf":1.0}}},"df":1,"docs":{"74":{"tf":1.0}}},"1":{"df":1,"docs":{"213":{"tf":1.0}}},"df":1,"docs":{"148":{"tf":1.4142135623730951}}},"2":{"8":{"df":2,"docs":{"52":{"tf":1.0},"77":{"tf":1.0}}},"df":2,"docs":{"131":{"tf":1.0},"209":{"tf":1.0}}},"6":{"3":{"8":{"4":{"df":2,"docs":{"50":{"tf":1.0},"53":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"2":{"8":{"df":1,"docs":{"206":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":16,"docs":{"0":{"tf":1.0},"147":{"tf":1.7320508075688772},"167":{"tf":2.0},"171":{"tf":1.0},"172":{"tf":1.0},"174":{"tf":1.4142135623730951},"186":{"tf":1.4142135623730951},"187":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"210":{"tf":1.4142135623730951},"223":{"tf":2.449489742783178},"225":{"tf":1.7320508075688772},"5":{"tf":1.0},"60":{"tf":1.0},"81":{"tf":1.0}}},"2":{".":{"0":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"0":{"0":{"df":2,"docs":{"48":{"tf":1.0},"72":{"tf":1.0}}},"1":{"6":{"df":1,"docs":{"206":{"tf":1.0}}},"8":{"df":1,"docs":{"6":{"tf":1.0}}},"9":{"df":1,"docs":{"209":{"tf":1.0}}},"df":0,"docs":{}},"2":{"0":{"df":2,"docs":{"176":{"tf":1.0},"203":{"tf":1.4142135623730951}}},"1":{"df":12,"docs":{"108":{"tf":1.4142135623730951},"198":{"tf":1.7320508075688772},"199":{"tf":1.4142135623730951},"200":{"tf":1.4142135623730951},"201":{"tf":1.4142135623730951},"202":{"tf":1.0},"203":{"tf":1.4142135623730951},"204":{"tf":1.0},"205":{"tf":1.0},"206":{"tf":1.0},"207":{"tf":1.0},"208":{"tf":1.7320508075688772}}},"2":{"df":1,"docs":{"208":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":1,"docs":{"193":{"tf":2.0}}}}},"5":{"0":{"df":1,"docs":{"76":{"tf":1.0}}},"6":{"df":1,"docs":{"63":{"tf":1.0}}},"df":3,"docs":{"153":{"tf":1.0},"203":{"tf":1.0},"38":{"tf":1.0}}},"7":{"df":1,"docs":{"176":{"tf":1.0}}},"df":12,"docs":{"10":{"tf":1.0},"148":{"tf":1.4142135623730951},"171":{"tf":1.0},"172":{"tf":1.0},"176":{"tf":1.0},"186":{"tf":1.0},"187":{"tf":1.0},"202":{"tf":1.0},"213":{"tf":1.0},"225":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"75":{"tf":1.0}}},"3":{".":{"1":{"df":1,"docs":{"186":{"tf":1.0}}},"df":0,"docs":{}},"1":{"6":{"4":{"df":1,"docs":{"202":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"df":1,"docs":{"203":{"tf":1.0}}},"8":{"7":{"5":{"df":1,"docs":{"209":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"0":{"df":1,"docs":{"148":{"tf":1.0}}},"df":0,"docs":{}},"df":10,"docs":{"138":{"tf":1.4142135623730951},"171":{"tf":1.0},"186":{"tf":1.0},"45":{"tf":1.4142135623730951},"47":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"70":{"tf":1.0}}},"4":{"0":{"9":{"6":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"1":{"2":{"df":1,"docs":{"202":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"186":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":1.0}}},"5":{"1":{"2":{"0":{"0":{"0":{"df":2,"docs":{"33":{"tf":1.0},"68":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"9":{"4":{"df":1,"docs":{"203":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"3":{"7":{"df":1,"docs":{"202":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"0":{"0":{"0":{"0":{"df":1,"docs":{"177":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"6":{"6":{"df":1,"docs":{"202":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"2":{"9":{"df":2,"docs":{"202":{"tf":1.0},"203":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"148":{"tf":1.0}}},"7":{"0":{"0":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"73":{"tf":1.0}}},"9":{"df":3,"docs":{"186":{"tf":1.4142135623730951},"189":{"tf":1.4142135623730951},"190":{"tf":1.4142135623730951}}},"_":{"?":{")":{"#":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":1,"docs":{"226":{"tf":1.0}}},"df":0,"docs":{}}}}}},")":{"#":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":1,"docs":{"226":{"tf":2.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":17,"docs":{"119":{"tf":1.4142135623730951},"120":{"tf":1.0},"147":{"tf":1.0},"148":{"tf":1.0},"153":{"tf":1.4142135623730951},"163":{"tf":1.0},"164":{"tf":1.0},"169":{"tf":1.4142135623730951},"170":{"tf":1.0},"173":{"tf":1.0},"213":{"tf":4.795831523312719},"220":{"tf":1.4142135623730951},"221":{"tf":1.7320508075688772},"225":{"tf":1.4142135623730951},"226":{"tf":4.0},"45":{"tf":2.0},"58":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"170":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"159":{"tf":1.0}}}}},"df":0,"docs":{}}}},"a":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":2,"docs":{"113":{"tf":1.0},"138":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"167":{"tf":1.4142135623730951},"174":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"/":{"df":0,"docs":{},"w":{"/":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"167":{"tf":1.0},"174":{"tf":1.0}}}}}}},">":{"#":{"<":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"213":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"{":{"df":0,"docs":{},"n":{",":{"df":0,"docs":{},"m":{"df":1,"docs":{"213":{"tf":1.4142135623730951}}}},"df":1,"docs":{"213":{"tf":2.0}}}}},"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"174":{"tf":1.0}},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"174":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"167":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"b":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"229":{"tf":1.0}}}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":2,"docs":{"101":{"tf":1.0},"107":{"tf":2.23606797749979}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"202":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"138":{"tf":1.0},"85":{"tf":1.0}}}},"v":{"df":14,"docs":{"10":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.7320508075688772},"122":{"tf":1.0},"161":{"tf":1.0},"178":{"tf":1.0},"186":{"tf":1.0},"203":{"tf":1.4142135623730951},"210":{"tf":1.7320508075688772},"211":{"tf":1.0},"214":{"tf":2.0},"219":{"tf":1.0},"223":{"tf":1.4142135623730951},"5":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772}},"e":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"107":{"tf":1.0},"144":{"tf":1.0},"166":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"146":{"tf":1.0}}},"df":0,"docs":{}}}},"c":{"c":{"df":1,"docs":{"148":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"179":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"119":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"11":{"tf":1.7320508075688772},"12":{"tf":1.7320508075688772},"186":{"tf":1.7320508075688772},"197":{"tf":1.0},"230":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":18,"docs":{"104":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.4142135623730951},"121":{"tf":1.4142135623730951},"129":{"tf":1.0},"143":{"tf":1.4142135623730951},"144":{"tf":1.0},"145":{"tf":1.0},"151":{"tf":1.0},"155":{"tf":1.0},"159":{"tf":1.0},"161":{"tf":1.0},"163":{"tf":1.0},"169":{"tf":1.0},"172":{"tf":1.0},"223":{"tf":1.0},"227":{"tf":1.4142135623730951}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":5,"docs":{"119":{"tf":1.0},"125":{"tf":1.0},"139":{"tf":1.0},"200":{"tf":1.0},"203":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"118":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"121":{"tf":1.0},"214":{"tf":1.0}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":3,"docs":{"150":{"tf":1.0},"157":{"tf":1.0},"203":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"79":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"84":{"tf":1.0},"94":{"tf":1.7320508075688772}},"s":{"/":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"@":{"df":0,"docs":{},"v":{"4":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"df":4,"docs":{"108":{"tf":1.4142135623730951},"148":{"tf":1.0},"174":{"tf":1.0},"230":{"tf":1.7320508075688772}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":8,"docs":{"117":{"tf":1.0},"138":{"tf":1.0},"161":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.0},"217":{"tf":1.0},"221":{"tf":1.0},"223":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"176":{"tf":1.0},"186":{"tf":1.0},"222":{"tf":1.4142135623730951}}}}},"d":{"df":29,"docs":{"100":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"112":{"tf":1.4142135623730951},"121":{"tf":1.0},"122":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"129":{"tf":1.7320508075688772},"133":{"tf":2.6457513110645907},"138":{"tf":1.0},"139":{"tf":1.4142135623730951},"146":{"tf":1.0},"178":{"tf":1.4142135623730951},"182":{"tf":1.0},"183":{"tf":1.0},"2":{"tf":1.0},"203":{"tf":1.4142135623730951},"212":{"tf":1.0},"228":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.0},"7":{"tf":1.0},"86":{"tf":1.0},"95":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":14,"docs":{"0":{"tf":1.0},"188":{"tf":1.0},"194":{"tf":1.0},"203":{"tf":1.0},"214":{"tf":1.0},"221":{"tf":1.4142135623730951},"223":{"tf":1.0},"226":{"tf":1.4142135623730951},"227":{"tf":1.0},"229":{"tf":1.0},"24":{"tf":1.0},"31":{"tf":1.0},"84":{"tf":1.0},"99":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"163":{"tf":1.0},"200":{"tf":1.0},"221":{"tf":1.0},"223":{"tf":1.0},"226":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":8,"docs":{"154":{"tf":1.0},"178":{"tf":1.0},"197":{"tf":1.0},"201":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.0},"208":{"tf":1.0}}}}}}},"df":33,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"109":{"tf":2.449489742783178},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"116":{"tf":1.0},"117":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"119":{"tf":1.0},"120":{"tf":1.7320508075688772},"121":{"tf":2.23606797749979},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.7320508075688772},"129":{"tf":3.0},"130":{"tf":1.0},"142":{"tf":1.0},"160":{"tf":1.0},"186":{"tf":1.0},"197":{"tf":1.0},"230":{"tf":1.0},"5":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"137":{"tf":1.0}}}}},"t":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"153":{"tf":1.0},"169":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"153":{"tf":1.0}}}}},"df":1,"docs":{"153":{"tf":1.0}}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"223":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"211":{"tf":1.0},"222":{"tf":1.7320508075688772},"223":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"230":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":80,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"117":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"203":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"223":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"102":{"tf":1.0},"121":{"tf":1.0},"135":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"139":{"tf":1.0},"179":{"tf":1.0},"182":{"tf":1.0},"223":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":16,"docs":{"0":{"tf":1.0},"105":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"121":{"tf":1.0},"138":{"tf":1.0},"142":{"tf":1.0},"210":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.0},"214":{"tf":1.0},"217":{"tf":1.0},"220":{"tf":2.0},"221":{"tf":1.4142135623730951},"225":{"tf":1.0},"94":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"7":{"tf":1.0},"79":{"tf":1.4142135623730951}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"226":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"183":{"tf":1.0},"5":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"124":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"132":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"153":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":1,"docs":{"221":{"tf":1.0}}}}}}}}},"i":{"a":{"df":1,"docs":{"121":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{".":{".":{")":{"]":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"113":{"tf":1.0}}}}}}},"/":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"116":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"]":{"df":3,"docs":{"85":{"tf":1.0},"86":{"tf":1.0},"89":{"tf":1.0}}},"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":55,"docs":{"0":{"tf":2.0},"113":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"127":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"138":{"tf":1.0},"14":{"tf":1.7320508075688772},"146":{"tf":1.0},"15":{"tf":1.7320508075688772},"151":{"tf":1.0},"16":{"tf":1.7320508075688772},"161":{"tf":1.4142135623730951},"169":{"tf":1.0},"17":{"tf":1.7320508075688772},"179":{"tf":1.0},"18":{"tf":1.7320508075688772},"19":{"tf":1.7320508075688772},"195":{"tf":1.0},"20":{"tf":1.7320508075688772},"209":{"tf":1.0},"21":{"tf":1.7320508075688772},"211":{"tf":1.0},"214":{"tf":1.4142135623730951},"219":{"tf":1.0},"22":{"tf":1.7320508075688772},"221":{"tf":1.0},"222":{"tf":1.0},"223":{"tf":1.0},"226":{"tf":2.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.7320508075688772},"25":{"tf":1.7320508075688772},"26":{"tf":2.0},"27":{"tf":2.449489742783178},"28":{"tf":1.7320508075688772},"29":{"tf":2.23606797749979},"30":{"tf":1.7320508075688772},"31":{"tf":1.7320508075688772},"32":{"tf":1.7320508075688772},"33":{"tf":1.0},"5":{"tf":1.7320508075688772},"58":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":2.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.7320508075688772},"90":{"tf":1.0},"91":{"tf":1.0}},"e":{"d":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"214":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"200":{"tf":1.0},"8":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":18,"docs":{"1":{"tf":1.0},"102":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"127":{"tf":1.0},"130":{"tf":1.0},"144":{"tf":1.0},"166":{"tf":1.0},"174":{"tf":1.4142135623730951},"186":{"tf":1.7320508075688772},"192":{"tf":1.0},"195":{"tf":1.0},"197":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.7320508075688772},"29":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"218":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"<":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"218":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"218":{"tf":1.0}}}},"df":1,"docs":{"218":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":11,"docs":{"0":{"tf":1.0},"133":{"tf":1.0},"144":{"tf":1.0},"203":{"tf":1.0},"213":{"tf":1.4142135623730951},"214":{"tf":1.4142135623730951},"218":{"tf":1.0},"222":{"tf":1.4142135623730951},"223":{"tf":2.23606797749979},"224":{"tf":1.0},"226":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"229":{"tf":1.0},"230":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":8,"docs":{"107":{"tf":1.0},"147":{"tf":1.4142135623730951},"148":{"tf":1.0},"185":{"tf":1.0},"229":{"tf":1.4142135623730951},"230":{"tf":1.4142135623730951},"46":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":1,"docs":{"202":{"tf":1.0}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"179":{"tf":1.0},"200":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":2,"docs":{"0":{"tf":1.0},"202":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":9,"docs":{"117":{"tf":1.0},"145":{"tf":1.0},"210":{"tf":1.0},"213":{"tf":1.0},"214":{"tf":1.4142135623730951},"219":{"tf":1.0},"222":{"tf":1.4142135623730951},"223":{"tf":1.0},"226":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":3,"docs":{"30":{"tf":1.0},"31":{"tf":2.0},"32":{"tf":1.0}}}}}}}}}},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"169":{"tf":1.0},"230":{"tf":1.0}}}}}},"y":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"df":1,"docs":{"148":{"tf":1.0}}}}},"<":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"219":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":6,"docs":{"10":{"tf":1.0},"164":{"tf":1.0},"192":{"tf":1.0},"213":{"tf":1.4142135623730951},"218":{"tf":1.0},"60":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"126":{"tf":1.0}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"100":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":4,"docs":{"166":{"tf":1.0},"176":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"7":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"119":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"21":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"c":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"147":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"y":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"147":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":4,"docs":{"130":{"tf":1.0},"147":{"tf":1.4142135623730951},"148":{"tf":1.0},"221":{"tf":1.0}}},"df":10,"docs":{"114":{"tf":1.0},"141":{"tf":1.0},"174":{"tf":1.0},"177":{"tf":1.0},"182":{"tf":1.4142135623730951},"211":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"229":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"a":{"c":{"df":0,"docs":{},"h":{"df":8,"docs":{"127":{"tf":1.0},"137":{"tf":1.0},"157":{"tf":1.0},"160":{"tf":1.0},"211":{"tf":1.7320508075688772},"221":{"tf":1.4142135623730951},"222":{"tf":1.0},"223":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"119":{"tf":1.0}}}}},"v":{"df":1,"docs":{"181":{"tf":1.0}}},"x":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":3,"docs":{"203":{"tf":1.0},"211":{"tf":1.0},"226":{"tf":1.0}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"221":{"tf":1.0}}}},"df":0,"docs":{}}},"g":{"df":1,"docs":{"16":{"tf":1.7320508075688772}},"u":{"df":1,"docs":{"133":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":8,"docs":{"148":{"tf":1.0},"163":{"tf":1.0},"170":{"tf":1.0},"171":{"tf":1.4142135623730951},"212":{"tf":1.0},"213":{"tf":1.7320508075688772},"6":{"tf":1.0},"73":{"tf":1.7320508075688772}}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.7320508075688772},"31":{"tf":1.7320508075688772},"32":{"tf":1.7320508075688772}},"i":{"c":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0}},"s":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"d":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"197":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"218":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":6,"docs":{"213":{"tf":3.0},"214":{"tf":2.0},"219":{"tf":1.4142135623730951},"225":{"tf":1.7320508075688772},"226":{"tf":1.4142135623730951},"33":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"t":{"df":2,"docs":{"205":{"tf":1.4142135623730951},"224":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"k":{"df":7,"docs":{"107":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"179":{"tf":1.0},"186":{"tf":1.0},"229":{"tf":1.4142135623730951},"230":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"131":{"tf":1.0},"226":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"(":{"c":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"174":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"x":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{".":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"174":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"!":{"(":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{".":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"167":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"214":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"(":{"_":{"#":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"226":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"226":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":8,"docs":{"144":{"tf":1.0},"145":{"tf":1.0},"199":{"tf":1.4142135623730951},"201":{"tf":1.0},"214":{"tf":1.4142135623730951},"223":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":3,"docs":{"113":{"tf":1.0},"140":{"tf":1.0},"167":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":13,"docs":{"155":{"tf":1.0},"167":{"tf":2.23606797749979},"174":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.0},"182":{"tf":1.4142135623730951},"183":{"tf":1.0},"188":{"tf":1.4142135623730951},"189":{"tf":1.4142135623730951},"190":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.0},"4":{"tf":1.0}}}}},"t":{"'":{"df":1,"docs":{"223":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"221":{"tf":1.4142135623730951},"223":{"tf":1.0}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"(":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"210":{"tf":1.4142135623730951}}}}}},"df":1,"docs":{"210":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"221":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"210":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"223":{"tf":1.4142135623730951}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"_":{"df":1,"docs":{"210":{"tf":1.0}}},"df":0,"docs":{},"j":{"df":1,"docs":{"220":{"tf":1.0}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"j":{"df":1,"docs":{"220":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"j":{"df":1,"docs":{"220":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"220":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"223":{"tf":1.4142135623730951}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"210":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"210":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":14,"docs":{"107":{"tf":1.0},"118":{"tf":1.0},"144":{"tf":2.449489742783178},"145":{"tf":1.4142135623730951},"166":{"tf":1.0},"210":{"tf":2.0},"213":{"tf":1.0},"217":{"tf":1.4142135623730951},"218":{"tf":1.0},"220":{"tf":1.4142135623730951},"222":{"tf":1.0},"223":{"tf":1.4142135623730951},"226":{"tf":1.7320508075688772},"99":{"tf":1.7320508075688772}}},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"203":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"123":{"tf":1.4142135623730951},"148":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"104":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"203":{"tf":1.0}}}}},"n":{"df":1,"docs":{"213":{"tf":1.0}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":11,"docs":{"11":{"tf":1.7320508075688772},"116":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.7320508075688772},"131":{"tf":1.0},"186":{"tf":1.4142135623730951},"214":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"90":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"105":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":8,"docs":{"109":{"tf":1.0},"122":{"tf":1.7320508075688772},"166":{"tf":1.4142135623730951},"167":{"tf":1.0},"186":{"tf":1.0},"223":{"tf":1.0},"226":{"tf":1.4142135623730951},"229":{"tf":1.0}}}}},"o":{"df":1,"docs":{"116":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"t":{"df":13,"docs":{"1":{"tf":1.0},"104":{"tf":1.0},"114":{"tf":1.0},"117":{"tf":1.0},"119":{"tf":1.0},"129":{"tf":1.0},"135":{"tf":1.0},"141":{"tf":1.0},"147":{"tf":1.4142135623730951},"148":{"tf":1.0},"196":{"tf":1.4142135623730951},"27":{"tf":1.0},"5":{"tf":1.4142135623730951}}}},"df":2,"docs":{"117":{"tf":1.4142135623730951},"118":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":13,"docs":{"104":{"tf":1.0},"117":{"tf":1.0},"121":{"tf":1.0},"150":{"tf":1.0},"160":{"tf":1.0},"164":{"tf":1.0},"167":{"tf":1.0},"176":{"tf":1.0},"179":{"tf":1.0},"191":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.0},"227":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":13,"docs":{"119":{"tf":1.0},"124":{"tf":1.0},"146":{"tf":1.0},"160":{"tf":1.0},"161":{"tf":1.0},"166":{"tf":1.4142135623730951},"167":{"tf":1.0},"171":{"tf":1.0},"174":{"tf":1.0},"176":{"tf":1.0},"34":{"tf":1.4142135623730951},"48":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"35":{"tf":1.7320508075688772}}}},"y":{"df":2,"docs":{"130":{"tf":1.0},"193":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"167":{"tf":1.0},"174":{"tf":1.0}}}}}}},"a":{"c":{"df":0,"docs":{},"k":{"df":6,"docs":{"176":{"tf":1.0},"183":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.0}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"188":{"tf":1.4142135623730951}}}}}}}}},"df":6,"docs":{"181":{"tf":2.8284271247461903},"182":{"tf":3.1622776601683795},"183":{"tf":2.0},"186":{"tf":1.0},"188":{"tf":1.0},"192":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"226":{"tf":1.4142135623730951}}}}}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"177":{"tf":1.4142135623730951}}}}}},"d":{"df":4,"docs":{"116":{"tf":1.0},"124":{"tf":2.0},"134":{"tf":1.4142135623730951},"5":{"tf":1.0}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"137":{"tf":1.0},"228":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"r":{"df":5,"docs":{"147":{"tf":1.0},"213":{"tf":1.0},"214":{"tf":1.4142135623730951},"41":{"tf":1.0},"7":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"e":{"df":4,"docs":{"171":{"tf":1.0},"215":{"tf":1.0},"64":{"tf":1.0},"91":{"tf":1.0}}},"h":{"df":1,"docs":{"177":{"tf":1.4142135623730951}}},"i":{"c":{"df":18,"docs":{"100":{"tf":1.0},"101":{"tf":2.23606797749979},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":1.0},"128":{"tf":1.0},"155":{"tf":1.0},"161":{"tf":1.0},"181":{"tf":1.0},"204":{"tf":1.0},"3":{"tf":1.0},"7":{"tf":1.0},"98":{"tf":1.4142135623730951}}},"df":3,"docs":{"0":{"tf":1.0},"176":{"tf":1.0},"87":{"tf":1.0}}}},"z":{"df":3,"docs":{"213":{"tf":1.0},"41":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"df":10,"docs":{"113":{"tf":1.0},"138":{"tf":1.0},"167":{"tf":2.449489742783178},"174":{"tf":2.23606797749979},"180":{"tf":1.0},"182":{"tf":1.0},"183":{"tf":1.0},"188":{"tf":1.0},"213":{"tf":2.23606797749979},"226":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":6,"docs":{"115":{"tf":1.0},"142":{"tf":1.0},"166":{"tf":1.0},"202":{"tf":1.0},"210":{"tf":1.0},"223":{"tf":1.0}}}}},"df":6,"docs":{"10":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"164":{"tf":1.0},"167":{"tf":1.0},"221":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":23,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"104":{"tf":1.0},"118":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"128":{"tf":1.0},"136":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":1.0},"166":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.0},"181":{"tf":1.0},"183":{"tf":1.0},"185":{"tf":1.0},"195":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.4142135623730951},"50":{"tf":1.0},"81":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"179":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"138":{"tf":1.0},"146":{"tf":1.0}},"n":{"df":1,"docs":{"99":{"tf":1.4142135623730951}}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"146":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":9,"docs":{"107":{"tf":1.0},"112":{"tf":1.0},"129":{"tf":1.0},"131":{"tf":1.0},"133":{"tf":1.4142135623730951},"139":{"tf":1.0},"166":{"tf":1.0},"30":{"tf":1.0},"64":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"133":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"133":{"tf":1.4142135623730951},"163":{"tf":1.4142135623730951},"172":{"tf":1.0}}}},"v":{"df":1,"docs":{"164":{"tf":1.0}}},"w":{"df":17,"docs":{"104":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"143":{"tf":1.0},"156":{"tf":1.0},"160":{"tf":1.0},"210":{"tf":1.0},"212":{"tf":1.0},"218":{"tf":1.0},"220":{"tf":1.0},"226":{"tf":1.0},"26":{"tf":1.7320508075688772},"5":{"tf":1.0},"60":{"tf":1.0},"7":{"tf":1.0},"77":{"tf":1.0},"95":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"226":{"tf":1.0}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":8,"docs":{"101":{"tf":1.0},"131":{"tf":1.0},"151":{"tf":1.0},"157":{"tf":1.0},"159":{"tf":1.0},"166":{"tf":1.0},"197":{"tf":1.0},"203":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":6,"docs":{"112":{"tf":1.0},"133":{"tf":1.0},"146":{"tf":1.0},"160":{"tf":1.0},"202":{"tf":1.0},"230":{"tf":1.0}}}},"t":{"a":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"186":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"=":{"$":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"189":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"189":{"tf":1.0}}},"df":0,"docs":{}}}},"df":12,"docs":{"176":{"tf":1.0},"181":{"tf":1.4142135623730951},"182":{"tf":2.23606797749979},"183":{"tf":2.23606797749979},"186":{"tf":2.6457513110645907},"187":{"tf":1.4142135623730951},"188":{"tf":2.0},"189":{"tf":2.449489742783178},"192":{"tf":1.0},"193":{"tf":1.7320508075688772},"202":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"119":{"tf":1.0},"145":{"tf":1.0},"197":{"tf":1.0},"202":{"tf":1.0},"204":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":12,"docs":{"148":{"tf":1.4142135623730951},"175":{"tf":1.4142135623730951},"176":{"tf":1.7320508075688772},"177":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.0},"186":{"tf":1.0},"203":{"tf":1.4142135623730951},"217":{"tf":1.0},"220":{"tf":1.0},"226":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"214":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"b":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":2,"docs":{"176":{"tf":1.0},"203":{"tf":1.0}},"g":{"df":4,"docs":{"103":{"tf":1.0},"177":{"tf":1.4142135623730951},"203":{"tf":1.0},"208":{"tf":1.7320508075688772}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"100":{"tf":1.0},"197":{"tf":1.0},"200":{"tf":1.0},"203":{"tf":1.0},"206":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"108":{"tf":1.0},"115":{"tf":1.0},"223":{"tf":1.4142135623730951},"31":{"tf":2.0},"4":{"tf":1.0}}},"y":{"(":{"_":{"df":1,"docs":{"226":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"d":{"df":1,"docs":{"67":{"tf":1.7320508075688772}}},"df":1,"docs":{"108":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"223":{"tf":2.0}}},"df":0,"docs":{}}}}}}},"t":{"df":4,"docs":{"111":{"tf":1.0},"120":{"tf":1.0},"167":{"tf":1.0},"81":{"tf":1.7320508075688772}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":9,"docs":{"103":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"120":{"tf":1.0},"129":{"tf":1.0},"138":{"tf":1.7320508075688772},"139":{"tf":1.0},"141":{"tf":1.0},"203":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"k":{"(":{"_":{")":{"#":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"226":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"213":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"218":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"_":{"(":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"218":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"226":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"226":{"tf":1.7320508075688772}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"221":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":13,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"155":{"tf":1.0},"161":{"tf":1.0},"164":{"tf":2.0},"210":{"tf":1.0},"213":{"tf":2.6457513110645907},"221":{"tf":1.4142135623730951},"226":{"tf":2.8284271247461903},"49":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"83":{"tf":1.0}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"218":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"154":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"118":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"111":{"tf":1.0},"131":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"196":{"tf":1.0}}},"df":8,"docs":{"100":{"tf":1.4142135623730951},"121":{"tf":1.0},"129":{"tf":1.0},"164":{"tf":1.0},"194":{"tf":2.23606797749979},"195":{"tf":1.7320508075688772},"196":{"tf":2.0},"203":{"tf":1.4142135623730951}}},"l":{"(":{"_":{"#":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"214":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"213":{"tf":1.4142135623730951}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"218":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":6,"docs":{"120":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"220":{"tf":1.4142135623730951},"55":{"tf":1.7320508075688772},"57":{"tf":1.7320508075688772}},"e":{"a":{"df":0,"docs":{},"n":{"df":5,"docs":{"210":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":2.0},"214":{"tf":1.7320508075688772},"226":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"r":{"df":1,"docs":{"100":{"tf":1.0}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"<":{"[":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"161":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":1,"docs":{"161":{"tf":1.0}}}},"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"161":{"tf":1.4142135623730951}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"h":{"df":11,"docs":{"112":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"167":{"tf":1.0},"203":{"tf":1.0},"210":{"tf":1.0},"222":{"tf":1.0},"223":{"tf":1.0},"226":{"tf":1.0},"230":{"tf":1.0},"7":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"53":{"tf":1.0},"59":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"x":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"117":{"tf":1.0},"135":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"218":{"tf":2.0}}}}}},"t":{"df":1,"docs":{"77":{"tf":1.0}}}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":4,"docs":{"129":{"tf":1.4142135623730951},"48":{"tf":1.0},"77":{"tf":1.4142135623730951},"80":{"tf":2.0}},"e":{"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"72":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"69":{"tf":2.0}}}},"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":14,"docs":{"102":{"tf":1.7320508075688772},"133":{"tf":1.4142135623730951},"179":{"tf":1.4142135623730951},"181":{"tf":1.0},"182":{"tf":1.7320508075688772},"183":{"tf":1.7320508075688772},"186":{"tf":1.4142135623730951},"187":{"tf":1.4142135623730951},"188":{"tf":2.6457513110645907},"189":{"tf":2.0},"192":{"tf":2.0},"210":{"tf":1.0},"213":{"tf":1.0},"214":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":6,"docs":{"210":{"tf":1.0},"222":{"tf":1.0},"228":{"tf":1.0},"230":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"7":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"165":{"tf":1.0},"200":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"181":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"s":{"df":1,"docs":{"145":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"116":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"177":{"tf":1.0},"93":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"100":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"203":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"l":{"d":{"df":10,"docs":{"101":{"tf":1.4142135623730951},"103":{"tf":2.23606797749979},"105":{"tf":1.0},"108":{"tf":1.4142135623730951},"155":{"tf":1.0},"161":{"tf":1.0},"195":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.4142135623730951},"96":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":2,"docs":{"176":{"tf":1.0},"177":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"186":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"179":{"tf":1.4142135623730951}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"138":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"229":{"tf":1.4142135623730951}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":8,"docs":{"50":{"tf":1.0},"56":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0}},"s":{":":{":":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"177":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"176":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"227":{"tf":1.4142135623730951},"230":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"df":25,"docs":{"104":{"tf":1.0},"109":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"133":{"tf":1.4142135623730951},"135":{"tf":1.0},"138":{"tf":2.6457513110645907},"148":{"tf":1.0},"153":{"tf":1.0},"159":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":2.23606797749979},"164":{"tf":1.0},"167":{"tf":1.4142135623730951},"168":{"tf":1.0},"170":{"tf":2.0},"172":{"tf":1.4142135623730951},"173":{"tf":1.0},"174":{"tf":1.4142135623730951},"177":{"tf":1.0},"212":{"tf":1.4142135623730951},"217":{"tf":1.0},"219":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"119":{"tf":1.0},"145":{"tf":1.0},"148":{"tf":1.0},"174":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":1,"docs":{"146":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"119":{"tf":1.0},"146":{"tf":1.0}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"214":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"185":{"tf":1.0},"7":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"85":{"tf":1.0}}}}}}}},"g":{"df":0,"docs":{},"o":{"#":{"5":{"0":{"3":{"4":{"df":1,"docs":{"202":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":5,"docs":{"113":{"tf":1.0},"140":{"tf":1.0},"62":{"tf":1.0},"7":{"tf":1.7320508075688772},"92":{"tf":1.4142135623730951}}}}}}},"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"108":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"108":{"tf":1.0}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"108":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"113":{"tf":1.0},"140":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"113":{"tf":1.0},"140":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"129":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":41,"docs":{"0":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":2.449489742783178},"104":{"tf":3.1622776601683795},"105":{"tf":1.0},"108":{"tf":2.23606797749979},"109":{"tf":1.0},"112":{"tf":2.0},"113":{"tf":2.6457513110645907},"114":{"tf":1.0},"115":{"tf":2.0},"116":{"tf":1.0},"117":{"tf":1.7320508075688772},"120":{"tf":2.449489742783178},"125":{"tf":1.0},"128":{"tf":1.7320508075688772},"129":{"tf":1.0},"131":{"tf":1.0},"133":{"tf":2.0},"134":{"tf":1.0},"135":{"tf":1.4142135623730951},"138":{"tf":2.6457513110645907},"139":{"tf":1.0},"140":{"tf":2.8284271247461903},"141":{"tf":1.0},"142":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"195":{"tf":1.4142135623730951},"202":{"tf":2.449489742783178},"203":{"tf":2.23606797749979},"36":{"tf":1.7320508075688772},"4":{"tf":1.0},"5":{"tf":3.1622776601683795},"6":{"tf":1.7320508075688772},"7":{"tf":2.23606797749979},"92":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"95":{"tf":1.0},"96":{"tf":2.0}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"229":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":33,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.0},"103":{"tf":1.4142135623730951},"111":{"tf":1.0},"113":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.7320508075688772},"127":{"tf":1.4142135623730951},"130":{"tf":1.0},"133":{"tf":1.0},"135":{"tf":1.0},"136":{"tf":1.0},"137":{"tf":1.4142135623730951},"138":{"tf":1.0},"140":{"tf":1.4142135623730951},"145":{"tf":1.0},"163":{"tf":1.0},"202":{"tf":1.4142135623730951},"203":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.0},"215":{"tf":1.0},"223":{"tf":1.0},"226":{"tf":1.4142135623730951},"7":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.4142135623730951},"86":{"tf":1.0},"87":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"97":{"tf":1.0}}},"t":{"_":{"a":{"b":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"131":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"0":{"tf":1.0},"168":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":8,"docs":{"0":{"tf":2.23606797749979},"100":{"tf":1.4142135623730951},"112":{"tf":1.0},"127":{"tf":2.23606797749979},"131":{"tf":1.4142135623730951},"133":{"tf":1.4142135623730951},"84":{"tf":2.0},"85":{"tf":1.0}}},"y":{"=":{"<":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"_":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"144":{"tf":1.0},"145":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":2,"docs":{"113":{"tf":1.0},"140":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"112":{"tf":1.4142135623730951},"133":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"u":{"df":0,"docs":{},"s":{"df":9,"docs":{"113":{"tf":1.0},"140":{"tf":1.0},"154":{"tf":1.0},"174":{"tf":1.0},"221":{"tf":1.0},"34":{"tf":1.0},"5":{"tf":1.4142135623730951},"7":{"tf":1.0},"71":{"tf":1.0}}}}},"d":{"df":1,"docs":{"108":{"tf":1.0}}},"df":1,"docs":{"213":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":12,"docs":{"0":{"tf":1.0},"121":{"tf":1.0},"141":{"tf":1.0},"145":{"tf":1.0},"157":{"tf":1.0},"210":{"tf":1.0},"211":{"tf":1.0},"220":{"tf":1.0},"31":{"tf":1.0},"7":{"tf":1.7320508075688772},"82":{"tf":1.0},"91":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"165":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":6,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0}}}}}}},"df":1,"docs":{"7":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"130":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"200":{"tf":1.4142135623730951}}}}}}},"n":{"df":0,"docs":{},"g":{"df":35,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"113":{"tf":1.0},"129":{"tf":1.0},"133":{"tf":2.0},"138":{"tf":1.0},"147":{"tf":2.0},"148":{"tf":1.0},"166":{"tf":1.4142135623730951},"167":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":2.6457513110645907},"177":{"tf":1.4142135623730951},"178":{"tf":1.0},"179":{"tf":2.0},"180":{"tf":1.0},"181":{"tf":2.0},"182":{"tf":2.0},"183":{"tf":1.0},"185":{"tf":1.0},"186":{"tf":1.0},"188":{"tf":1.0},"192":{"tf":1.0},"194":{"tf":1.4142135623730951},"195":{"tf":1.0},"196":{"tf":2.23606797749979},"197":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.0},"210":{"tf":1.0},"222":{"tf":1.4142135623730951},"223":{"tf":1.0},"226":{"tf":1.0},"34":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"m":{"d":{"df":4,"docs":{"133":{"tf":1.4142135623730951},"186":{"tf":1.0},"187":{"tf":1.0},"193":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":6,"docs":{"175":{"tf":1.4142135623730951},"184":{"tf":2.0},"185":{"tf":2.0},"186":{"tf":3.3166247903554},"193":{"tf":1.4142135623730951},"230":{"tf":1.0}}}}},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"186":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"o":{"df":1,"docs":{"165":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"137":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":19,"docs":{"1":{"tf":1.4142135623730951},"100":{"tf":1.0},"133":{"tf":1.0},"135":{"tf":1.0},"141":{"tf":1.0},"144":{"tf":1.0},"146":{"tf":1.4142135623730951},"149":{"tf":1.0},"156":{"tf":1.0},"164":{"tf":1.0},"175":{"tf":1.4142135623730951},"197":{"tf":1.0},"227":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.7320508075688772},"84":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":2.0}}}}}},"r":{"(":{"'":{"df":0,"docs":{},"x":{"df":1,"docs":{"213":{"tf":1.0}}}},"_":{"df":2,"docs":{"213":{"tf":1.0},"226":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"218":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"152":{"tf":1.4142135623730951},"211":{"tf":1.7320508075688772},"213":{"tf":2.0},"214":{"tf":1.4142135623730951},"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":7,"docs":{"152":{"tf":1.7320508075688772},"213":{"tf":1.4142135623730951},"214":{"tf":1.0},"26":{"tf":1.4142135623730951},"60":{"tf":1.7320508075688772},"67":{"tf":1.7320508075688772},"79":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"130":{"tf":1.4142135623730951}}}},"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":15,"docs":{"121":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"163":{"tf":1.0},"169":{"tf":1.0},"170":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"212":{"tf":1.0},"221":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"214":{"tf":1.0}}}}}}},"df":1,"docs":{"146":{"tf":1.0}}}}}},"f":{"df":0,"docs":{},"n":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"119":{"tf":1.4142135623730951},"120":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":3,"docs":{"119":{"tf":1.0},"120":{"tf":1.7320508075688772},"146":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"164":{"tf":1.0},"173":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"164":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"221":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"146":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"159":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":58,"docs":{"102":{"tf":1.0},"113":{"tf":2.0},"116":{"tf":1.0},"118":{"tf":1.7320508075688772},"119":{"tf":1.0},"120":{"tf":1.0},"124":{"tf":1.0},"132":{"tf":1.4142135623730951},"138":{"tf":1.7320508075688772},"144":{"tf":1.4142135623730951},"145":{"tf":1.4142135623730951},"146":{"tf":1.0},"147":{"tf":1.0},"150":{"tf":1.7320508075688772},"151":{"tf":1.4142135623730951},"152":{"tf":2.23606797749979},"153":{"tf":1.4142135623730951},"154":{"tf":1.0},"155":{"tf":1.7320508075688772},"156":{"tf":1.4142135623730951},"157":{"tf":2.0},"158":{"tf":1.0},"159":{"tf":1.4142135623730951},"160":{"tf":1.4142135623730951},"161":{"tf":1.7320508075688772},"162":{"tf":2.0},"163":{"tf":2.8284271247461903},"164":{"tf":3.1622776601683795},"166":{"tf":1.4142135623730951},"167":{"tf":1.0},"168":{"tf":2.23606797749979},"169":{"tf":1.0},"170":{"tf":2.6457513110645907},"171":{"tf":2.6457513110645907},"172":{"tf":1.4142135623730951},"173":{"tf":2.6457513110645907},"174":{"tf":2.0},"179":{"tf":1.0},"180":{"tf":1.0},"186":{"tf":2.0},"192":{"tf":1.4142135623730951},"202":{"tf":2.0},"21":{"tf":1.0},"210":{"tf":1.0},"214":{"tf":1.7320508075688772},"221":{"tf":2.23606797749979},"226":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"37":{"tf":1.4142135623730951},"5":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0}},"e":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"158":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"128":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":11,"docs":{"102":{"tf":1.0},"179":{"tf":1.4142135623730951},"180":{"tf":1.0},"182":{"tf":1.7320508075688772},"183":{"tf":1.4142135623730951},"186":{"tf":1.0},"188":{"tf":1.0},"189":{"tf":1.4142135623730951},"190":{"tf":1.0},"191":{"tf":1.0},"229":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"160":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"127":{"tf":1.0},"182":{"tf":1.0},"5":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"223":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"177":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"c":{"df":5,"docs":{"124":{"tf":1.0},"144":{"tf":1.4142135623730951},"145":{"tf":1.0},"186":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":3,"docs":{"0":{"tf":1.0},"119":{"tf":1.0},"148":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"111":{"tf":1.0}},"n":{"df":2,"docs":{"133":{"tf":1.0},"146":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"177":{"tf":1.0}}}}}},"i":{".":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"/":{"c":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"0":{"tf":1.0},"125":{"tf":1.0},"175":{"tf":1.0},"5":{"tf":1.0},"93":{"tf":2.23606797749979},"94":{"tf":1.0},"95":{"tf":2.449489742783178},"96":{"tf":2.0}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"228":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"99":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"127":{"tf":1.0}},"i":{"df":2,"docs":{"202":{"tf":1.0},"203":{"tf":1.4142135623730951}}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"213":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"186":{"tf":1.0}}}}},"r":{"df":2,"docs":{"200":{"tf":1.0},"203":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"109":{"tf":1.0},"203":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":104,"docs":{"0":{"tf":2.0},"1":{"tf":1.4142135623730951},"100":{"tf":2.0},"101":{"tf":2.23606797749979},"102":{"tf":2.449489742783178},"103":{"tf":1.7320508075688772},"104":{"tf":2.0},"105":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":4.123105625617661},"109":{"tf":1.4142135623730951},"111":{"tf":1.0},"113":{"tf":1.7320508075688772},"115":{"tf":2.449489742783178},"116":{"tf":1.0},"118":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.7320508075688772},"123":{"tf":1.4142135623730951},"125":{"tf":1.0},"129":{"tf":1.4142135623730951},"130":{"tf":1.4142135623730951},"131":{"tf":1.7320508075688772},"132":{"tf":1.0},"133":{"tf":1.7320508075688772},"134":{"tf":1.4142135623730951},"135":{"tf":1.0},"136":{"tf":1.0},"137":{"tf":1.4142135623730951},"138":{"tf":3.0},"142":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.7320508075688772},"149":{"tf":1.0},"153":{"tf":1.0},"159":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.4142135623730951},"166":{"tf":1.0},"167":{"tf":1.4142135623730951},"172":{"tf":1.0},"174":{"tf":1.4142135623730951},"175":{"tf":2.6457513110645907},"176":{"tf":2.449489742783178},"177":{"tf":1.4142135623730951},"178":{"tf":2.6457513110645907},"179":{"tf":3.3166247903554},"180":{"tf":2.6457513110645907},"181":{"tf":2.449489742783178},"182":{"tf":2.6457513110645907},"183":{"tf":2.23606797749979},"185":{"tf":1.0},"186":{"tf":2.23606797749979},"187":{"tf":2.449489742783178},"188":{"tf":2.0},"189":{"tf":2.0},"190":{"tf":1.7320508075688772},"191":{"tf":2.0},"192":{"tf":1.7320508075688772},"194":{"tf":2.449489742783178},"195":{"tf":1.0},"196":{"tf":1.4142135623730951},"197":{"tf":1.7320508075688772},"199":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"200":{"tf":1.0},"202":{"tf":2.6457513110645907},"203":{"tf":3.605551275463989},"204":{"tf":1.0},"208":{"tf":1.0},"21":{"tf":1.0},"210":{"tf":1.0},"215":{"tf":1.4142135623730951},"220":{"tf":1.0},"222":{"tf":1.0},"223":{"tf":1.0},"224":{"tf":1.0},"226":{"tf":1.4142135623730951},"227":{"tf":1.4142135623730951},"229":{"tf":2.6457513110645907},"230":{"tf":3.1622776601683795},"26":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.4142135623730951},"4":{"tf":2.0},"41":{"tf":1.0},"43":{"tf":2.23606797749979},"5":{"tf":4.358898943540674},"58":{"tf":1.0},"6":{"tf":3.1622776601683795},"7":{"tf":4.0},"84":{"tf":2.0},"85":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.7320508075688772},"91":{"tf":1.0},"93":{"tf":3.0},"94":{"tf":2.449489742783178},"95":{"tf":2.0},"96":{"tf":2.23606797749979},"97":{"tf":2.0},"98":{"tf":1.0}}},"y":{"'":{"df":19,"docs":{"103":{"tf":1.4142135623730951},"130":{"tf":1.0},"131":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.0},"172":{"tf":1.4142135623730951},"210":{"tf":1.0},"221":{"tf":1.4142135623730951},"226":{"tf":1.0},"5":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0}}},".":{"df":1,"docs":{"227":{"tf":1.0}},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"182":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":4,"docs":{"121":{"tf":1.0},"129":{"tf":1.4142135623730951},"139":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951}}}}}}},":":{":":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"0":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"122":{"tf":1.0}}}}}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":2,"docs":{"0":{"tf":1.0},"92":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":2,"docs":{"0":{"tf":1.0},"87":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"85":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"123":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"138":{"tf":1.0}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"148":{"tf":1.0}}}}}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"50":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":2,"docs":{"121":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}}},"p":{"df":0,"docs":{},"e":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"0":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":2.0},"90":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":2,"docs":{"0":{"tf":1.0},"88":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"5":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":3,"docs":{"0":{"tf":1.0},"5":{"tf":1.0},"89":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":4,"docs":{"116":{"tf":1.4142135623730951},"124":{"tf":1.0},"134":{"tf":1.0},"186":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"183":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"94":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"129":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"121":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"129":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"121":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"116":{"tf":1.0},"129":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"121":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"r":{"c":{"/":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"133":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":3,"docs":{"112":{"tf":1.0},"116":{"tf":1.4142135623730951},"133":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"133":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"133":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":3,"docs":{"117":{"tf":1.0},"133":{"tf":1.0},"135":{"tf":1.0}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"133":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"e":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"133":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"{":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"}":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"112":{"tf":1.0},"133":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"112":{"tf":1.0},"133":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":3,"docs":{"112":{"tf":1.0},"131":{"tf":1.0},"133":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"119":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"159":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":3,"docs":{"158":{"tf":1.0},"163":{"tf":1.0},"172":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"160":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"164":{"tf":1.0},"173":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"147":{"tf":1.0}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"163":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"161":{"tf":1.0},"172":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"164":{"tf":1.0},"173":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"{":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"171":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"{":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"160":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"171":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"n":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":5,"docs":{"102":{"tf":1.7320508075688772},"129":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"179":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"144":{"tf":1.0},"145":{"tf":1.0},"229":{"tf":2.0}},"r":{"df":2,"docs":{"152":{"tf":1.0},"163":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"120":{"tf":1.0}}}}}}},"o":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"214":{"tf":1.0},"221":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"s":{"df":7,"docs":{"101":{"tf":1.0},"104":{"tf":1.0},"125":{"tf":1.0},"131":{"tf":1.0},"133":{"tf":1.0},"221":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{}},"df":59,"docs":{"0":{"tf":3.0},"100":{"tf":1.4142135623730951},"101":{"tf":1.0},"102":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"111":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.7320508075688772},"119":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":2.0},"124":{"tf":1.7320508075688772},"125":{"tf":1.4142135623730951},"126":{"tf":1.0},"127":{"tf":1.0},"129":{"tf":1.0},"131":{"tf":1.0},"134":{"tf":1.4142135623730951},"137":{"tf":1.0},"138":{"tf":1.4142135623730951},"139":{"tf":1.0},"141":{"tf":1.7320508075688772},"144":{"tf":1.4142135623730951},"145":{"tf":1.4142135623730951},"146":{"tf":1.0},"147":{"tf":1.7320508075688772},"148":{"tf":1.7320508075688772},"152":{"tf":1.0},"155":{"tf":1.0},"158":{"tf":1.0},"161":{"tf":1.4142135623730951},"165":{"tf":1.7320508075688772},"166":{"tf":1.7320508075688772},"167":{"tf":2.6457513110645907},"174":{"tf":2.449489742783178},"186":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.0},"210":{"tf":2.449489742783178},"211":{"tf":1.4142135623730951},"215":{"tf":1.0},"218":{"tf":1.0},"221":{"tf":1.7320508075688772},"222":{"tf":1.4142135623730951},"223":{"tf":1.4142135623730951},"226":{"tf":1.4142135623730951},"5":{"tf":3.0},"7":{"tf":3.0},"71":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":2.23606797749979},"87":{"tf":2.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.7320508075688772},"90":{"tf":1.4142135623730951},"91":{"tf":1.7320508075688772},"98":{"tf":1.4142135623730951}},"r":{"df":1,"docs":{"174":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"186":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"227":{"tf":1.0}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":1,"docs":{"226":{"tf":1.0}},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":2,"docs":{"210":{"tf":1.7320508075688772},"215":{"tf":1.4142135623730951}}}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"167":{"tf":1.0},"197":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":1,"docs":{"166":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":10,"docs":{"0":{"tf":1.0},"107":{"tf":1.0},"144":{"tf":1.0},"147":{"tf":1.0},"185":{"tf":1.0},"202":{"tf":1.0},"206":{"tf":1.0},"211":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.0}}},"m":{"a":{"df":2,"docs":{"113":{"tf":1.0},"138":{"tf":1.0}},"n":{"d":{"df":23,"docs":{"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.7320508075688772},"108":{"tf":1.0},"112":{"tf":2.6457513110645907},"122":{"tf":1.0},"133":{"tf":2.6457513110645907},"135":{"tf":1.4142135623730951},"138":{"tf":2.0},"144":{"tf":1.0},"145":{"tf":1.0},"177":{"tf":1.0},"178":{"tf":1.4142135623730951},"179":{"tf":1.4142135623730951},"180":{"tf":1.0},"182":{"tf":1.0},"186":{"tf":1.0},"188":{"tf":1.0},"196":{"tf":1.0},"202":{"tf":1.0},"5":{"tf":2.0},"7":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":11,"docs":{"11":{"tf":1.7320508075688772},"12":{"tf":1.7320508075688772},"124":{"tf":1.0},"129":{"tf":1.4142135623730951},"141":{"tf":1.0},"203":{"tf":1.4142135623730951},"214":{"tf":1.0},"221":{"tf":1.0},"229":{"tf":1.4142135623730951},"230":{"tf":1.0},"91":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"(":{"df":1,"docs":{"182":{"tf":1.0}}},"1":{"df":1,"docs":{"186":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"186":{"tf":1.0}}},"df":17,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"106":{"tf":1.0},"113":{"tf":1.7320508075688772},"128":{"tf":1.0},"133":{"tf":2.449489742783178},"138":{"tf":1.7320508075688772},"179":{"tf":2.23606797749979},"182":{"tf":1.4142135623730951},"186":{"tf":3.0},"187":{"tf":1.4142135623730951},"188":{"tf":1.4142135623730951},"189":{"tf":2.0},"190":{"tf":2.449489742783178},"191":{"tf":1.7320508075688772},"192":{"tf":1.4142135623730951},"195":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":22,"docs":{"0":{"tf":1.0},"101":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"112":{"tf":1.0},"130":{"tf":1.4142135623730951},"131":{"tf":1.0},"133":{"tf":1.0},"146":{"tf":1.7320508075688772},"155":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":2.23606797749979},"169":{"tf":1.0},"170":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"173":{"tf":1.0},"174":{"tf":1.4142135623730951},"211":{"tf":1.0},"226":{"tf":1.0},"29":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"203":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":10,"docs":{"113":{"tf":1.0},"114":{"tf":1.0},"13":{"tf":1.0},"131":{"tf":1.0},"138":{"tf":1.0},"141":{"tf":1.0},"163":{"tf":1.0},"167":{"tf":1.0},"222":{"tf":1.0},"226":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}}}},"t":{"df":2,"docs":{"214":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":23,"docs":{"107":{"tf":1.0},"130":{"tf":1.0},"138":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"151":{"tf":1.0},"154":{"tf":1.4142135623730951},"156":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"161":{"tf":1.7320508075688772},"168":{"tf":1.0},"169":{"tf":1.0},"176":{"tf":1.7320508075688772},"210":{"tf":1.0},"222":{"tf":2.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951},"85":{"tf":1.0},"88":{"tf":1.0},"93":{"tf":1.4142135623730951},"98":{"tf":1.0},"99":{"tf":1.7320508075688772}},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"138":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"210":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"177":{"tf":1.0},"193":{"tf":1.0},"199":{"tf":1.0},"200":{"tf":1.0},"5":{"tf":1.0},"89":{"tf":1.0}}},"x":{"df":10,"docs":{"0":{"tf":1.4142135623730951},"119":{"tf":1.0},"137":{"tf":1.0},"161":{"tf":1.0},"210":{"tf":1.0},"211":{"tf":1.0},"223":{"tf":2.449489742783178},"38":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772},"87":{"tf":2.23606797749979}}}},"i":{"c":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"108":{"tf":1.7320508075688772},"125":{"tf":1.0},"2":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"226":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"210":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"130":{"tf":1.0},"156":{"tf":1.0},"213":{"tf":1.0},"226":{"tf":1.0},"99":{"tf":1.0}},"u":{"df":1,"docs":{"221":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"144":{"tf":1.0},"154":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"107":{"tf":1.0}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"138":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"146":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":7,"docs":{"120":{"tf":1.0},"210":{"tf":1.0},"213":{"tf":1.4142135623730951},"221":{"tf":1.0},"223":{"tf":1.0},"226":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{},"f":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"129":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"121":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":2,"docs":{"121":{"tf":1.0},"129":{"tf":1.0}},"i":{"d":{"df":2,"docs":{"147":{"tf":1.0},"230":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":2,"docs":{"129":{"tf":1.0},"7":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"129":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":85,"docs":{"10":{"tf":1.4142135623730951},"109":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"121":{"tf":1.7320508075688772},"129":{"tf":4.123105625617661},"13":{"tf":1.4142135623730951},"139":{"tf":2.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"202":{"tf":2.0},"203":{"tf":1.0},"21":{"tf":2.23606797749979},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"26":{"tf":2.23606797749979},"27":{"tf":2.23606797749979},"28":{"tf":1.4142135623730951},"29":{"tf":1.7320508075688772},"30":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"41":{"tf":2.23606797749979},"42":{"tf":1.4142135623730951},"43":{"tf":2.23606797749979},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"5":{"tf":2.449489742783178},"50":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"7":{"tf":3.1622776601683795},"70":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"72":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"8":{"tf":2.23606797749979},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"230":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"127":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"99":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"129":{"tf":1.0}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"220":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"202":{"tf":1.0}}}}},"i":{"d":{"df":14,"docs":{"0":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"148":{"tf":1.0},"221":{"tf":1.0},"223":{"tf":1.0},"224":{"tf":1.0},"30":{"tf":1.0},"43":{"tf":1.0},"54":{"tf":1.0},"63":{"tf":1.0},"75":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"214":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"148":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951}}}}},"df":2,"docs":{"161":{"tf":1.0},"71":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"129":{"tf":1.0}}}}},"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"129":{"tf":1.0},"161":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"121":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"230":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":30,"docs":{"0":{"tf":1.0},"113":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":1.0},"129":{"tf":1.0},"138":{"tf":1.0},"145":{"tf":1.0},"149":{"tf":1.0},"151":{"tf":1.4142135623730951},"152":{"tf":1.4142135623730951},"159":{"tf":1.0},"167":{"tf":1.0},"186":{"tf":1.0},"188":{"tf":1.0},"196":{"tf":1.0},"210":{"tf":1.0},"213":{"tf":1.4142135623730951},"214":{"tf":1.4142135623730951},"218":{"tf":1.0},"220":{"tf":1.0},"223":{"tf":1.4142135623730951},"225":{"tf":1.0},"226":{"tf":1.0},"29":{"tf":1.0},"5":{"tf":1.4142135623730951},"51":{"tf":1.0},"7":{"tf":2.0},"86":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"114":{"tf":1.0},"121":{"tf":1.0},"141":{"tf":1.0},"186":{"tf":1.0},"210":{"tf":1.4142135623730951},"221":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":8,"docs":{"107":{"tf":1.0},"144":{"tf":1.0},"146":{"tf":1.0},"151":{"tf":1.0},"167":{"tf":3.0},"169":{"tf":1.4142135623730951},"172":{"tf":1.0},"174":{"tf":3.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":6,"docs":{"177":{"tf":1.0},"229":{"tf":1.0},"93":{"tf":1.7320508075688772},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}}}},"r":{"a":{"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"145":{"tf":1.0},"220":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":8,"docs":{"100":{"tf":1.0},"109":{"tf":1.0},"203":{"tf":1.4142135623730951},"227":{"tf":1.0},"228":{"tf":1.0},"229":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"100":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"199":{"tf":1.4142135623730951},"200":{"tf":1.0},"203":{"tf":2.449489742783178},"229":{"tf":2.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"204":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"104":{"tf":1.0},"163":{"tf":1.0}}},"t":{"df":2,"docs":{"128":{"tf":1.0},"137":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"161":{"tf":1.0},"163":{"tf":1.0},"222":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":13,"docs":{"108":{"tf":1.0},"113":{"tf":1.0},"122":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.0},"140":{"tf":1.0},"142":{"tf":1.0},"159":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.0},"179":{"tf":1.4142135623730951},"180":{"tf":1.0},"75":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"177":{"tf":2.23606797749979}}}}}},":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"171":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"160":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":2,"docs":{"177":{"tf":1.0},"218":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":9,"docs":{"0":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"147":{"tf":1.0},"186":{"tf":1.7320508075688772},"224":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.7320508075688772},"86":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":14,"docs":{"117":{"tf":1.0},"129":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"167":{"tf":1.4142135623730951},"169":{"tf":1.0},"182":{"tf":1.4142135623730951},"183":{"tf":1.0},"189":{"tf":1.4142135623730951},"190":{"tf":1.4142135623730951},"191":{"tf":1.4142135623730951},"192":{"tf":1.0},"219":{"tf":1.0},"220":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"31":{"tf":1.0},"71":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"222":{"tf":1.0},"226":{"tf":1.0},"230":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":3,"docs":{"204":{"tf":1.0},"5":{"tf":1.0},"99":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"100":{"tf":1.4142135623730951},"149":{"tf":1.0},"156":{"tf":1.0},"186":{"tf":1.0},"201":{"tf":1.0},"202":{"tf":1.7320508075688772},"203":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"=":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"177":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"99":{"tf":1.0}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"99":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":19,"docs":{"0":{"tf":1.0},"105":{"tf":1.4142135623730951},"113":{"tf":1.7320508075688772},"116":{"tf":1.4142135623730951},"140":{"tf":1.7320508075688772},"167":{"tf":2.0},"172":{"tf":1.0},"174":{"tf":1.7320508075688772},"25":{"tf":1.7320508075688772},"34":{"tf":1.0},"5":{"tf":1.4142135623730951},"61":{"tf":1.7320508075688772},"89":{"tf":1.0},"9":{"tf":1.7320508075688772},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.4142135623730951},"96":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":21,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"109":{"tf":1.4142135623730951},"111":{"tf":1.0},"112":{"tf":2.0},"113":{"tf":1.4142135623730951},"114":{"tf":1.0},"116":{"tf":1.0},"127":{"tf":1.4142135623730951},"133":{"tf":2.0},"138":{"tf":1.4142135623730951},"139":{"tf":1.0},"151":{"tf":1.0},"155":{"tf":2.0},"161":{"tf":2.8284271247461903},"169":{"tf":1.0},"179":{"tf":1.0},"187":{"tf":1.0},"192":{"tf":1.0},"214":{"tf":1.4142135623730951},"226":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"113":{"tf":1.0},"138":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"129":{"tf":1.0}}}}}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"181":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"167":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"162":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":35,"docs":{"108":{"tf":1.4142135623730951},"113":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.0},"167":{"tf":1.0},"174":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.0},"179":{"tf":1.0},"182":{"tf":1.4142135623730951},"183":{"tf":1.0},"186":{"tf":2.0},"188":{"tf":1.0},"189":{"tf":1.4142135623730951},"190":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.0},"193":{"tf":1.7320508075688772},"202":{"tf":1.0},"203":{"tf":1.7320508075688772},"210":{"tf":1.0},"211":{"tf":1.0},"218":{"tf":1.7320508075688772},"220":{"tf":1.4142135623730951},"221":{"tf":1.7320508075688772},"222":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":2.8284271247461903},"36":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"7":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":4,"docs":{"146":{"tf":1.0},"221":{"tf":1.0},"223":{"tf":1.0},"226":{"tf":1.4142135623730951}}}}}}},"x":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"212":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"c":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"161":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"158":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"159":{"tf":1.0},"172":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"161":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"(":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"158":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":6,"docs":{"152":{"tf":1.0},"153":{"tf":1.0},"159":{"tf":1.0},"169":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":20,"docs":{"119":{"tf":1.7320508075688772},"120":{"tf":1.4142135623730951},"121":{"tf":1.0},"146":{"tf":1.4142135623730951},"147":{"tf":1.4142135623730951},"152":{"tf":1.0},"153":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.0},"160":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"167":{"tf":1.0},"169":{"tf":1.4142135623730951},"170":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"173":{"tf":1.0},"212":{"tf":1.0},"221":{"tf":1.4142135623730951}}},"y":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"175":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"203":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"177":{"tf":1.0}}}},"t":{"a":{"df":8,"docs":{"151":{"tf":1.0},"153":{"tf":1.0},"169":{"tf":1.0},"210":{"tf":1.7320508075688772},"211":{"tf":1.0},"217":{"tf":1.0},"218":{"tf":1.4142135623730951},"224":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":10,"docs":{"134":{"tf":1.0},"176":{"tf":1.0},"179":{"tf":1.7320508075688772},"185":{"tf":1.0},"187":{"tf":1.0},"188":{"tf":1.0},"193":{"tf":1.4142135623730951},"209":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.0}}}},"y":{"df":2,"docs":{"176":{"tf":1.0},"230":{"tf":1.0}}}},"b":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":2,"docs":{"126":{"tf":1.0},"14":{"tf":1.7320508075688772}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"d":{"df":2,"docs":{"179":{"tf":1.0},"193":{"tf":2.0}}},"df":4,"docs":{"138":{"tf":1.4142135623730951},"148":{"tf":1.4142135623730951},"5":{"tf":1.0},"96":{"tf":1.4142135623730951}},"e":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":10,"docs":{"118":{"tf":1.4142135623730951},"127":{"tf":1.0},"131":{"tf":1.0},"144":{"tf":1.4142135623730951},"145":{"tf":1.0},"165":{"tf":1.4142135623730951},"167":{"tf":1.0},"168":{"tf":1.0},"174":{"tf":1.7320508075688772},"99":{"tf":1.0}}}},"b":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"177":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"g":{"df":3,"docs":{"109":{"tf":1.0},"126":{"tf":2.0},"129":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"161":{"tf":1.0},"167":{"tf":1.0}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":2,"docs":{"53":{"tf":1.0},"78":{"tf":1.0}}},"s":{"df":2,"docs":{"118":{"tf":1.0},"143":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":8,"docs":{"109":{"tf":1.0},"116":{"tf":2.449489742783178},"117":{"tf":1.0},"119":{"tf":1.0},"124":{"tf":1.0},"135":{"tf":1.4142135623730951},"146":{"tf":1.0},"211":{"tf":1.7320508075688772}},"e":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"116":{"tf":1.4142135623730951},"124":{"tf":1.0},"134":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"!":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"129":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"129":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"167":{"tf":1.0}}}}}},"f":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"171":{"tf":1.0}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":96,"docs":{"0":{"tf":1.7320508075688772},"10":{"tf":1.0},"108":{"tf":1.0},"11":{"tf":1.0},"112":{"tf":1.4142135623730951},"113":{"tf":1.4142135623730951},"116":{"tf":1.0},"12":{"tf":1.0},"129":{"tf":1.7320508075688772},"13":{"tf":1.0},"133":{"tf":1.0},"134":{"tf":1.0},"138":{"tf":1.0},"14":{"tf":1.0},"140":{"tf":1.0},"147":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"177":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.0},"21":{"tf":2.23606797749979},"22":{"tf":1.0},"225":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":2.0},"27":{"tf":2.23606797749979},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.0},"42":{"tf":1.0},"43":{"tf":2.449489742783178},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":2.23606797749979},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":2.23606797749979},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0},"96":{"tf":1.0}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"129":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"167":{"tf":1.0},"174":{"tf":1.0}}}}},"i":{"d":{"df":2,"docs":{"159":{"tf":1.0},"172":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":35,"docs":{"109":{"tf":1.0},"112":{"tf":1.7320508075688772},"129":{"tf":1.0},"131":{"tf":1.7320508075688772},"132":{"tf":1.0},"133":{"tf":1.0},"134":{"tf":1.7320508075688772},"135":{"tf":1.0},"137":{"tf":1.0},"144":{"tf":1.4142135623730951},"145":{"tf":1.0},"146":{"tf":1.0},"153":{"tf":1.0},"155":{"tf":1.4142135623730951},"158":{"tf":1.0},"159":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"167":{"tf":1.7320508075688772},"168":{"tf":1.0},"172":{"tf":1.4142135623730951},"173":{"tf":1.7320508075688772},"174":{"tf":1.7320508075688772},"178":{"tf":1.7320508075688772},"200":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.4142135623730951},"206":{"tf":1.0},"212":{"tf":1.4142135623730951},"214":{"tf":1.4142135623730951},"220":{"tf":1.0},"226":{"tf":1.0},"7":{"tf":1.0},"84":{"tf":1.0}},"e":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"134":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"121":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":9,"docs":{"112":{"tf":1.0},"119":{"tf":1.0},"129":{"tf":1.7320508075688772},"131":{"tf":1.4142135623730951},"133":{"tf":1.0},"151":{"tf":1.0},"162":{"tf":1.0},"169":{"tf":1.0},"219":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"229":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"179":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"161":{"tf":1.0},"213":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"i":{"df":3,"docs":{"0":{"tf":1.0},"7":{"tf":1.7320508075688772},"85":{"tf":1.0}}},"y":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"p":{"df":1,"docs":{"5":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"d":{"df":13,"docs":{"119":{"tf":1.0},"157":{"tf":1.0},"172":{"tf":1.0},"186":{"tf":1.0},"210":{"tf":1.0},"213":{"tf":1.0},"214":{"tf":1.0},"217":{"tf":1.0},"219":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.0},"225":{"tf":1.0},"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"175":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":4,"docs":{"104":{"tf":1.4142135623730951},"186":{"tf":1.4142135623730951},"203":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"101":{"tf":1.0},"141":{"tf":1.0},"154":{"tf":1.0},"90":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"226":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"b":{"df":16,"docs":{"100":{"tf":1.0},"121":{"tf":1.0},"124":{"tf":1.0},"134":{"tf":1.4142135623730951},"175":{"tf":2.0},"176":{"tf":1.0},"203":{"tf":1.4142135623730951},"209":{"tf":1.0},"211":{"tf":1.7320508075688772},"213":{"tf":1.7320508075688772},"214":{"tf":1.0},"217":{"tf":1.0},"222":{"tf":1.0},"226":{"tf":1.7320508075688772},"4":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":8,"docs":{"0":{"tf":1.0},"101":{"tf":1.0},"109":{"tf":1.0},"116":{"tf":1.4142135623730951},"124":{"tf":1.0},"134":{"tf":1.4142135623730951},"5":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":6,"docs":{"149":{"tf":1.0},"211":{"tf":1.0},"6":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"99":{"tf":1.0}}}},"r":{"df":2,"docs":{"211":{"tf":1.0},"30":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"167":{"tf":1.0},"174":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":10,"docs":{"105":{"tf":1.0},"119":{"tf":1.0},"146":{"tf":1.0},"149":{"tf":1.0},"176":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":1.0},"217":{"tf":1.0},"7":{"tf":1.0},"99":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":11,"docs":{"109":{"tf":1.0},"122":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"134":{"tf":1.0},"138":{"tf":1.0},"144":{"tf":1.0},"148":{"tf":1.0},"167":{"tf":1.4142135623730951},"174":{"tf":1.4142135623730951},"211":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"117":{"tf":1.0},"160":{"tf":1.0},"189":{"tf":1.0},"27":{"tf":1.0},"44":{"tf":1.0}}}}}}}},"v":{"df":27,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":3.3166247903554},"106":{"tf":1.0},"107":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"115":{"tf":1.7320508075688772},"116":{"tf":1.0},"117":{"tf":1.7320508075688772},"119":{"tf":1.0},"125":{"tf":1.0},"128":{"tf":1.4142135623730951},"130":{"tf":1.0},"131":{"tf":1.0},"133":{"tf":2.0},"134":{"tf":1.0},"135":{"tf":1.4142135623730951},"138":{"tf":1.0},"140":{"tf":1.4142135623730951},"142":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"168":{"tf":1.0},"176":{"tf":1.0},"203":{"tf":2.449489742783178}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":136,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.4142135623730951},"108":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.4142135623730951},"117":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"134":{"tf":1.0},"135":{"tf":1.0},"136":{"tf":1.7320508075688772},"137":{"tf":2.23606797749979},"138":{"tf":1.0},"139":{"tf":1.0},"140":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.0},"143":{"tf":1.4142135623730951},"144":{"tf":1.0},"145":{"tf":1.4142135623730951},"146":{"tf":1.0},"147":{"tf":1.0},"148":{"tf":1.0},"149":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.0},"156":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.0},"160":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.4142135623730951},"163":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"170":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"173":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.0},"181":{"tf":1.0},"182":{"tf":1.0},"183":{"tf":1.0},"184":{"tf":1.0},"185":{"tf":1.0},"186":{"tf":1.0},"187":{"tf":1.0},"188":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.0},"193":{"tf":1.0},"194":{"tf":1.0},"195":{"tf":1.0},"196":{"tf":1.0},"197":{"tf":1.4142135623730951},"198":{"tf":1.0},"199":{"tf":1.4142135623730951},"200":{"tf":1.0},"201":{"tf":1.0},"202":{"tf":1.4142135623730951},"203":{"tf":2.6457513110645907},"204":{"tf":1.0},"205":{"tf":1.0},"206":{"tf":1.0},"207":{"tf":1.0},"208":{"tf":1.0},"209":{"tf":1.0},"210":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":1.0},"214":{"tf":1.0},"215":{"tf":1.0},"216":{"tf":1.0},"217":{"tf":1.0},"218":{"tf":1.0},"219":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.0},"222":{"tf":1.0},"223":{"tf":1.7320508075688772},"224":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":1.0},"227":{"tf":1.0},"228":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.0},"3":{"tf":1.0},"97":{"tf":1.7320508075688772},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":11,"docs":{"127":{"tf":1.0},"130":{"tf":1.0},"146":{"tf":1.4142135623730951},"156":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.7320508075688772},"159":{"tf":1.0},"160":{"tf":1.4142135623730951},"168":{"tf":1.0},"171":{"tf":1.7320508075688772},"172":{"tf":1.7320508075688772}}}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"217":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":3,"docs":{"105":{"tf":1.0},"182":{"tf":1.0},"188":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":20,"docs":{"103":{"tf":1.0},"113":{"tf":1.0},"120":{"tf":1.0},"127":{"tf":2.0},"133":{"tf":1.0},"139":{"tf":1.0},"140":{"tf":1.0},"154":{"tf":1.0},"167":{"tf":1.4142135623730951},"174":{"tf":1.0},"175":{"tf":1.0},"203":{"tf":1.0},"214":{"tf":1.0},"218":{"tf":1.0},"220":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"88":{"tf":1.0},"93":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":4,"docs":{"165":{"tf":1.0},"166":{"tf":1.0},"174":{"tf":1.0},"223":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"r":{"df":1,"docs":{"108":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"2":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"3":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":3,"docs":{"127":{"tf":1.0},"226":{"tf":1.0},"229":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"182":{"tf":1.0},"214":{"tf":1.0},"220":{"tf":1.0},"224":{"tf":1.0},"4":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":21,"docs":{"108":{"tf":1.4142135623730951},"112":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"129":{"tf":1.7320508075688772},"133":{"tf":1.7320508075688772},"139":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.0},"182":{"tf":1.4142135623730951},"183":{"tf":1.0},"186":{"tf":1.0},"189":{"tf":1.4142135623730951},"190":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.0},"196":{"tf":1.4142135623730951},"203":{"tf":1.0},"24":{"tf":1.0},"7":{"tf":1.7320508075688772}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"x":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"178":{"tf":1.0},"181":{"tf":1.0},"202":{"tf":1.4142135623730951},"203":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"5":{"tf":1.0},"89":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":5,"docs":{"39":{"tf":1.7320508075688772},"40":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"42":{"tf":1.7320508075688772},"7":{"tf":2.0}},"e":{"d":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"133":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"152":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":6,"docs":{"133":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.4142135623730951},"213":{"tf":1.0},"227":{"tf":1.0},"228":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"148":{"tf":1.0}}}}}},"m":{"df":1,"docs":{"230":{"tf":1.0}}},"o":{"c":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":7,"docs":{"124":{"tf":1.0},"129":{"tf":1.4142135623730951},"130":{"tf":1.0},"203":{"tf":1.0},"43":{"tf":2.0},"61":{"tf":1.4142135623730951},"98":{"tf":1.0}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"95":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":31,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"109":{"tf":1.4142135623730951},"110":{"tf":1.0},"116":{"tf":2.0},"121":{"tf":1.4142135623730951},"124":{"tf":2.23606797749979},"128":{"tf":1.0},"129":{"tf":1.4142135623730951},"130":{"tf":1.4142135623730951},"131":{"tf":1.0},"144":{"tf":1.4142135623730951},"145":{"tf":1.4142135623730951},"146":{"tf":1.7320508075688772},"153":{"tf":1.0},"159":{"tf":1.0},"175":{"tf":1.0},"186":{"tf":1.4142135623730951},"187":{"tf":1.7320508075688772},"193":{"tf":1.0},"194":{"tf":1.0},"201":{"tf":1.0},"203":{"tf":1.7320508075688772},"204":{"tf":1.4142135623730951},"208":{"tf":1.0},"227":{"tf":1.0},"5":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.0},"84":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}}}}}}},"df":1,"docs":{"229":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":10,"docs":{"124":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":1.0},"174":{"tf":1.0},"218":{"tf":1.0},"219":{"tf":1.0},"221":{"tf":1.0},"229":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"209":{"tf":1.0},"211":{"tf":2.0}}}}},"df":0,"docs":{}},"n":{"'":{"df":0,"docs":{},"t":{"df":27,"docs":{"111":{"tf":1.0},"113":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"127":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.0},"132":{"tf":1.0},"138":{"tf":1.4142135623730951},"143":{"tf":1.0},"144":{"tf":1.0},"146":{"tf":1.0},"154":{"tf":1.0},"174":{"tf":1.0},"178":{"tf":1.0},"181":{"tf":1.0},"193":{"tf":1.0},"200":{"tf":1.0},"210":{"tf":1.0},"213":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.0},"223":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":1.0},"230":{"tf":1.0},"27":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":18,"docs":{"100":{"tf":1.0},"117":{"tf":1.4142135623730951},"121":{"tf":1.0},"129":{"tf":1.4142135623730951},"175":{"tf":1.0},"176":{"tf":1.4142135623730951},"179":{"tf":1.0},"181":{"tf":1.4142135623730951},"182":{"tf":1.0},"183":{"tf":1.4142135623730951},"189":{"tf":1.0},"199":{"tf":1.0},"201":{"tf":1.0},"202":{"tf":1.0},"212":{"tf":1.0},"217":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":2.0}}}},"t":{"df":1,"docs":{"24":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":4,"docs":{"113":{"tf":1.0},"118":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"227":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"171":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"165":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"207":{"tf":1.4142135623730951},"221":{"tf":1.7320508075688772}},"s":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"226":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"136":{"tf":1.0}}},"r":{"df":3,"docs":{"108":{"tf":2.0},"4":{"tf":1.0},"6":{"tf":2.449489742783178}}}}}},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"159":{"tf":1.0},"172":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"159":{"tf":2.0},"172":{"tf":1.4142135623730951},"203":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"e":{"df":3,"docs":{"138":{"tf":1.0},"200":{"tf":1.0},"202":{"tf":1.0}}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"186":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"229":{"tf":1.0},"25":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":9,"docs":{"107":{"tf":1.0},"144":{"tf":1.0},"175":{"tf":1.0},"185":{"tf":1.0},"208":{"tf":1.0},"223":{"tf":1.0},"226":{"tf":1.0},"230":{"tf":1.0},"7":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"227":{"tf":1.0},"229":{"tf":1.7320508075688772},"230":{"tf":1.0}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"5":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.0},"95":{"tf":1.0}}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"165":{"tf":1.0},"166":{"tf":1.0},"174":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":17,"docs":{"0":{"tf":2.0},"113":{"tf":1.0},"134":{"tf":1.0},"16":{"tf":1.0},"161":{"tf":1.0},"163":{"tf":1.0},"179":{"tf":1.0},"203":{"tf":1.4142135623730951},"210":{"tf":1.0},"211":{"tf":1.0},"217":{"tf":1.0},"222":{"tf":1.0},"223":{"tf":1.0},"27":{"tf":1.4142135623730951},"5":{"tf":1.0},"7":{"tf":1.0},"93":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":14,"docs":{"0":{"tf":1.0},"104":{"tf":1.0},"113":{"tf":1.4142135623730951},"137":{"tf":1.0},"138":{"tf":1.0},"140":{"tf":1.0},"186":{"tf":1.4142135623730951},"203":{"tf":1.0},"220":{"tf":1.0},"223":{"tf":1.0},"27":{"tf":1.0},"7":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":7,"docs":{"111":{"tf":1.0},"133":{"tf":1.0},"135":{"tf":1.4142135623730951},"221":{"tf":1.4142135623730951},"226":{"tf":1.4142135623730951},"230":{"tf":1.0},"93":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"100":{"tf":1.0},"147":{"tf":1.0},"221":{"tf":1.0},"97":{"tf":1.0}}}}},"y":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"144":{"tf":1.0}}},"<":{"'":{"_":{"df":3,"docs":{"119":{"tf":1.4142135623730951},"120":{"tf":1.0},"221":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"116":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"167":{"tf":1.0},"212":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":12,"docs":{"116":{"tf":1.4142135623730951},"118":{"tf":1.7320508075688772},"119":{"tf":2.0},"120":{"tf":1.4142135623730951},"130":{"tf":1.4142135623730951},"143":{"tf":1.7320508075688772},"144":{"tf":2.8284271247461903},"145":{"tf":1.4142135623730951},"166":{"tf":1.0},"167":{"tf":1.0},"212":{"tf":1.0},"222":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}}},"s":{"df":0,"docs":{},"i":{"df":3,"docs":{"192":{"tf":1.0},"210":{"tf":1.0},"88":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":8,"docs":{"120":{"tf":1.0},"145":{"tf":1.0},"203":{"tf":2.0},"214":{"tf":1.0},"222":{"tf":1.0},"226":{"tf":1.0},"229":{"tf":1.0},"88":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"182":{"tf":1.0},"195":{"tf":1.0},"5":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"211":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"200":{"tf":1.0}}}}}}}}}},"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"137":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"177":{"tf":1.0},"6":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"122":{"tf":1.0},"186":{"tf":1.0}}}}}}},"df":4,"docs":{"186":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"58":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"29":{"tf":1.0},"30":{"tf":1.7320508075688772},"31":{"tf":1.7320508075688772},"32":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"i":{"b":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"213":{"tf":1.4142135623730951},"223":{"tf":1.4142135623730951},"225":{"tf":1.0},"58":{"tf":1.7320508075688772}}}}}},"v":{"df":1,"docs":{"5":{"tf":1.0}}}},"m":{"df":0,"docs":{},"t":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"218":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"119":{"tf":1.0},"120":{"tf":1.0}}}},"t":{"df":12,"docs":{"109":{"tf":1.0},"117":{"tf":1.0},"119":{"tf":2.0},"138":{"tf":2.0},"146":{"tf":3.7416573867739413},"147":{"tf":2.0},"148":{"tf":1.0},"149":{"tf":1.7320508075688772},"166":{"tf":1.0},"27":{"tf":1.0},"7":{"tf":1.4142135623730951},"83":{"tf":1.0}}}},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"137":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":5,"docs":{"116":{"tf":1.0},"138":{"tf":1.0},"188":{"tf":1.0},"213":{"tf":2.23606797749979},"218":{"tf":1.0}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":11,"docs":{"0":{"tf":1.4142135623730951},"123":{"tf":1.0},"127":{"tf":1.0},"138":{"tf":1.0},"203":{"tf":1.0},"44":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"79":{"tf":1.0},"90":{"tf":1.7320508075688772},"91":{"tf":1.4142135623730951}},"e":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"146":{"tf":1.0},"165":{"tf":1.0},"96":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"127":{"tf":1.0},"203":{"tf":1.0},"229":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"d":{"df":8,"docs":{"127":{"tf":1.0},"144":{"tf":1.0},"166":{"tf":1.0},"203":{"tf":1.0},"208":{"tf":1.0},"218":{"tf":1.0},"225":{"tf":1.0},"27":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"230":{"tf":1.0}}}}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":5,"docs":{"203":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"69":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"137":{"tf":1.0},"161":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"137":{"tf":1.4142135623730951},"186":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":5,"docs":{"161":{"tf":1.0},"174":{"tf":1.0},"187":{"tf":1.0},"203":{"tf":1.0},"212":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"120":{"tf":1.0},"121":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"137":{"tf":1.0},"153":{"tf":1.0},"169":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"127":{"tf":1.0},"7":{"tf":1.0}}},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"161":{"tf":1.0},"211":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"129":{"tf":1.0},"175":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"48":{"tf":1.0}}},"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"34":{"tf":1.0},"47":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":7,"docs":{"153":{"tf":1.0},"163":{"tf":1.0},"218":{"tf":2.6457513110645907},"219":{"tf":2.0},"220":{"tf":1.4142135623730951},"47":{"tf":1.7320508075688772},"48":{"tf":1.4142135623730951}}}},"v":{"df":2,"docs":{"93":{"tf":1.0},"94":{"tf":1.0}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"129":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772}}}}}}}},"q":{"df":1,"docs":{"159":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"167":{"tf":1.0},"174":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"226":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"52":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":13,"docs":{"103":{"tf":1.0},"107":{"tf":1.0},"113":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":2.8284271247461903},"140":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"148":{"tf":2.0},"5":{"tf":1.0},"52":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"93":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"152":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":3,"docs":{"202":{"tf":1.0},"203":{"tf":1.7320508075688772},"92":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"161":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"204":{"tf":1.0},"206":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"c":{"df":9,"docs":{"130":{"tf":1.0},"138":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.0},"161":{"tf":1.0},"223":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951},"96":{"tf":1.0}}},"df":0,"docs":{}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":2,"docs":{"226":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":12,"docs":{"164":{"tf":1.4142135623730951},"173":{"tf":1.0},"186":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.0},"210":{"tf":1.0},"221":{"tf":1.0},"226":{"tf":1.0},"5":{"tf":1.7320508075688772},"71":{"tf":1.0},"90":{"tf":1.0},"99":{"tf":1.0}},"t":{"df":1,"docs":{"227":{"tf":1.0}},"u":{"df":1,"docs":{"230":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"227":{"tf":1.0},"228":{"tf":2.0}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"145":{"tf":1.0}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":7,"docs":{"113":{"tf":1.0},"116":{"tf":1.0},"138":{"tf":1.0},"166":{"tf":1.0},"186":{"tf":1.0},"202":{"tf":1.0},"226":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":9,"docs":{"144":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.0},"152":{"tf":1.4142135623730951},"153":{"tf":1.0},"157":{"tf":1.4142135623730951},"158":{"tf":1.0},"159":{"tf":1.0},"167":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":57,"docs":{"103":{"tf":1.0},"109":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951},"121":{"tf":1.7320508075688772},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.7320508075688772},"127":{"tf":1.4142135623730951},"132":{"tf":1.0},"133":{"tf":1.0},"134":{"tf":1.7320508075688772},"138":{"tf":1.4142135623730951},"140":{"tf":1.0},"142":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.4142135623730951},"146":{"tf":1.4142135623730951},"147":{"tf":1.7320508075688772},"148":{"tf":2.0},"154":{"tf":1.0},"155":{"tf":1.0},"161":{"tf":1.0},"163":{"tf":1.0},"167":{"tf":1.0},"169":{"tf":1.4142135623730951},"174":{"tf":1.4142135623730951},"181":{"tf":1.0},"21":{"tf":1.0},"210":{"tf":1.0},"211":{"tf":1.0},"213":{"tf":2.23606797749979},"214":{"tf":2.23606797749979},"215":{"tf":1.0},"219":{"tf":1.7320508075688772},"220":{"tf":1.4142135623730951},"221":{"tf":1.0},"223":{"tf":2.449489742783178},"225":{"tf":1.0},"226":{"tf":2.23606797749979},"27":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":2.449489742783178},"58":{"tf":1.0},"6":{"tf":1.4142135623730951},"61":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"226":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"49":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"190":{"tf":1.0},"191":{"tf":1.0}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"218":{"tf":1.0}}}}}},"df":1,"docs":{"19":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"113":{"tf":1.0},"122":{"tf":1.0},"128":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":11,"docs":{"100":{"tf":1.0},"115":{"tf":1.0},"130":{"tf":1.0},"145":{"tf":1.0},"150":{"tf":1.0},"181":{"tf":1.0},"186":{"tf":1.0},"188":{"tf":1.0},"203":{"tf":1.4142135623730951},"222":{"tf":1.4142135623730951},"229":{"tf":1.0}}}},"t":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":8,"docs":{"120":{"tf":1.0},"143":{"tf":1.0},"166":{"tf":1.7320508075688772},"167":{"tf":2.449489742783178},"174":{"tf":2.23606797749979},"186":{"tf":1.0},"203":{"tf":1.0},"212":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":7,"docs":{"144":{"tf":1.0},"165":{"tf":2.6457513110645907},"166":{"tf":1.4142135623730951},"167":{"tf":2.23606797749979},"174":{"tf":2.8284271247461903},"214":{"tf":1.4142135623730951},"83":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":14,"docs":{"103":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"120":{"tf":1.0},"138":{"tf":1.0},"146":{"tf":1.0},"15":{"tf":1.7320508075688772},"203":{"tf":1.7320508075688772},"212":{"tf":1.0},"214":{"tf":1.0},"221":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"197":{"tf":1.0},"199":{"tf":1.0},"203":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"104":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"222":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":11,"docs":{"101":{"tf":1.0},"116":{"tf":1.0},"130":{"tf":1.0},"158":{"tf":1.0},"187":{"tf":1.0},"194":{"tf":1.0},"201":{"tf":1.0},"210":{"tf":1.0},"212":{"tf":1.0},"229":{"tf":1.0},"98":{"tf":1.0}}}},"n":{"df":3,"docs":{"201":{"tf":1.4142135623730951},"212":{"tf":1.4142135623730951},"216":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"45":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"156":{"tf":1.0},"163":{"tf":1.0},"223":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"34":{"tf":1.4142135623730951},"64":{"tf":1.0},"7":{"tf":1.0}}}}},"r":{"(":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"(":{"_":{"df":1,"docs":{"226":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"218":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"226":{"tf":1.0}}}}}}},".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"163":{"tf":1.4142135623730951},"170":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"210":{"tf":1.7320508075688772},"221":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"167":{"tf":1.0},"174":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":3,"docs":{"146":{"tf":1.0},"147":{"tf":1.0},"212":{"tf":1.0}}}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"219":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"'":{"_":{"df":12,"docs":{"121":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"169":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"221":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"226":{"tf":1.0}}}}}}},"df":1,"docs":{"226":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"151":{"tf":1.4142135623730951},"169":{"tf":1.0}}},"y":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"151":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":24,"docs":{"121":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":1.4142135623730951},"153":{"tf":1.7320508075688772},"158":{"tf":1.0},"159":{"tf":1.7320508075688772},"160":{"tf":1.7320508075688772},"163":{"tf":2.23606797749979},"168":{"tf":1.0},"169":{"tf":2.0},"170":{"tf":2.23606797749979},"171":{"tf":1.0},"172":{"tf":2.0},"212":{"tf":1.7320508075688772},"213":{"tf":3.872983346207417},"214":{"tf":2.0},"218":{"tf":1.0},"219":{"tf":1.4142135623730951},"221":{"tf":2.0},"225":{"tf":1.0},"226":{"tf":3.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":30,"docs":{"123":{"tf":1.4142135623730951},"131":{"tf":1.0},"146":{"tf":2.0},"147":{"tf":1.0},"148":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.4142135623730951},"152":{"tf":2.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.0},"162":{"tf":1.0},"167":{"tf":2.449489742783178},"168":{"tf":1.0},"169":{"tf":2.23606797749979},"171":{"tf":1.4142135623730951},"172":{"tf":1.4142135623730951},"174":{"tf":1.4142135623730951},"209":{"tf":1.0},"210":{"tf":1.7320508075688772},"211":{"tf":2.449489742783178},"212":{"tf":1.4142135623730951},"213":{"tf":3.0},"214":{"tf":2.8284271247461903},"221":{"tf":1.0},"222":{"tf":1.0},"223":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":1.0},"87":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"167":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"163":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"221":{"tf":1.0},"223":{"tf":1.0},"226":{"tf":1.7320508075688772},"7":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"107":{"tf":1.0},"223":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"167":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"!":{"(":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"121":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"121":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":1,"docs":{"148":{"tf":1.0}}}},"df":2,"docs":{"119":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"0":{"df":3,"docs":{"186":{"tf":1.4142135623730951},"189":{"tf":1.4142135623730951},"190":{"tf":1.4142135623730951}}},"3":{"2":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}},"6":{"4":{":":{":":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"148":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"e":{"df":3,"docs":{"201":{"tf":1.0},"202":{"tf":1.4142135623730951},"204":{"tf":1.7320508075688772}}},"t":{"df":4,"docs":{"119":{"tf":1.0},"146":{"tf":1.0},"202":{"tf":1.0},"222":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"112":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":7,"docs":{"138":{"tf":1.0},"182":{"tf":1.0},"188":{"tf":1.0},"5":{"tf":1.4142135623730951},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"138":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"229":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"112":{"tf":1.0},"133":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"182":{"tf":1.0}}}}}},"s":{"df":37,"docs":{"0":{"tf":1.0},"105":{"tf":1.0},"107":{"tf":1.4142135623730951},"120":{"tf":1.0},"129":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"166":{"tf":1.7320508075688772},"167":{"tf":1.0},"17":{"tf":1.0},"174":{"tf":1.0},"18":{"tf":1.0},"186":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.0},"202":{"tf":1.4142135623730951},"212":{"tf":1.0},"213":{"tf":1.7320508075688772},"22":{"tf":1.0},"220":{"tf":1.0},"223":{"tf":1.4142135623730951},"23":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":2.0},"61":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.4142135623730951},"71":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"90":{"tf":1.4142135623730951},"93":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"159":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":3,"docs":{"146":{"tf":1.0},"154":{"tf":1.0},"99":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"179":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"144":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":8,"docs":{"0":{"tf":1.0},"121":{"tf":2.0},"176":{"tf":1.0},"209":{"tf":1.0},"7":{"tf":1.4142135623730951},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.4142135623730951}},"e":{"(":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"123":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"d":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"186":{"tf":1.0},"230":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":4,"docs":{"107":{"tf":1.0},"131":{"tf":1.0},"5":{"tf":1.0},"89":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"102":{"tf":1.0},"179":{"tf":1.0},"186":{"tf":1.0},"188":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":4,"docs":{"144":{"tf":1.0},"146":{"tf":1.0},"179":{"tf":1.0},"230":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"202":{"tf":1.0}}}}}},"f":{"df":1,"docs":{"179":{"tf":1.0}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":6,"docs":{"121":{"tf":1.4142135623730951},"129":{"tf":1.0},"57":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.7320508075688772},"70":{"tf":2.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":32,"docs":{"0":{"tf":1.0},"103":{"tf":2.0},"112":{"tf":2.0},"113":{"tf":3.872983346207417},"114":{"tf":2.0},"115":{"tf":1.4142135623730951},"116":{"tf":1.7320508075688772},"120":{"tf":1.0},"121":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":2.0},"131":{"tf":1.0},"133":{"tf":3.4641016151377544},"134":{"tf":1.0},"138":{"tf":3.605551275463989},"139":{"tf":2.23606797749979},"140":{"tf":2.23606797749979},"141":{"tf":2.23606797749979},"142":{"tf":1.0},"177":{"tf":1.4142135623730951},"179":{"tf":1.0},"186":{"tf":1.4142135623730951},"188":{"tf":1.0},"195":{"tf":1.0},"196":{"tf":1.0},"202":{"tf":1.4142135623730951},"227":{"tf":1.0},"24":{"tf":1.0},"56":{"tf":1.7320508075688772},"7":{"tf":2.0},"92":{"tf":1.0},"95":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"108":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":6,"docs":{"138":{"tf":1.0},"186":{"tf":1.4142135623730951},"221":{"tf":1.4142135623730951},"226":{"tf":1.7320508075688772},"54":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"124":{"tf":1.0},"149":{"tf":1.4142135623730951},"186":{"tf":1.0},"7":{"tf":1.0}}}},"d":{"df":24,"docs":{"100":{"tf":1.0},"113":{"tf":1.0},"123":{"tf":1.0},"129":{"tf":1.0},"137":{"tf":1.0},"140":{"tf":1.0},"145":{"tf":1.0},"152":{"tf":1.0},"159":{"tf":1.0},"161":{"tf":1.0},"185":{"tf":1.0},"186":{"tf":1.4142135623730951},"187":{"tf":1.0},"188":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.4142135623730951},"191":{"tf":1.0},"203":{"tf":1.0},"210":{"tf":1.0},"225":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.4142135623730951},"91":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":5,"docs":{"144":{"tf":1.0},"145":{"tf":1.0},"208":{"tf":1.0},"222":{"tf":1.0},"230":{"tf":1.4142135623730951}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"138":{"tf":1.0},"202":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":34,"docs":{"102":{"tf":1.4142135623730951},"108":{"tf":1.0},"109":{"tf":1.0},"113":{"tf":1.0},"119":{"tf":1.0},"121":{"tf":1.0},"123":{"tf":1.0},"129":{"tf":1.4142135623730951},"131":{"tf":1.0},"136":{"tf":1.0},"137":{"tf":2.0},"152":{"tf":1.0},"167":{"tf":1.0},"174":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.4142135623730951},"182":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"197":{"tf":1.0},"200":{"tf":1.0},"201":{"tf":1.0},"208":{"tf":1.0},"210":{"tf":1.0},"214":{"tf":1.0},"219":{"tf":1.0},"221":{"tf":1.4142135623730951},"222":{"tf":1.0},"223":{"tf":1.0},"225":{"tf":1.0},"229":{"tf":1.0},"5":{"tf":1.0},"93":{"tf":1.0},"98":{"tf":1.4142135623730951}}}}},"t":{"df":5,"docs":{"111":{"tf":1.0},"129":{"tf":1.0},"132":{"tf":1.0},"186":{"tf":1.0},"5":{"tf":1.0}}},"x":{"df":22,"docs":{"100":{"tf":1.4142135623730951},"103":{"tf":1.0},"105":{"tf":1.0},"114":{"tf":1.7320508075688772},"138":{"tf":1.7320508075688772},"139":{"tf":1.0},"141":{"tf":1.7320508075688772},"146":{"tf":1.0},"147":{"tf":2.23606797749979},"148":{"tf":1.4142135623730951},"166":{"tf":1.0},"177":{"tf":1.4142135623730951},"181":{"tf":1.4142135623730951},"182":{"tf":1.4142135623730951},"186":{"tf":2.0},"202":{"tf":1.4142135623730951},"203":{"tf":1.0},"5":{"tf":1.7320508075688772},"85":{"tf":1.0},"86":{"tf":1.4142135623730951},"91":{"tf":1.0},"93":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"/":{"a":{"d":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"185":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"186":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"112":{"tf":1.0},"133":{"tf":1.0},"7":{"tf":1.4142135623730951}}},"t":{"df":3,"docs":{"211":{"tf":1.0},"214":{"tf":1.7320508075688772},"227":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"210":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"1":{"9":{"9":{"5":{"df":1,"docs":{"230":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"176":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"t":{"df":3,"docs":{"104":{"tf":1.0},"125":{"tf":1.0},"128":{"tf":1.0}}}},"n":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"119":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":32,"docs":{"107":{"tf":1.0},"113":{"tf":3.1622776601683795},"119":{"tf":1.4142135623730951},"120":{"tf":1.7320508075688772},"121":{"tf":2.0},"129":{"tf":1.0},"138":{"tf":3.605551275463989},"146":{"tf":1.0},"147":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":1.4142135623730951},"153":{"tf":1.0},"154":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"169":{"tf":1.0},"170":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"173":{"tf":1.0},"212":{"tf":1.0},"214":{"tf":1.0},"220":{"tf":1.4142135623730951},"221":{"tf":1.4142135623730951},"223":{"tf":1.0},"226":{"tf":1.4142135623730951},"5":{"tf":1.0},"55":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{":":{":":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"120":{"tf":1.0}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"(":{"_":{"df":1,"docs":{"120":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"120":{"tf":1.0}}}}},"df":0,"docs":{}},"<":{"'":{"_":{"df":2,"docs":{"119":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"120":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"113":{"tf":1.4142135623730951},"138":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":3,"docs":{"131":{"tf":1.0},"201":{"tf":1.0},"87":{"tf":1.0}}}}},"df":2,"docs":{"113":{"tf":1.0},"138":{"tf":1.0}},"l":{"d":{"df":1,"docs":{"148":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"129":{"tf":1.0}}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"203":{"tf":1.0}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":46,"docs":{"102":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":1.7320508075688772},"115":{"tf":1.0},"116":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.4142135623730951},"129":{"tf":1.0},"133":{"tf":2.0},"138":{"tf":1.0},"144":{"tf":1.4142135623730951},"145":{"tf":1.4142135623730951},"152":{"tf":1.0},"158":{"tf":1.0},"161":{"tf":1.0},"167":{"tf":2.0},"168":{"tf":1.0},"169":{"tf":1.0},"174":{"tf":1.0},"176":{"tf":1.4142135623730951},"177":{"tf":1.0},"178":{"tf":1.4142135623730951},"179":{"tf":1.0},"180":{"tf":1.0},"182":{"tf":1.0},"186":{"tf":1.4142135623730951},"193":{"tf":1.0},"201":{"tf":1.4142135623730951},"202":{"tf":1.4142135623730951},"203":{"tf":1.7320508075688772},"21":{"tf":1.0},"210":{"tf":1.4142135623730951},"212":{"tf":1.0},"213":{"tf":1.4142135623730951},"214":{"tf":1.7320508075688772},"217":{"tf":1.4142135623730951},"218":{"tf":1.0},"221":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":1.4142135623730951},"27":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}}},"o":{"!":{"(":{"\"":{"b":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"167":{"tf":1.0},"174":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"113":{"tf":1.4142135623730951},"138":{"tf":2.0}}}}}}},"df":0,"docs":{},"x":{"df":1,"docs":{"154":{"tf":1.0}}}},".":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}}},"_":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"113":{"tf":1.4142135623730951},"140":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":9,"docs":{"111":{"tf":1.0},"116":{"tf":1.7320508075688772},"119":{"tf":1.0},"120":{"tf":1.0},"124":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":2.0},"138":{"tf":1.4142135623730951},"144":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"167":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"d":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"113":{"tf":1.4142135623730951},"138":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"113":{"tf":1.0},"138":{"tf":1.0}}},"df":18,"docs":{"109":{"tf":1.0},"113":{"tf":1.4142135623730951},"116":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.7320508075688772},"124":{"tf":1.0},"132":{"tf":1.0},"138":{"tf":3.3166247903554},"144":{"tf":1.0},"161":{"tf":1.4142135623730951},"167":{"tf":1.4142135623730951},"174":{"tf":1.4142135623730951},"213":{"tf":1.0},"214":{"tf":1.4142135623730951},"223":{"tf":1.4142135623730951},"27":{"tf":1.0},"41":{"tf":1.0},"7":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"116":{"tf":1.0},"119":{"tf":1.7320508075688772},"120":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"b":{"df":0,"docs":{},"i":{"d":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"c":{"df":3,"docs":{"108":{"tf":1.0},"177":{"tf":1.0},"192":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"167":{"tf":1.4142135623730951},"174":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"165":{"tf":1.0},"166":{"tf":1.0}}}}},"g":{"df":2,"docs":{"185":{"tf":1.0},"187":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"148":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"148":{"tf":1.0},"174":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"186":{"tf":1.0}}}}}}}},"k":{"df":3,"docs":{"102":{"tf":1.4142135623730951},"179":{"tf":1.0},"188":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"t":{"!":{"(":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"147":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"104":{"tf":1.4142135623730951},"125":{"tf":1.7320508075688772},"129":{"tf":1.0},"147":{"tf":1.0},"16":{"tf":2.0},"175":{"tf":1.0},"194":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"111":{"tf":1.0}}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"179":{"tf":1.0},"226":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"df":17,"docs":{"107":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"133":{"tf":1.0},"172":{"tf":1.0},"186":{"tf":1.0},"187":{"tf":1.0},"190":{"tf":1.0},"206":{"tf":1.0},"215":{"tf":1.0},"218":{"tf":1.4142135623730951},"220":{"tf":1.0},"226":{"tf":1.0},"5":{"tf":1.4142135623730951},"7":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":4,"docs":{"107":{"tf":1.0},"202":{"tf":1.7320508075688772},"204":{"tf":1.0},"5":{"tf":1.4142135623730951}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"138":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"230":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"s":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}},"df":5,"docs":{"107":{"tf":1.0},"131":{"tf":1.0},"5":{"tf":1.0},"85":{"tf":1.0},"89":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"223":{"tf":1.0},"229":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":3,"docs":{"130":{"tf":1.0},"167":{"tf":1.4142135623730951},"174":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":8,"docs":{"120":{"tf":1.0},"137":{"tf":1.0},"163":{"tf":1.0},"171":{"tf":1.0},"230":{"tf":1.0},"5":{"tf":1.0},"69":{"tf":1.4142135623730951},"84":{"tf":1.0}},"i":{"df":5,"docs":{"146":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"120":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":43,"docs":{"0":{"tf":1.0},"109":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"119":{"tf":2.0},"120":{"tf":1.4142135623730951},"124":{"tf":1.0},"130":{"tf":1.4142135623730951},"131":{"tf":1.7320508075688772},"132":{"tf":1.0},"133":{"tf":2.23606797749979},"134":{"tf":1.0},"135":{"tf":1.0},"138":{"tf":3.1622776601683795},"14":{"tf":1.0},"144":{"tf":1.4142135623730951},"146":{"tf":1.0},"147":{"tf":1.0},"148":{"tf":1.0},"15":{"tf":1.0},"154":{"tf":1.4142135623730951},"159":{"tf":1.0},"161":{"tf":1.0},"167":{"tf":1.7320508075688772},"172":{"tf":1.0},"174":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"212":{"tf":1.0},"22":{"tf":1.0},"226":{"tf":1.7320508075688772},"23":{"tf":1.0},"38":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"113":{"tf":1.0},"137":{"tf":1.0},"156":{"tf":1.0},"164":{"tf":1.0},"173":{"tf":1.0},"223":{"tf":1.0},"7":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"152":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":7,"docs":{"202":{"tf":1.0},"221":{"tf":1.0},"223":{"tf":1.4142135623730951},"226":{"tf":2.0},"5":{"tf":1.0},"50":{"tf":1.7320508075688772},"7":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":31,"docs":{"105":{"tf":1.0},"107":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":2.0},"114":{"tf":1.0},"116":{"tf":1.0},"122":{"tf":1.4142135623730951},"129":{"tf":2.0},"138":{"tf":2.23606797749979},"139":{"tf":1.0},"140":{"tf":1.4142135623730951},"141":{"tf":1.4142135623730951},"144":{"tf":1.4142135623730951},"145":{"tf":1.0},"147":{"tf":1.0},"148":{"tf":1.0},"155":{"tf":1.0},"161":{"tf":2.0},"165":{"tf":1.0},"166":{"tf":1.4142135623730951},"167":{"tf":1.0},"171":{"tf":1.0},"174":{"tf":1.4142135623730951},"176":{"tf":1.0},"194":{"tf":1.0},"196":{"tf":1.4142135623730951},"223":{"tf":1.4142135623730951},"226":{"tf":1.4142135623730951},"5":{"tf":1.0},"6":{"tf":1.0},"90":{"tf":1.0}},"i":{"c":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"161":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"161":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":9,"docs":{"109":{"tf":1.0},"111":{"tf":1.4142135623730951},"113":{"tf":1.0},"171":{"tf":1.0},"176":{"tf":1.0},"200":{"tf":1.0},"203":{"tf":1.4142135623730951},"204":{"tf":1.0},"98":{"tf":1.4142135623730951}}}},"i":{"b":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{},"t":{"@":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{":":{"<":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"102":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":17,"docs":{"102":{"tf":2.449489742783178},"104":{"tf":1.0},"105":{"tf":1.0},"133":{"tf":2.8284271247461903},"177":{"tf":2.8284271247461903},"178":{"tf":1.7320508075688772},"179":{"tf":2.23606797749979},"180":{"tf":1.4142135623730951},"182":{"tf":3.3166247903554},"183":{"tf":2.0},"186":{"tf":1.0},"188":{"tf":2.449489742783178},"189":{"tf":2.23606797749979},"190":{"tf":1.4142135623730951},"191":{"tf":1.7320508075688772},"192":{"tf":1.0},"203":{"tf":1.0}},"h":{"df":0,"docs":{},"u":{"b":{"df":3,"docs":{"182":{"tf":1.7320508075688772},"43":{"tf":1.0},"94":{"tf":2.0}}},"df":0,"docs":{}}},"l":{"a":{"b":{"df":2,"docs":{"43":{"tf":1.0},"95":{"tf":2.23606797749979}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":14,"docs":{"100":{"tf":1.4142135623730951},"119":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.0},"151":{"tf":1.0},"169":{"tf":1.0},"202":{"tf":1.0},"213":{"tf":2.0},"84":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}},"n":{"df":10,"docs":{"151":{"tf":1.0},"152":{"tf":1.0},"160":{"tf":1.0},"167":{"tf":1.4142135623730951},"174":{"tf":1.0},"214":{"tf":1.0},"223":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":1.4142135623730951},"5":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"152":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"107":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"o":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"210":{"tf":1.4142135623730951}}}},"df":10,"docs":{"1":{"tf":1.0},"127":{"tf":1.0},"130":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.4142135623730951},"164":{"tf":1.0},"167":{"tf":1.0},"173":{"tf":1.0},"177":{"tf":1.0},"214":{"tf":1.0}},"o":{"d":{"df":11,"docs":{"100":{"tf":1.0},"118":{"tf":1.0},"122":{"tf":1.0},"132":{"tf":1.0},"174":{"tf":1.0},"186":{"tf":1.4142135623730951},"200":{"tf":1.0},"226":{"tf":1.0},"229":{"tf":2.0},"230":{"tf":1.0},"85":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"2":{"df":1,"docs":{"43":{"tf":1.0}}},"3":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"d":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"138":{"tf":1.0},"146":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"144":{"tf":1.0},"145":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"119":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"229":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"225":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"p":{"df":3,"docs":{"186":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":22,"docs":{"112":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.4142135623730951},"131":{"tf":1.4142135623730951},"133":{"tf":1.7320508075688772},"134":{"tf":1.0},"202":{"tf":1.4142135623730951},"214":{"tf":1.0},"227":{"tf":1.0},"229":{"tf":2.23606797749979},"230":{"tf":1.0},"5":{"tf":4.795831523312719},"7":{"tf":1.7320508075688772},"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.7320508075688772},"90":{"tf":2.6457513110645907},"91":{"tf":1.7320508075688772},"92":{"tf":1.0}}}},"w":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"200":{"tf":1.0}}}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":4,"docs":{"100":{"tf":1.0},"138":{"tf":1.0},"176":{"tf":1.0},"202":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"135":{"tf":1.0}}}}},"i":{"d":{"df":14,"docs":{"107":{"tf":1.0},"109":{"tf":1.0},"119":{"tf":1.0},"127":{"tf":1.0},"130":{"tf":1.4142135623730951},"158":{"tf":1.0},"168":{"tf":1.0},"176":{"tf":1.0},"194":{"tf":1.0},"196":{"tf":1.0},"203":{"tf":1.0},"212":{"tf":1.4142135623730951},"3":{"tf":1.0},"99":{"tf":1.4142135623730951}},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"106":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"111":{"tf":1.0},"116":{"tf":1.0},"125":{"tf":1.0},"132":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"h":{"a":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"100":{"tf":1.0},"101":{"tf":2.0},"108":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"176":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"117":{"tf":1.0},"135":{"tf":1.0},"158":{"tf":1.0},"203":{"tf":1.0},"221":{"tf":1.0}},"l":{"df":6,"docs":{"111":{"tf":1.0},"131":{"tf":1.0},"200":{"tf":1.0},"203":{"tf":1.0},"225":{"tf":1.0},"230":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"192":{"tf":1.0},"202":{"tf":1.0}}}}}},"r":{"d":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"177":{"tf":1.0}}},"df":0,"docs":{}}},"df":8,"docs":{"108":{"tf":1.0},"189":{"tf":1.0},"200":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.0},"210":{"tf":1.7320508075688772},"214":{"tf":1.0},"223":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":4,"docs":{"17":{"tf":1.4142135623730951},"182":{"tf":1.0},"186":{"tf":1.0},"188":{"tf":1.0}}},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"214":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":3,"docs":{"195":{"tf":1.0},"208":{"tf":1.0},"211":{"tf":1.0}},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"138":{"tf":1.0},"225":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":5,"docs":{"124":{"tf":1.0},"186":{"tf":1.0},"188":{"tf":1.4142135623730951},"189":{"tf":1.0},"190":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"186":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"228":{"tf":1.0}}}}}},"p":{"df":1,"docs":{"72":{"tf":1.0}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"224":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"97":{"tf":1.0}}}},"p":{"df":17,"docs":{"0":{"tf":1.0},"104":{"tf":1.0},"119":{"tf":1.0},"123":{"tf":1.0},"130":{"tf":1.0},"137":{"tf":1.0},"146":{"tf":2.0},"147":{"tf":1.0},"148":{"tf":3.0},"184":{"tf":1.0},"186":{"tf":1.0},"203":{"tf":1.7320508075688772},"229":{"tf":2.23606797749979},"230":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"130":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"155":{"tf":1.0}}},"df":22,"docs":{"109":{"tf":1.0},"116":{"tf":1.4142135623730951},"119":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"130":{"tf":1.4142135623730951},"133":{"tf":1.0},"134":{"tf":1.0},"139":{"tf":1.0},"154":{"tf":1.0},"169":{"tf":1.0},"177":{"tf":1.0},"179":{"tf":1.0},"192":{"tf":1.0},"206":{"tf":1.0},"213":{"tf":1.0},"215":{"tf":1.0},"218":{"tf":1.4142135623730951},"220":{"tf":1.0},"41":{"tf":1.0},"7":{"tf":1.0},"97":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"130":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.7320508075688772}}}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"211":{"tf":1.4142135623730951},"214":{"tf":1.0}},"i":{"df":3,"docs":{"112":{"tf":1.0},"223":{"tf":1.0},"227":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"h":{"df":6,"docs":{"100":{"tf":1.0},"107":{"tf":1.0},"123":{"tf":1.0},"203":{"tf":1.0},"204":{"tf":1.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"100":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"204":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"146":{"tf":1.0}}}}}}}}},"r":{"'":{"df":1,"docs":{"223":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"<":{"'":{"_":{"df":2,"docs":{"163":{"tf":1.0},"170":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"163":{"tf":1.0},"170":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"154":{"tf":2.449489742783178}}}}},"df":0,"docs":{}},"df":15,"docs":{"107":{"tf":1.0},"109":{"tf":1.0},"118":{"tf":1.0},"123":{"tf":1.7320508075688772},"144":{"tf":1.0},"145":{"tf":1.0},"151":{"tf":1.0},"154":{"tf":1.0},"163":{"tf":1.0},"169":{"tf":1.0},"210":{"tf":2.0},"217":{"tf":1.0},"218":{"tf":1.0},"220":{"tf":1.4142135623730951},"222":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"177":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"202":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"35":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"u":{"df":1,"docs":{"100":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"104":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"94":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"3":{"0":{"0":{"0":{"df":1,"docs":{"196":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"<":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"182":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"102":{"tf":1.0},"178":{"tf":1.0},"183":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"106":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"229":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"147":{"tf":1.0},"223":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"161":{"tf":1.0}}}}}}}}}},"i":{"'":{"d":{"df":1,"docs":{"221":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":1,"docs":{"224":{"tf":1.0}}},"v":{"df":1,"docs":{"224":{"tf":1.0}}}},".":{"df":1,"docs":{"155":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"j":{"df":1,"docs":{"220":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"c":{"df":4,"docs":{"107":{"tf":1.0},"154":{"tf":1.0},"181":{"tf":1.0},"186":{"tf":1.4142135623730951}}},"d":{"df":5,"docs":{"100":{"tf":1.0},"145":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.7320508075688772},"172":{"tf":1.4142135623730951}},"e":{"a":{"df":5,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"186":{"tf":1.4142135623730951},"226":{"tf":1.4142135623730951},"229":{"tf":1.0}},"l":{"df":2,"docs":{"185":{"tf":1.0},"203":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"120":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":6,"docs":{"120":{"tf":1.4142135623730951},"163":{"tf":1.0},"213":{"tf":1.0},"26":{"tf":1.4142135623730951},"43":{"tf":2.0},"60":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":4,"docs":{"119":{"tf":1.0},"145":{"tf":1.0},"158":{"tf":1.0},"43":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"'":{"df":1,"docs":{"213":{"tf":1.0}}},"(":{"_":{"df":3,"docs":{"213":{"tf":2.8284271247461903},"221":{"tf":1.4142135623730951},"226":{"tf":1.7320508075688772}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"218":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"210":{"tf":1.4142135623730951},"221":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"_":{"df":1,"docs":{"226":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"226":{"tf":1.0}}}}}}},"df":1,"docs":{"226":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"210":{"tf":1.0},"213":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"_":{"df":1,"docs":{"226":{"tf":2.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"226":{"tf":1.0}}}}}}},"df":2,"docs":{"218":{"tf":1.0},"226":{"tf":1.0}}}}},"s":{"_":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":11,"docs":{"120":{"tf":1.0},"138":{"tf":1.0},"165":{"tf":1.0},"167":{"tf":1.7320508075688772},"174":{"tf":1.0},"21":{"tf":1.4142135623730951},"23":{"tf":1.0},"36":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"137":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"95":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"138":{"tf":1.0}}}}},"df":3,"docs":{"140":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"105":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"211":{"tf":1.0}}}},"l":{"<":{"'":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"x":{"df":7,"docs":{"121":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"170":{"tf":1.0},"173":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"164":{"tf":1.0},"173":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"164":{"tf":1.0},"173":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"164":{"tf":1.0},"173":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":2,"docs":{"164":{"tf":1.0},"173":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"!":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"129":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":19,"docs":{"113":{"tf":1.4142135623730951},"116":{"tf":1.0},"119":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951},"121":{"tf":1.0},"129":{"tf":2.449489742783178},"138":{"tf":1.4142135623730951},"152":{"tf":1.0},"153":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"162":{"tf":1.0},"164":{"tf":2.0},"169":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"212":{"tf":1.0},"220":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":37,"docs":{"113":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.7320508075688772},"120":{"tf":1.4142135623730951},"122":{"tf":1.4142135623730951},"123":{"tf":1.0},"126":{"tf":1.0},"129":{"tf":1.0},"134":{"tf":1.0},"136":{"tf":1.0},"138":{"tf":1.4142135623730951},"145":{"tf":1.4142135623730951},"146":{"tf":2.449489742783178},"149":{"tf":1.0},"155":{"tf":1.0},"157":{"tf":1.4142135623730951},"158":{"tf":1.0},"159":{"tf":1.7320508075688772},"160":{"tf":1.7320508075688772},"161":{"tf":2.6457513110645907},"164":{"tf":2.0},"168":{"tf":1.0},"169":{"tf":1.0},"172":{"tf":1.7320508075688772},"199":{"tf":1.0},"202":{"tf":2.23606797749979},"203":{"tf":1.7320508075688772},"211":{"tf":1.4142135623730951},"212":{"tf":1.0},"215":{"tf":1.7320508075688772},"218":{"tf":1.4142135623730951},"220":{"tf":2.8284271247461903},"221":{"tf":1.4142135623730951},"222":{"tf":2.23606797749979},"224":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":3.1622776601683795}},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"158":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"c":{"df":0,"docs":{},"x":{"df":4,"docs":{"158":{"tf":1.0},"159":{"tf":1.0},"161":{"tf":1.0},"172":{"tf":1.0}}}},"df":0,"docs":{}},"df":4,"docs":{"130":{"tf":1.0},"159":{"tf":1.0},"161":{"tf":1.0},"172":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"127":{"tf":1.0}}}}}}}}},"df":1,"docs":{"45":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"223":{"tf":1.4142135623730951}}}}}}},"df":3,"docs":{"138":{"tf":1.0},"148":{"tf":1.0},"5":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"<":{"'":{"_":{"df":2,"docs":{"164":{"tf":1.0},"173":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"164":{"tf":1.0}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":2,"docs":{"164":{"tf":1.0},"173":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":14,"docs":{"116":{"tf":1.4142135623730951},"118":{"tf":1.0},"132":{"tf":1.0},"143":{"tf":1.0},"154":{"tf":1.0},"175":{"tf":1.0},"201":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.0},"225":{"tf":1.0},"29":{"tf":2.0},"46":{"tf":1.7320508075688772},"5":{"tf":1.0},"82":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"165":{"tf":1.0},"174":{"tf":1.0},"223":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":13,"docs":{"0":{"tf":1.0},"124":{"tf":1.0},"150":{"tf":1.0},"186":{"tf":1.4142135623730951},"197":{"tf":1.0},"199":{"tf":1.4142135623730951},"202":{"tf":2.0},"203":{"tf":2.23606797749979},"210":{"tf":1.0},"226":{"tf":1.0},"5":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}}}}}},"n":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"134":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"(":{"c":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"167":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"174":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":2,"docs":{"130":{"tf":1.0},"167":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"(":{"#":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"226":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"229":{"tf":1.7320508075688772},"230":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.7320508075688772}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":22,"docs":{"0":{"tf":1.7320508075688772},"101":{"tf":1.0},"126":{"tf":1.0},"128":{"tf":1.0},"133":{"tf":1.4142135623730951},"146":{"tf":1.4142135623730951},"151":{"tf":1.0},"153":{"tf":1.0},"169":{"tf":1.0},"185":{"tf":1.0},"186":{"tf":1.7320508075688772},"190":{"tf":1.0},"202":{"tf":1.0},"228":{"tf":1.0},"229":{"tf":1.0},"27":{"tf":1.7320508075688772},"5":{"tf":1.7320508075688772},"56":{"tf":1.7320508075688772},"7":{"tf":1.0},"78":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}},"e":{"!":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"a":{"df":0,"docs":{},"t":{"!":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"!":{"(":{"\"":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":1,"docs":{"147":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"223":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"221":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"147":{"tf":1.0},"166":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"177":{"tf":1.0},"203":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"226":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"152":{"tf":1.0},"161":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"210":{"tf":1.0},"220":{"tf":1.0},"222":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"x":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"58":{"tf":1.0},"62":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"158":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"i":{"c":{"df":8,"docs":{"147":{"tf":1.0},"21":{"tf":1.0},"212":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"31":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"203":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"203":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":29,"docs":{"104":{"tf":1.0},"111":{"tf":1.0},"118":{"tf":1.4142135623730951},"119":{"tf":1.0},"131":{"tf":1.0},"138":{"tf":1.0},"143":{"tf":1.4142135623730951},"144":{"tf":1.4142135623730951},"145":{"tf":2.0},"146":{"tf":1.0},"148":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":1.0},"154":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.0},"166":{"tf":1.0},"169":{"tf":1.0},"176":{"tf":1.0},"196":{"tf":1.0},"211":{"tf":1.0},"218":{"tf":1.0},"220":{"tf":1.0},"223":{"tf":1.0},"226":{"tf":1.0},"230":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951},"92":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":22,"docs":{"175":{"tf":2.23606797749979},"176":{"tf":1.0},"177":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.0},"181":{"tf":1.0},"182":{"tf":1.0},"183":{"tf":1.0},"184":{"tf":1.0},"185":{"tf":1.0},"186":{"tf":1.0},"187":{"tf":1.0},"188":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.0},"193":{"tf":1.0},"194":{"tf":1.0},"195":{"tf":1.0},"196":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"116":{"tf":1.0},"121":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"152":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"210":{"tf":1.4142135623730951},"221":{"tf":1.0}}},"df":0,"docs":{}}}},"df":3,"docs":{"221":{"tf":1.4142135623730951},"223":{"tf":1.0},"226":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"115":{"tf":1.0},"142":{"tf":1.0}}}},"df":2,"docs":{"163":{"tf":1.0},"219":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":9,"docs":{"146":{"tf":1.0},"154":{"tf":1.4142135623730951},"166":{"tf":1.0},"167":{"tf":1.4142135623730951},"174":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.0},"65":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"145":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"211":{"tf":1.0},"224":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":9,"docs":{"1":{"tf":2.6457513110645907},"101":{"tf":1.0},"108":{"tf":3.0},"125":{"tf":1.4142135623730951},"195":{"tf":1.7320508075688772},"2":{"tf":1.7320508075688772},"3":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"94":{"tf":1.0}}},"n":{"c":{"df":7,"docs":{"131":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"167":{"tf":1.0},"179":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":18,"docs":{"112":{"tf":1.4142135623730951},"124":{"tf":1.0},"133":{"tf":1.4142135623730951},"134":{"tf":1.0},"147":{"tf":1.0},"148":{"tf":1.0},"163":{"tf":1.0},"177":{"tf":1.4142135623730951},"211":{"tf":1.4142135623730951},"214":{"tf":1.0},"226":{"tf":1.0},"30":{"tf":1.0},"45":{"tf":1.0},"63":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.0},"86":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"195":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"(":{"_":{"df":3,"docs":{"213":{"tf":1.0},"214":{"tf":1.0},"226":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"u":{"1":{"2":{"8":{"df":1,"docs":{"218":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"153":{"tf":1.0},"223":{"tf":1.0}},"e":{"df":0,"docs":{},"g":{"df":2,"docs":{"213":{"tf":1.0},"214":{"tf":1.7320508075688772}},"r":{"df":6,"docs":{"203":{"tf":1.4142135623730951},"222":{"tf":1.0},"93":{"tf":1.7320508075688772},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"j":{"df":1,"docs":{"104":{"tf":1.7320508075688772}}}}}},"n":{"d":{"df":3,"docs":{"103":{"tf":1.0},"214":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":2,"docs":{"5":{"tf":1.0},"90":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"86":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":13,"docs":{"100":{"tf":1.0},"113":{"tf":1.0},"140":{"tf":1.0},"152":{"tf":1.0},"161":{"tf":1.4142135623730951},"197":{"tf":1.0},"199":{"tf":1.0},"203":{"tf":1.7320508075688772},"229":{"tf":1.0},"230":{"tf":1.0},"7":{"tf":1.0},"92":{"tf":1.0},"97":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.7320508075688772}}}}},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"107":{"tf":1.4142135623730951},"123":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":10,"docs":{"107":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"130":{"tf":1.4142135623730951},"131":{"tf":1.4142135623730951},"201":{"tf":1.0},"203":{"tf":1.4142135623730951},"204":{"tf":1.7320508075688772},"210":{"tf":1.0},"36":{"tf":1.0}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"147":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"99":{"tf":1.7320508075688772}}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":6,"docs":{"158":{"tf":1.0},"202":{"tf":1.0},"209":{"tf":1.0},"217":{"tf":1.0},"223":{"tf":1.4142135623730951},"226":{"tf":1.4142135623730951}},"t":{"df":2,"docs":{"0":{"tf":1.0},"99":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"99":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"35":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"174":{"tf":1.0}}}},"o":{"c":{"df":2,"docs":{"144":{"tf":1.0},"162":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":1,"docs":{"145":{"tf":1.0}}},"l":{"df":0,"docs":{},"v":{"df":3,"docs":{"131":{"tf":1.0},"177":{"tf":1.0},"31":{"tf":1.0}}}}}}},"o":{"df":1,"docs":{"43":{"tf":1.0}}},"p":{"df":0,"docs":{},"v":{"4":{"df":1,"docs":{"43":{"tf":1.0}}},"6":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":1,"docs":{"99":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"202":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"186":{"tf":1.4142135623730951}}}}}}}},"s":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"152":{"tf":1.0}}}}}}},"df":1,"docs":{"152":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":1,"docs":{"152":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"120":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"120":{"tf":1.0}}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"220":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"(":{"c":{"df":0,"docs":{},"x":{"df":2,"docs":{"163":{"tf":1.0},"172":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"172":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"(":{"c":{"df":0,"docs":{},"x":{"df":3,"docs":{"164":{"tf":1.0},"171":{"tf":1.0},"173":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"130":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"(":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"171":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"171":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"<":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"220":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":1,"docs":{"220":{"tf":1.0}}}},"df":4,"docs":{"217":{"tf":1.7320508075688772},"220":{"tf":2.449489742783178},"222":{"tf":1.7320508075688772},"226":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"'":{"df":0,"docs":{},"t":{"df":4,"docs":{"124":{"tf":1.0},"214":{"tf":1.0},"219":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":17,"docs":{"0":{"tf":1.0},"134":{"tf":1.0},"137":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"147":{"tf":1.0},"166":{"tf":1.0},"186":{"tf":1.0},"200":{"tf":1.0},"201":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":2.23606797749979},"204":{"tf":2.8284271247461903},"223":{"tf":1.0},"228":{"tf":1.0},"229":{"tf":2.449489742783178},"5":{"tf":1.4142135623730951}},"e":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"130":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"t":{"'":{"df":18,"docs":{"100":{"tf":1.4142135623730951},"123":{"tf":1.0},"163":{"tf":1.0},"177":{"tf":1.0},"185":{"tf":1.0},"186":{"tf":1.4142135623730951},"20":{"tf":1.0},"203":{"tf":1.0},"210":{"tf":1.4142135623730951},"211":{"tf":1.4142135623730951},"212":{"tf":1.0},"214":{"tf":1.0},"218":{"tf":1.0},"221":{"tf":1.4142135623730951},"229":{"tf":1.0},"230":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"'":{"df":2,"docs":{"148":{"tf":1.0},"27":{"tf":1.4142135623730951}}},"df":20,"docs":{"122":{"tf":1.0},"123":{"tf":1.0},"131":{"tf":1.0},"148":{"tf":1.0},"153":{"tf":1.0},"156":{"tf":1.0},"157":{"tf":1.4142135623730951},"158":{"tf":1.7320508075688772},"159":{"tf":2.23606797749979},"160":{"tf":1.7320508075688772},"164":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"171":{"tf":2.23606797749979},"172":{"tf":2.6457513110645907},"173":{"tf":1.0},"208":{"tf":1.0},"27":{"tf":1.0},"37":{"tf":1.7320508075688772},"61":{"tf":2.0}}},"r":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"v":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"160":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":6,"docs":{"113":{"tf":1.0},"137":{"tf":1.4142135623730951},"158":{"tf":1.0},"163":{"tf":1.0},"172":{"tf":1.0},"45":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":7,"docs":{"120":{"tf":1.0},"121":{"tf":1.0},"129":{"tf":1.0},"223":{"tf":1.4142135623730951},"226":{"tf":1.0},"5":{"tf":1.0},"90":{"tf":1.0}}}}}}}},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"26":{"tf":1.0}},"o":{"b":{"df":3,"docs":{"88":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"203":{"tf":1.7320508075688772},"228":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"131":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":3,"docs":{"151":{"tf":1.0},"169":{"tf":1.0},"99":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"181":{"tf":1.0},"91":{"tf":1.0}}}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":9,"docs":{"113":{"tf":1.0},"134":{"tf":1.0},"138":{"tf":1.0},"174":{"tf":1.0},"176":{"tf":1.0},"186":{"tf":1.0},"228":{"tf":1.0},"229":{"tf":1.0},"5":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"120":{"tf":1.0}}}},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}}}}}},"i":{"b":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{},"n":{"d":{"df":8,"docs":{"129":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.7320508075688772},"161":{"tf":1.0},"162":{"tf":1.0},"169":{"tf":1.0},"210":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":10,"docs":{"144":{"tf":1.4142135623730951},"147":{"tf":1.0},"148":{"tf":1.4142135623730951},"154":{"tf":1.0},"164":{"tf":1.0},"203":{"tf":1.0},"212":{"tf":1.0},"223":{"tf":1.7320508075688772},"225":{"tf":1.0},"89":{"tf":1.0}},"n":{"df":3,"docs":{"203":{"tf":1.0},"211":{"tf":1.0},"223":{"tf":1.0}}}}}}},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":5,"docs":{"119":{"tf":1.0},"138":{"tf":1.0},"186":{"tf":1.7320508075688772},"228":{"tf":1.4142135623730951},"229":{"tf":1.7320508075688772}}}}},"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"130":{"tf":1.0},"200":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"181":{"tf":1.0},"183":{"tf":1.0}}},"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"#":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"106":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"229":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"122":{"tf":1.0}}}}}},"/":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"179":{"tf":1.0},"183":{"tf":1.0}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":17,"docs":{"102":{"tf":1.4142135623730951},"160":{"tf":1.0},"175":{"tf":1.4142135623730951},"176":{"tf":2.449489742783178},"177":{"tf":1.4142135623730951},"178":{"tf":1.4142135623730951},"179":{"tf":2.449489742783178},"180":{"tf":2.449489742783178},"183":{"tf":1.0},"186":{"tf":1.0},"188":{"tf":1.4142135623730951},"190":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.0},"203":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.0}}}}}}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}}}}}},"df":4,"docs":{"157":{"tf":1.0},"159":{"tf":1.4142135623730951},"171":{"tf":1.4142135623730951},"172":{"tf":2.23606797749979}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{":":{":":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"171":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"a":{"df":0,"docs":{},"g":{"df":12,"docs":{"0":{"tf":1.0},"146":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"200":{"tf":1.0},"209":{"tf":1.0},"211":{"tf":1.4142135623730951},"226":{"tf":2.23606797749979},"5":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.4142135623730951}},"e":{"'":{"df":1,"docs":{"99":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"52":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951}},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"50":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"k":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"b":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":2,"docs":{"34":{"tf":1.0},"63":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"r":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"116":{"tf":1.0},"121":{"tf":1.0},"171":{"tf":1.0},"188":{"tf":1.0},"213":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"145":{"tf":1.0},"159":{"tf":1.0}}},".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"151":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"/":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"121":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"151":{"tf":1.0},"169":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"<":{"'":{"_":{"df":8,"docs":{"152":{"tf":1.0},"153":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"169":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0}}},"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"x":{"df":7,"docs":{"121":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"170":{"tf":1.0},"173":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":7,"docs":{"145":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.7320508075688772},"155":{"tf":1.0},"158":{"tf":1.0},"167":{"tf":1.0},"169":{"tf":1.0}}}}}}}}},"df":3,"docs":{"133":{"tf":1.0},"135":{"tf":1.4142135623730951},"146":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"<":{"'":{"_":{"df":8,"docs":{"152":{"tf":1.0},"153":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"169":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0}}},"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"x":{"df":7,"docs":{"121":{"tf":1.0},"146":{"tf":1.4142135623730951},"147":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"170":{"tf":1.0},"173":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":14,"docs":{"118":{"tf":1.7320508075688772},"130":{"tf":1.4142135623730951},"143":{"tf":1.4142135623730951},"144":{"tf":1.0},"145":{"tf":3.0},"146":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.4142135623730951},"167":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"222":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"r":{"df":9,"docs":{"111":{"tf":1.0},"119":{"tf":1.0},"121":{"tf":1.0},"138":{"tf":1.0},"141":{"tf":1.0},"146":{"tf":1.0},"201":{"tf":1.0},"212":{"tf":1.0},"221":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":6,"docs":{"102":{"tf":1.4142135623730951},"176":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.0},"94":{"tf":1.4142135623730951},"95":{"tf":1.0}}}},"x":{"df":1,"docs":{"43":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"154":{"tf":1.0}}}}}},"y":{"df":1,"docs":{"199":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"137":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":5,"docs":{"134":{"tf":1.0},"141":{"tf":1.0},"202":{"tf":1.4142135623730951},"221":{"tf":1.0},"226":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"230":{"tf":1.0}}}},"v":{"df":1,"docs":{"186":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{".":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"167":{"tf":1.0},"174":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":4,"docs":{"167":{"tf":1.0},"175":{"tf":1.0},"223":{"tf":1.0},"93":{"tf":1.0}}}},"g":{"a":{"c":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"41":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"118":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.0}}}},"t":{"'":{"df":6,"docs":{"113":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.4142135623730951},"133":{"tf":1.0},"152":{"tf":1.0},"161":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":18,"docs":{"0":{"tf":1.7320508075688772},"100":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"116":{"tf":1.0},"123":{"tf":1.0},"127":{"tf":1.0},"144":{"tf":1.4142135623730951},"145":{"tf":1.4142135623730951},"154":{"tf":1.0},"166":{"tf":1.0},"196":{"tf":1.0},"202":{"tf":1.0},"212":{"tf":1.4142135623730951},"216":{"tf":1.4142135623730951},"5":{"tf":2.0},"7":{"tf":1.0},"84":{"tf":1.0},"99":{"tf":1.4142135623730951}}},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"137":{"tf":1.0}}}},"df":0,"docs":{}}}},"x":{"df":2,"docs":{"144":{"tf":1.0},"99":{"tf":1.0}}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":1,"docs":{"129":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"227":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"228":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"154":{"tf":1.0},"161":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":7,"docs":{"145":{"tf":1.0},"177":{"tf":1.4142135623730951},"211":{"tf":1.0},"221":{"tf":1.0},"63":{"tf":1.4142135623730951},"7":{"tf":1.0},"75":{"tf":1.7320508075688772}}}}},"n":{"df":0,"docs":{},"e":{"df":13,"docs":{"116":{"tf":1.0},"138":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":2.0},"174":{"tf":1.0},"177":{"tf":1.0},"193":{"tf":1.4142135623730951},"202":{"tf":1.0},"5":{"tf":1.4142135623730951},"7":{"tf":1.0},"74":{"tf":1.7320508075688772}}},"k":{"df":6,"docs":{"108":{"tf":1.0},"130":{"tf":1.0},"156":{"tf":1.7320508075688772},"168":{"tf":1.0},"186":{"tf":1.7320508075688772},"7":{"tf":1.0}},"e":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"t":{"'":{"df":3,"docs":{"109":{"tf":1.0},"121":{"tf":1.7320508075688772},"146":{"tf":1.0}}},"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":5,"docs":{"129":{"tf":1.7320508075688772},"134":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}},"e":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"139":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"101":{"tf":1.0},"105":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"df":168,"docs":{"0":{"tf":4.0},"10":{"tf":2.0},"100":{"tf":2.6457513110645907},"101":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.7320508075688772},"105":{"tf":1.4142135623730951},"109":{"tf":4.242640687119285},"11":{"tf":1.4142135623730951},"110":{"tf":1.0},"111":{"tf":2.449489742783178},"112":{"tf":3.4641016151377544},"113":{"tf":3.3166247903554},"114":{"tf":1.7320508075688772},"115":{"tf":1.7320508075688772},"116":{"tf":4.0},"117":{"tf":3.4641016151377544},"118":{"tf":2.6457513110645907},"119":{"tf":3.1622776601683795},"12":{"tf":1.4142135623730951},"120":{"tf":3.0},"121":{"tf":3.3166247903554},"122":{"tf":2.6457513110645907},"123":{"tf":2.0},"124":{"tf":3.3166247903554},"125":{"tf":1.0},"126":{"tf":1.4142135623730951},"127":{"tf":3.0},"128":{"tf":1.7320508075688772},"129":{"tf":3.872983346207417},"13":{"tf":1.7320508075688772},"130":{"tf":2.6457513110645907},"131":{"tf":4.0},"132":{"tf":2.8284271247461903},"133":{"tf":4.795831523312719},"134":{"tf":2.8284271247461903},"135":{"tf":3.1622776601683795},"136":{"tf":1.4142135623730951},"137":{"tf":2.6457513110645907},"138":{"tf":3.7416573867739413},"139":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"140":{"tf":2.8284271247461903},"141":{"tf":1.7320508075688772},"142":{"tf":1.0},"143":{"tf":2.0},"144":{"tf":3.3166247903554},"145":{"tf":2.6457513110645907},"146":{"tf":5.477225575051661},"147":{"tf":2.8284271247461903},"148":{"tf":1.7320508075688772},"149":{"tf":2.0},"15":{"tf":1.4142135623730951},"150":{"tf":1.4142135623730951},"151":{"tf":1.0},"157":{"tf":1.0},"16":{"tf":1.4142135623730951},"161":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.0},"166":{"tf":2.23606797749979},"167":{"tf":2.0},"168":{"tf":1.7320508075688772},"169":{"tf":1.0},"17":{"tf":1.4142135623730951},"174":{"tf":2.449489742783178},"18":{"tf":1.4142135623730951},"181":{"tf":1.0},"186":{"tf":2.23606797749979},"19":{"tf":1.4142135623730951},"197":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"202":{"tf":3.605551275463989},"203":{"tf":2.6457513110645907},"204":{"tf":1.0},"209":{"tf":1.0},"21":{"tf":1.4142135623730951},"210":{"tf":3.1622776601683795},"211":{"tf":1.0},"212":{"tf":1.0},"214":{"tf":2.449489742783178},"215":{"tf":1.7320508075688772},"22":{"tf":1.4142135623730951},"220":{"tf":1.0},"221":{"tf":2.23606797749979},"222":{"tf":2.449489742783178},"223":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":3.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"35":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"37":{"tf":1.7320508075688772},"38":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"41":{"tf":1.7320508075688772},"42":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.7320508075688772},"48":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"5":{"tf":5.477225575051661},"50":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772},"54":{"tf":1.7320508075688772},"55":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"58":{"tf":1.7320508075688772},"59":{"tf":1.7320508075688772},"60":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"64":{"tf":1.7320508075688772},"65":{"tf":1.7320508075688772},"66":{"tf":1.7320508075688772},"67":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"7":{"tf":5.0990195135927845},"70":{"tf":1.7320508075688772},"71":{"tf":2.449489742783178},"72":{"tf":1.7320508075688772},"73":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"77":{"tf":1.7320508075688772},"78":{"tf":2.23606797749979},"79":{"tf":1.4142135623730951},"8":{"tf":2.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":3.4641016151377544},"85":{"tf":2.449489742783178},"86":{"tf":3.1622776601683795},"87":{"tf":2.0},"88":{"tf":1.7320508075688772},"89":{"tf":2.23606797749979},"9":{"tf":1.4142135623730951},"90":{"tf":2.0},"91":{"tf":2.6457513110645907},"92":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"95":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"224":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"146":{"tf":1.0},"147":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"121":{"tf":1.4142135623730951},"146":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"202":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":34,"docs":{"104":{"tf":1.0},"107":{"tf":1.4142135623730951},"113":{"tf":1.0},"116":{"tf":1.0},"121":{"tf":1.0},"124":{"tf":1.0},"129":{"tf":1.0},"133":{"tf":1.0},"138":{"tf":1.0},"172":{"tf":1.0},"203":{"tf":1.4142135623730951},"204":{"tf":1.0},"208":{"tf":1.0},"21":{"tf":1.4142135623730951},"226":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":2.0},"46":{"tf":1.0},"5":{"tf":1.4142135623730951},"51":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.0},"84":{"tf":1.0}}}},"t":{"(":{"!":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"_":{"df":1,"docs":{"226":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"_":{"#":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"214":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},")":{"*":{"#":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"214":{"tf":1.0}}}}}},"df":0,"docs":{}},"+":{"#":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"225":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"{":{"1":{"0":{"df":1,"docs":{"213":{"tf":1.0}}},"df":0,"docs":{}},"5":{",":{"1":{"0":{"df":1,"docs":{"213":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":3,"docs":{"213":{"tf":1.4142135623730951},"219":{"tf":1.0},"225":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"218":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"_":{")":{")":{"df":0,"docs":{},"{":{"1":{"0":{"df":1,"docs":{"213":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"213":{"tf":1.7320508075688772},"219":{"tf":1.0}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":3,"docs":{"212":{"tf":1.4142135623730951},"213":{"tf":1.4142135623730951},"226":{"tf":1.4142135623730951}},"e":{")":{")":{"df":0,"docs":{},"{":{"2":{"df":1,"docs":{"226":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"213":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"(":{"'":{"df":0,"docs":{},"x":{"'":{")":{")":{"df":0,"docs":{},"{":{"2":{"df":1,"docs":{"213":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"213":{"tf":1.0}}}},"_":{"#":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"213":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{")":{"#":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{")":{"#":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"214":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},")":{"#":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"213":{"tf":1.0}}}}}},")":{"#":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"213":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"_":{"#":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"213":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},")":{")":{"#":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"213":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"213":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"210":{"tf":1.0}}},"df":0,"docs":{}}}},":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"220":{"tf":1.0}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"220":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"220":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":6,"docs":{"213":{"tf":2.23606797749979},"214":{"tf":1.0},"218":{"tf":1.0},"219":{"tf":2.0},"220":{"tf":1.4142135623730951},"226":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":8,"docs":{"210":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":4.123105625617661},"214":{"tf":2.6457513110645907},"225":{"tf":1.4142135623730951},"226":{"tf":1.7320508075688772},"53":{"tf":1.7320508075688772},"78":{"tf":1.4142135623730951}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"131":{"tf":1.0}}}}},"l":{"df":2,"docs":{"138":{"tf":1.7320508075688772},"147":{"tf":1.0}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":13,"docs":{"115":{"tf":1.4142135623730951},"116":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"142":{"tf":1.0},"177":{"tf":1.0},"178":{"tf":1.4142135623730951},"179":{"tf":1.0},"188":{"tf":1.0},"195":{"tf":1.4142135623730951},"196":{"tf":1.0},"86":{"tf":1.0},"96":{"tf":1.0}}},"t":{"df":2,"docs":{"109":{"tf":1.0},"112":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":4,"docs":{"105":{"tf":1.4142135623730951},"186":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0}},"i":{"c":{"df":10,"docs":{"109":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.7320508075688772},"136":{"tf":1.0},"138":{"tf":1.7320508075688772},"143":{"tf":1.0},"146":{"tf":1.7320508075688772},"149":{"tf":1.0},"165":{"tf":1.0},"211":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"197":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"203":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":28,"docs":{"101":{"tf":1.0},"111":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"134":{"tf":1.0},"138":{"tf":1.0},"144":{"tf":1.4142135623730951},"145":{"tf":1.4142135623730951},"146":{"tf":1.7320508075688772},"147":{"tf":1.4142135623730951},"148":{"tf":1.0},"152":{"tf":1.7320508075688772},"159":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"167":{"tf":1.0},"172":{"tf":1.0},"186":{"tf":1.4142135623730951},"210":{"tf":1.0},"218":{"tf":1.0},"220":{"tf":1.4142135623730951},"223":{"tf":1.7320508075688772},"225":{"tf":1.0},"226":{"tf":1.4142135623730951},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0}}},"p":{"df":3,"docs":{"131":{"tf":1.0},"133":{"tf":1.0},"45":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"204":{"tf":1.0}}},"s":{"df":1,"docs":{"203":{"tf":1.0}}}},"t":{"df":9,"docs":{"130":{"tf":1.0},"146":{"tf":1.0},"174":{"tf":1.0},"210":{"tf":1.0},"211":{"tf":1.0},"214":{"tf":1.0},"221":{"tf":1.0},"223":{"tf":1.7320508075688772},"226":{"tf":1.0}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"154":{"tf":1.4142135623730951}}}}},"df":6,"docs":{"118":{"tf":1.0},"121":{"tf":1.0},"144":{"tf":1.0},"217":{"tf":1.4142135623730951},"219":{"tf":1.7320508075688772},"53":{"tf":1.0}}}}}}},"m":{"!":{"(":{"df":0,"docs":{},"x":{"df":2,"docs":{"167":{"tf":1.4142135623730951},"174":{"tf":1.0}}}},"df":0,"docs":{}},"a":{"c":{"df":2,"docs":{"167":{"tf":1.0},"174":{"tf":1.0}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"148":{"tf":1.0}}}}},"o":{"df":1,"docs":{"43":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"166":{"tf":1.4142135623730951}}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"167":{"tf":1.4142135623730951},"174":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"167":{"tf":1.0}}}}},"df":22,"docs":{"116":{"tf":1.0},"121":{"tf":1.0},"126":{"tf":1.0},"129":{"tf":1.0},"134":{"tf":2.0},"147":{"tf":1.0},"163":{"tf":1.0},"165":{"tf":2.449489742783178},"166":{"tf":3.0},"167":{"tf":4.358898943540674},"168":{"tf":1.0},"174":{"tf":3.7416573867739413},"19":{"tf":1.0},"210":{"tf":1.0},"212":{"tf":1.7320508075688772},"214":{"tf":1.4142135623730951},"219":{"tf":1.0},"223":{"tf":1.0},"226":{"tf":1.0},"39":{"tf":1.7320508075688772},"69":{"tf":2.23606797749979},"83":{"tf":2.23606797749979}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"e":{"df":6,"docs":{"105":{"tf":1.0},"176":{"tf":1.0},"196":{"tf":1.0},"203":{"tf":1.0},"71":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"148":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"113":{"tf":1.0},"138":{"tf":1.0},"148":{"tf":1.0},"217":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"227":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"131":{"tf":1.0},"175":{"tf":1.0},"197":{"tf":1.0},"199":{"tf":1.0},"223":{"tf":1.0},"230":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"203":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"201":{"tf":1.0},"203":{"tf":1.0},"210":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":41,"docs":{"102":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.0},"114":{"tf":1.0},"118":{"tf":1.4142135623730951},"120":{"tf":1.0},"121":{"tf":1.0},"125":{"tf":1.0},"128":{"tf":1.0},"132":{"tf":1.4142135623730951},"141":{"tf":1.0},"143":{"tf":1.0},"160":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"177":{"tf":2.0},"178":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.0},"182":{"tf":1.0},"183":{"tf":1.4142135623730951},"186":{"tf":2.0},"188":{"tf":1.0},"192":{"tf":1.0},"194":{"tf":1.4142135623730951},"196":{"tf":1.7320508075688772},"197":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.7320508075688772},"210":{"tf":1.0},"214":{"tf":1.0},"222":{"tf":1.4142135623730951},"226":{"tf":1.0},"227":{"tf":1.0},"229":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"1":{"tf":1.0},"202":{"tf":1.4142135623730951},"203":{"tf":1.4142135623730951},"204":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":6,"docs":{"152":{"tf":1.0},"159":{"tf":1.0},"202":{"tf":1.0},"5":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"0":{"tf":1.0},"113":{"tf":1.7320508075688772},"140":{"tf":1.7320508075688772},"36":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"230":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"l":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}},"c":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"_":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"i":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":2,"docs":{"54":{"tf":1.0},"62":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"121":{"tf":1.0},"62":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":13,"docs":{"109":{"tf":1.0},"115":{"tf":1.7320508075688772},"117":{"tf":1.0},"129":{"tf":1.4142135623730951},"135":{"tf":1.4142135623730951},"142":{"tf":1.7320508075688772},"177":{"tf":1.0},"186":{"tf":1.0},"211":{"tf":1.0},"222":{"tf":1.0},"223":{"tf":1.0},"229":{"tf":1.0},"5":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"121":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"y":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"p":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":2,"docs":{"159":{"tf":1.0},"172":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":3,"docs":{"116":{"tf":1.0},"163":{"tf":1.0},"7":{"tf":1.0}}},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":3,"docs":{"194":{"tf":1.0},"195":{"tf":1.0},"196":{"tf":1.0}}}}}},"df":1,"docs":{"64":{"tf":1.0}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"81":{"tf":1.7320508075688772}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"102":{"tf":2.23606797749979},"180":{"tf":1.7320508075688772},"186":{"tf":1.0},"188":{"tf":2.23606797749979}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"(":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"171":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"171":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"174":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"(":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"160":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"160":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":21,"docs":{"120":{"tf":1.0},"121":{"tf":1.0},"124":{"tf":1.0},"131":{"tf":1.0},"153":{"tf":1.7320508075688772},"163":{"tf":2.0},"169":{"tf":1.4142135623730951},"174":{"tf":1.0},"210":{"tf":2.0},"211":{"tf":2.6457513110645907},"212":{"tf":2.449489742783178},"213":{"tf":5.477225575051661},"214":{"tf":3.4641016151377544},"217":{"tf":1.0},"220":{"tf":2.23606797749979},"221":{"tf":2.6457513110645907},"222":{"tf":1.4142135623730951},"223":{"tf":2.0},"225":{"tf":2.8284271247461903},"226":{"tf":2.6457513110645907},"54":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"s":{"!":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"152":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"119":{"tf":1.0},"146":{"tf":1.0}}}}}},"x":{"df":6,"docs":{"10":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":21,"docs":{"10":{"tf":1.0},"33":{"tf":1.0},"38":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"81":{"tf":1.0},"93":{"tf":1.0}}}}}}},"y":{"b":{"df":1,"docs":{"130":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"145":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":4,"docs":{"194":{"tf":1.4142135623730951},"195":{"tf":2.23606797749979},"196":{"tf":1.7320508075688772},"203":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":4,"docs":{"167":{"tf":2.0},"174":{"tf":1.0},"179":{"tf":1.0},"182":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":17,"docs":{"107":{"tf":1.4142135623730951},"118":{"tf":1.0},"144":{"tf":1.7320508075688772},"145":{"tf":1.0},"161":{"tf":1.0},"166":{"tf":1.4142135623730951},"203":{"tf":2.0},"210":{"tf":1.0},"213":{"tf":1.0},"222":{"tf":1.0},"230":{"tf":1.0},"31":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.0},"99":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"119":{"tf":1.0},"120":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"113":{"tf":1.0}}}}}}}}},"t":{"df":1,"docs":{"5":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"176":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"138":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"203":{"tf":2.0},"204":{"tf":1.0},"230":{"tf":1.4142135623730951}}}},"m":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":11,"docs":{"132":{"tf":1.0},"183":{"tf":1.0},"187":{"tf":1.0},"199":{"tf":1.4142135623730951},"200":{"tf":1.0},"201":{"tf":1.0},"203":{"tf":3.0},"227":{"tf":1.0},"229":{"tf":1.7320508075688772},"230":{"tf":1.7320508075688772},"5":{"tf":1.0}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"229":{"tf":1.0},"230":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"144":{"tf":1.0},"163":{"tf":1.0},"203":{"tf":1.4142135623730951},"227":{"tf":1.0},"99":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"229":{"tf":1.0},"230":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"199":{"tf":1.0}}}}}}}}}},"r":{"df":0,"docs":{},"g":{"df":10,"docs":{"106":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"179":{"tf":2.0},"183":{"tf":1.0},"186":{"tf":1.4142135623730951},"188":{"tf":1.0},"189":{"tf":1.4142135623730951},"190":{"tf":1.0},"192":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":8,"docs":{"103":{"tf":1.0},"119":{"tf":2.0},"146":{"tf":2.449489742783178},"147":{"tf":1.0},"148":{"tf":2.23606797749979},"149":{"tf":1.0},"179":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"129":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"83":{"tf":1.4142135623730951}},"i":{"df":1,"docs":{"83":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"164":{"tf":1.0},"173":{"tf":1.0}}}},"df":0,"docs":{}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"163":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":33,"docs":{"113":{"tf":1.7320508075688772},"117":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.4142135623730951},"121":{"tf":1.0},"129":{"tf":1.0},"131":{"tf":1.0},"135":{"tf":1.0},"138":{"tf":1.7320508075688772},"144":{"tf":1.4142135623730951},"145":{"tf":1.7320508075688772},"146":{"tf":2.6457513110645907},"151":{"tf":1.7320508075688772},"152":{"tf":1.4142135623730951},"153":{"tf":1.4142135623730951},"154":{"tf":1.0},"155":{"tf":1.4142135623730951},"159":{"tf":1.4142135623730951},"160":{"tf":1.0},"161":{"tf":1.7320508075688772},"162":{"tf":2.449489742783178},"163":{"tf":3.1622776601683795},"164":{"tf":3.0},"167":{"tf":2.0},"168":{"tf":1.4142135623730951},"169":{"tf":2.0},"170":{"tf":2.23606797749979},"171":{"tf":1.4142135623730951},"172":{"tf":1.0},"173":{"tf":2.0},"40":{"tf":1.7320508075688772},"73":{"tf":1.0},"74":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"b":{"df":1,"docs":{"43":{"tf":1.0}}},"d":{"df":1,"docs":{"107":{"tf":1.0}}},"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"d":{"df":1,"docs":{"174":{"tf":1.0}}},"df":2,"docs":{"26":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"w":{"df":1,"docs":{"43":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"1":{"tf":1.0},"113":{"tf":1.0},"140":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":9,"docs":{"109":{"tf":1.0},"121":{"tf":1.7320508075688772},"26":{"tf":1.0},"47":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"185":{"tf":1.0},"223":{"tf":1.0}}}}},"r":{"df":1,"docs":{"107":{"tf":1.0}}},"s":{"c":{"_":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"131":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":2,"docs":{"137":{"tf":1.0},"61":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"s":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"0":{"tf":1.0}}},"x":{"df":3,"docs":{"16":{"tf":1.7320508075688772},"221":{"tf":1.0},"223":{"tf":1.0}}}},"m":{"df":2,"docs":{"179":{"tf":1.0},"193":{"tf":2.0}}},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"134":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"79":{"tf":1.0}}},"i":{"df":0,"docs":{},"f":{"df":3,"docs":{"115":{"tf":1.0},"127":{"tf":1.0},"142":{"tf":1.0}},"i":{"df":6,"docs":{"103":{"tf":1.0},"133":{"tf":3.0},"167":{"tf":1.0},"174":{"tf":1.0},"176":{"tf":1.0},"222":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":6,"docs":{"0":{"tf":1.0},"156":{"tf":1.0},"168":{"tf":1.0},"20":{"tf":1.7320508075688772},"27":{"tf":1.0},"7":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"129":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"129":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"229":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"229":{"tf":1.0},"230":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"e":{"df":43,"docs":{"0":{"tf":1.4142135623730951},"101":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.7320508075688772},"105":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"119":{"tf":1.4142135623730951},"120":{"tf":1.0},"124":{"tf":1.0},"131":{"tf":1.0},"135":{"tf":1.4142135623730951},"140":{"tf":1.0},"141":{"tf":1.0},"143":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"148":{"tf":1.0},"154":{"tf":1.0},"161":{"tf":1.0},"163":{"tf":1.7320508075688772},"164":{"tf":1.0},"186":{"tf":1.0},"196":{"tf":1.0},"197":{"tf":1.7320508075688772},"199":{"tf":1.0},"200":{"tf":1.7320508075688772},"202":{"tf":2.23606797749979},"203":{"tf":3.0},"212":{"tf":1.0},"213":{"tf":1.0},"217":{"tf":1.0},"223":{"tf":1.0},"226":{"tf":1.7320508075688772},"5":{"tf":1.7320508075688772},"58":{"tf":1.0},"7":{"tf":1.0},"79":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.4142135623730951},"89":{"tf":1.0},"90":{"tf":1.0}},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"137":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"200":{"tf":1.4142135623730951},"210":{"tf":2.0}}}}},"v":{"df":0,"docs":{},"e":{"df":4,"docs":{"100":{"tf":1.0},"186":{"tf":1.7320508075688772},"229":{"tf":1.0},"230":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"121":{"tf":1.0}}}}}}},"df":0,"docs":{}},"_":{"1":{"_":{"4":{"4":{"df":1,"docs":{"121":{"tf":1.0}}},"5":{"df":1,"docs":{"121":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"121":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":4,"docs":{"109":{"tf":1.0},"121":{"tf":4.358898943540674},"62":{"tf":1.4142135623730951},"7":{"tf":2.449489742783178}},"s":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"121":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"0":{"tf":1.0},"225":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"202":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"65":{"tf":1.0},"66":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"l":{"df":11,"docs":{"113":{"tf":1.0},"117":{"tf":1.0},"119":{"tf":1.0},"121":{"tf":1.0},"138":{"tf":1.0},"146":{"tf":1.0},"214":{"tf":1.0},"225":{"tf":1.4142135623730951},"226":{"tf":1.0},"31":{"tf":1.0},"5":{"tf":1.0}},"e":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"25":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"51":{"tf":1.7320508075688772}},"e":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"45":{"tf":2.23606797749979}}}},"y":{"_":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"212":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"212":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"214":{"tf":1.0}}}}}}},"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"214":{"tf":1.0}}}}}}},"df":1,"docs":{"214":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"214":{"tf":1.0}}}}}}},"df":1,"docs":{"214":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"214":{"tf":1.0}}}}}}},"df":1,"docs":{"214":{"tf":1.0}}}}}},"df":5,"docs":{"212":{"tf":1.7320508075688772},"213":{"tf":4.0},"214":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"212":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"152":{"tf":1.0},"153":{"tf":1.0},"169":{"tf":1.0},"170":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"164":{"tf":1.0},"173":{"tf":1.0}}}}}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"=":{"<":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"144":{"tf":1.0},"145":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"113":{"tf":1.0},"140":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"112":{"tf":1.4142135623730951},"133":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"133":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},">":{"(":{"<":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"213":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"182":{"tf":1.0}}}}}}},"df":0,"docs":{}},"d":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"218":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":45,"docs":{"109":{"tf":1.0},"111":{"tf":1.7320508075688772},"112":{"tf":1.0},"113":{"tf":1.0},"116":{"tf":2.449489742783178},"118":{"tf":1.4142135623730951},"119":{"tf":1.7320508075688772},"120":{"tf":2.0},"124":{"tf":1.4142135623730951},"128":{"tf":1.0},"129":{"tf":1.0},"132":{"tf":3.0},"133":{"tf":1.4142135623730951},"134":{"tf":1.4142135623730951},"138":{"tf":1.0},"140":{"tf":1.0},"144":{"tf":1.4142135623730951},"146":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.0},"170":{"tf":1.0},"173":{"tf":1.0},"178":{"tf":1.0},"182":{"tf":1.4142135623730951},"209":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":2.6457513110645907},"214":{"tf":3.3166247903554},"219":{"tf":1.0},"223":{"tf":2.23606797749979},"225":{"tf":1.0},"230":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.7320508075688772},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"41":{"tf":1.7320508075688772},"47":{"tf":1.7320508075688772},"67":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772},"7":{"tf":2.23606797749979},"70":{"tf":1.7320508075688772},"94":{"tf":1.4142135623730951}},"s":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"104":{"tf":1.0}}}}}}}},"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"214":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"n":{"df":2,"docs":{"148":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"211":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"196":{"tf":1.0}}}}}},"b":{"df":1,"docs":{"41":{"tf":1.0}}},"df":1,"docs":{"26":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":9,"docs":{"103":{"tf":1.0},"163":{"tf":1.4142135623730951},"175":{"tf":1.0},"181":{"tf":1.0},"187":{"tf":1.0},"188":{"tf":2.0},"195":{"tf":1.0},"204":{"tf":1.0},"58":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"124":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":41,"docs":{"108":{"tf":1.0},"111":{"tf":1.4142135623730951},"113":{"tf":1.7320508075688772},"116":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"119":{"tf":1.0},"121":{"tf":1.4142135623730951},"123":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.4142135623730951},"135":{"tf":1.0},"138":{"tf":1.4142135623730951},"140":{"tf":1.4142135623730951},"143":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.4142135623730951},"148":{"tf":1.0},"152":{"tf":1.0},"161":{"tf":1.0},"168":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.4142135623730951},"177":{"tf":1.4142135623730951},"185":{"tf":1.4142135623730951},"186":{"tf":1.7320508075688772},"202":{"tf":1.4142135623730951},"203":{"tf":1.4142135623730951},"214":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.0},"222":{"tf":1.0},"223":{"tf":1.4142135623730951},"226":{"tf":1.4142135623730951},"228":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.7320508075688772},"43":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"87":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"127":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"g":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"226":{"tf":1.4142135623730951},"32":{"tf":1.0},"5":{"tf":1.0}}}},"df":3,"docs":{"107":{"tf":1.0},"5":{"tf":1.0},"90":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"210":{"tf":1.4142135623730951},"49":{"tf":1.7320508075688772}}}},"t":{"b":{"df":0,"docs":{},"s":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"179":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"181":{"tf":1.0},"99":{"tf":1.0}}}}},"w":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":2,"docs":{"121":{"tf":1.0},"129":{"tf":1.0}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":11,"docs":{"104":{"tf":1.0},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"117":{"tf":1.0},"133":{"tf":2.0},"134":{"tf":1.0},"135":{"tf":1.0},"138":{"tf":1.0},"140":{"tf":1.4142135623730951},"144":{"tf":1.0},"145":{"tf":1.0}}}}}}},"df":41,"docs":{"0":{"tf":1.0},"100":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":2.0},"111":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"113":{"tf":1.7320508075688772},"116":{"tf":1.0},"117":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"129":{"tf":2.0},"131":{"tf":1.7320508075688772},"133":{"tf":2.23606797749979},"135":{"tf":1.4142135623730951},"136":{"tf":1.0},"137":{"tf":1.0},"139":{"tf":1.4142135623730951},"140":{"tf":1.7320508075688772},"143":{"tf":1.0},"144":{"tf":1.4142135623730951},"147":{"tf":1.0},"150":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"175":{"tf":1.4142135623730951},"179":{"tf":1.0},"185":{"tf":1.0},"186":{"tf":1.4142135623730951},"187":{"tf":1.7320508075688772},"188":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.0},"193":{"tf":1.7320508075688772},"202":{"tf":1.4142135623730951},"203":{"tf":2.0},"222":{"tf":1.0},"224":{"tf":1.0},"93":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"t":{"df":12,"docs":{"112":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"129":{"tf":1.0},"138":{"tf":1.0},"149":{"tf":1.4142135623730951},"163":{"tf":1.0},"167":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"186":{"tf":1.0},"79":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":8,"docs":{"108":{"tf":1.4142135623730951},"116":{"tf":1.0},"125":{"tf":1.4142135623730951},"130":{"tf":1.0},"176":{"tf":1.4142135623730951},"179":{"tf":1.7320508075688772},"202":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}}}}}},"o":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"202":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"e":{"df":10,"docs":{"145":{"tf":1.7320508075688772},"210":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":3.1622776601683795},"214":{"tf":2.6457513110645907},"220":{"tf":1.7320508075688772},"223":{"tf":2.449489742783178},"225":{"tf":1.0},"226":{"tf":1.0}},"i":{"d":{"df":2,"docs":{"119":{"tf":1.4142135623730951},"120":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"203":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"145":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":5,"docs":{"109":{"tf":1.0},"137":{"tf":1.0},"210":{"tf":1.0},"225":{"tf":1.0},"96":{"tf":1.0}},"e":{"df":10,"docs":{"119":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.0},"146":{"tf":1.0},"210":{"tf":2.0},"212":{"tf":1.0},"213":{"tf":1.0},"218":{"tf":1.4142135623730951},"221":{"tf":1.4142135623730951},"7":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"b":{"df":0,"docs":{},"r":{"a":{"c":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"129":{"tf":1.0},"138":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":36,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"103":{"tf":1.0},"108":{"tf":1.0},"113":{"tf":1.4142135623730951},"133":{"tf":1.4142135623730951},"138":{"tf":2.23606797749979},"146":{"tf":2.23606797749979},"147":{"tf":1.0},"148":{"tf":2.449489742783178},"151":{"tf":1.4142135623730951},"158":{"tf":1.0},"160":{"tf":1.0},"167":{"tf":1.4142135623730951},"174":{"tf":1.0},"175":{"tf":1.0},"177":{"tf":1.4142135623730951},"178":{"tf":1.0},"179":{"tf":1.4142135623730951},"186":{"tf":2.0},"187":{"tf":1.4142135623730951},"192":{"tf":1.0},"201":{"tf":1.0},"202":{"tf":1.0},"212":{"tf":1.0},"213":{"tf":1.0},"218":{"tf":1.4142135623730951},"219":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":2.23606797749979},"6":{"tf":1.0},"7":{"tf":2.23606797749979},"90":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":4,"docs":{"21":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0}}}}}}}}},"h":{"df":5,"docs":{"117":{"tf":1.0},"135":{"tf":1.0},"148":{"tf":1.0},"202":{"tf":1.0},"97":{"tf":1.0}}},"i":{"c":{"df":4,"docs":{"112":{"tf":1.0},"133":{"tf":1.7320508075688772},"145":{"tf":1.4142135623730951},"169":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"222":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"a":{"d":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"202":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":19,"docs":{"108":{"tf":1.0},"113":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.4142135623730951},"129":{"tf":1.4142135623730951},"133":{"tf":1.0},"138":{"tf":1.4142135623730951},"140":{"tf":1.0},"149":{"tf":1.4142135623730951},"175":{"tf":1.0},"182":{"tf":1.0},"188":{"tf":1.0},"194":{"tf":1.0},"202":{"tf":1.0},"212":{"tf":1.0},"223":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0},"230":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":15,"docs":{"10":{"tf":1.0},"138":{"tf":1.0},"191":{"tf":1.0},"213":{"tf":1.0},"214":{"tf":1.0},"222":{"tf":1.0},"47":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"131":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"112":{"tf":1.0},"133":{"tf":1.0}}}}}}}},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"99":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"o":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"159":{"tf":1.0}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"137":{"tf":1.0}}}}}}},"c":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.0}}}}},"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"214":{"tf":1.0}},"r":{"df":1,"docs":{"226":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":4,"docs":{"186":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"220":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"122":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":2,"docs":{"84":{"tf":1.4142135623730951},"87":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":3,"docs":{"146":{"tf":1.0},"203":{"tf":1.0},"230":{"tf":1.0}}}},"df":0,"docs":{}}}},"k":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"144":{"tf":1.0}}}},"df":2,"docs":{"138":{"tf":1.7320508075688772},"72":{"tf":1.0}}},"l":{"d":{"df":2,"docs":{"147":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"n":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"227":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"c":{"df":7,"docs":{"121":{"tf":1.0},"124":{"tf":1.0},"138":{"tf":1.0},"146":{"tf":1.0},"177":{"tf":1.0},"186":{"tf":1.0},"230":{"tf":1.4142135623730951}}},"df":32,"docs":{"100":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.7320508075688772},"121":{"tf":1.4142135623730951},"127":{"tf":1.0},"131":{"tf":1.0},"133":{"tf":1.4142135623730951},"135":{"tf":1.0},"140":{"tf":1.0},"146":{"tf":1.7320508075688772},"147":{"tf":1.4142135623730951},"159":{"tf":1.0},"17":{"tf":1.4142135623730951},"172":{"tf":1.0},"174":{"tf":1.0},"179":{"tf":1.0},"199":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.0},"211":{"tf":1.0},"214":{"tf":1.7320508075688772},"221":{"tf":1.0},"223":{"tf":1.0},"225":{"tf":1.0},"226":{"tf":2.0},"228":{"tf":1.0},"230":{"tf":1.4142135623730951},"5":{"tf":1.0},"69":{"tf":1.4142135623730951},"79":{"tf":1.0},"97":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"186":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"200":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"97":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"p":{"df":1,"docs":{"226":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"s":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":16,"docs":{"112":{"tf":1.0},"113":{"tf":1.0},"116":{"tf":1.4142135623730951},"138":{"tf":1.0},"177":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.0},"182":{"tf":1.0},"183":{"tf":1.4142135623730951},"186":{"tf":1.0},"188":{"tf":1.0},"196":{"tf":1.0},"203":{"tf":1.7320508075688772},"208":{"tf":1.0},"227":{"tf":1.0},"43":{"tf":1.0}},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"43":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"43":{"tf":1.0}}},"l":{"df":1,"docs":{"43":{"tf":1.0}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}}}},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"r":{"df":11,"docs":{"13":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"223":{"tf":1.7320508075688772},"226":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"71":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"5":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"120":{"tf":1.4142135623730951},"86":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"127":{"tf":1.0}}}}}}},"t":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"218":{"tf":1.4142135623730951},"226":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"218":{"tf":1.0}}}},"df":1,"docs":{"218":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"221":{"tf":1.0},"6":{"tf":1.0},"88":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"n":{"<":{"&":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"214":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"121":{"tf":1.0}}}}},"u":{"3":{"2":{"df":2,"docs":{"167":{"tf":1.0},"174":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":1,"docs":{"218":{"tf":1.0}}}}},"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"df":15,"docs":{"108":{"tf":1.0},"133":{"tf":1.0},"146":{"tf":1.0},"170":{"tf":1.0},"171":{"tf":1.0},"195":{"tf":1.4142135623730951},"212":{"tf":1.0},"213":{"tf":1.4142135623730951},"214":{"tf":1.0},"218":{"tf":1.0},"223":{"tf":1.0},"225":{"tf":1.0},"5":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":12,"docs":{"117":{"tf":1.7320508075688772},"121":{"tf":1.0},"137":{"tf":1.0},"145":{"tf":1.0},"147":{"tf":1.0},"175":{"tf":1.0},"177":{"tf":1.0},"186":{"tf":1.0},"226":{"tf":1.0},"5":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"165":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"182":{"tf":1.4142135623730951},"183":{"tf":1.0},"188":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"6":{"4":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"148":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":5,"docs":{"101":{"tf":1.0},"147":{"tf":1.0},"186":{"tf":1.4142135623730951},"221":{"tf":1.0},"7":{"tf":1.0}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":3,"docs":{"129":{"tf":1.0},"188":{"tf":1.0},"212":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"163":{"tf":2.0},"164":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"163":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":2,"docs":{"144":{"tf":1.0},"145":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"t":{"df":19,"docs":{"102":{"tf":1.0},"108":{"tf":1.0},"127":{"tf":1.0},"137":{"tf":1.0},"138":{"tf":1.0},"161":{"tf":1.0},"178":{"tf":1.0},"180":{"tf":1.0},"186":{"tf":2.0},"188":{"tf":1.0},"192":{"tf":1.4142135623730951},"199":{"tf":1.0},"203":{"tf":1.4142135623730951},"221":{"tf":1.0},"230":{"tf":1.0},"4":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0},"90":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"223":{"tf":1.4142135623730951}}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"227":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":15,"docs":{"103":{"tf":1.4142135623730951},"113":{"tf":1.7320508075688772},"115":{"tf":1.0},"117":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.0},"126":{"tf":1.0},"138":{"tf":3.0},"142":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"149":{"tf":1.0},"188":{"tf":1.0},"202":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"85":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"154":{"tf":1.0},"167":{"tf":1.0},"174":{"tf":1.0},"66":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"133":{"tf":1.4142135623730951}}}},"df":12,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"122":{"tf":1.0},"137":{"tf":1.0},"153":{"tf":1.0},"161":{"tf":1.4142135623730951},"175":{"tf":1.0},"197":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"108":{"tf":1.7320508075688772},"121":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":5,"docs":{"100":{"tf":1.4142135623730951},"217":{"tf":1.4142135623730951},"84":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"108":{"tf":1.0}}}}}}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"148":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"191":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"18":{"tf":2.0}},"k":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"21":{"tf":1.7320508075688772},"55":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"161":{"tf":1.7320508075688772},"164":{"tf":1.0},"173":{"tf":1.0},"21":{"tf":1.0},"219":{"tf":1.4142135623730951},"55":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":6,"docs":{"144":{"tf":1.0},"217":{"tf":1.4142135623730951},"218":{"tf":1.0},"219":{"tf":1.7320508075688772},"223":{"tf":2.23606797749979},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"144":{"tf":1.0},"145":{"tf":1.0},"223":{"tf":1.7320508075688772}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"219":{"tf":1.0}}}}}}},"t":{"df":19,"docs":{"116":{"tf":1.4142135623730951},"126":{"tf":1.4142135623730951},"166":{"tf":1.0},"175":{"tf":1.4142135623730951},"193":{"tf":1.0},"21":{"tf":1.0},"210":{"tf":1.4142135623730951},"214":{"tf":1.7320508075688772},"217":{"tf":1.0},"225":{"tf":1.4142135623730951},"226":{"tf":1.4142135623730951},"229":{"tf":1.0},"230":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0},"91":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"118":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":1,"docs":{"229":{"tf":1.4142135623730951}}}}},"s":{"c":{"a":{"df":0,"docs":{},"l":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"112":{"tf":1.0},"118":{"tf":1.0},"144":{"tf":1.0}}}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"133":{"tf":1.4142135623730951},"140":{"tf":1.0},"145":{"tf":1.0}}}},"df":0,"docs":{}}},"df":31,"docs":{"109":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":2.449489742783178},"118":{"tf":1.4142135623730951},"120":{"tf":1.0},"121":{"tf":1.4142135623730951},"128":{"tf":1.4142135623730951},"129":{"tf":1.4142135623730951},"133":{"tf":2.449489742783178},"135":{"tf":2.0},"138":{"tf":1.7320508075688772},"143":{"tf":1.7320508075688772},"144":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.7320508075688772},"164":{"tf":1.0},"182":{"tf":1.0},"183":{"tf":1.0},"186":{"tf":1.0},"215":{"tf":1.0},"221":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"63":{"tf":1.7320508075688772},"7":{"tf":1.0},"75":{"tf":1.0},"93":{"tf":1.0}}},"t":{"df":2,"docs":{"102":{"tf":1.0},"186":{"tf":1.0}}}},"t":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"226":{"tf":1.4142135623730951}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":2,"docs":{"221":{"tf":1.0},"226":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"221":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"151":{"tf":1.0},"169":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"177":{"tf":1.7320508075688772},"182":{"tf":1.0},"185":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"163":{"tf":1.0},"170":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"182":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"d":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"177":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"178":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":16,"docs":{"10":{"tf":1.7320508075688772},"108":{"tf":1.0},"133":{"tf":1.0},"160":{"tf":1.7320508075688772},"171":{"tf":1.0},"172":{"tf":1.0},"21":{"tf":1.0},"29":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"51":{"tf":1.0},"69":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772}},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"172":{"tf":1.0}}}},":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"160":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"171":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"163":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"222":{"tf":1.0}}},"df":26,"docs":{"122":{"tf":1.0},"127":{"tf":1.0},"134":{"tf":1.0},"151":{"tf":1.0},"153":{"tf":1.0},"163":{"tf":2.0},"169":{"tf":1.0},"209":{"tf":1.7320508075688772},"210":{"tf":1.7320508075688772},"211":{"tf":2.449489742783178},"212":{"tf":3.7416573867739413},"213":{"tf":5.0},"214":{"tf":4.0},"215":{"tf":2.23606797749979},"216":{"tf":1.0},"217":{"tf":2.0},"218":{"tf":1.0},"219":{"tf":2.6457513110645907},"220":{"tf":2.0},"221":{"tf":3.4641016151377544},"222":{"tf":2.449489742783178},"223":{"tf":3.7416573867739413},"224":{"tf":1.7320508075688772},"225":{"tf":2.8284271247461903},"226":{"tf":5.5677643628300215},"58":{"tf":2.23606797749979}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":6,"docs":{"217":{"tf":2.0},"218":{"tf":2.449489742783178},"219":{"tf":1.7320508075688772},"220":{"tf":2.23606797749979},"223":{"tf":1.4142135623730951},"226":{"tf":1.7320508075688772}},"e":{"'":{"df":1,"docs":{"220":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"df":5,"docs":{"179":{"tf":1.0},"180":{"tf":1.0},"182":{"tf":1.0},"183":{"tf":1.0},"5":{"tf":1.4142135623730951}},"e":{"d":{"a":{"df":0,"docs":{}