#!/bin/bash

print_logs() {
    echo "Integration test stopped. Getting logs."
    docker-compose logs
}

trap "exit" INT TERM
trap "print_logs" EXIT

if [[ -n $1 ]]; then echo "Running mode: $1"; fi

env_file=./.env
if [[ "$1" == "hop" ]]; then
  env_file=./.env.hopping
elif [[ "$1" == "kcp" ]]; then
  env_file=./.env.kcp
fi

docker-compose down --rmi all -v
docker-compose build --no-cache --parallel
docker-compose --env-file $env_file up -d --build

# need to wait for openvpn to generate configs
max_retry=40
counter=0

# Testing bridged tunnel
until docker-compose --env-file $env_file exec client ping -c 3 -I tun0 8.8.8.8
do
   ((counter++))
   [[ counter -eq $max_retry ]] && echo "Failed!" && exit 1
   echo "Pinging in client container with config $(cat ${env_file} | grep KCP) and $(cat ${env_file} | grep HOP_PT) failed. Trying again. Try #$counter"
   sleep 30
done


# Testing bridge control panel
if [[ `docker compose logs | grep control-client | tail -n1 | cut -d "|" -f2 | xargs` == "parsing failure" ]]
then
  echo "failed to parse from control panel"
  exit 1
else
  echo "control panel parsing succeeded"
fi;
