package org.component.test;


import java.util.List;

import org.component.test.api.SomeApi;
import org.component.test.api.SomeOtherApi;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.FieldOption;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.component.annotations.ReferenceScope;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.event.EventAdmin;



@Component(name = "org.test.project1", configurationPid = { "pid1",
		"pid2" }, enabled = true, configurationPolicy = ConfigurationPolicy.OPTIONAL, factory = "factoryTest", immediate = false, properties = {
				"prop1.properties", "prop2.properties" }, property = { "prop1:Long=3", "prop1:Long=4",
						"prop2:Long=25" }, scope = ServiceScope.PROTOTYPE)
public class ProviderImpl2 implements SomeApi,SomeOtherApi{

	@Reference
	private ConfigurationAdmin _service;

	private EventAdmin _service2;

	@Reference(bind="bindService",cardinality=ReferenceCardinality.OPTIONAL,field="_service2",fieldOption=FieldOption.REPLACE,name="test",policy=ReferencePolicy.DYNAMIC,policyOption=ReferencePolicyOption.RELUCTANT,scope=ReferenceScope.PROTOTYPE,updated="updateService",target="(test=4)",service=EventAdmin.class)
	void bindService(EventAdmin d) {

	}

	void unbindService(EventAdmin d) {

	}

	void updateService(EventAdmin d) {

	}

	@Activate
	void activate() {
	}

	@Deactivate
	void deactivate() {
	}

	@Modified
	void modify() {
	}
}
