/*
 * $Header: /cvs/xierpa/aQute.lib/src/aQute/lib/line/LineReader.java,v 1.1 2007-01-03 17:27:52 pkriens Exp $
 * 
 * Copyright (c) The OSGi Alliance (2006). All Rights Reserved.
 * 
 * Implementation of certain elements of the OSGi Specification may be subject
 * to third party intellectual property rights, including without limitation,
 * patent rights (such a third party may or may not be a member of the OSGi
 * Alliance). The OSGi Alliance is not responsible and shall not be held
 * responsible in any manner for identifying or failing to identify any or all
 * such third party intellectual property rights.
 * 
 * This document and the information contained herein are provided on an "AS IS"
 * basis and THE OSGI ALLIANCE DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO ANY WARRANTY THAT THE USE OF THE INFORMATION
 * HEREIN WILL NOT INFRINGE ANY RIGHTS AND ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT WILL THE
 * OSGI ALLIANCE BE LIABLE FOR ANY LOSS OF PROFITS, LOSS OF BUSINESS, LOSS OF
 * USE OF DATA, INTERRUPTION OF BUSINESS, OR FOR DIRECT, INDIRECT, SPECIAL OR
 * EXEMPLARY, INCIDENTIAL, PUNITIVE OR CONSEQUENTIAL DAMAGES OF ANY KIND IN
 * CONNECTION WITH THIS DOCUMENT OR THE INFORMATION CONTAINED HEREIN, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH LOSS OR DAMAGE.
 * 
 * All Company, brand and product names may be trademarks that are the sole
 * property of their respective owners. All rights reserved.
 */

package aQute.lib.line;

import java.io.*;

public class LineReader {
	InputStream			reader;
	OutputStream		writer;
	byte[]				buffer			= new byte[8192];
	int					cursor;
	int					end;
	int					last;
	boolean				echo;
	int					linelength;
	boolean				iac				= false;

	final static byte	CR				= 13;
	final static byte	LF				= 13;
	final static byte	CRLF[]			= {13, 10};
	final static byte	BS				= 8;
	final static byte	HISTORY_BACK	= 2;
	final static byte	HISTORY_FORW	= 6;
	final static byte	EOF				= 13;

	public LineReader(InputStream in, OutputStream out, boolean echo,
			int linelength) {
		this.reader = in;
		this.writer = out;
		this.echo = echo;
		this.linelength = linelength;
	}

	public String getLine() throws Exception {
		outer: while (true) {
			writer.flush();
			int c = reader.read();
			if (iac)
				iac(c);
			else {
				switch (c) {
					case -1 :
						return null;
					case '\r' :
						break outer;
					case '\n' :
						if (last != '\r')
							break outer;
						else
							break;

					case 8 : // Backspace
						if (cursor > 0) {
							cursor--;
							delete();
						}
						break;

					case 0x7F : // Backspace
						if (cursor < end) {
							delete();
						}
						break;

					case 255 : // IAC Interpret as command
						iac = true;
						break;

					default :
						insert(c);
						break;
				}
				last = c;
			}
		}
		return new String(buffer, 0, end);
	}

	void insert(int ch) throws Exception {
		System.arraycopy(buffer, cursor, buffer, cursor + 1, end - cursor - 1);
		end++;
		buffer[cursor] = (byte) ch;
		update();
	}

	void delete() throws Exception {
		System.arraycopy(buffer, cursor, buffer, cursor - 1, end - cursor);
		end--;
		cursor--;
	}

	void update() throws Exception {
		for (int i = cursor; i < end; i++) {
			writer.write(0xFF & buffer[cursor]);
		}
		for (int i = cursor; i < end; i++) {
			writer.write(BS);
		}
	}

	/*
	 * TODO
	 */
	void iac(int c) {
		if ( c < 128 )
			iac = false;
	}
}
