package aQute.lib.bundle.support;

import java.io.*;
import java.net.*;
import java.util.*;

import javax.servlet.http.*;

import org.osgi.framework.*;
import org.osgi.service.http.*;
import org.osgi.util.tracker.*;

public class Publisher extends ServiceTracker implements HttpContext {
	Hashtable	publications;

	Publisher() {
		super(Activator.context, HttpService.class.getName(), null);
		this.publications = parse((String) context.getBundle().getHeaders()
				.get("J2B-Published"));
		open();
	}

	Hashtable parse(String publications) {
		StringTokenizer st = new StringTokenizer(publications, ",");
		Hashtable pubs = new Hashtable();

		while (st.hasMoreTokens()) {
			StringTokenizer clause = new StringTokenizer(st.nextToken().trim());
			String pack = clause.nextToken(";").trim();

			while (clause.hasMoreTokens()) {
				String cmd = clause.nextToken("=;").trim();
				String value = clause.nextToken("=;");

				if (cmd.equalsIgnoreCase("j2b-uri")) {
					pubs.put(value, "/" + pack.replace('.', '/'));
				} else
					System.out.println("No Such cmd " + cmd + " in " + clause);
			}
		}
		return pubs;
	}

	/*
	 * @see HttpContext#handleSecurity(HttpServletRequest, HttpServletResponse)
	 */
	public boolean handleSecurity(HttpServletRequest arg0,
			HttpServletResponse arg1) throws IOException {
		return true;
	}

	/*
	 * @see HttpContext#getResource(String)
	 */
	public URL getResource(String pack) {
		System.out.println("Getting rq for " + pack);
		URL url = getClass().getResource(pack);
		System.out.println("Package" + pack + "  " + url);
		return url;
	}

	/*
	 * @see HttpContext#getMimeType(String)
	 */
	public String getMimeType(String arg0) {
		return null;
	}

	/*
	 * @see ServiceTrackerCustomizer#addingService(ServiceReference)
	 */
	public Object addingService(ServiceReference ref) {
		HttpService http = (HttpService) context.getService(ref);
		System.out.println("Publishing");
		for (Enumeration k = publications.keys(); k.hasMoreElements();)
			try {
				String uri = (String) k.nextElement();
				String path = (String) publications.get(uri);
				System.out.println("Publishing uri=" + uri + " path=" + path);
				http.registerResources(uri, path, this);
			} catch (NamespaceException e) {
				e.printStackTrace();
			}
		return http;
	}
}

