package aQute.lib.bundle;

import java.util.*;

public class Package implements Comparable {
	Jar				jar;
	String			pname;
	boolean			reference;
	Map				resources	= new TreeMap();
	String			version;
	public TreeMap	attributes	= new TreeMap();

	public Package() {
	}

	public Package(String clause) {
		System.out.println("Parsing from clause " + clause);
		StringTokenizer st = new StringTokenizer(clause.trim(), ",");
		while (st.hasMoreTokens()) {
			StringTokenizer clst = new StringTokenizer(st.nextToken(), ";");
			pname = clst.nextToken().trim();
			while (clst.hasMoreTokens()) {
				String key = clst.nextToken(";=").trim();
				String value = clst.nextToken("=;").trim();
				if (key.equalsIgnoreCase("specification-version"))
					version = value;
				setAttribute(key, value);
			}
		}
	}

	public String getAttribute(String key, String deflt) {
		System.out.println("Pack " + this + " get attr " + key + " deflt "
				+ deflt + " " + attributes.get(key.toLowerCase()));
		Object value = attributes.get(key.toLowerCase());
		if (value == null)
			return deflt;
		else
			return (String) value;
	}

	public void setAttribute(String key, String value) {
		System.out.println("Pack " + this + " set attr " + key + " value "
				+ value);
		attributes.put(key.toLowerCase(), value);
	}

	public boolean isReference() {
		return reference;
	}

	Package(Jar jar, String pname) {
		this.jar = jar;
		this.pname = pname;
		resources = new Hashtable();
	}

	public Iterator getResources() {
		return resources.values().iterator();
	}

	boolean addResource(Resource r) {
		if (resources.get(r.getName()) != null)
			return false;

		resources.put(r.getName(), r);
		reference |= r.isReference();
		return true;
	}

	public String toString() {
		if (isReference())
			return "ref " + getSpecification();
		else
			return "cnt " + getSpecification();
	}

	public String getSpecification() {
		StringBuffer sb = new StringBuffer();
		sb.append(pname);
		if (version != null) {
			sb.append(";specification-version=");
			sb.append(version);
		}
		return sb.toString();
	}

	public String getName() {
		return pname;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public int compareTo(Object o) {
		Package p = (Package) o;
		int result = getName().compareTo(p.getName());
		if (result != 0)
			return result;

		if (p.getVersion() == null || getVersion() == null)
			return 0;

		return getVersion().compareTo(p.getVersion());
	}

	public String getVersion() {
		return version;
	}

	public int hashCode() {
		return getName().hashCode();
	}
	public boolean equals(Object o) {
		if (!(o instanceof Package))
			return false;

		Package p = (Package) o;
		return getName().equals(p.getName());
	}

}

