/*
 * Decompiled with CFR 0.152.
 */
package com.infor.core.util;

import com.infor.core.util.ExceptionalMapEntryClosure;
import com.infor.core.util.IExceptionalClosure;
import com.infor.core.util.ISelector;
import com.infor.core.util.MapEntryClosure;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static boolean detect(Collection<?> collection, Predicate predicate) {
        return CollectionUtils.find(collection, (Predicate)predicate) != null;
    }

    public static boolean stringCollectionContainsIgnoreCase(Collection<String> stringCollection, final String searchString) {
        return CollectionUtil.detect(stringCollection, new Predicate(){

            public boolean evaluate(Object parameters) {
                String eachString = (String)parameters;
                return eachString.equalsIgnoreCase(searchString);
            }
        });
    }

    public static void forEachDoIgnoreException(Collection<?> collection, IExceptionalClosure closure) {
        for (Object each : collection) {
            try {
                closure.execute(each);
            }
            catch (Exception ignored2) {
                Object ignored2 = null;
            }
        }
    }

    public static void forEachDo(Collection<?> collection, IExceptionalClosure closure) throws Exception {
        for (Object each : collection) {
            closure.execute(each);
        }
    }

    public static void forEachDo(Collection<?> collection, Closure closure) {
        for (Object each : collection) {
            closure.execute(each);
        }
    }

    public static void forEachDo(Map<?, ?> map, MapEntryClosure closure) {
        CollectionUtil.forEachDo(map.entrySet(), (Closure)closure);
    }

    public static void forEachDo(Map<?, ?> map, ExceptionalMapEntryClosure closure) throws Exception {
        CollectionUtil.forEachDo(map.entrySet(), (IExceptionalClosure)closure);
    }

    public static Object select(Set<?> set, ISelector selector) {
        for (Object element : set) {
            if (!selector.accept(element)) continue;
            return element;
        }
        return null;
    }
}

