/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.math.interpolations.Interpolation;
import org.jquantlib.math.interpolations.Interpolator;
import org.jquantlib.math.interpolations.factories.LogLinear;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.yieldcurves.YieldCurve;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.calendars.Target;
import org.jquantlib.util.Date;
import org.jquantlib.util.Pair;

public class InterpolatedDiscountCurve<T extends Interpolator>
extends YieldTermStructure
implements YieldCurve {
    protected Date[] dates;
    protected double[] times;
    protected double[] data;
    protected boolean isNegativeRates;
    protected Interpolator interpolator;
    protected Interpolation interpolation;

    protected InterpolatedDiscountCurve(DayCounter dayCounter, T interpolator) {
        super(dayCounter);
        this.isNegativeRates = this.settings.isNegativeRates();
        this.interpolator = interpolator != null ? interpolator : new LogLinear();
        throw new UnsupportedOperationException("Work in progress");
    }

    protected InterpolatedDiscountCurve(Date referenceDate, DayCounter dayCounter, T interpolator) {
        super(referenceDate, (Calendar)Target.getCalendar(), dayCounter);
        this.isNegativeRates = this.settings.isNegativeRates();
        this.interpolator = interpolator != null ? interpolator : new LogLinear();
        throw new UnsupportedOperationException("Work in progress");
    }

    protected InterpolatedDiscountCurve(int settlementDays, Calendar calendar, DayCounter dayCounter, T interpolator) {
        super(settlementDays, calendar, dayCounter);
        this.isNegativeRates = this.settings.isNegativeRates();
        this.interpolator = interpolator != null ? interpolator : new LogLinear();
        throw new UnsupportedOperationException("Work in progress");
    }

    public InterpolatedDiscountCurve(Date[] dates, double[] discounts, DayCounter dayCounter, Calendar cal, T interpolator) {
        super(dates[0], cal, dayCounter);
        throw new UnsupportedOperationException("Work in progress");
    }

    @Override
    protected double discountImpl(double t) {
        return this.interpolation.evaluate(t, true);
    }

    @Override
    public Date[] getDates() {
        return (Date[])this.dates.clone();
    }

    @Override
    public double[] getData() {
        return (double[])this.data.clone();
    }

    @Override
    public Date maxDate() {
        return this.dates[this.dates.length - 1];
    }

    @Override
    public Pair<Date, Double>[] getNodes() {
        Pair[] results = new Pair[this.dates.length];
        for (int i = 0; i < this.dates.length; ++i) {
            results[i] = new Pair<Date, Double>(this.dates[i], this.data[i]);
        }
        return results;
    }

    @Override
    public double[] getTimes() {
        return (double[])this.times.clone();
    }
}

