/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.methods.lattices;

import org.jquantlib.math.Array;
import org.jquantlib.math.Matrix;
import org.jquantlib.methods.lattices.TreeLattice;
import org.jquantlib.methods.lattices.TrinomialTree;

public abstract class TreeLattice2D<T extends TrinomialTree>
extends TreeLattice {
    private Matrix m;
    private double rho;
    protected T tree1;
    protected T tree2;

    public TreeLattice2D(T tree1, T tree2, double correlation) {
        super(((TrinomialTree)tree1).timeGrid(), TrinomialTree.branches.getValue() * TrinomialTree.branches.getValue());
        this.tree1 = tree1;
        this.tree2 = tree2;
        this.m = new Matrix(TrinomialTree.branches.getValue(), TrinomialTree.branches.getValue());
        this.rho = Math.abs(correlation);
        if (correlation < 0.0 && TrinomialTree.branches.getValue() == 3) {
            this.m.set(0, 0, -1.0);
            this.m.set(0, 1, -4.0);
            this.m.set(0, 2, 5.0);
            this.m.set(1, 0, -4.0);
            this.m.set(1, 1, 8.0);
            this.m.set(1, 2, -4.0);
            this.m.set(2, 0, 5.0);
            this.m.set(2, 1, -4.0);
            this.m.set(2, 2, -1.0);
        } else {
            this.m.set(0, 0, 5.0);
            this.m.set(0, 1, -4.0);
            this.m.set(0, 2, -1.0);
            this.m.set(1, 0, -4.0);
            this.m.set(1, 1, 8.0);
            this.m.set(1, 2, -4.0);
            this.m.set(2, 0, -1.0);
            this.m.set(2, 1, -4.0);
            this.m.set(2, 2, 5.0);
        }
    }

    @Override
    public Array grid(double t) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public int size(int i) {
        return ((TrinomialTree)this.tree1).size(i) * ((TrinomialTree)this.tree2).size(i);
    }

    @Override
    public int descendant(int i, int index, int branch) {
        int modulo = ((TrinomialTree)this.tree1).size(i);
        int index1 = index % modulo;
        int index2 = index / modulo;
        int branch1 = branch % TrinomialTree.branches.getValue();
        int branch2 = branch / TrinomialTree.branches.getValue();
        modulo = ((TrinomialTree)this.tree1).size(i + 1);
        return ((TrinomialTree)this.tree1).descendant(i, index1, branch1) + ((TrinomialTree)this.tree2).descendant(i, index2, branch2) * modulo;
    }

    @Override
    public double probability(int i, int index, int branch) {
        int modulo = ((TrinomialTree)this.tree1).size(i);
        int index1 = index % modulo;
        int index2 = index / modulo;
        int branch1 = branch % TrinomialTree.branches.getValue();
        int branch2 = branch / TrinomialTree.branches.getValue();
        double prob1 = ((TrinomialTree)this.tree1).probability(i, index1, branch1);
        double prob2 = ((TrinomialTree)this.tree2).probability(i, index2, branch2);
        return prob1 * prob2 + this.rho * this.m.get(branch1, branch2) / 36.0;
    }
}

