/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Application;
import netscape.application.ApplicationObserver;
import netscape.application.Timer;
import netscape.application.View;
import netscape.application.Window;
import netscape.util.InconsistencyException;

class TimerQueue
implements Runnable,
ApplicationObserver {
    Timer firstTimer;
    boolean running;

    public TimerQueue() {
        Application application = Application.application();
        application.addObserver(this);
        if (application.isRunning()) {
            this.start();
        }
    }

    synchronized void start() {
        if (this.running) {
            throw new InconsistencyException("Can't start a TimerQueue that is already running");
        }
        Thread thread = new Thread((Runnable)this, "TimerQueue");
        try {
            if (thread.getPriority() > 1) {
                thread.setPriority(thread.getPriority() - 1);
            }
            thread.setDaemon(true);
        }
        catch (SecurityException securityException) {}
        thread.start();
        this.running = true;
    }

    synchronized void stop() {
        this.running = false;
        this.notify();
    }

    synchronized void addTimer(Timer timer, long l) {
        if (timer.running) {
            return;
        }
        Timer timer2 = null;
        Timer timer3 = this.firstTimer;
        while (timer3 != null) {
            if (timer3.expirationTime > l) break;
            timer2 = timer3;
            timer3 = timer3.nextTimer;
        }
        if (timer2 == null) {
            this.firstTimer = timer;
        } else {
            timer2.nextTimer = timer;
        }
        timer.expirationTime = l;
        timer.nextTimer = timer3;
        timer.running = true;
        this.notify();
    }

    synchronized void removeTimer(Timer timer) {
        if (!timer.running) {
            return;
        }
        Timer timer2 = null;
        Timer timer3 = this.firstTimer;
        boolean bl = false;
        while (timer3 != null) {
            if (timer3 == timer) {
                bl = true;
                break;
            }
            timer2 = timer3;
            timer3 = timer3.nextTimer;
        }
        if (!bl) {
            return;
        }
        if (timer2 == null) {
            this.firstTimer = timer.nextTimer;
        } else {
            timer2.nextTimer = timer.nextTimer;
        }
        timer.expirationTime = 0L;
        timer.nextTimer = null;
        timer.running = false;
    }

    synchronized boolean containsTimer(Timer timer) {
        return timer.running;
    }

    synchronized long postExpiredTimers() {
        long l;
        do {
            Timer timer;
            if ((timer = this.firstTimer) == null) {
                return 0L;
            }
            long l2 = System.currentTimeMillis();
            l = timer.expirationTime - l2;
            if (l > 0L) continue;
            timer.post(l2);
            this.removeTimer(timer);
            if (timer.repeats()) {
                this.addTimer(timer, l2 + (long)timer.delay());
            }
            try {
                this.wait(1L);
            }
            catch (InterruptedException interruptedException) {}
        } while (l <= 0L);
        return l;
    }

    public synchronized void run() {
        while (this.running) {
            long l = this.postExpiredTimers();
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TimerQueue (");
        Timer timer = this.firstTimer;
        while (timer != null) {
            stringBuffer.append(timer.toString());
            timer = timer.nextTimer;
            if (timer == null) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void focusDidChange(Application application, View view) {
    }

    public void currentDocumentDidChange(Application application, Window window) {
    }

    public void applicationDidPause(Application application) {
    }

    public void applicationDidResume(Application application) {
    }

    public synchronized void applicationDidStart(Application application) {
        this.start();
    }

    public synchronized void applicationDidStop(Application application) {
        this.stop();
    }
}

