/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.BezelBorder;
import netscape.application.Border;
import netscape.application.Color;
import netscape.application.EmptyBorder;
import netscape.application.Font;
import netscape.application.FormElement;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.Rect;
import netscape.application.Size;
import netscape.application.TextField;
import netscape.application.View;
import netscape.util.ClassInfo;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class ContainerView
extends View
implements FormElement {
    private String title = "";
    private Font titleFont;
    private Image image;
    private TextField titleField;
    private Color backgroundColor = Color.lightGray;
    private Color titleColor = Color.black;
    private Border border = BezelBorder.groovedBezel();
    private int imageDisplayStyle;
    private boolean transparent = false;
    static Vector _fieldDescription = null;
    static final String TITLE_KEY = "title";
    static final String TITLE_FONT_KEY = "titleFont";
    static final String BACKGROUND_COLOR_KEY = "backgroundColor";
    static final String TITLE_COLOR_KEY = "titleColor";
    static final String BORDER_KEY = "border";
    static final String IMAGE_KEY = "image";
    static final String IMAGE_DISPLAY_STYLE_KEY = "imageDisplayStyle";
    static final String TRANSPARENT_KEY = "transparent";

    public ContainerView() {
        this(0, 0, 0, 0);
    }

    public ContainerView(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public ContainerView(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.titleField = new TextField(0, 0, 10, 18);
        this.titleField.setBorder(null);
        this.titleField.setTransparent(true);
        this.titleField.setEditable(false);
        this.titleField.setVertResizeInstruction(4);
        this.titleField.setHorizResizeInstruction(2);
        this.titleField.setJustification(1);
        this.titleFont = Font.fontNamed("Helvetica", 1, 12);
        this.layoutParts();
    }

    void layoutParts() {
        int n;
        int n2;
        this.titleField.removeFromSuperview();
        this.titleField.setStringValue(this.title);
        this.titleField.setFont(this.titleFont);
        this.titleField.sizeToMinSize();
        if (this.border != null) {
            n2 = this.border.leftMargin();
            n = this.border.rightMargin();
        } else {
            n2 = 0;
            n = 0;
        }
        if (!this.titleField.isEmpty()) {
            this.titleField.moveTo(n2, 0);
            this.titleField.sizeTo(this.width() - n2 - n, this.titleField.height());
            this.addSubview(this.titleField);
        }
    }

    public Size minSize() {
        Size size = super.minSize();
        Vector vector = this.subviews();
        int n = 0;
        int n2 = 0;
        if (size.width != 0 || size.height != 0) {
            return size;
        }
        if (this.title != null && !"".equals(this.title)) {
            this.titleField.setStringValue(this.title);
            this.titleField.setFont(this.titleFont);
            n = this.titleField.minSize().width + 6;
            n2 = this.titleField.minSize().height + 2;
        }
        this.layoutView(0, 0);
        int n3 = vector.count();
        int n4 = 0;
        while (n4 < n3) {
            View view = (View)vector.elementAt(n4);
            if (view.bounds().maxX() > n) {
                n = view.bounds().maxX();
            }
            if (view.bounds().maxY() > n2) {
                n2 = view.bounds().maxY();
            }
            ++n4;
        }
        size.width = n;
        size.height = n2;
        if (this.border != null) {
            size.width += this.border.rightMargin();
            size.height += this.border.bottomMargin();
        }
        return size;
    }

    public Rect interiorRect() {
        Rect rect = this.border != null ? this.border.interiorRect(0, 0, this.width(), this.height()) : new Rect(0, 0, this.width(), this.height());
        if (this.titleField._superview != null) {
            rect.y += this.titleField.bounds.height;
            rect.height -= this.titleField.bounds.height;
        }
        return rect;
    }

    public void setTitle(String string) {
        this.title = string != null ? string : "";
        this.layoutParts();
        this.setDirty(true);
    }

    public String title() {
        return this.title;
    }

    public void setTitleColor(Color color) {
        if (color == null || color.equals(this.titleColor)) {
            return;
        }
        this.titleColor = color;
        this.titleField.setTextColor(color);
        this.setDirty(true);
    }

    public Color titleColor() {
        return this.titleColor;
    }

    public void setTitleFont(Font font) {
        this.titleFont = font == null ? Font.fontNamed("Helvetica", 1, 12) : font;
        this.layoutParts();
        this.setDirty(true);
    }

    public Font titleFont() {
        return this.titleFont;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.setDirty(true);
    }

    public Color backgroundColor() {
        return this.backgroundColor;
    }

    public void setBorder(Border border) {
        if (border == null) {
            border = EmptyBorder.emptyBorder();
        }
        this.border = border;
        this.layoutParts();
        this.setDirty(true);
    }

    public Border border() {
        return this.border;
    }

    public void setImage(Image image) {
        this.image = image;
        this.setDirty(true);
    }

    public Image image() {
        return this.image;
    }

    public void setImageDisplayStyle(int n) {
        if (n != 0 && n != 2 && n != 1) {
            throw new InconsistencyException("Unknown image display style: " + n);
        }
        this.imageDisplayStyle = n;
        this.setDirty(true);
    }

    public int imageDisplayStyle() {
        return this.imageDisplayStyle;
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
    }

    public boolean isTransparent() {
        return this.transparent || !this.titleField.isEmpty();
    }

    public void drawViewBackground(Graphics graphics) {
        if (!this.transparent && (this.image == null || this.imageDisplayStyle == 0 && this.backgroundColor != null)) {
            Rect rect = this.image == null ? Rect.newRect() : Rect.newRect(0, 0, this.image.width(), this.image.height());
            if (!rect.contains(this.bounds)) {
                rect.setBounds(0, 0, this.width(), this.height());
                if (this.titleField.isInViewHierarchy()) {
                    rect.moveBy(0, this.titleField.bounds.height / 2);
                    rect.sizeBy(0, -this.titleField.bounds.height / 2);
                }
                graphics.setColor(this.backgroundColor);
                graphics.fillRect(rect);
            }
            Rect.returnRect(rect);
        }
        if (this.image != null) {
            this.image.drawWithStyle(graphics, 0, 0, this.width(), this.height(), this.imageDisplayStyle);
        }
    }

    public void drawViewBorder(Graphics graphics) {
        if (this.border == null) {
            return;
        }
        Rect rect = Rect.newRect(0, 0, this.width(), this.height());
        if (this.titleField.isInViewHierarchy()) {
            rect.moveBy(0, this.titleField.bounds.height / 2);
            rect.sizeBy(0, -this.titleField.bounds.height / 2);
        }
        if (!this.titleField.isInViewHierarchy()) {
            this.border.drawInRect(graphics, rect);
            Rect.returnRect(rect);
            return;
        }
        Size size = this.titleField.minSize();
        Rect rect2 = Rect.newRect(this.titleField.bounds);
        rect2.x = rect2.midX() - size.width / 2 - 4;
        rect2.width = size.width + 8;
        Rect rect3 = Rect.newRect(rect);
        rect3.width = rect2.x - rect.x;
        graphics.pushState();
        graphics.setClipRect(rect3);
        this.border.drawInRect(graphics, rect);
        graphics.popState();
        rect3.x = rect2.maxX();
        rect3.width = rect.maxX() - rect2.maxX();
        graphics.pushState();
        graphics.setClipRect(rect3);
        this.border.drawInRect(graphics, rect);
        graphics.popState();
        rect3.x = rect2.x;
        rect3.y = rect2.maxY();
        rect3.width = rect2.width;
        rect3.height = rect.maxY() - rect2.maxY();
        graphics.pushState();
        graphics.setClipRect(rect3);
        this.border.drawInRect(graphics, rect);
        graphics.popState();
        Rect.returnRect(rect3);
        Rect.returnRect(rect2);
        Rect.returnRect(rect);
    }

    public void drawView(Graphics graphics) {
        this.drawViewBackground(graphics);
    }

    public void drawSubviews(Graphics graphics) {
        super.drawSubviews(graphics);
        this.drawViewBorder(graphics);
    }

    public void layoutView(int n, int n2) {
        if (this.titleField.isInViewHierarchy()) {
            this.titleField.removeFromSuperview();
        }
        super.layoutView(n, n2);
        this.layoutParts();
    }

    public void describeClassInfo(ClassInfo classInfo) {
        super.describeClassInfo(classInfo);
        classInfo.addClass("netscape.application.ContainerView", 1);
        classInfo.addField(TITLE_KEY, (byte)16);
        classInfo.addField(TITLE_FONT_KEY, (byte)18);
        classInfo.addField(BACKGROUND_COLOR_KEY, (byte)18);
        classInfo.addField(TITLE_COLOR_KEY, (byte)18);
        classInfo.addField(IMAGE_KEY, (byte)18);
        classInfo.addField(IMAGE_DISPLAY_STYLE_KEY, (byte)8);
        classInfo.addField(BORDER_KEY, (byte)18);
        classInfo.addField(TRANSPARENT_KEY, (byte)0);
    }

    public void encode(Encoder encoder) throws CodingException {
        boolean bl = false;
        if (this.titleField.superview() != null) {
            this.titleField.removeFromSuperview();
            bl = true;
        }
        super.encode(encoder);
        encoder.encodeString(TITLE_KEY, this.title);
        encoder.encodeObject(TITLE_FONT_KEY, this.titleFont);
        encoder.encodeObject(BACKGROUND_COLOR_KEY, this.backgroundColor);
        encoder.encodeObject(TITLE_COLOR_KEY, this.titleColor);
        encoder.encodeObject(IMAGE_KEY, this.image);
        encoder.encodeInt(IMAGE_DISPLAY_STYLE_KEY, this.imageDisplayStyle);
        if (this.border instanceof EmptyBorder) {
            encoder.encodeObject(BORDER_KEY, null);
        } else {
            encoder.encodeObject(BORDER_KEY, this.border);
        }
        encoder.encodeBoolean(TRANSPARENT_KEY, this.transparent);
        if (bl) {
            this.addSubview(this.titleField);
        }
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.title = decoder.decodeString(TITLE_KEY);
        this.setTitleFont((Font)decoder.decodeObject(TITLE_FONT_KEY));
        this.backgroundColor = (Color)decoder.decodeObject(BACKGROUND_COLOR_KEY);
        this.setTitleColor((Color)decoder.decodeObject(TITLE_COLOR_KEY));
        this.image = (Image)decoder.decodeObject(IMAGE_KEY);
        this.imageDisplayStyle = decoder.decodeInt(IMAGE_DISPLAY_STYLE_KEY);
        this.setBorder((Border)decoder.decodeObject(BORDER_KEY));
        this.transparent = decoder.decodeBoolean(TRANSPARENT_KEY);
    }

    public void finishDecoding() throws CodingException {
        super.finishDecoding();
        String string = this.title;
        this.title = null;
        this.setTitle(string);
    }

    public String formElementText() {
        if (this.titleField != null) {
            return this.titleField.stringValue();
        }
        return "";
    }
}

