/*
 * Decompiled with CFR 0.152.
 */
package jflex.core;

import java.util.List;
import jflex.core.Macros;
import jflex.core.RegExp1;
import jflex.core.RegExp2;
import jflex.core.RegExpException;
import jflex.core.sym;
import jflex.core.unicode.CharClasses;
import jflex.core.unicode.IntCharSet;
import jflex.exceptions.CharClassException;

public class RegExp {
    int type;

    public RegExp(int type) {
        this.type = type;
    }

    public String print(String tab) {
        return tab + this.toString();
    }

    public String toString() {
        return "type = " + this.typeName();
    }

    public String typeName() {
        return sym.terminalNames[this.type];
    }

    public boolean isCharClass() {
        switch (this.type) {
            case 47: 
            case 55: 
            case 58: {
                return true;
            }
            case 41: {
                RegExp2 binary = (RegExp2)this;
                return binary.r1.isCharClass() && binary.r2.isCharClass();
            }
        }
        return false;
    }

    public int size(Macros macros) {
        switch (this.type) {
            case 41: {
                RegExp2 binary = (RegExp2)this;
                return binary.r1.size(macros) + binary.r2.size(macros) + 2;
            }
            case 56: {
                RegExp2 binary = (RegExp2)this;
                return binary.r1.size(macros) + binary.r2.size(macros);
            }
            case 39: 
            case 40: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return content.size(macros) + 2;
            }
            case 42: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return content.size(macros);
            }
            case 45: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return content.size(macros) * content.size(macros);
            }
            case 46: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return content.size(macros) * content.size(macros) * 3;
            }
            case 48: 
            case 57: {
                RegExp1 unary = (RegExp1)this;
                return ((String)unary.content).length() + 1;
            }
            case 47: 
            case 58: {
                return 2;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                return 2;
            }
            case 49: {
                RegExp1 unary = (RegExp1)this;
                return macros.getDefinition((String)unary.content).size(macros);
            }
        }
        throw new RegExpException(this);
    }

    static String revString(String s) {
        return new StringBuilder(s).reverse().toString();
    }

    public final RegExp resolveTilde() {
        switch (this.type) {
            case 41: {
                RegExp2 binary = (RegExp2)this;
                return new RegExp2(41, binary.r1.resolveTilde(), binary.r2.resolveTilde());
            }
            case 56: {
                RegExp2 binary = (RegExp2)this;
                return new RegExp2(56, binary.r1.resolveTilde(), binary.r2.resolveTilde());
            }
            case 39: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(39, content.resolveTilde());
            }
            case 40: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(40, content.resolveTilde());
            }
            case 42: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(42, content.resolveTilde());
            }
            case 45: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(45, content.resolveTilde());
            }
            case 46: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = ((RegExp)unary.content).resolveTilde();
                RegExp1 any_star = new RegExp1(39, RegExp.anyChar());
                RegExp1 neg = new RegExp1(45, new RegExp2(56, any_star, new RegExp2(56, content, any_star)));
                return new RegExp2(56, neg, content);
            }
            case 47: 
            case 48: 
            case 55: 
            case 57: 
            case 58: {
                RegExp1 unary = (RegExp1)this;
                return new RegExp1(unary.type, unary.content);
            }
        }
        throw new RegExpException(this);
    }

    public static RegExp anyChar() {
        return new RegExp1(55, IntCharSet.allChars());
    }

    public static RegExp1 checkPrimClass(RegExp r) {
        if (!(r instanceof RegExp1) || r.type != 55) {
            throw new CharClassException("Not normalised " + r);
        }
        return (RegExp1)r;
    }

    public static IntCharSet performClassOp(int op, IntCharSet l, IntCharSet r, RegExp ctxt) {
        IntCharSet intersection = l.and(r);
        switch (op) {
            case 32: {
                return intersection;
            }
            case 33: {
                IntCharSet set = IntCharSet.copyOf(l);
                set.sub(intersection);
                return set;
            }
            case 34: {
                IntCharSet set = IntCharSet.copyOf(l);
                set.add(r);
                set.sub(intersection);
                return set;
            }
        }
        throw new RegExpException(ctxt);
    }

    public final RegExp normalise(Macros m) {
        switch (this.type) {
            case 41: 
            case 56: {
                RegExp2 binary = (RegExp2)this;
                return new RegExp2(this.type, binary.r1.normalise(m), binary.r2.normalise(m));
            }
            case 39: 
            case 40: 
            case 42: 
            case 45: 
            case 46: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(this.type, content.normalise(m));
            }
            case 47: 
            case 48: 
            case 55: 
            case 57: 
            case 58: {
                RegExp1 unary = (RegExp1)this;
                return new RegExp1(this.type, unary.content);
            }
            case 52: {
                RegExp1 unary = (RegExp1)this;
                List contents = (List)unary.content;
                IntCharSet set = new IntCharSet();
                for (RegExp r : contents) {
                    RegExp1 n = RegExp.checkPrimClass(r.normalise(m));
                    set.add((IntCharSet)n.content);
                }
                return new RegExp1(55, set);
            }
            case 53: {
                RegExp1 unary = (RegExp1)this;
                List contents = (List)unary.content;
                IntCharSet set = IntCharSet.allChars();
                for (RegExp r : contents) {
                    RegExp1 n = RegExp.checkPrimClass(r.normalise(m));
                    set.sub((IntCharSet)n.content);
                }
                return new RegExp1(55, set);
            }
            case 54: {
                RegExp1 unary = (RegExp1)this;
                RegExp2 binary = (RegExp2)unary.content;
                RegExp1 l = RegExp.checkPrimClass(binary.r1.normalise(m));
                IntCharSet setl = (IntCharSet)l.content;
                RegExp1 r = RegExp.checkPrimClass(binary.r2.normalise(m));
                IntCharSet setr = (IntCharSet)r.content;
                IntCharSet set = RegExp.performClassOp(binary.type, setl, setr, this);
                return new RegExp1(55, set);
            }
            case 49: {
                RegExp1 unary = (RegExp1)this;
                return m.getDefinition((String)unary.content).normalise(m);
            }
        }
        throw new RegExpException(this);
    }

    public final void makeCCLs(CharClasses c, boolean caseless) {
        switch (this.type) {
            case 41: 
            case 56: {
                RegExp2 binary = (RegExp2)this;
                binary.r1.makeCCLs(c, caseless);
                binary.r2.makeCCLs(c, caseless);
                return;
            }
            case 39: 
            case 40: 
            case 42: 
            case 45: 
            case 46: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                content.makeCCLs(c, caseless);
                return;
            }
            case 47: 
            case 48: 
            case 57: 
            case 58: {
                return;
            }
            case 55: {
                RegExp1 unary = (RegExp1)this;
                IntCharSet set = (IntCharSet)unary.content;
                c.makeClass(set, caseless);
                return;
            }
        }
        throw new CharClassException("makeCCLs: unexpected regexp " + this);
    }

    public final RegExp rev() {
        switch (this.type) {
            case 41: {
                RegExp2 binary = (RegExp2)this;
                return new RegExp2(41, binary.r1.rev(), binary.r2.rev());
            }
            case 56: {
                RegExp2 binary = (RegExp2)this;
                return new RegExp2(56, binary.r2.rev(), binary.r1.rev());
            }
            case 39: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(39, content.rev());
            }
            case 40: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(40, content.rev());
            }
            case 42: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(42, content.rev());
            }
            case 45: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(45, content.rev());
            }
            case 46: {
                RegExp content = this.resolveTilde();
                return content.rev();
            }
            case 48: 
            case 57: {
                RegExp1 unary = (RegExp1)this;
                return new RegExp1(unary.type, RegExp.revString((String)unary.content));
            }
            case 47: 
            case 55: 
            case 58: {
                RegExp1 unary = (RegExp1)this;
                return new RegExp1(unary.type, unary.content);
            }
        }
        throw new RegExpException(this);
    }
}

