/*
 * Decompiled with CFR 0.152.
 */
package jflex.chars;

import java.util.PrimitiveIterator;

public final class Interval
implements Iterable<Integer> {
    public int start;
    public int end;

    public Interval(int start, int end) {
        this.start = start;
        this.end = end;
        assert (this.invariants());
    }

    public boolean contains(int point) {
        return this.start <= point && this.end >= point;
    }

    public boolean contains(Interval other) {
        return this.start <= other.start && this.end >= other.end;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Interval)) {
            return false;
        }
        Interval other = (Interval)o;
        return other.start == this.start && other.end == this.end;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.start;
        h *= 1000003;
        return h ^= this.end;
    }

    private static boolean isPrintable(int c) {
        return 31 < c && c < 127;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[");
        if (Interval.isPrintable(this.start)) {
            result.append("'").append((char)this.start).append("'");
        } else {
            result.append(this.start);
        }
        if (this.start != this.end) {
            result.append("-");
            if (Interval.isPrintable(this.end)) {
                result.append("'").append((char)this.end).append("'");
            } else {
                result.append(this.end);
            }
        }
        result.append("]");
        return result.toString();
    }

    public static Interval ofCharacter(int c) {
        return new Interval(c, c);
    }

    public static Interval copyOf(Interval interval) {
        return new Interval(interval.start, interval.end);
    }

    public int size() {
        return this.end - this.start + 1;
    }

    public boolean invariants() {
        return this.start <= this.end;
    }

    public IntervalIterator iterator() {
        return new IntervalIterator();
    }

    public class IntervalIterator
    implements PrimitiveIterator.OfInt {
        private int pos;

        private IntervalIterator() {
            this.pos = Interval.this.start;
        }

        @Override
        public boolean hasNext() {
            return this.pos < Interval.this.end;
        }

        @Override
        public int nextInt() {
            return this.pos++;
        }
    }
}

