/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.util;

import java.lang.ref.WeakReference;
import org.jquantlib.util.DefaultObservable;
import org.jquantlib.util.Observable;
import org.jquantlib.util.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeakReferenceObservable
extends DefaultObservable {
    private static final Logger logger = LoggerFactory.getLogger(WeakReferenceObservable.class);

    public WeakReferenceObservable(Observable observable) {
        super(observable);
    }

    @Override
    public void addObserver(Observer observer) {
        super.addObserver(new WeakReferenceObserver(observer));
    }

    @Override
    public void deleteObserver(Observer observer) {
        for (Observer weakObserver : this.getObservers()) {
            WeakReferenceObserver weakReference = (WeakReferenceObserver)weakObserver;
            Observer o = (Observer)weakReference.get();
            if (o != null && !o.equals(observer)) continue;
            this.deleteWeakReference(weakReference);
        }
    }

    private void deleteWeakReference(WeakReferenceObserver observer) {
        super.deleteObserver(observer);
    }

    private class WeakReferenceObserver
    extends WeakReference<Observer>
    implements Observer {
        public WeakReferenceObserver(Observer referent) {
            super(referent);
        }

        @Override
        public void update(Observable o, Object arg) {
            Observer referent = (Observer)this.get();
            if (referent != null) {
                referent.update(o, arg);
            } else {
                WeakReferenceObservable.this.deleteWeakReference(this);
            }
        }
    }
}

