/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class Argentina
extends DelegateCalendar {
    private static final Argentina SETTLEMENT_CALENDAR = new Argentina(Market.SETTLEMENT);
    private static final Argentina MERVAL_CALENDAR = new Argentina(Market.MERVAL);

    private Argentina(Market market) {
        WesternCalendar delegate;
        switch (market) {
            case SETTLEMENT: {
                delegate = new ArgentinaSettlementCalendar();
                break;
            }
            case MERVAL: {
                delegate = new ArgentinaMervalExchangeCalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static Argentina getCalendar(Market market) {
        switch (market) {
            case SETTLEMENT: {
                return SETTLEMENT_CALENDAR;
            }
            case MERVAL: {
                return MERVAL_CALENDAR;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class ArgentinaMervalExchangeCalendar
    extends WesternCalendar {
        private ArgentinaMervalExchangeCalendar() {
        }

        @Override
        public String getName() {
            return "MERVAL";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int dd = date.getDayOfYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.JANUARY || dd == em - 4 || dd == em - 3 || d == 24 && m == Month.MARCH || d == 2 && m == Month.APRIL || d == 1 && m == Month.MAY || d == 25 && m == Month.MAY || d >= 15 && d <= 21 && w == Weekday.MONDAY && m == Month.JUNE || d == 9 && m == Month.JULY || d >= 15 && d <= 21 && w == Weekday.MONDAY && m == Month.AUGUST || (d == 10 || d == 11 || d == 12 || d == 15 || d == 16) && w == Weekday.MONDAY && m == Month.OCTOBER || d == 6 && m == Month.NOVEMBER || d == 8 && m == Month.DECEMBER || (d == 24 || d == 25) && m == Month.DECEMBER) && (d != 31 || m != Month.DECEMBER);
        }
    }

    private static final class ArgentinaSettlementCalendar
    extends WesternCalendar {
        private ArgentinaSettlementCalendar() {
        }

        @Override
        public String getName() {
            return "Argentina";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int dd = date.getDayOfYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.JANUARY || d == 2 && m == Month.APRIL || d == 1 && m == Month.MAY || d == 25 && m == Month.MAY || d >= 15 && d <= 21 && w == Weekday.MONDAY && m == Month.JUNE || d == 9 && m == Month.JULY || d >= 15 && d <= 21 && w == Weekday.MONDAY && m == Month.AUGUST || (d == 10 || d == 11 || d == 12 || d == 15 || d == 16) && w == Weekday.MONDAY && m == Month.OCTOBER || dd == em - 4 || dd == em - 3 || d == 2 && m == Month.NOVEMBER || d == 8 && m == Month.DECEMBER || d == 24 && m == Month.DECEMBER || d == 25 && m == Month.DECEMBER) && (d != 31 && (d != 30 || w != Weekday.FRIDAY) || m != Month.DECEMBER);
        }
    }

    public static enum Market {
        SETTLEMENT,
        MERVAL;

    }
}

