/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.interpolations;

import java.util.Arrays;
import org.jquantlib.math.Array;
import org.jquantlib.math.Closeness;
import org.jquantlib.math.interpolations.AbstractInterpolation;
import org.jquantlib.math.interpolations.Interpolation;
import org.jquantlib.math.interpolations.Interpolator;
import org.jquantlib.methods.finitedifferences.TridiagonalOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubicSplineInterpolation
extends AbstractInterpolation {
    private static final Logger logger = LoggerFactory.getLogger(CubicSplineInterpolation.class);
    private final BoundaryCondition leftType;
    private final BoundaryCondition rightType;
    private final double leftValue;
    private final double rightValue;
    private final boolean constrained;
    private int n;
    private double[] vp;
    private double[] va;
    private double[] vb;
    private double[] vc;
    private boolean monotone;

    public static Interpolator getInterpolator(BoundaryCondition leftCondition, double leftConditionValue, BoundaryCondition rightCondition, double rightConditionValue, boolean monotonicityConstraint) {
        CubicSplineInterpolation cubicSpline;
        CubicSplineInterpolation cubicSplineInterpolation = cubicSpline = new CubicSplineInterpolation(leftCondition, leftConditionValue, rightCondition, rightConditionValue, monotonicityConstraint);
        cubicSplineInterpolation.getClass();
        return cubicSplineInterpolation.new CubicSplineInterpolationImpl(cubicSpline);
    }

    private CubicSplineInterpolation(BoundaryCondition leftCondition, double leftConditionValue, BoundaryCondition rightCondition, double rightConditionValue, boolean monotonicityConstraint) {
        this.leftType = leftCondition;
        this.rightType = rightCondition;
        this.leftValue = leftConditionValue;
        this.rightValue = rightConditionValue;
        this.monotone = false;
        this.constrained = monotonicityConstraint;
    }

    @Override
    @Deprecated
    public void update() {
        this.reload();
    }

    @Override
    public void reload() {
        TridiagonalOperator L = new TridiagonalOperator(this.n);
        Array tmp = new Array(this.n);
        double[] dx = new double[this.n];
        double[] S = new double[this.n];
        int i = 0;
        dx[i] = this.vx[i + 1] - this.vx[i];
        S[i] = (this.vy[i + 1] - this.vy[i]) / dx[i];
        for (i = 1; i < this.n - 1; ++i) {
            dx[i] = this.vx[i + 1] - this.vx[i];
            S[i] = (this.vy[i + 1] - this.vy[i]) / dx[i];
            L.setMidRow(i, dx[i], 2.0 * (dx[i] + dx[i - 1]), dx[i - 1]);
            tmp.set(i, 3.0 * (dx[i] * S[i - 1] + dx[i - 1] * S[i]));
        }
        switch (this.leftType) {
            case NotAKnot: {
                L.setFirstRow(dx[1] * (dx[1] + dx[0]), (dx[0] + dx[1]) * (dx[0] + dx[1]));
                tmp.set(0, S[0] * dx[1] * (2.0 * dx[1] + 3.0 * dx[0]) + S[1] * dx[0] * dx[0]);
                break;
            }
            case FirstDerivative: {
                L.setFirstRow(1.0, 0.0);
                tmp.set(0, this.leftValue);
                break;
            }
            case SecondDerivative: {
                L.setFirstRow(2.0, 1.0);
                tmp.set(0, 3.0 * S[0] - this.leftValue * dx[0] / 2.0);
                break;
            }
            case Periodic: 
            case Lagrange: {
                throw new UnsupportedOperationException("this end condition is not implemented yet");
            }
            default: {
                throw new UnsupportedOperationException("unknown end condition");
            }
        }
        switch (this.rightType) {
            case NotAKnot: {
                L.setLastRow(-(dx[this.n - 2] + dx[this.n - 3]) * (dx[this.n - 2] + dx[this.n - 3]), -dx[this.n - 3] * (dx[this.n - 3] + dx[this.n - 2]));
                tmp.set(this.n - 1, -S[this.n - 3] * dx[this.n - 2] * dx[this.n - 2] - S[this.n - 2] * dx[this.n - 3] * (3.0 * dx[this.n - 2] + 2.0 * dx[this.n - 3]));
                break;
            }
            case FirstDerivative: {
                L.setLastRow(0.0, 1.0);
                tmp.set(this.n - 1, this.rightValue);
                break;
            }
            case SecondDerivative: {
                L.setLastRow(1.0, 2.0);
                tmp.set(this.n - 1, 3.0 * S[this.n - 2] + this.rightValue * dx[this.n - 2] / 2.0);
                break;
            }
            case Periodic: 
            case Lagrange: {
                throw new UnsupportedOperationException("this end condition is not implemented yet");
            }
            default: {
                throw new UnsupportedOperationException("unknown end condition");
            }
        }
        tmp = L.solveFor(tmp);
        if (this.constrained) {
            for (i = 0; i < this.n; ++i) {
                double pu;
                double pd;
                double correction;
                if (i == 0) {
                    correction = tmp.get(i) * S[0] > 0.0 ? tmp.get(i) / Math.abs(tmp.get(i)) * Math.min(Math.abs(tmp.get(i)), Math.abs(3.0 * S[0])) : 0.0;
                    if (Closeness.isClose(correction, tmp.get(i))) continue;
                    tmp.set(i, correction);
                    this.monotone = true;
                    continue;
                }
                if (i == this.n - 1) {
                    correction = tmp.get(i) * S[this.n - 2] > 0.0 ? tmp.get(i) / Math.abs(tmp.get(i)) * Math.min(Math.abs(tmp.get(i)), Math.abs(3.0 * S[this.n - 2])) : 0.0;
                    if (Closeness.isClose(correction, tmp.get(i))) continue;
                    tmp.set(i, correction);
                    this.monotone = true;
                    continue;
                }
                double pm = (S[i - 1] * dx[i] + S[i] * dx[i - 1]) / (dx[i - 1] + dx[i]);
                double M = 3.0 * Math.min(Math.min(Math.abs(S[i - 1]), Math.abs(S[i])), Math.abs(pm));
                if (i > 1 && (S[i - 1] - S[i - 2]) * (S[i] - S[i - 1]) > 0.0 && pm * (pd = (S[i - 1] * (2.0 * dx[i - 1] + dx[i - 2]) - S[i - 2] * dx[i - 1]) / (dx[i - 2] + dx[i - 1])) > 0.0 && pm * (S[i - 1] - S[i - 2]) > 0.0) {
                    M = Math.max(M, 1.5 * Math.min(Math.abs(pm), Math.abs(pd)));
                }
                if (i < this.n - 2 && (S[i] - S[i - 1]) * (S[i + 1] - S[i]) > 0.0 && pm * (pu = (S[i] * (2.0 * dx[i] + dx[i + 1]) - S[i + 1] * dx[i]) / (dx[i] + dx[i + 1])) > 0.0 && -pm * (S[i] - S[i - 1]) > 0.0) {
                    M = Math.max(M, 1.5 * Math.min(Math.abs(pm), Math.abs(pu)));
                }
                if (Closeness.isClose(correction = tmp.get(i) * pm > 0.0 ? tmp.get(i) / Math.abs(tmp.get(i)) * Math.min(Math.abs(tmp.get(i)), M) : 0.0, tmp.get(i))) continue;
                tmp.set(i, correction);
                this.monotone = true;
            }
        }
        for (i = 0; i < this.n - 1; ++i) {
            this.va[i] = tmp.get(i);
            this.vb[i] = (3.0 * S[i] - tmp.get(i + 1) - 2.0 * tmp.get(i)) / dx[i];
            this.vc[i] = (tmp.get(i + 1) + tmp.get(i) - 2.0 * S[i]) / (dx[i] * dx[i]);
        }
        this.vp[0] = 0.0;
        for (i = 1; i < this.n - 1; ++i) {
            this.vp[i] = this.vp[i - 1] + dx[i - 1] * (this.vy[i - 1] + dx[i - 1] * (this.va[i - 1] / 2.0 + dx[i - 1] * (this.vb[i - 1] / 3.0 + dx[i - 1] * this.vc[i - 1] / 4.0)));
        }
    }

    @Override
    protected double evaluateImpl(double x) {
        int j = this.locate(x);
        double dx = x - this.vx[j];
        return this.vy[j] + dx * (this.va[j] + dx * (this.vb[j] + dx * this.vc[j]));
    }

    @Override
    protected double primitiveImpl(double x) {
        int j = this.locate(x);
        double dx = x - this.vx[j];
        return this.vp[j] + dx * (this.vy[j] + dx * (this.va[j] / 2.0 + dx * (this.vb[j] / 3.0 + dx * this.vc[j] / 4.0)));
    }

    @Override
    protected double derivativeImpl(double x) {
        int j = this.locate(x);
        double dx = x - this.vx[j];
        return this.va[j] + (2.0 * this.vb[j] + 3.0 * this.vc[j] * dx) * dx;
    }

    @Override
    protected double secondDerivativeImpl(double x) {
        int j = this.locate(x);
        double dx = x - this.vx[j];
        return 2.0 * this.vb[j] + 6.0 * this.vc[j] * dx;
    }

    public double[] getVa() {
        return this.va;
    }

    public double[] getVb() {
        return this.vb;
    }

    public double[] getVc() {
        return this.vc;
    }

    static /* synthetic */ double[] access$102(CubicSplineInterpolation x0, double[] x1) {
        x0.vp = x1;
        return x1;
    }

    static /* synthetic */ double[] access$202(CubicSplineInterpolation x0, double[] x1) {
        x0.va = x1;
        return x1;
    }

    static /* synthetic */ double[] access$302(CubicSplineInterpolation x0, double[] x1) {
        x0.vb = x1;
        return x1;
    }

    static /* synthetic */ double[] access$402(CubicSplineInterpolation x0, double[] x1) {
        x0.vc = x1;
        return x1;
    }

    public static enum BoundaryCondition {
        NotAKnot,
        FirstDerivative,
        SecondDerivative,
        Periodic,
        Lagrange;

    }

    private class CubicSplineInterpolationImpl
    implements Interpolator {
        private CubicSplineInterpolation delegate;

        public CubicSplineInterpolationImpl(CubicSplineInterpolation delegate) {
            this.delegate = delegate;
        }

        @Override
        public final Interpolation interpolate(double[] x, double[] y) {
            return this.interpolate(x.length, x, y);
        }

        @Override
        public final Interpolation interpolate(int size, double[] x, double[] y) {
            this.delegate.vx = Arrays.copyOfRange(x, 0, size);
            this.delegate.vy = Arrays.copyOfRange(y, 0, size);
            CubicSplineInterpolation.this.n = CubicSplineInterpolation.this.vx.length;
            CubicSplineInterpolation.access$102(CubicSplineInterpolation.this, new double[CubicSplineInterpolation.this.n - 1]);
            CubicSplineInterpolation.access$202(CubicSplineInterpolation.this, new double[CubicSplineInterpolation.this.n - 1]);
            CubicSplineInterpolation.access$302(CubicSplineInterpolation.this, new double[CubicSplineInterpolation.this.n - 1]);
            CubicSplineInterpolation.access$402(CubicSplineInterpolation.this, new double[CubicSplineInterpolation.this.n - 1]);
            this.delegate.reload();
            return this.delegate;
        }

        @Override
        public final boolean isGlobal() {
            return true;
        }
    }
}

