/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.integrals;

import org.jquantlib.math.UnaryFunctionDouble;
import org.jquantlib.math.integrals.Integrator;

public class SegmentIntegral
extends Integrator {
    private int intervals;

    public SegmentIntegral(int intervals) {
        super(1.0, 1);
        if (intervals < 1) {
            throw new ArithmeticException("at least 1 interval needed");
        }
        this.intervals = intervals;
    }

    @Override
    public final double integrate(UnaryFunctionDouble f, double a, double b) {
        double dx = (b - a) / (double)this.getNumberOfEvaluations();
        double sum = 0.5 * (f.evaluate(a) + f.evaluate(b));
        double end = b - 0.5 * dx;
        for (double x = a + dx; x < end; x += dx) {
            sum += f.evaluate(x);
        }
        return sum * dx;
    }

    @Override
    public final int getNumberOfEvaluations() {
        return this.intervals;
    }
}

