/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.transaction.server;

import java.rmi.RemoteException;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.transaction.CannotJoinException;
import net.jini.core.transaction.NestableTransaction;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.CrashCountException;
import net.jini.core.transaction.server.NestableTransactionManager;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.core.transaction.server.TransactionParticipant;

public class NestableServerTransaction
extends ServerTransaction
implements NestableTransaction {
    static final long serialVersionUID = -3438419132543972925L;
    public final NestableServerTransaction parent;

    public NestableServerTransaction(NestableTransactionManager mgr, long id, NestableServerTransaction parent) {
        super(mgr, id);
        this.parent = parent;
    }

    public NestableTransaction.Created create(NestableTransactionManager mgr, long leaseTime) throws UnknownTransactionException, CannotJoinException, LeaseDeniedException, RemoteException {
        TransactionManager.Created rawTxn = mgr.create((NestableTransactionManager)this.mgr, this.id, leaseTime);
        return new NestableTransaction.Created(new NestableServerTransaction(mgr, rawTxn.id, this), rawTxn.lease);
    }

    public NestableTransaction.Created create(long leaseTime) throws UnknownTransactionException, CannotJoinException, LeaseDeniedException, RemoteException {
        return this.create((NestableTransactionManager)this.mgr, leaseTime);
    }

    public void promote(TransactionParticipant[] parts, long[] crashCounts, TransactionParticipant drop) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        ((NestableTransactionManager)this.mgr).promote(this.id, parts, crashCounts, drop);
    }

    public boolean enclosedBy(NestableTransaction enclosing) {
        NestableServerTransaction ancestor = this.parent;
        while (ancestor != null) {
            if (ancestor.equals(enclosing)) {
                return true;
            }
            ancestor = ancestor.parent;
        }
        return false;
    }

    public boolean isNested() {
        return this.parent != null;
    }

    public String toString() {
        return this.getClass().getName() + " [manager=" + this.mgr + ", id=" + this.id + ", parent=" + this.parent + "]";
    }
}

