/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.http;

import com.sun.jini.jeri.internal.http.Header;
import com.sun.jini.jeri.internal.http.HttpServerManager;
import com.sun.jini.jeri.internal.http.MessageReader;
import com.sun.jini.jeri.internal.http.MessageWriter;
import com.sun.jini.jeri.internal.http.Request;
import com.sun.jini.jeri.internal.http.StartLine;
import com.sun.jini.jeri.internal.http.TimedConnection;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.StringTokenizer;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.io.context.AcknowledgmentSource;
import net.jini.jeri.InboundRequest;
import net.jini.jeri.RequestDispatcher;

public abstract class HttpServerConnection
implements TimedConnection {
    private static final int HTTP_MAJOR = 1;
    private static final int HTTP_MINOR = 1;
    private static final int UNSTARTED = 0;
    private static final int IDLE = 1;
    private static final int BUSY = 2;
    private static final int CLOSED = 3;
    private static final String serverString = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return "Java/" + System.getProperty("java.version", "???") + " " + (class$com$sun$jini$jeri$internal$http$HttpServerConnection == null ? (class$com$sun$jini$jeri$internal$http$HttpServerConnection = HttpServerConnection.class$("com.sun.jini.jeri.internal.http.HttpServerConnection")) : class$com$sun$jini$jeri$internal$http$HttpServerConnection).getName();
        }
    });
    private static final Executor userThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(true));
    private final Socket sock;
    private final InputStream in;
    private final OutputStream out;
    private final RequestDispatcher dispatcher;
    private final HttpServerManager manager;
    private final Object stateLock = new Object();
    private int state = 0;
    static /* synthetic */ Class class$com$sun$jini$jeri$internal$http$HttpServerConnection;

    public HttpServerConnection(Socket sock, RequestDispatcher dispatcher, HttpServerManager manager) throws IOException {
        if (dispatcher == null) {
            throw new NullPointerException();
        }
        this.sock = sock;
        this.dispatcher = dispatcher;
        this.manager = manager;
        this.in = new BufferedInputStream(sock.getInputStream());
        this.out = new BufferedOutputStream(sock.getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != 0) {
                throw new IllegalStateException();
            }
            this.state = 1;
            userThreadPool.execute(new Dispatcher(), "HTTP dispatcher");
        }
    }

    protected void checkPermissions() {
    }

    protected InvocationConstraints checkConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
        if (constraints.requirements().isEmpty()) {
            return InvocationConstraints.EMPTY;
        }
        throw new UnsupportedConstraintException("cannot satisfy constraints: " + constraints);
    }

    protected abstract void populateContext(Collection var1);

    protected void idle() {
    }

    protected void busy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown(boolean force) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 3) {
                return true;
            }
            if (!force && this.state == 2) {
                return false;
            }
            this.state = 3;
        }
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private void registerAcks(String ackList) {
        if (ackList != null) {
            StringTokenizer tok = new StringTokenizer(ackList, ",");
            while (tok.hasMoreTokens()) {
                this.manager.notifyAckListeners(tok.nextToken().trim());
            }
        }
    }

    private static boolean supportsPersist(StartLine sline, Header header) {
        if (header.containsValue("Connection", "close", true)) {
            return false;
        }
        if (header.containsValue("Connection", "Keep-Alive", true)) {
            return true;
        }
        int c = StartLine.compareVersions(sline.major, sline.minor, 1, 1);
        return c >= 0;
    }

    private static boolean supportsChunking(StartLine sline, Header header) {
        int c = StartLine.compareVersions(sline.major, sline.minor, 1, 1);
        return c >= 0 && header.containsValue("TE", "trailers", true);
    }

    private static Header createResponseHeader(boolean persist) {
        Header header = new Header();
        long now = System.currentTimeMillis();
        header.setField("Date", Header.getDateString(now));
        header.setField("Server", serverString);
        header.setField("Connection", persist ? "Keep-Alive" : "close");
        return header;
    }

    private class InboundRequestImpl
    extends Request
    implements InboundRequest {
        private final MessageReader reader;
        private final MessageWriter writer;
        private String cookie;
        private boolean corrupt = false;

        InboundRequestImpl(MessageReader reader, MessageWriter writer) {
            this.reader = reader;
            this.writer = writer;
        }

        public void checkPermissions() {
            HttpServerConnection.this.checkPermissions();
        }

        public InvocationConstraints checkConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
            return HttpServerConnection.this.checkConstraints(constraints);
        }

        public void populateContext(Collection context) {
            context.add(new AcknowledgmentSource(){

                public boolean addAcknowledgmentListener(AcknowledgmentSource.Listener listener) {
                    if (listener == null) {
                        throw new NullPointerException();
                    }
                    return InboundRequestImpl.this.addAcknowledgmentListener(listener);
                }
            });
            HttpServerConnection.this.populateContext(context);
        }

        public InputStream getRequestInputStream() {
            return this.getInputStream();
        }

        public OutputStream getResponseOutputStream() {
            return this.getOutputStream();
        }

        boolean streamCorrupt() {
            return this.corrupt;
        }

        void startOutput() throws IOException {
        }

        void write(byte[] b, int off, int len) throws IOException {
            this.writer.writeContent(b, off, len);
        }

        void endOutput() throws IOException {
            if (this.cookie != null) {
                Header trailer = new Header();
                trailer.setField("RMI-Response-Cookie", this.cookie);
                this.writer.writeTrailer(trailer);
            } else {
                this.writer.writeTrailer(null);
            }
        }

        boolean startInput() throws IOException {
            return true;
        }

        int read(byte[] b, int off, int len) throws IOException {
            return this.reader.readContent(b, off, len);
        }

        int available() throws IOException {
            return this.reader.availableContent();
        }

        void endInput() throws IOException {
            Header trailer = this.reader.readTrailer();
            if (trailer != null) {
                HttpServerConnection.this.registerAcks(trailer.getField("RMI-Response-Ack"));
            }
        }

        void addAckListener(AcknowledgmentSource.Listener listener) {
            if (this.cookie == null) {
                this.cookie = HttpServerConnection.this.manager.newCookie();
            }
            HttpServerConnection.this.manager.addAckListener(this.cookie, listener);
        }

        void done(boolean corrupt) {
            this.corrupt = corrupt;
        }
    }

    private class Dispatcher
    implements Runnable {
        private Dispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {}
                catch (IOException iOException) {
                    Object var8_9 = null;
                    HttpServerConnection.this.shutdown(true);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                HttpServerConnection.this.shutdown(true);
                throw throwable;
            }
            while (true) {
                HttpServerConnection.this.idle();
                MessageReader reader = new MessageReader(HttpServerConnection.this.in, false);
                StartLine sline = reader.readStartLine();
                HttpServerConnection.this.busy();
                Object object = HttpServerConnection.this.stateLock;
                synchronized (object) {
                    if (HttpServerConnection.this.state == 3) {
                        // MONITOREXIT @DISABLED, blocks:[18, 6, 10] lbl24 : MonitorExitStatement: MONITOREXIT : var3_4
                        Object var8_7 = null;
                        HttpServerConnection.this.shutdown(true);
                        return;
                    }
                    HttpServerConnection.this.state = 2;
                }
                Header header = reader.readHeader();
                String reqType = header.getField("RMI-Request-Type");
                if (!"POST".equals(sline.method)) {
                    this.handleBadRequest(sline, header, reader);
                } else if ("standard".equalsIgnoreCase(reqType)) {
                    this.handleRequest(sline, header, reader);
                } else if ("ping".equalsIgnoreCase(reqType)) {
                    this.handlePing(sline, header, reader);
                } else {
                    this.handleBadRequest(sline, header, reader);
                }
                Object object2 = HttpServerConnection.this.stateLock;
                synchronized (object2) {
                    if (HttpServerConnection.this.state == 3) {
                        // MONITOREXIT @DISABLED, blocks:[7, 10, 11] lbl48 : MonitorExitStatement: MONITOREXIT : var5_6
                        Object var8_8 = null;
                        HttpServerConnection.this.shutdown(true);
                        return;
                    }
                    HttpServerConnection.this.state = 1;
                }
            }
        }

        private void handleBadRequest(StartLine inLine, Header inHeader, MessageReader reader) throws IOException {
            inHeader.merge(reader.readTrailer());
            HttpServerConnection.this.registerAcks(inHeader.getField("RMI-Response-Ack"));
            boolean persist = HttpServerConnection.supportsPersist(inLine, inHeader);
            MessageWriter writer = new MessageWriter(HttpServerConnection.this.out, false);
            writer.writeStartLine(new StartLine(1, 1, 400, "Bad Request"));
            writer.writeHeader(HttpServerConnection.createResponseHeader(persist));
            writer.writeTrailer(null);
            if (!persist) {
                HttpServerConnection.this.shutdown(true);
            }
        }

        private void handlePing(StartLine inLine, Header inHeader, MessageReader reader) throws IOException {
            inHeader.merge(reader.readTrailer());
            HttpServerConnection.this.registerAcks(inHeader.getField("RMI-Response-Ack"));
            boolean persist = HttpServerConnection.supportsPersist(inLine, inHeader);
            MessageWriter writer = new MessageWriter(HttpServerConnection.this.out, false);
            writer.writeStartLine(new StartLine(1, 1, 200, "OK"));
            writer.writeHeader(HttpServerConnection.createResponseHeader(persist));
            writer.writeTrailer(null);
            if (!persist) {
                HttpServerConnection.this.shutdown(true);
            }
        }

        private void handleRequest(StartLine inLine, Header inHeader, MessageReader reader) throws IOException {
            HttpServerConnection.this.registerAcks(inHeader.getField("RMI-Response-Ack"));
            boolean persist = HttpServerConnection.supportsPersist(inLine, inHeader);
            boolean chunk = HttpServerConnection.supportsChunking(inLine, inHeader);
            MessageWriter writer = new MessageWriter(HttpServerConnection.this.out, chunk);
            writer.writeStartLine(new StartLine(1, 1, 200, "OK"));
            writer.writeHeader(HttpServerConnection.createResponseHeader(persist));
            InboundRequestImpl req = new InboundRequestImpl(reader, writer);
            try {
                HttpServerConnection.this.dispatcher.dispatch(req);
            }
            catch (Throwable th) {
                // empty catch block
            }
            req.finish();
            if (!persist || req.streamCorrupt()) {
                HttpServerConnection.this.shutdown(true);
            }
        }
    }
}

