/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec.support;

import java.util.ArrayList;
import java.util.List;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleProtocolEncoderOutput
implements ProtocolEncoderOutput {
    private final List<ByteBuffer> bufferQueue = new ArrayList<ByteBuffer>();

    public List<ByteBuffer> getBufferQueue() {
        return this.bufferQueue;
    }

    @Override
    public void write(ByteBuffer buf) {
        this.bufferQueue.add(buf);
    }

    @Override
    public void mergeAll() {
        int size = this.bufferQueue.size();
        if (size < 2) {
            return;
        }
        int sum = 0;
        for (int i = size - 1; i >= 0; --i) {
            sum += this.bufferQueue.get(i).remaining();
        }
        ByteBuffer newBuf = ByteBuffer.allocate(sum);
        while (!this.bufferQueue.isEmpty()) {
            ByteBuffer buf = this.bufferQueue.remove(0);
            newBuf.put(buf);
            buf.release();
        }
        newBuf.flip();
        this.bufferQueue.add(newBuf);
    }

    @Override
    public WriteFuture flush() {
        WriteFuture future = null;
        while (!this.bufferQueue.isEmpty()) {
            ByteBuffer buf = this.bufferQueue.remove(0);
            if (!buf.hasRemaining()) continue;
            future = this.doFlush(buf);
        }
        return future;
    }

    protected abstract WriteFuture doFlush(ByteBuffer var1);
}

