/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.internal.provisional.p2.core.FormatException;
import org.eclipse.equinox.internal.provisional.p2.core.Messages;
import org.eclipse.equinox.internal.provisional.p2.core.RawFormat;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionFormatParser;
import org.eclipse.equinox.internal.provisional.p2.core.VersionParser;
import org.eclipse.equinox.internal.provisional.p2.core.VersionVector;
import org.eclipse.osgi.util.NLS;

public class VersionFormat
implements Serializable {
    private static final long serialVersionUID = 6888925893926932754L;
    public static final VersionFormat OSGI_FORMAT;
    public static final VersionFormat RAW_FORMAT;
    private static final Map formatCache;
    private static final String OSGI_FORMAT_STRING = "n[.n=0;[.n=0;[.S=[A-Za-z0-9_-];]]]";
    private static final String RAW_FORMAT_STRING = "r(.r)*p?";
    private final Fragment topFragment;
    private String fmtString;

    static {
        formatCache = Collections.synchronizedMap(new HashMap());
        try {
            VersionFormatParser parser = new VersionFormatParser();
            OSGI_FORMAT = new VersionFormat(parser.compile(OSGI_FORMAT_STRING, 0, OSGI_FORMAT_STRING.length()));
            formatCache.put(OSGI_FORMAT_STRING, OSGI_FORMAT);
            RAW_FORMAT = new RawFormat(parser.compile(RAW_FORMAT_STRING, 0, RAW_FORMAT_STRING.length()));
            formatCache.put(RAW_FORMAT_STRING, RAW_FORMAT);
        }
        catch (FormatException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    static boolean equalsAllowNull(Object a, Object b) {
        return a == null ? b == null : b != null && a.equals(b);
    }

    public static VersionFormat compile(String format) throws FormatException {
        return VersionFormat.compile(format, 0, format.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VersionFormat compile(String format, int start, int end) throws FormatException {
        String fmtString;
        String string = fmtString = format.substring(start, end).intern();
        synchronized (string) {
            VersionFormat fmt = (VersionFormat)formatCache.get(fmtString);
            if (fmt == null) {
                VersionFormatParser parser = new VersionFormatParser();
                fmt = new VersionFormat(parser.compile(format, start, end));
                formatCache.put(fmtString, fmt);
            }
            return fmt;
        }
    }

    static Version parseRaw(String version, VersionFormat originalFormat, String original) {
        Comparable[] padReturn = new Comparable[1];
        Comparable[] vector = RAW_FORMAT.parse(version, 0, version.length(), padReturn);
        return new Version(vector, padReturn[0], originalFormat, original);
    }

    static void appendCharacterRange(StringBuffer sb, char[] range, boolean inverted) {
        sb.append('=');
        sb.append('[');
        if (inverted) {
            sb.append('^');
        }
        int top = range.length;
        int idx = 0;
        while (idx < top) {
            char b = range[idx];
            if (b == '\\' || b == ']' || b == '-' && idx + 1 < top) {
                sb.append('\\');
            }
            sb.append(b);
            int ndx = idx + 1;
            if (ndx + 2 < top) {
                char c = b;
                while (ndx < top) {
                    char n = range[ndx];
                    if (c + '\u0001' != n) break;
                    c = n;
                    ++ndx;
                }
                if (ndx > idx + 3) {
                    sb.append('-');
                    if (c == '\\' || c == ']' || c == '-' && idx + 1 < top) {
                        sb.append('\\');
                    }
                    sb.append(c);
                    idx = ndx - 1;
                }
            }
            ++idx;
        }
        sb.append(']');
        sb.append(';');
    }

    static Fragment createAutoFragment(VersionFormatParser.Instructions instr, Qualifier qualifier) {
        return new AutoFragment(instr, qualifier);
    }

    static Fragment createDelimiterFragment(VersionFormatParser.Instructions instr, Qualifier qualifier) {
        return new DelimiterFragment(instr, qualifier);
    }

    static Fragment createGroupFragment(VersionFormatParser.Instructions instr, Qualifier qualifier, Fragment[] fragments, boolean array) {
        return new GroupFragment(instr, qualifier, fragments, array);
    }

    static Fragment createLiteralFragment(Qualifier qualifier, String literal) {
        return new LiteralFragment(qualifier, literal);
    }

    static Fragment createNumberFragment(VersionFormatParser.Instructions instr, Qualifier qualifier, boolean signed) {
        return new NumberFragment(instr, qualifier, signed);
    }

    static Fragment createPadFragment(Qualifier qualifier) {
        return new PadFragment(qualifier);
    }

    static Fragment createQuotedFragment(VersionFormatParser.Instructions instr, Qualifier qualifier) {
        return new QuotedFragment(instr, qualifier);
    }

    static Fragment createRawFragment(VersionFormatParser.Instructions instr, Qualifier qualifier) {
        return new RawFragment(instr, qualifier);
    }

    static Fragment createStringFragment(VersionFormatParser.Instructions instr, Qualifier qualifier, boolean unbound) {
        return new StringFragment(instr, qualifier, unbound);
    }

    static void toStringEscaped(StringBuffer sb, String value, String escapes) {
        int idx = 0;
        while (idx < value.length()) {
            char c = value.charAt(idx);
            if (c == '\\' || escapes.indexOf(c) >= 0) {
                sb.append('\\');
            }
            sb.append(c);
            ++idx;
        }
    }

    VersionFormat(Fragment topFragment) {
        this.topFragment = topFragment;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof VersionFormat && this.toString().equals(o.toString());
    }

    public int hashCode() {
        return 11 * this.toString().hashCode();
    }

    public Version parse(String version) {
        return this.parse(version, 0, version.length());
    }

    public Version parse(String version, int start, int maxPos) {
        Comparable[] padReturn = new Comparable[1];
        Comparable[] vector = this.parse(version, start, maxPos, padReturn);
        return new Version(vector, padReturn[0], this, version.substring(start, maxPos));
    }

    public synchronized String toString() {
        if (this.fmtString == null) {
            StringBuffer sb = new StringBuffer();
            this.toString(sb);
        }
        return this.fmtString;
    }

    public synchronized void toString(StringBuffer sb) {
        if (this.fmtString != null) {
            sb.append(this.fmtString);
        } else {
            int start = sb.length();
            sb.append("format");
            if (this.topFragment.getPadValue() != null) {
                sb.append('(');
                this.topFragment.toString(sb);
                sb.append(')');
            } else {
                this.topFragment.toString(sb);
            }
            this.fmtString = sb.substring(start);
        }
    }

    TreeInfo createInfo(int start) {
        return new TreeInfo(this.topFragment, start);
    }

    Comparable[] parse(String version, int start, int maxPos, Comparable[] padReturn) {
        ArrayList entries = new ArrayList();
        if (start == maxPos) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.format_0_unable_to_parse_empty_version, (Object)this, (Object)version.substring(start, maxPos)));
        }
        TreeInfo info = new TreeInfo(this.topFragment, start);
        if (!this.topFragment.parse(entries, version, maxPos, info) || info.getPosition() != maxPos) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.format_0_unable_to_parse_1, (Object)this, (Object)version.substring(start, maxPos)));
        }
        Comparable pad = info.getPadValue();
        VersionParser.removeRedundantTrail(entries, pad);
        padReturn[0] = pad;
        return entries.toArray(new Comparable[entries.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readResolve() {
        Map map = formatCache;
        synchronized (map) {
            String string = this.toString();
            VersionFormat fmt = formatCache.put(string, this);
            if (fmt == null) {
                fmt = this;
            } else {
                formatCache.put(string, fmt);
            }
            return fmt;
        }
    }

    private static class AutoFragment
    extends RangeFragment {
        private static final long serialVersionUID = -1016534328164247755L;

        AutoFragment(VersionFormatParser.Instructions instr, Qualifier qualifier) {
            super(instr, qualifier);
        }

        boolean parseOne(List segments, String version, int maxPos, TreeInfo info) {
            int len;
            int pos = info.getPosition();
            maxPos = this.checkRange(pos, maxPos);
            if (maxPos < 0) {
                return false;
            }
            char c = version.charAt(pos);
            if (VersionParser.isDigit(c) && this.isAllowed(c)) {
                int len2;
                int start = pos;
                int value = c - 48;
                while (++pos < maxPos) {
                    c = version.charAt(pos);
                    if (!VersionParser.isDigit(c) || !this.isAllowed(c)) break;
                    value *= 10;
                    value += c - 48;
                }
                if (this.rangeMin > (len2 = pos - start) || len2 > this.rangeMax) {
                    return false;
                }
                if (!this.isIgnored()) {
                    segments.add(Version.valueOf(value));
                }
                info.setPosition(pos);
                return true;
            }
            if (!VersionParser.isLetter(c) || !this.isAllowed(c)) {
                return false;
            }
            int start = pos++;
            while (pos < maxPos) {
                c = version.charAt(pos);
                if (!VersionParser.isLetter(c) || !this.isAllowed(c)) break;
                ++pos;
            }
            if (this.rangeMin > (len = pos - start) || len > this.rangeMax) {
                return false;
            }
            if (!this.isIgnored()) {
                segments.add(version.substring(start, pos));
            }
            info.setPosition(pos);
            return true;
        }

        void toString(StringBuffer sb) {
            sb.append('a');
            super.toString(sb);
        }
    }

    private static class DelimiterFragment
    extends Fragment {
        private static final long serialVersionUID = 8173654376143370605L;
        private final char[] delimChars;
        private final boolean inverted;

        DelimiterFragment(VersionFormatParser.Instructions ep, Qualifier qualifier) {
            super(qualifier);
            if (ep == null) {
                this.delimChars = null;
                this.inverted = false;
            } else {
                this.inverted = ep.inverted;
                this.delimChars = ep.characters;
            }
        }

        boolean isMatch(String version, int pos) {
            char c = version.charAt(pos);
            if (this.delimChars != null) {
                int idx = 0;
                while (idx < this.delimChars.length) {
                    if (c == this.delimChars[idx]) {
                        return !this.inverted;
                    }
                    ++idx;
                }
                return this.inverted;
            }
            return !VersionParser.isLetterOrDigit(c);
        }

        boolean parseOne(List segments, String version, int maxPos, TreeInfo info) {
            int pos = info.getPosition();
            if (pos < maxPos && this.isMatch(version, pos)) {
                info.setPosition(pos + 1);
                return true;
            }
            return false;
        }

        void toString(StringBuffer sb) {
            sb.append('d');
            if (this.delimChars != null) {
                VersionFormat.appendCharacterRange(sb, this.delimChars, this.inverted);
            }
            super.toString(sb);
        }
    }

    private static abstract class ElementFragment
    extends Fragment {
        private static final long serialVersionUID = -6834591415456539713L;
        private final Comparable defaultValue;
        private final boolean ignored;
        private final Comparable padValue;

        ElementFragment(VersionFormatParser.Instructions instr, Qualifier qualifier) {
            super(qualifier);
            if (instr != null) {
                this.ignored = instr.ignore;
                this.defaultValue = instr.defaultValue;
                this.padValue = instr.padValue;
            } else {
                this.ignored = false;
                this.defaultValue = null;
                this.padValue = null;
            }
        }

        Comparable getDefaultValue() {
            return this.defaultValue;
        }

        Comparable getPadValue() {
            return this.padValue;
        }

        boolean isIgnored() {
            return this.ignored;
        }

        void setDefaults(List segments) {
            Comparable defaultVal = this.getDefaultValue();
            if (defaultVal != null) {
                segments.add(defaultVal);
            }
        }

        void toString(StringBuffer sb) {
            if (this.ignored) {
                sb.append('=');
                sb.append('!');
                sb.append(';');
            }
            if (this.defaultValue != null) {
                sb.append('=');
                VersionVector.rawToString(sb, false, this.defaultValue);
                sb.append(';');
            }
            if (this.padValue != null) {
                sb.append('=');
                sb.append('p');
                VersionVector.rawToString(sb, false, this.padValue);
                sb.append(';');
            }
            super.toString(sb);
        }
    }

    static abstract class Fragment
    implements Serializable {
        private static final long serialVersionUID = 4109185333058622681L;
        private final Qualifier qualifier;

        Fragment(Qualifier qualifier) {
            this.qualifier = qualifier;
        }

        public final boolean equals(Object f) {
            return f == this || this.getClass().equals(f.getClass()) && this.qualifier.equals(((Fragment)f).qualifier);
        }

        public final int hashCode() {
            return 11 * this.qualifier.hashCode();
        }

        public boolean isGroup() {
            return false;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            this.toString(sb);
            return sb.toString();
        }

        Comparable getDefaultValue() {
            return null;
        }

        Fragment getFirstLeaf() {
            return this;
        }

        Comparable getPadValue() {
            return null;
        }

        Qualifier getQualifier() {
            return this.qualifier;
        }

        boolean parse(List segments, String version, int maxPos, TreeInfo info) {
            return this.qualifier.parse(new Fragment[]{this}, 0, segments, version, maxPos, info);
        }

        abstract boolean parseOne(List var1, String var2, int var3, TreeInfo var4);

        void setDefaults(List segments) {
        }

        void toString(StringBuffer sb) {
            if (!(this.qualifier == VersionFormatParser.EXACT_ONE_QUALIFIER || this.qualifier == VersionFormatParser.ZERO_OR_ONE_QUALIFIER && this.isGroup())) {
                this.qualifier.toString(sb);
            }
        }
    }

    private static class GroupFragment
    extends ElementFragment {
        private static final long serialVersionUID = 9219978678087669699L;
        private final boolean array;
        private final Fragment[] fragments;

        GroupFragment(VersionFormatParser.Instructions instr, Qualifier qualifier, Fragment[] fragments, boolean array) {
            super(instr, qualifier);
            this.fragments = fragments;
            this.array = array;
        }

        public boolean isGroup() {
            return !this.array;
        }

        Fragment getFirstLeaf() {
            return this.fragments[0].getFirstLeaf();
        }

        boolean parseOne(List segments, String version, int maxPos, TreeInfo info) {
            if (this.array) {
                ArrayList subSegs = new ArrayList();
                boolean success = this.fragments[0].getQualifier().parse(this.fragments, 0, subSegs, version, maxPos, info);
                if (!success || subSegs.isEmpty()) {
                    return false;
                }
                Comparable padValue = info.getPadValue();
                if (padValue != null) {
                    info.setPadValue(null);
                } else {
                    padValue = this.getPadValue();
                }
                VersionParser.removeRedundantTrail(segments, padValue);
                segments.add(new VersionVector(subSegs.toArray(new Comparable[subSegs.size()]), padValue));
                return true;
            }
            if (this.fragments[0].getQualifier().parse(this.fragments, 0, segments, version, maxPos, info)) {
                Comparable padValue = this.getPadValue();
                if (padValue != null) {
                    info.setPadValue(padValue);
                }
                return true;
            }
            return false;
        }

        void setDefaults(List segments) {
            Comparable dflt = this.getDefaultValue();
            if (dflt != null) {
                super.setDefaults(segments);
            } else {
                int idx = 0;
                while (idx < this.fragments.length) {
                    this.fragments[idx].setDefaults(segments);
                    ++idx;
                }
            }
        }

        void toString(StringBuffer sb) {
            if (this.array) {
                sb.append('<');
                int idx = 0;
                while (idx < this.fragments.length) {
                    this.fragments[idx].toString(sb);
                    ++idx;
                }
                sb.append('>');
            } else if (this.getQualifier() == VersionFormatParser.ZERO_OR_ONE_QUALIFIER) {
                sb.append('[');
                int idx = 0;
                while (idx < this.fragments.length) {
                    this.fragments[idx].toString(sb);
                    ++idx;
                }
                sb.append(']');
            } else {
                sb.append('(');
                int idx = 0;
                while (idx < this.fragments.length) {
                    this.fragments[idx].toString(sb);
                    ++idx;
                }
                sb.append(')');
            }
            super.toString(sb);
        }
    }

    private static class LiteralFragment
    extends Fragment {
        private static final long serialVersionUID = 6210696245839471802L;
        private final String string;

        LiteralFragment(Qualifier qualifier, String string) {
            super(qualifier);
            this.string = string;
        }

        boolean parseOne(List segments, String version, int maxPos, TreeInfo info) {
            int litLen;
            int pos = info.getPosition();
            if (pos + (litLen = this.string.length()) > maxPos) {
                return false;
            }
            int idx = 0;
            while (idx < litLen) {
                if (this.string.charAt(idx) != version.charAt(pos)) {
                    return false;
                }
                ++idx;
                ++pos;
            }
            info.setPosition(pos);
            return true;
        }

        void toString(StringBuffer sb) {
            String str = this.string;
            if (str.length() != 1) {
                sb.append('\'');
                VersionFormat.toStringEscaped(sb, str, "'");
                sb.append('\'');
            } else {
                char c = str.charAt(0);
                switch (c) {
                    case '\'': 
                    case '(': 
                    case '*': 
                    case '+': 
                    case '<': 
                    case '=': 
                    case '?': 
                    case '[': 
                    case '\\': 
                    case '{': {
                        sb.append('\\');
                        sb.append(c);
                        break;
                    }
                    default: {
                        if (VersionParser.isLetterOrDigit(c)) {
                            sb.append('\\');
                            sb.append(c);
                            break;
                        }
                        sb.append(c);
                    }
                }
            }
            super.toString(sb);
        }
    }

    private static class NumberFragment
    extends RangeFragment {
        private static final long serialVersionUID = -8552754381106711507L;
        private final boolean signed;

        NumberFragment(VersionFormatParser.Instructions instr, Qualifier qualifier, boolean signed) {
            super(instr, qualifier);
            this.signed = signed;
        }

        boolean parseOne(List segments, String version, int maxPos, TreeInfo info) {
            int len;
            int value;
            int pos = info.getPosition();
            maxPos = this.checkRange(pos, maxPos);
            if (maxPos < 0) {
                return false;
            }
            int start = pos;
            char c = version.charAt(pos);
            if (this.signed || this.characters != null) {
                boolean negate = false;
                if (this.signed && c == '-' && pos + 1 < maxPos) {
                    negate = true;
                    c = version.charAt(++pos);
                }
                if (c < '0' || c > '9' || !this.isAllowed(c)) {
                    return false;
                }
                value = c - 48;
                while (++pos < maxPos) {
                    c = version.charAt(pos);
                    if (c < '0' || c > '9' || !this.isAllowed(c)) break;
                    value *= 10;
                    value += c - 48;
                }
                if (negate) {
                    value = -value;
                }
            } else {
                if (c < '0' || c > '9') {
                    return false;
                }
                value = c - 48;
                while (++pos < maxPos) {
                    c = version.charAt(pos);
                    if (c < '0' || c > '9') break;
                    value *= 10;
                    value += c - 48;
                }
            }
            if (this.rangeMin > (len = pos - start) || len > this.rangeMax) {
                return false;
            }
            if (!this.isIgnored()) {
                segments.add(Version.valueOf(value));
            }
            info.setPosition(pos);
            return true;
        }

        void toString(StringBuffer sb) {
            sb.append(this.signed ? (char)'N' : 'n');
            super.toString(sb);
        }
    }

    private static class PadFragment
    extends ElementFragment {
        private static final long serialVersionUID = 5052010199974380170L;

        PadFragment(Qualifier qualifier) {
            super(null, qualifier);
        }

        boolean parseOne(List segments, String version, int maxPos, TreeInfo info) {
            int[] position;
            Comparable v;
            int pos = info.getPosition();
            if (pos >= maxPos || version.charAt(pos) != 'p') {
                return false;
            }
            if ((v = VersionParser.parseRawElement(version, position = new int[]{++pos}, maxPos)) == null) {
                return false;
            }
            if (!this.isIgnored()) {
                info.setPadValue(v);
            }
            info.setPosition(position[0]);
            return true;
        }

        void toString(StringBuffer sb) {
            sb.append('p');
            super.toString(sb);
        }
    }

    static class Qualifier
    implements Serializable {
        private static final long serialVersionUID = 7494021832824671685L;
        private final int max;
        private final int min;

        Qualifier(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Qualifier)) {
                return false;
            }
            Qualifier oq = (Qualifier)o;
            return this.min == oq.min && this.max == oq.max;
        }

        public int hashCode() {
            return 31 * this.min + 67 * this.max;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            this.toString(sb);
            return sb.toString();
        }

        int getMax() {
            return this.max;
        }

        int getMin() {
            return this.min;
        }

        boolean parse(Fragment[] fragments, int fragIdx, List segments, String version, int maxPos, TreeInfo info) {
            Fragment fragment = fragments[fragIdx++];
            int idx = 0;
            while (idx < this.min) {
                if (!fragment.parseOne(segments, version, maxPos, info)) {
                    return false;
                }
                ++idx;
            }
            while (idx < this.max) {
                info.pushState(segments.size(), fragment);
                if (!fragment.parseOne(segments, version, maxPos, info)) {
                    info.popState(segments, fragment);
                    break;
                }
                ++idx;
            }
            int maxParsed = idx;
            while (true) {
                if (this.max != Integer.MAX_VALUE) {
                    while (idx < this.max) {
                        fragment.setDefaults(segments);
                        ++idx;
                    }
                }
                if (fragIdx == fragments.length) {
                    return true;
                }
                if (fragments[fragIdx].getQualifier().parse(fragments, fragIdx, segments, version, maxPos, info)) {
                    return true;
                }
                if (maxParsed <= this.min) {
                    return false;
                }
                info.popState(segments, fragment);
                idx = --maxParsed;
            }
        }

        void toString(StringBuffer sb) {
            if (this.min == 0) {
                if (this.max == 1) {
                    sb.append('?');
                } else if (this.max == Integer.MAX_VALUE) {
                    sb.append('*');
                } else {
                    sb.append('{');
                    sb.append(this.min);
                    sb.append(',');
                    sb.append(this.max);
                    sb.append('}');
                }
            } else if (this.max == Integer.MAX_VALUE) {
                if (this.min == 1) {
                    sb.append('+');
                } else {
                    sb.append('{');
                    sb.append(this.min);
                    sb.append(",}");
                }
            } else {
                sb.append('{');
                sb.append(this.min);
                if (this.min != this.max) {
                    sb.append(',');
                    sb.append(this.max);
                }
                sb.append('}');
            }
        }

        private Object readResolve() {
            Qualifier q = this;
            if (this.min == 0) {
                if (this.max == 1) {
                    q = VersionFormatParser.ZERO_OR_ONE_QUALIFIER;
                } else if (this.max == Integer.MAX_VALUE) {
                    q = VersionFormatParser.ZERO_OR_MANY_QUALIFIER;
                }
            } else if (this.min == 1) {
                if (this.max == 1) {
                    q = VersionFormatParser.EXACT_ONE_QUALIFIER;
                } else if (this.max == Integer.MAX_VALUE) {
                    q = VersionFormatParser.ONE_OR_MANY_QUALIFIER;
                }
            }
            return q;
        }
    }

    private static class QuotedFragment
    extends RangeFragment {
        private static final long serialVersionUID = 6057751133533608969L;

        QuotedFragment(VersionFormatParser.Instructions instr, Qualifier qualifier) {
            super(instr, qualifier);
        }

        boolean parseOne(List segments, String version, int maxPos, TreeInfo info) {
            char endQuote;
            int pos = info.getPosition();
            if (pos >= maxPos) {
                return false;
            }
            char quote = version.charAt(pos);
            switch (quote) {
                case '<': {
                    endQuote = '>';
                    break;
                }
                case '{': {
                    endQuote = '}';
                    break;
                }
                case '(': {
                    endQuote = ')';
                    break;
                }
                case '[': {
                    endQuote = ']';
                    break;
                }
                case '>': {
                    endQuote = '<';
                    break;
                }
                case '}': {
                    endQuote = '{';
                    break;
                }
                case ')': {
                    endQuote = '(';
                    break;
                }
                case ']': {
                    endQuote = '[';
                    break;
                }
                default: {
                    if (VersionParser.isLetterOrDigit(quote)) {
                        return false;
                    }
                    endQuote = quote;
                }
            }
            int start = ++pos;
            char c = version.charAt(pos);
            while (c != endQuote && this.isAllowed(c) && ++pos < maxPos) {
                c = version.charAt(pos);
            }
            if (c != endQuote || this.rangeMin > pos - start) {
                return false;
            }
            int len = pos - start;
            if (this.rangeMin > len || len > this.rangeMax) {
                return false;
            }
            if (!this.isIgnored()) {
                segments.add(version.substring(start, pos));
            }
            info.setPosition(++pos);
            return true;
        }

        void toString(StringBuffer sb) {
            sb.append('q');
            super.toString(sb);
        }
    }

    private static abstract class RangeFragment
    extends ElementFragment {
        private static final long serialVersionUID = -6680402803630334708L;
        final char[] characters;
        final boolean inverted;
        final int rangeMax;
        final int rangeMin;

        RangeFragment(VersionFormatParser.Instructions instr, Qualifier qualifier) {
            super(instr, qualifier);
            if (instr == null) {
                this.characters = null;
                this.inverted = false;
                this.rangeMin = 0;
                this.rangeMax = Integer.MAX_VALUE;
            } else {
                this.characters = instr.characters;
                this.inverted = instr.inverted;
                this.rangeMin = instr.rangeMin;
                this.rangeMax = instr.rangeMax;
            }
        }

        int checkRange(int pos, int maxPos) {
            int check = pos;
            check = this.rangeMin == 0 ? ++check : (check += this.rangeMin);
            if (check > maxPos) {
                maxPos = -1;
            } else if (this.rangeMax != Integer.MAX_VALUE && (check = pos + this.rangeMax) < maxPos) {
                maxPos = check;
            }
            return maxPos;
        }

        boolean isAllowed(char c) {
            char[] crs = this.characters;
            if (crs != null) {
                int idx = crs.length;
                while (--idx >= 0) {
                    if (c != crs[idx]) continue;
                    return !this.inverted;
                }
                return this.inverted;
            }
            return true;
        }

        void toString(StringBuffer sb) {
            if (this.characters != null) {
                VersionFormat.appendCharacterRange(sb, this.characters, this.inverted);
            }
            if (this.rangeMin != 0 || this.rangeMax != Integer.MAX_VALUE) {
                sb.append('=');
                sb.append('{');
                sb.append(this.rangeMin);
                if (this.rangeMin != this.rangeMax) {
                    sb.append(',');
                    if (this.rangeMax != Integer.MAX_VALUE) {
                        sb.append(this.rangeMax);
                    }
                }
                sb.append('}');
                sb.append(';');
            }
            super.toString(sb);
        }
    }

    private static class RawFragment
    extends ElementFragment {
        private static final long serialVersionUID = 4107448125256042602L;

        RawFragment(VersionFormatParser.Instructions processing, Qualifier qualifier) {
            super(processing, qualifier);
        }

        boolean parseOne(List segments, String version, int maxPos, TreeInfo info) {
            int[] position = new int[]{info.getPosition()};
            Comparable v = VersionParser.parseRawElement(version, position, maxPos);
            if (v == null) {
                return false;
            }
            if (!this.isIgnored()) {
                segments.add(v);
            }
            info.setPosition(position[0]);
            return true;
        }

        void toString(StringBuffer sb) {
            sb.append('r');
            super.toString(sb);
        }
    }

    private static class StringFragment
    extends RangeFragment {
        private static final long serialVersionUID = -2265924553606430164L;
        final boolean anyChar;

        StringFragment(VersionFormatParser.Instructions instr, Qualifier qualifier, boolean noLimit) {
            super(instr, qualifier);
            this.anyChar = noLimit;
        }

        /*
         * Unable to fully structure code
         */
        boolean parseOne(List segments, String version, int maxPos, TreeInfo info) {
            block7: {
                block8: {
                    pos = info.getPosition();
                    maxPos = this.checkRange(pos, maxPos);
                    if (maxPos < 0) {
                        return false;
                    }
                    start = pos;
                    if (this.characters == null) break block8;
                    if (!this.anyChar) ** GOTO lbl16
                    while (pos < maxPos) {
                        if (this.isAllowed(version.charAt(pos))) {
                            ++pos;
                            continue;
                        }
                        break block7;
                    }
                    break block7;
                    while (VersionParser.isLetter(c = version.charAt(pos)) && this.isAllowed(c)) {
                        ++pos;
lbl16:
                        // 2 sources

                        if (pos < maxPos) continue;
                        break block7;
                    }
                    break block7;
                }
                if (!this.anyChar) ** GOTO lbl25
                pos = maxPos;
                break block7;
                while (VersionParser.isLetter(version.charAt(pos))) {
                    ++pos;
lbl25:
                    // 2 sources

                    if (pos < maxPos) continue;
                }
            }
            len = pos - start;
            if (len == 0 || this.rangeMin > len || len > this.rangeMax) {
                return false;
            }
            if (!this.isIgnored()) {
                segments.add(version.substring(start, pos));
            }
            info.setPosition(pos);
            return true;
        }

        void toString(StringBuffer sb) {
            sb.append(this.anyChar ? (char)'S' : 's');
            super.toString(sb);
        }
    }

    private static class TreeInfo
    extends ArrayList {
        private static final long serialVersionUID = 4770093863009659750L;
        private Comparable padValue;
        private int top;

        TreeInfo(Fragment frag, int pos) {
            this.add(new StateInfo(pos, 0, frag));
            this.top = 0;
        }

        Comparable getPadValue() {
            return this.padValue;
        }

        int getPosition() {
            return ((StateInfo)this.get((int)this.top)).position;
        }

        void popState(List segments, Fragment frag) {
            int idx = this.top;
            while (idx > 0) {
                StateInfo si = (StateInfo)this.get(idx);
                if (si.fragment != frag) continue;
                int nsegs = segments.size();
                int segMax = si.segmentCount;
                while (nsegs > segMax) {
                    segments.remove(--nsegs);
                }
                this.top = idx - 1;
                break;
            }
        }

        void pushState(int segCount, Fragment fragment) {
            int pos = ((StateInfo)this.get((int)this.top)).position;
            if (++this.top == this.size()) {
                this.add(new StateInfo(pos, segCount, fragment));
            } else {
                StateInfo si = (StateInfo)this.get(this.top);
                si.fragment = fragment;
                si.position = pos;
                si.segmentCount = segCount;
            }
        }

        void setPadValue(Comparable pad) {
            this.padValue = pad;
        }

        void setPosition(int pos) {
            ((StateInfo)this.get((int)this.top)).position = pos;
        }

        private static class StateInfo {
            Fragment fragment;
            int segmentCount;
            int position;

            StateInfo(int position, int segmentCount, Fragment fragment) {
                this.fragment = fragment;
                this.position = position;
                this.segmentCount = segmentCount;
            }
        }
    }
}

