/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl.helper;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.felix.cm.impl.helper.TargetedPID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigurationMap<T> {
    private Map<String, T> configurations = Collections.emptyMap();

    protected ConfigurationMap(String[] configuredPids) {
        this.setConfiguredPids(configuredPids);
    }

    protected abstract Map<String, T> createMap(int var1);

    protected abstract boolean shallTake(TargetedPID var1, TargetedPID var2, long var3);

    protected abstract void record(TargetedPID var1, TargetedPID var2, long var3);

    protected abstract boolean removeConfiguration(TargetedPID var1, TargetedPID var2);

    protected T get(TargetedPID key) {
        String servicePid = this.getKeyPid(key);
        if (servicePid != null) {
            return this.configurations.get(servicePid);
        }
        return null;
    }

    protected void put(TargetedPID key, T value) {
        String servicePid = this.getKeyPid(key);
        if (servicePid != null) {
            this.configurations.put(servicePid, value);
        }
    }

    protected String getKeyPid(TargetedPID targetedPid) {
        if (this.accepts(targetedPid.getServicePid())) {
            return targetedPid.getServicePid();
        }
        if (this.accepts(targetedPid.getRawPid())) {
            return targetedPid.getRawPid();
        }
        return null;
    }

    public boolean accepts(String servicePid) {
        return this.configurations.containsKey(servicePid);
    }

    public void setConfiguredPids(String[] configuredPids) {
        Map<Object, Object> newConfigs;
        if (configuredPids != null) {
            newConfigs = this.createMap(configuredPids.length);
            for (String pid : configuredPids) {
                newConfigs.put(pid, this.configurations.get(pid));
            }
        } else {
            newConfigs = Collections.emptyMap();
        }
        this.configurations = newConfigs;
    }

    boolean isDifferentPids(String[] pids) {
        HashSet<String> otherPids;
        if (this.configurations.isEmpty() && pids == null) {
            return false;
        }
        if (this.configurations.isEmpty()) {
            return true;
        }
        if (pids == null) {
            return true;
        }
        if (this.configurations.size() != pids.length) {
            return true;
        }
        Set<String> thisPids = this.configurations.keySet();
        return !thisPids.equals(otherPids = new HashSet<String>(Arrays.asList(pids)));
    }
}

