/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.log;

import java.util.ArrayList;
import java.util.List;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;

final class LogListenerThread
extends Thread {
    private final List<LogEntry> m_entriesToDeliver = new ArrayList<LogEntry>();
    private final List<LogListener> m_listeners = new ArrayList<LogListener>();

    LogListenerThread() {
        super("FelixLogListener");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEntry(LogEntry entry) {
        List<LogEntry> list = this.m_entriesToDeliver;
        synchronized (list) {
            this.m_entriesToDeliver.add(entry);
            this.m_entriesToDeliver.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(LogListener listener) {
        List<LogListener> list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(LogListener listener) {
        List<LogListener> list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getListenerCount() {
        List<LogListener> list = this.m_listeners;
        synchronized (list) {
            return this.m_listeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        List<LogEntry> list = this.m_entriesToDeliver;
        synchronized (list) {
            this.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isInterrupted()) {
            ArrayList<LogEntry> entriesToDeliver = new ArrayList<LogEntry>();
            List<LogEntry> list = this.m_entriesToDeliver;
            synchronized (list) {
                if (this.m_entriesToDeliver.isEmpty()) {
                    try {
                        this.m_entriesToDeliver.wait();
                    }
                    catch (InterruptedException e) {
                        this.interrupt();
                    }
                } else {
                    entriesToDeliver.addAll(this.m_entriesToDeliver);
                    this.m_entriesToDeliver.clear();
                }
            }
            if (entriesToDeliver.isEmpty()) continue;
            ArrayList<LogListener> listeners = new ArrayList<LogListener>();
            List<LogListener> e = this.m_listeners;
            synchronized (e) {
                listeners.addAll(this.m_listeners);
            }
            for (LogEntry entry : entriesToDeliver) {
                for (LogListener listener : listeners) {
                    try {
                        listener.logged(entry);
                    }
                    catch (Throwable t) {
                        System.err.println("Logger failed to log with " + t.getMessage());
                        t.printStackTrace(System.err);
                    }
                }
            }
        }
    }
}

