/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class Brazil
extends DelegateCalendar {
    private static final Brazil SETTLEMENT_CALENDAR = new Brazil(Market.SETTLEMENT);
    private static final Brazil EXCHANGE_CALENDAR = new Brazil(Market.BOVESPA);

    private Brazil(Market market) {
        WesternCalendar delegate;
        switch (market) {
            case SETTLEMENT: {
                delegate = new BrazilSettlementCalendar();
                break;
            }
            case BOVESPA: {
                delegate = new BrazilExchangeCalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static Brazil getCalendar(Market market) {
        switch (market) {
            case SETTLEMENT: {
                return SETTLEMENT_CALENDAR;
            }
            case BOVESPA: {
                return EXCHANGE_CALENDAR;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class BrazilExchangeCalendar
    extends WesternCalendar {
        private BrazilExchangeCalendar() {
        }

        @Override
        public String getName() {
            return "BOVESPA";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int dd = date.getDayOfYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.JANUARY || d == 25 && m == Month.JANUARY || d == 21 && m == Month.APRIL || d == 1 && m == Month.MAY || d == 9 && m == Month.JULY || d == 20 && m == Month.NOVEMBER && y >= 2007 || d == 24 && m == Month.DECEMBER || d == 25 && m == Month.DECEMBER || dd == em - 3 || dd == em - 49 || dd == em - 48 || dd == em + 59) && (m != Month.DECEMBER || d != 31 && (d < 29 || w != Weekday.FRIDAY));
        }
    }

    private static final class BrazilSettlementCalendar
    extends WesternCalendar {
        private BrazilSettlementCalendar() {
        }

        @Override
        public String getName() {
            return "Brazil";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int dd = date.getDayOfYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.JANUARY || d == 21 && m == Month.APRIL || d == 1 && m == Month.MAY || d == 7 && m == Month.SEPTEMBER || d == 12 && m == Month.OCTOBER || d == 2 && m == Month.NOVEMBER || d == 15 && m == Month.NOVEMBER || d == 25 && m == Month.DECEMBER || dd == em - 3 || dd == em - 49 || dd == em - 48) && dd != em + 59;
        }
    }

    public static enum Market {
        SETTLEMENT,
        BOVESPA;

    }
}

