/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.processes;

import org.jquantlib.processes.Discretization1D;
import org.jquantlib.processes.LinearDiscretization;
import org.jquantlib.processes.StochasticProcess;

public abstract class StochasticProcess1D
extends StochasticProcess {
    protected Discretization1D discretization1D;
    private static final String ARRAY_1D_REQUIRED = "1-D array required";

    protected StochasticProcess1D(LinearDiscretization discretization) {
        super(discretization);
        this.discretization1D = discretization;
    }

    public abstract double x0();

    public abstract double drift(double var1, double var3);

    public abstract double diffusion(double var1, double var3);

    public final double expectation(double t0, double x0, double dt) {
        return this.apply(x0, this.discretization1D.driftDiscretization(this, t0, x0, dt));
    }

    public final double stdDeviation(double t0, double x0, double dt) {
        return this.discretization1D.diffusionDiscretization(this, t0, x0, dt);
    }

    public final double variance(double t0, double x0, double dt) {
        return this.discretization1D.varianceDiscretization(this, t0, x0, dt);
    }

    public final double evolve(double t0, double x0, double dt, double dw) {
        return this.apply(this.expectation(t0, x0, dt), this.stdDeviation(t0, x0, dt) * dw);
    }

    public double apply(double x0, double dx) {
        return x0 + dx;
    }

    @Override
    public final int getSize() {
        return 1;
    }

    @Override
    public final double[] initialValues() {
        return new double[]{this.x0()};
    }

    @Override
    public final double[] drift(double t, double[] x) {
        if (x.length != 1) {
            throw new IllegalArgumentException(ARRAY_1D_REQUIRED);
        }
        return new double[]{this.drift(t, x[0])};
    }

    @Override
    public final double[][] diffusion(double t, double[] x) {
        if (x.length != 1) {
            throw new IllegalArgumentException(ARRAY_1D_REQUIRED);
        }
        double v = this.diffusion(t, x[0]);
        return new double[][]{{v}};
    }

    @Override
    public final double[] expectation(double t0, double[] x0, double dt) {
        if (x0.length != 1) {
            throw new IllegalArgumentException(ARRAY_1D_REQUIRED);
        }
        return new double[]{this.expectation(t0, x0[0], dt)};
    }

    @Override
    public final double[][] stdDeviation(double t0, double[] x0, double dt) {
        if (x0.length != 1) {
            throw new IllegalArgumentException(ARRAY_1D_REQUIRED);
        }
        double v = this.stdDeviation(t0, x0[0], dt);
        return new double[][]{{v}};
    }

    @Override
    public final double[][] covariance(double t0, double[] x0, double dt) {
        if (x0.length != 1) {
            throw new IllegalArgumentException(ARRAY_1D_REQUIRED);
        }
        double v = this.discretization1D.varianceDiscretization(this, t0, x0[0], dt);
        return new double[][]{{v}};
    }

    @Override
    public final double[] evolve(double t0, double[] x0, double dt, double[] dw) {
        if (x0.length != 1) {
            throw new IllegalArgumentException(ARRAY_1D_REQUIRED);
        }
        if (dw.length != 1) {
            throw new IllegalArgumentException(ARRAY_1D_REQUIRED);
        }
        return new double[]{this.evolve(t0, x0[0], dt, dw[0])};
    }

    @Override
    public final double[] apply(double[] x0, double[] dx) {
        if (x0.length != 1) {
            throw new IllegalArgumentException(ARRAY_1D_REQUIRED);
        }
        if (dx.length != 1) {
            throw new IllegalArgumentException(ARRAY_1D_REQUIRED);
        }
        return new double[]{this.apply(x0[0], dx[0])};
    }
}

