/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.integrals;

import org.jquantlib.math.UnaryFunctionDouble;
import org.jquantlib.math.integrals.Integrator;

public class TrapezoidIntegral
extends Integrator {
    protected Method method;

    public TrapezoidIntegral(double accuracy) {
        this(accuracy, 1000);
    }

    public TrapezoidIntegral(double accuracy, int maxEvaluations) {
        this(accuracy, Method.Default, maxEvaluations);
    }

    public TrapezoidIntegral(double accuracy, Method method, int maxEvaluations) {
        super(accuracy, maxEvaluations);
        this.method = method;
    }

    protected final double defaultIteration(UnaryFunctionDouble f, double a, double b, double I, int N) {
        double sum = 0.0;
        double dx = (b - a) / (double)N;
        double x = a + dx / 2.0;
        for (int i = 0; i < N; ++i) {
            sum += f.evaluate(x);
            x += dx;
        }
        return (I + dx * sum) / 2.0;
    }

    protected final double midPointIteration(UnaryFunctionDouble f, double a, double b, double I, double N) {
        double sum = 0.0;
        double dx = (b - a) / N;
        double x = a + dx / 6.0;
        double D = 2.0 * dx / 3.0;
        int i = 0;
        while ((double)i < N) {
            sum += f.evaluate(x) + f.evaluate(x + D);
            x += dx;
            ++i;
        }
        return (I + dx * sum) / 3.0;
    }

    protected Method getMethod() {
        return this.method;
    }

    @Override
    protected double integrate(UnaryFunctionDouble f, double a, double b) {
        int N = 1;
        double I = (f.evaluate(a) + f.evaluate(b)) * (b - a) / 2.0;
        int i = 1;
        do {
            double newI;
            switch (this.method) {
                case MidPoint: {
                    newI = this.midPointIteration(f, a, b, I, N);
                    N *= 3;
                    break;
                }
                default: {
                    newI = this.defaultIteration(f, a, b, I, N);
                    N *= 2;
                }
            }
            if (Math.abs(I - newI) <= this.getAbsoluteAccuracy() && i > 5) {
                return newI;
            }
            I = newI;
        } while (++i < this.getMaxEvaluations());
        throw new ArithmeticException("max number of iterations reached");
    }

    public static enum Method {
        Default,
        MidPoint;

    }
}

