/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.jetty.internal.JettyConfig;
import org.eclipse.jetty.server.AsyncNCSARequestLog;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

class FileRequestLog {
    public static final String SVC_PROP_NAME = "name";
    public static final String DEFAULT_NAME = "file";
    public static final String SVC_PROP_FILEPATH = "filepath";
    private final NCSARequestLog delegate;
    private final String logFilePath;
    private final String serviceName;
    private ServiceRegistration<RequestLog> registration = null;

    FileRequestLog(JettyConfig config) {
        this.logFilePath = config.getRequestLogFilePath();
        this.serviceName = config.getRequestLogFileServiceName() != null ? config.getRequestLogFileServiceName() : DEFAULT_NAME;
        this.delegate = config.isRequestLogFileAsync() ? new AsyncNCSARequestLog(this.logFilePath, null) : new NCSARequestLog(this.logFilePath);
        this.delegate.setAppend(config.isRequestLogFileAppend());
        this.delegate.setRetainDays(config.getRequestLogFileRetainDays());
        this.delegate.setFilenameDateFormat(config.getRequestLogFilenameDateFormat());
        this.delegate.setExtended(config.isRequestLogFileExtended());
        this.delegate.setIgnorePaths(config.getRequestLogFileIgnorePaths());
        this.delegate.setLogCookies(config.isRequestLogFileLogCookies());
        this.delegate.setLogServer(config.isRequestLogFileLogServer());
        this.delegate.setLogLatency(config.isRequestLogFileLogLatency());
        if (config.getRequestLogDateFormat() != null) {
            this.delegate.setLogDateFormat(config.getRequestLogDateFormat());
        }
        if (config.getRequestLogTimeZone() != null) {
            this.delegate.setLogTimeZone(config.getRequestLogTimeZone());
        }
    }

    synchronized void start(BundleContext context) throws IOException, IllegalStateException {
        File logFile = new File(this.logFilePath).getAbsoluteFile();
        File logFileDir = logFile.getParentFile();
        if (logFileDir != null && !logFileDir.isDirectory()) {
            SystemLogger.info("Creating directory " + logFileDir.getAbsolutePath());
            Files.createDirectories(logFileDir.toPath(), PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------")));
        }
        if (this.registration != null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " is already started");
        }
        try {
            this.delegate.start();
            Hashtable<String, String> svcProps = new Hashtable<String, String>();
            ((Dictionary)svcProps).put(SVC_PROP_NAME, this.serviceName);
            ((Dictionary)svcProps).put(SVC_PROP_FILEPATH, this.logFilePath);
            this.registration = context.registerService(RequestLog.class, (Object)this.delegate, svcProps);
        }
        catch (Exception e) {
            SystemLogger.error("Error starting File Request Log", e);
        }
    }

    synchronized void stop() {
        try {
            if (this.registration != null) {
                this.registration.unregister();
            }
            this.delegate.stop();
        }
        catch (Exception e) {
            SystemLogger.error("Error shutting down File Request Log", e);
        }
        finally {
            this.registration = null;
        }
    }
}

