/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.async.promise;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.osgi.util.function.Function;
import org.osgi.util.function.Predicate;
import org.osgi.util.promise.Failure;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.Success;

public class PromiseImpl<T>
implements Promise<T> {
    private final ExecutorService exec;
    private final List<Runnable> tasks = new ArrayList<Runnable>();
    private final CountDownLatch resolved = new CountDownLatch(1);
    private List<PromiseImpl> chain;
    private Success onSuccess;
    private Failure onFailure;
    private Throwable failure;
    private T value;

    public PromiseImpl() {
        this.exec = Executors.newSingleThreadExecutor();
    }

    public void fail(Throwable failure) {
        if (failure == null) {
            throw new NullPointerException();
        }
        this.complete(null, failure);
    }

    public void resolve(T value) {
        this.complete(value, null);
    }

    public Promise<Void> resolveWith(Promise<? extends T> with) {
        if (with == null) {
            throw new NullPointerException();
        }
        final PromiseImpl<Void> result = new PromiseImpl<Void>();
        with.then(new Success<T, T>(){

            @Override
            public Promise<T> call(Promise<T> resolved) throws Exception {
                if (PromiseImpl.this.isDone()) {
                    result.fail(new IllegalStateException("associated Promise already resolved"));
                }
                PromiseImpl.this.resolve(resolved.getValue());
                result.resolve(null);
                return null;
            }
        }, new Failure(){

            @Override
            public void fail(Promise<?> resolved) throws Exception {
                if (PromiseImpl.this.isDone()) {
                    result.fail(new IllegalStateException("associated Promise already resolved"));
                }
                PromiseImpl.this.fail(resolved.getFailure());
                result.resolve(null);
            }
        });
        return result;
    }

    private synchronized void complete(T value, Throwable failure) {
        if (this.isDone()) {
            throw new IllegalStateException("Promise is already resolved");
        }
        if (failure != null) {
            this.failure = failure;
        } else {
            this.value = value;
        }
        this.resolved.countDown();
        if (this.chain != null) {
            this.runChain();
        }
        for (Runnable task : this.tasks) {
            this.exec.submit(task);
        }
    }

    private void runChain() {
        while (!this.chain.isEmpty()) {
            PromiseImpl next = this.chain.remove(0);
            if (this.failure != null) {
                try {
                    if (next.onFailure != null) {
                        next.onFailure.fail(this);
                    }
                    next.fail(this.failure);
                }
                catch (Exception e) {
                    next.fail(e);
                }
                continue;
            }
            try {
                Promise p = null;
                if (next.onSuccess != null) {
                    p = next.onSuccess.call(this);
                }
                if (p == null) {
                    next.resolve(null);
                    continue;
                }
                next.resolveWith(p);
            }
            catch (InvocationTargetException e) {
                next.fail(e.getCause());
            }
            catch (Exception e) {
                next.fail(e);
            }
        }
    }

    @Override
    public boolean isDone() {
        return this.resolved.getCount() == 0L;
    }

    @Override
    public T getValue() throws InvocationTargetException, InterruptedException {
        this.resolved.await();
        if (this.failure != null) {
            throw new InvocationTargetException(this.failure);
        }
        return this.value;
    }

    @Override
    public Throwable getFailure() throws InterruptedException {
        this.resolved.await();
        return this.failure;
    }

    @Override
    public synchronized Promise<T> onResolve(Runnable callback) {
        if (callback == null) {
            throw new NullPointerException();
        }
        if (this.isDone()) {
            this.exec.submit(callback);
        } else {
            this.tasks.add(callback);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> Promise<R> then(Success<? super T, ? extends R> success, Failure failure) {
        PromiseImpl<T> result = new PromiseImpl<T>();
        result.onSuccess = success;
        result.onFailure = failure;
        PromiseImpl promiseImpl = this;
        synchronized (promiseImpl) {
            if (this.chain == null) {
                this.chain = new ArrayList<PromiseImpl>();
            }
            this.chain.add(result);
            if (this.isDone()) {
                this.runChain();
            }
        }
        return result;
    }

    @Override
    public <R> Promise<R> then(Success<? super T, ? extends R> success) {
        return this.then(success, null);
    }

    @Override
    public Promise<T> filter(final Predicate<? super T> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        final PromiseImpl<T> result = new PromiseImpl<T>();
        this.then(new Success<T, T>(){

            @Override
            public Promise<T> call(Promise<T> resolved) throws Exception {
                try {
                    if (predicate.test(resolved.getValue())) {
                        result.resolve(resolved.getValue());
                    } else {
                        result.fail(new NoSuchElementException("predicate does not accept value"));
                    }
                }
                catch (Throwable t) {
                    result.fail(t);
                }
                return null;
            }
        }, new Failure(){

            @Override
            public void fail(Promise<?> resolved) throws Exception {
                result.fail(resolved.getFailure());
            }
        });
        return result;
    }

    @Override
    public <R> Promise<R> map(final Function<? super T, ? extends R> mapper) {
        if (mapper == null) {
            throw new NullPointerException();
        }
        final PromiseImpl<T> result = new PromiseImpl<T>();
        this.then(new Success<T, T>(){

            @Override
            public Promise<T> call(Promise<T> resolved) throws Exception {
                try {
                    Object val = mapper.apply(resolved.getValue());
                    result.resolve(val);
                }
                catch (Throwable t) {
                    result.fail(t);
                }
                return null;
            }
        }, new Failure(){

            @Override
            public void fail(Promise<?> resolved) throws Exception {
                result.fail(resolved.getFailure());
            }
        });
        return result;
    }

    @Override
    public <R> Promise<R> flatMap(final Function<? super T, Promise<? extends R>> mapper) {
        if (mapper == null) {
            throw new NullPointerException();
        }
        final PromiseImpl<T> result = new PromiseImpl<T>();
        this.then(new Success<T, T>(){

            @Override
            public Promise<T> call(Promise<T> resolved) throws Exception {
                try {
                    Promise p = (Promise)mapper.apply(resolved.getValue());
                    result.resolveWith(p);
                }
                catch (Throwable t) {
                    result.fail(t);
                }
                return null;
            }
        }, new Failure(){

            @Override
            public void fail(Promise<?> resolved) throws Exception {
                result.fail(resolved.getFailure());
            }
        });
        return result;
    }

    @Override
    public Promise<T> recover(final Function<Promise<?>, ? extends T> recovery) {
        if (recovery == null) {
            throw new NullPointerException();
        }
        final PromiseImpl<T> result = new PromiseImpl<T>();
        this.then(new Success<T, T>(){

            @Override
            public Promise<T> call(Promise<T> resolved) throws Exception {
                result.resolve(resolved.getValue());
                return null;
            }
        }, new Failure(){

            @Override
            public void fail(Promise<?> resolved) throws Exception {
                try {
                    Object recover = recovery.apply(resolved);
                    if (recover != null) {
                        result.resolve(recover);
                    } else {
                        result.fail(resolved.getFailure());
                    }
                }
                catch (Throwable t) {
                    result.fail(t);
                }
            }
        });
        return result;
    }

    @Override
    public Promise<T> recoverWith(final Function<Promise<?>, Promise<? extends T>> recovery) {
        if (recovery == null) {
            throw new NullPointerException();
        }
        final PromiseImpl<T> result = new PromiseImpl<T>();
        this.then(new Success<T, T>(){

            @Override
            public Promise<T> call(Promise<T> resolved) throws Exception {
                result.resolve(resolved.getValue());
                return null;
            }
        }, new Failure(){

            @Override
            public void fail(Promise<?> resolved) throws Exception {
                try {
                    Promise recover = (Promise)recovery.apply(resolved);
                    if (recover != null) {
                        result.resolveWith(recover);
                    } else {
                        result.fail(resolved.getFailure());
                    }
                }
                catch (Throwable t) {
                    result.fail(t);
                }
            }
        });
        return result;
    }

    @Override
    public Promise<T> fallbackTo(final Promise<? extends T> fallback) {
        if (fallback == null) {
            throw new NullPointerException();
        }
        final PromiseImpl<T> result = new PromiseImpl<T>();
        this.then(new Success<T, T>(){

            @Override
            public Promise<T> call(Promise<T> resolved) throws Exception {
                result.resolve(resolved.getValue());
                return null;
            }
        }, new Failure(){

            @Override
            public void fail(Promise<?> resolved) throws Exception {
                Throwable fail = fallback.getFailure();
                if (fail != null) {
                    result.fail(resolved.getFailure());
                } else {
                    result.resolve(fallback.getValue());
                }
            }
        });
        return result;
    }
}

