/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.async.impl;

import java.lang.reflect.InvocationTargetException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.aries.async.impl.MethodCall;
import org.osgi.util.promise.Deferred;

public class Work<T>
implements Runnable {
    private final MethodCall methodCall;
    private final Deferred<T> deferred;
    private final AccessControlContext acc;

    public Work(MethodCall methodCall, Deferred<T> deferred) {
        this.methodCall = methodCall;
        this.deferred = deferred;
        this.acc = AccessController.getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            final Object service = this.methodCall.getService();
            this.methodCall.method.setAccessible(true);
            Object returnValue = AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){

                @Override
                public T run() throws Exception {
                    return ((Work)Work.this).methodCall.method.invoke(service, ((Work)Work.this).methodCall.arguments);
                }
            }, this.acc);
            this.deferred.resolve(returnValue);
        }
        catch (PrivilegedActionException pae) {
            Throwable targetException = pae.getCause();
            if (targetException instanceof InvocationTargetException) {
                targetException = ((InvocationTargetException)targetException).getTargetException();
            }
            this.deferred.fail(targetException);
        }
        catch (Exception e) {
            this.deferred.fail(e);
        }
        finally {
            this.methodCall.releaseService();
        }
    }
}

