/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.joda.primitives.list.impl.ArrayBooleanList;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.DateGenerationRule;
import org.jquantlib.time.IMM;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.time.Weekday;
import org.jquantlib.time.calendars.NullCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.DateFactory;

public class Schedule {
    private final boolean fullInterface;
    private final Period tenor;
    private final Calendar calendar;
    private final BusinessDayConvention convention;
    private final BusinessDayConvention terminationDateConvention;
    private final DateGenerationRule rule;
    private final boolean endOfMonth;
    private final Date firstDate;
    private final Date nextToLastDate;
    private final boolean finalIsRegular;
    private final List<Date> dates;
    private final List<Boolean> isRegular;

    private Schedule(Period tenor, Calendar calendar, BusinessDayConvention convention, BusinessDayConvention terminationDateConvention, DateGenerationRule rule, boolean endOfMonth, Date firstDate, Date nextToLastDate, List<Date> dates, boolean finalIsRegular, boolean fullInterface) {
        this.tenor = tenor;
        this.calendar = calendar;
        this.convention = convention;
        this.terminationDateConvention = terminationDateConvention;
        this.rule = rule;
        this.endOfMonth = endOfMonth;
        this.firstDate = firstDate;
        this.nextToLastDate = nextToLastDate;
        this.finalIsRegular = finalIsRegular;
        this.fullInterface = fullInterface;
        this.dates = dates == null ? new ArrayList<Date>() : dates;
        this.isRegular = new ArrayBooleanList();
    }

    public Schedule(List<Date> dates, Calendar calendar, BusinessDayConvention convention) {
        this(new Period(), calendar, convention, convention, DateGenerationRule.FORWARD, false, DateFactory.getFactory().getTodaysDate(), DateFactory.getFactory().getTodaysDate(), dates, true, false);
    }

    public Schedule(Date effectiveDate, Date terminationDate, Period periodTenor, Calendar calendar, BusinessDayConvention businessDayConvention, BusinessDayConvention terminationDateConvention, DateGenerationRule dateGenerationRule, boolean endOfMonth, Date firstDate, Date nextToLastDate) {
        this(periodTenor, calendar, businessDayConvention, terminationDateConvention, dateGenerationRule, endOfMonth, firstDate, nextToLastDate, null, true, true);
        if (effectiveDate == Date.NULL_DATE || effectiveDate == null) {
            throw new IllegalArgumentException("Effective date is null");
        }
        if (terminationDate == Date.NULL_DATE || terminationDate == null) {
            throw new IllegalArgumentException("TerminationDate date is null");
        }
        if (effectiveDate.ge(terminationDate)) {
            throw new IllegalArgumentException("Effective date later than or equal to termination date ");
        }
        DateGenerationRule rule = dateGenerationRule;
        Period tenor = periodTenor;
        BusinessDayConvention convention = businessDayConvention;
        if (tenor.length() == 0) {
            rule = DateGenerationRule.ZERO;
        } else if (tenor.length() < 0) {
            throw new IllegalArgumentException("non positive tenor (" + tenor + ") not allowed");
        }
        if (firstDate != Date.NULL_DATE && firstDate != null) {
            switch (rule) {
                case BACKWARD: 
                case FORWARD: {
                    if (!firstDate.lt(effectiveDate) || !firstDate.ge(terminationDate)) break;
                    throw new IllegalStateException("first date (" + firstDate + ") out of [effective (" + effectiveDate + "), termination (" + terminationDate + ")] date range");
                }
                case THIRD_WEDNESDAY: {
                    if (IMM.getDefaultIMM().isIMMdate(firstDate, false)) break;
                    throw new IllegalStateException("first date (" + firstDate + ") is not an IMM date");
                }
                case ZERO: {
                    throw new IllegalStateException("first date incompatible with " + (Object)((Object)rule) + " date generation rule");
                }
                default: {
                    throw new IllegalStateException("unknown Rule (" + (Object)((Object)rule) + ")");
                }
            }
        }
        if (nextToLastDate != Date.NULL_DATE && nextToLastDate != null) {
            switch (rule) {
                case BACKWARD: 
                case FORWARD: {
                    if (!nextToLastDate.le(effectiveDate) || !nextToLastDate.ge(terminationDate)) break;
                    throw new IllegalStateException("next to last date (" + nextToLastDate + ") out of [effective (" + effectiveDate + "), termination (" + terminationDate + ")] date range");
                }
                case THIRD_WEDNESDAY: {
                    if (!IMM.getDefaultIMM().isIMMdate(nextToLastDate, false)) {
                        throw new IllegalStateException("first date (" + firstDate + ") is not an IMM date");
                    }
                }
                case ZERO: {
                    throw new IllegalStateException("next to last date incompatible with " + (Object)((Object)rule) + " date generation rule");
                }
                default: {
                    throw new IllegalStateException("unknown Rule (" + (Object)((Object)rule) + ")");
                }
            }
        }
        NullCalendar nullCalendar = new NullCalendar();
        int periods = 1;
        switch (rule) {
            case ZERO: {
                tenor = new Period(0, TimeUnit.DAYS);
                this.dates.add(effectiveDate);
                this.dates.add(terminationDate);
                this.isRegular.add(true);
                break;
            }
            case BACKWARD: {
                Date temp;
                this.dates.add(terminationDate);
                Date seed = terminationDate;
                if (nextToLastDate != Date.NULL_DATE && nextToLastDate != null) {
                    this.dates.add(1, nextToLastDate);
                    temp = nullCalendar.advance(seed, new Period(-periods * tenor.length(), tenor.units()), convention, endOfMonth);
                    if (!temp.equals(nextToLastDate)) {
                        this.isRegular.add(0, false);
                    } else {
                        this.isRegular.add(0, true);
                    }
                    seed = nextToLastDate;
                }
                Date exitDate = effectiveDate;
                if (firstDate != Date.NULL_DATE && firstDate != null) {
                    exitDate = firstDate;
                }
                while (!(temp = nullCalendar.advance(seed, new Period(-periods * tenor.length(), tenor.units()), convention, endOfMonth)).lt(exitDate)) {
                    this.dates.add(0, temp);
                    this.isRegular.add(0, true);
                    ++periods;
                }
                if (endOfMonth && calendar.isEndOfMonth(seed)) {
                    convention = BusinessDayConvention.PRECEDING;
                }
                if (calendar.adjust(this.dates.get(0), convention).eq(calendar.adjust(effectiveDate, convention))) break;
                this.dates.add(0, effectiveDate);
                this.isRegular.add(0, false);
                break;
            }
            case THIRD_WEDNESDAY: {
                if (endOfMonth) {
                    throw new IllegalStateException("endOfMonth convention incompatible with " + (Object)((Object)rule) + " date generation rule");
                }
            }
            case FORWARD: {
                Date temp;
                this.dates.add(effectiveDate);
                Date seed = effectiveDate;
                if (firstDate != Date.NULL_DATE && firstDate != null) {
                    this.dates.add(firstDate);
                    temp = nullCalendar.advance(seed, new Period(periods * tenor.length(), tenor.units()), convention, endOfMonth);
                    if (temp != firstDate) {
                        this.isRegular.add(false);
                    } else {
                        this.isRegular.add(true);
                    }
                    seed = firstDate;
                }
                Date exitDate = terminationDate;
                if (nextToLastDate != Date.NULL_DATE && nextToLastDate != null) {
                    exitDate = nextToLastDate;
                }
                while (!(temp = nullCalendar.advance(seed, new Period(periods * tenor.length(), tenor.units()), convention, endOfMonth)).gt(exitDate)) {
                    this.dates.add(temp);
                    this.isRegular.add(true);
                    ++periods;
                }
                if (endOfMonth && calendar.isEndOfMonth(seed)) {
                    convention = BusinessDayConvention.PRECEDING;
                }
                if (calendar.adjust(this.dates.get(this.dates.size() - 1), terminationDateConvention).equals(calendar.adjust(terminationDate, terminationDateConvention))) break;
                this.dates.add(terminationDate);
                this.isRegular.add(false);
                break;
            }
            default: {
                throw new IllegalStateException("unknown DateGeneration::Rule (" + (Object)((Object)rule) + ")");
            }
        }
        if (rule == DateGenerationRule.THIRD_WEDNESDAY) {
            for (int i = 1; i < this.dates.size() - 1; ++i) {
                Date d = this.dates.get(i);
                Date adjDate = d.getNthWeekday(3, Weekday.WEDNESDAY);
                d.getUpdatable().update(adjDate);
            }
        }
        for (int i = 0; i < this.dates.size() - 1; ++i) {
            this.dates.get(i).getUpdatable().update(calendar.adjust(this.dates.get(i), convention));
        }
        if (terminationDateConvention != BusinessDayConvention.UNADJUSTED) {
            this.dates.get(this.dates.size() - 1).getUpdatable().update(calendar.adjust(this.dates.get(this.dates.size() - 1), terminationDateConvention));
        }
    }

    public Iterator<Date> getDatesAfter(Date date) {
        if (this.dates.size() > 0) {
            int i;
            ArrayList<Date> ldates = new ArrayList<Date>();
            int index = -1;
            for (i = 0; i < this.dates.size(); ++i) {
                Date d = this.dates.get(i);
                if (!d.equals(date)) continue;
                index = i;
                break;
            }
            if (index > 0) {
                for (i = index; i < this.dates.size(); ++i) {
                    ldates.add(this.dates.get(i));
                }
                return ldates.iterator();
            }
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public Date getNextDate(Date refDate) {
        if (this.dates.size() > 0) {
            int index = -1;
            for (int i = 0; i < this.dates.size(); ++i) {
                Date d = this.dates.get(i);
                if (!d.equals(refDate)) continue;
                index = i;
                break;
            }
            if (index >= 0 && index != this.dates.size() - 1) {
                return this.dates.get(index + 1);
            }
        }
        return null;
    }

    public Date getPreviousDate(Date refDate) {
        if (this.dates.size() > 0) {
            int index = -1;
            for (int i = 0; i < this.dates.size(); ++i) {
                Date d = this.dates.get(i);
                if (!d.equals(refDate)) continue;
                index = i;
                break;
            }
            if (index > 0) {
                return this.dates.get(index - 1);
            }
        }
        return null;
    }

    public boolean isRegular(int i) {
        if (!this.fullInterface) {
            throw new IllegalStateException("full interface not available");
        }
        if (this.isRegular.size() > 0) {
            if (i > this.isRegular.size() && i < 0) {
                throw new IllegalArgumentException("index (" + i + ") must be in [1, " + this.isRegular.size() + "]");
            }
            return this.isRegular.get(i - 1);
        }
        return false;
    }
}

