/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.vanilla;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.exercise.AmericanExercise;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.math.distributions.CumulativeNormalDistribution;
import org.jquantlib.pricingengines.BlackCalculator;
import org.jquantlib.pricingengines.BlackFormula;
import org.jquantlib.pricingengines.VanillaOptionEngine;
import org.jquantlib.pricingengines.arguments.OneAssetOptionArguments;
import org.jquantlib.pricingengines.results.OneAssetOptionResults;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;

public class BaroneAdesiWhaleyApproximationEngine
extends VanillaOptionEngine {
    @Override
    public void calculate() {
        if (((OneAssetOptionArguments)this.arguments).exercise.type() != Exercise.Type.AMERICAN) {
            throw new ArithmeticException("not an American Option");
        }
        if (!(((OneAssetOptionArguments)this.arguments).exercise instanceof AmericanExercise)) {
            throw new ArithmeticException("non-American exercise given");
        }
        AmericanExercise ex = (AmericanExercise)((OneAssetOptionArguments)this.arguments).exercise;
        if (ex.payoffAtExpiry()) {
            throw new ArithmeticException("payoff at expiry not handled");
        }
        if (!(((OneAssetOptionArguments)this.arguments).payoff instanceof StrikedTypePayoff)) {
            throw new ArithmeticException("non-striked payoff given");
        }
        StrikedTypePayoff payoff = (StrikedTypePayoff)((OneAssetOptionArguments)this.arguments).payoff;
        if (!(((OneAssetOptionArguments)this.arguments).stochasticProcess instanceof GeneralizedBlackScholesProcess)) {
            throw new ArithmeticException("Black-Scholes process required");
        }
        GeneralizedBlackScholesProcess process = (GeneralizedBlackScholesProcess)((OneAssetOptionArguments)this.arguments).stochasticProcess;
        double variance = process.blackVolatility().getLink().blackVariance(ex.lastDate(), payoff.strike());
        double dividendDiscount = process.dividendYield().getLink().discount(ex.lastDate());
        double riskFreeDiscount = process.riskFreeRate().getLink().discount(ex.lastDate());
        double spot = process.stateVariable().getLink().evaluate();
        double forwardPrice = spot * dividendDiscount / riskFreeDiscount;
        BlackCalculator black = new BlackCalculator(payoff, forwardPrice, Math.sqrt(variance), riskFreeDiscount);
        if (dividendDiscount >= 1.0 && payoff.optionType() == Option.Type.CALL) {
            ((OneAssetOptionResults)this.results).value = black.value();
            ((OneAssetOptionResults)this.results).delta = black.delta(spot);
            ((OneAssetOptionResults)this.results).deltaForward = black.deltaForward();
            ((OneAssetOptionResults)this.results).elasticity = black.elasticity(spot);
            ((OneAssetOptionResults)this.results).gamma = black.gamma(spot);
            DayCounter rfdc = process.riskFreeRate().getLink().dayCounter();
            DayCounter divdc = process.dividendYield().getLink().dayCounter();
            DayCounter voldc = process.blackVolatility().getLink().dayCounter();
            double t = rfdc.yearFraction(process.riskFreeRate().getLink().referenceDate(), ((OneAssetOptionArguments)this.arguments).exercise.lastDate());
            ((OneAssetOptionResults)this.results).rho = black.rho(t);
            t = divdc.yearFraction(process.dividendYield().getLink().referenceDate(), ((OneAssetOptionArguments)this.arguments).exercise.lastDate());
            ((OneAssetOptionResults)this.results).dividendRho = black.dividendRho(t);
            t = voldc.yearFraction(process.blackVolatility().getLink().referenceDate(), ((OneAssetOptionArguments)this.arguments).exercise.lastDate());
            ((OneAssetOptionResults)this.results).vega = black.vega(t);
            ((OneAssetOptionResults)this.results).theta = black.theta(spot, t);
            ((OneAssetOptionResults)this.results).thetaPerDay = black.thetaPerDay(spot, t);
            ((OneAssetOptionResults)this.results).strikeSensitivity = black.strikeSensitivity();
            ((OneAssetOptionResults)this.results).itmCashProbability = black.itmCashProbability();
        } else {
            CumulativeNormalDistribution cumNormalDist = new CumulativeNormalDistribution();
            double tolerance = 1.0E-6;
            double Sk = BaroneAdesiWhaleyApproximationEngine.criticalPrice(payoff, riskFreeDiscount, dividendDiscount, variance, tolerance);
            double forwardSk = Sk * dividendDiscount / riskFreeDiscount;
            double d1 = (Math.log(forwardSk / payoff.strike()) + 0.5 * variance) / Math.sqrt(variance);
            double n = 2.0 * Math.log(dividendDiscount / riskFreeDiscount) / variance;
            double K = -2.0 * Math.log(riskFreeDiscount) / (variance * (1.0 - riskFreeDiscount));
            switch (payoff.optionType()) {
                case CALL: {
                    double Q = (-(n - 1.0) + Math.sqrt((n - 1.0) * (n - 1.0) + 4.0 * K)) / 2.0;
                    double a = Sk / Q * (1.0 - dividendDiscount * cumNormalDist.evaluate(d1));
                    if (spot < Sk) {
                        ((OneAssetOptionResults)this.results).value = black.value() + a * Math.pow(spot / Sk, Q);
                        break;
                    }
                    ((OneAssetOptionResults)this.results).value = spot - payoff.strike();
                    break;
                }
                case PUT: {
                    double Q = (-(n - 1.0) - Math.sqrt((n - 1.0) * (n - 1.0) + 4.0 * K)) / 2.0;
                    double a = -(Sk / Q) * (1.0 - dividendDiscount * cumNormalDist.evaluate(-d1));
                    if (spot > Sk) {
                        ((OneAssetOptionResults)this.results).value = black.value() + a * Math.pow(spot / Sk, Q);
                        break;
                    }
                    ((OneAssetOptionResults)this.results).value = payoff.strike() - spot;
                    break;
                }
                default: {
                    throw new ArithmeticException("unknown option type");
                }
            }
        }
    }

    static double criticalPrice(StrikedTypePayoff payoff, double riskFreeDiscount, double dividendDiscount, double variance) {
        return BaroneAdesiWhaleyApproximationEngine.criticalPrice(payoff, riskFreeDiscount, dividendDiscount, variance, 1.0E-6);
    }

    static double criticalPrice(StrikedTypePayoff payoff, double riskFreeDiscount, double dividendDiscount, double variance, double tolerance) {
        double Si;
        double n = 2.0 * Math.log(dividendDiscount / riskFreeDiscount) / variance;
        double m = -2.0 * Math.log(riskFreeDiscount) / variance;
        double bT = Math.log(dividendDiscount / riskFreeDiscount);
        switch (payoff.optionType()) {
            case CALL: {
                double qu = (-(n - 1.0) + Math.sqrt((n - 1.0) * (n - 1.0) + 4.0 * m)) / 2.0;
                double Su = payoff.strike() / (1.0 - 1.0 / qu);
                double h = -(bT + 2.0 * Math.sqrt(variance)) * payoff.strike() / (Su - payoff.strike());
                Si = payoff.strike() + (Su - payoff.strike()) * (1.0 - Math.exp(h));
                break;
            }
            case PUT: {
                double qu = (-(n - 1.0) - Math.sqrt((n - 1.0) * (n - 1.0) + 4.0 * m)) / 2.0;
                double Su = payoff.strike() / (1.0 - 1.0 / qu);
                double h = (bT - 2.0 * Math.sqrt(variance)) * payoff.strike() / (payoff.strike() - Su);
                Si = Su + (payoff.strike() - Su) * Math.exp(h);
                break;
            }
            default: {
                throw new ArithmeticException("unknown option type");
            }
        }
        double forwardSi = Si * dividendDiscount / riskFreeDiscount;
        double d1 = (Math.log(forwardSi / payoff.strike()) + 0.5 * variance) / Math.sqrt(variance);
        CumulativeNormalDistribution cumNormalDist = new CumulativeNormalDistribution();
        double K = riskFreeDiscount != 1.0 ? -2.0 * Math.log(riskFreeDiscount) / (variance * (1.0 - riskFreeDiscount)) : 0.0;
        double temp = BlackFormula.blackFormula(payoff.optionType(), payoff.strike(), forwardSi, Math.sqrt(variance)) * riskFreeDiscount;
        switch (payoff.optionType()) {
            case CALL: {
                double Q = (-(n - 1.0) + Math.sqrt((n - 1.0) * (n - 1.0) + 4.0 * K)) / 2.0;
                double LHS = Si - payoff.strike();
                double RHS = temp + (1.0 - dividendDiscount * cumNormalDist.evaluate(d1)) * Si / Q;
                double bi = dividendDiscount * cumNormalDist.evaluate(d1) * (1.0 - 1.0 / Q) + (1.0 - dividendDiscount * cumNormalDist.derivative(d1) / Math.sqrt(variance)) / Q;
                while (Math.abs(LHS - RHS) / payoff.strike() > tolerance) {
                    Si = (payoff.strike() + RHS - bi * Si) / (1.0 - bi);
                    forwardSi = Si * dividendDiscount / riskFreeDiscount;
                    d1 = (Math.log(forwardSi / payoff.strike()) + 0.5 * variance) / Math.sqrt(variance);
                    LHS = Si - payoff.strike();
                    double temp2 = BlackFormula.blackFormula(payoff.optionType(), payoff.strike(), forwardSi, Math.sqrt(variance)) * riskFreeDiscount;
                    RHS = temp2 + (1.0 - dividendDiscount * cumNormalDist.evaluate(d1)) * Si / Q;
                    bi = dividendDiscount * cumNormalDist.evaluate(d1) * (1.0 - 1.0 / Q) + (1.0 - dividendDiscount * cumNormalDist.derivative(d1) / Math.sqrt(variance)) / Q;
                }
                break;
            }
            case PUT: {
                double Q = (-(n - 1.0) - Math.sqrt((n - 1.0) * (n - 1.0) + 4.0 * K)) / 2.0;
                double LHS = payoff.strike() - Si;
                double RHS = temp - (1.0 - dividendDiscount * cumNormalDist.evaluate(-d1)) * Si / Q;
                double bi = -dividendDiscount * cumNormalDist.evaluate(-d1) * (1.0 - 1.0 / Q) - (1.0 + dividendDiscount * cumNormalDist.derivative(-d1) / Math.sqrt(variance)) / Q;
                while (Math.abs(LHS - RHS) / payoff.strike() > tolerance) {
                    Si = (payoff.strike() - RHS + bi * Si) / (1.0 + bi);
                    forwardSi = Si * dividendDiscount / riskFreeDiscount;
                    d1 = (Math.log(forwardSi / payoff.strike()) + 0.5 * variance) / Math.sqrt(variance);
                    LHS = payoff.strike() - Si;
                    double temp2 = BlackFormula.blackFormula(payoff.optionType(), payoff.strike(), forwardSi, Math.sqrt(variance)) * riskFreeDiscount;
                    RHS = temp2 - (1.0 - dividendDiscount * cumNormalDist.evaluate(-d1)) * Si / Q;
                    bi = -dividendDiscount * cumNormalDist.evaluate(-d1) * (1.0 - 1.0 / Q) - (1.0 + dividendDiscount * cumNormalDist.derivative(-d1) / Math.sqrt(variance)) / Q;
                }
                break;
            }
            default: {
                throw new ArithmeticException("unknown option type");
            }
        }
        return Si;
    }
}

