/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.xml;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.felix.scrplugin.om.metatype.AttributeDefinition;
import org.apache.felix.scrplugin.om.metatype.Designate;
import org.apache.felix.scrplugin.om.metatype.MTObject;
import org.apache.felix.scrplugin.om.metatype.MetaData;
import org.apache.felix.scrplugin.om.metatype.OCD;
import org.apache.felix.scrplugin.xml.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class MetaTypeIO {
    public static final String NAMESPACE_URI = "http://www.osgi.org/xmlns/metatype/v1.0.0";
    public static final String INNER_NAMESPACE_URI = "";
    public static final String PREFIX = "metatype";
    protected static final String METADATA_ELEMENT = "MetaData";
    protected static final String METADATA_ELEMENT_QNAME = "metatype:MetaData";
    protected static final String OCD_ELEMENT = "OCD";
    protected static final String OCD_ELEMENT_QNAME = "OCD";
    protected static final String DESIGNATE_ELEMENT = "Designate";
    protected static final String DESIGNATE_ELEMENT_QNAME = "Designate";
    protected static final String OBJECT_ELEMENT = "Object";
    protected static final String OBJECT_ELEMENT_QNAME = "Object";
    protected static final String AD_ELEMENT = "AD";
    protected static final String AD_ELEMENT_QNAME = "AD";
    protected static final String OPTION_ELEMENT = "Option";
    protected static final String OPTION_ELEMENT_QNAME = "Option";

    public static void write(MetaData metaData, File file) throws MojoExecutionException {
        try {
            MetaTypeIO.generateXML(metaData, IOUtils.getSerializer(file));
        }
        catch (TransformerException e) {
            throw new MojoExecutionException("Unable to write xml to " + file, (Exception)e);
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Unable to generate xml for " + file, (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write xml to " + file, (Exception)e);
        }
    }

    protected static void generateXML(MetaData metaData, ContentHandler contentHandler) throws SAXException {
        contentHandler.startDocument();
        contentHandler.startPrefixMapping(PREFIX, NAMESPACE_URI);
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, "localization", metaData.getLocalization());
        contentHandler.startElement(NAMESPACE_URI, METADATA_ELEMENT, METADATA_ELEMENT_QNAME, ai);
        IOUtils.newline(contentHandler);
        Iterator i = metaData.getDescriptors().iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof OCD) {
                MetaTypeIO.generateXML((OCD)obj, contentHandler);
                continue;
            }
            MetaTypeIO.generateXML((Designate)obj, contentHandler);
        }
        contentHandler.endElement(NAMESPACE_URI, METADATA_ELEMENT, METADATA_ELEMENT_QNAME);
        IOUtils.newline(contentHandler);
        contentHandler.endPrefixMapping(PREFIX);
        contentHandler.endDocument();
    }

    protected static void generateXML(OCD ocd, ContentHandler contentHandler) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, "id", ocd.getId());
        IOUtils.addAttribute(ai, "name", ocd.getName());
        IOUtils.addAttribute(ai, "description", ocd.getDescription());
        IOUtils.indent(contentHandler, 1);
        contentHandler.startElement(INNER_NAMESPACE_URI, "OCD", "OCD", ai);
        if (ocd.getProperties().size() > 0) {
            IOUtils.newline(contentHandler);
            Iterator i = ocd.getProperties().iterator();
            while (i.hasNext()) {
                AttributeDefinition ad = (AttributeDefinition)i.next();
                MetaTypeIO.generateXML(ad, contentHandler);
            }
            IOUtils.indent(contentHandler, 1);
        }
        contentHandler.endElement(INNER_NAMESPACE_URI, "OCD", "OCD");
        IOUtils.newline(contentHandler);
    }

    protected static void generateXML(AttributeDefinition ad, ContentHandler contentHandler) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, "id", ad.getId());
        IOUtils.addAttribute(ai, "type", ad.getType());
        if (ad.getDefaultMultiValue() != null) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < ad.getDefaultMultiValue().length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(ad.getDefaultMultiValue()[i]);
            }
            IOUtils.addAttribute(ai, "default", buf);
        } else {
            IOUtils.addAttribute(ai, "default", ad.getDefaultValue());
        }
        IOUtils.addAttribute(ai, "name", ad.getName());
        IOUtils.addAttribute(ai, "description", ad.getDescription());
        IOUtils.addAttribute(ai, "cardinality", ad.getCardinality());
        IOUtils.indent(contentHandler, 2);
        contentHandler.startElement(INNER_NAMESPACE_URI, "AD", "AD", ai);
        if (ad.getOptions() != null && ad.getOptions().size() > 0) {
            IOUtils.newline(contentHandler);
            Iterator oi = ad.getOptions().entrySet().iterator();
            while (oi.hasNext()) {
                Map.Entry entry = oi.next();
                ai.clear();
                IOUtils.addAttribute(ai, "value", String.valueOf(entry.getKey()));
                IOUtils.addAttribute(ai, "label", String.valueOf(entry.getValue()));
                IOUtils.indent(contentHandler, 3);
                contentHandler.startElement(INNER_NAMESPACE_URI, "Option", "Option", ai);
                contentHandler.endElement(INNER_NAMESPACE_URI, "Option", "Option");
                IOUtils.newline(contentHandler);
            }
            IOUtils.indent(contentHandler, 2);
        }
        contentHandler.endElement(INNER_NAMESPACE_URI, "AD", "AD");
        IOUtils.newline(contentHandler);
    }

    protected static void generateXML(Designate designate, ContentHandler contentHandler) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, "pid", designate.getPid());
        IOUtils.indent(contentHandler, 1);
        contentHandler.startElement(INNER_NAMESPACE_URI, "Designate", "Designate", ai);
        IOUtils.newline(contentHandler);
        MetaTypeIO.generateXML(designate.getObject(), contentHandler);
        IOUtils.indent(contentHandler, 1);
        contentHandler.endElement(INNER_NAMESPACE_URI, "Designate", "Designate");
        IOUtils.newline(contentHandler);
    }

    protected static void generateXML(MTObject obj, ContentHandler contentHandler) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, "ocdref", obj.getOcdref());
        IOUtils.indent(contentHandler, 2);
        contentHandler.startElement(INNER_NAMESPACE_URI, "Object", "Object", ai);
        contentHandler.endElement(INNER_NAMESPACE_URI, "Object", "Object");
        IOUtils.newline(contentHandler);
    }
}

