/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.ds.parser;

import java.util.List;
import org.eclipse.equinox.ds.Log;
import org.eclipse.equinox.ds.model.ComponentDescription;
import org.eclipse.equinox.ds.parser.ComponentElement;
import org.osgi.framework.BundleContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class ParserHandler
extends DefaultHandler {
    private static final boolean DEBUG = false;
    private DefaultHandler handler;
    private List components;
    protected BundleContext bundleContext;
    private int depth;
    private boolean error;

    ParserHandler(BundleContext bundleContext, List components) {
        this.bundleContext = bundleContext;
        this.components = components;
    }

    public void setHandler(DefaultHandler handler) {
        this.handler = handler;
    }

    public void addComponentDescription(ComponentDescription component) {
        this.components.add(component);
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public boolean isError() {
        return this.error;
    }

    public void logError(String msg) {
        this.error = true;
        Log.log(1, "[SCR] Parser Error. ", new SAXException(msg));
    }

    public void startDocument() throws SAXException {
        this.handler = this;
        this.depth = 0;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        ++this.depth;
        if (this.handler != this) {
            this.handler.startElement(uri, localName, qName, attributes);
            return;
        }
        if (localName.equals("component") && (this.depth == 1 && uri.length() == 0 || uri.equals("http://www.osgi.org/xmlns/scr/v1.0.0"))) {
            this.setHandler(new ComponentElement(this, attributes));
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.handler != this) {
            this.handler.characters(ch, start, length);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.handler != this) {
            this.handler.endElement(uri, localName, qName);
        }
        --this.depth;
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void warning(SAXParseException e) throws SAXException {
    }

    public void error(SAXParseException e) throws SAXException {
    }

    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }
}

