/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.command;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Reason;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resolver;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.gogo.command.Util;
import org.apache.felix.service.command.Descriptor;
import org.apache.felix.service.command.Parameter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.util.tracker.ServiceTracker;

public class OBR {
    private static final String REPO_ADD = "add";
    private static final String REPO_REMOVE = "remove";
    private static final String REPO_LIST = "list";
    private static final String REPO_REFRESH = "refresh";
    private static final char VERSION_SEPARATOR = '@';
    private final BundleContext m_bc;
    private final ServiceTracker m_tracker;

    public OBR(BundleContext bc, ServiceTracker tracker) {
        this.m_bc = bc;
        this.m_tracker = tracker;
    }

    private RepositoryAdmin getRepositoryAdmin() {
        Object svcObj;
        try {
            svcObj = this.m_tracker.getService();
        }
        catch (Exception ex) {
            svcObj = null;
        }
        if (svcObj == null) {
            System.out.println("No repository admin service available");
        }
        return (RepositoryAdmin)svcObj;
    }

    @Descriptor(value="manage repositories")
    public void repos(@Descriptor(value="( add | list | refresh | remove )") String action, @Descriptor(value="space-delimited list of repository URLs") String[] args) throws IOException {
        RepositoryAdmin svcObj = this.getRepositoryAdmin();
        if (svcObj == null) {
            return;
        }
        RepositoryAdmin ra = svcObj;
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                try {
                    if (action.equals(REPO_ADD)) {
                        ra.addRepository(args[i]);
                        continue;
                    }
                    if (action.equals(REPO_REFRESH)) {
                        ra.removeRepository(args[i]);
                        ra.addRepository(args[i]);
                        continue;
                    }
                    if (action.equals(REPO_REMOVE)) {
                        ra.removeRepository(args[i]);
                        continue;
                    }
                    System.out.println("Unknown repository operation: " + action);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        } else {
            Repository[] repos = ra.listRepositories();
            if (repos != null && repos.length > 0) {
                for (int i = 0; i < repos.length; ++i) {
                    System.out.println(repos[i].getURI());
                }
            } else {
                System.out.println("No repository URLs are set.");
            }
        }
    }

    @Descriptor(value="list repository resources")
    public void list(@Descriptor(value="display all versions") @Parameter(names={"-v", "--verbose"}, presentValue="true", absentValue="false") boolean verbose, @Descriptor(value="optional strings used for name matching") String[] args) throws IOException, InvalidSyntaxException {
        RepositoryAdmin svcObj = this.getRepositoryAdmin();
        if (svcObj == null) {
            return;
        }
        RepositoryAdmin ra = svcObj;
        StringBuffer sb = new StringBuffer();
        if (args == null || args.length == 0) {
            sb.append("(|(presentationname=*)(symbolicname=*))");
        } else {
            StringBuffer value = new StringBuffer();
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    value.append(" ");
                }
                value.append(args[i]);
            }
            sb.append("(|(presentationname=*");
            sb.append(value);
            sb.append("*)(symbolicname=*");
            sb.append(value);
            sb.append("*))");
        }
        Resource[] resources = ra.discoverResources(sb.toString());
        TreeMap<Resource, Resource[]> revisionMap = new TreeMap<Resource, Resource[]>(new Comparator(){

            public int compare(Object o1, Object o2) {
                int compare;
                Resource r1 = (Resource)o1;
                Resource r2 = (Resource)o2;
                int symCompare = r1.getSymbolicName().compareTo(r2.getSymbolicName());
                if (symCompare == 0) {
                    return 0;
                }
                int n = r1.getPresentationName() == null ? -1 : (compare = r2.getPresentationName() == null ? 1 : r1.getPresentationName().compareToIgnoreCase(r2.getPresentationName()));
                if (compare == 0) {
                    return symCompare;
                }
                return compare;
            }
        });
        for (int resIdx = 0; resources != null && resIdx < resources.length; ++resIdx) {
            Resource[] revisions = (Resource[])revisionMap.get(resources[resIdx]);
            revisionMap.put(resources[resIdx], OBR.addResourceByVersion(revisions, resources[resIdx]));
        }
        for (Map.Entry entry : revisionMap.entrySet()) {
            Resource[] revisions = (Resource[])entry.getValue();
            String name = revisions[0].getPresentationName();
            name = name == null ? revisions[0].getSymbolicName() : name;
            System.out.print(name);
            if (verbose && revisions[0].getPresentationName() != null) {
                System.out.print(" [" + revisions[0].getSymbolicName() + "]");
            }
            System.out.print(" (");
            int revIdx = 0;
            do {
                if (revIdx > 0) {
                    System.out.print(", ");
                }
                System.out.print(revisions[revIdx].getVersion());
            } while (verbose && ++revIdx < revisions.length);
            if (!verbose && revisions.length > 1) {
                System.out.print(", ...");
            }
            System.out.println(")");
        }
        if (resources == null || resources.length == 0) {
            System.out.println("No matching bundles.");
        }
    }

    @Descriptor(value="retrieve resource description from repository")
    public void info(@Descriptor(value="( <bundle-name> | <symbolic-name> | <bundle-id> )[@<version>] ...") String[] args) throws IOException, InvalidSyntaxException {
        RepositoryAdmin svcObj = this.getRepositoryAdmin();
        if (svcObj == null) {
            return;
        }
        RepositoryAdmin ra = svcObj;
        for (int argIdx = 0; args != null && argIdx < args.length; ++argIdx) {
            Resource[] resources;
            String targetName = args[argIdx];
            String targetVersion = null;
            int idx = args[argIdx].indexOf(64);
            if (idx > 0) {
                targetName = args[argIdx].substring(0, idx);
                targetVersion = args[argIdx].substring(idx + 1);
            }
            if ((resources = this.searchRepository(ra, targetName, targetVersion)) == null || resources.length == 0) {
                System.err.println("Unknown bundle and/or version: " + args[argIdx]);
                continue;
            }
            for (int resIdx = 0; resIdx < resources.length; ++resIdx) {
                if (resIdx > 0) {
                    System.out.println("");
                }
                this.printResource(System.out, resources[resIdx]);
            }
        }
    }

    @Descriptor(value="deploy resource from repository")
    public void deploy(@Descriptor(value="start deployed bundles") @Parameter(names={"-s", "--start"}, presentValue="true", absentValue="false") boolean start, @Descriptor(value="deploy required bundles only") @Parameter(names={"-ro", "--required-only"}, presentValue="true", absentValue="false") boolean requiredOnly, @Descriptor(value="( <bundle-name> | <symbolic-name> | <bundle-id> )[@<version>] ...") String[] args) throws IOException, InvalidSyntaxException {
        RepositoryAdmin svcObj = this.getRepositoryAdmin();
        if (svcObj == null) {
            return;
        }
        RepositoryAdmin ra = svcObj;
        Resolver resolver = ra.resolver();
        for (int argIdx = 0; args != null && argIdx < args.length; ++argIdx) {
            Resource resource;
            String targetName = args[argIdx];
            String targetVersion = null;
            int idx = args[argIdx].indexOf(64);
            if (idx > 0) {
                targetName = args[argIdx].substring(0, idx);
                targetVersion = args[argIdx].substring(idx + 1);
            }
            if ((resource = this.selectNewestVersion(this.searchRepository(ra, targetName, targetVersion))) != null) {
                resolver.add(resource);
                continue;
            }
            System.err.println("Unknown bundle - " + args[argIdx]);
        }
        if (resolver.getAddedResources() != null && resolver.getAddedResources().length > 0) {
            if (resolver.resolve()) {
                int resIdx;
                System.out.println("Target resource(s):");
                System.out.println(Util.getUnderlineString(19));
                Resource[] resources = resolver.getAddedResources();
                for (resIdx = 0; resources != null && resIdx < resources.length; ++resIdx) {
                    System.out.println("   " + resources[resIdx].getPresentationName() + " (" + resources[resIdx].getVersion() + ")");
                }
                resources = resolver.getRequiredResources();
                if (resources != null && resources.length > 0) {
                    System.out.println("\nRequired resource(s):");
                    System.out.println(Util.getUnderlineString(21));
                    for (resIdx = 0; resIdx < resources.length; ++resIdx) {
                        System.out.println("   " + resources[resIdx].getPresentationName() + " (" + resources[resIdx].getVersion() + ")");
                    }
                }
                if (!requiredOnly && (resources = resolver.getOptionalResources()) != null && resources.length > 0) {
                    System.out.println("\nOptional resource(s):");
                    System.out.println(Util.getUnderlineString(21));
                    for (resIdx = 0; resIdx < resources.length; ++resIdx) {
                        System.out.println("   " + resources[resIdx].getPresentationName() + " (" + resources[resIdx].getVersion() + ")");
                    }
                }
                try {
                    System.out.print("\nDeploying...\n");
                    int options = 0;
                    if (start) {
                        options |= 0x10;
                    }
                    if (requiredOnly) {
                        options |= 1;
                    }
                    resolver.deploy(options);
                    System.out.println("done.");
                }
                catch (IllegalStateException ex) {
                    System.err.println(ex);
                }
            } else {
                Reason[] reqs = resolver.getUnsatisfiedRequirements();
                if (reqs != null && reqs.length > 0) {
                    System.out.println("Unsatisfied requirement(s):");
                    System.out.println(Util.getUnderlineString(27));
                    for (int reqIdx = 0; reqIdx < reqs.length; ++reqIdx) {
                        System.out.println("   " + reqs[reqIdx].getRequirement().getFilter());
                        System.out.println("      " + reqs[reqIdx].getResource().getPresentationName());
                    }
                } else {
                    System.out.println("Could not resolve targets.");
                }
            }
        }
    }

    @Descriptor(value="retrieve resource source code from repository")
    public void source(@Descriptor(value="extract source code") @Parameter(names={"-x", "--extract"}, presentValue="true", absentValue="false") boolean extract, @Descriptor(value="local target directory") File localDir, @Descriptor(value="( <bundle-name> | <symbolic-name> | <bundle-id> )[@<version>] ...") String[] args) throws IOException, InvalidSyntaxException {
        RepositoryAdmin svcObj = this.getRepositoryAdmin();
        if (svcObj == null) {
            return;
        }
        RepositoryAdmin ra = svcObj;
        for (int argIdx = 0; argIdx < args.length; ++argIdx) {
            Resource resource;
            String targetName = args[argIdx];
            String targetVersion = null;
            int idx = args[argIdx].indexOf(64);
            if (idx > 0) {
                targetName = args[argIdx].substring(0, idx);
                targetVersion = args[argIdx].substring(idx + 1);
            }
            if ((resource = this.selectNewestVersion(this.searchRepository(ra, targetName, targetVersion))) == null) {
                System.err.println("Unknown bundle and/or version: " + args[argIdx]);
                continue;
            }
            String srcURI = (String)resource.getProperties().get("source");
            if (srcURI != null) {
                Util.downloadSource(System.out, System.err, new URL(srcURI), localDir, extract);
                continue;
            }
            System.err.println("Missing source URL: " + args[argIdx]);
        }
    }

    @Descriptor(value="retrieve resource JavaDoc from repository")
    public void javadoc(@Descriptor(value="extract documentation") @Parameter(names={"-x", "--extract"}, presentValue="true", absentValue="false") boolean extract, @Descriptor(value="local target directory") File localDir, @Descriptor(value="( <bundle-name> | <symbolic-name> | <bundle-id> )[@<version>] ...") String[] args) throws IOException, InvalidSyntaxException {
        RepositoryAdmin svcObj = this.getRepositoryAdmin();
        if (svcObj == null) {
            return;
        }
        RepositoryAdmin ra = svcObj;
        for (int argIdx = 0; argIdx < args.length; ++argIdx) {
            Resource resource;
            String targetName = args[argIdx];
            String targetVersion = null;
            int idx = args[argIdx].indexOf(64);
            if (idx > 0) {
                targetName = args[argIdx].substring(0, idx);
                targetVersion = args[argIdx].substring(idx + 1);
            }
            if ((resource = this.selectNewestVersion(this.searchRepository(ra, targetName, targetVersion))) == null) {
                System.err.println("Unknown bundle and/or version: " + args[argIdx]);
                continue;
            }
            URL docURL = (URL)resource.getProperties().get("javadoc");
            if (docURL != null) {
                Util.downloadSource(System.out, System.err, docURL, localDir, extract);
                continue;
            }
            System.err.println("Missing javadoc URL: " + args[argIdx]);
        }
    }

    private Resource[] searchRepository(RepositoryAdmin ra, String targetId, String targetVersion) throws InvalidSyntaxException {
        try {
            Bundle bundle = this.m_bc.getBundle(Long.parseLong(targetId));
            if (bundle == null) {
                return null;
            }
            targetId = bundle.getSymbolicName();
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        StringBuffer sb = new StringBuffer("(|(presentationname=");
        sb.append(targetId);
        sb.append(")(symbolicname=");
        sb.append(targetId);
        sb.append("))");
        if (targetVersion != null) {
            sb.insert(0, "(&");
            sb.append("(version=");
            sb.append(targetVersion);
            sb.append("))");
        }
        return ra.discoverResources(sb.toString());
    }

    private Resource selectNewestVersion(Resource[] resources) {
        int idx = -1;
        Version v = null;
        for (int i = 0; resources != null && i < resources.length; ++i) {
            if (i == 0) {
                idx = 0;
                v = resources[i].getVersion();
                continue;
            }
            Version vtmp = resources[i].getVersion();
            if (vtmp.compareTo(v) <= 0) continue;
            idx = i;
            v = vtmp;
        }
        return idx < 0 ? null : resources[idx];
    }

    private void printResource(PrintStream out, Resource resource) {
        Capability[] caps;
        System.out.println(Util.getUnderlineString(resource.getPresentationName().length()));
        out.println(resource.getPresentationName());
        System.out.println(Util.getUnderlineString(resource.getPresentationName().length()));
        Map map = resource.getProperties();
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue().getClass().isArray()) {
                out.println(entry.getKey() + ":");
                for (int j = 0; j < Array.getLength(entry.getValue()); ++j) {
                    out.println("   " + Array.get(entry.getValue(), j));
                }
                continue;
            }
            out.println(entry.getKey() + ": " + entry.getValue());
        }
        Requirement[] reqs = resource.getRequirements();
        if (reqs != null && reqs.length > 0) {
            out.println("Requires:");
            for (int i = 0; i < reqs.length; ++i) {
                out.println("   " + reqs[i].getFilter());
            }
        }
        if ((caps = resource.getCapabilities()) != null && caps.length > 0) {
            out.println("Capabilities:");
            for (int i = 0; i < caps.length; ++i) {
                out.println("   " + caps[i].getPropertiesAsMap());
            }
        }
    }

    private static Resource[] addResourceByVersion(Resource[] revisions, Resource resource) {
        Resource[] sorted = null;
        if (revisions == null) {
            sorted = new Resource[]{resource};
        } else {
            Version version = resource.getVersion();
            Version middleVersion = null;
            int top = 0;
            int bottom = revisions.length - 1;
            int middle = 0;
            while (top <= bottom) {
                middle = (bottom - top) / 2 + top;
                middleVersion = revisions[middle].getVersion();
                int cmp = middleVersion.compareTo(version);
                if (cmp < 0) {
                    bottom = middle - 1;
                    continue;
                }
                top = middle + 1;
            }
            if (top >= revisions.length || revisions[top] != resource) {
                sorted = new Resource[revisions.length + 1];
                System.arraycopy(revisions, 0, sorted, 0, top);
                System.arraycopy(revisions, top, sorted, top + 1, revisions.length - top);
                sorted[top] = resource;
            }
        }
        return sorted;
    }
}

