/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class Singapore
extends DelegateCalendar {
    private static final Singapore SGX_CALENDAR = new Singapore(Market.SGX);

    private Singapore(Market market) {
        SingaporeSettlementCalendar delegate;
        switch (market) {
            case SGX: {
                delegate = new SingaporeSettlementCalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static Singapore getCalendar(Market market) {
        switch (market) {
            case SGX: {
                return SGX_CALENDAR;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class SingaporeSettlementCalendar
    extends WesternCalendar {
        private SingaporeSettlementCalendar() {
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.JANUARY || dd == em - 3 || d == 1 && m == Month.MAY || d == 9 && m == Month.AUGUST || d == 25 && m == Month.DECEMBER || y == 2004 && ((d == 22 || d == 23) && m == Month.JANUARY || (d == 1 || d == 2) && m == Month.FEBRUARY || d == 2 && m == Month.JUNE || d == 11 && m == Month.NOVEMBER || (d == 14 || d == 15) && m == Month.NOVEMBER) || y == 2005 && ((d == 9 || d == 10) && m == Month.FEBRUARY || d == 21 && m == Month.JANUARY || d == 22 && m == Month.MAY || d == 1 && m == Month.NOVEMBER || d == 3 && m == Month.NOVEMBER) || y == 2006 && ((d == 30 || d == 31) && m == Month.JANUARY || d == 10 && m == Month.JANUARY || d == 12 && m == Month.MAY || d == 24 && m == Month.OCTOBER) || y == 2007 && ((d == 19 || d == 20) && m == Month.FEBRUARY || d == 2 && m == Month.JANUARY || d == 20 && m == Month.DECEMBER || d == 31 && m == Month.MAY || d == 8 && m == Month.NOVEMBER || d == 13 && m == Month.OCTOBER) || y == 2008 && ((d == 7 || d == 8) && m == Month.FEBRUARY || d == 8 && m == Month.DECEMBER || d == 19 && m == Month.MAY || d == 27 && m == Month.OCTOBER || d == 1 && m == Month.OCTOBER)) && (y != 2009 || !((d == 26 || d == 27) && m == Month.JANUARY || d == 27 && m == Month.NOVEMBER || d == 9 && m == Month.MAY || d == 15 && m == Month.NOVEMBER) && (d != 20 || m != Month.SEPTEMBER));
        }

        @Override
        public String getName() {
            return "Singapore exchange";
        }
    }

    public static enum Market {
        SGX;

    }
}

